/**
* @file mmdemo.h
* @brief Multimedia demo - main program header
* @date Feb 16, 2007
*
* DIALOGIC CONFIDENTIAL 
* Copyright  2007 Dialogic Corporation. All Rights Reserved.
* 
* The source code contained or described herein and all documents related to 
* the source code ("Material") are owned by Dialogic Corporation or its suppliers
* or licensors. Title to the Material remains with Dialogic Corporation or its 
* suppliers and licensors. The Material contains trade secrets and proprietary
* and confidential information of Dialogic or its suppliers and licensors. The
* Material is protected by worldwide copyright and trade secret laws and treaty
* provisions. No part of the Material may be used, copied, reproduced, 
* modified, published, uploaded, posted, transmitted, distributed, or disclosed
* in any way without Dialogic's prior express written permission.
* 
* No license under any patent, copyright, trade secret or other intellectual 
* property right is granted to or conferred upon you by disclosure or delivery
* of the Materials, either expressly, by implication, inducement, estoppel or
* otherwise. Any license under such intellectual property rights must be
* express and approved by Dialogic in writing.
*/

#ifndef _mmdemo_h
#define _mmdemo_h


// Standard Include Files
#include <stdio.h>
#include <errno.h>



// Application Level Include Files
#include "ipchannel.h"
#include "connection.h"

// Global variables
bool          g_bDone                 = false;
int           g_nConnectionsDesired   = 1;
static int    g_nConnections          = 1;
int           g_nCallType             = 0;
int           g_nTimeToRecord         = 0;
long          g_lTotalCallsCompleted  = 0;    // total number of calls Completed.
FILE          *g_logfile;
char          g_cDestIp[20];
char          g_cProxyIp[20];
char          g_cPhoneNumber[31];
int           g_nSipUdpPort;

#ifdef WIN32
unsigned long g_localIPinByteOrder;
#else
in_addr_t     g_localIPinByteOrder;
#endif

bool          g_bLowResVideo          = false; // QCIF 64kbps 10fps
int           g_nReadyChannels        = 0;

typedef map<long, CIPChannel *> IP_CALL_MAP;    //  IP Call variables
IP_CALL_MAP g_ipCallMap;

//  Connection Map that holds all Connections.
//  The Key into this map is a hashed integer that represents the
//  PSTN Phone Number of the PSTN devices - its own number.
typedef map<unsigned long, CConnection *> CONNECTION_MAP;
CONNECTION_MAP g_connectionMap;

CConnection *g_ConnectionTable[MAX_SPANS][CHANS_PER_SPAN];
CLocker g_appLock;

#ifdef WIN32
struct _timeb g_StartTime;                // app. start time
#else
struct timeb  g_StartTime;                // app. start time
#endif

#ifdef TDM_AUDIO
char          g_cISDNGatewayIP[256];
int           g_nISDNGatewayPort;
#endif

#ifdef WIN32

typedef unsigned (__stdcall *PTHREAD_START) (void *);
static DWORD WINAPI RunDemo(PVOID pData);

#else

typedef void *(*PTHREAD_START) (void *);
static void *RunDemo(void *pData);
#endif

void ProcessNonGCEvent(METAEVENT &metaevt);

#ifdef WIN32
int GetHostInfo(char *a_cIpAddrInDotNotation, unsigned long *a_IpAddrInByteOrder);
#else
int GetHostInfo(char *a_cIpAddrInDotNotation, in_addr_t *a_IpAddrInByteOrder);
#endif

bool InitGC();
bool Initialize(int nStartIpmChan, int nMaxChans);
bool Shutdown();
void PrintHelp();
void InitLogfiles();
void OnRegister(void *pData);
#endif
