/**********@@@SOFT@@@WARE@@@COPY@@@RIGHT@@@**********************************
* DIALOGIC CONFIDENTIAL
*
* Copyright (C) 2007 Dialogic Corporation. All Rights Reserved.
* The source code contained or described herein and all documents related
* to the source code ("Material") are owned by Dialogic Corporation or its
* suppliers or licensors. Title to the Material remains with Dialogic Corporation
* or its suppliers and licensors. The Material contains trade secrets and
* proprietary and confidential information of Dialogic or its suppliers and
* licensors. The Material is protected by worldwide copyright and trade secret
* laws and treaty provisions. No part of the Material may be used, copied,
* reproduced, modified, published, uploaded, posted, transmitted, distributed,
* or disclosed in any way without Dialogic's prior express written permission.
*
* No license under any patent, copyright, trade secret or other intellectual
* property right is granted to or conferred upon you by disclosure or delivery
* of the Materials, either expressly, by implication, inducement, estoppel or
* otherwise. Any license under such intellectual property rights must be
* express and approved by Dialogic in writing.
*
***********************************@@@SOFT@@@WARE@@@COPY@@@RIGHT@@@**********/


#include "NetworkConnection.h"


NetworkConnection::NetworkConnection()
{
	Print(LOG_DEBUG,"+ NetworkConnection::NetworkConnection");
	m_pSipDevice = new SipDevice();
	m_pMediaDevice = new MediaDevice();
	m_bMediaDeviceOpen = false;
	m_bMediaStarted = false;
	m_bMediaListening = false;
	m_bSipDeviceOpen = false;
	strcpy(m_ObjectId,"");
	Print(LOG_DEBUG,"- NetworkConnection::NetworkConnection");
}

NetworkConnection::~NetworkConnection()
{
	Print(LOG_DEBUG,"+ NetworkConnection::~NetworkConnection");
	delete m_pSipDevice;
	delete m_pMediaDevice;
	Print(LOG_DEBUG,"- NetworkConnection::~NetworkConnection");
}

int NetworkConnection::Open(const char* a_SipDevName, const char* a_MediaDevName)
{
	Print(LOG_DEBUG,"+ NetworkConnection::Open");
	int rc = 0;
	rc = m_pSipDevice->Open(a_SipDevName);
	if (rc != 0)
	{
		Print (LOG_ERROR,"NetworkConnection::Open - SipDevice Open Failed\n");
	}
	else
	{
		rc = m_pMediaDevice->Open(a_MediaDevName);
		if (rc != 0)
		{
			Print (LOG_ERROR,"NetworkConnection::Open - MediaDevice Open Failed\n");
		}
	}
	Print(LOG_DEBUG,"- NetworkConnection::Open");
	return rc;
}

int NetworkConnection::Close()
{
	Print(LOG_DEBUG,"+ NetworkConnection::Close");
	int rc = 0;
	rc = m_pSipDevice->Close();
	if (rc != 0)
	{
		Print (LOG_ERROR,"NetworkConnection::Close - SipDevice Close Failed\n");
	}
	
	if (m_bMediaListening)
	{
		m_pMediaDevice->UnListen();
	}
	if (m_bMediaStarted)
	{
		m_pMediaDevice->StopMedia();
	}
	
	rc = m_pMediaDevice->Close();
	if (rc != 0)
	{
		Print (LOG_ERROR,"NetworkConnection::Close - MediaDevice Close Failed\n");
	}
	Print(LOG_DEBUG,"- NetworkConnection::Close");
	return rc;
}

int NetworkConnection::StartMedia(sdpSessionDescription* a_pSDP)
{
	Print(LOG_DEBUG,"+ NetworkConnection::StartMedia");
	int rc = 0;
	rc = m_pMediaDevice->StartMedia(a_pSDP);
	Print(LOG_DEBUG,"- NetworkConnection::StartMedia");
	return rc;
}

int NetworkConnection::StopMedia()
{
	Print(LOG_DEBUG,"+ NetworkConnection::StopMedia");
	int rc = 0;
	rc = m_pMediaDevice->StopMedia();
	Print(LOG_DEBUG,"- NetworkConnection::StopMedia");
	return rc;
}

int NetworkConnection::GetXmitSlot(SC_TSINFO* a_pTSINFO)
{
	Print(LOG_DEBUG,"+ NetworkConnection::GetXmitSlot");
	int rc = 0;
	rc = m_pMediaDevice->GetXmitSlot(a_pTSINFO);
	Print(LOG_DEBUG,"- NetworkConnection::GetXmitSlot");
	return rc;
}

int NetworkConnection::Listen(SC_TSINFO* a_pTSINFO)
{
	Print(LOG_DEBUG,"+ NetworkConnection::Listen");
	int rc = 0;
	rc = m_pMediaDevice->Listen(a_pTSINFO);
	Print(LOG_DEBUG,"- NetworkConnection::Listen");
	return rc;
}

int NetworkConnection::UnListen()
{
	Print(LOG_DEBUG,"+ NetworkConnection::UnListen");
	int rc = 0;
	rc = m_pMediaDevice->UnListen();
	Print(LOG_DEBUG,"- NetworkConnection::UnListen");
	return rc;
}

bool NetworkConnection::IsOpen()
{
	Print(LOG_DEBUG,"+ NetworkConnection::IsOpen");
	bool rc = false;
	if ( (m_bSipDeviceOpen == true) && (m_bMediaDeviceOpen == true) )
	{
		rc = true;
	}
	Print(LOG_DEBUG,"- NetworkConnection::IsOpen");
	return rc;
}

Device* NetworkConnection::GetSipDevice()
{
	Print(LOG_DEBUG,"+ NetworkConnection::GetSipDevice");
	Print(LOG_DEBUG,"- NetworkConnection::GetSipDevice");
	return m_pSipDevice;
}

Device* NetworkConnection::GetMediaDevice()
{
	Print(LOG_DEBUG,"+ NetworkConnection::GetMediaDevice");
	Print(LOG_DEBUG,"- NetworkConnection::GetMediaDevice");
	return m_pMediaDevice;
}

void NetworkConnection::SetObjectId(char* a_ObjectId)
{
	Print(LOG_DEBUG,"+ NetworkConnection::SetObjectId");
	char* pObjectId = NULL;
	pObjectId = strstr(a_ObjectId,";tag=");
	if ( (pObjectId != NULL) && (strlen(pObjectId)>5) )
	{
		pObjectId = pObjectId + ( sizeof(char) * 5 );
		Print(LOG_INFO,"\t\tStoring network connection ObjectId");
		Print(LOG_INFO,"\t\tObjectId = %s",pObjectId);
		strcpy(m_ObjectId,pObjectId);
	}
	Print(LOG_DEBUG,"- NetworkConnection::SetObjectId");
}

char* NetworkConnection::GetObjectId()
{
	Print(LOG_DEBUG,"+ NetworkConnection::GetObjectId");
	Print(LOG_DEBUG,"- NetworkConnection::GetObjectId");
	return m_ObjectId;
}












void NetworkConnection::OnMediaOpen()
{
	Print(LOG_DEBUG,"+ NetworkConnection::OnMediaOpen");
	m_pMediaDevice->GetLocalMediaInfo(&m_MediaInfo);
	m_bMediaDeviceOpen = true;
	Print(LOG_DEBUG,"- NetworkConnection::OnMediaOpen");
}

void NetworkConnection::OnMediaClose()
{
	Print(LOG_DEBUG,"+ NetworkConnection::OnMediaClose");
	m_bMediaDeviceOpen = false;
	Print(LOG_DEBUG,"- NetworkConnection::OnMediaClose");
}

void NetworkConnection::OnMediaStart()
{
	Print(LOG_DEBUG,"+ NetworkConnection::OnMediaStart");
	m_bMediaStarted = true;
	Print(LOG_DEBUG,"- NetworkConnection::OnMediaStart");
}

void NetworkConnection::OnMediaStop()
{
	Print(LOG_DEBUG,"+ NetworkConnection::OnMediaStop");
	m_bMediaStarted = false;
	Print(LOG_DEBUG,"- NetworkConnection::OnMediaStop");
}

void NetworkConnection::OnMediaListen()
{
	Print(LOG_DEBUG,"+ NetworkConnection::OnMediaListen");
	m_bMediaListening = true;
	Print(LOG_DEBUG,"- NetworkConnection::OnMediaListen");
}

void NetworkConnection::OnMediaUnListen()
{
	Print(LOG_DEBUG,"+ NetworkConnection::OnMediaUnListen");
	m_bMediaListening = false;
	Print(LOG_DEBUG,"- NetworkConnection::OnMediaUnListen");
}


















void NetworkConnection::OnSipOpen(METAEVENT* a_MetaEvent)
{
	Print(LOG_DEBUG,"+ NetworkConnection::OnSipOpen");
	m_pSipDevice->EnableEvents();
	m_bSipDeviceOpen = true;
	Print(LOG_DEBUG,"- NetworkConnection::OnSipOpen");
}

void NetworkConnection::OnSipOffered(METAEVENT* a_MetaEvent)
{
	Print(LOG_DEBUG,"+ NetworkConnection::OnSipOffered");
	int rc = 0;

	m_pSipDevice->SetCRN(a_MetaEvent->crn);
	m_pSipDevice->ProcessSipHeaderInfo(a_MetaEvent,this);
	m_pSipDevice->ProcessInboundSDP(a_MetaEvent,&m_SDP);

	rc = StartMedia(&m_SDP);
	if (rc == 0)
	{
		m_pSipDevice->AcceptCall();
	}
	else
	{
		m_pSipDevice->RejectCall();
	}

	Print(LOG_DEBUG,"- NetworkConnection::OnSipOffered");
}

void NetworkConnection::OnSipAccept(METAEVENT* a_MetaEvent)
{
	Print(LOG_DEBUG,"+ NetworkConnection::OnSipAccept");

	Print(LOG_INFO,"\t\tGenerating SDP Answer");

	m_SDP.connection()->setAddress(m_MediaInfo.MediaData[0].mediaInfo.PortInfo.cIPAddress);
	Print(LOG_INFO,"\t\tSDP connection address set to %s",m_SDP.connection()->getAddress());

	m_SDP.origin()->setAddress(m_MediaInfo.MediaData[0].mediaInfo.PortInfo.cIPAddress);
	Print(LOG_INFO,"\t\tSDP origin address set to %s",m_SDP.origin()->getAddress());

	m_SDP.sessionName()->setName("SDP API - 3PCC Test Application");
	Print(LOG_INFO,"\t\tSDP session name set to %s",m_SDP.sessionName()->getName());

	sdpMediaDescriptionList* pMDList = m_SDP.mediaDescriptionList();
	pMDList->clear();

	Print(LOG_INFO,"\t\tAdding SDP media descriptor");
	sdpMediaDescription* pMD = pMDList->addItem();
	sdpMedia* pMedia = pMD->media();

	Print(LOG_INFO,"\t\tSetting SDP media to audio");
	pMedia->setMedia("audio");
	Print(LOG_INFO,"\t\tSetting SDP media port to %ld",m_MediaInfo.MediaData[0].mediaInfo.PortInfo.unPortId);
	pMedia->setPort(m_MediaInfo.MediaData[0].mediaInfo.PortInfo.unPortId);
	Print(LOG_INFO,"\t\tSetting SDP media transport to RTP/AVP");
	pMedia->setTransport("RTP/AVP");
	Print(LOG_INFO,"\t\tAdding media format 0 (G.711 MuLaw)");
	pMedia->addFormat("0");
		
	m_pSipDevice->AnswerCall(&m_SDP);
	Print(LOG_DEBUG,"- NetworkConnection::OnSipAccept");
}

void NetworkConnection::OnSipAnswered(METAEVENT* a_MetaEvent)
{
	Print(LOG_DEBUG,"+ NetworkConnection::OnSipAnswered");
	m_pSipDevice->ProcessSipHeaderInfo(a_MetaEvent,this);
	Print(LOG_DEBUG,"- NetworkConnection::OnSipAnswered");
}

void NetworkConnection::OnSipAck(METAEVENT* a_MetaEvent)
{
	Print(LOG_DEBUG,"+ NetworkConnection::OnSipAck");
	m_pSipDevice->ProcessSipHeaderInfo(a_MetaEvent,this);
	Print(LOG_DEBUG,"- NetworkConnection::OnSipAck");
}

void NetworkConnection::OnSipDisconnected(METAEVENT* a_MetaEvent)
{
	Print(LOG_DEBUG,"+ NetworkConnection::OnSipDisconnected");
	StopMedia();
	m_pSipDevice->DropCall();
	Print(LOG_DEBUG,"- NetworkConnection::OnSipDisconnected");
}

void NetworkConnection::OnSipDropCall(METAEVENT* a_MetaEvent)
{
	Print(LOG_DEBUG,"+ NetworkConnection::OnSipDropCall");
	m_pSipDevice->ReleaseCall();
	Print(LOG_DEBUG,"- NetworkConnection::OnSipDropCall");
}

void NetworkConnection::OnSipReleaseCall(METAEVENT* a_MetaEvent)
{
	Print(LOG_DEBUG,"+ NetworkConnection::OnSipReleaseCall");
	m_pSipDevice->ProcessSipHeaderInfo(a_MetaEvent,this);
	Print(LOG_DEBUG,"- NetworkConnection::OnSipReleaseCall");
}

void NetworkConnection::OnSipReqModifyCall(METAEVENT* a_MetaEvent)
{
	Print(LOG_DEBUG,"+ NetworkConnection::OnSipReqModifyCall");
	m_pSipDevice->RejectModifyCall();
	Print(LOG_DEBUG,"- NetworkConnection::OnSipReqModifyCall");
}

void NetworkConnection::OnSipSetConfigData(METAEVENT* a_MetaEvent)
{
	Print(LOG_DEBUG,"+ NetworkConnection::OnSipSetConfigData");
	m_pSipDevice->WaitCall();
	Print(LOG_DEBUG,"- NetworkConnection::OnSipSetConfigData");
}
