/**********@@@SOFT@@@WARE@@@COPY@@@RIGHT@@@**********************************
* DIALOGIC CONFIDENTIAL
*
* Copyright (C) 2007 Dialogic Corporation. All Rights Reserved.
* The source code contained or described herein and all documents related
* to the source code ("Material") are owned by Dialogic Corporation or its
* suppliers or licensors. Title to the Material remains with Dialogic Corporation
* or its suppliers and licensors. The Material contains trade secrets and
* proprietary and confidential information of Dialogic or its suppliers and
* licensors. The Material is protected by worldwide copyright and trade secret
* laws and treaty provisions. No part of the Material may be used, copied,
* reproduced, modified, published, uploaded, posted, transmitted, distributed,
* or disclosed in any way without Dialogic's prior express written permission.
*
* No license under any patent, copyright, trade secret or other intellectual
* property right is granted to or conferred upon you by disclosure or delivery
* of the Materials, either expressly, by implication, inducement, estoppel or
* otherwise. Any license under such intellectual property rights must be
* express and approved by Dialogic in writing.
*
***********************************@@@SOFT@@@WARE@@@COPY@@@RIGHT@@@**********/


#include "SipDevice.h"


SipDevice::SipDevice()
{
	Print(LOG_DEBUG,"+ SipDevice::SipDevice");
	strcpy(m_CallID,"");
	m_CRN = 0;
	Print(LOG_DEBUG,"- SipDevice::SipDevice");
}

SipDevice::~SipDevice()
{
	Print(LOG_DEBUG,"+ SipDevice::~SipDevice");
	Print(LOG_DEBUG,"- SipDevice::~SipDevice");
}

int SipDevice::Open(const char* a_SipDevName)
{
	Print(LOG_DEBUG,"+ SipDevice::Open");
	int rc = 0;
	strcpy(m_DeviceName,a_SipDevName);
	Print(LOG_INFO,"\tOpening SIP device %s", a_SipDevName);
	if (rc = gc_OpenEx(&m_DeviceHandle, (char*)a_SipDevName, EV_ASYNC, &m_DeviceHandle) != GC_SUCCESS) 
	{
		Print(LOG_ERROR,"\tgc_OpenEx(devicename=%s, mode=EV_ASYNC) Failed", a_SipDevName);
	}
	else
	{
		Print(LOG_INFO,"\tdevicename=%s successfully opened.  Handle = %d", a_SipDevName, m_DeviceHandle);
	}
	Print(LOG_INFO,"\n");

	Print(LOG_DEBUG,"- SipDevice::Open");
	return rc;
}

int SipDevice::Close()
{
	Print(LOG_DEBUG,"+ SipDevice::Close");
	int rc = 0;

	if (m_DeviceHandle)
	{
		if (m_CRN != 0)
		{
			Print(LOG_INFO,"\t\tDropping call on device %s",m_DeviceName);
			if (gc_DropCall(m_CRN, GC_NORMAL_CLEARING, EV_ASYNC) != GC_SUCCESS) 
			{
				Print(LOG_ERROR,"\tgc_DropCall() Failed");
			}
		}
		Print(LOG_INFO,"\tClosing SIP device %s", m_DeviceName);
		gc_Close(m_DeviceHandle);
		m_DeviceHandle = 0;
	}

	Print(LOG_DEBUG,"- SipDevice::Close");
	return rc;
}

int SipDevice::ProcessSipHeaderInfo(METAEVENT* a_MetaEvent, NetworkConnection* a_pNetworkConnection)
{
	Print(LOG_DEBUG,"+ SipDevice::ProcessSipHeaderInfo");
	int rc = 0;

	GC_PARM_BLK *pParmBlock = (GC_PARM_BLK*)(a_MetaEvent->extevtdatap);
	GC_PARM_DATA  *parmp = NULL;
	char HeaderData[IP_SIP_HDR_MAXLEN];

	Print(LOG_INFO,"\t\tRetrieving inbound Sip Headers");

	/* going thru each parameter block data*/
	while ((parmp = gc_util_next_parm(pParmBlock,parmp)) != 0)
	{
		switch (parmp->set_ID)
		{
			case IPSET_SIP_MSGINFO:
				switch (parmp->parm_ID)
				{
					case IPPARM_SIP_HDR:
						strncpy(HeaderData,(char*)parmp->value_buf,parmp->value_size);
						HeaderData[parmp->value_size]='\0';
						Print(LOG_DEBUG,"\t\t%s",HeaderData);
						if (strstr(HeaderData,"Call-ID:"))
						{
							if (strlen(m_CallID) == 0)
							{
								Print(LOG_INFO,"\t\tStoring Call-ID");
								Print(LOG_INFO,"\t\tCall-ID = %s",HeaderData);
								strcpy(m_CallID,HeaderData);
							}
						}
						if (strstr(HeaderData,"To"))
						{
							a_pNetworkConnection->SetObjectId(HeaderData);
						}
						break;
				}
				break;
		}
	}
	Print(LOG_INFO,"\n");
	Print(LOG_DEBUG,"- SipDevice::ProcessSipHeaderInfo");
	return rc;
}

int SipDevice::ProcessInboundSDP(METAEVENT* a_MetaEvent, sdpSessionDescription* a_pSDP)
{
	Print(LOG_DEBUG,"+ SipDevice::ProcessInboundSDP");
	int rc = -1;

	GC_PARM_BLK *pParmBlock = (GC_PARM_BLK*)(a_MetaEvent->extevtdatap);
	GC_PARM_DATA  *parmp = NULL;
	char sdpOffer[256];

	Print(LOG_INFO,"\t\tRetrieving inbound SDP");

	/* going thru each parameter block data*/
	while ((parmp = gc_util_next_parm(pParmBlock,parmp)) != 0)
	{
		switch (parmp->set_ID)
		{
			/* Handle SDP information */
			case IPSET_SDP:
				switch (parmp->parm_ID)
				{
					case IPPARM_SDP_OFFER:
						Print(LOG_INFO,"\t\tSDP Offer Retrieved");
						strncpy(sdpOffer,(char*)parmp->value_buf,parmp->value_size);
						sdpOffer[parmp->value_size]='\0';
						Print(LOG_DEBUG,"\t\tSDP Offer = \n%s",sdpOffer);
						
						a_pSDP->clear();
						a_pSDP->importSDP(sdpOffer,false);
						Print(LOG_INFO,"\t\tSDP connection = %s",a_pSDP->connection()->getValue());
						Print(LOG_INFO,"\t\tSDP origin = %s",a_pSDP->origin()->getValue());
						Print(LOG_INFO,"\t\tSDP session name = %s",a_pSDP->sessionName()->getName());

						int NumMD = a_pSDP->mediaDescriptionList()->numItem();
						Print(LOG_INFO,"\t\tSDP contains %d media descriptor(s)",NumMD);
						int i,j;
						for(i=0;i<NumMD;i++)
						{
							sdpMediaDescription* pMD = a_pSDP->mediaDescriptionList()->getItem(i);
							sdpMedia* pMedia = pMD->media();
							int NumMedia = pMedia->getNumFormat();
							Print(LOG_INFO,"\t\tMedia descriptor #%d = %s",i+1,pMedia->getValue());
							Print(LOG_INFO,"\t\tMedia descriptor #%d contains %d media format(s)",i+1,NumMedia);
							for(j=0;j<NumMedia;j++)
							{
								Print(LOG_INFO,"\t\t\tMedia format #%d = %s",j+1,pMedia->getFormat(j));
							}

							sdpAttributeList* pAttributeList = pMD->attributeList();
							int NumAttribute = pAttributeList->numItem();
							Print(LOG_INFO,"\t\tMedia descriptor #%d contains %d attribute(s)",i+1,NumAttribute);
							for(j=0;j<NumAttribute;j++)
							{
								sdpAttribute* pAttribute = pAttributeList->getItem(j);
								Print(LOG_INFO,"\t\t\tAttribute #%d = %s",j+1,pAttribute->getValue());
							}
						}
						break;
				}
				break;
		}
	}
	Print(LOG_INFO,"\n");
	Print(LOG_DEBUG,"- SipDevice::ProcessInboundSDP");
	return rc;
}

int SipDevice::WaitCall()
{
	Print(LOG_DEBUG,"+ SipDevice::WaitCall");
	int rc = -1;
	Print(LOG_INFO,"\t\tEvents enabled");
	Print(LOG_INFO,"\t\tWaiting for Inbound Calls on device %s",m_DeviceName);
	if (gc_WaitCall(m_DeviceHandle, NULL, NULL, -1, EV_ASYNC) != GC_SUCCESS) 
	{
		Print(LOG_ERROR,"\tgc_WaitCall(linedev=%ld, crnp=NULL, waittime=0, mode=EV_ASYNC) Failed", m_DeviceHandle);
	}
	Print(LOG_DEBUG,"- SipDevice::WaitCall");
	return rc;
}

int SipDevice::AcceptCall()
{
	Print(LOG_DEBUG,"+ SipDevice::AcceptCall");
	int rc = -1;

	Print(LOG_INFO,"\t\tAccepting Call");
	if (rc = gc_AcceptCall(m_CRN, GC_CALL_REJECTED, EV_ASYNC) != GC_SUCCESS) 
	{
		Print(LOG_ERROR,"\tgc_AcceptCall(crn=0x%lx, # of rings=0, mode=EV_ASYNC) Failed", m_CRN);
	}
	Print(LOG_DEBUG,"- SipDevice::AcceptCall");
	return rc;
}

int SipDevice::RejectCall()
{
	Print(LOG_DEBUG,"+ SipDevice::RejectCall");
	int rc = -1;

	Print(LOG_INFO,"\t\tRejecting Call");
	if (gc_DropCall(m_CRN, 0, EV_ASYNC) != GC_SUCCESS) 
	{
		Print(LOG_ERROR,"\tgc_RejectCall() Failed");
	}
	Print(LOG_DEBUG,"- SipDevice::RejectCall");
	return rc;
}

int SipDevice::AnswerCall(sdpSessionDescription* a_pSDP)
{
	Print(LOG_DEBUG,"+ SipDevice::AnswerCall");
	int rc = 0;

	Print(LOG_INFO,"\t\tInserting SDP Answer");
	GC_PARM_BLKP parmblkp = NULL; // input parameter block pointer 
	GC_PARM_BLKP retblkp = NULL; // return parameter block
	int retval = GC_SUCCESS;

	char sdpAnswer[256];
	a_pSDP->exportSDP(sdpAnswer,255,false);
	int len = strlen(sdpAnswer);
	Print(LOG_DEBUG,"\t\tSDP Answer = \n%s",sdpAnswer);

	gc_util_insert_parm_ref(&parmblkp,
							IPSET_SDP,
							IPPARM_SDP_ANSWER,
							len,
							sdpAnswer);

	gc_SetUserInfo(GCTGT_GCLIB_CRN, m_CRN, parmblkp, GC_SINGLECALL);
	gc_util_delete_parm_blk(parmblkp);
	
	Print(LOG_INFO,"\t\tAnswering Call");
	if (rc = gc_AnswerCall(m_CRN, 0, EV_ASYNC) != GC_SUCCESS) 
	{
		Print(LOG_ERROR,"\tgc_AnswerCall(crn=0x%lx, # of rings=0, mode=EV_ASYNC) Failed", m_CRN);
	}
	Print(LOG_DEBUG,"- SipDevice::AnswerCall");
	return rc;
}

int SipDevice::DropCall()
{
	Print(LOG_DEBUG,"+ SipDevice::DropCall");
	int rc = 0;
	Print(LOG_INFO,"\t\tDropping call on device %s",m_DeviceName);
	if (gc_DropCall(m_CRN, GC_NORMAL_CLEARING, EV_ASYNC) != GC_SUCCESS) 
	{
		Print(LOG_ERROR,"\tgc_DropCall() Failed");
	}
	Print(LOG_DEBUG,"- SipDevice::DropCall");
	return rc;
}

int SipDevice::RejectModifyCall()
{
	Print(LOG_DEBUG,"+ SipDevice::RejectModifyCall");
	int rc = 0;
	Print(LOG_INFO,"\t\tRejecting Modify Call request");
	if (rc =gc_RejectModifyCall(m_CRN, IPEC_SIPReasonStatus488NotAcceptableHere, EV_ASYNC) != GC_SUCCESS) 
	{
		Print(LOG_ERROR,"\tgc_RejectModifyCall() Failed");
	}
	Print(LOG_DEBUG,"- SipDevice::RejectModifyCall");
	return rc;
}

int SipDevice::ReleaseCall()
{
	Print(LOG_DEBUG,"+ SipDevice::ReleaseCall");
	int rc = 0;
	Print(LOG_INFO,"\t\tReleasing call on device %s",m_DeviceName);
	if (gc_ReleaseCallEx(m_CRN, EV_ASYNC) != GC_SUCCESS) 
	{
		Print(LOG_ERROR,"\tgc_ReleaseCallEx() Failed");
	}
	m_CRN = 0;
	Print(LOG_DEBUG,"- SipDevice::ReleaseCall");
	return rc;
}

int SipDevice::EnableEvents()
{
	Print(LOG_DEBUG,"+ SipDevice::EnableEvents");
	Print(LOG_INFO,"\t\tEnabling events for device %s",m_DeviceName);

	GC_PARM_BLKP        gcParmBlk = NULL;
	long                requestid;
	int                 returnValue;
	int rc = 0;
	
	if (gc_util_insert_parm_val(&gcParmBlk, GCSET_CALLEVENT_MSK, GCACT_ADDMSK,
		sizeof(unsigned long), GCEV_DIALING) < 0)
	{
		Print(LOG_ERROR,"\tunable to gc_util_insert_parm_val:GCEV_DIALING");
	}

	if (gc_util_insert_parm_val(&gcParmBlk, GCSET_CALLEVENT_MSK, GCACT_ADDMSK,
		sizeof(unsigned long), GCEV_EXTENSION) < 0)
	{
		Print(LOG_ERROR,"\tunable to gc_util_insert_parm_val:GCEV_EXTENSION");
	}

	if (gc_util_insert_parm_val(&gcParmBlk, GCSET_CALLEVENT_MSK, GCACT_ADDMSK,
		sizeof(unsigned long), GCEV_EXTENSIONCMPLT) < 0)
	{
		Print(LOG_ERROR,"\tunable to gc_util_insert_parm_val:GCEV_EXTENSIONCMPLT");
	}

	if (gc_util_insert_parm_val(&gcParmBlk, GCSET_CALLEVENT_MSK, GCACT_ADDMSK,
		sizeof(unsigned long), GCMSK_SIP_ACK) < 0)
	{
		Print(LOG_ERROR,"\tunable to gc_util_insert_parm_val:GCEV_EXTENSIONCMPLT");
	}

	if (gc_util_insert_parm_val(&gcParmBlk, GCSET_CALLEVENT_MSK, GCACT_ADDMSK,
		sizeof(unsigned long), GCMSK_200_OK) < 0)
	{
		Print(LOG_ERROR,"\tunable to gc_util_insert_parm_val:GCEV_EXTENSIONCMPLT");
	}

	returnValue = gc_SetConfigData(GCTGT_GCLIB_CHAN,
								m_DeviceHandle,
								gcParmBlk, 
								0, 
								GCUPDATE_IMMEDIATE, 
								&requestid, 
								EV_ASYNC);
	if (returnValue < 0)
	{
		Print(LOG_ERROR,"\t***** Error: failed in gc_SetConfigData GCEV_DIALING *****");
	}

	gc_util_delete_parm_blk(gcParmBlk); 

	Print(LOG_DEBUG,"- SipDevice::EnableEvents");
	return rc;
}







void SipDevice::SetCRN(CRN a_CRN)
{
	Print(LOG_DEBUG,"+ SipDevice::SetCRN");
	m_CRN = a_CRN;
	Print(LOG_DEBUG,"- SipDevice::SetCRN");
}



