/**********@@@SOFT@@@WARE@@@COPY@@@RIGHT@@@**********************************
* DIALOGIC CONFIDENTIAL
*
* Copyright (C) 2007 Dialogic Corporation. All Rights Reserved.
* The source code contained or described herein and all documents related
* to the source code ("Material") are owned by Dialogic Corporation or its
* suppliers or licensors. Title to the Material remains with Dialogic Corporation
* or its suppliers and licensors. The Material contains trade secrets and
* proprietary and confidential information of Dialogic or its suppliers and
* licensors. The Material is protected by worldwide copyright and trade secret
* laws and treaty provisions. No part of the Material may be used, copied,
* reproduced, modified, published, uploaded, posted, transmitted, distributed,
* or disclosed in any way without Dialogic's prior express written permission.
*
* No license under any patent, copyright, trade secret or other intellectual
* property right is granted to or conferred upon you by disclosure or delivery
* of the Materials, either expressly, by implication, inducement, estoppel or
* otherwise. Any license under such intellectual property rights must be
* express and approved by Dialogic in writing.
*
***********************************@@@SOFT@@@WARE@@@COPY@@@RIGHT@@@**********/
// UnitTest.cpp : Defines the entry point for the console application.
//

#include "sdpAPI.h"

#ifdef WIN32
#include <afx.h>
#endif


void InvestigateSDP(sdpSessionDescription* pSDP);
void TestFromString();
void TestNewSDP();
void TestLists();



int main(int argc, char* argv[])
{

#ifdef WIN32
#ifdef _DEBUG
	CMemoryState oldMemState, newMemState, diffMemState;
	oldMemState.Checkpoint();
#endif
#endif

	TestFromString();
	TestNewSDP();

	sdpSessionDescription* sdp = new sdpSessionDescription;
	delete sdp;
	
#ifdef WIN32
#ifdef _DEBUG
	newMemState.Checkpoint();
	if( diffMemState.Difference( oldMemState, newMemState ) )
	{
		TRACE( "Memory leaked!\n" );
		diffMemState.DumpStatistics();
	}
#endif
#endif

	printf ("\n\n\nPRESS ENTER TO EXIT\n");
	getchar();

	return 0;
}


void TestNewSDP()
{
	char* pString = NULL;

	printf ("\n\n\n\n**************************************************************************************************\n");
	printf ("Creating empty SDP ... \n\n");

	sdpSessionDescription sdp;

	printf ("Adding entries to SDP ... \n\n");

	printf ("Adding version (v=) ... \n");
	sdp.version()->setVersion("0");

	printf ("Adding origin (o=) ... \n");
	sdp.origin()->setUserName("4072155420");
	sdp.origin()->setSessionId("8000");
	sdp.origin()->setVersion("8000");
	sdp.origin()->setNetworkType("IN");
	sdp.origin()->setAddressType("IP4");
	sdp.origin()->setAddress("66.192.229.109");

	printf ("Adding session name (s=) ... \n");
	sdp.sessionName()->setName("SIP Call");

	printf ("Adding session information (i=) ... \n");
	sdp.sessionInformation()->setInfo("My Session Info");

	printf ("Adding uri (u=) ... \n");
	sdp.uri()->setURI("http://www.collinshillfootball.com");

	sdpEmailAddress* pEmail;
	printf ("Adding email address (e=) ... \n");
	pEmail = sdp.emailAddressList()->addItem();
	pEmail->setEmail("stephen.buko@intel.com");
	printf ("Adding another email address (e=) ... \n");
	pEmail = sdp.emailAddressList()->addItem();
	pEmail->setEmail("stevebuko@bellsouth.net");

	sdpPhoneNumber* pPhoneNumber;
	printf ("Adding phone number (p=) ... \n");
	pPhoneNumber = sdp.phoneNumberList()->addItem();
	pPhoneNumber->setNumber("(770) 995-8768");
	printf ("Adding another phone number (p=) ... \n");
	pPhoneNumber = sdp.phoneNumberList()->addItem();
	pPhoneNumber->setNumber("(770) 995-0469");
	printf ("Adding another phone number (p=) ... \n");
	pPhoneNumber = sdp.phoneNumberList()->addItem();
	pPhoneNumber->setNumber("(678) 733-0389");

	printf ("Adding session connection (c=) ... \n");
	sdp.connection()->setNetworkType("IN");
	sdp.connection()->setAddressType("IP4");
	sdp.connection()->setAddress("66.192.229.109");

	printf ("Adding session bandwidth (b=) ... \n");
	sdp.bandwidth()->setModifier("X-YZ");
	sdp.bandwidth()->setBandwidthValue("128");

	printf ("Adding time (t=) ... \n");
	sdpTimeDescription* pTD=sdp.timeDescriptionList()->addItem();
	unsigned long Start = 1234567890;
	unsigned long Stop = 1098765432;
	pTD->time()->setStart(Start);
	pTD->time()->setStop(Stop);

	printf ("Adding repeat times (r=) ... \n");
	pTD->repeatTimes()->setInterval("604800");
	pTD->repeatTimes()->setDuration("3600");
	pTD->repeatTimes()->setOffsets("0 90000");

	printf ("Adding timezone adjustment (z=) ... \n");
	sdp.timezoneAdjustment()->addAdjustment("2882844526","-1h");
	printf ("Adding another timezone adjustment (z=) ... \n");
	sdp.timezoneAdjustment()->addAdjustment("2898848070","0");

	printf ("Adding session encryption key (k=) ... \n");
	sdp.encryptionKey()->setMethod("clear");
	sdp.encryptionKey()->setKey("<1203984958SK45>");

	printf ("Adding session attribute (a=) ... \n");
	sdpAttribute* pAttribute;
	pAttribute = sdp.attributeList()->addItem();
	pAttribute->setProperty("sendonly");

	printf ("\nAdding media description ... \n\n");
	sdpMediaDescription* pMD=sdp.mediaDescriptionList()->addItem();
	
	printf ("Adding media (m=) ... \n");
	pMD->media()->setMedia("audio");
	pMD->media()->setPort(61964);
	pMD->media()->setTransport("RTP/AVP");
	pMD->media()->setNumPorts(1);
	pMD->media()->addFormat("18");
	pMD->media()->addFormat("0");
	pMD->media()->addFormat("8");
	pMD->media()->addFormat("4");
	pMD->media()->addFormat("2");
	pMD->media()->addFormat("15");
	pMD->media()->addFormat("101");

	printf ("m= line currently is set to %s\n",pMD->media()->getValue());

	printf ("Deleting Format 0 ...\n");
	pMD->media()->deleteFormat("0");

	printf ("Deleting Format 8 ...\n");
	pMD->media()->deleteFormat("8");

	printf ("Deleting Format 4 ...\n");
	pMD->media()->deleteFormat("4");

	printf ("Updated m= line is now set to %s\n",pMD->media()->getValue());

	printf ("Setting number of ports used to 2 ...\n");
	pMD->media()->setNumPorts(2);

	printf ("Updated m= line is now set to %s\n",pMD->media()->getValue());

	pMD->mediaTitle()->setTitle("Media Desc 1.");

	sdpAttributeList* pAttributeList = pMD->attributeList();

	printf ("Adding media attribute (a=) ... \n");
	pAttribute = pAttributeList->addItem();
	pAttribute->setProperty("rtpmap");
	pAttribute->setPropertyValue("18 G729/8000");
	
	printf ("Adding media attribute (a=) ... \n");
	pAttribute = pAttributeList->addItem();
	pAttribute->setProperty("rtpmap");
	pAttribute->setPropertyValue("0 PCMU/8000");
	
	printf ("Adding media attribute (a=) ... \n");
	pAttribute = pAttributeList->addItem();
	pAttribute->setProperty("rtpmap");
	pAttribute->setPropertyValue("8 PCMA/8000");
	
	printf ("Adding media attribute (a=) ... \n");
	pAttribute = pAttributeList->addItem();
	pAttribute->setProperty("rtpmap");
	pAttribute->setPropertyValue("4 G723/8000");
	
	printf ("Adding media attribute (a=) ... \n");
	pAttribute = pAttributeList->addItem();
	pAttribute->setProperty("rtpmap");
	pAttribute->setPropertyValue("2 G726-32/8000");
	
	printf ("Adding media attribute (a=) ... \n");
	pAttribute = pAttributeList->addItem();
	pAttribute->setProperty("rtpmap");
	pAttribute->setPropertyValue("15 G728/8000");

	printf ("Adding media attribute (a=) ... \n");
	pAttribute = pAttributeList->addItem();
	pAttribute->setProperty("ptime");
	pAttribute->setPropertyValue("10");
	
	printf ("Adding media attribute (a=) ... \n");
	pAttribute = pAttributeList->addItem();
	pAttribute->setProperty("rtpmap");
	pAttribute->setPropertyValue("101 telephone-event/8000");

	printf ("Adding media attribute (a=) ... \n");
	pAttribute = pAttributeList->addItem();
	pAttribute->setProperty("fmtp");
	pAttribute->setPropertyValue("101 0-11");

	printf ("Adding media connection (c=) ... \n");
	pMD->connection()->setNetworkType("IN");
	pMD->connection()->setAddressType("IP4");
	pMD->connection()->setAddress("0.0.0.0");

	printf ("Adding media bandwidth (b=) ... \n");
	pMD->bandwidth()->setModifier("X-YZ");
	pMD->bandwidth()->setBandwidthValue("64");

	printf ("Adding media encryption key (k=) ... \n");
	pMD->encryptionKey()->setMethod("clear");
	pMD->encryptionKey()->setKey("<AAA1203984958SK45>");

//	InvestigateSDP(&sdp);

	printf ("\n\nGenerating SDP to string ... \n");
	char MySDP[1024];
	if (sdp.exportSDP(MySDP,1024,false) == 0)
	{
		printf ("Retrieval of SDP successful\n");
	}
	else
	{
		printf ("******************  Retrieval of SDP FAILED ***************\n");
	}

	printf ("\n\nDumping Generated SDP ....\n\n%s\n\n", MySDP);
	printf ("**************************************************************************************************\n");
}


void TestFromString()
{
	char RawSDP1[] = {"v=0\no=mhandley 2890844526 2890842807 IN IP4 126.16.64.4\ns=SDP Seminar\ni=A Seminar on the session description protocol\nu=http://www.cs.ucl.ac.uk/staff/M.Handley/sdp.03.pse=mjh@isi.edu (Mark Handley)\nc=IN IP4 224.2.17.12/127\nt=2873397496 2873404696\n"};
	char RawSDP2[] = {"v=0\no=mhandley 2890844526 2890842807 IN IP4 126.16.64.4\ns=SDP Seminar\ni=A Seminar on the session description protocol\nu=http://www.cs.ucl.ac.uk/staff/M.Handley/sdp.03.ps\ne=mjh@isi.edu (Mark Handley)\np=(770) 995-0469\nc=IN IP4 224.2.17.12/127\nt=2873397496 2873404696\nz=2882844526 -1h 2898848070 0\na=recvonly\nm=audio 49170 RTP/AVP 0 8\nm=video 51372 RTP/AVP 31\nm=application 32416 udp wb\na=orient:portrait\n"};
	char RawSDP3[] = {"v=0\no=4072155420 8000 8000 IN IP4 66.192.229.109\ns=SIP Call\nc=IN IP4 66.192.229.109\nt=0 0\nm=audio 61964 RTP/AVP 18 0 8 4 2 15 101\na=rtpmap:18 G729/8000\na=rtpmap:0 PCMU/8000\na=rtpmap:8 PCMA/8000\na=rtpmap:4 G723/8000\na=rtpmap:2 G726-32/8000\na=rtpmap:15 G728/8000\na=ptime:10\na=rtpmap:101 telephone-event/8000\na=fmtp:101 0-11\n"};
	int i=0;


	// create blank SDP
	sdpSessionDescription* sdp = new sdpSessionDescription;
	char* SDPs[3];
	SDPs[0] = RawSDP1;
	SDPs[1] = RawSDP2;
	SDPs[2] = RawSDP3;

	for (i=0;i<3;i++)
	{
		printf ("\n\n\n\n**************************************************************************************************\n");
		printf ("Running \"SDP from String\" test #%d ... \n",i+1);
		printf ("Dumping Raw SDP String ... \n\n%s\n", SDPs[i]);

		sdp->clear();
		printf ("Importing SDP data from string ... \n\n");
		sdp->importSDP(SDPs[i],false);

//		InvestigateSDP(&sdp);

		char MySDP[600];
		printf ("Exporting SDP data from SDP object to string ... \n");
		if (sdp->exportSDP(MySDP,600,false) == 0)
		{
			printf ("Retrieval of SDP successful\n");
		}
		else
		{
			printf ("******************  Retrieval of SDP FAILED ***************\n");
		}
	
		printf ("\n\nDumping Generated SDP ....\n\n%s\n\n", MySDP);

		printf ("\n\nComparing original SDP and generated SDP .....\n\n");
		if (!strcmp(SDPs[i],MySDP))
		{
			printf ("SDPs are identical.  Test Passed\n");
		}
		else
		{
			printf ("****************** SDPs are different.  Test FAILED ******************\n");
			printf ("Original SDP len = %d\n",strlen(SDPs[i]));
			printf ("Generated SDP len = %d\n",strlen(MySDP));
		}
		printf ("**************************************************************************************************\n");
	}

	delete sdp;
}


void InvestigateSDP(sdpSessionDescription* pSDP)
{
	char* pString = NULL;
	int i=0;
	int j=0;

	// investigate v=
	if (pSDP->version()->ifExists())
	{
		printf("Version = %s\n",pSDP->version()->getVersion());
	}

	// investigate o=
	if (pSDP->origin()->ifExists())
	{
		printf("Origin User Name = %s\n",pSDP->origin()->getUserName());
		printf("Origin Session Id = %s\n",pSDP->origin()->getSessionId());
		printf("Origin Version = %s\n",pSDP->origin()->getVersion());
		printf("Origin Network Type = %s\n",pSDP->origin()->getNetworkType());
		printf("Origin Address Type = %s\n",pSDP->origin()->getAddressType());
		printf("Origin Address = %s\n",pSDP->origin()->getAddress());
	}

	// investigate s=
	if (pSDP->sessionName()->ifExists())
	{
		printf("Session Name = %s\n",pSDP->sessionName()->getName());
	}

	// investigate i=
	if (pSDP->sessionInformation()->ifExists())
	{
		printf("Session Information = %s\n",pSDP->sessionInformation()->getInfo());
	}

	// investigate u=
	if (pSDP->uri()->ifExists())
	{
		printf("URI = %s\n",pSDP->uri()->getURI());
	}

	// investigate e=
	int NumEmailAddress = pSDP->emailAddressList()->numItem();
	if (NumEmailAddress)
	{
		printf("Number of Email Addresses = %d\n",NumEmailAddress);
		for (i=0;i<NumEmailAddress;i++)
		{
			sdpEmailAddress* pEmail = pSDP->emailAddressList()->getItem(i);
			printf("\tEmail Address #%d= %s\n",i+1,pEmail->getEmail());
		}
	}

	// investigate p=
	int NumPhoneNumber = pSDP->phoneNumberList()->numItem();
	if (NumPhoneNumber)
	{
		printf("Number of Phone Numbers = %d\n",NumPhoneNumber);
		for (i=0;i<NumPhoneNumber;i++)
		{
			sdpPhoneNumber* pPhoneNumber = pSDP->phoneNumberList()->getItem(i);
			printf("\tPhone Number #%d= %s\n",i+1,pPhoneNumber->getNumber());
		}
	}

	// investigate c=
	if (pSDP->connection()->ifExists())
	{
		printf("Connection Network Type = %s\n",pSDP->connection()->getNetworkType());
		printf("Connection Address Type = %s\n",pSDP->connection()->getAddressType());
		printf("Connection Address = %s\n",pSDP->connection()->getAddress());
	}

	// investigate b=
	if (pSDP->bandwidth()->ifExists())
	{
		printf("Bandwidth Modifier= %s\n",pSDP->bandwidth()->getModifier());
		printf("Bandwidth Value= %s\n",pSDP->bandwidth()->getBandwidthValue());
	}

	// investigate Time Descriptions
	int NumTimeDescription = pSDP->timeDescriptionList()->numItem();
	if (NumTimeDescription)
	{
		printf("Number of Time Descriptions = %d\n",NumTimeDescription);
		for (i=0;i<NumTimeDescription;i++)
		{
			sdpTimeDescription* pTD = pSDP->timeDescriptionList()->getItem(i);
			printf("Time Description #%d\n",i+1);
		
			// investigate t=
			sdpTime* pTime = pTD->time();
			printf("\tTime Start = %u\n",pTime->getStart());
			printf("\tTime Stop = %u\n",pTime->getStop());

			// investigate r=
			sdpRepeatTimes* pRepeatTimes = pTD->repeatTimes();
			if (pRepeatTimes->ifExists())
			{
				printf("\tRepeat Times Interval= %s\n",pRepeatTimes->getInterval());
				printf("\tRepeat Times Duration= %s\n",pRepeatTimes->getDuration());
				printf("\tRepeat Times Offsets= %s\n",pRepeatTimes->getOffsets());
			}
		}
	}

	// investigate z=
	if (pSDP->timezoneAdjustment()->ifExists())
	{
		printf("Timezone Adjustments = %s\n",pSDP->timezoneAdjustment()->getValue());
	}

	// investigate k=
	if (pSDP->encryptionKey()->ifExists())
	{
		printf("Encrption Method = %s\n",pSDP->encryptionKey()->getMethod());
		printf("Encrption Key = %s\n",pSDP->encryptionKey()->getKey());
	}

	// investigate Session Attributes a=
	int NumSessionAttribute = pSDP->attributeList()->numItem();
	if (NumSessionAttribute)
	{
		printf("Number of Session Attributes = %d\n",NumSessionAttribute);
		for (i=0;i<NumSessionAttribute;i++)
		{
			sdpAttribute* pAttribute = pSDP->attributeList()->getItem(i);
			printf("Session Attribute #%d Name = %s\n",i+1,pAttribute->getProperty());
			if ( strlen(pAttribute->getPropertyValue()) )
			{
				printf("Session Attribute #%d Value = %s\n",i+1,pAttribute->getPropertyValue());
			}
		}
	}

	// investigate Media Descriptions
	int NumMediaDescription = pSDP->mediaDescriptionList()->numItem();
	if (NumMediaDescription)
	{
		printf("Number of Media Descriptions = %d\n",NumMediaDescription);
		for (i=0;i<NumMediaDescription;i++)
		{
			sdpMediaDescription* pMD = pSDP->mediaDescriptionList()->getItem(i);
			printf("Media Description #%d\n",i+1);
		
			// investigate m=
			sdpMedia* pMedia = pMD->media();
			printf("\tMedia = %s\n",pMedia->getMedia());
			printf("\tPort = %ld\n",pMedia->getPort());
			printf("\tNum Ports = %d\n",pMedia->getNumPorts());
			printf("\tTransport = %s\n",pMedia->getTransport());

			int NumFormat = pMedia->getNumFormat();
			if (NumFormat)
			{
				printf("\tNumber of supported media formats = %d\n",NumFormat);
				for (j=0;j<NumFormat;j++)
				{
					printf("\t\tMedia Format #%d = %s\n",j+1,pMedia->getFormat(j));
				}
			}

			// investigate i=
			if (pMD->mediaTitle()->ifExists())
			{
				printf("\tMedia Title = %s\n",pMD->mediaTitle()->getTitle());
			}
		
			// investigate c=
			if (pMD->connection()->ifExists())
			{
				printf("\tConnection Network Type = %s\n",pMD->connection()->getNetworkType());
				printf("\tConnection Address Type = %s\n",pMD->connection()->getAddressType());
				printf("\tConnection Address = %s\n",pMD->connection()->getAddress());
			}

			// investigate b=
			if (pMD->bandwidth()->ifExists())
			{
				printf("Bandwidth Modifier= %s\n",pMD->bandwidth()->getModifier());
				printf("Bandwidth Value= %s\n",pMD->bandwidth()->getBandwidthValue());
			}

			// investigate k=
			if (pMD->encryptionKey()->ifExists())
			{
				printf("Encrption Method = %s\n",pMD->encryptionKey()->getMethod());
				printf("Encrption Key = %s\n",pMD->encryptionKey()->getKey());
			}

			// investigate Session Attributes a=
			int NumMediaAttribute = pMD->attributeList()->numItem();
			if (NumMediaAttribute)
			{
				printf("\tNumber of Media Attributes = %d\n",NumMediaAttribute);
				sdpAttributeList* pAttributeList = pMD->attributeList();
				for (j=0;j<NumMediaAttribute;j++)
				{
					sdpAttribute* pAttribute = pAttributeList->getItem(j);
					printf("\t\tMedia Attribute #%d Name = %s\n",j+1,pAttribute->getProperty());
					if ( strlen(pAttribute->getPropertyValue()) )
					{
						printf("\t\tMedia Attribute #%d Value = %s\n",j+1,pAttribute->getPropertyValue());
					}
				}
			}
		}
	}
}







