/**********@@@SOFT@@@WARE@@@COPY@@@RIGHT@@@**********************************
* DIALOGIC CONFIDENTIAL
*
* Copyright (C) 2007 Dialogic Corporation. All Rights Reserved.
* The source code contained or described herein and all documents related
* to the source code ("Material") are owned by Dialogic Corporation or its
* suppliers or licensors. Title to the Material remains with Dialogic Corporation
* or its suppliers and licensors. The Material contains trade secrets and
* proprietary and confidential information of Dialogic or its suppliers and
* licensors. The Material is protected by worldwide copyright and trade secret
* laws and treaty provisions. No part of the Material may be used, copied,
* reproduced, modified, published, uploaded, posted, transmitted, distributed,
* or disclosed in any way without Dialogic's prior express written permission.
*
* No license under any patent, copyright, trade secret or other intellectual
* property right is granted to or conferred upon you by disclosure or delivery
* of the Materials, either expressly, by implication, inducement, estoppel or
* otherwise. Any license under such intellectual property rights must be
* express and approved by Dialogic in writing.
*
***********************************@@@SOFT@@@WARE@@@COPY@@@RIGHT@@@**********/
//
// sdpElement.cpp : 
//

#include "sdpAPI.h"





///////////////////////////////////////////////////////////////////////////////////
// class sdpElementString
///////////////////////////////////////////////////////////////////////////////////
sdpElementString::sdpElementString()
{
	m_pString = new char[1];
	strcpy(m_pString,"");
}

sdpElementString::sdpElementString(const char *pString)
{
	if(pString != NULL)
	{
		m_pString = new char[strlen(pString)+1];
		strcpy(m_pString,pString);
	}
	else
	{
		m_pString = new char[1];
		strcpy(m_pString,"");
	}
}

sdpElementString::~sdpElementString()
{
	if(m_pString != NULL){
	   delete []m_pString;
	}
}

void sdpElementString::set(const char* a_String)
{
	if (a_String)
	{
		if( m_pString != NULL){
		   delete []m_pString;
        }
		m_pString = new char[strlen(a_String)+1];
		strcpy(m_pString,a_String);
	}
}

const char*	sdpElementString::get()
{
	return m_pString;
}

int sdpElementString::len()
{
	int len = strlen(m_pString);
	return len;
}
///////////////////////////////////////////////////////////////////////////////////




///////////////////////////////////////////////////////////////////////////////////
// class sdpElement
///////////////////////////////////////////////////////////////////////////////////
sdpElement::sdpElement(char a_Id)
{
	m_Id = a_Id;
}

sdpElement::~sdpElement()
{
}

void sdpElement::clear()
{
	m_String.set("");
}

int sdpElement::getLen()
{
	return m_String.len();
}

const char* sdpElement::getValue()
{
	if ( m_String.len() < 3 )
	{
		return "";
	}
	else
	{
		return m_String.get()+sizeof(char)*2;
	}
}

void sdpElement::setValue(const char* a_Value)
{
	if (a_Value)
	{
		char* elementString = new char[strlen(a_Value)+3];
		sprintf(elementString,"%c=%s",m_Id,a_Value);
		setString(elementString);
		delete []elementString;
	}
}

bool sdpElement::ifExists()
{
	if (m_String.len())
	{
		return true;
	}
	else
	{
		return false;
	}
}

void sdpElement::setString(const char* a_String)
{
	if (a_String)
	{
		m_String.set(a_String);
	}
}

const char* sdpElement::getString()
{
	return m_String.get();
}
///////////////////////////////////////////////////////////////////////////////////




///////////////////////////////////////////////////////////////////////////////////
// class sdpVersion : public sdpElement
///////////////////////////////////////////////////////////////////////////////////
sdpVersion::sdpVersion() : sdpElement('v')
{
}

const char* sdpVersion::getVersion()
{
	return getValue();
}

void sdpVersion::setVersion(const char* a_Version)
{
	if (a_Version)
	{
		setValue(a_Version);
	}
}
///////////////////////////////////////////////////////////////////////////////////




///////////////////////////////////////////////////////////////////////////////////
//class sdpTime : public sdpElement
///////////////////////////////////////////////////////////////////////////////////
sdpTime::sdpTime() : sdpElement('t')
{
	m_Start = 0;
	m_Stop = 0;
}

void sdpTime::clear()
{
	m_Start = 0;
	m_Stop = 0;

	sdpElement::clear();
}

void sdpTime::setString(const char* a_String)
{
	if (a_String)
	{
		sdpElement::setString(a_String);
		decode();
	}
}

void sdpTime::decode()
{
	if (getString())
	{
		sscanf(getString()+sizeof(char)*2,"%lu %lu",&m_Start,&m_Stop);
	}
}

void sdpTime::encode()
{
	char NewTime[24];
	sprintf(NewTime,"t=%lu %lu",m_Start,m_Stop);
	sdpElement::setString(NewTime);
}

unsigned long sdpTime::getStart()
{
	return m_Start;
}

unsigned long sdpTime::getStop()
{
	return m_Stop;
}

void sdpTime::setStart(unsigned long a_Start)
{
	m_Start = a_Start;
	encode();
}

void sdpTime::setStop(unsigned long a_Stop)
{
	m_Stop = a_Stop;
	encode();
}
///////////////////////////////////////////////////////////////////////////////////




///////////////////////////////////////////////////////////////////////////////////
// class sdpRepeatTimes : public sdpElement
///////////////////////////////////////////////////////////////////////////////////
sdpRepeatTimes::sdpRepeatTimes() : sdpElement('r')
{
}

void sdpRepeatTimes::clear()
{
	m_Interval.set("");
	m_Duration.set("");
	m_Offsets.set("");
	sdpElement::clear();
}

void sdpRepeatTimes::setString(const char* a_String)
{
	if (a_String)
	{
		sdpElement::setString(a_String);
		decode();
	}
}

void sdpRepeatTimes::decode()
{
	if (getString() && (strlen(getString())>2) )
	{
		m_Interval.set(getString()+sizeof(char)*2);
		char* pTemp;
		pTemp = (char *)strchr(m_Interval.get(),' ');
		if (pTemp)
		{
			pTemp[0]='\0';
			pTemp = pTemp + sizeof(char);
			m_Duration.set(pTemp);
		}
		pTemp = (char *)strchr(m_Duration.get(),' ');
		if (pTemp)
		{
			pTemp[0]='\0';
			pTemp = pTemp + sizeof(char);
			m_Offsets.set(pTemp);
		}
	}
}

void sdpRepeatTimes::encode()
{
	int len = 0;
	len = len + m_Interval.len();
	len = len + m_Duration.len();
	len = len + m_Offsets.len();

	char* NewRepeatTimes = new char[len+5];
	sprintf(NewRepeatTimes,"r=%s %s %s",m_Interval.get(),m_Duration.get(),m_Offsets.get());
	sdpElement::setString(NewRepeatTimes);
	delete []NewRepeatTimes;
}

const char* sdpRepeatTimes::getInterval()
{
	return m_Interval.get();
}

const char* sdpRepeatTimes::getDuration()
{
	return m_Duration.get();
}

const char* sdpRepeatTimes::getOffsets()
{
	return m_Offsets.get();
}

void sdpRepeatTimes::setInterval(const char* a_Interval)
{
	if (a_Interval)
	{
		m_Interval.set(a_Interval);
		encode();
	}
}

void sdpRepeatTimes::setDuration(const char* a_Duration)
{
	if (a_Duration)
	{
		m_Duration.set(a_Duration);
		encode();
	}
}

void sdpRepeatTimes::setOffsets(const char* a_Offsets)
{
	if (a_Offsets)
	{
		m_Offsets.set(a_Offsets);
		encode();
	}
}
///////////////////////////////////////////////////////////////////////////////////




///////////////////////////////////////////////////////////////////////////////////
// class sdpSessionName : public sdpElement
///////////////////////////////////////////////////////////////////////////////////
sdpSessionName::sdpSessionName() : sdpElement('s')
{
}

const char* sdpSessionName::getName()
{
	return getValue();
}

void sdpSessionName::setName(const char* a_Name)
{
	if (a_Name)
	{
		setValue(a_Name);
	}
}
///////////////////////////////////////////////////////////////////////////////////




///////////////////////////////////////////////////////////////////////////////////
// class sdpSessionInformation : public sdpElement
///////////////////////////////////////////////////////////////////////////////////
sdpSessionInformation::sdpSessionInformation() : sdpElement('i')
{
}

const char* sdpSessionInformation::getInfo()
{
	return getValue();
}

void sdpSessionInformation::setInfo(const char* a_Info)
{
	if (a_Info)
	{
		setValue(a_Info);
	}
}
///////////////////////////////////////////////////////////////////////////////////




///////////////////////////////////////////////////////////////////////////////////
// class sdpURI : public sdpElement
///////////////////////////////////////////////////////////////////////////////////
sdpURI::sdpURI() : sdpElement('u')
{
}

const char* sdpURI::getURI()
{
	return getValue();
}

void sdpURI::setURI(const char* a_URI)
{
	if (a_URI)
	{
		setValue(a_URI);
	}
}
///////////////////////////////////////////////////////////////////////////////////




///////////////////////////////////////////////////////////////////////////////////
// class sdpOrigin : public sdpElement
///////////////////////////////////////////////////////////////////////////////////
sdpOrigin::sdpOrigin() : sdpElement('o')
{
}

void sdpOrigin::clear()
{
	m_Address.set("");
	m_AddressType.set("");
	m_NetworkType.set("");
	m_SessionId.set("");
	m_UserName.set("");
	m_Version.set("");
	sdpElement::clear();
}

void sdpOrigin::setString(const char* a_String)
{
	if (a_String)
	{
		sdpElement::setString(a_String);
		decode();
	}
}

void sdpOrigin::decode()
{
	if (getString() && (strlen(getString())>2) )
	{
		m_UserName.set(getString()+sizeof(char)*2);
		char* pTemp;
		pTemp = (char *)strchr(m_UserName.get(),' ');
		if (pTemp)
		{
			pTemp[0]='\0';
			pTemp = pTemp + sizeof(char);
			m_SessionId.set(pTemp);
		}
		pTemp = (char *)strchr(m_SessionId.get(),' ');
		if (pTemp)
		{
			pTemp[0]='\0';
			pTemp = pTemp + sizeof(char);
			m_Version.set(pTemp);
		}
		pTemp = (char *)strchr(m_Version.get(),' ');
		if (pTemp)
		{
			pTemp[0]='\0';
			pTemp = pTemp + sizeof(char);
			m_NetworkType.set(pTemp);
		}
		pTemp = (char *)strchr(m_NetworkType.get(),' ');
		if (pTemp)
		{
			pTemp[0]='\0';
			pTemp = pTemp + sizeof(char);
			m_AddressType.set(pTemp);
		}
		pTemp = (char *)strchr(m_AddressType.get(),' ');
		if (pTemp)
		{
			pTemp[0]='\0';
			pTemp = pTemp + sizeof(char);
			m_Address.set(pTemp);
		}
	}
}

void sdpOrigin::encode()
{
	int len = 0;
	len = len + m_UserName.len();
	len = len + m_SessionId.len();
	len = len + m_Version.len();
	len = len + m_NetworkType.len();
	len = len + m_AddressType.len();
	len = len + m_Address.len();

	char* NewOrigin = new char[len+8];
	sprintf(NewOrigin,"o=%s %s %s %s %s %s",m_UserName.get(),m_SessionId.get(),m_Version.get(),m_NetworkType.get(),m_AddressType.get(),m_Address.get());
	sdpElement::setString(NewOrigin);
	delete []NewOrigin;
}

const char* sdpOrigin::getAddress()
{
	return m_Address.get();
}

const char* sdpOrigin::getAddressType()
{
	return m_AddressType.get();
}

const char* sdpOrigin::getNetworkType()
{
	return m_NetworkType.get();
}

const char* sdpOrigin::getSessionId()
{
	return m_SessionId.get();
}

const char* sdpOrigin::getUserName()
{
	return m_UserName.get();
}

const char* sdpOrigin::getVersion()
{
	return m_Version.get();
}

void sdpOrigin::setAddress(const char* a_Address)
{
	if (a_Address)
	{
		m_Address.set(a_Address);
		encode();
	}
}

void sdpOrigin::setAddressType(const char* a_AddressType)
{
	if (a_AddressType)
	{
		m_AddressType.set(a_AddressType);
		encode();
	}
}

void sdpOrigin::setNetworkType(const char* a_NetworkType)
{
	if (a_NetworkType)
	{
		m_NetworkType.set(a_NetworkType);
		encode();
	}
}

void sdpOrigin::setSessionId(const char* a_SessionId)
{
	if (a_SessionId)
	{
		m_SessionId.set(a_SessionId);
		encode();
	}
}

void sdpOrigin::setUserName(const char* a_UserName)
{
	if (a_UserName)
	{
		m_UserName.set(a_UserName);
		encode();
	}
}

void sdpOrigin::setVersion(const char* a_Version)
{
	if (a_Version)
	{
		m_Version.set(a_Version);
		encode();
	}
}
///////////////////////////////////////////////////////////////////////////////////




///////////////////////////////////////////////////////////////////////////////////
// class sdpPhoneNumber : public sdpElement
///////////////////////////////////////////////////////////////////////////////////
sdpPhoneNumber::sdpPhoneNumber() : sdpElement('p')
{
}
const char* sdpPhoneNumber::getNumber()
{
	return getValue();
}

void sdpPhoneNumber::setNumber(const char* a_Number)
{
	if (a_Number)
	{
		setValue(a_Number);
	}
}
///////////////////////////////////////////////////////////////////////////////////




///////////////////////////////////////////////////////////////////////////////////
// class sdpTimezoneAdjustment : public sdpElement
sdpTimezoneAdjustment::sdpTimezoneAdjustment() : sdpElement('z')
{
	m_pAdjustmentTimes = NULL;
	m_pOffsets = NULL;
	m_NumAdjustment = 0;
}

sdpTimezoneAdjustment::~sdpTimezoneAdjustment()
{
	clear();
}

void sdpTimezoneAdjustment::clear()
{
	int i=0;
	for (i=0;i<m_NumAdjustment;i++)
	{
		delete m_pAdjustmentTimes[i];
		delete m_pOffsets[i];
	}
	delete m_pAdjustmentTimes;
	delete m_pOffsets;

	m_NumAdjustment = 0;
	m_pAdjustmentTimes = NULL;
	m_pOffsets = NULL;

	sdpElement::clear();
}

void sdpTimezoneAdjustment::setString(const char* a_String)
{
	if (a_String)
	{
		sdpElement::setString(a_String);
		decode();
	}
}

void sdpTimezoneAdjustment::decode()
{
	if (getString() && (strlen(getString())>2) )
	{
		char* pData = new char[strlen(getString())+1];
		strcpy(pData,getString() + sizeof(char)*2);
		
		sdpElementString AdjustmentTime;
		sdpElementString Offset;

		char* pTemp = pData;

		while (pTemp)
		{
			pTemp = strchr(pTemp,' ');
			if (pTemp)
			{
				pTemp[0]='\0';
				AdjustmentTime.set(pData);
				pTemp = pTemp + sizeof(char);
				strcpy(pData,pTemp);
			
				pTemp = strchr(pData,' ');
				if (pTemp)
				{
					pTemp[0]='\0';
					Offset.set(pData);
					pTemp = pTemp + sizeof(char);
					strcpy(pData,pTemp);
				}
				else
				{
					Offset.set(pData);
				}
				addAdjustment(AdjustmentTime.get(),Offset.get());
			}
		}

		delete []pData;
	}
}

void sdpTimezoneAdjustment::encode()
{
	int len=0;
	int i=0;

	for (i=0;i<m_NumAdjustment;i++)
	{
		len = len + m_pAdjustmentTimes[i]->len();
		len = len + m_pOffsets[i]->len();
	}

	char* NewTimezoneAdjustment = new char[len + m_NumAdjustment*2 + 4];

	sprintf(NewTimezoneAdjustment,"z=");
	for (i=0;i<m_NumAdjustment;i++)
	{
		if (i==0)
		{
			sprintf(NewTimezoneAdjustment,"%s%s %s",NewTimezoneAdjustment,m_pAdjustmentTimes[i]->get(),m_pOffsets[i]->get());
		}
		else
		{
			sprintf(NewTimezoneAdjustment,"%s %s %s",NewTimezoneAdjustment,m_pAdjustmentTimes[i]->get(),m_pOffsets[i]->get());
		}
	}
	
	sdpElement::setString(NewTimezoneAdjustment);
	delete []NewTimezoneAdjustment;
}

int sdpTimezoneAdjustment::addAdjustment(const char* a_AdjustmentTime, const char* a_Offset)
{
	if (a_AdjustmentTime && a_Offset)
	{
		if (m_pAdjustmentTimes == NULL)
		{
			m_pAdjustmentTimes = (sdpElementString**)malloc(sizeof(sdpElementString*));
		}
		else
		{
			m_pAdjustmentTimes = (sdpElementString**)realloc( m_pAdjustmentTimes,sizeof(sdpElementString) * (m_NumAdjustment+1) );
		}
		if (m_pOffsets == NULL)
		{
			m_pOffsets = (sdpElementString**)malloc(sizeof(sdpElementString*));
		}
		else
		{
			m_pOffsets = (sdpElementString**)realloc( m_pOffsets,sizeof(sdpElementString) * (m_NumAdjustment+1) );
		}

		sdpElementString* pAdjustmentTime = new sdpElementString;
		sdpElementString* pOffset = new sdpElementString;

		m_pAdjustmentTimes[m_NumAdjustment] = pAdjustmentTime;
		m_pOffsets[m_NumAdjustment] = pOffset;

		m_NumAdjustment++;

		pAdjustmentTime->set(a_AdjustmentTime);
		pOffset->set(a_Offset);

		encode();
	}
	return m_NumAdjustment;
}

int sdpTimezoneAdjustment::deleteAdjustment(const char* a_AdjustmentTime, const char* a_Offset)
{
	int i=0;
	int j=0;
	if (a_AdjustmentTime && a_Offset)
	{
		for (i=0;i<m_NumAdjustment;i++)
		{
			if (!strcmp(a_AdjustmentTime,m_pAdjustmentTimes[i]->get()))
			{
				if (!strcmp(a_Offset,m_pOffsets[i]->get()))
				{
					delete m_pAdjustmentTimes[i];
					for (j=i;j<m_NumAdjustment-1;j++)
					{
						m_pAdjustmentTimes[j] = m_pAdjustmentTimes[j+1];
					}
					delete m_pOffsets[i];
					for (j=i;j<m_NumAdjustment-1;j++)
					{
						m_pOffsets[j] = m_pOffsets[j+1];
					}
					m_NumAdjustment--;
					encode();
				}
			}
		}
	}
	return m_NumAdjustment;
}

const char* sdpTimezoneAdjustment::getAdjustmentTime(int a_Index)
{
	const char* pTime = NULL;
	if (a_Index < m_NumAdjustment)
	{
		pTime = m_pAdjustmentTimes[a_Index]->get();
	}
	return pTime;
}

const char* sdpTimezoneAdjustment::getOffset(int a_Index)
{
	const char* pOffset = NULL;
	if (a_Index < m_NumAdjustment)
	{
		pOffset = m_pOffsets[a_Index]->get();
	}
	return pOffset;
}

int sdpTimezoneAdjustment::getNumAdjustment()
{
	return m_NumAdjustment;
}
///////////////////////////////////////////////////////////////////////////////////




///////////////////////////////////////////////////////////////////////////////////
// class sdpEmailAddress : public sdpElement
///////////////////////////////////////////////////////////////////////////////////
sdpEmailAddress::sdpEmailAddress() : sdpElement('e')
{
}

const char* sdpEmailAddress::getEmail()
{
	return getValue();
}

void sdpEmailAddress::setEmail(const char* a_Email)
{
	if (a_Email)
	{
		setValue(a_Email);
	}
}
///////////////////////////////////////////////////////////////////////////////////




///////////////////////////////////////////////////////////////////////////////////
// class sdpEncryptionKey : public sdpElement
///////////////////////////////////////////////////////////////////////////////////
sdpEncryptionKey::sdpEncryptionKey() : sdpElement('k')
{
}

void sdpEncryptionKey::clear()
{
	m_Method.set("");
	m_Key.set("");

	sdpElement::clear();
}

void sdpEncryptionKey::setString(const char* a_String)
{
	if (!a_String)
	{
		return;
	}
	sdpElement::setString(a_String);
	decode();
}

void sdpEncryptionKey::decode()
{
	if ( getString() && (strlen(getString())>2) )
	{
		m_Method.set(getString()+sizeof(char)*2);

		char* pTemp;
		pTemp = (char *)strchr(m_Method.get(),':');
		if (pTemp)
		{
			pTemp[0]='\0';
			pTemp = pTemp + sizeof(char);
			m_Key.set(pTemp);
		}
	}
}

void sdpEncryptionKey::encode()
{
	int len = 0;
	len = len + m_Method.len();
	len = len + m_Key.len();

	char* NewEncryptionKey = new char[len+4];
	if (m_Key.len())
	{
		sprintf(NewEncryptionKey,"k=%s:%s",m_Method.get(),m_Key.get());
	}
	else
	{
		sprintf(NewEncryptionKey,"k=%s",m_Method.get());
	}
	sdpElement::setString(NewEncryptionKey);
	delete []NewEncryptionKey;
}

const char* sdpEncryptionKey::getMethod()
{
	return m_Method.get();
}

const char* sdpEncryptionKey::getKey()
{
	return m_Key.get();
}

void sdpEncryptionKey::setMethod(const char* a_Method)
{
	if (a_Method)
	{
		m_Method.set(a_Method);
		encode();
	}
}

void sdpEncryptionKey::setKey(const char* a_Key)
{
	if (a_Key)
	{
		m_Key.set(a_Key);
		encode();
	}
}
///////////////////////////////////////////////////////////////////////////////////




///////////////////////////////////////////////////////////////////////////////////
// class sdpBandwidth : public sdpElement
///////////////////////////////////////////////////////////////////////////////////
sdpBandwidth::sdpBandwidth() : sdpElement('b')
{
}

void sdpBandwidth::clear()
{
	m_Modifier.set("");
	m_BandwidthValue.set("");

	sdpElement::clear();
}

void sdpBandwidth::setString(const char* a_String)
{
	if (!a_String)
	{
		return;
	}
	sdpElement::setString(a_String);
	decode();
}

void sdpBandwidth::decode()
{
	if (getString() && (strlen(getString())>2) )
	{
		m_Modifier.set(getString()+sizeof(char)*2);

		char* pTemp;
		pTemp = (char *)strchr(m_Modifier.get(),':');
		if (pTemp)
		{
			pTemp[0]='\0';
			pTemp = pTemp + sizeof(char);
			m_BandwidthValue.set(pTemp);
		}
	}
}

void sdpBandwidth::encode()
{
	int len = 0;
	len = len + m_Modifier.len();
	len = len + m_BandwidthValue.len();

	char* NewBandwidth = new char[len+4];
	if (m_BandwidthValue.len())
	{
		sprintf(NewBandwidth,"b=%s:%s",m_Modifier.get(),m_BandwidthValue.get());
	}
	else
	{
		sprintf(NewBandwidth,"b=%s",m_Modifier.get());
	}
	sdpElement::setString(NewBandwidth);
	delete []NewBandwidth;
}

const char* sdpBandwidth::getModifier()
{
	return m_Modifier.get();
}

const char* sdpBandwidth::getBandwidthValue()
{
	return m_BandwidthValue.get();
}

void sdpBandwidth::setModifier(const char* a_Modifier)
{
	if (a_Modifier)
	{
		m_Modifier.set(a_Modifier);
		encode();
	}
}

void sdpBandwidth::setBandwidthValue(const char* a_BandwidthValue)
{
	if (a_BandwidthValue)
	{
		m_BandwidthValue.set(a_BandwidthValue);
		encode();
	}
}
///////////////////////////////////////////////////////////////////////////////////




///////////////////////////////////////////////////////////////////////////////////
// class sdpConnection : public sdpElement
///////////////////////////////////////////////////////////////////////////////////
sdpConnection::sdpConnection() : sdpElement('c')
{
}

void sdpConnection::clear()
{
	m_Address.set("");
	m_AddressType.set("");
	m_NetworkType.set("");

	sdpElement::clear();
}

void sdpConnection::setString(const char* a_String)
{
	if (!a_String)
	{
		return;
	}
	sdpElement::setString(a_String);
	decode();
}

void sdpConnection::decode()
{
	if (getString() && (strlen(getString())>2) )
	{
		m_NetworkType.set(getString()+sizeof(char)*2);
		char* pTemp;
		pTemp = (char *)strchr(m_NetworkType.get(),' ');
		if (pTemp)
		{
			pTemp[0]='\0';
			pTemp = pTemp + sizeof(char);
			m_AddressType.set(pTemp);
		}
		pTemp = (char *)strchr(m_AddressType.get(),' ');
		if (pTemp)
		{
			pTemp[0]='\0';
			pTemp = pTemp + sizeof(char);
			m_Address.set(pTemp);
		}
	}
}

void sdpConnection::encode()
{
	int len = 0;
	len = len + m_NetworkType.len();
	len = len + m_AddressType.len();
	len = len + m_Address.len();

	char* NewConnection = new char[len+5];
	sprintf(NewConnection,"c=%s %s %s",m_NetworkType.get(),m_AddressType.get(),m_Address.get());
	sdpElement::setString(NewConnection);
	delete []NewConnection;
}

const char* sdpConnection::getAddress()
{
	return m_Address.get();
}

const char* sdpConnection::getAddressType()
{
	return m_AddressType.get();
}

const char* sdpConnection::getNetworkType()
{
	return m_NetworkType.get();
}

void sdpConnection::setAddress(const char* a_Address)
{
	if (a_Address)
	{
		m_Address.set(a_Address);
		encode();
	}
}

void sdpConnection::setAddressType(const char* a_AddressType)
{
	if (a_AddressType)
	{
		m_AddressType.set(a_AddressType);
		encode();
	}
}

void sdpConnection::setNetworkType(const char* a_NetworkType)
{
	if (a_NetworkType)
	{
		m_NetworkType.set(a_NetworkType);
		encode();
	}
}
///////////////////////////////////////////////////////////////////////////////////


///////////////////////////////////////////////////////////////////////////////////
////// class sdpCryptoSessionParm : public sdpElement
///////////////////////////////////////////////////////////////////////////////////

sdpCryptoSessionParm::sdpCryptoSessionParm(const char *name, 
					const char *value) : sdpElement('a')
{
	m_Name.set(name);
	m_Value.set(value);
}
///////////////////////////////////////////////////////////////////////////////////

///////////////////////////////////////////////////////////////////////////////////
////// class sdpCryptoAttribute : public sdpAttribute
///////////////////////////////////////////////////////////////////////////////////

void sdpCryptoAttribute::clear()
{
	m_tag.set("");
	m_cryptoSuite.set("");
	m_sdpCryptoKeyParmList.clear();
	m_sdpCryptoSessionParmList.clear();

	sdpAttribute::clear();
}

void sdpCryptoAttribute::decode()
{
	const char* pString = getString();
	int len = strlen(pString);
	int count=0;
	char tokenDelimiter;
	int pCharOffset;

	sdpAttribute::decode();

	if (pString && (len>6))
	{
		char *pChar = new char [len+1];
		char *pCharOrig = pChar;
		sdpCryptoKeyParm* pCryptoKeyParm = NULL;
		char *pCharEqual;
		sdpCryptoSessionParm* pCryptoSessionParm;

		strcpy(pChar, pString);
		pChar = strtok (pChar,":|; ");
		while (pChar != NULL)
		{
			if(*pChar == '\0')
				continue;

			switch(count)
			{
				case 0:
					break;

				case 1:
					m_tag.set(pChar);
					break;

				case 2:
					m_cryptoSuite.set(pChar);
					break;

				default:
					if((pCharEqual = strchr(pChar, '=')) != NULL)
					{
						// This means we are now going through the session parameters.
						*pCharEqual = '\0';
						pCryptoSessionParm = new sdpCryptoSessionParm(pChar, pCharEqual+1);
						m_sdpCryptoSessionParmList.addItem(pCryptoSessionParm);
						*pCharEqual = '=';
						count = 2;
						break;
					}

					pCharOffset = pChar-pCharOrig;
					tokenDelimiter = *(pString+pCharOffset+strlen(pChar));

					if(count == 3 && 
						(tokenDelimiter == ' ' || tokenDelimiter == '\0'))
					{
						// This is a session parameter with out value.
						pCryptoSessionParm = new sdpCryptoSessionParm(pChar, NULL);
						m_sdpCryptoSessionParmList.addItem(pCryptoSessionParm);
						count = 2;
						break;
					}

					switch((count-3)%5)
					{
						case 0:
							pCryptoKeyParm = new sdpCryptoKeyParm();
							pCryptoKeyParm->setKeyMethod(pChar);
							break;
						case 1:
							pCryptoKeyParm->setKey(pChar);
							break;
						case 2:
							if(tokenDelimiter != ':')
							{
								// Key life time parameter is present and
								// is in the current token.
								pCryptoKeyParm->setKeyLifeTime(pChar);
							}
							else
							{
								// Key life time parameter is absent and 
								// the current token is MKI.
								pCryptoKeyParm->setMasterKeyIdentifier(pChar);
								count++;
							}
							break;
						case 3:
							pCryptoKeyParm->setMasterKeyIdentifier(pChar);
							break;
						case 4:
							pCryptoKeyParm->setMasterKeyIdentifierLength(pChar);
							m_sdpCryptoKeyParmList.addItem(pCryptoKeyParm);
							pCryptoKeyParm = NULL;
							count = 2;
							break;
					}

					if(tokenDelimiter == ';')
					{
						// The next token will be the beginning of next key parm.
						// So reset the counter and add the key parm to the list if
						// not added already.
						count = 2;
						if(pCryptoKeyParm != NULL)
						{
							m_sdpCryptoKeyParmList.addItem(pCryptoKeyParm);
							pCryptoKeyParm = NULL;
						}
					}
					else if(tokenDelimiter == ' ')
					{
						// end of key-param
						count = 2;
					}

					break;
			}

			pChar = strtok (NULL, ":|; ");
			count++;
		}

		if(pCryptoKeyParm != NULL)
		{
			m_sdpCryptoKeyParmList.addItem(pCryptoKeyParm);
			pCryptoKeyParm = NULL;
		}

		pChar = pCharOrig;
		delete []pChar;
	}
}

const char * sdpCryptoAttribute::getTag()
{
	return m_tag.get();
}

const char * sdpCryptoAttribute::getCryptoSuite()
{
	return m_cryptoSuite.get();
}

void sdpCryptoAttribute::addKeyParm(const char *keyMethod, const char *key,
			const char *keyLifeTime, const char *masterKeyIdentifier,
			const char *masterKeyIdentifierLength)
{
	sdpCryptoKeyParm *pCryptoKeyParm =  new sdpCryptoKeyParm(
											keyMethod, 
											key,
											keyLifeTime, 
											masterKeyIdentifier,
											masterKeyIdentifierLength);

	m_sdpCryptoKeyParmList.addItem(pCryptoKeyParm);
}

void sdpCryptoAttribute::clearKeyParms()
{
	m_sdpCryptoKeyParmList.clear();
}

void sdpCryptoAttribute::addSessionParm(const char *name, const char *value)
{
	sdpCryptoSessionParm *pCryptoSessionParm =  new sdpCryptoSessionParm(
											name, 
											value);
	m_sdpCryptoSessionParmList.addItem(pCryptoSessionParm);
}

void sdpCryptoAttribute::clearSessionParms()
{
	m_sdpCryptoSessionParmList.clear();
}

void sdpCryptoAttribute::setTag(const char* a_Tag)
{
	if (a_Tag)
	{
		m_tag.set(a_Tag);
	}
}

void sdpCryptoAttribute::setCryptoSuite(const char* a_CryptoSuite)
{
	if (a_CryptoSuite)
	{
		m_cryptoSuite.set(a_CryptoSuite);
	}
}

void sdpCryptoAttribute::encode()
{
	char* NewAttribute = new char[MAX_CRYPTO_ATTRIBUTE_LENGTH];
	char *pChar;
	int i;

	sprintf(NewAttribute, "%s", "a=crypto:");

	// Now add the key tag.
	strcat(NewAttribute, m_tag.get());
	strcat(NewAttribute, " ");

	// Now add the crypto suite name
	strcat(NewAttribute, m_cryptoSuite.get());
	strcat(NewAttribute, " ");

	// Now Add all the key parameters
	for(i=0; i<m_sdpCryptoKeyParmList.numItem(); i++)
	{
		// Get the crypto parameter at index i from the list.
		sdpCryptoKeyParm* pCryptoKeyParm = m_sdpCryptoKeyParmList.getItem(i);
		
		if(i != 0)
		{
			// Here ';' is a key parameter seperator.
			strcat(NewAttribute, ";");
		}

		// Now add the key method of the key parameter.
		strcat(NewAttribute, pCryptoKeyParm->getKeyMethod().get());
		strcat(NewAttribute, ":");

		// Now add the actual key of the key parameter.
		strcat(NewAttribute, pCryptoKeyParm->getKey().get());

		// Now add the key life time of the key parameter if present.
		// key life time is an optional parameter.
		if(pCryptoKeyParm->getKeyLifeTime().len() > 0)
		{
			strcat(NewAttribute, "|");
			strcat(NewAttribute, pCryptoKeyParm->getKeyLifeTime().get());
		}

		// Now add the MKI and MKI length key parameters.
		// These two are also optional parameters.
		if(pCryptoKeyParm->getMasterKeyIdentifier().len() > 0 &&
			pCryptoKeyParm->getMasterKeyIdentifierLength().len() > 0)
		{
			strcat(NewAttribute, "|");
			strcat(NewAttribute, pCryptoKeyParm->getMasterKeyIdentifier().get());
			strcat(NewAttribute, ":");
			strcat(NewAttribute, pCryptoKeyParm->getMasterKeyIdentifierLength().get());
		}
	}

	// Now add the session parameters. These are optional.
	int numSessionParms = m_sdpCryptoSessionParmList.numItem();
	for(i=0; i<numSessionParms; i++)
	{
		sdpCryptoSessionParm* pCryptoSessionParm = m_sdpCryptoSessionParmList.getItem(i);
		const char *pValue;
		
		strcat(NewAttribute, " ");
		strcat(NewAttribute, pCryptoSessionParm->getName());

		if ((pValue = pCryptoSessionParm->getValue()) != NULL &&
			(*pValue != '\0'))
		{
			strcat(NewAttribute, "=");
			strcat(NewAttribute, pValue);
		}
	}

	sdpElement::setString(NewAttribute);

	setPropertyWithoutEncode("crypto");

	pChar = strchr(NewAttribute, ':');
	pChar++;
	setPropertyValueWithoutEncode(pChar);

	delete []NewAttribute;
}
///////////////////////////////////////////////////////////////////////////////////

///////////////////////////////////////////////////////////////////////////////////
// class sdpAttribute : public sdpElement
///////////////////////////////////////////////////////////////////////////////////
sdpAttribute::sdpAttribute() : sdpElement('a')
{
}

void sdpAttribute::clear()
{
	m_Property.set("");
	m_PropertyValue.set("");

	sdpElement::clear();
}
	
void sdpAttribute::setString(const char* a_String)
{
	if (!a_String)
	{
		return;
	}
	sdpElement::setString(a_String);
	decode();
}

void sdpAttribute::decode()
{
	if (getString() && (strlen(getString())>2) )
	{
		m_Property.set(getString()+sizeof(char)*2);

		char* pTemp;
		pTemp = (char *)strchr(m_Property.get(),':');
		if (pTemp)
		{
			pTemp[0]='\0';
			pTemp = pTemp + sizeof(char);
			m_PropertyValue.set(pTemp);
		}
	}
}

void sdpAttribute::encode()
{
	int len = 0;
	len = len + m_Property.len();
	len = len + m_PropertyValue.len();

	char* NewAttribute = new char[len+4];
	if (m_PropertyValue.len())
	{
		sprintf(NewAttribute,"a=%s:%s",m_Property.get(),m_PropertyValue.get());
	}
	else
	{
		sprintf(NewAttribute,"a=%s",m_Property.get());
	}
	sdpElement::setString(NewAttribute);
	delete []NewAttribute;
}

const char* sdpAttribute::getProperty()
{
	return m_Property.get();
}

const char* sdpAttribute::getPropertyValue()
{
	return m_PropertyValue.get();
}

void sdpAttribute::setProperty(const char* a_Property)
{
	if (a_Property)
	{
		m_Property.set(a_Property);
		encode();
	}
}

void sdpAttribute::setPropertyValue(const char* a_PropertyValue)
{
	if (a_PropertyValue)
	{
		m_PropertyValue.set(a_PropertyValue);
		encode();
	}
}
///////////////////////////////////////////////////////////////////////////////////




///////////////////////////////////////////////////////////////////////////////////
// class sdpMediaTitle : public sdpElement
///////////////////////////////////////////////////////////////////////////////////
sdpMediaTitle::sdpMediaTitle() : sdpElement('i')
{
}

const char* sdpMediaTitle::getTitle()
{
	return getValue();
}

void sdpMediaTitle::setTitle(const char* a_Title)
{
	if (a_Title)
	{
		setValue(a_Title);
	}
}
///////////////////////////////////////////////////////////////////////////////////




///////////////////////////////////////////////////////////////////////////////////
// class sdpMedia : public sdpElement
///////////////////////////////////////////////////////////////////////////////////
sdpMedia::sdpMedia() : sdpElement('m')
{
	m_NumFormat = 0;
	m_NumPorts = 0;
	m_Port = 0;
	m_pFormats = NULL;
}

sdpMedia::~sdpMedia()
{
	clear();
}

void sdpMedia::clear()
{
	int i=0;

	m_Media.set("");
	m_Transport.set("");
	m_NumPorts = 0;
	m_Port = 0;

	for (i=0;i<m_NumFormat;i++)
	{
		delete m_pFormats[i];
	}
	delete m_pFormats;
	m_NumFormat = 0;
	m_pFormats = NULL;

	sdpElement::clear();
}

void sdpMedia::setString(const char* a_String)
{
	if (!a_String)
	{
		return;
	}
	sdpElement::setString(a_String);
	decode();
}

void sdpMedia::decode()
{
	if (getString() && (strlen(getString())>2) )
	{
		sdpElementString Port;
		sdpElementString Formats;

		m_Media.set(getString()+sizeof(char)*2);
		char* pTemp;
		pTemp = (char *)strchr(m_Media.get(),' ');
		if (pTemp)
		{
			pTemp[0]='\0';
			pTemp = pTemp + sizeof(char);
			Port.set(pTemp);
			sscanf(Port.get(),"%ld",&m_Port);
			m_NumPorts = 1;
		}
		pTemp = (char *)strchr(Port.get(),' ');
		if (pTemp)
		{
			pTemp[0]='\0';
			pTemp = pTemp + sizeof(char);
			m_Transport.set(pTemp);
		}
		pTemp = (char *)strchr(m_Transport.get(),' ');
		if (pTemp)
		{
			pTemp[0]='\0';
			Formats.set(pTemp + sizeof(char));
		}

		char* pFormats = (char*)Formats.get();
		while (pTemp)
		{
			pTemp = (char *)strchr(pFormats,' ');
			if (pTemp)
			{
				pTemp[0]='\0';
				addFormat(pFormats);
				pFormats = pTemp + sizeof(char);
			}
			else
			{
				addFormat(pFormats);
			}
		}
	}
}

void sdpMedia::encode()
{
	int i=0;
	int len=0,l_iTempSize=0;
	int l_iBufSize;
	len = len + m_Media.len();
	len = len + m_Transport.len();

	l_iBufSize = ((len+14+10)*5);
  
	char* NewMedia = new char[l_iBufSize];
	if (m_NumPorts < 2)
	{
		sprintf(NewMedia,"m=%s %ld %s",m_Media.get(),m_Port,m_Transport.get());
	}
	else
	{
		sprintf(NewMedia,"m=%s %ld/%d %s",m_Media.get(),m_Port,m_NumPorts,m_Transport.get());
	}
	//Calculate the size of NewMedia at this point
	l_iTempSize=strlen(NewMedia);

	for (i=0;i<m_NumFormat;i++)
	{
		l_iTempSize += m_pFormats[i]->len();
		//Add two to l_iTempSize because the sprintf below adds a space and NULL char
		if((l_iTempSize +2) < (l_iBufSize)) {
		   sprintf(NewMedia,"%s %s",NewMedia,m_pFormats[i]->get());
		}else {
		   break;
		}
	}
	sdpElement::setString(NewMedia);
	delete []NewMedia;
}

const char* sdpMedia::getFormat(int a_Index)
{
	const char* pFormat = NULL;
	if (a_Index < m_NumFormat)
	{
		pFormat = m_pFormats[a_Index]->get();
	}
	return pFormat;
}

const char* sdpMedia::getMedia()
{
	return m_Media.get();
}

int sdpMedia::getNumFormat()
{
	return m_NumFormat;
}

int sdpMedia::getNumPorts()
{
	return m_NumPorts;
}

long sdpMedia::getPort()
{
	return m_Port;
}

const char* sdpMedia::getTransport()
{
	return m_Transport.get();
}

int sdpMedia::addFormat(const char* a_Format)
{
	if (a_Format)
	{
		if (m_pFormats == NULL)
		{
			m_pFormats = (sdpElementString**)malloc(sizeof(sdpElementString*));
		}
		else
		{
			m_pFormats = (sdpElementString**)realloc( m_pFormats,sizeof(sdpElementString) * (m_NumFormat+1) );
		}

		sdpElementString* pFormat = new sdpElementString;
		m_pFormats[m_NumFormat] = pFormat;
		m_NumFormat++;

		pFormat->set(a_Format);
		encode();
	}
	return m_NumFormat;
}

int sdpMedia::deleteFormat(const char* a_Format)
{
	int i=0;
	int j=0;
	if (a_Format)
	{
		for (i=0;i<m_NumFormat;i++)
		{
			if (!strcmp(a_Format,m_pFormats[i]->get()))
			{
				delete m_pFormats[i];
				for (j=i;j<m_NumFormat-1;j++)
				{
					m_pFormats[j] = m_pFormats[j+1];
				}
				m_NumFormat--;
				encode();
			}
		}
	}
	return m_NumFormat;
}

void sdpMedia::setMedia(const char* a_Media)
{
	if (a_Media)
	{
		m_Media.set(a_Media);
		encode();
	}
}

void sdpMedia::setNumPorts(int a_NumPorts)
{
	m_NumPorts = a_NumPorts;
	encode();
}

void sdpMedia::setPort(long a_Port)
{
	m_Port = a_Port;
	encode();
}

void sdpMedia::setTransport(const char* a_Transport)
{
	if (a_Transport)
	{
		m_Transport.set(a_Transport);
		encode();
	}
}
///////////////////////////////////////////////////////////////////////////////////




