/**********@@@SOFT@@@WARE@@@COPY@@@RIGHT@@@**********************************
* DIALOGIC CONFIDENTIAL
*
* Copyright (C) 2007 Dialogic Corporation. All Rights Reserved.
* The source code contained or described herein and all documents related
* to the source code ("Material") are owned by Dialogic Corporation or its
* suppliers or licensors. Title to the Material remains with Dialogic Corporation
* or its suppliers and licensors. The Material contains trade secrets and
* proprietary and confidential information of Dialogic or its suppliers and
* licensors. The Material is protected by worldwide copyright and trade secret
* laws and treaty provisions. No part of the Material may be used, copied,
* reproduced, modified, published, uploaded, posted, transmitted, distributed,
* or disclosed in any way without Dialogic's prior express written permission.
*
* No license under any patent, copyright, trade secret or other intellectual
* property right is granted to or conferred upon you by disclosure or delivery
* of the Materials, either expressly, by implication, inducement, estoppel or
* otherwise. Any license under such intellectual property rights must be
* express and approved by Dialogic in writing.
*
***********************************@@@SOFT@@@WARE@@@COPY@@@RIGHT@@@**********/

#ifndef SDP_ELEMENTS_DEFINE
#define SDP_ELEMENTS_DEFINE

#define MAX_CRYPTO_ATTRIBUTE_LENGTH 2048

///////////////////////////////////////////////////////////////////////////////////
//  sdpElementString class. 
///////////////////////////////////////////////////////////////////////////////////
class sdpElementString
{
public:
	sdpElementString();
	sdpElementString(const char *pString);
	~sdpElementString();
public:
	void		set(const char* a_String);
	const char*	get();
	int			len();
private:
	char*		m_pString;
};
///////////////////////////////////////////////////////////////////////////////////




///////////////////////////////////////////////////////////////////////////////////
//!  Base sdpElement class. 
/*!  The base class that all other SDP elements inherit from, excluding sdpTimeDescription,
     sdpMediaDescription, and sdpSessionDescription. */
///////////////////////////////////////////////////////////////////////////////////
class sdpElement
{
public:
	sdpElement(char);
	virtual ~sdpElement();
public:
	//!  Clears value. 
	/*!  This method clears the values stored in the corresponding object.
	\return void */
	void			clear();
	//!  Returns value len. 
	/*!  This method returns the len of the value string stored in the cooresponding object.
	\return int		- length of string containing object data*/
	int				getLen();
	//!  Returns value. 
	/*!  This method returns the value stored in the corresponding object.
	\return const char*	- string containing object data */
	const char*		getValue();
	//!  Does value exist? 
	/*!  This method returns "true" if the value of the corresponding object has been set previously.
	\return bool	- true if data has been set.  false if not.*/
	bool			ifExists();
	//!  Sets value. 
	/*!  This method sets the values stored in the corresponding object.
	\param a_Value	- string containing data to set the object value to.
	\return void*/
	void			setValue(const char* a_Value);
private:
	char			m_Id;
protected:
	virtual void	setString(const char* a_String);
	const char*		getString();
private:
	sdpElementString	m_String;
friend class sdpSessionDescription;
};
///////////////////////////////////////////////////////////////////////////////////




///////////////////////////////////////////////////////////////////////////////////
//!  sdpVersion class. 
/*!  Associated with a 'v=' entry in the session description.*/
///////////////////////////////////////////////////////////////////////////////////
class sdpVersion : public sdpElement
{
public:
	sdpVersion();
public:
	//!  Returns the Version value. 
	/*!  This method returns the Version of the sdpVersion object.
	\return	const char*		- version from v= line*/
	const char*	getVersion();
	//!  Sets the Version value. 
	/*!  This method sets the Version of the sdpVersion object.
	\param	a_Version	- version for v= line
	\return	void */
	void		setVersion(const char* a_Version);
};
///////////////////////////////////////////////////////////////////////////////////




///////////////////////////////////////////////////////////////////////////////////
//!  sdpTime class. 
/*!  Associated with a 't=' entry in the time description.*/
class sdpTime : public sdpElement
{
public:
	sdpTime();
public:
	//!  Returns Start time. 
	/*!  This method returns the Start time of the cooresponding sdpTime object
	\return	unsigned long	- start time from t= line*/
	unsigned long	getStart();
	//!  Returns Stop time. 
	/*!  This method returns the Stop time of the cooresponding sdpTime object
	\return	unsigned long	- stop time from t= line*/
	unsigned long	getStop();
	//!  Sets Start time. 
	/*!  This method sets the Start time of the cooresponding sdpTime object
	\param	a_Start	- start time for the t= line
	\return	void */
	void			setStart(unsigned long a_Start);
	//!  Sets Stop time. 
	/*!  This method sets the Stop time of the cooresponding sdpTime object
	\param	a_Stop	- stop time for the t= line
	\return	void */
	void			setStop(unsigned long a_Stop);
	void			clear();
private:
	unsigned long	m_Start;
	unsigned long	m_Stop;
protected:  // sdpElement overrides
	void			setString(const char*);
	void			decode();
	void			encode();
friend class sdpSessionDescription;
};
///////////////////////////////////////////////////////////////////////////////////




///////////////////////////////////////////////////////////////////////////////////
//!  sdpRepeatTimes class. 
/*!  Associated with a 'r=' entry in the time description.*/
class sdpRepeatTimes : public sdpElement
{
public:
	sdpRepeatTimes();
public:
	//!  Returns the Duration. 
	/*!  This method returns the Repeat Duration portion of the sdpRepeatTimes object
	\return	const char*	- repeat duration from the r= line	 */
	const char*	getDuration();
	//!  Returns the Interval. 
	/*!  This method returns the Repeat Interval portion of the sdpRepeatTimes object
	\return	const char*	- repeat interval from the r= line*/
	const char*	getInterval();
	//!  Returns the Offsets. 
	/*!  This method returns the Repeat Offsets portion of the sdpRepeatTimes object
	\return	const char*	- repeat offsets from the r= line */
	const char*	getOffsets();
	//!  Sets the Duration. 
	/*!  This method sets the Repeat Duration portion of the sdpRepeatTimes object
	\param	a_Duration	- repeat duration for the r= line
	\return	void */
	void	setDuration(const char* a_Duration);
	//!  Sets the Interval. 
	/*!  This method sets the Repeat Interval portion of the sdpRepeatTimes object
	\param	a_Interval	- repeat interval for the r= line
	\return	void */
	void	setInterval(const char* a_Interval);
	//!  Sets the Offsets. 
	/*!  This method sets the Repeat Offsets portion of the sdpRepeatTimes object
	\param	a_Offsets	- repeat offsets for the r= line
	\return	void */
	void	setOffsets(const char* a_Offsets);
	void	clear();
private:
	sdpElementString	m_Interval;
	sdpElementString	m_Duration;
	sdpElementString	m_Offsets;
protected:  // sdpElement overrides
	void	setString(const char*);
	void	decode();
	void	encode();
friend class sdpSessionDescription;
};
///////////////////////////////////////////////////////////////////////////////////




///////////////////////////////////////////////////////////////////////////////////
//!  sdpSessionName class. 
/*!  Associated with a 's=' entry in the session description.*/
class sdpSessionName : public sdpElement
{
public:
	sdpSessionName();
public:
	//!  Returns the Session Name value. 
	/*!  This method returns the Session Name of the sdpSessionName object
	\return	const char*	- session name from the s= line  */
	const char*	getName();
	//!  Sets the Session Name value. 
	/*!  This method sets the Session Name of the sdpSessionName object
	\param	a_Name	- session name for the s= line
	\return	void */
	void		setName(const char* a_Name);
};
///////////////////////////////////////////////////////////////////////////////////




///////////////////////////////////////////////////////////////////////////////////
//!  sdpSessionInformation class. 
/*!  Associated with a 'i=' entry in the session description.*/
class sdpSessionInformation : public sdpElement
{
public:
	sdpSessionInformation();
public:
	//!  Returns the Session Information value. 
	/*!  This method returns the Session Information value of the sdpSessionInformation object
	\return	const char*	- session information from the i= line in a session description*/
	const char*	getInfo();
	//!  Sets the Session Information value. 
	/*!  This method sets the Session Information value of the sdpSessionInformation object
	\param	a_Info	- session information for the i= line in a session description
	\return	void */
	void		setInfo(const char* a_Info);
};
///////////////////////////////////////////////////////////////////////////////////




///////////////////////////////////////////////////////////////////////////////////
//!  sdpURI class. 
/*!  Associated with a 'u=' entry in the session description.*/
class sdpURI : public sdpElement
{
public:
	sdpURI();
public:
	//!  Returns the URI value. 
	/*!  This method returns the URI of the sdpURI object
	\return	const char*	- uri from the u= line */
	const char*	getURI();
	//!  Sets the URI value. 
	/*!  This method sets the URI value of the sdpURI object
	\param	a_URI		- uri for the u= line
	\return	void */
	void		setURI(const char* a_URI);
};
///////////////////////////////////////////////////////////////////////////////////




///////////////////////////////////////////////////////////////////////////////////
//!  sdpOrigin class. 
/*!  Associated with a 'o=' entry in the session description.*/
class sdpOrigin : public sdpElement
{
public:
	sdpOrigin();
public:
	//!  Returns the Origin Address value. 
	/*!  This method returns the Origin Address portion of the sdpOrigin object
	\return	const char*	- origin address from the o= line */
	const char*	getAddress();
	//!  Returns the Origin Address Type value. 
	/*!  This method returns the Origin Address Type portion of the sdpOrigin object
	\return	const char*	- origin address type from the o= line */
	const char*	getAddressType();
	//!  Returns the Origin Network Type value. 
	/*!  This method returns the Origin Network Type portion of the sdpOrigin object
	\return	const char*	- origin netowrk type from the o= line */
	const char*	getNetworkType();
	//!  Returns the Origin Session Id value. 
	/*!  This method returns the Origin Session Id portion of the sdpOrigin object
	\return	const char*	- origin session id from the o= line*/
	const char*	getSessionId();
	//!  Returns the Origin User Name value. 
	/*!  This method returns the Origin User Name portion of the sdpOrigin object
	\return	const char*	- origin user name from the o= line */
	const char*	getUserName();
	//!  Returns the Origin Version value. 
	/*!  This method returns the Origin Version portion of the sdpOrigin object
	\return	const char*	- origin version from the o= line */
	const char*	getVersion();
	//!  Sets the Origin Address value. 
	/*!  This method sets the Origin Address portion of the sdpOrigin object
	\param	a_Address	- origin address for the o= line
	\return	void */
	void	setAddress(const char* a_Address);
	//!  Sets the Origin Address Type value. 
	/*!  This method sets the Origin Address Type portion of the sdpOrigin object
	\param	a_AddressType	- origin address type for the o= line
	\return	void */
	void	setAddressType(const char* a_AddressType);
	//!  Sets the Origin Network Type value. 
	/*!  This method sets the Origin Network Type portion of the sdpOrigin object
	\param	a_NetworkType	- origin network type for the o= line
	\return	void */
	void	setNetworkType(const char* a_NetworkType);
	//!  Sets the Origin Session Id value. 
	/*!  This method sets the Origin Session Id portion of the sdpOrigin object
	\param	a_SessionId	- origin session id for the o= line
	\return	void */
	void	setSessionId(const char* a_SessionId);
	//!  Sets the Origin User Name value. 
	/*!  This method sets the Origin User Name portion of the sdpOrigin object
	\param	a_UserName	- origin user name for the o= line
	\return	void */
	void	setUserName(const char* a_UserName);
	//!  Sets the Origin Version value. 
	/*!  This method sets the Origin Version portion of the sdpOrigin object
	\param	a_Version	- origin version for the o= line
	\return	void */
	void	setVersion(const char* a_Version);
	void	clear();
private:
	sdpElementString m_Address;
	sdpElementString m_AddressType;
	sdpElementString m_NetworkType;
	sdpElementString m_SessionId;
	sdpElementString m_UserName;
	sdpElementString m_Version;
protected:  // sdpElement overrides
	void	setString(const char*);
	void	decode();
	void	encode();
friend class sdpSessionDescription;
};
///////////////////////////////////////////////////////////////////////////////////




///////////////////////////////////////////////////////////////////////////////////
//!  sdpPhoneNumber class. 
/*!  Associated with a 'p=' entry in the session description.*/
class sdpPhoneNumber : public sdpElement
{
public:
	sdpPhoneNumber();
public:
	//!  Returns the Phone Number value. 
	/*!  This method returns the Phone Number value of the sdpPhoneNumber object
	\return	const char*	- phone number from the p= line */
	const char*	getNumber();
	//!  Sets the Phone Number value. 
	/*!  This method sets the Phone Number value of the sdpPhoneNumber object
	\param	a_Number	- phone number for the p= line
	\return	void */
	void		setNumber(const char* a_Number);
};
///////////////////////////////////////////////////////////////////////////////////




///////////////////////////////////////////////////////////////////////////////////
//!  sdpTimezoneAdjustment class. 
/*!  Associated with a 'z=' entry in the session description.*/
class sdpTimezoneAdjustment : public sdpElement
{
public:
	sdpTimezoneAdjustment();
	~sdpTimezoneAdjustment();
public:
	//!  Adds a Timezone Adjustment value. 
	/*!  This method adds a new Timezone Adjustment value to the sdpTimezoneAdjustment object 
	\param	a_AdjustmentTime	- new time to add to the z= line
	\param	a_Offset			- new offset to add to the z= line
	\return	int			- total number of timezone adjustments now included in the sdpMedia object */
	int		addAdjustment(const char* a_AdjustmentTime, const char* a_Offset);
	//!  Deletes a Timezone Adjustment value. 
	/*!  This method deletes a Timezone Adjustment value from the sdpMedia object
	\param	a_AdjustmentTime	- existing adjustment time to delete from the sdpMedia object
	\param	a_Offset			- existing offset to delete from the sdpMedia object
	\return	int			- total number of timezone adjustments now included in the sdpMedia object */
	int		deleteAdjustment(const char* a_AdjustmentTime, const char* a_Offset);
	//!  Returns the Adjustment Time. 
	/*!  This method returns the Adjustment Time portion of the sdpTimezoneAdjustment object
	\param	a_Index	- index of adjustment time to retrieve.  The index is 0 based.
	\return	const char*	- adjustment time from the z= line */
	const char*	getAdjustmentTime(int a_Index);
	//!  Returns the Number of Timezone Adjustments. 
	/*!  This method returns the Number of Timezone Adjustments contained in the 'z=' line
	\return	int	- number of timezone adjustments include in the z= line */
	int		getNumAdjustment();
	//!  Returns the Offset value. 
	/*!  This method returns the Offset value portion of the sdpTimezoneAdjustment object
	\param	a_Index	- index of offset to retrieve.  The index is 0 based.
	\return	const char*	- offset from the z= line */
	const char*	getOffset(int a_Index);
	void	clear();
private:
	sdpElementString**	m_pAdjustmentTimes;
	sdpElementString**	m_pOffsets;
	int					m_NumAdjustment;
protected:  // sdpElement overrides
	void	setString(const char*);
	void	decode();
	void	encode();
friend class sdpSessionDescription;
};
///////////////////////////////////////////////////////////////////////////////////




///////////////////////////////////////////////////////////////////////////////////
//!  sdpEmailAddress class. 
/*!  Associated with a 'e=' entry in the session description.*/
class sdpEmailAddress : public sdpElement
{
public:
	sdpEmailAddress();
public:
	//!  Returns the Email Address. 
	/*!  This method returns the Email Address value of the sdpEmailAddress object
	\return	void	- email address from the e= line */
	const char*	getEmail();
	//!  Sets the Email Address.
	/*!  This method sets the Email Address value of the sdpEmailAddress object
	\param	a_Email	- email address for the e= line
	\return	void */
	void		setEmail(const char* a_Email);
};
///////////////////////////////////////////////////////////////////////////////////




///////////////////////////////////////////////////////////////////////////////////
//!  sdpEncryptionKey class. 
/*!  Associated with a 'k=' entry in the session description and media description.*/
class sdpEncryptionKey : public sdpElement
{
public:
	sdpEncryptionKey();
public:
	//!  Returns the Encryption Key value. 
	/*!  This method returns the Encryption Key value portion of the sdpEncryptionKey object
	\return	const char*	- encryption key from the k= line */
	const char*	getKey();
	//!  Returns the Encryption Method. 
	/*!  This method returns the Encryption Method portion of the sdpEncryptionKey object
	\return	const char*	- encryption method from the k= line */
	const char*	getMethod();
	//!  Sets the Encryption Key value. 
	/*!  This method sets the Encryption Key value portion of the sdpEncryptionKey object
	\param	a_Key		- encryption key for the k= line
	\return	void */
	void	setKey(const char* a_Key);
	//!  Sets the Encryption Method. 
	/*!  This method sets the Encryption Method portion of the sdpEncryptionKey object
	\param	a_Method	- encryption method for the k= line
	\return	void */
	void	setMethod(const char* a_Method);
	void	clear();
private:
	sdpElementString	m_Method;
	sdpElementString	m_Key;
protected:  // sdpElement overrides
	void	setString(const char*);
	void	decode();
	void	encode();
friend class sdpSessionDescription;
};
///////////////////////////////////////////////////////////////////////////////////




///////////////////////////////////////////////////////////////////////////////////
//!  sdpBandwidth class. 
/*!  Associated with a 'b=' entry in the session description and media description.*/
class sdpBandwidth : public sdpElement
{
public:
	sdpBandwidth();
public:
	//!  Returns the Bandwidth value. 
	/*!  This method returns the Bandwidth value portion of the sdpBandwidth object
	\return	const char*	- bandwidth value from the b= line */
	const char*	getBandwidthValue();
	//!  Returns the Bandwidth Modifier. 
	/*!  This method returns the Bandwidth Modifier portion of the sdpBandwidth object
	\return	const char*	- bandwidth modifier from the b= line */
	const char*	getModifier();
	//!  Sets the Bandwidth value. 
	/*!  This method sets the Bandwidth value portion of the sdpBandwidth object
	\param	a_Bandwidth	- bandwidth value for the b= line
	\return	void */
	void	setBandwidthValue(const char* a_Bandwidth);
	//!  Sets the Bandwidth Modifier. 
	/*!  This method sets the Bandwidth Modifier portion of the sdpBandwidth object
	\param	a_Modifier	- bandwidth modifier for the b= line
	\return	void */
	void	setModifier(const char* a_Modifier);
	void	clear();
private:
	sdpElementString	m_Modifier;
	sdpElementString	m_BandwidthValue;
protected:  // sdpElement overrides
	void	setString(const char*);
	void	decode();
	void	encode();
friend class sdpSessionDescription;
};
///////////////////////////////////////////////////////////////////////////////////




///////////////////////////////////////////////////////////////////////////////////
//!  sdpConnection class. 
/*!  Associated with a 'c=' entry in the session description and media description.*/
class sdpConnection : public sdpElement
{
public:
	sdpConnection();
public:
	//!  Returns the Connection Address value. 
	/*!  This method returns the Connection Address portion of the sdpConnection object
	\return	const char*	- connection address from the c= line */
	const char*	getAddress();
	//!  Returns the Connection Address Type value. 
	/*!  This method returns the Connection Address Type portion of the sdpConnection object
	\return	const char*	- connection address type from the c= line */
	const char*	getAddressType();
	//!  Returns the Connection Network Type value. 
	/*!  This method returns the Connection Network Type portion of the sdpConnection object
	\return	const char*	- connection network type from the c= line */
	const char*	getNetworkType();
	//!  Sets the Connection Address value. 
	/*!  This method sets the Connection Address portion of the sdpConnection object
	\param	a_Address		- connection address for the c= line
	\return	void */
	void	setAddress(const char* a_Address);
	//!  Sets the Connection Address Type value. 
	/*!  This method sets the Connection Address Type portion of the sdpConnection object
	\param	a_AddressType	- connection address type for the c= line
	\return	void */
	void	setAddressType(const char* a_AddressType);
	//!  Sets the Connection Network Type value. 
	/*!  This method sets the Connection Network Type portion of the sdpConnection object
	\param	a_NetworkType	- connection network type for the c= line
	\return	void */
	void	setNetworkType(const char* a_NetworkType);
	void	clear();
private:
	sdpElementString	m_Address;
	sdpElementString	m_AddressType;
	sdpElementString	m_NetworkType;
protected:  // sdpElement overrides
	void	setString(const char*);
	void	decode();
	void	encode();
friend class sdpSessionDescription;
};
///////////////////////////////////////////////////////////////////////////////////


///////////////////////////////////////////////////////////////////////////////////
//!  sdpCryptoSessionParm class. 
/*!  Associated with session parameters in the crypto attribute of sdp.*/
class sdpCryptoSessionParm : public sdpElement
{
public:
	sdpCryptoSessionParm():sdpElement('a') {};
	//!  Constrctor.
	/*!  This method creates the sdpCryptoSessionParm object from the given name and value parameters. */
	sdpCryptoSessionParm(	const char *name, 
					const char *value);

	//!  Returns the name of the session parameter.
	/*!  This method returns the name of the session parameter stored in the sdpCryptoSessionParm object.
	\return	const char*	- session parameter name of the sdpCryptoSessionParm object */
	const char * getName() { return m_Name.get(); };
	//!  Returns the value of the session parameter.
	/*!  This method returns the value of the session parameter stored in the sdpCryptoSessionParm object.
	\return	const char*	- session parameter value of the sdpCryptoSessionParm object */
	const char * getValue() { return m_Value.get(); };

	//!  Sets the name property. 
	/*!  This method sets the name property of the sdpCryptoSessionParm object.
	\param	name - name of the session parameter.
	\return	void */
	void setName(const char *name) { m_Name.set(name); };
	//!  Sets the value property. 
	/*!  This method sets the value property of the sdpCryptoSessionParm object.
	\param	value - value of the session parameter.
	\return	void */
	void setValue(const char *value) { m_Value.set(value); };

private:
	sdpElementString	m_Name;
	sdpElementString	m_Value;
friend class sdpSessionDescription;
};
///////////////////////////////////////////////////////////////////////////////////

///////////////////////////////////////////////////////////////////////////////////
//!  sdpCryptoKeyParm class. 
/*!  Associated with a key parameters in the crypto sttribute of sdp.*/
class sdpCryptoKeyParm : public sdpElement
{
public:
	sdpCryptoKeyParm():sdpElement('a') {};
	//!  Constrctor.
	/*!  This method creates the sdpCryptoKeyParm object from the given key parameters. */
	/*sdpCryptoKeyParm::*/sdpCryptoKeyParm(const char *keyMethod, 
					const char *key,
					const char *keyLifeTime, 
					const char *masterKeyIdentifier,
					const char *masterKeyIdentifierLength) :
					sdpElement('a'),
					m_keyMethod(keyMethod),
					m_key(key),
					m_keyLifeTime(keyLifeTime),
					m_masterKeyIdentifier(masterKeyIdentifier),
					m_masterKeyIdentifierLength(masterKeyIdentifierLength) {};

	//!  Returns a reference to the key method.
	/*!  This method returns a reference to the key method property of the sdpCryptoKeyParm object.
	\return	sdpElementString& - key method parameter of the sdpCryptoKeyParm object */
	sdpElementString& getKeyMethod() { return m_keyMethod; };
	//!  Returns a reference to the key.
	/*!  This method returns a reference to the key property of the sdpCryptoKeyParm object.
	\return	sdpElementString& - key parameter of the sdpCryptoKeyParm object */
	sdpElementString& getKey() { return m_key; };
	//!  Returns a reference to the key life time.
	/*!  This method returns a reference to the key life time property of the sdpCryptoKeyParm object.
	\return	sdpElementString& - key life time parameter of the sdpCryptoKeyParm object */
	sdpElementString& getKeyLifeTime() { return m_keyLifeTime; };
	//!  Returns a reference to the master key identifier (MKI).
	/*!  This method returns a reference to the master key identifier property of the sdpCryptoKeyParm object.
	\return	sdpElementString& - master key identifier parameter of the sdpCryptoKeyParm object */
	sdpElementString& getMasterKeyIdentifier() { return m_masterKeyIdentifier; };
	//!  Returns a reference to the master key identifier length.
	/*!  This method returns a reference to the master key identifier length property of the sdpCryptoKeyParm object.
	\return	sdpElementString& -  master key identifier length parameter of the sdpCryptoKeyParm object */
	sdpElementString& getMasterKeyIdentifierLength() { return m_masterKeyIdentifierLength; };

	//!  Sets the key method property. 
	/*!  This method sets the key method property of the sdpCryptoKeyParm object.
	\param	keyMethod - key method.
	\return	void */
	void setKeyMethod(const char *keyMethod) { m_keyMethod.set(keyMethod); };
	//!  Sets the key property. 
	/*!  This method sets the key property of the sdpCryptoKeyParm object.
	\param	key - actual key.
	\return	void */
	void setKey(const char *key) { m_key.set(key); };
	//!  Sets the key life time property. 
	/*!  This method sets the key life time property of the sdpCryptoKeyParm object.
	\param	keyLifeTime - key life time.
	\return	void */
	void setKeyLifeTime(const char *keyLifeTime) { m_keyLifeTime.set(keyLifeTime); };
	//!  Sets the master key identifier property. 
	/*!  This method sets the master key identifier property of the sdpCryptoKeyParm object.
	\param	masterKeyIdentifier - master key identifier (MKI).
	\return	void */
	void setMasterKeyIdentifier(const char *masterKeyIdentifier) { m_masterKeyIdentifier.set(masterKeyIdentifier); };
	//!  Sets the master key identifier length property. 
	/*!  This method sets the master key identifier length property of the sdpCryptoKeyParm object.
	\param	masterKeyIdentifierLength - master key identifier length.
	\return	void */
	void setMasterKeyIdentifierLength(const char *masterKeyIdentifierLength) { m_masterKeyIdentifierLength.set(masterKeyIdentifierLength); };
private:
	sdpElementString	m_keyMethod;
	sdpElementString	m_key;
	sdpElementString	m_keyLifeTime;
	sdpElementString	m_masterKeyIdentifier;
	sdpElementString	m_masterKeyIdentifierLength;
friend class sdpSessionDescription;
};
///////////////////////////////////////////////////////////////////////////////////


///////////////////////////////////////////////////////////////////////////////////
//!  sdpAttribute class. 
/*!  Associated with a 'a=' entry in the session description and media description.*/
class sdpAttribute : public sdpElement
{
public:
	sdpAttribute();
	virtual ~sdpAttribute() {};
public:
	//!  Returns the Property Name. 
	/*!  This method returns the Name of the attribute property in the sdpAttribute object
	\return	const char*	- name of the attribute property from the a= line */
	const char*	getProperty();
	//!  Returns the Property Value. 
	/*!  This method returns the Value of the attribute property in the sdpAttribute object
	\return	const char*	- value of the attribute property from the a= line */
	const char*	getPropertyValue();
	//!  Sets the Property Name. 
	/*!  This method sets the Name of the attribute property in the sdpAttribute object
	\param	a_Name	- name of the attribute property for the a= line
	\return	void */
	void	setProperty(const char* a_Name);
	//!  Sets the Property Value. 
	/*!  This method sets the value of the attribute property in the sdpAttribute object
	\param	a_Value	- value of the attribute property for the a= line
	\return	void */
	void	setPropertyValue(const char* a_Value);
	//!  Sets the Property Name and doesn't set sdpElement's m_String. 
	/*!  This method sets the Name of the attribute property in the sdpAttribute object
	\param	a_Name	- name of the attribute property for the a= line
	\return	void */
	inline	void setPropertyWithoutEncode(const char* a_Name) 
	{
		if (a_Name)
		{
			m_Property.set(a_Name);
		}
	}
	//!  Sets the Property Value and doesn't set sdpElement's m_String.. 
	/*!  This method sets the Value of the attribute property in the sdpAttribute object
	\param	a_Value	- value of the attribute property for the a= line
	\return	void */
	inline	void setPropertyValueWithoutEncode(const char* a_Value) 
	{
		if (a_Value)
		{
			m_PropertyValue.set(a_Value);
		}
	}
	void	clear();
private:
	sdpElementString	m_Property;
	sdpElementString	m_PropertyValue;
protected:  // sdpElement overrides
	void	setString(const char*);
	virtual	void	decode();
	virtual	void	encode();
friend class sdpSessionDescription;
};
///////////////////////////////////////////////////////////////////////////////////

#include "sdpLists.h"

///////////////////////////////////////////////////////////////////////////////////
//!  sdpCryptoAttribute class. 
/*!  Associated with a 'a=crypto' entry in the session description and media description.*/
class sdpCryptoAttribute : public sdpAttribute
{
public:
	~sdpCryptoAttribute() {};
	//!  Sets the Tag value. 
	/*!  This method sets the tag property in the sdpCryptoAttribute object
	\param	tag	- value of the tag property for the a=crypto line
	\return	void */
	void setTag(const char *tag);
	//!  Sets the CryptoSuite value. 
	/*!  This method sets the crypto suite property in the sdpCryptoAttribute object
	\param	cryptoSuite	- value of the cryptoSuite property for the a=crypto line
	\return	void */
	void setCryptoSuite(const char *cryptoSuite);
	//!  Creates the crypto key parameter and adds it to the list.
	/*!  This method creates the crypto key parameter from it's elements and adds it in the list of crypto key parameters stored in sdpCryptoAttribute object.
	\param	keyMethod	- value of the keyMethod property for the key parameter.
	\param	key			- value of the key property for the key parameter.
	\param	keyLifeTime	- value of the keyLifeTime property for the key parameter.
	\param	masterKeyIdentifier	- value of the masterKeyIdentifier property for the key parameter.
	\param	masterKeyIdentifierLength	- value of the masterKeyIdentifierLength property for the key parameter.
	\return	void */
	void addKeyParm(const char *keyMethod, const char *key,
			const char *keyLifeTime, const char *masterKeyIdentifier,
			const char *masterKeyIdentifierLength);
	//!  Clears all the crypto key parameters from the list. 
	/*!  This method clears all the key parameters from the key parameter list in the sdpCryptoAttribute object
	\return	void */
	void clearKeyParms();

	//!  Creates session parameter and adds it to the list.
	/*!  This method creates the session parameter and adds it in the list of session parameters stored in sdpCryptoAttribute object associated with a=crypto attribute.
	\param	name	- name of the session parameter.
	\param	value	- value of the session parameter.
	\return	void */
	void addSessionParm(const char *name, const char *value);
	//!  Clears all the crypto session parameters from the list.
	/*!  This method clears all the crypto session parameters from the list of crypto session parameters in the sdpCryptoAttribute object.
	\return	void */
	void clearSessionParms();

	//!  Returns the crypto tag.
	/*!  This method returns the crypto tag value in the sdpCryptoAttribute object
	\return	const char*	- crypto tag value of the sdpCryptoAttribute object */
	const char * getTag();
	//!  Returns the crypto suite.
	/*!  This method returns the crypto suite value in the sdpCryptoAttribute object
	\return	const char*	- crypto suite value of the sdpCryptoAttribute object */
	const char * getCryptoSuite();

	//!  Returns the crypto key parameter list.
	/*!  This method returns the crypto key parameter list in the sdpCryptoAttribute object.
	\return	sdpCryptoKeyParmList *	- pointer to the crypto key parameter list of the sdpCryptoAttribute object */
	sdpCryptoKeyParmList * getCryptoKeyParmList() { return &m_sdpCryptoKeyParmList; };
	
	//!  Returns the crypto session parameter list.
	/*!  This method returns the crypto session parameter list in the sdpCryptoAttribute object.
	\return	sdpCryptoSessionParmList *	- pointer to the crypto session parameter list of the sdpCryptoAttribute object */
	sdpCryptoSessionParmList * getCryptoSessionParmList() { return &m_sdpCryptoSessionParmList; };

	void clear();

	//!  Sets the sdpElement's m_String and sdpAttribute's m_Property.
	/*!  This method creates a crytp attribute string from sdpCryptoAttribute object's crypto elements and assigns it to sdpElement's m_String and sdpAttribute's m_Property.
	\return	void */
	virtual void	encode();

private:
	sdpElementString	m_tag;
	sdpElementString	m_cryptoSuite;

	sdpCryptoKeyParmList	m_sdpCryptoKeyParmList;
	sdpCryptoSessionParmList	m_sdpCryptoSessionParmList;

protected:  // sdpAttribute overrides
	virtual void	decode();

friend class sdpSessionDescription;
};
///////////////////////////////////////////////////////////////////////////////////


///////////////////////////////////////////////////////////////////////////////////
//!  sdpMediaTitle class. 
/*!  Associated with a 'i=' entry in the media description.*/
class sdpMediaTitle : public sdpElement
{
public:
	sdpMediaTitle();
public:
	//!  Returns the Media Title value. 
	/*!  This method returns the Media Title value of the sdpMediaTitle object
	\return	const char*	- media title from the i= line in a media description */
	const char*	getTitle();
	//!  Sets the Media Title value. 
	/*!  This method sets the Media Title value of the sdpMediaTitle object
	\param	a_Title	- media title for the i= line in a media description
	\return	void */
	void		setTitle(const char* a_Title);
};
///////////////////////////////////////////////////////////////////////////////////




///////////////////////////////////////////////////////////////////////////////////
//!  sdpMedia class. 
/*!  Associated with a 'm=' entry in the media description.*/
class sdpMedia : public sdpElement
{
public:
	sdpMedia();
	~sdpMedia();
public:
	//!  Adds a Media Format value. 
	/*!  This method adds a new Media Format value to the sdpMedia object 
	\param	a_Format	- new media format to add to the m= line
	\return	int			- total number of media formats now included in the sdpMedia object */
	int		addFormat(const char* a_Format);
	//!  Deletes a Media Format value. 
	/*!  This method deletes a Media Format value from the sdpMedia object
	\param	a_Format	- existing media format to delete from the sdpMedia object
	\return	int			- total number of media formats now included in the sdpMedia object */
	int		deleteFormat(const char* a_Format);
	//!  Returns the Media Format value. 
	/*!  This method returns the Media Format portion of the sdpMedia object
	\param	a_Index		- index of the media format to return.  Index is 0 based.
	\return	const char*	- media format from the m= line*/
	const char*	getFormat(int a_Index);
	//!  Returns the Media Type value. 
	/*!  This method returns the Media Type portion of the sdpMedia object
	\return	const char*	- media type from the m= line */
	const char*	getMedia();
	//!  Returns the Number of Media Formats. 
	/*!  This method returns the Number of Media Formats contained in the 'm=' line
	\return	int	- number of media formats include in the m= line */
	int		getNumFormat();
	//!  Returns the Number of Ports. 
	/*!  This method returns the Number of Ports defined in the 'm=' line
	\return	int	- number of ports defined in the m= line */
	int		getNumPorts();
	//!  Returns the Port. 
	/*!  Returns the Port contained in the 'm=' line
	\return	long	- port defined in the m= line */
	long	getPort();
	//!  Returns the Transport. 
	/*!  This method returns the Transport contained in the 'm=' line
	\return	const char*	- transport defined in the m= line */
	const char*	getTransport();
	//!  Sets the Media Type value. 
	/*!  This method sets the Media Type portion of the sdpMedia object
	\param	a_Media	- media type for the m= line
	\return	void */
	void	setMedia(const char* a_Media);
	//!  Sets the Number of Ports. 
	/*!  This method sets the Number of Ports contained in the 'm=' line
	\param	a_NumPorts	- number of ports for the  m= line in a media description
	\return	void */
	void	setNumPorts(int a_NumPorts);
	//!  Sets the Port. 
	/*!  This method sets the Port contained in the 'm=' line
	\param	a_Port	- port used in the m= line in a media description
	\return	void */
	void	setPort(long a_Port);
	//!  Sets the Transport. 
	/*!  This method sets the Transport contained in the 'm=' line
	\param	a_Transport	- media transport for the m= line in a media description
	\return	void */
	void	setTransport(const char* a_Transport);
	void	clear();
private:
	sdpElementString**	m_pFormats;
	sdpElementString	m_Media;
	sdpElementString	m_Transport;
	int		m_NumFormat;
	int		m_NumPorts;
	long	m_Port;
protected:  // sdpElement overrides
	void	setString(const char*);
	void	decode();
	void	encode();
friend class sdpSessionDescription;
};
///////////////////////////////////////////////////////////////////////////////////




#endif
