#!/bin/sh
#INTEL_DIALOGIC_DIR=/usr/dialogic
sbcupdate -V >/dev/null
RET=$?
if [ $RET = 0 ]
then
  echo "Updating AMC with 3 DSPs, please wait..."
else
  echo "sbcupdate not installed, install sbcutils and then proceed"
  exit $RET
fi

IPMC=`sbcupdate -Minfo | grep "Current firmware" | cut -c27-35`
AMC=`sbcupdate -Minfo -tamc | grep boot | cut -c28-32` 
DOWNGRADE=0

if [ $AMC = '1.08' ]
then 
   if [ $IPMC = '30.06.02' ] 
   then
      DOWNGRADE=0
   else 
      DOWNGRADE=1
   fi
fi

if [ $DOWNGRADE = 1 ]
then
	echo "Downgrading IPMC to older version to update AMC"
	sbcupdate -M direct --force-fw-update ${INTEL_DIALOGIC_DIR}/data/MPCBL0040_FW_1071.hex
	sleep 60
fi

sbcupdate -M direct -t amc --force-fw-update ${INTEL_DIALOGIC_DIR}/data/Tvl2Amc_OpCode_00_02_01.hex 
sleep 15

echo "Reading mfg information from fru"

AMC_getfru

status=$?
if [ $status -ne 0 ]; then
        echo "AMC fru read failed"
        exit 1
fi

sbcupdate -M direct -t amc  --force-fru-update --force-id ${INTEL_DIALOGIC_DIR}/data/MMB250BA01AQ_500.fru
sleep 15

echo "Writing mfg information to fru"

AMC_putfru >/dev/null

status=$?
if [ $status -ne 0 ]; then
        echo "AMC fru write failed"
        exit 1
fi

sbcupdate -M direct -t amc  --force-sdr-update ${INTEL_DIALOGIC_DIR}/data/MMB250BA01AQ_600.sdr
sleep 30

sbcupdate -Minfo -tamc

if [ $DOWNGRADE = 1 ]
then
	echo "Upgrading IPMC back to original version"
  sbcupdate -M direct --force-fw-update ${INTEL_DIALOGIC_DIR}/data/MPCBL0040_FW_11214.hex
  ipmitool raw 0x30 9 9 0 1 6
  ipmitool raw 0x30 9 9 0 2 120
  ipmitool raw 0x30 9 9 0 3 30
	sleep 15
fi

