/**********@@@SOFT@@@WARE@@@COPY@@@RIGHT@@@**********************************
* Copyright (C) 2001-2010 Dialogic Corporation. All Rights Reserved.
* Redistribution and use in source and binary forms, with or without
* modification, are permitted provided that the following conditions
* are met:
* 1.    Redistributions of source code must retain the above copyright
* notice, this list of conditions and the following disclaimer.
*
* 2.    Redistributions in binary form must reproduce the above copyright
* notice, this list of conditions and the following disclaimer in
* the documentation and/or other materials provided with the
* distribution.
*
* 3.    Neither the name Dialogic nor the names of its
* contributors may be used to endorse or promote products derived from this
* software without specific prior written permission.
*
* THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS "AS IS"
* AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE
* IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE
* ARE DISCLAIMED. IN NO EVENT SHALL THE COPYRIGHT OWNER OR CONTRIBUTORS BE
* LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR
* CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF
* SUBSTITUTE GOODS OR SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS
* INTERRUPTION) HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN
* CONTRACT, STRICT LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE)
* ARISING IN ANY WAY OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE
* POSSIBILITY OF SUCH DAMAGE.
***********************************@@@SOFT@@@WARE@@@COPY@@@RIGHT@@@**********/
////
//  FILE:         aspen.h
//
//  DESCRIPTION:  Defines all of the offsets needed to work with the Aspen ASIC
//                and it's Host Streaming feature.
//
////




#ifndef __ASPEN_H__
#define __ASPEN_H__




////
//  Offsets to the transmit/receiver buffers
////
#define ASPEN_TDM_XMIT_BUFFER		0x80000
#define ASPEN_TDM_RECV_BUFFER		0x90000




////
//  Clear Message Ready Interrupt Register
////
#define REG_OFFSET_CLEAR_MSGRDY_INTR        0x7FF80
#define ASPEN_MSGRDY_INTERRUPT              0x1
#define ASPEN_HOST_RAM_PENDING_INTERRUPT    0x2
#define ASPEN_ERROR_INTERRUPT               0x4
#define ASPEN_RATE_INTERRUPT                0x8




////
//  Clear Rate Interrupt Register
////
#define REG_OFFSET_CLEAR_RATE_INTR          0x7FFC0
#define ASPEN_CLEAR_RATE_INTERRUPT          0x8




////
//  TDM Resource Select Register
//
//  Host should claim resources starting with Stream 7 and working up (Stream 7,
//  then Stream 6 and so on).
////
#define REG_OFFSET_RESOURCE_SELECT			0xA0000
#define TDM_RESOURCE_STREAM_0				0x01
#define TDM_RESOURCE_STREAM_1				0x02
#define TDM_RESOURCE_STREAM_2				0x04
#define TDM_RESOURCE_STREAM_3				0x08
#define TDM_RESOURCE_STREAM_4				0x10
#define TDM_RESOURCE_STREAM_5				0x20
#define TDM_RESOURCE_STREAM_6				0x40
#define TDM_RESOURCE_STREAM_7				0x80
#define TDM_RESOURCE_DEFAULT_CONFIG			0xF0  // Host claims streams 4-7




////
//  TDM Enable Register
////
#define REG_OFFSET_TDM_ENABLE				0xA0004
#define TDM_DISABLE							0x0
#define TDM_ENABLE_ON_FRAME_SYNC			0x1
#define TDM_ENABLE_ON_SYNC_PATTERN			0x2
#define TDM_SEND_PATTERN_ENABLE_ON_SYNC		0x3



////
//  Clocking Mode Register
////
#define REG_OFFSET_CLOCKING_MODE			0xA0008
#define ASPEN_CLOCK_MASTER	    			0x01
#define ASPEN_CLOCK_SLAVE                   0x00
#define ASPEN_CLOCK_POLARITY_RISING         0x00
#define ASPEN_CLOCK_POLARITY_FALLING        0x02
#define ASPEN_FSYNC_POLARITY_HIGH           0x04
#define ASPEN_FSYNC_POLARITY_LOW            0x00
#define ASPEN_FRAMING_MODE_TRAILING			0x00
#define ASPEN_FRAMING_MODE_CENTER			0x08
#define ASPEN_FRAMING_MODE_LEADING			0x18
#define ASPEN_CLOCK_RATE_2048_HZ            0x00
#define ASPEN_CLOCK_RATE_4096_HZ			0x20
#define CLOCKING_MODE_DEFAULT_CONFIG        ( ASPEN_CLOCK_SLAVE | \
                                              ASPEN_CLOCK_POLARITY_RISING | \
                                              ASPEN_FSYNC_POLARITY_HIGH | \
                                              ASPEN_FRAMING_MODE_TRAILING | \
                                              ASPEN_CLOCK_RATE_4096_HZ )




////
//  Interrupt Rate Register
////
#define REG_OFFSET_INTERRUPT_RATE			0xA000C
#define TDM_INTERRUPT_RATE_4MS				0x00
#define TDM_INTERRUPT_RATE_2MS				0x01



////
//  Interrupt Enable Register
////
#define REG_OFFSET_INTERRUPT_ENABLE			0xA0010
#define DISABLE_RATE_INTERRUPT				0x0
#define ENABLE_RATE_INTERRUPT				0x1




////
//  A-Law Idle Pattern Register
////
#define REG_OFFSET_ALAW_IDLE_PATTERN		0xA0014
#define ALAW_IDLE_PATTERN_MASK				0xFF




////
//  Mu-Law Idle Pattern Register
////
#define REG_OFFSET_MULAW_IDLE_PATTERN		0xA0018
#define MULAW_IDLE_PATTERN_MASK				0xFF




////
//  Transparent Idle Pattern (8-Bit) Register
////
#define REG_OFFSET_8BIT_TRANS_IDLE_PATTERN	0xA001C
#define TRANS_IDLE_PATTERN_8BIT_MASK		0xFF




////
//  Transparent Idle Pattern (16-Bit) Register
////
#define REG_OFFSET_16BIT_TRANS_IDLE_PATTERN	0xA0020
#define TRANS_IDLE_PATTERN_16BIT_MASK		0xFFFF




////
//  PING PONG Control Register
////
#define REG_OFFSET_PING_PONG_CONTROL		0xA0024




////
//  Syncronization Pattern Register
////
#define REG_OFFSET_SYNC_PATTERN				0xA002C




////
//  Data Packing Register
////
#define REG_OFFSET_DATA_PACKING				0xA0030
#define PACKING_MODE_8BIT					0x00
#define PACKING_MODE_16BIT					0x01
#define PACKING_MODE_UNPACKED				0x10




////
//  Timeslot Control Bits (offset calculated using base + (TS Num * 0x4)
////
#define REG_TIMESLOT_CONTROL_BASE				0xA1000
#define REG_OFFSET_TIMESLOT_CONTROL_BITS(y)  	((y) * 0x4)

#define TS_CONTROL_SET_TIMESLOT_IDLE			0x01
#define TS_CONTROL_SET_ENABLE_TX_LAW_CONVERSION 0x02
#define TS_CONTROL_SET_ENABLE_RX_LAW_CONVERSION 0x04
#define TS_CONTROL_SET_ALAW                     0x08
#define TS_CONTROL_SET_MULAW                    0x00
#define TS_CONTROL_SET_LOOPBACK					0x10
#define TS_CONTROL_SET_DRIVER_ACTIVE			0x20

#define TS_CONTROL_MULAW_DEFAULT                ( TS_CONTROL_SET_ENABLE_TX_LAW_CONVERSION | \
                                                  TS_CONTROL_SET_ENABLE_RX_LAW_CONVERSION | \
                                                  TS_CONTROL_SET_MULAW | \
                                                  TS_CONTROL_SET_DRIVER_ACTIVE )

#define TS_CONTROL_ALAW_DEFAULT                 ( TS_CONTROL_SET_ENABLE_TX_LAW_CONVERSION | \
                                                  TS_CONTROL_SET_ENABLE_RX_LAW_CONVERSION | \
                                                  TS_CONTROL_SET_ALAW | \
                                                  TS_CONTROL_SET_DRIVER_ACTIVE )

#define TS_CONTROL_TRANSPARENT_DEFAULT			( TS_CONTROL_SET_DRIVER_ACTIVE )

#endif	// __ASPEN_H__
