/**********@@@SOFT@@@WARE@@@COPY@@@RIGHT@@@**********************************
* Copyright (C) 2001-2010 Dialogic Corporation. All Rights Reserved.
* Redistribution and use in source and binary forms, with or without
* modification, are permitted provided that the following conditions
* are met:
* 1.    Redistributions of source code must retain the above copyright
* notice, this list of conditions and the following disclaimer.
*
* 2.    Redistributions in binary form must reproduce the above copyright
* notice, this list of conditions and the following disclaimer in
* the documentation and/or other materials provided with the
* distribution.
*
* 3.    Neither the name Dialogic nor the names of its
* contributors may be used to endorse or promote products derived from this
* software without specific prior written permission.
*
* THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS "AS IS"
* AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE
* IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE
* ARE DISCLAIMED. IN NO EVENT SHALL THE COPYRIGHT OWNER OR CONTRIBUTORS BE
* LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR
* CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF
* SUBSTITUTE GOODS OR SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS
* INTERRUPTION) HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN
* CONTRACT, STRICT LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE)
* ARISING IN ANY WAY OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE
* POSSIBILITY OF SUCH DAMAGE.
***********************************@@@SOFT@@@WARE@@@COPY@@@RIGHT@@@**********/
/**********************************************************************
 * File Name                    : mercd_linux_linux_stub.c
 * Description                  : Driver HSI Stub Functions
 *
 *
 **********************************************************************/

#ifndef LINUX24
#include <linux/moduleparam.h>
#endif

#include <linux/module.h>
#include <linux/version.h>
#include <linux/timer.h>
#include "msd.h"
#include "mercd.h"
#include "hsi_interface.h"
#include "heb_interface.h"

#define _MERCD_LINUX_STUB_C
#include "msdextern.h"
#undef  _MERCD_LINUX_STUB_C

#include "mercd_hsi.h"

/***************************************************************************
 * Function Name       : stub_hsi_interface_timer_cb
 * Function Type       : Stub HSI function
 * Inputs              : none
 * Outputs             : none
 * Calling functions   :
 * Description         : Timer callback function when Mercd is running the HSI
 *                          functionality as a stub.
 * Additional comments :
 ****************************************************************************/
void stub_hsi_interface_timer_cb(void) {
   static unsigned int run_count = 0;
   mercd_osal_timeout_start_sT timeoutinfo = { 0 };

   g_stub_hsi_interface_timer_on_queue = 0;

   if (g_hsi_isr_callback && !g_stub_hsi_interface_timer_shutdown && g_stub_rate_interrupt_enabled) {
      /////////////////////////////////////////////////////////////////////////////////////////////////////////
      g_hsi_isr_callback(g_stub_rate_interrupt_bridge_id,
                         ((run_count % g_stub_number_of_hsi_buffers) << 24) |
                         (run_count & 0xFFFFFF                            )  );
      /////////////////////////////////////////////////////////////////////////////////////////////////////////
   }

   if (!g_stub_hsi_interface_timer_shutdown) {
      run_count++;
      timeoutinfo.Interval = 10;
      timeoutinfo.Function = (PMSD_FUNCTION)stub_hsi_interface_timer_cb;
      timeoutinfo.Context = (void*) 44;
      timeoutinfo.Handle = &g_stub_hsi_interface_timer_list;

      //////////////////////////////////////////////////////////////////////
      (*mercd_osal_func[MERCD_OSAL_TIMEOUT_START])((void *)&timeoutinfo); //
      //////////////////////////////////////////////////////////////////////

       g_stub_hsi_interface_timer_on_queue = 1;
   } else {
       g_stub_hsi_interface_timer_on_queue = 0;
   }
}


/***************************************************************************
 * Function Name       : stub_hsi_interface_timer
 * Function Type       : Stub HSI function
 * Inputs              : none
 * Outputs             : none
 * Calling functions   :
 * Description         : Timer used to stub the HSI Rate Interrupt processing.
 * Additional comments :
 ****************************************************************************/
md_status_t stub_hsi_interface_timer(void)
{
        md_status_t     Status;
        mercd_osal_timeout_start_sT timeoutinfo = { 0 };
        /* static struct timer_list      l_timer_list = { 0 }; */

        MSD_FUNCTION_TRACE_EX("stub_hsi_interface_timer(): Entering.\n");

        timeoutinfo.Interval = 3000;
        timeoutinfo.Function = (PMSD_FUNCTION)stub_hsi_interface_timer_cb;
        timeoutinfo.Context = (void*) 44;
        timeoutinfo.Handle = &g_stub_hsi_interface_timer_list;

        //////////////////////////////////////////////////////////////////////
        (*mercd_osal_func[MERCD_OSAL_TIMEOUT_START])((void *)&timeoutinfo); //
        //////////////////////////////////////////////////////////////////////

        g_stub_hsi_interface_timer_on_queue = 1;

        Status = timeoutinfo.ret;

        if (Status != MD_SUCCESS) {
           MSD_ERR_DBGPRINT("stub_hsi_isr_callback(): Starting Timer Failed.\n");
           return(MD_FAILURE);
        }

        MSD_FUNCTION_TRACE_EX("stub_hsi_interface_timer(): Exiting.\n");
        return(MD_SUCCESS);
}


/***************************************************************************
 * Function Name       : stub_hsi_isr_callback
 * Function Type       : Stub HSI function
 * Inputs              : none
 * Outputs             : none
 * Calling functions   :
 * Description         : Default HSI Rate Interrupt processing callback function.
 * Additional comments :
 ****************************************************************************/
void stub_hsi_isr_callback(int bridgeId, int hsiBufferIndex) {
   PMDRV_MSG              MdMsg;
   PSTRM_MSG              StrmMsg1;
   int                    bridgeIdAndIndex[2];
   int                   *pbridgeIdAndIndex = &(bridgeIdAndIndex[0]);

   MSD_FUNCTION_TRACE_EX("stub_hsi_isr_callback(): Entering.\n");

   MSD_LEVEL1_DBGPRINT("stub_hsi_isr_callback(): g_stub_hsi_isr_callback_MsdOpenBlock: 0x%08x\n", g_stub_hsi_isr_callback_MsdOpenBlock);

   g_stub_number_of_rate_interrupts = (g_stub_number_of_rate_interrupts + 1) & 0x7FFFFFFF;

   if (g_stub_hsi_isr_callback_MsdOpenBlock) {
      StrmMsg1 = supp_alloc_buf(sizeof(MDRV_MSG)+2*sizeof(int), GFP_ATOMIC);
      if(StrmMsg1 == NULL) {
         MSD_ERR_DBGPRINT("stub_hsi_isr_callback(): Cannot alloc Msg buffer\n");
         return;
      }
      MD_SET_MSG_TYPE(StrmMsg1, M_DATA);

      MdMsg = MD_EXTRACT_MDMSG_FROM_STRMMSG(StrmMsg1);
      MD_SET_MSG_WRITE_PTR(StrmMsg1, (MD_GET_MSG_READ_PTR(StrmMsg1)+sizeof(MDRV_MSG)+2*sizeof(int)));

      pbridgeIdAndIndex    = (int *) MD_GET_MDMSG_PAYLOAD(MdMsg);
      pbridgeIdAndIndex[0] = bridgeId;

      pbridgeIdAndIndex[1] = hsiBufferIndex;

      g_stub_hsi_isr_callback_MsdOpenBlock->state = MERCD_OPEN_STATE_OPENED;
      ////////////////////////////////////////////////////////////////////////
      supp_process_receive(g_stub_hsi_isr_callback_MsdOpenBlock, StrmMsg1); //
      ////////////////////////////////////////////////////////////////////////
   }
   MSD_FUNCTION_TRACE_EX("stub_hsi_isr_callback(): Exiting.\n");
}


/***************************************************************************
 * Function Name       : stub_mid_strmmgr_hsi_buffer_init
 * Function Type       : Stub HSI function
 * Inputs              : none
 * Outputs             : none
 * Calling functions   :
 * Description         : Stub function for initializing the HSI Bridges.
 * Additional comments :
 ****************************************************************************/
int stub_mid_strmmgr_hsi_buffer_init(pmercd_open_block_sT MsdOpenBlock, void *argp) {
   PHSI_BRIDGE_INIT_INPUT  phsiBridgeInitInput ;
   PHSI_BRIDGE_INIT_OUTPUT phsiBridgeInitOutput;
   PSTRM_MSG               StrmMsg1            ;
   PMDRV_MSG               MdMsg               ;


   MSD_FUNCTION_TRACE_EX("stub_mid_strmmgr_hsi_buffer_init(): Entering.\n");
   MsdOpenBlock->flags |= MERCD_OPEN_FLAG_PAYLOAD_ONLY;
   phsiBridgeInitInput = (PHSI_BRIDGE_INIT_INPUT) argp;
   MSD_LEVEL1_DBGPRINT("stub_mid_strmmgr_hsi_buffer_init(): phsiBridgeInitInput->logicalId: %d\n", phsiBridgeInitInput->logicalId);
   MSD_LEVEL1_DBGPRINT("stub_mid_strmmgr_hsi_buffer_init(): phsiBridgeInitInput->hmpIsrFunc: 0x%08x\n", phsiBridgeInitInput->hmpIsrFunc);
   g_hsi_isr_callback = phsiBridgeInitInput->hmpIsrFunc;

   g_stub_number_of_hsi_buffers = phsiBridgeInitInput->numHsiBuffers;
   StrmMsg1 = supp_alloc_buf(sizeof(MDRV_MSG)+sizeof(HSI_BRIDGE_INIT_OUTPUT), GFP_ATOMIC);
   if(StrmMsg1 == NULL) {
      MSD_ERR_DBGPRINT("stub_mid_strmmgr_hsi_buffer_init(): ERROR: Cannot alloc Msg buffer\n");
      return(-EFAULT);
   }
   MD_SET_MSG_TYPE(StrmMsg1, M_DATA);

   MdMsg = MD_EXTRACT_MDMSG_FROM_STRMMSG(StrmMsg1);
   //MERCURY_SET_BODY_SIZE(MercMsg,sizeof(HSI_BRIDGE_INIT_OUTPUT));
   MD_SET_MSG_WRITE_PTR(StrmMsg1, (MD_GET_MSG_READ_PTR(StrmMsg1)+sizeof(MDRV_MSG)+sizeof(HSI_BRIDGE_INIT_OUTPUT)));

   phsiBridgeInitOutput  = (PHSI_BRIDGE_INIT_OUTPUT) MD_GET_MDMSG_PAYLOAD(MdMsg);
   phsiBridgeInitOutput->type = HSI_BRIDGE_INIT_COMPLETION;
   phsiBridgeInitOutput->bridgeId = phsiBridgeInitInput->bridgeId;;
   phsiBridgeInitOutput->txDelay = 2;
   phsiBridgeInitOutput->rxDelay = 3;
   phsiBridgeInitOutput->txSyncDelay = 5;
   phsiBridgeInitOutput->rxSyncDelay = 7;

   ////////////////////////////////////////////////
   supp_process_receive(MsdOpenBlock, StrmMsg1); //
   ////////////////////////////////////////////////

   MSD_FUNCTION_TRACE_EX("stub_mid_strmmgr_hsi_buffer_init(): Exiting.\n");
   return 0;
}


/***************************************************************************
 * Function Name       : stub_mid_strmmgr_hsi_buffer_stop
 * Function Type       : Stub HSI function
 * Inputs              : none
 * Outputs             : none
 * Calling functions   :
 * Description         : Stub function for stopping the HSI Bridges.
 * Additional comments :
 ****************************************************************************/
int stub_mid_strmmgr_hsi_buffer_stop(pmercd_open_block_sT MsdOpenBlock, void *argp) {
   unsigned int            *phsiBridgeStopInput ;
   PHSI_BRIDGE_STOP_OUTPUT  phsiBridgeStopOutput;
   PSTRM_MSG     StrmMsg1            ;
   PMDRV_MSG     MdMsg               ;

   MSD_FUNCTION_TRACE_EX("stub_mid_strmmgr_hsi_buffer_stop(): Entering.\n");

   MsdOpenBlock->flags |= MERCD_OPEN_FLAG_PAYLOAD_ONLY;

   phsiBridgeStopInput = (unsigned int*) argp;
   MSD_LEVEL1_DBGPRINT("stub_mid_strmmgr_hsi_buffer_stop(): *phsiBridgeStopInput: %d\n", *phsiBridgeStopInput);
   StrmMsg1 = supp_alloc_buf(sizeof(MDRV_MSG)+sizeof(HSI_BRIDGE_STOP_OUTPUT), GFP_ATOMIC);
   if(StrmMsg1 == NULL) {
      MSD_ERR_DBGPRINT("stub_mid_strmmgr_hsi_buffer_stop(): ERROR: Cannot alloc Msg buffer\n");
      return(-EFAULT);
   }
   MD_SET_MSG_TYPE(StrmMsg1, M_DATA);

   MdMsg = MD_EXTRACT_MDMSG_FROM_STRMMSG(StrmMsg1);
   MD_SET_MSG_WRITE_PTR(StrmMsg1,
      (MD_GET_MSG_READ_PTR(StrmMsg1)+sizeof(MDRV_MSG)+sizeof(HSI_BRIDGE_STOP_OUTPUT)));

   phsiBridgeStopOutput           = (PHSI_BRIDGE_STOP_OUTPUT) MD_GET_MDMSG_PAYLOAD(MdMsg);
   phsiBridgeStopOutput->type     = HSI_BRIDGE_STOP_COMPLETION;
   phsiBridgeStopOutput->bridgeId = g_stub_rate_interrupt_bridge_id;

   ////////////////////////////////////////////////
   supp_process_receive(MsdOpenBlock, StrmMsg1); //
   ////////////////////////////////////////////////

   MSD_FUNCTION_TRACE_EX("stub_mid_strmmgr_hsi_buffer_stop(): Exiting.\n");
   return 0;
}


/***************************************************************************
 * Function Name       : stub_mid_strmmgr_hsi_rate_interrupt_enable
 * Function Type       : Stub HSI function
 * Inputs              : none
 * Outputs             : none
 * Calling functions   :
 * Description         : Stub function for enabling the HSI Rate Interrupt.
 * Additional comments :
 ****************************************************************************/
int stub_mid_strmmgr_hsi_rate_interrupt_enable(pmercd_open_block_sT MsdOpenBlock, void *argp) {
   unsigned int                   *phsiIntrRateEnableInput ;
   PHSI_BRIDGE_INTR_ENABLE_OUTPUT  phsiIntrRateEnableOutput;
   unsigned int  payloadSize             ;
   PSTRM_MSG     StrmMsg1                ;
   PMDRV_MSG     MdMsg                   ;

   MSD_FUNCTION_TRACE_EX("stub_mid_strmmgr_hsi_rate_interrupt_enable(): Entering.\n");

   g_stub_rate_interrupt_enabled = 1;

   MsdOpenBlock->flags |= MERCD_OPEN_FLAG_PAYLOAD_ONLY;
   phsiIntrRateEnableInput = (unsigned int*) argp;
   MSD_LEVEL1_DBGPRINT("stub_mid_strmmgr_hsi_rate_interrupt_enable(): *phsiIntrRateEnableInput (Logical Id): %d\n", *phsiIntrRateEnableInput);
   g_stub_rate_interrupt_logical_id = *phsiIntrRateEnableInput;
   payloadSize = sizeof(HSI_BRIDGE_INTR_ENABLE_OUTPUT);
   StrmMsg1 = supp_alloc_buf(sizeof(MDRV_MSG) + payloadSize, GFP_ATOMIC);
   if(StrmMsg1 == NULL) {
      MSD_LEVEL1_DBGPRINT("stub_mid_strmmgr_hsi_rate_interrupt_enable(): ERROR: Cannot alloc Msg buffer\n");
      return(-EFAULT);
   }
   MD_SET_MSG_TYPE(StrmMsg1, M_DATA);

   MdMsg = MD_EXTRACT_MDMSG_FROM_STRMMSG(StrmMsg1);
   MD_SET_MSG_WRITE_PTR(StrmMsg1,
      (MD_GET_MSG_READ_PTR(StrmMsg1)+sizeof(MDRV_MSG)+payloadSize));

   phsiIntrRateEnableOutput  = (PHSI_BRIDGE_INTR_ENABLE_OUTPUT) MD_GET_MDMSG_PAYLOAD(MdMsg);

   phsiIntrRateEnableOutput->type     = HSI_BRIDGE_INTR_ENABLE_COMPLETION;
   phsiIntrRateEnableOutput->bridgeId = g_stub_rate_interrupt_bridge_id;

   ////////////////////////////////////////////////
   supp_process_receive(MsdOpenBlock, StrmMsg1); //
   ////////////////////////////////////////////////

   MSD_FUNCTION_TRACE_EX("stub_mid_strmmgr_hsi_rate_interrupt_enable(): Exiting.\n");

   return 0;

}


/***************************************************************************
 * Function Name       : stub_mid_strmmgr_hsi_rate_interrupt_disable
 * Function Type       : Stub HSI function
 * Inputs              : none
 * Outputs             : none
 * Calling functions   :
 * Description         : Stub function for disabling the HSI Rate Interrupt.
 * Additional comments :
 ****************************************************************************/
int stub_mid_strmmgr_hsi_rate_interrupt_disable(pmercd_open_block_sT MsdOpenBlock, void *argp) {
   unsigned int                    *phsiIntrRateDisableInput ;
   PHSI_BRIDGE_INTR_DISABLE_OUTPUT  phsiIntrRateDisableOutput;
   unsigned int  payloadSize              ;
   PSTRM_MSG     StrmMsg1                 ;
   PMDRV_MSG     MdMsg                    ;

   MSD_FUNCTION_TRACE_EX("stub_mid_strmmgr_hsi_rate_interrupt_disable(): Entering.\n");

   MsdOpenBlock->flags |= MERCD_OPEN_FLAG_PAYLOAD_ONLY;

   g_stub_rate_interrupt_enabled = 0;

   phsiIntrRateDisableInput = (unsigned int*) argp;
   MSD_LEVEL1_DBGPRINT("stub_mid_strmmgr_hsi_rate_interrupt_disable(): *phsiIntrRateDisableInput: %d\n", *phsiIntrRateDisableInput);
   payloadSize = sizeof(HSI_BRIDGE_INTR_DISABLE_OUTPUT);
   StrmMsg1 = supp_alloc_buf(sizeof(MDRV_MSG) + payloadSize, GFP_ATOMIC);
   if(StrmMsg1 == NULL) {
      MSD_ERR_DBGPRINT("Cannot alloc Msg buffer\n");
      return(-EFAULT);
   }
   MD_SET_MSG_TYPE(StrmMsg1, M_DATA);

   MdMsg = MD_EXTRACT_MDMSG_FROM_STRMMSG(StrmMsg1);
   MD_SET_MSG_WRITE_PTR(StrmMsg1,
      (MD_GET_MSG_READ_PTR(StrmMsg1)+sizeof(MDRV_MSG)+payloadSize));

   phsiIntrRateDisableOutput           = (PHSI_BRIDGE_INTR_DISABLE_OUTPUT) MD_GET_MDMSG_PAYLOAD(MdMsg);
   phsiIntrRateDisableOutput->type     = HSI_BRIDGE_INTR_DISABLE_COMPLETION;
   phsiIntrRateDisableOutput->bridgeId = g_stub_rate_interrupt_bridge_id;

   ////////////////////////////////////////////////
   supp_process_receive(MsdOpenBlock, StrmMsg1); //
   ////////////////////////////////////////////////

   MSD_FUNCTION_TRACE_EX("stub_mid_strmmgr_hsi_rate_interrupt_disable(): Exiting.\n");
   return 0;
}


/***************************************************************************
 * Function Name       : stub_mid_strmmgr_hsi_bridge_connect
 * Function Type       : Stub HSI function
 * Inputs              : none
 * Outputs             : none
 * Calling functions   :
 * Description         : Stub function for connecting or disconnecting the HSI Bridges.
 * Additional comments :
 ****************************************************************************/
int stub_mid_strmmgr_hsi_bridge_connect(pmercd_open_block_sT MsdOpenBlock, void *argp) {
   PHSI_BRIDGE_ROUTE_INPUT  phsiBridgeRouteInput ;
   PHSI_BRIDGE_ROUTE_OUTPUT phsiBridgeRouteOutput;
   unsigned int             payloadSize          ;
   PSTRM_MSG                StrmMsg1             ;
   PMDRV_MSG                MdMsg                ;


   MSD_FUNCTION_TRACE_EX("stub_mid_strmmgr_hsi_bridge_connect(): Entering.\n");
   MsdOpenBlock->flags |= MERCD_OPEN_FLAG_PAYLOAD_ONLY;

   phsiBridgeRouteInput = (unsigned int*) argp;
   MSD_LEVEL1_DBGPRINT("stub_mid_strmmgr_hsi_bridge_connect(): *phsiBridgeRouteInput: %d\n", *phsiBridgeRouteInput);
   payloadSize = sizeof(HSI_BRIDGE_ROUTE_OUTPUT) +
                 (phsiBridgeRouteInput->numRoutes - 1) * sizeof(HSI_BRIDGE_ROUTE_DESC);
   StrmMsg1 = supp_alloc_buf(sizeof(MDRV_MSG) + payloadSize, GFP_ATOMIC);
   if(StrmMsg1 == NULL) {
      MSD_ERR_DBGPRINT("stub_mid_strmmgr_hsi_bridge_connect(): ERROR: Cannot alloc Msg buffer\n");
      return(-EFAULT);
   }
   MD_SET_MSG_TYPE(StrmMsg1, M_DATA);

   MdMsg = MD_EXTRACT_MDMSG_FROM_STRMMSG(StrmMsg1);
   MD_SET_MSG_WRITE_PTR(StrmMsg1,
      (MD_GET_MSG_READ_PTR(StrmMsg1)+sizeof(MDRV_MSG)+payloadSize));

   phsiBridgeRouteOutput  = (PHSI_BRIDGE_ROUTE_OUTPUT) MD_GET_MDMSG_PAYLOAD(MdMsg);
   phsiBridgeRouteOutput->type            = HSI_BRIDGE_ROUTE_COMPLETION;
   phsiBridgeRouteOutput->bridgeId        = g_stub_rate_interrupt_bridge_id;
   phsiBridgeRouteOutput->numFailures     = 0;
   phsiBridgeRouteOutput->failedRoutes[0].bridgePort = 53;
   phsiBridgeRouteOutput->failedRoutes[0].hardBusTS  = 59;
   phsiBridgeRouteOutput->failedRoutes[0].flags      = 61;

   ////////////////////////////////////////////////
   supp_process_receive(MsdOpenBlock, StrmMsg1); //
   ////////////////////////////////////////////////

   MSD_FUNCTION_TRACE_EX("stub_mid_strmmgr_hsi_bridge_connect(): Exiting.\n");
   return 0;
}


/***************************************************************************
 * Function Name       : stub_mid_strmmgr_heb_get_dongle_id
 * Function Type       : Stub HSI function
 * Inputs              : none
 * Outputs             : none
 * Calling functions   :
 * Description         : Stub function for the Dongle Id.
 * Additional comments :
 ****************************************************************************/
int stub_mid_strmmgr_heb_get_dongle_id(pmercd_open_block_sT MsdOpenBlock, void *argp) {
   PHEB_GET_DONGLE_ID_INPUT  phebGetDongleIdInput ;
   PHEB_GET_DONGLE_ID_OUTPUT phebGetDongleIdOutput;
   unsigned int              payloadSize          ;
   int                       i                    ;
   PSTRM_MSG                 StrmMsg1             ;
   PMDRV_MSG                 MdMsg                ;


   MSD_FUNCTION_TRACE_EX("stub_mid_strmmgr_heb_get_dongle_id(): Entering.\n");

   MsdOpenBlock->flags |= MERCD_OPEN_FLAG_PAYLOAD_ONLY;

   phebGetDongleIdInput = (unsigned int*) argp;
   MSD_LEVEL1_DBGPRINT("stub_mid_strmmgr_heb_get_dongle_id(): phebGetDongleIdInput->logicalId: %d\n", phebGetDongleIdInput->logicalId);
   MSD_LEVEL1_DBGPRINT("stub_mid_strmmgr_heb_get_dongle_id(): phebGetDongleIdInput->time: %d\n", phebGetDongleIdInput->time);
   payloadSize = sizeof(HEB_GET_DONGLE_ID_OUTPUT) + (MAX_DONGLE_ID_LENGTH-1)*sizeof(unsigned long);
   StrmMsg1 = supp_alloc_buf(sizeof(MDRV_MSG) + payloadSize, GFP_ATOMIC);
   if(StrmMsg1 == NULL) {
      MSD_ERR_DBGPRINT("stub_mid_strmmgr_heb_get_dongle_id(): ERROR: Cannot alloc Msg buffer\n");
      return(-EFAULT);
   }
   MD_SET_MSG_TYPE(StrmMsg1, M_DATA);

   MdMsg = MD_EXTRACT_MDMSG_FROM_STRMMSG(StrmMsg1);
   MD_SET_MSG_WRITE_PTR(StrmMsg1,
      (MD_GET_MSG_READ_PTR(StrmMsg1)+sizeof(MDRV_MSG)+payloadSize));

   phebGetDongleIdOutput = (unsigned int*) MD_GET_MDMSG_PAYLOAD(MdMsg);
   phebGetDongleIdOutput->blockSize = MAX_DONGLE_ID_LENGTH;
   for (i=0; i < MAX_DONGLE_ID_LENGTH; i++) {
      phebGetDongleIdOutput->key[i] = i;
   }

   ////////////////////////////////////////////////
   supp_process_receive(MsdOpenBlock, StrmMsg1); //
   ////////////////////////////////////////////////

   MSD_FUNCTION_TRACE_EX("stub_mid_strmmgr_heb_get_dongle_id(): Exiting.\n");
   return 0;
}
