# Dialogic Version String. Do not edit this or next line.\
DLcid 03000001-11 dm3_qtech
# Do not edit previous line.
################################################################
#
#   Copyright (C) 2005 Intel Corporation.
#
#   All Rights Reserved.  All names, products,
#   and services mentioned herein are the trademarks
#   or registered trademarks of their respective organizations
#   and are the sole property of their respective owners.
#
################################################################

#don't source the script more then once
if [info exists CASComponent] {
    return
}

if ![info exists CAS] {
    source ${qscript_library}/cas_defs.qs
    unset CAS
}

#this line helps the auto loader find this class
proc CASComponent {} {}
catch {AddressableClass new -Name CASComponent -init {-Extends Component}}
CASComponent set ComponentType $CAS_Std_ComponentType
CASComponent set typeDefRegistry CASComponent_TypeDefs

#Error code descriptions
set QS_ErrorCode_Descriptions($CAS_ErrMaxDigitsExceeded) {CAS_ErrMaxDigitsExceeded: The maximum number of definable digits has been exceeded in a train definition, or in the case of MsgDial the string exceeded the maximum allowable length.}
set QS_ErrorCode_Descriptions($CAS_ErrSignalTableFull) {CAS_ErrSignalTableFull: The signal table is full and can't insert the signal entry}
set QS_ErrorCode_Descriptions($CAS_ErrSignalInUse) {CAS_ErrSignalInUse: The signal is in use and can't be deleted.}
set QS_ErrorCode_Descriptions($CAS_ErrPulseTrainRef) {CAS_ErrPulseTrainRef: The Pulse Train Signal Id Reference is invalid.}
set QS_ErrorCode_Descriptions($CAS_ErrDigitLabelUndefined) {CAS_ErrDigitLabelUndefined: The specified digit label is not recognized.}
set QS_ErrorCode_Descriptions($CAS_ErrSignalId) {CAS_ErrSignalId: The signal identifier is invalid, or, in the case of MsgDefineSignal, has been previously defined.}
set QS_ErrorCode_Descriptions($CAS_ErrSignalType) {CAS_ErrSignalType: The Signal Type is invalid.}
set QS_ErrorCode_Descriptions($CAS_ErrPulseTrainRef) {CAS_ErrPulseTrainRef: The Pulse Train Signal Id Reference is invalid.}

#***CAS_TypeDefs*****
#this object is a database of typedefs which can be automatically recognized by
#the an CASComponent object, it also recognizes all types specified in StdResource_TypeDefs
TypeDefRegistry new -Name CASComponent_TypeDefs \
    -init [list -Extends [[CASComponent set Extends] set typeDefRegistry]]
CASComponent_TypeDefs define -MsgType CAS_MsgDefTransition \
    -TypeDef [list \
		  SignalId $CAS_MsgDefTransition_SignalId \
		  PreTransCode $CAS_MsgDefTransition_PreTransCode \
		  PostTransCode $CAS_MsgDefTransition_PostTransCode \
		  PreTransInterval $CAS_MsgDefTransition_PreTransInterval \
		  PostTransInterval $CAS_MsgDefTransition_PostTransInterval \
		  ]
CASComponent_TypeDefs define -MsgType CAS_MsgDefPulse \
    -TypeDef [list \
		SignalId $CAS_MsgDefPulse_SignalId \
		OffPulseCode $CAS_MsgDefPulse_OffPulseCode \
		OnPulseCode $CAS_MsgDefPulse_OnPulseCode \
		PrePulseInterval $CAS_MsgDefPulse_PrePulseInterval \
		PulseIntervalMin $CAS_MsgDefPulse_PulseIntervalMin \
		PulseIntervalMax $CAS_MsgDefPulse_PulseIntervalMax \
		PulseIntervalNom $CAS_MsgDefPulse_PulseIntervalNom \
		PostPulseInterval $CAS_MsgDefPulse_PostPulseInterval \
	      ]
CASComponent_TypeDefs define -MsgType CAS_MsgDefTrain \
    -TypeDef [list \
		  SignalId $CAS_MsgDefTrain_SignalId \
		  OffPulseCode $CAS_MsgDefTrain_OffPulseCode \
		  OnPulseCode $CAS_MsgDefTrain_OnPulseCode \
		  PulseIntervalMin $CAS_MsgDefTrain_PulseIntervalMin \
		  PulseIntervalMax $CAS_MsgDefTrain_PulseIntervalMax \
		  PulseIntervalNom $CAS_MsgDefTrain_PulseIntervalNom \
		  PreTrainInterval $CAS_MsgDefTrain_PreTrainInterval \
		  InterPulseIntervalMin $CAS_MsgDefTrain_InterPulseIntervalMin \
		  InterPulseIntervalMax $CAS_MsgDefTrain_InterPulseIntervalMax \
		  InterPulseIntervalNom $CAS_MsgDefTrain_InterPulseIntervalNom \
		  PostTrainInterval $CAS_MsgDefTrain_PostTrainInterval \
		  DigitCount $CAS_MsgDefTrain_DigitCount \
		  DigitList [list -Count DigitCount \
			     -DataType [list \
					    PulseCount $CAS_MsgDefTrain_Digit_PulseCount \
					    Label $CAS_MsgDefTrain_Digit_Label \
					    ] \
			     ] \
		  ]
CASComponent_TypeDefs define -MsgType CAS_MsgDefSequence \
    -TypeDef [list \
		SignalId $CAS_MsgDefSequence_SignalId \
		PulseTrainRef $CAS_MsgDefSequence_PulseTrainRef \
		PreSeqInterval $CAS_MsgDefSequence_PreSeqInterval \
		InterTrainIntervalMin $CAS_MsgDefSequence_InterTrainIntervalMin \
		InterTrainIntervalMax $CAS_MsgDefSequence_InterTrainIntervalMax \
		InterTrainIntervalNom $CAS_MsgDefSequence_InterTrainIntervalNom \
		PostSeqInterval $CAS_MsgDefSequence_PostSeqInterval \
	      ]
CASComponent_TypeDefs define -MsgType CAS_MsgDefSignalCmplt \
    -TypeDef {}
CASComponent_TypeDefs define -MsgType CAS_MsgDeleteSignal \
    -TypeDef [list \
		  SignalId $CAS_MsgDeleteSignal_SignalId \
		  ]
CASComponent_TypeDefs define -MsgType CAS_MsgDeleteSignalCmplt \
    -TypeDef {}
set CAS_Transition_t [list \
			  PreTransCode $CAS_Transition_PreTransCode \
			  PostTransCode $CAS_Transition_PostTransCode \
			  PreTransInterval $CAS_Transition_PreTransInterval \
			  PostTransInterval $CAS_Transition_PostTransInterval \
			 ]
set CAS_Pulse_t [list \
		     OffPulseCode $CAS_Pulse_OffPulseCode \
		     OnPulseCode $CAS_Pulse_OnPulseCode \
		     PrePulseInterval $CAS_Pulse_PrePulseInterval \
		     PulseIntervalMin $CAS_Pulse_PulseIntervalMin \
		     PulseIntervalMax $CAS_Pulse_PulseIntervalMax \
		     PulseIntervalNom $CAS_Pulse_PulseIntervalNom \
		     PostPulseInterval $CAS_Pulse_PostPulseInterval \
		    ]
set CAS_Train_t [list \
		  OffPulseCode $CAS_Train_OffPulseCode \
		  OnPulseCode $CAS_Train_OnPulseCode \
		  PulseIntervalMin $CAS_Train_PulseIntervalMin \
		  PulseIntervalMax $CAS_Train_PulseIntervalMax \
		  PulseIntervalNom $CAS_Train_PulseIntervalNom \
		  PreTrainInterval $CAS_Train_PreTrainInterval \
		  InterPulseIntervalMin $CAS_Train_InterPulseIntervalMin \
		  InterPulseIntervalMax $CAS_Train_InterPulseIntervalMax \
		  InterPulseIntervalNom $CAS_Train_InterPulseIntervalNom \
		  PostTrainInterval $CAS_Train_PostTrainInterval \
		  DigitCount $CAS_Train_DigitCount \
		  DigitList [list -Count DigitCount \
			     -DataType [list \
					    PulseCount $CAS_Train_Digit_PulseCount \
					    Label $CAS_MsgDefTrain_Digit_Label \
					    ] \
			     ] \
		  ]
set CAS_Sequence_t [list \
			PulseTrainRef $CAS_Sequence_PulseTrainRef \
			PreSeqInterval $CAS_Sequence_PreSeqInterval \
			InterTrainIntervalMin $CAS_Sequence_InterTrainIntervalMin \
			InterTrainIntervalMax $CAS_Sequence_InterTrainIntervalMax \
			InterTrainIntervalNom $CAS_Sequence_InterTrainIntervalNom \
			PostSeqInterval $CAS_Sequence_PostSeqInterval \
		       ]
CASComponent_TypeDefs define -MsgType CAS_MsgDefineSignal \
    -TypeDef [list \
		  SignalId $CAS_MsgDefineSignal_SignalId \
		  SignalType $CAS_MsgDefineSignal_SignalType \
		  SignalDefinition [list -Switch SignalType \
					-Cases [list \
						    $CAS_SignalType_Transition [list -DataType $CAS_Transition_t] \
						    $CAS_SignalType_Pulse [list -DataType $CAS_Pulse_t] \
						    $CAS_SignalType_Train [list -DataType $CAS_Train_t] \
						    $CAS_SignalType_Sequence [list -DataType $CAS_Sequence_t] \
						    default [list -DataType $QT_UINT8 -Count -1] \
						    ] \
					] \
		  ]
CASComponent_TypeDefs define -MsgType CAS_MsgDefineSignalCmplt \
    -TypeDef {}
CASComponent_TypeDefs define -MsgType CAS_MsgRedefineSignal \
    -TypeDef [list \
		  SignalId $CAS_MsgRedefineSignal_SignalId \
		  SignalType $CAS_MsgRedefineSignal_SignalType \
		  SignalDefinition [list -Switch SignalType \
					-Cases [list \
						    $CAS_SignalType_Transition [list -DataType $CAS_Transition_t] \
						    $CAS_SignalType_Pulse [list -DataType $CAS_Pulse_t] \
						    $CAS_SignalType_Train [list -DataType $CAS_Train_t] \
						    $CAS_SignalType_Sequence [list -DataType $CAS_Sequence_t] \
						    default [list -DataType $QT_UINT8 -Count -1] \
						    ] \
					] \
		  ]
CASComponent_TypeDefs define -MsgType CAS_MsgRedefineSignalCmplt \
    -TypeDef {}
CASComponent_TypeDefs define -MsgType CAS_MsgGetSignalDefinition \
    -TypeDef [list \
		  SignalId $CAS_MsgGetSignalDefinition_SignalId \
		  ]
CASComponent_TypeDefs define -MsgType CAS_MsgGetSignalDefinitionCmplt \
    -TypeDef [list \
		  SignalId $CAS_MsgGetSignalDefinitionCmplt_SignalId \
		  SignalType $CAS_MsgGetSignalDefinitionCmplt_SignalType \
		  SignalDefinition [list -Switch SignalType \
					-Cases [list \
						    $CAS_SignalType_Transition [list -DataType $CAS_Transition_t] \
						    $CAS_SignalType_Pulse [list -DataType $CAS_Pulse_t] \
						    $CAS_SignalType_Train [list -DataType $CAS_Train_t] \
						    $CAS_SignalType_Sequence [list -DataType $CAS_Sequence_t] \
						    default [list -DataType $QT_UINT8 -Count -1] \
						    ] \
					] \
		  ]
CASComponent defineMsgMethod -MethodName DefineTransition \
    -Type $CAS_MsgDefTransition -TypeDef lookup \
    -RetType $CAS_MsgDefSignalCmplt -RetTypeDef lookup
CASComponent defineMsgMethod -MethodName DefinePulse \
    -Type $CAS_MsgDefPulse -TypeDef lookup \
    -RetType $CAS_MsgDefSignalCmplt -RetTypeDef lookup
CASComponent defineMsgMethod -MethodName DefineTrain \
    -Type $CAS_MsgDefTrain -TypeDef lookup -Defaults {-DigitCount {}} \
    -RetType $CAS_MsgDefSignalCmplt -RetTypeDef lookup
CASComponent defineMsgMethod -MethodName DefineSequence \
    -Type $CAS_MsgDefSequence -TypeDef lookup \
    -RetType $CAS_MsgDefSignalCmplt -RetTypeDef lookup
CASComponent defineMsgMethod -MethodName DeleteSignal \
    -Type $CAS_MsgDeleteSignal -TypeDef lookup \
    -RetType $CAS_MsgDeleteSignalCmplt -RetTypeDef lookup
CASComponent defineMsgMethod -MethodName DefineSignal \
    -Type $CAS_MsgDefineSignal -TypeDef lookup \
    -RetType $CAS_MsgDefineSignalCmplt -RetTypeDef lookup
CASComponent defineMsgMethod -MethodName RedefineSignal \
    -Type $CAS_MsgRedefineSignal -TypeDef lookup \
    -RetType $CAS_MsgRedefineSignalCmplt -RetTypeDef lookup
CASComponent defineMsgMethod -MethodName GetSignalDefinition \
    -Type $CAS_MsgGetSignalDefinition -TypeDef lookup \
    -RetType $CAS_MsgGetSignalDefinitionCmplt -RetTypeDef lookup
return

