# Dialogic Version String. Do not edit this or next line.\
DLcid 03000001-11 dm3_qtech
# Do not edit previous line.
################################################################
#
#   Copyright (C) 2005 Intel Corporation.
#
#   All Rights Reserved.  All names, products,
#   and services mentioned herein are the trademarks
#   or registered trademarks of their respective organizations
#   and are the sole property of their respective owners.
#
################################################################

#don't source the script more then once
if [info exists CAS] {
    return
}

source ${qscript_library}/cas_defs.qs
unset CAS

#this line helps the auto loader find this class
proc CAS {} {}

catch {AddressableClass new -Name CAS -init {-Extends Instance}}
CAS set ComponentType $CAS_Std_ComponentType
CAS set typeDefRegistry CAS_TypeDefs

#Error code descriptions
set QS_ErrorCode_Descriptions($CAS_ErrSignalEnabled) {CAS_ErrSignalEnabled: The signal referenced is already enabled for the instance.}
set QS_ErrorCode_Descriptions($CAS_ErrDigitLabelUndefined) {CAS_ErrDigitLabelUndefined: The specified digit label is not recognized.}
set QS_ErrorCode_Descriptions($CAS_ErrSignalId) {CAS_ErrSignalId: The signal identifier is invalid, or, in the case of MsgDefineSignal, has been previously defined.}
set QS_ErrorCode_Descriptions($CAS_ErrSignalType) {CAS_ErrSignalType: The Signal Type is invalid.}
set QS_ErrorCode_Descriptions($CAS_ErrPulseTrainRef) {CAS_ErrPulseTrainRef: The Pulse Train Signal Id Reference is invalid.}
set QS_ErrorCode_Descriptions($CAS_ErrMaxDigitsExceeded) {CAS_ErrMaxDigitsExceeded: The maximum number of definable digits has been exceeded in a train definition, or in the case of MsgDial the string exceeded the maximum allowable length.}
CAS method init {args} {
    eval $this super init $args
    global CAS_MsgGenerateSignalCmplt CAS_MsgDialCmplt
    $this asyncRegister -MsgType $CAS_MsgGenerateSignalCmplt -TypeDef {} -Proc {}
    $this asyncRegister -MsgType $CAS_MsgDialCmplt -TypeDef {} -Proc {}
    return
}

#***CAS_TypeDefs*****
#this object is a database of typedefs which can be automatically recognized by
#the an CAS object, it also recognizes all types specified in StdResource_TypeDefs

TypeDefRegistry new -Name CAS_TypeDefs \
    -init [list -Extends [[CAS set Extends] set typeDefRegistry]]
CAS_TypeDefs define -MsgType CAS_EvtDetectedSignal \
    -TypeDef [list \
		  SignalId $CAS_EvtDetectedSignal_SignalId \
		  Timestamp $CAS_EvtDetectedSignal_Timestamp \
		  Count $CAS_EvtDetectedSignal_Count \
		  Format $CAS_EvtDetectedSignal_Format \
		  SignalList [list -Switch Format \
				  -Cases [list \
					      $CAS_SignalListFormat_PulseCountsArray [list -Count Count -DataType $QT_UINT8] \
					      $CAS_SignalListFormat_LabelString [list -DataType $QT_CHAR -Count Count] \
					      $CAS_SignalListFormat_LabelArray [list -Count Count -DataType $QT_CHAR] \
					      default [list -Count Count -DataType $QT_UINT8]
					      ] \
			      ] \
		 ]
CAS_TypeDefs define -MsgType CAS_MsgDisableSignal \
    -TypeDef [list \
		  SignalId $CAS_MsgDisableSignal_SignalId \
		  ]
CAS_TypeDefs define -MsgType CAS_MsgDisableSignalCmplt \
    -TypeDef {}
CAS_TypeDefs define -MsgType CAS_MsgEnableSignal \
    -TypeDef [list \
		  SignalId $CAS_MsgEnableSignal_SignalId \
		  ]
CAS_TypeDefs define -MsgType CAS_MsgEnableSignalCmplt \
    -TypeDef {}
CAS_TypeDefs define -MsgType CAS_MsgGenerateSignal \
    -TypeDef [list \
		  SignalId $CAS_MsgGenerateSignal_SignalId \
		  Count $CAS_MsgGenerateSignal_Count \
		  Format $CAS_MsgGenerateSignal_Format \
		  SignalList [list -Switch Format \
				  -Cases [list \
					      $CAS_SignalListFormat_PulseCountsArray [list -Count Count -DataType $QT_UINT8] \
					      $CAS_SignalListFormat_LabelString [list -DataType $QT_CHAR -Count Count] \
					      $CAS_SignalListFormat_LabelArray [list -Count Count -DataType $QT_CHAR] \
					      default [list -Count Count -DataType $QT_UINT8]
					      ] \
			      ] \
		  ]
CAS_TypeDefs define -MsgType CAS_MsgGenerateSignalCmplt \
    -TypeDef {}
CAS_TypeDefs define -MsgType CAS_MsgDial \
    -TypeDef [list \
		  SignalId $CAS_MsgDial_SignalId \
		  DigitString $CAS_MsgDial_DigitString \
		  ]
CAS_TypeDefs define -MsgType CAS_MsgDialCmplt \
    -TypeDef [list \
		  Reason $CAS_MsgDialCmplt_Reason \
		  ]
CAS_TypeDefs define -MsgType CAS_MsgStopSignal \
    -TypeDef {}
CAS_TypeDefs define -MsgType CAS_MsgMatchCondition \
    -TypeDef [list \
		  SignalId $CAS_MsgMatchCondition_SignalId \
		  Condition $CAS_MsgMatchCondition_Condition \
		  ]
CAS_TypeDefs define -MsgType CAS_MsgMatchConditionCmplt \
    -TypeDef [list \
		  SignalId $CAS_MsgMatchConditionCmplt_SignalId \
		  Condition $CAS_MsgMatchConditionCmplt_Condition \
		  Match $CAS_MsgMatchConditionCmplt_Match \
		  ]
CAS_TypeDefs define -EvtGroup CAS_EventId_AllSignals \
    -TypeDef [list \
		  EvtGroup $CAS_RTCEvtDetectedSignal_Label \
		  SignalId $CAS_RTCEvtDetectedSignal_SignalId \
		  Direction $CAS_RTCEvtDetectedSignal_Direction \
		  Timestamp $CAS_RTCEvtDetectedSignal_Timestamp \
		  Count $CAS_RTCEvtDetectedSignal_Count \
		  Format $CAS_RTCEvtDetectedSignal_Format \
		  SignalList [list -Switch Format \
				  -Cases [list \
					      $CAS_SignalListFormat_PulseCountsArray [list -Count Count -DataType $QT_UINT8] \
					      $CAS_SignalListFormat_LabelString [list -DataType $QT_CHAR -Count Count] \
					      $CAS_SignalListFormat_LabelArray [list -Count Count -DataType $QT_CHAR] \
					      default [list -Count Count -DataType $QT_UINT8]
					      ] \
			      ] \
		 ]
CAS_TypeDefs define -EvtGroup CAS_EventId_AllTransitions \
    -TypeDef [list \
		  EvtGroup $CAS_EvtDetectedTransition_Label \
		  PreTransCode $CAS_EvtDetectedTransition_PreTransCode \
		  PostTransCode $CAS_EvtDetectedTransition_PostTransCode \
		  Direction $CAS_EvtDetectedTransition_Direction \
		  Timestamp $CAS_EvtDetectedTransition_Timestamp \
		 ]
CAS defineMsgMethod -MethodName DisableSignal \
    -Type $CAS_MsgDisableSignal -TypeDef lookup \
    -RetType $CAS_MsgDisableSignalCmplt -RetTypeDef lookup
CAS defineMsgMethod -MethodName EnableSignal \
    -Type $CAS_MsgEnableSignal -TypeDef lookup \
    -RetType $CAS_MsgEnableSignalCmplt -RetTypeDef lookup
CAS defineMsgMethod -MethodName GenerateSignal \
    -Type $CAS_MsgGenerateSignal -TypeDef lookup -Defaults {-Count {} -Format {} -SignalList {}} \
    -RetType $CAS_MsgGenerateSignalCmplt -RetTypeDef lookup
CAS defineMsgMethod -MethodName StartGenerateSignal \
    -Type $CAS_MsgGenerateSignal -TypeDef lookup -Defaults {-Count {} -Format {} -SignalList {}}
CAS defineMsgMethod -MethodName Dial \
    -Type $CAS_MsgDial -TypeDef lookup \
    -RetType $CAS_MsgDialCmplt -RetTypeDef lookup
CAS defineMsgMethod -MethodName StartDial \
    -Type $CAS_MsgDial -TypeDef lookup
CAS defineMsgMethod -MethodName StopSignal \
    -Type $CAS_MsgStopSignal -TypeDef lookup
CAS defineMsgMethod -MethodName MatchCondition \
    -Type $CAS_MsgMatchCondition -TypeDef lookup \
    -RetType $CAS_MsgMatchConditionCmplt -RetTypeDef lookup

