# Dialogic Version String. Do not edit this or next line.\
DLcid 03000001-11 dm3_qtech
# Do not edit previous line.
################################################################
#
#   Copyright (C) 2005 Intel Corporation.
#
#   All Rights Reserved.  All names, products,
#   and services mentioned herein are the trademarks
#   or registered trademarks of their respective organizations
#   and are the sole property of their respective owners.
#
################################################################

#don't source the script more then once
if [info exists EvtCallback] {
    return
}

#this line helps the auto loader find this class
proc EvtCallback {} {}


catch {class new -Name EvtCallback}


set QS_ErrorCode_Descriptions(MsgFromUnregisteredSource) {The following message was received from a source which has not registered with the event callback manager.}
set QS_ErrorCode_Descriptions(UnregisteredEvent) {Unregistered event from registered source}

#EvtCallback_init
#-Addressable - The Source to monitor
EvtCallback method init {args} {
    $this super init

    array set check [CheckParms -Proc EvtCallback_register -Provided $args \
			 -Required {-Addressable}]

    array set parms $check(Flags)

    $this public addr SrcDesc typeDefRegistry
    
    set addr $parms(-Addressable)
    set SrcDesc [OrderDesc [$addr set TgtDesc]]
    set typeDefRegistry [$addr Class set typeDefRegistry]

    global QS_CallbackRegistry


    if [info exists QS_CallbackRegistry($SrcDesc)] {
	error "A EvtCallback object already exists for Descriptor $SrcDesc"
    }

    #register this object to handle async message from given source
    set QS_CallbackRegistry($SrcDesc) [list $this invoke]

    #register the default Unregistered callback
    $this register -Unregistered -Obj $this -Proc UnregisteredEvt -TypeDef Msg

};#endof EvtCallback_init

#EvtCallback_destroy
EvtCallback method destroy {} {
    global QS_CallbackRegistry
    unset QS_CallbackRegistry([$this set SrcDesc])
    $this super destroy
};#endof EvtCallback_destroy



#EvtCallback_register - register a callback on for an Event
#***Inputs***
#-Proc - procedure to call on event
#[-MsgType] - Message Type to watch for (defaults to Std_MsgDetectEvt)
#[-EvtGroup] - Event Group to watch for
#[-TypeDef] - TypeDef to use to interpret the msg, Msg = return the Msg
#[-Obj] - call method specified by -Proc within obj
#****Switches****
#[-Unregistered] - set callback for Unregistered events
EvtCallback method register {args} {
    array set check [CheckParms -Proc EvtCallback_register -Provided $args \
			     -Required {-Proc} -Optional {-MsgType -EvtGroup
				 -Obj -TypeDef} -Switches {-Unregistered}]
    
    array set parms $check(Flags)
    
    #handle required arguments
    set Proc $parms(-Proc)

    #handle optional arguments
    if [catch {set type $parms(-MsgType)} result] {
	global Std_MsgEvtDetected
	set type $Std_MsgEvtDetected
    }

    if [catch {set label $parms(-EvtGroup)} result] {
	set label 0x0
    }


    if [catch {set td $parms(-TypeDef)} result] {
	set td lookup
    }

    if [catch {set obj $parms(-Obj)} result] {
	set obj {}
    }


    #setup evtId
    if {[lsearch -exact $check(Switches) "-Unregistered"]==-1} {
	set evtId [list Event_[list MsgType [format "0x%x" $type] EvtLabel [format "0x%x" $label]]]
    } else {
	set evtId Event_Unregistered
    }
    
    $this public $evtId

    lappend $evtId [list Obj $obj Proc $Proc TypeDef $td]

};#enof EvtCallback_register


#EvtCallback_cancel - cancel a registered callback handler
#-Proc - the callback to cancel
#[-MsgType] - Message Type to callback to disable (defaults to Std_MsgDetectEvt)
#[-EvtGroup] - Event Label to disable
#[-Obj] - the object which proc applies to
EvtCallback method cancel {args} {
    global QS_CallbackRegistry
    
    array set check [CheckParms -Proc EvtCallback_register -Provided $args \
			 -Required {-Proc} -Optional {-MsgType -EvtGroup -Obj}]
    
    array set parms $check(Flags)

    set Proc $parms(-Proc)
 
    #handle optional arguments
    if [catch {set type $parms(-MsgType)} result] {
	global Std_MsgEvtDetected
	set type $Std_MsgEvtDetected
    }

    if [catch {set label $parms(-EvtGroup)} result] {
	set label 0x0
    }

    if [catch {set obj $parms(-Obj)} result] {
	set obj {}
    }

    set evtId [list Event_[list MsgType [format "0x%x" $type] \
			       EvtLabel [format "0x%x" $label]]]

    $this public $evtId

    set newCallBackList {}
    set removed 0
    foreach callback [set $evtId] {
	array set cb $callback

	if {$cb(Obj)==$obj && $cb(Proc)==$Proc} {
	    #don't insert this callback into the new list
	    incr removed
	} else {
	    #this one doesn't match remove pattern, insert it into new list
	    lappend newCallBackList $callback
	}
    }

    if {$removed == 0} {
	QS_ERROR -Error NoMatchingEvent -Data [list $evtId [list Obj $obj Proc $proc]] 
    }

    #replace old callback list with new one
    set $evtId $newCallBackList
    
    # DM3ktest bug - asyncCancel needs to remove the callback entry for the SrcDesc
    unset QS_CallbackRegistry([$this set SrcDesc])

    return
};#endof EvtCallback_cancel


#EvtCallback_invoke - invoke a callback on a give EvtId
#msg - the async msg that came in
EvtCallback method invoke {msg} {

    set offset 0

    #get EvtId
    array set head [$msg set Head]

    set type $head(Type)

    global Std_MsgEvtDetected
 
    if {$type == $Std_MsgEvtDetected} {
	#get label
	global Std_MsgEvtDetected_Label QT_UINT8
	if [catch {
	    #set default TypeDef to std_MsgEvtDetected
	    $msg set TypeDef [list EvtGroup $Std_MsgEvtDetected_Label Data [list -DataType $QT_UINT8 -Count -1]]

	    array set data [$msg bodyGet -Offset 0 -TypeDef [list Label $Std_MsgEvtDetected_Label]]


	    set label $data(Label)

	    unset data
	    set lookup_type -EvtGroup
	    set lookup_key $label
	} result] {
		set label 0x0
		set lookup_type -MsgType
		set lookup_key $type
	}
    } else {
	set label 0x0
	set lookup_type -MsgType
	set lookup_key $type
    }

    set EvtId [list Event_[list MsgType [format "0x%x" $type] \
			       EvtLabel [format "0x%x" $label]]]

    #lookup callback
   
    $this public $EvtId addr typeDefRegistry
    
    if ![info exists $EvtId] {
	#not a registered event
	set EvtId Event_Unregistered
	$this public $EvtId
    } else {
	if {[set $EvtId] == {}} {
	    #not a registered event
	    set EvtId Event_Unregistered
	    $this public $EvtId
	}
    }

    


    #set offset [$msg set Offset]
    set offset 0

    foreach callback [set $EvtId] {
	array set handle $callback
	
	if {$handle(TypeDef) == "lookup"} {
	    #lookup the TypeDef
	    catch {$msg set TypeDef [$typeDefRegistry lookup $lookup_type $lookup_key]}
	} else {
	    if {$handle(TypeDef)!="Msg"} {
		$msg set TypeDef $handle(TypeDef)
	    }
	}

	if {$handle(TypeDef) == "Msg"} {
	    #give a copy of the msg as input
	    set newMsg [$msg clone]
	    catch {$newMsg set TypeDef [$typeDefRegistry lookup $lookup_type $lookup_key]}
	    set retval $newMsg
	} else {
	    #parse the message
	    set data [$msg bodyGet -Offset $offset]
	    #$msg destroy
	    set retval $data
	}

	#the afters are used so that I can process all callbacks before
	#any are called
	if {$handle(Obj) == {} && [lindex $handle(Proc) 0] == "set"} {
	    #special case if proc is "set varname"
	    after 10 $handle(Proc) [list [list $addr $type $retval]]
	} else {
	    if {$handle(Obj) == {}} {
		#if handle(Obj) and handle(Proc) are both {} then don't call any handler
		if {$handle(Proc)!= {}} {
		    after 10 [list $handle(Proc) $addr $type $retval]
		}
	    } else {
		after 10 [list $handle(Obj) $handle(Proc) $addr $type $retval]
	    }
	}
    }
    $msg destroy
    return
};#endof EvtCallback_invoke

#EvtCallback_UnregisteredEvt - a default callback handler for unregistered events
EvtCallback method UnregisteredEvt {src type msg} {

    set offset 0

    #get EvtId
    array set head [$msg set Head]

    set type $head(Type)

    global Std_MsgEvtDetected

    if {$type == $Std_MsgEvtDetected} {
	#get label
	global Std_MsgEvtDetected_Label QT_UINT8
	if [catch {
	    array set data [$msg bodyGet -Offset 0 -TypeDef [list Label $Std_MsgEvtDetected_Label]]

	    $msg set TypeDef [list EvtGroup $Std_MsgEvtDetected_Label Data [list -DataType $QT_UINT8 -Count -1]]
	    set label $data(Label)

	    unset data
	    set lookup_type -EvtGroup
	    set lookup_key $label
	} result] {
	    set label 0x0
	    set lookup_type -MsgType
	    set lookup_key $type
	}
    } else {
	set label 0x0
	set lookup_type -MsgType
	set lookup_key $type
    }
    
    $this public typeDefRegistry
    unset head
    $msg public TypeDef

    catch {set TypeDef [$typeDefRegistry lookup $lookup_type $lookup_key]}

    puts stderr "\n************************************"
    puts stderr "Unregistered Message for $src\n"


   
    if [catch {set body [$msg bodyGet -Offset 0]} result] {
		global QT_UINT8
		set TypeDef [list -ByteData [list -DataType $QT_UINT8 -Count -1]]
		set body [$msg bodyGet -Offset 0]
    }

    set head [$msg set Head]
    puts stderr "head: $head\n"
    puts stderr "body: $body"
    puts stderr "************************************\n"

    $msg destroy
    QS_Error -Error "UnregisteredMessage" -Data "Source: $src\nHead: $head\nBody: $body"
    return
};#EvtCallback_UnregisteredEvt



#this func receives all async msgs
proc QSAsyncMsgHandler { data } {
    #make msg object
    array set datain $data

    set msg [Msg new]
    $msg public MsgRef Head

    set MsgRef $datain(MsgRef)
    set Head [QS_MsgRefGetHead $MsgRef]

	
    #msg object made

    array set head $Head

    global QS_CallbackRegistry

    if [catch {set cb $QS_CallbackRegistry($head(Source))} result ] {
	#EvtCallback object not found for this SrcDesc
	#lookup type in the StdResource typedef registry
	set tdr [StdResource set typeDefRegistry]
	
	catch {$msg set TypeDef [$tdr lookup -MsgType $Head(Type)]}

	set cb $QS_CallbackRegistry(Unregistered)
    }

    if {[llength $cb]==2} {
	set obj [lindex $cb 0]
	set method [lindex $cb 1]
	after 0 "$obj $method $msg"
    } else {
	after 0 "$cb $msg"
    }
    return

};#QSAsyncMsgHandler


#default handler for async messages from unregistered sources
proc UnregisteredSourceHandler {msg} {
    set offset 0

    #get EvtId
    array set head [$msg set Head]

    set type $head(Type)

    global Std_MsgEvtDetected
    
    if {$type == $Std_MsgEvtDetected} {
	#get label
	global Std_MsgEvtDetected_Label QT_UINT8
	if [catch {
		array set data [$msg bodyGet -Offset 0 -TypeDef [list Label $Std_MsgEvtDetected_Label]]

		set label $data(Label)


	    $msg set TypeDef [list EvtGroup $Std_MsgEvtDetected_Label Data [list -DataType $QT_UINT8 -Count -1]]

		unset data
		set lookup_type -EvtGroup
		set lookup_key $label
	} result] {
		set label 0x0
		set lookup_type -MsgType
		set lookup_key $type
	}
    } else {
	set label 0x0
	set lookup_type -MsgType
	set lookup_key $type
    }
    
    set typeDefRegistry [StdResource set typeDefRegistry]
    unset head

    catch {$msg set TypeDef [$typeDefRegistry lookup $lookup_type $lookup_key]}



    if [catch {set body [$msg bodyGet -Offset 0]} result] {
		global QT_UINT8
		$msg set TypeDef [list -ByteData [list -DataType $QT_UINT8 -Count -1]]
		set body [$msg bodyGet -Offset 0]
    }

    puts stderr "\n***************************************"
    puts stderr "Message arrived for unregistered source"
    $msg bodyPuts stderr
    puts stderr "***************************************\n"
    set head [$msg set Head]

    $msg destroy
    QS_Error -Error "MsgFromUnregisteredSource" -Data "Head: $head\nBody: $body"
    return
};#endof UnregisteredSourceHandler


set QS_CallbackRegistry(Unregistered) UnregisteredSourceHandler

#OrderDesc - puts a descriptor in the proper order
#****Inputs***
#descriptor - descriptor to be ordered
#****Outputs***
#descriptor - ordered descriptor
proc OrderDesc {origDesc} {
    array set oDesc $origDesc

    lappend desc Node [format "0x%x" $oDesc(Node)]
    lappend desc Board [format "0x%x" $oDesc(Board)]
    lappend desc Processor [format "0x%x" $oDesc(Processor)]
    lappend desc Component [format "0x%x" $oDesc(Component)]
    lappend desc Instance [format "0x%x" $oDesc(Instance)]

    return $desc
};#endof OrderDesc





#waiter class, subclass of EvtCallback

EvtCallback set AsyncWait [class new]


[EvtCallback set AsyncWait] method init {args} {
    $this super init

    array set check [CheckParms -Proc {EvtCallback::AsyncWait_init} -Provided $args \
		       	 -Required {-EvtCallback} -Optional {-MsgType -EvtGroup -Timeout -TypeDef}]

    array set parms $check(Flags)

    $this public evtcallback result
    

    #required parms
    set evtcallback $parms(-EvtCallback)


    set result TIMEOUT

    #remove -EvtCallback and call enable if others are specifed
    unset parms(-EvtCallback)

    if [expr [llength [array names parms]] > 0] {
	#check for supplied timeout
	if ![catch {set timeout $parms(-Timeout)} result] {
	    unset parms(-Timeout)
	}
	eval $this enable [array get parms]
	if [info exists timeout] {
	    $this wait -Timeout $timeout
	}
    }
    
    return

};#endof EvtCallback::AsyncWait_init

[EvtCallback set AsyncWait] method destroy {} {

    #make sure it is disabled
    catch {$this disable}

    $this super destroy
};#endof EvtCallback::AsyncWait_destroy

[EvtCallback set AsyncWait] method trigger {obj type data} {

    $this public result

    $this disable

    set result $data

    return
};#endof EvtCallback::AsyncWait_trigger

[EvtCallback set AsyncWait] method enable {args} {

    array set check [CheckParms -Proc {EvtCallback::AsyncWait_enable} -Provided $args \
		       	 -Optional {-MsgType -EvtGroup -TypeDef}]

    array set parms $check(Flags)

    $this public evtcallback enbparms result

    set result TIMEOUT

    set enbparms [array get parms]

    #register an asyc callback
    eval $evtcallback register $enbparms -Obj $this -Proc trigger

    return
};#endof EvtCallback::AsyncWait_enable

[EvtCallback set AsyncWait] method disable {} {


    $this public evtcallback enbparms result
    

    #remove -TypeDef from enbparms if necessary
    array set cancelParms $enbparms
    catch {unset cancelParms(-TypeDef)}

    #register an asyc callback
    eval $evtcallback cancel [array get cancelParms] -Obj $this -Proc trigger

    return
};#endof EvtCallback::AsyncWait_disable





[EvtCallback set AsyncWait] method wait {args} {

    array set check [CheckParms -Proc {EvtCallback::AsyncWait_wait} -Provided $args \
		       	 -Optional {-Timeout}]

    array set parms $check(Flags)


    $this public result evtcallback data

    #check to see if it's already been triggered
    if {$result != "TIMEOUT"} {
	set data $result
	set result TIMEOUT
	return $data
    }

    #set timeout
    if [info exists parms(-Timeout)] {
	set timeout $parms(-Timeout)
	unset parms(-Timeout)    
	set timerid [after $timeout [list $this set result TIMEOUT]]
    } else {
	set timerid NULL
    }

    #wait on variable
    set vwaitvar "$this\(field_result\)"
    vwait $vwaitvar

    #cancel timer
    after cancel $timerid


    #check for timeout
    if {$result == "TIMEOUT"} {
	QS_Error -Error TIMEOUT -Data [array get parms]
    } 
    
    set data $result
    set result TIMEOUT

    #no error, return the data part of the message or event
    return $data


};#endof EvtCallback::AsyncWait_wait


