# Dialogic Version String. Do not edit this or next line.\
DLcid 03000001-11 dm3_qtech
# Do not edit previous line.
################################################################
#
#   Copyright (C) 2005 Intel Corporation.
#
#   All Rights Reserved.  All names, products,
#   and services mentioned herein are the trademarks
#   or registered trademarks of their respective organizations
#   and are the sole property of their respective owners.
#
################################################################

#TypeDefRegistry Class contains TypeDefs for Messages

#don't source the script more then once
if [info exists TypeDefRegistry] {
    return
}


#this line helps the auto loader find this class
proc TypeDefRegistry {} {}


catch {class new -Name TypeDefRegistry -init {-Extends class}}




#TypeDefRegistry_TypeDef - defines a typedef for a type
#***Inputs***
#[-Name] - The name of the typedef, required for autoGen into C++
#[-MsgType] - The message type to define
#[-EvtGroup] - The event type to define
#[-Other] - some other id to use in defining a typedef
#-TypeDef - the definition
TypeDefRegistry method define {args} {
    #puts $args
    array set check [CheckParms -Proc TypeDefRegistry_define -Provided $args \
			 -Required {-TypeDef} -Optional {-Name -MsgType -EvtGroup -Other}]

    array set parms $check(Flags)

    #handle required arguments
    set td $parms(-TypeDef)



    #handle optional arguments
    set head "Msg"
    if [catch {set types $parms(-MsgType)} result] {
	set head "Evt"
	if [catch {set types $parms(-EvtGroup)} result] {
	    set head "Other"
	    if [catch {set types [list $parms(-Other)]} result] {
		error "TypeDefRegistry_TypeDef: must specify -MsgType,-EvtGroup, or -Other"
	    }
	}
    }

    
	    

    if [catch {set names $parms(-Name)} result] {
	set names $types
    }

    set index 0
    #types may be a list
    foreach type $types {
	#defines it as a method, a bit of a cheat, I just use it's look up functions
	if {$head == "Other"} {
	    set type ${head}_$type
	} else {
	    if [catch {expr $type} result] {
		#type is not a number, must have been a name, get it from global scope
		upvar \#0 $type real_type
		if [catch {set type $real_type} result] {
		    #this is done so that a more readable error is generated
		    eval set $type
		}
	    }
	    set type ${head}_[format "0x%x" $type]
	}
	set name [lindex $names $index]
	if ![catch {expr $name}] {
	    #name is just a number, fix this
	    set name ${head}_$name
	}
	$this method $type [list $name $td]
	incr index
    }
    return
};#endof TypeDefRegistry_TypeDef


#TypeDefRegistry_findTypeDef - defines a typedef for a type
#***Inputs***
#[-MsgType] - The message type to find
#[-EvtGroup] - The event type to find
#[-Other] - Find another type
TypeDefRegistry method lookup {args} {
    array set check [CheckParms -Proc TypeDefRegistry_findTypeDef -Provided $args \
			 -Optional {-MsgType -EvtGroup -Other} -Switches {-AllInfo}]

    array set parms $check(Flags)

    #handle optional arguments
    if [catch {set type Msg_[format "0x%x" $parms(-MsgType)]} result] {
	if [catch {set type Evt_[format "0x%x" $parms(-EvtGroup)]} result] {
	    if [catch {set type Other_[list $parms(-Other)]} result] {
		error "TypeDefRegistry_TypeDef: must specify -MsgType,-EvtGroup, or -Other"
	    }
	}
    }


    #uses the clas findMethod funtion to find typedefs
    if [catch {set retval [class_findMethod $this $type]}] {
	error "$this of class [$this set Class] which Extends [$this set Extends] has no TypeDef for $type"
    }
    
    if {[lsearch -exact $check(Switches) "-AllInfo"]!=-1} {
	return $retval
    }
    return [lindex [lindex $retval 1] 1]
};#endof TypeDefRegistry_TypeDef





