# Dialogic Version String. Do not edit this or next line.\
DLcid 03000001-11 dm3_qtech
# Do not edit previous line.
################################################################
#
#   Copyright (C) 2005 Intel Corporation.
#
#   All Rights Reserved.  All names, products,
#   and services mentioned herein are the trademarks
#   or registered trademarks of their respective organizations
#   and are the sole property of their respective owners.
#
################################################################

#don't source the script more then once
if [info exists class] {
    return
}

proc class {} {}

proc class_findMethod {this method} {
    upvar \#0 $this class_obj
    
    #find the method to call
    if [catch {set func $class_obj(method_$method)} result] {
	#method not found, search for it in super class
	
	set func [class_findMethod $class_obj(field_Extends) $method]
	
	#cache the found method
	set class_obj(method_$method) $func
	
    }
    
    return $func
};#endof class_findMethod

proc class_obj_make {objname} {
    set obj_make "proc $objname {method args} \{
	upvar \#0 $objname obj
	upvar \#0 \$obj(field_Class) obj_class
	
	set curr_context \$obj(field_ClassContext)

	if \[catch \{
	if \{\$method == \"super\"\} \{
	    upvar \#0 \$obj(field_ClassContext) obj_context
	    if \[catch \{
		set method \[lindex \$args 0\]
		set args \[lreplace \$args 0 0\]
		
		set \obj(field_ClassContext) \$obj_context(field_Extends)
		
		set func \[class_findMethod \$obj(field_ClassContext) \$method\] 
		\} result\] \{
		    set obj(field_ClassContext) \$obj(field_Class)
		    error \"instance $objname of class \$obj(field_Class) has no super class method \$method\"
		    \}
		    
		    \} elseif \[catch \{ 
			set func \$obj_class(method_\$method)\} result \] \{
			    if \[catch \{
				set func \[class_findMethod \$obj(field_Class) \$method\]
				\} result \] \{
					puts stdout \" \$result \"
				    error \"instance $objname of class \$obj(field_Class) has no method \$method\"
				    \}
				    \}
				    set obj(field_ClassContext) \[lindex \$func 0\]
				    set retval \[uplevel 1 \[lindex \$func 1\] $objname \$args\]
				    \} result \] \{
					set obj(field_ClassContext) \$curr_context
                                        global errorInfo
					error \$result \$errorInfo
				    \}
                                    if \{\$method != \"destroy\"\} \{
				       set obj(field_ClassContext) \$curr_context
                                    \}
				    return \$retval
				    \}"
    #puts $obj_make
    eval $obj_make
				    
};#endof class_obj_make


#class_new
#[-Name] - name for new object, otherwise unique is made
#[-init] - arguments to pass to first init method
#**Switches***
#[-DontInit] - don't call init method (used for cloneing)
#**Exceptions***
#Object already exists
proc class_new {this args} {

    array set check [CheckParms -Proc class_new -Provided $args \
			 -Optional {-Name -init -a} -Switches {-DontInit}]

    array set parms $check(Flags)
    #handle optional arguments


    if [catch {set objname $parms(-Name)} result] {
	$this public instanceCounter Name

	#find a unique name
	while {1} {
	    incr instanceCounter
	    set objname ${Name}_${instanceCounter}
	    upvar \#0 $objname obj
	    if ![info exists obj] {
		break
	    }
	}
    } else {
	#make sure name not in use
	upvar \#0 $objname obj
	if [info exists obj] {
	    error "Object $objname already exists"
	}
    }

    #set new objects class
    set obj(field_Name) $objname
    set obj(field_Class) $this
    set obj(field_ClassContext) $this


    #define new proc for this object
    class_obj_make $objname

    if {[lsearch -exact $check(Switches) "-DontInit"] == -1} {
	#call init method
	if [catch {set initargs $parms(-init)} result] {
	    $objname init
	} else {
	    eval $objname init $initargs
	}
    }

    return $objname
};#endof class_new

#class_init - initializes a class object
#[-Extends] - specify which class to extend, defaults to object
proc class_init {this args} {
    $this super init

    array set check [CheckParms -Proc class_init -Provided $args \
		   -Optional {-Extends}]

    array set parms $check(Flags)

    if [catch {set ext_class $parms(-Extends)} result] {
	$this extends object
    } else {
	$this extends $ext_class
    }

    $this set instanceCounter 0


};#endof class_init

proc class_extend {this ext_classname} {
    upvar \#0 $this class_obj $ext_classname ext
    set class_obj(field_Extends) $ext_classname
    #copy all fields from extended class to current class, don't overwrite existing
    #fields
    set temp [array get class_obj]
    #try to execute the class, this makes sure the auto loader loads it
    catch {eval $ext_classname}
    array set class_obj [array get ext]
    array set class_obj $temp
    return
};#endof class_extend

proc class_listMethods {this} {
    upvar \#0 $this obj
    set list {}
    foreach item [array names obj] {
	if {[string range $item 0 6] == "method_"} {
	    set procname $obj($item)
	    if {[lindex $procname 0] == $this} {
		lappend list [string range $item 7 [string length $item]] 
	    }
	}
    }
    return $list
}

proc class_clone {this} {
    set clone [$this super clone]

    $clone set instanceCounter 0
    
    return $clone
};#endof class_clone

proc class_method {this methodName argListOrProcName {body NOTDEFINED}} {
    upvar \#0 $this class_obj
    if {$body == "NOTDEFINED"} {
	#no body, interpret argListOrProcName as the name of a procedure which defines this method
	set procname $argListOrProcName
    } else {
	#create procedure for this method
	set procname ${this}_$methodName
	#insert this variable at start of argument list
	set argList [linsert $argListOrProcName 0 this]
	proc $procname $argList $body
    }
    #associate procedure with class method
    set class_obj(method_$methodName) [list $this $procname]
};#endof class_method


array set class {
    field_Name class
    field_Class class
    field_Extends object
    field_ClassContext class
    field_instanceCounter 0
    method_init {class class_init}
    method_new {class class_new}
    method_extends {class class_extend}
    method_method {class class_method}
    method_clone {class class_clone}
    method_listMethods {class class_listMethods}
}

#build class object
class_obj_make class

