# Dialogic Version String. Do not edit this or next line.\
DLcid 03000001-11 dm3_qtech
# Do not edit previous line.
################################################################
#
#   Copyright (C) 2005 Intel Corporation.
#
#   All Rights Reserved.  All names, products,
#   and services mentioned herein are the trademarks
#   or registered trademarks of their respective organizations
#   and are the sole property of their respective owners.
#
################################################################

if ![info exists env(QSCRIPT_GEOSAVE)] {
    return
}

rename wm tcl_wm
rename toplevel tcl_toplevel
rename destroy tcl_destroy
rename exit tcl_exit



proc exit {args} {
    #get list of all toplevel windows
    global qs_toplevel_windows
    
    foreach window [array names qs_toplevel_windows] {
	qs_save_geometry $window
    }

    eval tcl_exit $args
}



proc wm {option window args} {
   
    switch -exact $option {
	title {
	    set oldtitle [tcl_wm title $window]
	    set title [lindex $args 0]
	    set retval [eval tcl_wm $option $window $args]
	    if {$title != {} && $oldtitle != $title} {
		#new title
		qs_load_geometry $window
	    }
	    return $retval
	}
    }


    eval tcl_wm $option $window $args
}


proc toplevel {path args} {
 
    set retval [eval tcl_toplevel $path $args]

    if {$args == {}} {
	#window created	
	#register handler
	global qs_toplevel_windows
	wm protocol $path WM_DELETE_WINDOW "destroy $path"
	set qs_toplevel_windows($path) {}

	qs_load_geometry $path
	
    }

    return $retval
}

proc destroy {path args} {
    global qs_toplevel_windows

    if [info exists qs_toplevel_windows($path)] {
	#it's a toplevel window
	qs_save_geometry $path
	unset qs_toplevel_windows($path)
    }

    eval tcl_destroy $path $args
}



proc qs_load_geometry {path} {

    global env qsgeo${path}.title

    if ![info exists qsgeo${path}.title] {


	   set title [tcl_wm title $path]

           set qsgeo${path}.title $title

	   if {$path != {.}} {
		   set title "[tcl_wm title .]_$title"
	   }

	   set filename "$env(QSCRIPT_GEOSAVE)//$title"

	   if [catch {set file [open $filename r]} result] {
		   #file doesn't exist
		   return
	   }
	   
	   catch {tcl_wm geometry $path [read -nonewline $file]}


	   close $file
    }

    return
}


proc qs_save_geometry {path} {
    global env qsgeo${path}.title

    set title [tcl_wm title $path]

    if [info exists qsgeo$path.title] {
      set title [set qsgeo${path}.title]
    } else {
       if {$path != {.}} {
	   set title "[tcl_wm title .]_$title"
       }

       if {$title == {}} {
	   #don't save blank titles
	   return
       }
    }
    
    set filename "$env(QSCRIPT_GEOSAVE)//$title"

    set file [open $filename w]
    
    scan [tcl_wm geometry $path] {%[0-9x]%[+\-0-9]} width pos
    puts -nonewline $file $pos

    close $file
    return
}


tcl_wm protocol . WM_DELETE_WINDOW "exit"

set qs_toplevel_windows(.) {}

