# Dialogic Version String. Do not edit this or next line.\
DLcid 03000001-11 dm3_qtech
# Do not edit previous line.
################################################################
#
#   Copyright (C) 2005 Intel Corporation.
#
#   All Rights Reserved.  All names, products,
#   and services mentioned herein are the trademarks
#   or registered trademarks of their respective organizations
#   and are the sole property of their respective owners.
#
################################################################

set QScript_Version "3.00 alpha 0.06"

catch {
    wm title . "QScript"
    wm iconmask . @${qscript_library}/dialogic_icon.xbm
    wm iconbitmap . @${qscript_library}/dialogic_icon.xbm
}

catch {source ${qscript_library}/geosave.qs}

set QS_GlobalValues(IncludePath) [list . $qscript_library]

#similar to source but looks for the file in all directories in the IncludePath global variable
proc include {filename} {
    global QS_GlobalValues

    foreach path $QS_GlobalValues(IncludePath) {
        set filepath [file join $path $filename]
	if [file exists $filepath] {
	    return [uplevel 1 source \"$filepath\"]
	}
    }

    error "FileNotFound: $filename not found in include path $QS_GlobalValues(IncludePath)"
}
    
#this proc gives tcl events to process  to keep awake, it doesn't load down the system
proc QS_KeepAlive {} {
    global QS_GlobalValues
    after $QS_GlobalValues(KeepAliveTime) QS_KeepAlive
}
   
#this sleep while still processing events
proc QS_Sleep {msec} {
    global QS_GlobalValues
    set timer $QS_GlobalValues(UniqueSleepTimer);
    incr QS_GlobalValues(UniqueSleepTimer);
    after $msec [list set QS_Timer_$timer 1]
    vwait QS_Timer_$timer
    global QS_Timer_$timer
    unset QS_Timer_$timer
    return
}

proc QSAsyncCatch { AsyncProc } {
    if [catch {uplevel \#0 $AsyncProc} catch_result] {
	QSAsyncErrorHandler $catch_result
    } else {
	return $catch_result
    }
}

proc QSAsyncErrorHandler { error } {
    global errorInfo errorCode
    puts stderr "\n**************************"
    puts stderr "QSAsyncErrorHandler Called"
    puts stderr "errorCode = $errorCode"
    puts stderr "*******QScript Trace******"
    puts stderr $errorInfo
    puts stderr "**************************\n"
}

proc QS_Error {args} {
    global QS_ErrorCode_Descriptions   
    array set check [CheckParms -Proc QS_Error -Provided $args \
			 -Required {-Error} \
			 -Optional {-Data}]

    array set parms $check(Flags)
    set error_code $parms(-Error)

    #handle optional flags
    if [catch {set data $parms(-Data)} result] {
	set data {}
    }

    #get the description of error
    if [catch {set error_desc $QS_ErrorCode_Descriptions($error_code)} res] {
	if [catch {set error_desc $QS_ErrorCode_Descriptions(NO_DESCRIPTION)} res] {
	    set error_desc {}
	}
    }

    error "Error $error_code Description {$error_desc} Data {$data}"
}


# QS_ErrorCode_Descriptions is a hash-table containing descriptons of errorCodes
set QS_ErrorCode_Descriptions(NO_DESCRIPTION) {No Description Available}

#QS_GlobalValues contains some default QScript values

#this is for NT which doesn't have an environment variable for host
if ![info exists env(HOST)] {
	if [info exists env(COMPUTERNAME)] {
		set env(HOST) $env(COMPUTERNAME)
	} else {
		set env(HOST) [info hostname]
	}
}

if [info exists env(REMOTE_QHOST)] {
    set QS_GlobalValues(HOST) $env(REMOTE_QHOST)
} else {
    set QS_GlobalValues(HOST) $env(HOST)
}

#Timeout default values in miliseconds, 0 means don't wait at all
set QS_GlobalValues(ResponseTimeout) 5000;#timeout on reading message when response is expected
set QS_GlobalValues(ErrorWaitTime) 1000;#time to wait for a error when there is no expected response

#the following two values don't apply on unix hosts
set QS_GlobalValues(MsgQueue_MaxMsgSize) 512;#default maximum size for received messages
set QS_GlobalValues(MsgQueue_Depth) 15;#default number of messages for a queue to receive at any one time

#when qscript has nothing to do it sits in an idle loop waiting for events, this is the number of msecs between checks, it can be changed at any time
set QS_GlobalValues(KeepAliveTime) 10;
set QS_GlobalValues(UniqueSleepTimer) 1;
set QS_GlobalValues(DefaultStreamerBlockSize) 70000;#the default block trasfer size for streamers
set file_list {util.qs class.qs object.qs
    mercdefs.qs qcluster.qs qcomplib.qs qmsg.qs stddefs.qs tscdefs.qs lcondefs.qs \
    qs_typedefs.qs qkernerr.qs qstream.qs qmmdlpack.qs qoscommon.qs }

foreach file $file_list {
    source ${qscript_library}/$file
}

#these were set in the defs files but are classes in qscript
unset LCON TSC

#start keep alive
QS_KeepAlive
return

