# Dialogic Version String. Do not edit this or next line.\
DLcid 03000001-11 dm3_qtech
# Do not edit previous line.
################################################################
#
#   Copyright (C) 2005 Intel Corporation.
#
#   All Rights Reserved.  All names, products,
#   and services mentioned herein are the trademarks
#   or registered trademarks of their respective organizations
#   and are the sole property of their respective owners.
#
################################################################

source ${qscript_library}/SigDet_Class.qs

cd $qscript_path

set MAXDIGITS 1000
set tickinterval 1000
set ticksOn 0
set digitScroll 1 ;#contols if the entry scrolls with digits
set tickScroll 0; #contols if the entry scrolls with digits

#parse command line arguments
if [catch {array set check [CheckParms -Proc digitdetector.qs -Provided $argv_clean -Required {-board} \
				-Optional {-line -chan -format -maxdigits -tickinterval} -Switches {-OffDetection -ticks}]} result ] {
    puts stderr $result
    return
}

proc quit { } {
    global sigdet
    $sigdet destroy
    exit
}

wm protocol . WM_DELETE_WINDOW quit

#main
#default values
set line 1
set chan 1
set offdet 0

#command line arguments
array set argvarr $check(Flags)
set boardnum $argvarr(-board)

if [info exists argvarr(-line)] {set line $argvarr(-line)}
if [info exists argvarr(-chan)] {set chan $argvarr(-chan)}
if [info exists argvarr(-maxdigits)] {set MAXDIGITS $argvarr(-maxdigits)}
if [info exists argvarr(-tickinterval)] {set tickinterval $argvarr(-tickinterval);set ticksOn 1}

if [expr [lsearch -exact $check(Switches) {-OffDetection}] != -1] {
    set offdet 1
}

if [expr [lsearch -exact $check(Switches) {-ticks}] != -1] {
    set ticksOn 1
}
# Build display
frame .display
entry .display.digits -textvariable digits -relief sunken
pack .display.digits -expand true -fill x
pack .display -expand true -fill x


set mnu [menu .display.mnu -tearoff false]

$mnu add checkbutton -label Ticks -variable ticksOn


#sub menu scroll
set scrlMnu [menu .display.mnu.scrll -tearoff false]
$mnu add cascade -label Scroll -menu $scrlMnu
$scrlMnu add checkbutton -label WithTicks -variable tickScroll
$scrlMnu add checkbutton -label WithDigits -variable digitScroll


foreach opt {Clear Reset Exit} {
    $mnu add command -label $opt -command cmd_$opt
}

#bind right mouse button to bring up menu
bind .display.digits <ButtonPress-3> {tk_popup $mnu %X %Y}


proc cmd_Clear {} {
    global digits
    set digits {}
}

proc cmd_Reset {} {   
    cmd_Clear
    detectEvts
}

proc cmd_Exit {} {
    quit
}

#find cluster
set board [Board new -init [list -BoardNum $boardnum]]

set clust [$board findClust -Attrs [list \
			 [list -key $Std_ComponentType -value $TSC_Std_ComponentType] \
					[list -key $TSC_AttrLineId -value $line] \
					[list -key $TSC_AttrChanId -value $chan] ] ]

if [catch {set sigdet [$clust find -InstClass SigDet -AutoAllocate]} result] {
	puts "No Signal Detecor in cluster"
	exit
}

proc handleSignalOn {obj type evt} {

	global digits MAXDIGITS digitScroll

	array set info $evt

	append digits [format "%c" [lindex $info(signalLabel) 0]]

	if {[string length $digits] > $MAXDIGITS} {
	    #remove first digit
	    .display.digits delete 0 1
	}
	
	if [expr $digitScroll] {
	    .display.digits	xview end
	}
}

proc handleSignalOff {obj type evt} {

	global digits MAXDIGITS digitScroll

	array set info $evt

	append digits [format "{%c}" [lindex $info(signalLabel) 0]]

	if {[string length $digits] > $MAXDIGITS} {
	    #remove first digit
	    .display.digits delete 0 1
	}

	if [expr $digitScroll] {
	    .display.digits	xview end
	}
}



proc detectEvts {} {
    global format_list sigdet SD_DetectEvt_Type_SignalOn offdet SD_DetectEvt_Type_SignalOff
    foreach id $format_list {
	$sigdet DetectEvt -EvtType $SD_DetectEvt_Type_SignalOn -SignalId $id
	if [expr $offdet == 1] {
	    $sigdet DetectEvt -EvtType $SD_DetectEvt_Type_SignalOff -SignalId $id
	}
    }
}

$sigdet asyncRegister -EvtGroup $SD_DetectEvt_Type_SignalOn -Proc handleSignalOn
$sigdet asyncRegister -EvtGroup $SD_DetectEvt_Type_SignalOff -Proc handleSignalOff



if [info exists argvarr(-format)] {
    set format $argvarr(-format)
    
} else {
    set format US_DTMF_SET
}



wm title . [list DM3 Digit Detector $boardnum.$line.$chan $format]

#make window large enough to see the title
set xsize [string length [wm title .]]
.display.digits configure -width [expr $xsize + 5]

set format_list {}
#test if format is a number
foreach id $format {
    if [catch {expr $id} result] {
	global $id
	#not a number, assume it is a globaly defined variable
	set id [set $id]
    }
    set format_list [concat $format_list $id]
}


detectEvts

#tick stuff
if [expr $tickinterval != 0] {
    while [expr 1] {
	QS_Sleep $tickinterval
	if {[expr $ticksOn]} {
	    #ticks are turned on append a . every tick interval
	    append digits .
	    if {[string length $digits] > $MAXDIGITS} {
		#remove first digit
		.display.digits delete 0 1
	    }

	    if [expr $tickScroll] {
		.display.digits	xview end
	    }
	} else {
	    #ticks are disabled, wait for the flag to change
	    vwait ticksOn
	}
    }
}

