# Dialogic Version String. Do not edit this or next line.\
DLcid 03000001-11 dm3_qtech
# Do not edit previous line.
################################################################
#
#   Copyright (C) 2005 Intel Corporation.
#
#   All Rights Reserved.  All names, products,
#   and services mentioned herein are the trademarks
#   or registered trademarks of their respective organizations
#   and are the sole property of their respective owners.
#
################################################################

set version 1.9
set rundir [pwd]
cd ${qscript_path}
source pstndiag_strings.qs
catch {AddressableClass new -Name LCONComponent -init {-Extends Component}}
LCONComponent set ComponentType $LCON_Std_ComponentType

# Override default handler for async messages from unregistered sources
catch {EvtCallback}
proc UnregisteredSourceHandler {msg} {
    return
}

proc CreateLog { filename } {
    global RunLog
    set RunLog(Filename) $filename
    set RunLog(Counter) 0
    set RunLog(Active) 1
    set RunLog(msSync) [clock clicks -milliseconds]
    set RunLog(Filehandle) [open $RunLog(Filename) "w+"]
    set RunLog(Monitor) {}
    fconfigure $RunLog(Filehandle) -encoding binary -translation binary
    set headerBuf "PSTNDiag log v01.00. \xd\xaUse PSTNDiag to view.\xd\xa"
    puts -nonewline $RunLog(Filehandle) [binary format a1024 $headerBuf]
    LogAppEvent -1 0 0 LogStarted
}

proc CloseLog {} {
    global RunLog
    LogAppEvent -1 0 0 LogClosed
    if {$RunLog(Filehandle) != ""} {
	close $RunLog(Filehandle)
    }
}

proc ResumeLog {} {
    global RunLog startup
    if {$RunLog(Filehandle) == ""} {
	CreateLog $startup(LogFile)
    }
    set RunLog(Active) 1
    LogAppEvent -1 0 0 LogResumed
}

proc SuspendLog {} {
    global RunLog
    set RunLog(Active) 1
    LogAppEvent -1 0 0 LogSuspended
    set RunLog(Active) 0
}

proc Log { type board line chan data } {
    global RunLog
    if {!$RunLog(Active)} {
	return
    }
    set ts [clock seconds]
    set diff [expr [clock clicks -milliseconds]-$RunLog(msSync)]
    set sf [binary format IIcccca* $ts $diff \
	    $type $board $line $chan $data]
    set subtotal [expr ([string length $sf]-1)/56 +1]
    set header [binary format IS [incr RunLog(Counter)] $subtotal]
    for {set i 1} {$i <= $subtotal} {incr i} {
	puts -nonewline $RunLog(Filehandle) \
		[binary format a6Sa56 $header $i \
		[string range $sf [expr ($i-1)*56] [expr $i*56-1]]]
    }
    flush $RunLog(Filehandle)
    if {$RunLog(Monitor) != ""} {
	set plaintext [TextDecode $sf]
	set graphiccmds [GraphicDecode $sf]
    }
    foreach w $RunLog(Monitor) {
	set inst [split $w _]
	set eventdiff 0
	switch [lindex $inst 0] {
	    log {
		set text .main.$w.text.tTrace
		set graphic .main.$w.graphic.cTrace
		if {[info exists system(Log.LastEvent)]} {
		    set eventdiff [expr $diff-$system(Log.LastEvent)]
		}
		set system(Log.LastEvent) $diff
	    }
	    chan {
		if {$board == [lindex $inst 1] && \
			$line == [lindex $inst 2] && \
			$chan == [lindex $inst 3]} {
		    set text .main.$w.fTrace.fTTrace.tTrace
		    set graphic .main.$w.fTrace.fGTrace.cTrace
		    if {[info exists system($board.$line.$chan.LastEvent)]} {
			set eventdiff [expr $diff-$system($board.$line.$chan.LastEvent)]
		    }
		    set system($board.$line.$chan.LastEvent) $diff
		} else {
		    set text {}
		    set graphic {}
		}
	    }
	    default {
		set text {}
		set graphic {}
	    }
	}
	if {$text != {}} {
	    #Update text display
	    $text configure -state normal
	    $text insert end "$plaintext\n"
	    $text see end
	    $text configure -state disabled
	}
	if {$graphic != {}} {
	    #Update graphic display
	    DrawEvent $graphic $RunLog(Counter) $diff $graphiccmds
	}
    }
}

proc LogAppError { board line chan data } {
    global AppErrors
    global RunLog
    if {!$RunLog(Active)} {
	return
    }
    Log 0 $board $line $chan $AppErrors($data)
}

proc LogAppErrorChan { instNum data } {
    global RunLog
    if {!$RunLog(Active)} {
	return
    }
    set inst [split $instNum .]
    Log 0 [lindex $inst 0] [lindex $inst 1] [lindex $inst 2] $data
}

proc LogAppEvent { board line chan data } {
    global AppEvents
    global RunLog
    if {!$RunLog(Active)} {
	return
    }
    Log 1 $board $line $chan $AppEvents($data)
}
proc LogAppEventData { board line chan type data} {
    global AppEvents
    global RunLog
    if {!$RunLog(Active)} {
	return
    }
    Log 1 $board $line $chan "$AppEvents($type)$data"
}
proc LogAppEventChanData { instNum type data } {
    global RunLog
    if {!$RunLog(Active)} {
	return
    }
    set inst [split $instNum .]
    LogAppEventData [lindex $inst 0] [lindex $inst 1] [lindex $inst 2] \
	    $type $data
}
proc LogFWEvent { board line chan data } {
    global RunLog
    if {!$RunLog(Active)} {
	return
    }
    Log 2 $board $line $chan $data
}

proc LogLineEvent { instNum data } {
    global RunLog
    if {!$RunLog(Active)} {
	return
    }
    set inst [split $instNum .]
    LogFWEvent [lindex $inst 0] [lindex $inst 1] 0 $data
}

proc LogChanEvent { instNum data } {
    global RunLog
    if {!$RunLog(Active)} {
	return
    }
    set inst [split $instNum .]
    LogFWEvent [lindex $inst 0] [lindex $inst 1] [lindex $inst 2] $data
}

proc TextDecode {sf} {
    global transAppError
    global transAppEvent
    global transMsgEvent
    global decodeAppEvent decodeMsgEvent
    binary scan $sf IIcccca* ts diff type board line chan data
    set textTS [clock format $ts -format "%H:%M:%S"]
    if {$board == -1} {
	set instNum General
    } else {
	set instNum $board
    }
    if {$line != 0} {
	append instNum .$line
    }
    if {$chan != 0} {
	append instNum .$chan
    }
    switch $type {
	0 {
	    return "$textTS\tAppError: [StripStringNulls $data]"
	}
	1 {
	    binary scan $data a4a* msgType data
	    set decodedata [$decodeAppEvent($transAppEvent($msgType)) $data]
	    return "$textTS\tAppEvent($instNum): $transAppEvent($msgType) $decodedata"
	} 
	2 {
	    binary scan $data Ia* msgType data
	    set msgType [format 0x%x $msgType]
	    if {[catch {set decodedata [$decodeMsgEvent($msgType) $data 0]}]} {
		return "$textTS\tMsgEvent($instNum): $msgType"
	    } else {
	        return "$textTS\tMsgEvent($instNum): $transMsgEvent($msgType) $decodedata"
            }
	}
	default {
	    return "$textTS\tUnrecognized log entry."
	}
    }
}

proc GraphicDecode {sf} {
    global transAppError
    global transAppEvent
    global transMsgEvent
    global decodeAppEvent decodeMsgEvent
    global color
    set num [binary scan $sf IIcccca* ts diff type board line chan data]

    if {$num <7} {
	return {Label {}}
    }
    
    if {$board == -1} {
	set instNum General
    } else {
	set instNum $board
    }
    if {$line != 0} {
	append instNum .$line
    }
    if {$chan != 0} {
	append instNum .$chan
    }
    switch $type {
	0 {
	    set evt(Label) {}
	}
	1 {
	    binary scan $data a4a* msgType data
	    set decodedata [$decodeAppEvent($transAppEvent($msgType)) $data]
	    set evt(Label) $transAppEvent($msgType)
	    set evt(Data) $decodedata
	    set evt(Color) $color(PSTN_CMD)
	} 
	2 {
	    binary scan $data Ia* msgType data
	    set msgType [format 0x%x $msgType]
	    if {[catch {set decodedata [$decodeMsgEvent($msgType) $data 1]}]} {
 		set evttype unknown
	    } else {
 		set evttype $decodeMsgEvent($msgType)
            }
	    switch $evttype {
		DecodeServiceState {
		    set evt(Label) $decodedata
		    set evt(Color) $color(TSC_CHANSTATE)
		}
		DecodeEvtChanState {
		    set evt(Label) $decodedata
		    set evt(Color) $color(TSC_CHANSTATE)
		}
		DecodeAlarmState {
		    set evt(Label) $decodedata
		    set evt(Color) $color(TSC_CHANSTATE)
		}
		DecodeEvtCallState {
		    set evt(Label) $decodedata
		    set evt(Color) $color(TSC_STATE)
		}
		DecodeCalledId -
		DecodeCallInfoset -
		DecodeCallAnalysis -
		DecodeCallerId {
		    set evt(Label) $decodedata
		    set evt(Color) $color(TSC_INFO)
		}
		DecodeString {
		    set evt(Label) $decodedata
		    set evt(Color) $color(TSC_INFO)
		}
		DecodeCallControl {
		    set evt(Label) $decodedata
		    set evt(Color) $color(TSC_CNTRL)
		}
		DecodeSignal {
		    set dir [lindex $decodedata 0]
		    set id [lindex $decodedata 1]
		    if {$dir == 1} {
			set evt(Color) $color(CAS_FROM)
		    } else {
			set evt(Color) $color(CAS_TO)
		    }
		    set evt(Label) $id
		}
		DecodeTransition {
		    #dont' decode transition bits at this time.
		    set evt(Label) {}
		}
		default {
		    set evt(Label) $msgType
		    set evt(Color) $color(UNKNOWN)
		}
	    }
	}
	default {
	    set evt(Label) {}
	}
    }
    return [array get evt]
}

proc DrawEvent { c count time data } {
    global system
    global glog
    global canvas_height canvas_width event_line_width\
	    font_size pixels_per_msec \
	    event_space color\
	    canvas_max_width \
	    compress_time_msec \
	    time_start delta_start \
	    event_label_space scroll_to

    # Data is array list returned from GraphicDecode
    array set evt $data
    if {$evt(Label) == ""} {
	return
    }

    set tag c$count
    set canvas_height 170
    set canvas_width [winfo width $c]
    set canvas_percent [expr ${canvas_width}.0 / $canvas_max_width]
    set scroll_to [expr .9 * $canvas_percent]
    set time_start [expr $canvas_height - ($font_size * 1.5)]
    set delta_start [expr $time_start + $font_size]
    set glog($c.event_space) [expr $canvas_height * $event_label_space]

    if ![info exists glog($c.clast_time)] {
	#first event for this channel
	set glog($c.clast_time) $time
	set glog($c.clabel_height) $font_size
	set glog($c.location_offset) -$canvas_width

    }

    if ![info exists glog($c.start_time)] {
	#first event overall
	set glog($c.start_time) [expr $time - 1000]
    }

    if ![info exists glog($c.last_time)] {
	set glog($c.last_time) $time
    }

    set delta [expr $time - $glog($c.clast_time)]

    #time compression
    set time_compressed 0
    if [expr $compress_time_msec && \
	    (($time - $glog($c.last_time)) > $compress_time_msec)] {
	set glog($c.location_offset) \
		[expr $glog($c.location_offset) + \
		(($time - $glog($c.last_time)) - \
		$compress_time_msec)*$pixels_per_msec]
	set time_compressed 1
    }
    set glog($c.last_time) $time
    set location \
	    [expr (($time - $glog($c.start_time))*$pixels_per_msec) - \
	    $glog($c.location_offset)]
    if {$location >= $canvas_max_width} {
	CanvasClear $c
    }

    set glog($c.clast_time) $time

    #reformat time and delta to be in seconds
    set delta [expr ${delta}.0 / 1000]
    set time [expr ${time}.0 / 1000]	
    set event(*Time) $time

    #append delta time to event
    set event(*Delta) $delta
    DrawText $c $tag $evt(Color) [list $location $glog($c.clabel_height)] \
	    $evt(Label)
    DrawLine $c $tag $evt(Color) [list $location 0 $location $canvas_height] \
	    $event_line_width {}
    if {![info exists glog($c.next_timestamp_location)]} {
	set glog($c.next_timestamp_location) 0
    }

    #determine if a timestamp won't overlapp last timestamp
    if [expr $location > $glog($c.next_timestamp_location)] {
	#attach timestamp
	DrawText $c $tag $color(TIME_E) [list $location $time_start] $time
	DrawText $c $tag $color(TIME_D) [list $location $delta_start] $delta
	set glog($c.next_timestamp_location) \
		[expr $location + [expr [string length $time] * \
		[expr $font_size / 2]]]
    }
    
    incr glog($c.clabel_height) $font_size

    if [expr $glog($c.clabel_height) > $glog($c.event_space)] {
	set glog($c.clabel_height) $font_size
    }

    CanvasScroll $c $location
}

proc DrawLine { c tag color line width extra} {
    eval {$c create line} $line \
	    -fill $color \
	    -tags $tag \
	    -capstyle projecting \
	    -width $width \
	    $extra
}

proc DrawText { c tag color location text} {
    eval {$c create text} $location \
	    -fill $color \
	    -text {$text} \
	    -tags $tag
}

proc CanvasScroll {args where} {
    if [expr $where == 0] {
	return
    }
    global canvas_max_width scroll_to
    set percent [expr ($where / $canvas_max_width) - $scroll_to]
    foreach l $args {
	$l xview moveto $percent
    }
}

proc CanvasClear {c} {
    global glog
start_time last_time location_offset
    catch {unset  glog($c.start_time)}
    set glog($c.location_offset) -1000
    catch {unset glog($c.last_time)}
    foreach name [array names glog $c.Tag.*] {
	unset glog($name)
    }
    eval {$c delete all}
    set glog($c.next_timestamp_location) 0
}

proc QuerySystem {} {
    global system
    global start diff count
    # Figure out which boards are downloaded.
    set boardList {0 1 2 3 4 5 6 7 8 9 10 11 12 13 14 15 16 17 18 19 20}
    set system(BoardList) {}
    foreach board $boardList {
	QueryBoard $board
    }
}

proc QueryBoard { board } {
    global system
    global Std_ParmInstNum
    global Std_ComponentType TSC_Std_ComponentType \
	    TSC_AttrLineId TSC_AttrChanId

    LogAppEvent $board 0 0 QueryBoard
    if {[catch {set b [Board new -init "-BoardNum $board"]}]} {
	# Board not downloaded or present (Windows)
	LogAppEvent $board 0 0 BoardNotPresent
	return 0
    } else {
	# Check for lcon to make sure board is really there
	if {[catch {
	    set lcomp [$b findComp -CompClass LCONComponent]
	}]} {
	    # Board not downloaded or present (Linux)
	    LogAppEvent $board 0 0 BoardNotPresent
	    return 0
	}
	# Board downloaded
	lappend system(BoardList) $board
	set system($board.handle) $b
	set system($board.Active) 0
	LogAppEvent $board 0 0 BoardFound
    }

    # Figure out how many trunks per board
    array set lineCount [$lcomp GetParm -Parm $Std_ParmInstNum]
    array set tgtDesc [$lcomp set TgtDesc]
    set msgQueue [$lcomp set MsgQueue]
    LogAppEventData $board 0 0 NumLines [binary format c $lineCount(Val)]
    for {set i 1} {$i <= $lineCount(Val)} {incr i} {
	lappend system($board.LineList) $i
	set tgtDesc(Instance) $i
	set system($board.$i.handle) \
		[LCON new -init [list -TgtDesc [array get tgtDesc] \
		-MsgQueue $msgQueue]]
    }

    # Query trunk info
    foreach i $system($board.LineList) {
	# Get LineType
	array set retVal [$system($board.$i.handle) GetParm 0x1601]
	set system($board.$i.LineType) $retVal(Val)
	LogAppEventData $board $i 0 LineType [binary format c $retVal(Val)]
	# Get Protocol Type
	array set retVal [$system($board.$i.handle) GetParm 0x1602]
	set system($board.$i.Protocol) $retVal(Val)
	LogAppEventData $board $i 0 ProtocolType [binary format c $retVal(Val)]
	
	# Init Active state
	set system($board.$i.Active) 0
	
	# Calculate number of channels
	if {($system($board.$i.LineType) == 0) || \
		($system($board.$i.LineType) == 1)} {
	    set testChan 24
	    set failChan 23
	} elseif {($system($board.$i.LineType) == 2) || \
		($system($board.$i.LineType) == 3)} {
	    set testChan 31
	    set failChan 30
	} elseif {$system($board.$i.LineType) == 4} {
	    set testChan 4
	    set failChan 4
	} else {
	    set system($board.$i.NumChans) 1
	}
	# test if testChan exists
	if {[catch {set clust [$system($board.handle) findClustByTSC -Line $i -Chan $testChan]}]} {
	    set system($board.$i.NumChans) $failChan
	} else {
	    set system($board.$i.NumChans) $testChan
	    $clust destroy
	}
	LogAppEventData $board $i 0 NumChans \
		[binary format c $system($board.$i.NumChans)]
    }

    # Query TocRoc status
    set chpcomp [$system($board.handle) findComp -CompClass CHPComponent]
    if {[catch {array set retVal [$chpcomp GetParm 0x1313]} result]} {
	# getparm failed, assume trc
	set retVal(Val) 0
    }
    set system($board.ClusterMode) $retVal(Val)
    LogAppEventData $board 0 0 ClusterMode [binary format c $retVal(Val)]

    # If TocRoc, query clusters now. Otherwise skip.
    if {$system($board.ClusterMode)} {
	# Identify component types

	set ROCComp(0x5) 1 ;# TGEN
	set ROCComp(0x7) 1 ;# SD
	set ROCComp(0xa) 1 ;# CA
	set ROCComp(0x8) 1 ;# Sigbuf
	set ROCComp(0x42) 1 ;# R2MF
	set TOCComp(0x12) 1 ;# TSC

	# Starting from 1, scan until we run out and track all clusters with
	# sigdet instance
	set rm [$system($board.handle) set resourceMgr]
	set clust [$system($board.handle) findClust -Attrs [list \
		[list -key $Std_ComponentType -value $TSC_Std_ComponentType] \
		[list -key $TSC_AttrLineId -value 1] \
		[list -key $TSC_AttrChanId -value 1] ] ]
	set system($board.clustHandle) $clust
	for {set cluster 1} {$cluster < 1024} { incr cluster } {
	    $clust SetInstance $cluster
	    # Find list of instances in cluster
	    set sebCount 0
	    set inst 0
	    if [catch {array set instances [$clust CompInfo]} result] {
		# cluster does not exist so exit loop
		break
	    } else {
		foreach instDesc $instances(instances) {
		    array set desc $instDesc

		    if [info exists compType($desc(Component))] {
			# compType previously cached
			set logComp $compType($desc(Component))
		    } else {
			# Use attr info instead
			array set res [$rm AttrInfo -theInstance $instDesc \
				-count 8 -attroffset 0]
			
			# Find the Std_ComponentType attribute 
			set attrInd [lsearch $res(attrs) "*-key 0x0"]
			
			if {$attrInd != -1} {
			    # Found the CompType attribute
			    array set attr [lindex $res(attrs) $attrInd]
			    set type $attr(-value)
			    set logComp [set compType($desc(Component)) $type]
			} else {
			    set logComp [set compType($desc(Component)) 0xff]
			}
		    }
		    # Check if logical compType is a ROC Component
		    if {[info exists ROCComp($logComp)]} {
			# add to medialist
			if {$logComp == 0x8} {
			    incr sebCount
			}
			if {$logComp != 0x8 || $sebCount <3} {
			    set inst [expr $desc(Instance)]
			    lappend system($board.Roc.$inst.MediaList) \
				    [list ComponentType $logComp \
				    InstDesc [array get desc]]
			}
		    }
		}
	    }
	    # record the cluster number of the Roc
	    if {$inst > 0} {
		set system($board.Roc.$inst.Cluster) $cluster
	    }
	}
    }
    return 1
}

proc CreateMenu {} {
    global RunLog
    menu .menu
    .menu add cascade -label "File" -menu .menu.file
    set m [menu .menu.file -tearoff 0]
    $m add command -label "Open log file..." \
	    -command "CreateOpenLogDialog"
    $m add command -label "Exit" \
	    -command "ExitApp"
    .menu add cascade -label "Log" -menu .menu.log 
    set m [menu .menu.log -tearoff 0]
    $m add command -label "View running log" \
	    -command "if {\[CreateRunningLog\]} {DisplayView log 1 1}"
    $m add checkbutton -label "Logging active" \
	    -onvalue 1 -offvalue 0 -variable RunLog(Active) \
	    -command "if {\$RunLog(Active)} {ResumeLog} else {SuspendLog}"
    .menu add cascade -label "View" -menu .menu.view
    set m [menu .menu.view -tearoff 0]
    $m add command -label "Open system view" \
	    -command "if {\[CreateSystemView\]} {DisplayView sysView 1 1}"
    $m add command -label "Open new view..." \
	    -command "CreateOpenViewDialog"
    .menu add cascade -label "Help" -menu .menu.help
    set m [menu .menu.help -tearoff 0]
    $m add command -label "About..." \
	    -command DisplayAbout
    $m add command -label "General Information..." \
	    -command DisplayGeneralHelp
    $m add command -label "Command Line..." \
	    -command DisplayCommandLineHelp
    . configure -menu .menu
}

proc CreateOpenLogDialog {} {
    global system startup
    set filename [tk_getOpenFile \
	    -filetypes {{{PSTNDiag Log File} {.pdlog} }} \
	    -parent . -title "Open log file..." \
	    -initialdir [file dirname $startup(LogFile)]]
    if {$filename != ""} {
	if {[CreateLogView $filename]} {
	    DisplayView olog_$system(LogCount) 1 1
        }
    }
}

proc CreateOpenViewDialog {} {
    global OVD
    if {[catch {toplevel .openView}]} {
	raise .openView
    }
    label .openView.title -text "Open a: "
    set f [frame .openView.type]
    if {![info exists OVD(viewType)]} {
        set OVD(viewType) 1
        set OVD(viewPane) 1
	set OVD(viewPrompt) "for (b): " 
    }
    radiobutton $f.board -text "Board View" -variable OVD(viewType) \
	    -value 1 -command {set OVD(viewPrompt) "for (b): "}
    radiobutton $f.line -text "Trunk View" -variable OVD(viewType) \
	    -value 2 -command {set OVD(viewPrompt) "for (b.t): "}
    radiobutton $f.chan -text "Channel View" -variable OVD(viewType) \
	    -value 3 -command {set OVD(viewPrompt) "for (b.t.c): "}
    pack $f.board $f.line $f.chan -side top -anchor w
    label .openView.title2 -textvariable OVD(viewPrompt) -width 10 -anchor e
    entry .openView.forEntry -textvariable OVD(viewFor) -width 10
    label .openView.title3 -text "in: "
    set f [frame .openView.where]
    radiobutton $f.pane1 -text "Upper pane" -variable OVD(viewPane) \
	    -value 1
    radiobutton $f.pane2 -text "Lower pane" -variable OVD(viewPane) \
	    -value 2
    pack $f.pane1 $f.pane2 -side top -anchor w
    set f [frame .openView.command]
    button $f.create -text "Open" \
	    -command {OpenViewFromDialog $OVD(viewType) $OVD(viewFor) $OVD(viewPane); destroy .openView}
    button $f.cancel -text "Cancel" \
	    -command {destroy .openView}
    pack $f.create $f.cancel -side left
    grid .openView.title .openView.type
    grid .openView.title2 .openView.forEntry
    grid .openView.title3 .openView.where
    grid .openView.command -
    grid configure .openView.title .openView.title2 .openView.title3 -sticky ne
    grid configure .openView.type .openView.forEntry .openView.where -sticky nw
}

proc OpenViewFromDialog { type for pane } {
    set map [split $for .]
    set boardNum [lindex $map 0]
    set lineNum [lindex $map 1]
    set chanNum [lindex $map 2]
    switch $type {
	1 {
	    if {[CreateBoardView $boardNum]} {
		DisplayView board_$boardNum $pane 1
	    }
	}
	2 {
	    if {[CreateLineView $boardNum.$lineNum]} {
		DisplayView line_${boardNum}_${lineNum} $pane 1
	    }
	}
	3 {
	    if {[CreateChanView $boardNum.$lineNum.$chanNum]} {
		DisplayView chan_${boardNum}_${lineNum}_${chanNum} $pane 1
	    }
	}
    }
}

proc CreateGUI {} {
    global viewBar viewList
    global statusBar
    global pane1 pane2 pane1text pane2text
    global statusText
    global version
    wm title . "PSTNDiag v$version"
    frame .main
    set viewBar .main.viewBar
    set viewList {}
    frame $viewBar -relief groove -bd 1
    set wId pane1
    frame $viewBar.$wId -bd 1 -relief groove
    label $viewBar.$wId.label -text "1" -pady 0
    menubutton $viewBar.$wId.button -textvariable ${wId}text -indicatoron 1 \
	    -pady 0 \
	    -menu $viewBar.${wId}.button.menu
    menu $viewBar.${wId}.button.menu -tearoff 0
    pack $viewBar.$wId.label $viewBar.$wId.button -side left
    set ${wId}text None
    menu $viewBar.$wId.menu -tearoff 0
    $viewBar.$wId.menu add command -label "Close View" \
	    -command "DestroyView \$$wId;ChangeView 1 1"
    bind $viewBar.$wId.button <ButtonPress-3> \
	    "tk_popup $viewBar.$wId.menu %X %Y"
    set wId pane2
    frame $viewBar.$wId -bd 1 -relief groove
    label $viewBar.$wId.label -text "2" -pady 0
    menubutton $viewBar.$wId.button -textvariable ${wId}text -indicatoron 1 \
	    -pady 0 \
	    -menu $viewBar.$wId.button.menu
    menu $viewBar.${wId}.button.menu -tearoff 0
    pack $viewBar.$wId.label $viewBar.$wId.button -side left
    set ${wId}text None
    menu $viewBar.$wId.menu -tearoff 0
    $viewBar.$wId.menu add command -label "Close View" \
	    -command "DestroyView \$$wId;ChangeView 1 2"
    bind $viewBar.$wId.button <ButtonPress-3> \
	    "tk_popup $viewBar.$wId.menu %X %Y"
    pack $viewBar.pane1 $viewBar.pane2 -side left
    set pane1 ""
    set pane2 ""
    frame .main.empty1 -relief groove -bd 1
    frame .main.empty2 -relief groove -bd 1
    set statusBar .main.statusBar
    label $statusBar -textvariable statusText -anchor w -relief groove -bd 2
    grid $viewBar -sticky ew
    grid .main.empty1 -sticky news
    grid .main.empty2 -sticky news
    grid columnconfigure .main 0 -weight 1
    grid rowconfigure .main 1 -weight 1;# -uniform pane
    grid rowconfigure .main 2 -weight 1;# -uniform pane
    pack .main -expand y -fill both
    bind . <Button-1> "focus %W"
    bind . <Control-Key-Prior> "ChangeView -1 1"
    bind . <Control-Key-Next> "ChangeView 1 1"
    bind . <Control-Shift-Key-Prior> "ChangeView -1 2"
    bind . <Control-Shift-Key-Next> "ChangeView 1 2"
}

# Add entry to menus and create frame
proc CreateView {buttonText wId} {
    global viewBar viewList viewIdToLabel viewLabelToId
    global pane1 pane2 panei1 panei2
    set index [lsearch -exact $viewList $wId]
    if {$index >= 0 } {
	return 0
    }
    foreach i {1 2} {
	set m $viewBar.pane$i.button.menu
	$m add radiobutton -variable panei$i -value $wId \
		-label $buttonText \
		-command "DisplayView $wId $i 1"
    }
    lappend viewList $wId
    set viewIdToLabel($wId) $buttonText
    set viewLabelToId($buttonText) $wId
    frame .main.$wId -relief groove -bd 2
    return 1
}

# Delete entry from menus and destroy frame.
# Unregister for appropriate events and clean up handles.
proc DestroyView {wId} {
    global viewBar viewList viewIdToLabel
    global pane1 pane2 panei1 panei2 pane1text pane2text
    global system RunLog
    global call_state_evt_list
    global chan_state_evt_list
    global TSC_EvtCallInfo_Type_CallerId TSC_EvtCallInfo_Type_CalledId
    global TSC_EvtTrace_Type_CallControl

    # Remove from viewList
    set index [lsearch -exact $viewList $wId]
    if {$index < 0 } {
	return
    }
    set viewList [lreplace $viewList $index $index ]

    # Remove from menus
    if {$pane1 == $wId} {
	set pane1 ""
	set panei1 ""
	set pane1text None
    } elseif {$pane2 == $wId} {
	set pane2 ""
	set panei2 ""
	set pane2text None
    }
    foreach i {1 2} {
	set m $viewBar.pane$i.button.menu
	$m delete $viewIdToLabel($wId)
    }

    destroy .main.$wId

    # Unregister LEDs
    set name [split $wId _]
    switch [lindex $name 0] {
	board {
	    set boardNum [lindex $name 1]
	    LogAppEvent $boardNum 0 0 CloseView
	    set LEDList {Red Yellow Signal Loopback DChannel}
	    foreach lineNum $system($boardNum.LineList) {
		foreach LED $LEDList {
		    LEDUnregister .main.$wId.main.led${LED}_$lineNum \
			    $boardNum.$lineNum.Led$LED
		}
	    }
	    set TxList {LineState RAI AIS TS16RAI TS16AIS }
	    foreach lineNum $system($boardNum.LineList) {
		foreach Tx $TxList {
		    TxUnregister .main.$wId.main.c${Tx}_$lineNum \
			    $boardNum.$lineNum.Led$Tx
		}
	    }
	    set system($boardNum.Active) 0
	}
	line {
	    set boardNum [lindex $name 1]
	    set lineNum [lindex $name 2]
	    LogAppEvent $boardNum $lineNum 0 CloseView
	    set LEDList {Red Yellow Signal Loopback DChannel}
	    foreach LED $LEDList {
		LEDUnregister .main.$wId.basic.led$LED \
			$boardNum.$lineNum.Led$LED
	    }
	    set LEDList {AISStatus CRC TS16Red TS16Yellow TS16AISStatus}
	    foreach LED $LEDList {
		LEDUnregister .main.$wId.advanced.led$LED \
			$boardNum.$lineNum.Led$LED
	    }
	    set TxList {LineState RAI AIS TS16RAI TS16AIS }
	    foreach Tx $TxList {
		TxUnregister .main.$wId.basic.c${Tx} \
			$boardNum.$lineNum.Led$Tx
	    }
	    set system($boardNum.$lineNum.Active) 0
	}
	chan {
	    set boardNum [lindex $name 1]
	    set lineNum [lindex $name 2]
	    set chanNum [lindex $name 3]
	    set RunLog(Monitor) [string map "$wId {}" $RunLog(Monitor)]
	    LogAppEvent $boardNum $lineNum $chanNum CloseView
	    set LEDList {Red Yellow Signal Loopback DChannel}
	    foreach LED $LEDList {
		LEDUnregister .main.$wId.line.led$LED \
			$boardNum.$lineNum.Led$LED
	    }
	    set TxList {LineState RAI AIS TS16RAI TS16AIS }
	    foreach Tx $TxList {
		TxUnregister .main.$wId.line.c${Tx} \
			$boardNum.$lineNum.Led$Tx
	    }
	    set tsc $system($boardNum.$lineNum.$chanNum.handle)

	    $tsc CancelxEvts -EvtTypeList $call_state_evt_list
	
	    $tsc CancelxEvts -EvtTypeList [list \
		    $TSC_EvtCallInfo_Type_CalledId \
		    $TSC_EvtCallInfo_Type_CallerId]
	    $tsc CancelxEvts -EvtTypeList $chan_state_evt_list
	    $tsc CancelEvt -EvtType $TSC_EvtTrace_Type_CallControl
	    set system(h.$system($boardNum.$lineNum.$chanNum.handle)) {}
	    $system($boardNum.$lineNum.$chanNum.handle) destroy
	    set system($boardNum.$lineNum.$chanNum.handle) {}
	    set system($boardNum.$lineNum.$chanNum.Active) 0
	    # try to kill cas. if it's not there, won't matter anyways
	    CancelCASEventHandler $boardNum.$lineNum.$chanNum
	}
	log {
	    set RunLog(Monitor) [string map "$wId {}" $RunLog(Monitor)]
	}
	default {
	}
    }
    if {![string compare $pane1 $wId]} {
	set pane1 ""
    }
    if {![string compare $pane2 $wId]} {
	set pane2 ""
    }
}

proc DisplayView {view location raise} {
    global viewBar viewList statusBar
    global viewIdToLabel viewLabelToId
    global pane1 pane2 panei1 panei2 pane1text pane2text

    #See if view is being displayed in pane1 or pane2
    if {$view == $pane1} {
	set oldp 1
    } elseif {$view == $pane2} {
	set oldp 2
    } else {
	set oldp $location
    }

    #If view is being displayed in a different pane, then undisplay it.
    if {$location != $oldp} {
	# Remove from displaytext
	set pane${oldp}text None
	catch {grid remove [grid slaves .main -row $oldp]}
	set pane$oldp ""
	set panei$oldp ""
    }
    
    #If raising, then remove what was in new location and
    #put view in new location
    if {$raise} {
	catch {grid remove [grid slaves .main -row $location]}
	set pane$location $view
	set panei$location $view
	set pane${location}text $viewIdToLabel($view)
	grid .main.$view -sticky news -row $location
    }
}

proc ChangeView {dir pane} {
    global viewBar viewList
    global pane1 pane2

    if {$pane == 1} {
	set current $pane1
	set other $pane2
    } else {
	set current $pane2
	set other $pane1
    }

    #search in direction for next entry that's not in the other pane
    set curIndex [lsearch -exact $viewList $current]
    set len [llength $viewList]
    if {$len == 0} {
	return
    }
    if {$curIndex < 0} {
	if {$dir == 1} {
	    set curIndex [expr $len-1]
	} else {
	    set curIndex 0
	}
    }
    for {set i [expr ($curIndex + $dir)%$len]} {$i != $curIndex} \
	    {set i [expr ($i+$dir)%$len]} {
	set test [lindex $viewList $i]
	if {$test != $other} {
	    DisplayView $test $pane 1
	    return
	}
	
    }
    #If we get here, then there was only one element in list.
    #Check that it's not being shown in other then show it
    set test [lindex $viewList 0]
    if {$test != $other} {
	DisplayView $test $pane 1
    }    
}

proc CreateSystemView {} {
    global sysViewSelected
    global system

    set sysViewSelected 0

    # check if boardlist was populated
    if {[llength $system(BoardList)] == 0} {
	MessageBox "Unable to open system view because no boards were detected in the system or -noscan option was specified."
	return 0
    }

    # Create framework
    if {![CreateView "System" sysView]} {
	return 1
    }
    set w .main.sysView
    
    # Create text and scrollbar
    text $w.text -yscrollcommand "$w.scrollbar set"
    set t $w.text
    scrollbar $w.scrollbar -orient vertical -command "$w.text yview"

    pack .main.sysView.text -side left -fill both -expand y
    pack .main.sysView.scrollbar -side left -fill y

    # Create action frame
    frame .main.sysView.buttons 
    pack .main.sysView.buttons -side right -fill y

    button .main.sysView.buttons.openView -text "Open View" \
	    -command "SysViewOpen .main.sysView.text 1 1"
    pack .main.sysView.buttons.openView

    # Font
    catch {font create fixed -family "Lucida Console" -size 8}

    # Populate
    set highlight "-foreground white -background blue"
    set normal "-foreground {} -background {}"
    set widget 0

    foreach board $system(BoardList) {
	$t insert end "-" "hide$board m$board" \
 		"\t" {} \
		"Board $board" "openable e$board db$board w[incr widget]" "\n"
	$t tag configure m$board -font fixed
	$t tag bind hide$board <Button-1> "HideText $t $board"
	$t tag bind db$board <Button-1> \
		"SysViewHighlight $t $widget 1"
	foreach line $system($board.LineList) {
	    # Trunk info
	    $t insert end "\t\t" "c$board" \
		    "-" "hide$board.$line m$board.$line c$board" \
		    "\t" "c$board" \
		    "Trunk $board.$line" "openable e$board.$line dl$board.$line w[incr widget] c$board" \
		    "\n" "c$board"
	    $t tag bind hide$board.$line <Button-1> "HideText $t $board.$line"
	    $t tag bind dl$board.$line <Button-1> \
		    "SysViewHighlight $t $widget 1"
	    $t tag configure m$board.$line -font fixed

	    # Channel info
	    set numCols 5
	    set numRows [expr (($system($board.$line.NumChans)-1)/$numCols+1)]
	    for {set group 1} {$group <= $numRows} {incr group} {
		$t insert end "\t\t\t\t" "c$board c$board.$line"
		for {set i 0}  {$i < $numCols} {incr i} {
		    set chan [expr $i*$numRows + $group]
		    if {$chan <= $system($board.$line.NumChans)} {
			$t insert end "\t" "c$board c$board.$line " \
				"Channel $board.$line.$chan" \
				"openable chan dc$board.$line.$chan w[expr $widget+$chan] c$board.$line c$board"
			$t tag bind dc$board.$line.$chan <Button-1> \
				"SysViewHighlight $t [expr $widget+$chan] 1"
		    }
		}
		$t insert end "\n" "c$board.$line c$board"
	    }
	    incr widget $system($board.$line.NumChans)
	    $t tag lower c$board.$line c$board
	}
    }

    $t configure -tabs {10 15 20 30 30 125}
    $t configure -cursor arrow -state disabled
    $t configure -height 0

    # Setup bindings

    bind $t <Key-Down> "SysViewSearch $t 1; break"
    bind $t <Key-Up> "SysViewSearch $t 0; break"
    bind $t <Key-Left> "SysViewCollapse $t; break"
    bind $t <Key-Right> "SysViewExpand $t; break"
    bind $t <Key-Return> "SysViewOpen $t 1 1; break"
    bind $t <Control-Key-Return> "SysViewOpen $t 1 0; break"
    bind $t <Shift-Key-Return> "SysViewOpen $t 2 1; break"
    bind $t <Control-Shift-Key-Return> "SysViewOpen $t 2 0; break"

    # Disable default bindings
    bind $t <B1-Leave> "break"
    bind $t <B1-Motion> "break"
    bind $t <Shift-Button-1> "break"
    bind $t <Double-Button-1> "break"
    bind $t <Control-Double-Button-1> "break"
    bind $t <Shift-Double-Button-1> "break"
    bind $t <Control-Shift-Double-Button-1> "break"
    bindtags .main.sysView.scrollbar {.main.sysView.scrollBar Scrollbar all}
    $t tag bind openable <Double-Button-1> \
	    "SysViewOpen $t 1 1; break"
    $t tag bind openable <Control-Double-Button-1> \
	    "SysViewOpen $t 1 0; break"
    $t tag bind openable <Shift-Double-Button-1> \
	    "SysViewOpen $t 2 1; break"
    $t tag bind openable <Control-Shift-Double-Button-1> \
	    "SysViewOpen $t 2 0; break"
    return 1
}

proc SysViewHighlight {t item on} {
    global sysViewSelected
    if {$on} {
	if {$sysViewSelected} {
	    $t tag configure w$sysViewSelected -foreground {} -background {}
	}
	$t tag configure w$item -foreground white -background blue
	set sysViewSelected $item
    } else {
	$t tag configure w$item -foreground {} -background {}
	set sysViewSelected {}
    }
    $t see w$item.first
}

proc SysViewSearch {t dir} {
    global sysViewSelected
    if {$dir == 1} {
	#Search forwards
	set direction -forwards
	if {$sysViewSelected} {
	    set test [expr $sysViewSelected + 1]
	    set startidx w$sysViewSelected.last
	} else {
	    set startidx 0.0
	}
	set endidx end
    } else {
	#Search backwards
	set direction -backwards
	if {$sysViewSelected} {
	    set test [expr $sysViewSelected - 1]
	    set startidx w$sysViewSelected.first
	} else {
	    set startidx end
	}
	set endidx 0.0
    }
    # try to find w$test
    if {$sysViewSelected} {
	if {![catch {set res [$t search -regexp {.+} w$test.first w$test.last]}]} {
	    
	    if {[string compare $res ""]} {
		SysViewHighlight $t $test 1
		return
	    }
	}
    }
    set res [$t search $direction -regexp {[BTC]} $startidx $endidx]
    if {[string compare $res ""]} {
	set taglist [$t tag names $res]
	set res [lsearch -regexp $taglist {w[0-9]+}]
	if {$res >= 0 } {
	    set res [string range [lindex $taglist $res] 1 end]
	    SysViewHighlight $t $res 1
	}
    }
}

proc SysViewCollapse {t} {
    global sysViewSelected
    if {$sysViewSelected} {
	set taglist [$t tag names w$sysViewSelected.first]
	set res [lsearch -regexp $taglist {c[0-9]+}]
	if {$res >= 0} {
	    set res [string range [lindex $taglist $res] 1 end]
	    HideText $t $res
	    SysViewSearch $t 0
	}
    }
}

proc SysViewExpand {t} {
    global sysViewSelected
    if {$sysViewSelected} {
	set taglist [$t tag names w$sysViewSelected.first]
	set res [lsearch -regexp $taglist {e[0-9]+}]
	if {$res >= 0} {
	    set res [string range [lindex $taglist $res] 1 end]
	    ShowText $t $res
	    SysViewSearch $t 1
	}
    }
}

proc ShowText {t item} {
    $t tag configure c$item -elide {}
    $t configure -state normal
    $t insert m$item.last "-" [$t tag names m$item.first]
    $t delete m$item.first
    $t tag bind hide$item <Button-1> "HideText $t $item"
    $t configure -state disabled
}

proc HideText {t item} {
    $t tag configure c$item -elide y
    $t configure -state normal
    $t insert m$item.last "+" [$t tag names m$item.first]
    $t delete m$item.first
    $t tag bind hide$item <Button-1> "ShowText $t $item"
    $t configure -state disabled
}

proc CreateBoardView {boardNum} {
    global system

    # Check if board is present
    if {![info exists system($boardNum.Active)]} {
	# board not active so either not there or we didn't scan.
	if {![QueryBoard $boardNum]} {
	    #message board not available
	    MessageBox "Unable to open board view $boardNum. This is probably because the board was not downloaded."
	    return 0
	}
    }

    # Create framework
    if {![CreateView "Board $boardNum" board_$boardNum]} {
	return 1
    }

    LogAppEvent $boardNum 0 0 CreateView
    set w .main.board_$boardNum
    label $w.title -text "Board $boardNum" -pady 0
    set w [frame $w.main]
    set f $w
    label $f.lLineNum -text "Trunk" -bd 1

    # InService menu
    set m $f.mLineState.menuLineState
    menubutton $f.mLineState -text "Trunk Active..." -menu $m \
	    -bd 1 -relief raised -padx 2 -pady 1
    menu $m -tearoff 0
    $m add command -label "Toggle all trunks In Service" \
	    -command "ToggleAll LineState $boardNum 1"
    $m add command -label "Toggle all trunks Out of Service" \
	    -command "ToggleAll LineState $boardNum 0"

    label $f.lRed -text "Red" -padx 0 -pady 0
    label $f.lYellow -text "Yellow" -padx 0 -pady 0
    label $f.lSignal -text "Signal" -padx 0 -pady 0
    label $f.lLoopback -text "Loopback" -padx 0 -pady 0

    # RAI menu
    set m $f.mRAI.menuRAI
    menubutton $f.mRAI -text "RAI..." -menu $m \
	    -bd 1 -relief raised -padx 2 -pady 1
    menu $m -tearoff 0
    $m add command -label "Toggle RAI on for all trunks" \
	    -command "ToggleAll RAI $boardNum 1"
    $m add command -label "Toggle RAI off for all trunks" \
	    -command "ToggleAll RAI $boardNum 0"

    # AIS menu
    set m $f.mAIS.menuAIS
    menubutton $f.mAIS -text "AIS..." -menu $m \
	    -bd 1 -relief raised -padx 2 -pady 1
    menu $m -tearoff 0
    $m add command -label "Toggle AIS on for all trunks" \
	    -command "ToggleAll AIS $boardNum 1"
    $m add command -label "Toggle AIS off for all trunks" \
	    -command "ToggleAll AIS $boardNum 0"

    # TS16 RAI menu
    set m $f.mTS16RAI.menuTS16RAI
    menubutton $f.mTS16RAI -text "TS16 RAI..." -menu $m \
	    -bd 1 -relief raised -padx 2 -pady 1
    menu $m -tearoff 0
    $m add command -label "Toggle TS16 RAI on for all trunks" \
	    -command "ToggleAll TS16RAI $boardNum 1"
    $m add command -label "Toggle TS16 RAI off for all trunks" \
	    -command "ToggleAll TS16RAI $boardNum 0"

    # TS16 AIS menu
    set m $f.mTS16AIS.menuTS16AIS
    menubutton $f.mTS16AIS -text "TS16 AIS..." -menu $m \
	    -bd 1 -relief raised -padx 2 -pady 1
    menu $m -tearoff 0
    $m add command -label "Toggle TS16 AIS on for all trunks" \
	    -command "ToggleAll TS16AIS $boardNum 1"
    $m add command -label "Toggle TS16 AIS off for all trunks" \
	    -command "ToggleAll TS16AIS $boardNum 0"
    label $f.mDChannel -text "DChannel" -padx 0 -pady 0

    # Pack headers
    set wlist [list $f.lLineNum $f.mLineState \
	    $f.lRed $f.lYellow $f.lSignal $f.lLoopback \
	    $f.mRAI $f.mAIS $f.mTS16RAI $f.mTS16AIS \
	    $f.mDChannel]
    set i 0
    foreach slave $wlist {
	$slave configure -anchor e
	grid $slave -sticky nsew -column 0 -row $i
	incr i
    }

    foreach line $system($boardNum.LineList) {
	set ww $w
	menubutton $ww.line_$line -text "$line.." \
		-padx 1 -pady 0 -bd 1 \
		-relief raised -menu $ww.line_$line.menu
	menu $ww.line_$line.menu -tearoff 0
	$ww.line_$line.menu add command \
		-label "Open Trunk View for $boardNum.$line" \
		-command "CreateLineView $boardNum.$line; \
		DisplayView line_${boardNum}_${line} 2 1"

	# LineState checkbutton
	checkbutton $ww.cLineState_$line -padx 0 -pady 0 -bd 0 \
		-variable system($boardNum.$line.LineState) \
		-command "UpdateLineState $boardNum.$line"
	TxRegister $ww.cLineState_$line $boardNum.$line.LedLineState

	# Alarm bitmaps
	set LEDList {Red Yellow Signal Loopback DChannel}
	foreach LED $LEDList {
	    label $ww.led${LED}_$line -bitmap @led.xbm -padx 0 -pady 0
	    LEDRegister $ww.led${LED}_$line $boardNum.$line.Led${LED}
	}

	# RAI checkbutton
	set TxList {RAI AIS TS16RAI TS16AIS}
	foreach Tx $TxList {
	    checkbutton $ww.c${Tx}_$line -padx 0 -pady 0 -bd 0 \
		    -variable system($boardNum.$line.$Tx) \
		    -command "UpdateAlarm $boardNum.$line $Tx"
	    TxRegister $ww.c${Tx}_$line $boardNum.$line.Led$Tx
	}

	if {$system($boardNum.$line.Protocol) != 4 || \
		![isE1 $system($boardNum.$line.LineType)]} {
	    $ww.cTS16RAI_$line configure -state disabled
	    $ww.cTS16AIS_$line configure -state disabled
	}

	if {$system($boardNum.$line.LineType) == 4} {
	    $ww.cRAI_$line configure -state disabled
	    $ww.cAIS_$line configure -state disabled
	}

	# Pack indicators
	set wlist [list $ww.line_$line $ww.cLineState_$line \
		$ww.ledRed_$line $ww.ledYellow_$line $ww.ledSignal_$line \
		$ww.ledLoopback_$line \
		$ww.cRAI_$line $ww.cAIS_$line $ww.cTS16RAI_$line \
		$ww.cTS16AIS_$line \
		$ww.ledDChannel_$line]
	set i 0
	foreach slave $wlist {
	    $slave configure -anchor center
	    grid $slave -sticky nsew -column $line -row $i
	    incr i
	}

	pack .main.board_$boardNum.title -side top -anchor nw
	pack $w -side top -anchor nw

    }
    
    # Setup firmware hooks
    foreach line $system($boardNum.LineList) {
	SetupBasicLineEventHandlers $boardNum $line
	RefreshLineStatus $boardNum $line
    }
    return 1
}

proc CreateLineView {instNum} {
    global system

    set instList [split $instNum .]
    set boardNum [lindex $instList 0]
    set lineNum [lindex $instList 1]
    set line $lineNum

    # Check if board is present
    if {![info exists system($boardNum.Active)]} {
	# board not active so either not there or we didn't scan.
	if {![QueryBoard $boardNum]} {
	    #message board not available
	    MessageBox "Unable to open trunk view $instNum. This is probably because the board was not downloaded."
	    return 0
	}
    }

    # Check if line is present
    if {![info exists system($instNum.Active)]} {
	#message line not available
	MessageBox "Unable to open trunk view $instNum because specified trunk does not exist."
	return 0
    }

    # Create framework
    if {![CreateView "Trunk $boardNum.$lineNum" line_${boardNum}_${lineNum}]} {
	return 1
    }
    LogAppEvent $boardNum $lineNum 0 CreateView
    set w .main.line_${boardNum}_${lineNum}

    set title "Trunk $boardNum.$lineNum - "
    switch [expr $system($boardNum.$lineNum.LineType)] {
	0 { append title "T1(D4)" }
	1 { append title "T1(ESF)" }
	2 { append title "E1(No CRC)" }
	3 { append title "E1(CRC)" }
	4 { append title "Analog" }
	default {
	    append title $system($boardNum.$lineNum.LineType)
	}
    }
    append title " - "
    switch [expr $system($boardNum.$lineNum.Protocol)] {
	4 {
	    append title CAS
	}
	5 {
	    append title ISDN
	}
	6 {
	    append title ClearChannel
	}
	default {
	    append title $system($boardNum.$lineNum.Protocol)
	}
    }

    label $w.title -text $title -pady 0
    set f [frame $w.basic -bd 1 -relief groove]
    label $f.lLineState -text "Trunk Active"
    label $f.lRed -text "Red" -pady 0
    label $f.lYellow -text "Yellow" -pady 0
    label $f.lSignal -text "Signal" -pady 0
    label $f.lLoopback -text "Loopback" -pady 0
    label $f.lRAI -text "Transmit RAI"
    label $f.lAIS -text "Transmit AIS"
    label $f.lTS16RAI -text "Transmit TS16 RAI"
    label $f.lTS16AIS -text "Transmit TS16 AIS"
    label $f.lDChannel -text "DChannel"

    # LineState checkbutton
    checkbutton $f.cLineState -padx 0 -pady 0 -bd 0 \
	    -variable system($boardNum.$line.LineState) \
	    -command "UpdateLineState $boardNum.$line"
    TxRegister $f.cLineState $boardNum.$line.LedLineState

    # Alarm bitmaps
    set LEDList {Red Yellow Signal Loopback DChannel}
    foreach LED $LEDList {
	label $f.led$LED -bitmap @led.xbm -padx 0 -pady 0
	LEDRegister $f.led$LED $boardNum.$line.Led$LED
    }

    # RAI checkbutton
    set TxList {RAI AIS TS16RAI TS16AIS}
    foreach Tx $TxList {
	checkbutton $f.c$Tx -padx 0 -pady 0 -bd 0 \
		-variable system($boardNum.$line.$Tx) \
		-command "UpdateAlarm $boardNum.$line $Tx"
	TxRegister $f.c$Tx $boardNum.$line.Led$Tx
    }

    if {($system($boardNum.$line.Protocol) != 4) || \
	    ![isE1 $system($boardNum.$line.LineType)]} {
	$f.lTS16RAI configure -state disabled
	$f.lTS16AIS configure -state disabled
	$f.cTS16RAI configure -state disabled
	$f.cTS16AIS configure -state disabled
	
    }
    if {$system($boardNum.$line.LineType) == 4} {
	$f.lRAI configure -state disabled
	$f.lAIS configure -state disabled
	$f.cRAI configure -state disabled
	$f.cAIS configure -state disabled
    }
    if {$system($boardNum.$line.Protocol) != 5} {
	$f.lDChannel configure -state disabled
	$f.ledDChannel configure -state disabled
    }

    # Pack basic pane
    grid $f.lLineState $f.cLineState
    grid $f.lRed $f.ledRed
    grid $f.lYellow $f.ledYellow
    grid $f.lSignal $f.ledSignal
    grid $f.lLoopback $f.ledLoopback
    grid $f.lRAI $f.cRAI
    grid $f.lAIS $f.cAIS
    grid $f.lTS16RAI $f.cTS16RAI
    grid $f.lTS16AIS $f.cTS16AIS
    grid $f.lDChannel $f.ledDChannel
    grid configure $f.lLineState $f.lRed $f.lYellow $f.lSignal $f.lLoopback\
	    $f.lRAI $f.lAIS $f.lTS16RAI $f.lTS16AIS $f.lDChannel -sticky e

    # Advanced controls
    set f [frame $w.advanced -bd 1 -relief groove]
    label $f.lAISStatus -text "AIS"
    label $f.lCRC -text "CRC"
    label $f.lTS16Red -text "TS16 Red"
    label $f.lTS16Yellow -text "TS16 Yellow"
    label $f.lTS16AISStatus -text "TS16 AIS"
    label $f.ledAISStatus -bitmap @led.xbm
    label $f.ledCRC -bitmap @led.xbm
    label $f.ledTS16Red -bitmap @led.xbm
    label $f.ledTS16Yellow -bitmap @led.xbm
    label $f.ledTS16AISStatus -bitmap @led.xbm

    if {($system($boardNum.$line.Protocol) != 4) || \
	    ![isE1 $system($boardNum.$line.LineType)]} {
	$f.lTS16Red configure -state disabled
	$f.lTS16Yellow configure -state disabled
	$f.lTS16AISStatus configure -state disabled
	$f.ledTS16Red configure -state disabled
	$f.ledTS16Yellow configure -state disabled
	$f.ledTS16AISStatus configure -state disabled
	
    }
    if {$system($boardNum.$line.LineType) != 3} {
	$f.lCRC configure -state disabled
	$f.ledCRC configure -state disabled
    }

    LEDRegister $f.ledAISStatus $boardNum.$line.LedAISStatus
    LEDRegister $f.ledCRC $boardNum.$line.LedCRC
    LEDRegister $f.ledTS16Red $boardNum.$line.LedTS16Red
    LEDRegister $f.ledTS16Yellow $boardNum.$line.LedTS16Yellow
    LEDRegister $f.ledTS16AISStatus $boardNum.$line.LedTS16AISStatus

    # Pack advanced pane
    grid $f.lAISStatus $f.ledAISStatus
    grid $f.lCRC $f.ledCRC
    grid $f.lTS16Red $f.ledTS16Red
    grid $f.lTS16Yellow $f.ledTS16Yellow
    grid $f.lTS16AISStatus $f.ledTS16AISStatus
    grid configure $f.lAISStatus $f.lCRC $f.lTS16Red $f.lTS16Yellow \
	    $f.lTS16AISStatus -sticky e
    set wv [frame $w.commands -bd 1 -relief groove]
    menubutton $wv.mLoopBack -text "Change loopback..." \
	    -bd 2 -relief raised \
	    -menu $wv.mLoopBack.menu
    set m [menu $wv.mLoopBack.menu -tearoff 0]
    $m add radiobutton \
	    -label "No Loopback" -value 0 \
	    -variable system($boardNum.$lineNum.LoopbackMode) \
	    -command "UpdateLoopback $boardNum.$lineNum"
    $m add radiobutton \
	    -label "Payload Loopback" -value 1 \
	    -variable system($boardNum.$lineNum.LoopbackMode) \
	    -command "UpdateLoopback $boardNum.$lineNum"
    $m add radiobutton \
	    -label "Line Loopback" -value 2 \
	    -variable system($boardNum.$lineNum.LoopbackMode) \
	    -command "UpdateLoopback $boardNum.$lineNum"
    $m add radiobutton \
	    -label "Digital Loopback" -value 3 \
	    -variable system($boardNum.$lineNum.LoopbackMode) \
	    -command "UpdateLoopback $boardNum.$lineNum"
    $m add radiobutton \
	    -label "Metallic Loopback" -value 4 \
	    -variable system($boardNum.$lineNum.LoopbackMode) \
	    -command "UpdateLoopback $boardNum.$lineNum"
    RefreshLoopbackMode $boardNum.$lineNum
    button $wv.bLaunchCASTrace -text "Launch CASTrace" \
	    -bd 2 -relief raised \
	    -command "LaunchApp CASTrace $instNum 1"
    if {$system($boardNum.$lineNum.Protocol) != 4} {
	$wv.bLaunchCASTrace configure -state disabled
    }
    button $wv.bLaunchisdntrace -text "Launch ISDNTrace" \
	    -bd 2 -relief raised \
	    -command "LaunchApp isdntrace $instNum 1"
    if {$system($boardNum.$lineNum.Protocol) != 5} {
	$wv.bLaunchisdntrace configure -state disabled
    }
    pack $wv.mLoopBack $wv.bLaunchCASTrace $wv.bLaunchisdntrace \
	    -side top -expand y -fill both
    pack $w.title -side top -anchor nw
    pack $w.basic $w.advanced $w.commands -side left -anchor n -padx 5
    # Setup firmware hooks
    SetupBasicLineEventHandlers $boardNum $lineNum
    SetupAdvLineEventHandlers $boardNum $lineNum
    # Update status
    RefreshLineStatus $boardNum $lineNum
    return 1
}

proc LaunchApp {app instNum misc} {
    global system

    set map [split $instNum .]
    set boardNum [lindex $map 0]
    set lineNum [lindex $map 1]

    set system($instNum.CommandLine) $app

    switch $app {
	CASTrace {	
	    append system($instNum.CommandLine) " -b $boardNum -l $lineNum "
	    if {$system($instNum.LineType) < 2} {
		append system($instNum.CommandLine) -t1
	    } else {
		append system($instNum.CommandLine) -e1
	    }
	}
      isdntrace {
	    append system($instNum.CommandLine) " -b$boardNum -d$lineNum"
	}
    }

    toplevel .launchApp
    wm title .launchApp "Launch App"
    set f .launchApp
    label $f.title -text "Preparing to launch $app."
    label $f.title2 -text "Edit the commandline then click OK to execute."
    entry $f.entry -textvariable system($instNum.CommandLine) -width 30
    global tcl_platform
    switch $tcl_platform(platform) {
        windows {
            button $f.ok -text Ok -command "eval exec cmd /c \$system($instNum.CommandLine) &;\
                LogAppEventData $boardNum $lineNum 0 LaunchApp \[binary format a* \$system($instNum.CommandLine)];\
                destroy .launchApp"
        }
        default {
            button $f.ok -text Ok -command "eval exec xterm -e \$system($instNum.CommandLine) &;\
                LogAppEventData $boardNum $lineNum 0 LaunchApp \[binary format a* \$system($instNum.CommandLine)];\
                destroy .launchApp"
        }
    }
    button $f.cancel -text "Cancel" -command "destroy .launchApp"
    grid $f.title -
    grid $f.title2 -
    grid $f.entry -
    grid $f.ok $f.cancel
}

proc CreateChanView {instNum} {
    global system RunLog
    global canvas_region
    set instList [split $instNum .]
    set boardNum [lindex $instList 0]
    set lineNum [lindex $instList 1]
    set chanNum [lindex $instList 2]
    set line $lineNum
    # Check if board is present
    if {![info exists system($boardNum.Active)]} {
	# board not active so either not there or we didn't scan.
	if {![QueryBoard $boardNum]} {
	    #message board not available
	    MessageBox "Unable to open channel view $instNum. This is probably because the board was not downloaded."
	    return 0
	}
    }
    # Check if line is present
    if {![info exists system($boardNum.$lineNum.Active)]} {
	#message line not available
	MessageBox "Unable to open channel view $instNum.  The specified trunk does not exist."
	return 0
    }
    # Check if chan is in range
    if {$chanNum < 1 || $chanNum > $system($boardNum.$lineNum.NumChans)} {
	#message chan not available
	MessageBox "Unable to open channel view $instNum.  The specified channel does not exist."
	return 0
    }
    # Create framework
    if {![CreateView "Chan $boardNum.$lineNum.$chanNum" chan_${boardNum}_${lineNum}_${chanNum}]} {
	return 1
    }
    LogAppEvent $boardNum $lineNum $chanNum CreateView
    set w .main.chan_${boardNum}_${lineNum}_${chanNum}

    set title "Channel $boardNum.$lineNum.$chanNum - "
    switch [expr $system($boardNum.$lineNum.LineType)] {
	0 { append title "T1(D4)" }
	1 { append title "T1(ESF)" }
	2 { append title "E1(No CRC)" }
	3 { append title "E1(CRC)" }
	4 { append title "Analog" }
	default {
	    append title $system($boardNum.$lineNum.LineType)
	}
    }
    append title " - "
    switch [expr $system($boardNum.$lineNum.Protocol)] {
	4 {
	    append title CAS
	}
	5 {
	    append title ISDN
	}
	6 {
	    append title ClearChannel
	}
	default {
	    append title $system($boardNum.$lineNum.Protocol)
	}
    }
    if {$system($boardNum.ClusterMode)} {
	append title " - TOC/ROC"
    } else {
	append title " - TRC"
    }
    label $w.title -text $title -pady 0
    set f [frame $w.line -bd 1 -relief groove]
    label $f.lLineState -text "Trunk Active"
    label $f.lRed -text "Red" -pady 0
    label $f.lYellow -text "Yellow" -pady 0
    label $f.lSignal -text "Signal" -pady 0
    label $f.lLoopback -text "Loopback" -pady 0
    label $f.lRAI -text "RAI"
    label $f.lAIS -text "AIS"
    label $f.lTS16RAI -text "TS16 RAI"
    label $f.lTS16AIS -text "TS16 AIS"
    label $f.lDChannel -text "DChannel"

    # LineState checkbutton
    checkbutton $f.cLineState -padx 0 -pady 0 -bd 0 \
	    -variable system($boardNum.$line.LineState) \
	    -command "UpdateLineState $boardNum.$line"
    TxRegister $f.cLineState $boardNum.$line.LedLineState

    # Alarm bitmaps
    set LEDList {Red Yellow Signal Loopback DChannel}
    foreach LED $LEDList {
	label $f.led$LED -bitmap @led.xbm -padx 0 -pady 0
	LEDRegister $f.led$LED $boardNum.$line.Led$LED
    }

    # RAI checkbutton
    set TxList {RAI AIS TS16RAI TS16AIS}
    foreach Tx $TxList {
	checkbutton $f.c$Tx -padx 0 -pady 0 -bd 0 \
		-variable system($boardNum.$line.$Tx) \
		-command "UpdateAlarm $boardNum.$line $Tx"
	TxRegister $f.c$Tx $boardNum.$line.Led$Tx
    }

    if {($system($boardNum.$line.Protocol) != 4) || \
	    ![isE1 $system($boardNum.$line.LineType)]} {
	$f.lTS16RAI configure -state disabled
	$f.lTS16AIS configure -state disabled
	$f.cTS16RAI configure -state disabled
	$f.cTS16AIS configure -state disabled
    }
    if {$system($boardNum.$line.LineType) == 4} {
	$f.lRAI configure -state disabled
	$f.lAIS configure -state disabled
	$f.cRAI configure -state disabled
	$f.cAIS configure -state disabled
    }
    if {$system($boardNum.$line.Protocol) != 5} {
	$f.lDChannel configure -state disabled
	$f.ledDChannel configure -state disabled
    }

    # Pack basic pane
    grid $f.lLineState $f.cLineState
    grid $f.lRed $f.ledRed
    grid $f.lYellow $f.ledYellow
    grid $f.lSignal $f.ledSignal
    grid $f.lLoopback $f.ledLoopback
    grid $f.lRAI $f.cRAI
    grid $f.lAIS $f.cAIS
    grid $f.lTS16RAI $f.cTS16RAI
    grid $f.lTS16AIS $f.cTS16AIS
    grid $f.lDChannel $f.ledDChannel

    grid configure $f.lLineState $f.lRed $f.lYellow $f.lSignal $f.lLoopback\
	    $f.lRAI $f.lAIS $f.lTS16RAI $f.lTS16AIS $f.lDChannel -sticky e

    # Chan section
    set wv [frame $w.chan -bd 1 -relief groove]

    set m $wv.mbChan.menu
    menubutton $wv.mbChan -textvariable system($instNum.ChanMode) \
	    -menu $m -height 0 \
	    -bd 1 -relief raised -pady 1 -indicatoron 1
    menu $m -tearoff 0
    $m add radiobutton -label "View CallInfo fields" \
	    -value "CallInfo" \
	    -variable system($instNum.ChanMode) \
	    -command "grid remove \[grid slaves $wv -row 1\];\
	    grid $wv.fCallInfo -sticky nsew -row 1 -column 0"
    $m add radiobutton -label "Edit MakeCall parameters" \
	    -value "MakeCall Parameters" \
	    -variable system($instNum.ChanMode) \
	    -command "grid remove \[grid slaves $wv -row 1\];\
	    grid $wv.fCallParams -sticky nsew -row 1 -column 0"
    $m add radiobutton -label "Edit ParkCall parameters" \
	    -value "ParkCall Parameters" \
	    -variable system($instNum.ChanMode) \
	    -command "grid remove \[grid slaves $wv -row 1\];\
	    grid $wv.fParkParams -sticky nsew -row 1 -column 0"
    $m add radiobutton -label "Edit ISDN IEs" \
	    -value "ISDN IEs" \
	    -variable system($instNum.ChanMode) \
	    -command "grid remove \[grid slaves $wv -row 1\];\
	    grid $wv.fISDNIes -sticky nsew -row 1 -column 0"
    $m add radiobutton -label "Edit Media Descriptors" \
	    -value "Media Descrs" \
	    -variable system($instNum.ChanMode) \
	    -command "grid remove \[grid slaves $wv -row 1\];\
	    grid $wv.fMediaComps -sticky nsew -row 1 -column 0"

    set system($instNum.ChanMode) CallInfo
    set system($instNum.CallProgress) 0x0
    set system($instNum.CallId) 0x0
    set system($instNum.ParkId) 0x0

    set f [frame $wv.fCallInfo]
    label $f.lDNIS -text "CalledID(DNIS)"
    label $f.lANI -text "CallerID(ANI)"
    label $f.lCallState -text "CallState"
    label $f.lChanState -text "ChanState"
    label $f.eDNIS -textvariable system($instNum.DNIS) -width 15
    label $f.eANI -textvariable system($instNum.ANI) -width 15
    label $f.eCallState -textvariable system($instNum.CallState) -width 15
    label $f.eChanState -textvariable system($instNum.ChanState) -width 15
    set wlist {ANI DNIS CallState ChanState}
    foreach slave $wlist {
	grid $f.l$slave $f.e$slave
	grid configure $f.l$slave -sticky e
	grid configure $f.e$slave -sticky ew
    }

    pack $w.chan.fCallInfo -expand y -fill both
    grid $wv.mbChan -sticky w -padx 10
    grid columnconfigure $wv 0 -weight 1
    grid $wv.fCallInfo -sticky ew

    set f [frame $wv.fCallParams]
    label $f.lOrigAddr -text "OrigAddr"
    label $f.lDestAddr -text "DestAddr"
    label $f.lCallProgress -text "CallProgress"
    label $f.lCallId -text "CallId"
    label $f.lConCallId -text "ConCallId"
    entry $f.eOrigAddr -textvariable system($instNum.OrigAddr) -width 12
    entry $f.eDestAddr -textvariable system($instNum.DestAddr) -width 12
    entry $f.eCallProgress -textvariable system($instNum.CallProgress) -width 5
    entry $f.eCallId -textvariable system($instNum.CallId) -width 12
    entry $f.eConCallId -textvariable system($instNum.ConCallId) -width 12

    set wlist {OrigAddr DestAddr CallProgress CallId ConCallId}
    foreach slave $wlist {
	grid $f.l$slave $f.e$slave
	grid configure $f.l$slave -sticky e
	grid configure $f.e$slave -sticky ew
    }
    grid columnconfigure $f 1 -weight 1

    set f [frame $wv.fParkParams]
    label $f.lParkId -text "ParkId"
    label $f.lParkAddr -text "ParkAddr"
    entry $f.eParkId -textvariable system($instNum.ParkId) -width 15
    entry $f.eParkAddr -textvariable system($instNum.ParkAddr) -width 15

    set wlist {ParkId ParkAddr}
    foreach slave $wlist {
	grid $f.l$slave $f.e$slave
	grid configure $f.l$slave -sticky e
	grid configure $f.e$slave -sticky ew
    }

    set f [frame $wv.fISDNIes]
    label $f.lMakeCallIe -text "MakeCall"
    label $f.lFacility -text "FACILITY"
    label $f.lCongCon -text "CONG_CON"
    label $f.lNotify -text "NOTIFY"
    label $f.lUserInfo -text "USER_INFO"
    label $f.lInfo -text "INFO"
    entry $f.eMakeCallIe -textvariable system($instNum.IE.MakeCall) -width 15
    entry $f.eFacility -textvariable system($instNum.IE.FACILITY) -width 15
    entry $f.eCongCon -textvariable system($instNum.IE.CONG_CON) -width 15
    entry $f.eNotify -textvariable system($instNum.IE.NOTIFY) -width 15
    entry $f.eUserInfo -textvariable system($instNum.IE.USER_INFO) -width 15
    entry $f.eInfo -textvariable system($instNum.IE.INFO) -width 15

    set wlist {MakeCallIe Facility CongCon Notify UserInfo Info}
    foreach slave $wlist {
	grid $f.l$slave $f.e$slave
	grid configure $f.l$slave -sticky e
	grid configure $f.e$slave -sticky ew
    }

    set f [frame $wv.fMediaComps]
    label $f.lInstNo -text "Instance"
    entry $f.eInstNo -textvariable system($instNum.TocRoc) -width 15 \
        -validate all -vcmd "string is integer %P"
    if {!$system($boardNum.ClusterMode)} {
	$f.lInstNo configure -state disabled
	$f.eInstNo configure -state disabled
    }
    set wlist {InstNo}
    foreach slave $wlist {
	grid $f.l$slave $f.e$slave
	grid configure $f.l$slave -sticky e
	grid configure $f.e$slave -sticky ew
    }

    set wv [frame $w.command -bd 1 -relief groove]
    
    set m $wv.mbCommand.menu
    menubutton $wv.mbCommand -textvariable system($instNum.CommandMode) \
	    -menu $m -height 0 \
	    -bd 1 -relief raised -pady 1 -indicatoron 1
    menu $m -tearoff 0
    $m add radiobutton -label "Channel State Commands" \
	    -value "Channel State" \
	    -variable system($instNum.CommandMode) \
	    -command "grid remove \[grid slaves $wv -row 1\];\
	    grid $wv.fChanState -sticky nsew -row 1 -column 0"
    $m add radiobutton -label "Outbound Call Control Commands" \
	    -value "Outbound Call Control" \
	    -variable system($instNum.CommandMode) \
	    -command "grid remove \[grid slaves $wv -row 1\];\
	    grid $wv.fOBCallControl -sticky nsew -row 1 -column 0"
    $m add radiobutton -label "Inbound Call Control Commands" \
	    -value "Inbound Call Control" \
	    -variable system($instNum.CommandMode) \
	    -command "grid remove \[grid slaves $wv -row 1\];\
	    grid $wv.fIBCallControl -sticky nsew -row 1 -column 0"
    $m add radiobutton -label "Call Hold Commands" \
	    -value "Call Hold" \
	    -variable system($instNum.CommandMode) \
	    -command "grid remove \[grid slaves $wv -row 1\];\
	    grid $wv.fCallHold -sticky nsew -row 1 -column 0"
    $m add radiobutton -label "Call Transfer Commands" \
	    -value "Call Transfer" \
	    -variable system($instNum.CommandMode) \
	    -command "grid remove \[grid slaves $wv -row 1\];\
	    grid $wv.fCallTransfer -sticky nsew -row 1 -column 0"
    $m add radiobutton -label "SendISDN Commands" \
	    -value "SendISDN" \
	    -variable system($instNum.CommandMode) \
	    -command "grid remove \[grid slaves $wv -row 1\];\
	    grid $wv.fSendISDN -sticky nsew -row 1 -column 0"
    $m add radiobutton -label "Misc. Commands" \
	    -value "Misc Commands" \
	    -variable system($instNum.CommandMode) \
	    -command "grid remove \[grid slaves $wv -row 1\];\
	    grid $wv.fMisc -sticky nsew -row 1 -column 0"
    $m add radiobutton -label "External Applications" \
	    -value "External Apps" \
	    -variable system($instNum.CommandMode) \
	    -command "grid remove \[grid slaves $wv -row 1\];\
	    grid $wv.fExternalApps -sticky nsew -row 1 -column 0"
    set system($instNum.CommandMode) "Channel State"

    # ChanState pane
    set buttonList {
	ChanState {
	    {SetChanState ResetLineDevice}
            {AttachMedia DetachMedia}
	}
	OBCallControl {
	    {MakeCall DialDigits}
	    {Drop Release}
	}
	IBCallControl {
	    {Answer Accept}
	    {Proceed Reject}
	    {Redirect}
	    {Drop Release}
	}
	CallHold {
	    {Hold }
	    {Retrieve Reconnect}
	}
	CallTransfer {
	    {InitTransfer BlindTransfer}
	    {CancelTransfer CompleteTransfer}
	    {Retrieve}
	}
	SendISDN {
	    {SendISDN}
	}
	Misc {
	    {Complete CancelComplete}
	    {Park Pickup}
	}
	ExternalApps {
	    {Audio}
	}
    }

    set menuButton(Complete) {CampOn CallBack}
    set menuButton(Reject) {Busy Congestion NumUnavailable Operator NumVacant}
    set menuButton(SendISDN) {FACILITY CONG_CON NOTIFY USER_INFO INFO}
    set menuButton(SetChanState) {InService OutOfService FinishCalls}
    set menuButton(ResetLineDevice) {InService OutOfService}

    #### disable attach/detach if not in toc/roc mode
    if {!$system($boardNum.ClusterMode)} {
	set buttonDisable(AttachMedia) 1
	set buttonDisable(DetachMedia) 1
    }

    foreach {frame bList} $buttonList {
	set f [frame $wv.f$frame]
	foreach row $bList {
	    set wList {}
	    foreach b $row {
		lappend wList $f.b$b
		if {[info exists menuButton($b)]} {
		    menubutton $f.b$b -text "$b.." \
			    -padx 0 -pady 2 -bd 1 -highlightthickness 0 \
			    -relief raised \
			    -menu $f.b$b.menu
		    set m [menu $f.b$b.menu -tearoff 0]
		    foreach item $menuButton($b) {
			$m add command -label $item \
				-command "Cmd$b $instNum $item"
		    }
		} else {
		    button $f.b$b -text $b \
			    -padx 0 -pady 0 -bd 1 -highlightthickness 0 \
			    -command "Cmd$b $instNum"
		}
		if {[info exists buttonDisable($b)]} {
		    $f.b$b configure -state disabled
		}
	    }
	    eval "grid $wList -sticky nsew"
	}
	grid columnconfigure $f 0 -weight 1
	grid columnconfigure $f 1 -weight 1
    }

    grid $wv.mbCommand -sticky w -padx 10
    grid $wv.fChanState -sticky ew
    grid columnconfigure $wv 0 -weight 1

    # Trace
    lappend RunLog(Monitor) chan_${boardNum}_${lineNum}_${chanNum}

    # Trace pane
    set wv [frame $w.fTrace -bd 1 -relief groove]
    set m $wv.mbTrace.menu
    menubutton $wv.mbTrace -textvariable system($instNum.LogMode) \
	    -menu $m -height 0 \
	    -bd 1 -relief raised -pady 1 -indicatoron 1
    menu $m -tearoff 0
    $m add radiobutton -value "Text Log" -variable system($instNum.LogMode) \
	    -label "View Text Log" \
	    -command "pack forget $wv.fGTrace;\
	    pack $wv.fTTrace -expand y -fill both -side top"
    $m add radiobutton -value "Timeline Log" \
	    -variable system($instNum.LogMode) \
	    -label "View Timeline Log" \
	    -command "pack forget $wv.fTTrace;\
	    pack $wv.fGTrace -expand y -fill both -side top"
    set system($instNum.LogMode) "Text Log"

    # TSPMon pane
    set f [frame $wv.fGTrace]
    canvas $f.cTrace -bg black -xscrollcommand "$f.sbTrace set" \
	    -height 0 \
	    -scrollregion $canvas_region
    scrollbar $f.sbTrace -orient horizontal -command "$f.cTrace xview"
    grid $f.cTrace -sticky nsew
    grid $f.sbTrace -sticky ew
    grid rowconfigure $f 0 -weight 1
    grid columnconfigure $f 0 -weight 1

    # TSPTrace pane
    set f [frame $wv.fTTrace]
    text $f.tTrace -yscrollcommand "$f.sbTrace set" \
	    -height 0
    scrollbar $f.sbTrace -orient vertical -command "$f.tTrace yview"
    grid $f.tTrace $f.sbTrace -sticky ns
    grid configure $f.tTrace -sticky nsew
    grid rowconfigure $f 0 -weight 1
    grid columnconfigure $f 0 -weight 1
    pack $wv.mbTrace -anchor nw -side top -padx 10
    pack $wv.fTTrace -expand y -fill both -side top
    grid $w.title - - -sticky w
    grid $w.line $w.chan $w.fTrace -sticky n
    grid ^ $w.command ^
    grid configure $w.fTrace -sticky nsew
    grid configure $w.command -sticky new
    grid columnconfigure $w 2 -weight 1
    grid rowconfigure $w 2 -weight 1
    set clust [$system($boardNum.handle) findClustByTSC \
	    -Line $lineNum -Chan $chanNum]
    set system($instNum.clustHandle) $clust
    set system($instNum.handle) [$clust find -InstClass TSC]
    set system(h.$system($instNum.handle)) $instNum
    set system($instNum.Protocol) $system($boardNum.$lineNum.Protocol)
    set system($instNum.CallId) 0x0
    set system($instNum.CmpltId) 0x0
    set system($instNum.ConCallId) 0x0
    if {$system($boardNum.ClusterMode)} {
	array set tgtDesc [$system($instNum.handle) set TgtDesc]
	set system($instNum.TocRoc) [expr $tgtDesc(Instance)]
    }

    # Setup firmware hooks
    SetupBasicLineEventHandlers $boardNum $lineNum
    SetupChanEventHandlers $instNum
    SetupCASEventHandler $instNum

    # Update status
    RefreshLineStatus $boardNum $lineNum
    RefreshChanStatus $instNum
    return 1
}

proc ToggleAll {alarm boardNum state} {
    global system

    foreach line $system($boardNum.LineList) {
	if {$system($boardNum.$line.$alarm) != $state} {
	    .main.board_$boardNum.main.c${alarm}_${line} invoke
	}
    }
}

proc SysViewOpen {t pane replace} {
    global sysViewSelected

    if {$sysViewSelected} {
	set taglist [$t tag names w$sysViewSelected.first]
	set res [lsearch -regexp $taglist {d[blc][0-9]+}]
	if {$res >= 0} {
	    set tag [lindex $taglist $res]
	    switch -exact [string range $tag 1 1] {
		b {
		    #open board
		    set b [string range $tag 2 end]
		    CreateBoardView $b
		    DisplayView board_$b $pane $replace
		}
		l {
		    #open line
		    set l [string range $tag 2 end]
		    CreateLineView $l
		    DisplayView line_[string map {. _} $l] $pane $replace
		}
		c {
		    #open chan
		    set c [string range $tag 2 end]
		    CreateChanView $c
		    DisplayView chan_[string map {. _} $c] $pane $replace
		}
	    }
	}
    }
}

proc CreateRunningLog {} {
    global RunLog glog font_size
    global canvas_region

    if {![CreateView "Log Current" log]} {
	return 1
    }

    set w .main.log

    lappend RunLog(Monitor) log

    label $w.title -text Log -pady 0

    set f [frame $w.text]
    text $f.tTrace -yscrollcommand "$f.sbTrace set" \
	    -height 0 -width 0 -state disabled
    scrollbar $f.sbTrace -orient vertical -command "$f.tTrace yview"

    grid $f.tTrace $f.sbTrace -sticky ns
    grid configure $f.tTrace -sticky nsew
    grid rowconfigure $f 0 -weight 1
    grid columnconfigure $f 0 -weight 1

    set f [frame $w.graphic]
    canvas $f.cTrace -bg black -xscrollcommand "$f.sbTrace set" \
	    -height 0 -width 0 \
	    -scrollregion $canvas_region
    set c $f.cTrace
    scrollbar $f.sbTrace -orient horizontal -command "$f.cTrace xview"

    grid $f.cTrace -sticky nsew
    grid $f.sbTrace -sticky ew
    grid rowconfigure $f 0 -weight 1
    grid columnconfigure $f 0 -weight 1

    grid $w.title - -sticky w
    grid $w.text $w.graphic -sticky nsew
    grid rowconfigure $w 1 -weight 1
    grid columnconfigure $w 0 -weight 1
    grid columnconfigure $w 1 -weight 1

    return 1
}

proc CreateLogView { filename } {
    global system
    global canvas_region

    if {![file exists $filename]} {
	MessageBox "Unable to open $filename.\nFile does not exist."
	return 0
    }

    set fh [open $filename r]
    fconfigure $fh -encoding binary -translation binary
    set buf [read $fh 1024]
    binary scan $buf a8a6a5 magic junk version
    if {$magic != "PSTNDiag"} {
	MessageBox "Unable to open $filename.\nFile does not appear to be a PSTNDiag log file."
	return 0
    }
    if {$version != "01.00"} {
	MessageBox "Unable to open $filename.\nLog format ($version) is incompatible with this version of PSTNDiag."
	return 0
    }

    set shortfile [file rootname [file tail $filename ]]
    set count [incr system(LogCount)]
    if {![CreateView "Log $shortfile" olog_$count]} {
	return 1
    }

    set w .main.olog_$count

    label $w.title -text "Log $shortfile" -pady 0

    set f [frame $w.text]
    set text [text $f.tTrace -yscrollcommand "$f.sbTrace set" \
	    -height 0 -width 0 -state disabled]
    scrollbar $f.sbTrace -orient vertical -command "$f.tTrace yview"

    grid $f.tTrace $f.sbTrace -sticky ns
    grid configure $f.tTrace -sticky nsew
    grid rowconfigure $f 0 -weight 1
    grid columnconfigure $f 0 -weight 1

    set f [frame $w.graphic]
    set graphic [canvas $f.cTrace -bg black -xscrollcommand "$f.sbTrace set" \
	    -height 0 -width 0 \
	    -scrollregion $canvas_region]
    scrollbar $f.sbTrace -orient horizontal -command "$f.cTrace xview"

    grid $f.cTrace -sticky nsew
    grid $f.sbTrace -sticky ew
    grid rowconfigure $f 0 -weight 1
    grid columnconfigure $f 0 -weight 1

    grid $w.title - -sticky w
    grid $w.text $w.graphic -sticky nsew
    grid rowconfigure $w 1 -weight 1
    grid columnconfigure $w 0 -weight 1
    grid columnconfigure $w 1 -weight 1
    
    set done 0
    while {!$done} {
	set part 0
	set subtotal 1
	set sf {}
	while {$part < $subtotal} {
	    set buf [read $fh 64]
	    if {[string length $buf] < 64} {
		set done 1
		break
	    }
	    binary scan $buf ISSa56 counter subtotal part data
	    append sf $data
	}
	binary scan $sf II ts diff
	$text configure -state normal
	catch {$text insert end "$counter [TextDecode $sf]\n"}
	$text see end
	$text configure -state disabled
	DrawEvent $graphic $counter $diff [GraphicDecode $sf]
	if {$counter % 100 == 0} {
	    update
	}
    }
    return 1
}

proc LEDRegister {wId lineInfo} {
    global system
    lappend system($lineInfo) $wId
}

proc LEDUnregister {wId lineInfo} {
    global system
    set system($lineInfo) [string map "$wId {}" $system($lineInfo)]
}

proc TxRegister {wId lineInfo} {
    global system
    lappend system($lineInfo) $wId
}

proc TxUnregister {wId lineInfo} {
    global system
    set system($lineInfo) [string map "$wId {}" $system($lineInfo)]
}

proc SetLED {lineInfo color} {
    global system
    foreach widget $system($lineInfo) {
	$widget configure -fg $color
    }
}

proc isE1 {val} {
    if {$val == 2 || $val == 3} {
	return 1
    } else {
	return 0
    }
}

proc RefreshLineStatus {boardNum lineNum} {
    global system alarmTrans
    global LineState_InService LineState_OutOfService
    global AllAlarms

    array set retval [$system($boardNum.$lineNum.handle) GetLineState]
    if {$retval(LineState) == $LineState_OutOfService} {
	set system($boardNum.$lineNum.LineState) 0
	LogAppEventData $boardNum $lineNum 0 \
		LCONLineStateRefresh [binary format I 0]
    } else {
	set system($boardNum.$lineNum.LineState) 1
	LogAppEventData $boardNum $lineNum 0 \
		LCONLineStateRefresh [binary format I 1]
    }

    unset retval

    array set retval \
	    [$system($boardNum.$lineNum.handle) GetAlarms -Alarms $AllAlarms]
    foreach alarm $retval(AlarmInfo) {
	array set alarmdata $alarm
	set system($boardNum.$lineNum.$alarmTrans($alarmdata(Type))) \
		[expr $alarmdata(State)]
	LogAppEventData $boardNum $lineNum 0 \
		LCONAlarmRefresh [binary format II $alarmdata(Type) \
		$alarmdata(State)]
	unset alarmdata
    }
}

proc SetupBasicLineEventHandlers {boardNum lineNum} {
    global system
    global AllAlarms LineState_AllService

    set LEDList {Red Yellow Signal Loopback DChannel}

    foreach LED $LEDList {
	if {![string compare [trace vinfo system($boardNum.$lineNum.$LED)] ""]} {
	    trace variable system($boardNum.$lineNum.$LED) w updateAlarmLed
	}
    }

    set TxList {RAI AIS TS16RAI TS16AIS LineState}
    
    foreach Tx $TxList {
	if {![string compare [trace vinfo system($boardNum.$lineNum.$Tx)] ""]} {
	    trace variable system($boardNum.$lineNum.$Tx) w updateAlarmTx
	}
    }

    if {!$system($boardNum.$lineNum.Active)} {
	$system($boardNum.$lineNum.handle) asyncRegister \
		-EvtGroup $AllAlarms -Proc handleAsyncAlarms
	$system($boardNum.$lineNum.handle) asyncRegister \
		-EvtGroup $LineState_AllService -Proc handleAsyncLineState
	$system($boardNum.$lineNum.handle) asyncRegister \
		-Unregistered -Proc handleUnregistered
	$system($boardNum.$lineNum.handle) DetectEvt -EvtType $AllAlarms
	$system($boardNum.$lineNum.handle) DetectEvt -EvtType $LineState_AllService
	lappend system(destroyList) $system($boardNum.$lineNum.handle)
	$system($boardNum.$lineNum.handle) set cancelEvts "$AllAlarms $LineState_AllService"
	set system($boardNum.$lineNum.Active) 1
    }
    
    set system(h.$system($boardNum.$lineNum.handle)) "$boardNum.$lineNum"

}

proc SetupAdvLineEventHandlers {boardNum lineNum} {
    global system
    set LEDList {AISStatus CRC TS16Red TS16Yellow TS16AISStatus}

    foreach LED $LEDList {
	if {![string compare [trace vinfo system($boardNum.$lineNum.$LED)] ""]} {
	    trace variable system($boardNum.$lineNum.$LED) w updateAlarmLed
	}
    }
}

proc handleUnregistered { this type data } {
    global system
    
}

proc handleAsyncAlarms { this type data } {
    global system alarmTrans
    global LineAlarm_Inactive LineAlarm_Active

    array set alarm $data

    set instNum $system(h.$this)
    LogLineEvent $instNum [binary format III $alarm(Label) \
	    $alarm(Type) $alarm(State)]
    set system($instNum.$alarmTrans($alarm(Type))) [expr $alarm(State)]
}

proc handleAsyncLineState {this type arg} {
    global system
    global LineState_InService LineState_OutOfService

    # Get event fields in an array
    array set change $arg

    set instNum $system(h.$this)
    if { $change(Type) == $LineState_InService } {
	set system($instNum.LineState) 1 
	LogLineEvent $instNum [binary format II $change(Label) 1]
    } else {
	set system($instNum.LineState) 0 
	LogLineEvent $instNum [binary format II $change(Label) 0]
    }

}

proc UpdateAlarm { instNum alarm } {
    global system xmitAlarmTrans
    global LineAlarm_Active LineAlarm_Inactive

    set lad $system($instNum.handle)
    set inst [split $instNum .]

    if { $system($instNum.$alarm) == $LineAlarm_Active } {
	if [catch {$lad SendAlarm -AlarmId $xmitAlarmTrans($alarm)} result] {
	    LogAppEventData [lindex $inst 0] [lindex $inst 1] 0 \
		    LCONSendAlarmFail [binary format I $xmitAlarmTrans($alarm)]
	} else {
	    LogAppEventData [lindex $inst 0] [lindex $inst 1] 0 \
		    LCONSendAlarm [binary format I $xmitAlarmTrans($alarm)]
	}
    } else {
	if [catch {$lad StopAlarm -AlarmId $xmitAlarmTrans($alarm)} result] {
	    LogAppEventData [lindex $inst 0] [lindex $inst 1] 0 \
		    LCONStopAlarmFail [binary format I $xmitAlarmTrans($alarm)]
	} else {
	    LogAppEventData [lindex $inst 0] [lindex $inst 1] 0 \
		    LCONStopAlarm [binary format I $xmitAlarmTrans($alarm)]
	}
    }
}

proc UpdateLineState { instNum } {
    global system
    global line LineState_InService LineState_OutOfService 
    global OOSReason_Standby OOSPriority_Immediate

    set oosreason $OOSReason_Standby
    set oospri $OOSPriority_Immediate

    set lad $system($instNum.handle)
    set inst [split $instNum .]

    if { $system($instNum.LineState) == 0 } {
	if [catch {$lad SetLineState -State $LineState_OutOfService \
		-Reason $oosreason -Priority $oospri} result] {
	    LogAppEventData [lindex $inst 0] [lindex $inst 1] 0 \
		    LCONLineStateFail [binary format I 0]
	    set system($instNum.LineState) 1
	} else {
	    LogAppEventData [lindex $inst 0] [lindex $inst 1] 0 \
		    LCONLineState [binary format I 0]
	}
    } else {
	if [catch {$lad SetLineState -State $LineState_InService} result] {
	    LogAppEventData [lindex $inst 0] [lindex $inst 1] 0 \
		    LCONLineStateFail [binary format I 1]
	    set system($instNum.LineState) 0
	} else {
	    LogAppEventData [lindex $inst 0] [lindex $inst 1] 0 \
		    LCONLineState [binary format I 1]
	}
    }
}

proc UpdateLoopback { instNum } {
    global system Loopback_None Loopback_Line
    
    set inst [split $instNum .]
    if { $system($instNum.LoopbackMode) == $Loopback_None } {
	set fail 1
    } else {
	set fail 0
    }
    if [catch { $system($instNum.handle) SetDiagMode \
	    -Mode $system($instNum.LoopbackMode) } result ] {
	LogAppEventData [lindex $inst 0] [lindex $inst 1] 0 \
		LCONLoopbackFail \
		[binary format I $system($instNum.LoopbackMode)]
	set system($instNum.LoopbackMode) $fail
    } else {
	LogAppEventData [lindex $inst 0] [lindex $inst 1] 0 \
		LCONLoopback [binary format I $system($instNum.LoopbackMode)]
    }
}

proc RefreshLoopbackMode {instNum} {
    global system

    array set retval [$system($instNum.handle) GetDiagMode]
    set system($instNum.LoopbackMode) [expr $retval(DiagnosticMode)]
    set inst [split $instNum .]
    LogAppEventData [lindex $inst 0] [lindex $inst 1] 0 \
	    LCONLoopbackRefresh [binary format I $retval(DiagnosticMode)]
}


proc updateAlarmLed { varName index op } {
    global system
    global LedOnColor LedOffColor
    global LineAlarm_Active
    
    upvar $varName var
    
    # Get alarm name
    set list [split $index .]
    set boardNum [lindex $list 0]
    set line [lindex $list 1]
    set alarm [lindex $list 2]
    
    if {$system($index) == 0} {
	foreach w $system($boardNum.$line.Led$alarm) {
	    $w configure -fg $LedOffColor($alarm)
	}
    } else {
	foreach w $system($boardNum.$line.Led$alarm) {
	    $w configure -fg $LedOnColor($alarm)
	}
    }
    if {![string compare $alarm Loopback]} {
	RefreshLoopbackMode $boardNum.$line
    }
}

proc updateAlarmTx { varName index op } {
    global system
    global LedOnColor LedOffColor
    global LineAlarm_Active
    
    upvar $varName var
    
    # Get alarm name
    set list [split $index .]
    set boardNum [lindex $list 0]
    set line [lindex $list 1]
    set alarm [lindex $list 2]
    
    if {$system($index) == $LineAlarm_Active} {
	foreach w $system($boardNum.$line.Led$alarm) {
	    $w configure -selectcolor $LedOnColor($alarm)
	}
    } else {
	foreach w $system($boardNum.$line.Led$alarm) {
	    $w configure -selectcolor $LedOffColor($alarm)
	}
    }
}

set call_state_evt_list [list $TSC_EvtCallState_Type_Null \
	$TSC_EvtCallState_Type_Accepted \
	$TSC_EvtCallState_Type_Connected \
	$TSC_EvtCallState_Type_ConnectedPendXfer \
	$TSC_EvtCallState_Type_Delivered \
	$TSC_EvtCallState_Type_Dialing \
	$TSC_EvtCallState_Type_Disconnected \
	$TSC_EvtCallState_Type_DialReady \
	$TSC_EvtCallState_Type_Failed \
	$TSC_EvtCallState_Type_Idle \
	$TSC_EvtCallState_Type_Initiated \
	$TSC_EvtCallState_Type_Offered \
	$TSC_EvtCallState_Type_Hold \
	$TSC_EvtCallState_Type_OnHoldPendXfer \
	$TSC_EvtCallState_Type_Originated \
	$TSC_EvtCallState_Type_Proceeding \
	$TSC_EvtCallState_Type_Unknown \
	$TSC_EvtCallState_Type_Alerting ]

set chan_state_evt_list [list \
	$TSC_EvtChanState_Type_Active \
	$TSC_EvtChanState_Type_ActivePending \
	$TSC_EvtChanState_Type_Alarm \
	$TSC_EvtChanState_Type_OutOfService \
	$TSC_EvtChanState_Type_Maintenance \
	$TSC_EvtChanState_Type_MaintenanceLocal \
	$TSC_EvtChanState_Type_OutOfServiceLocal \
	$TSC_EvtChanState_Type_Idle \
	$TSC_EvtChanState_Type_IdlePending \
	$TSC_EvtChanState_Type_Null \
	$TSC_EvtChanState_Type_Unknown \
	$TSC_EvtChanState_Type_OutOfServiceMediaDetached \
	$TSC_EvtChanState_Type_OutOfServiceRemote]


proc SetupChanEventHandlers {instNum} {
    global system
    global TSC_EvtCallState_Type_Null \
	    TSC_EvtChanState_Type_Active \
	    TSC_EvtCallInfo_Type_BearerChanId \
	    TSC_EvtCallInfoSet_Type_ISDNMsgSet \
	    TSC_EvtCallInfo_Type_CallAnalysis \
	    TSC_EvtCallInfo_Type_CallerId \
	    TSC_EvtCallInfo_Type_CalledId \
	    TSC_EvtTrace_Type_CallControl \
	    call_state_evt_list \
	    chan_state_evt_list

    set tsc $system($instNum.handle)

    [$tsc set callback] set Event_Unregistered {}

    if {![info exists system($instNum.Active)] } {
	set system($instNum.Active) 0
    }
    if {!$system($instNum.Active)} {
	set system($instNum.Active) 1

	#enable state change callbacks
	$tsc asyncRegister -EvtGroup $TSC_EvtCallState_Type_Null \
		-Proc handleCallStateChange

	#enable chan state callbacks
	$tsc asyncRegister -EvtGroup $TSC_EvtChanState_Type_Active \
		-Proc handleChanStateChange

	#enable call info callbacks
	$tsc asyncRegister -EvtGroup $TSC_EvtCallInfo_Type_BearerChanId \
		-Proc handleInfoEvents
	#   $tsc asyncRegister -EvtGroup $TSC_EvtCallInfoSet_Type_ISDNMsgSet \
		-Proc handleISDNEvents
	$tsc asyncRegister -EvtGroup $TSC_EvtCallInfo_Type_CallAnalysis \
		-Proc handleInfoEvents
	
	#register the handler for API Evt trace messages.
	#NOTE: Set the TypeDef to Msg, this means, don't auto parse
	#the message, instead pass in a raw Msg Object
	
	$tsc asyncRegister -EvtGroup $TSC_EvtTrace_Type_CallControl \
		-Proc handleApiTraceEvt -TypeDef Msg

	$tsc DetectxEvts -EvtGroup $TSC_EvtCallState_Type_Null \
		-EvtTypeList $call_state_evt_list
	
	#enable call info detection
	$tsc DetectxEvts -EvtGroup $TSC_EvtCallInfo_Type_BearerChanId  \
		-EvtTypeList [list $TSC_EvtCallInfo_Type_CalledId \
		$TSC_EvtCallInfo_Type_CallerId]
	#enable chan state detection
	$tsc DetectxEvts -EvtGroup $TSC_EvtChanState_Type_Active  \
		-EvtTypeList $chan_state_evt_list
	#enable API tracing
	$tsc DetectEvt -EvtType $TSC_EvtTrace_Type_CallControl

	lappend system(destroyList) $tsc
	$tsc set cancelEvts [concat $call_state_evt_list \
		$TSC_EvtCallInfo_Type_CalledId \
		$TSC_EvtCallInfo_Type_CallerId \
		$chan_state_evt_list \
		$TSC_EvtTrace_Type_CallControl ]
    }
#### Override default handler for async messages from unregistered sources
proc UnregisteredSourceHandler {msg} {
    #For now, just chuck them.
    return
}
}

proc SetupCASEventHandler {instNum} {
    global system \
	    CAS_EventId_AllSignals \
	    CAS_EventId_AllTransitions

    if {[info exists system($instNum.CAShandle)]} {
	# cas already initialized.
	return 1
    }
    set inst [split $instNum .]
    set clust [$system([lindex $inst 0].handle) findClustByTSC \
	    -Line [lindex $inst 1] -Chan [lindex $inst 2]]
    if {[catch {set system($instNum.CAShandle) \
	    [$clust find -InstClass CAS]}]} {
	# cas not allocated yet.
	return 0
    }
    set cas $system($instNum.CAShandle)
    set system(h.$cas) $instNum
    $cas asyncRegister -EvtGroup $CAS_EventId_AllSignals \
	    -Proc handleSignalEvt
    $cas asyncRegister -EvtGroup $CAS_EventId_AllTransitions \
	    -Proc handleTransEvt
    $cas DetectEvt -EvtType $CAS_EventId_AllSignals
    $cas DetectEvt -EvtType $CAS_EventId_AllTransitions
    lappend system(destroyList) $cas
    $cas set cancelEvts [concat $CAS_EventId_AllSignals \
	    $CAS_EventId_AllTransitions]
    return 1
}

proc CancelCASEventHandler {instNum} {
    global system \
	    CAS_EventId_AllSignals \
	    CAS_EventId_AllTransitions
    if {![info exists system($instNum.CAShandle)]} {
	# cas was never initialized
	return 1
    }
    set cas $system($instNum.CAShandle)
    $cas CancelEvt -EvtType $CAS_EventId_AllSignals
    $cas CancelEvt -EvtType $CAS_EventId_AllTransitions
    $cas destroy
    unset system(h.$cas)
    unset system($instNum.CAShandle)
    return 1
}

proc getCallStateReason { instNum reason } {
    global system transCallStateReason

    if { $system($instNum.Protocol) == 5 } {
	return $reason
    } else {
	return $transCallStateReason($reason)
    }
}

proc RefreshChanStatus { instNum } {
    global system
    global transChanState transCallState
    set tsc $system($instNum.handle)
    array set change [$tsc GetChanState]
    set chanstate $transChanState($change(ChanState))
    set system($instNum.ChanState) $chanstate
    array set change [$tsc GetCallState -CallId $system($instNum.CallId)]
    set system($instNum.CallId) $change(CallId)
    set callstate $transCallState($change(CallState))
    set callstater [getCallStateReason $instNum $change(Reason)]
    set system($instNum.CallState) "$callstate / $callstater"
}

#async event handlers
proc handleCallStateChange { this type evt } {
    global system transCallState
    array set change $evt
    set instNum $system(h.$this)
    set system($instNum.CallId) $change(CallId)
    set callstate $transCallState($change(CallState))
    set callstater [getCallStateReason $instNum $change(Reason)]
    set system($instNum.CallState) "$callstate / $callstater"

    if {$callstate == "Idle" || $callstate == "Null" } {
	set system($instNum.ANI) ""
	set system($instNum.DNIS) ""
    }
    LogChanEvent $instNum [binary format IIII $change(EvtGroup) \
	    $change(CallId) \
	    $change(CallState) $change(Reason)]
}

proc handleChanStateChange { this type evt } {
    global system transChanState
    array set change $evt
    set instNum $system(h.$this)
    set chanstate $transChanState($change(ChanState))
    set system($instNum.ChanState) $chanstate
    LogChanEvent $instNum [binary format II $change(EvtGroup) $change(ChanState)]
}

proc handleInfoEvents { this type evt } {
    global system transCallInfo transCallInfoset
    global TSC_EvtCallInfo_Type_CalledId TSC_EvtCallInfo_Type_CallerId \
	    TSC_EvtCallInfoSet_Type_CallInfoSet \
	    call_info_names call_infoset_names \
	    call_analysis_names TSC_EvtCallInfo_Type_CallAnalysis
    set instNum $system(h.$this)
    array set info $evt
    
    if { $info(Type) == $TSC_EvtCallInfoSet_Type_CallInfoSet } {
	set var_CallInfo $transCallInfoset($info(Type))
	foreach element $info(CallInfo) {
	    array set var_callInfoType $element
	    LogChanEvent $instNum [binary format II $info(Type) \
		    $var_callInfoType(Value)]
	}
    }
    
    if { $info(Type) == $TSC_EvtCallInfo_Type_CalledId } {
	set system($instNum.DNIS) $info(Value)
	LogChanEvent $instNum [binary format Ia64 $info(Type) $info(Value)]
    } elseif { $info(Type) == $TSC_EvtCallInfo_Type_CallerId } {
	set system($instNum.ANI) $info(Value)
	LogChanEvent $instNum [binary format Ia64 $info(Type) $info(Value)]
    } elseif { $info(Type) == $TSC_EvtCallInfo_Type_CallAnalysis } {
	LogChanEvent $instNum [binary format II $info(Type) $info(Value)]
    } else {
	LogChanEvent $instNum [binary format I $info(Type)]
    }
}

proc handleISDNEvents { this type evt } {
    global system transIsdnMessage transIsdnIe
    global tsc isdn_message_name isdn_ie_names isdn_message_name_list isdn_ie_name_list 
    set instNum system(h.$this)
    array set isdnMsg $evt
    set ieList {}
    foreach ie $isdnMsg(Data) {
	array set ieInfo $ie
	lappend ieList "$isdn_ie_names($ieInfo(IEId)) $ieInfo(Value)"
    }
    
    if { $ieList == {} } {
	LogChanEvent $instNum [binary format I $isdnMsg(MessageType)]
    } else {
	LogChanEvent $instNum [binary format I $isdnMsg(MessageType)]
    }
}

proc handleSignalEvt {obj type data} {
    global system
    global prev_time hosttime abstime tablebreak CAS_SIGIDS linecount
    global TRANSCODES i_oldpostrans o_oldpostrans
    set instNum $system(h.$obj)
    set hosttime [clock format [clock seconds] -format %T]
    array set darr $data
    LogChanEvent $instNum \
	    [binary format IcI 0x20 $darr(Direction) $darr(SignalId)]
    return
}

proc handleTransEvt {obj type data} {
    global system
    set instNum $system(h.$obj)
    array set darr $data
    LogChanEvent $instNum \
	    [binary format Iccc 0x21 $darr(Direction) \
	    $darr(PreTransCode) $darr(PostTransCode)]
    return
}
proc handleApiTraceEvt {obj msgtype msg} {
    global system
    global TSC_EvtTrace_Type_CallControl

    set instNum $system(h.$obj)
    set inst [split $instNum .]
    set boardNum [lindex $inst 0]
    set lineNum [lindex $inst 1]
    set chanNum [lindex $inst 2]

    #get trace part of message, does not include embedded msg
    array set darr [$msg bodyGet -Offset 0]

    #get the typedef registry object from the resource object
    set tdr [$obj Class set typeDefRegistry]

    #lookup the typedef for the associated msg type
    set td [$tdr lookup -MsgType $darr(MsgType)]

    #read remainder of message using the typedef
    set emb [$msg bodyGet -TypeDef $td]

    LogChanEvent $instNum \
	    [binary format IIa* $darr(Type) $darr(MsgType) $emb]
    $msg destroy
}

proc CmdSetChanState { instNum state } {
    global system
    global TSC_MsgSetChanState_state_$state

    LogAppEventChanData $instNum CmdSetChanState \
	    [binary format I [set TSC_MsgSetChanState_state_$state]]
    if {[catch {
	$system($instNum.handle) SetChanState \
		-State [set TSC_MsgSetChanState_state_$state]
    } result ]} {
	LogAppErrorChan $instNum $result
    }
    # if this is cas, try to initialize cas handler
    if {$system($instNum.Protocol) == 4} {
	SetupCASEventHandler $instNum
    }
}

proc CmdResetLineDevice { instNum state } {
    global system TSC_MsgSetChanState_state_$state
    LogAppEventChanData $instNum CmdResetLineDevice \
	    [binary format I [set TSC_MsgSetChanState_state_$state]]
    if {[catch {
	$system($instNum.handle) ResetLineDevice \
		-state [set TSC_MsgSetChanState_state_$state]
    } result ]} {
	LogAppErrorChan $instNum $result
    }
}

proc CmdMakeCall { instNum } {
    global system
    LogAppEventChanData $instNum CmdMakeCall \
	    [binary format a64a64c $system($instNum.DestAddr) \
	    $system($instNum.OrigAddr) $system($instNum.CallProgress)]

    if {[catch {
	array set retval [$system($instNum.handle) MakeCall \
		-DestAddr $system($instNum.DestAddr) \
		-OrigAddr $system($instNum.OrigAddr) \
		-CallProgress $system($instNum.CallProgress)]
	#	    -KVSet $kvset]
    } result ]} {
	LogAppErrorChan $instNum $result
    } else {
	set system($instNum.CallId) $retval(CallId)
    }
}

proc CmdDialDigits { instNum } {
    global system 
    LogAppEventChanData $instNum CmdDialDigits \
	    [binary format Ia64 $system($instNum.CallId) \
	    $system($instNum.DestAddr)]
    if {[catch {
	$system($instNum.handle) Dial -CallId $system($instNum.CallId) \
		-DigitString $system($instNum.DestAddr)
    } result ]} {
	LogAppErrorChan $instNum $result
    }
}

proc CmdDrop { instNum } {
    set reason Normal
    global system CallStateR_$reason
    LogAppEventChanData $instNum CmdDrop \
	    [binary format I $system($instNum.CallId)]

    if {[catch {
	$system($instNum.handle) DropCall -CallId $system($instNum.CallId) \
		-Reason [set CallStateR_$reason]
    } result ]} {
	LogAppErrorChan $instNum $result
    }
}

proc CmdDropReason { instNum reason } {
    global system
    LogAppEventChanData $instNum CmdDropReason \
	    [binary format II $system($instNum.CallId) $reason]

    if {[catch {
	$system($instNum.handle) DropCall -CallId $system($instNum.CallId) \
		-Reason $reason
    } result ]} {
	LogAppErrorChan $instNum $result
    }
}

proc CmdRelease { instNum } {
    set reason Normal
    global system CallStateR_$reason
    LogAppEventChanData $instNum CmdRelease \
	    [binary format I $system($instNum.CallId)]

    if {[catch {
	$system($instNum.handle) ReleaseCall -CallId $system($instNum.CallId) \
		-Reason [set CallStateR_$reason]
    } result ]} {
	LogAppErrorChan $instNum $result
    }
}

proc CmdReleaseReason { instNum reason } {
    global system
    LogAppEventChanData $instNum CmdReleaseReason \
	    [binary format II $system($instNum.CallId) $reason]

    if {[catch {
	$system($instNum.handle ReleaseCall -CallId $system($instNum.CallId) \
		-Reason $reason
    } result ]} {
	LogAppErrorChan $instNum $result
    }
}

proc CmdAnswer { instNum } {
    global system
    LogAppEventChanData $instNum CmdAnswer \
	    [binary format I $system($instNum.CallId)]

    if {[catch {
	$system($instNum.handle) AnswerCall \
		-CallId $system($instNum.CallId) -NumRings 1
    } result ]} {
	LogAppErrorChan $instNum $result
    }
}

proc CmdAccept { instNum } {
    global system
    LogAppEventChanData $instNum CmdAccept \
	    [binary format I $system($instNum.CallId)]
    if {[catch {
	$system($instNum.handle) AcceptCall -CallId $system($instNum.CallId)
    } result ]} {
	LogAppErrorChan $instNum $result
    }
}

proc CmdProceed { instNum } {
    global system
    LogAppEventChanData $instNum CmdProceed \
	    [binary format I $system($instNum.CallId)]
    if {[catch {
	$system($instNum.handle) ProceedCall -CallId $system($instNum.CallId)
    } result ]} {
	LogAppErrorChan $instNum $result
    }
}

proc CmdReject { instNum reason } {
    global system TSC_MsgRejectCall_Reason_$reason
    LogAppEventChanData $instNum CmdReject \
	    [binary format II $system($instNum.CallId) \
	    [set TSC_MsgRejectCall_Reason_$reason]]

    if {[catch {
	$system($instNum.handle) RejectCall -CallId $system($instNum.CallId) \
		-Reason [set TSC_MsgRejectCall_Reason_$reason]
    } result ]} {
	LogAppErrorChan $instNum $result
    }
}

proc CmdRedirect { instNum } {
    global system
    LogAppEventChanData $instNum CmdRedirect \
	    [binary format I $system($instNum.CallId)]

    if {[catch {
	$system($instNum.handle) RedirectCall -CallId $system($instNum.CallId) \
		-DestAddr $system($instNum.DestAddr)
    } result ]} {
	LogAppErrorChan $instNum $result
    }
}

proc CmdHold { instNum } {
    global system
    LogAppEventChanData $instNum CmdHold \
	    [binary format I $system($instNum.CallId)]
    if {[catch {
	$system($instNum.handle) HoldCall -CallId $system($instNum.CallId)
    } result ]} {
	LogAppErrorChan $instNum $result
    }
}

proc CmdRetrieve { instNum } {
    global system
    LogAppEventChanData $instNum CmdRetrieve \
	    [binary format I $system($instNum.CallId)]
    if {[catch {
	$system($instNum.handle) RetrieveCall -CallId $system($instNum.CallId)
    } result ]} {
	LogAppErrorChan $instNum $result
    }
}

proc CmdReconnect { instNum } {
    global system
    LogAppEventChanData $instNum CmdReconnect \
	    [binary format I $system($instNum.CallId)]
    if {[catch {
	$system($instNum.handle) ReconnectCall -CallId $system($instNum.CallId)
    } result ]} {
	LogAppErrorChan $instNum $result
    }
}

proc CmdInitTransfer { instNum } {
    global system
    LogAppEventChanData $instNum CmdInitTransfer \
	    [binary format Ia64c $system($instNum.CallId)\
	    $system($instNum.DestAddr) $system($instNum.CallProgress)]

    if {[catch {
	set system($instNum.CallId) [$system($instNum.handle) InitTransfer \
		-DestAddr $system($instNum.DestAddr) \
		-CallId $system($instNum.CallId) \
		-CallProgress $system($instNum.CallProgress)]
    } result ]} {
	LogAppErrorChan $instNum $result
    }
}

proc CmdBlindTransfer { instNum } {
    global system
    LogAppEventChanData $instNum CmdBlindTransfer \
	    [binary format Ia64a64c $system($instNum.CallId)\
	    $system($instNum.DestAddr) \
	    $system($instNum.OrigAddr) \
	    $system($instNum.CallProgress)]

    if {[catch {
	$system($instNum.handle) BlindTransferCall \
		-CallId $system($instNum.CallId) \
		-DestAddr $system($instNum.DestAddr) \
		-OrigAddr $system($instNum.OrigAddr) \
		-CallProgress $system($instNum.CallProgress)
    } result ]} {
	LogAppErrorChan $instNum $result
    }
}

proc CmdCancelTransfer { instNum } {
    global system
    LogAppEventChanData $instNum CmdCancelTransfer \
	    [binary format I $system($instNum.CallId)]
    if {[catch {
	$system($instNum.handle) CancelTransfer \
		-CallId $system($instNum.CallId)
    } result ]} {
	LogAppErrorChan $instNum $result
    }
}

proc CmdCompleteTransfer { instNum } {
    global system
    LogAppEventChanData $instNum CmdCompleteTransfer \
	    [binary format II $system($instNum.CallId) \
	    $system($instNum.ConCallId)]
    if {[catch {
	$system($instNum.handle) CompleteTransfer \
		-CallId $system($instNum.CallId) \
		-ConCallId $system($instNum.ConCallId)
    } result ]} {
	LogAppErrorChan $instNum $result
    }
}

proc CmdSendISDN { instNum msgName } {
    global system

    upvar \#0 $msgName msgType

    upvar \#0 system($instNum.IE.$msgName) real_data
    LogAppEventChanData $instNum CmdSendISDN
    [binary format I $system($instNum.CallId)]

    set data {}
    foreach byte $real_data {
	if [catch {expr $byte} result] {
	    #not a number, assume it is a variable name defined in the global scope
	    global $byte
	    set byte [set $byte]
	}
	lappend data $byte
    }
    
    if {[catch {
	$system($instNum.handle) SendISDN \
		-CallId $system($instNum.CallId) \
		-MessageType $msgType -Data $data
    } result ]} {
	LogAppErrorChan $instNum $result
    }
}

proc CmdComplete { instNum mode } {
    global system TSC_MsgCompleteCall_Mode_$mode
    LogAppEventChanData $instNum CmdComplete \
	    [binary format Ic $system($instNum.CallId) \
	    [set TSC_MsgCompleteCall_Mode_$mode]]

    if {[catch {
	set system($instNum.CmpltId) [$system($instNum.handle) CompleteCall \
		-CallId $system($instNum.CallId) \
		-Mode [set TSC_MsgCompleteCall_Mode_$mode]]
    } result ]} {
	LogAppErrorChan $instNum $result
    }
}

proc CmdCancelComplete { instNum } {
    global system
    LogAppEventChanData $instNum CmdCancelComplete \
	    [binary format I $system($instNum.CallId)]
    
    if {[catch {
	$system($instNum.handle) CancelComplete -CmpltId $system($instNum.CmpltId)
    } result ]} {
	LogAppErrorChan $instNum $result
    }
}

proc CmdPark { instNum } {
    global system
    LogAppEventChanData $instNum CmdPark \
	    [binary format Ia64 $system($instNum.ParkId) \
	    $system($instNum.ParkAddr)]
    
    if {[catch {
	set system($instNum.CallId) [$system($instNum.handle) ParkCall \
		-CallId $system($instNum.ParkId) \
		-ParkAddr $system($instNum.ParkAddr)]
    } result ]} {
	LogAppErrorChan $instNum $result
    }
}

proc CmdPickup { instNum } {
    global system
    LogAppEventChanData $instNum CmdPickup \
	    [binary format Ia64 $system($instNum.ParkId) \
	    $system($instNum.ParkAddr)]
    
    if {[catch {
	set system($instNum.CallId) [$system($instNum.handle) PickupCall \
		-ParkId $system($instNum.ParkId) \
		-ParkAddr $system($instNum.ParkAddr)]
    } result ]} {
	LogAppErrorChan $instNum $result
    }
}

proc CmdAttachMedia { instNum } {
    global system QSCBUS_PORT_OUT QSCBUS_PORT_IN

    LogAppEventChanData $instNum CmdAttachMedia \
	    [binary format I $system($instNum.TocRoc)]

    set inst [split $instNum .]
    set boardNum [lindex $inst 0]
    
    if {[catch {
	set RocInst $system($instNum.TocRoc)
	set roc $system($boardNum.clustHandle)
	$roc SetInstance $system($boardNum.Roc.$RocInst.Cluster)
	set toc $system($instNum.clustHandle)
	array set tocTS [$toc TSInfo -portId $QSCBUS_PORT_IN]
	array set rocTS [$roc TSInfo -portId $QSCBUS_PORT_IN]
    } result ]} { LogAppErrorChan $instNum $result }
    if {[catch {
	$system($instNum.handle) Attach \
		-MediaInfo $system($boardNum.Roc.$RocInst.MediaList)
    } result ]} { LogAppErrorChan $instNum $result }
    if {[catch {
	$roc TSAssign -portId $QSCBUS_PORT_OUT \
		-slotIds $tocTS(slotIds) -encoding $tocTS(encoding) \
		-idlePattern $tocTS(idlePattern)
    } result ]} { LogAppErrorChan $instNum $result }
    if {[catch {
	$roc Activate -portId $QSCBUS_PORT_OUT
    } result ]} { LogAppErrorChan $instNum $result }
    if {[catch {
	$toc TSAssign -portId $QSCBUS_PORT_OUT \
		-slotIds $rocTS(slotIds) -encoding $rocTS(encoding) \
		-idlePattern $rocTS(idlePattern)
    } result ]} { LogAppErrorChan $instNum $result }
    if {[catch {
	$toc Activate -portId $QSCBUS_PORT_OUT
    } result ]} { LogAppErrorChan $instNum $result }
}

proc CmdDetachMedia { instNum } {
    global system
    global system QSCBUS_PORT_OUT
    LogAppEventChanData $instNum CmdDetachMedia {}

    set inst [split $instNum .]
    set boardNum [lindex $inst 0]

    if {[catch {
	set RocInst $system($instNum.TocRoc)
	set roc $system($boardNum.clustHandle)
	$roc SetInstance $system($boardNum.Roc.$RocInst.Cluster)
	set toc $system($instNum.clustHandle)
	$system($instNum.handle) Detach
    } result ]} { LogAppErrorChan $instNum $result }
    if {[catch {
	$roc Deactivate -portId $QSCBUS_PORT_OUT
    } result ]} { LogAppErrorChan $instNum $result }
    if {[catch {
	$toc Deactivate -portId $QSCBUS_PORT_OUT
    } result ]} { LogAppErrorChan $instNum $result }
    if {[catch {
	$roc TSUnassign -portId $QSCBUS_PORT_OUT
    } result ]} { LogAppErrorChan $instNum $result }
    if {[catch {
	$toc TSUnassign -portId $QSCBUS_PORT_OUT
    } result ]} { LogAppErrorChan $instNum $result }
}

proc CmdAudio { instNum } {
    global system
    LogAppEventChanData $instNum CmdAudio {}
    set map [split $instNum .]
    set board [lindex $map 0]
    set line [lindex $map 1]
    set chan [lindex $map 2]
    exec audio -board $board -line $line -chan $chan &
}

proc ParseCommandLine {} {
    global argv argc startup env rundir

    set i 0
    set startup(ShowHelp) 0
    set startup(DoScan) 1
    set startup(DoLog) 1
    set startup(BoardQueue) {}
    set startup(TrunkQueue) {}
    set startup(ChanQueue) {}
    set startup(LogQueue) {}
    set startup(LogFile) [file join $env(INTEL_DIALOGIC_DIR) "log" "pstndiag"]
    append startup(LogFile) [clock format [clock seconds] -format .%Y%m%d.%H%M%S.pdlog]
    set startup(Errors) {}
    set len [llength $argv]
    while {$i < $len} {
	set arg [lindex $argv $i]
	if {[string equal -nocase $arg "-help"]} {
	    set startup(ShowHelp) 1
	} elseif {[string equal -nocase $arg "-noscan"]} {
	    set startup(DoScan) 0
	} elseif {[string equal -nocase $arg "-nolog"]} {
	    set startup(DoLog) 0
	} elseif {[string equal -nocase $arg "-board"]} {
	    incr i
	    lappend startup(BoardQueue) [lindex $argv $i]
	} elseif {[string equal -nocase $arg "-trunk"]} {
	    incr i
	    lappend startup(TrunkQueue) [lindex $argv $i]
	} elseif {[string equal -nocase $arg "-chan"]} {
	    incr i
	    lappend startup(ChanQueue) [lindex $argv $i]
	} elseif {[string equal -nocase -length 2 $arg "-b"]} {
	    lappend startup(BoardQueue) [string range $arg 2 end]
	} elseif {[string equal -nocase -length 2 $arg "-t"]} {
	    lappend startup(TrunkQueue) [string range $arg 2 end]
	} elseif {[string equal -nocase -length 2 $arg "-c"]} {
	    lappend startup(ChanQueue) [string range $arg 2 end]
	} elseif {[string equal -nocase $arg "-logto"]} {
	    incr i
	    set val [lindex $argv $i]
	    if {$val != ""} {
		set startup(LogFile) [file join $rundir $val]
	    } else {
		lappend startup(Errors) "No filename specified for -logto."
	    }
	} elseif {[string equal -nocase $arg "-openlog"]} {
	    incr i
	    set val [lindex $argv $i]
	    if {$val != ""} {
		lappend startup(LogQueue) [file join $rundir $val]
	    } else {
		lappend startup(Errors) "No filename specifed for -openlog."
	    }
	} else {
	    lappend startup(Errors) "Parameter \"$arg\" was not recognized."
	}
	incr i
    }
}

proc resource {} {
    uplevel {
	source pstndiag.qs
    }
}

proc ExitApp {} {
    global system
    catch {
	foreach obj $system(destroyList) {
	    if ![catch {set cancelList [$obj set cancelEvts]} result] {
		#object contains embeded list of events to cancel
		foreach evt $cancelList {
		    if [catch {$obj CancelEvt -EvtType $evt} result] {
			LogAppErrorChan 0.0.0 $result
		    }
		}
	    }
	}
	unset system(destroyList)
    }
    catch {
	CloseLog
    }
    exit
}

proc MessageBox {str} {
    tk_messageBox -icon info -message $str -parent . -title Error -type ok
}

proc DisplayErrors {} {
    global startup
    toplevel .error
    text .error.text -yscrollcommand ".error.yscroll set" -width 40 \
	    -wrap word -height 15
    scrollbar .error.yscroll -orient vertical -command ".error.text yview"
    button .error.ok -text "Dismiss" -command "destroy .error"

    grid .error.text .error.yscroll -sticky ns
    grid .error.ok - -sticky ew

    .error.text insert end "The following errors occurred during pstndiag initialization:\n"
    foreach line $startup(Errors) {
	.error.text insert end "$line\n"
    }
    .error.text configure -state disabled
    wm title .error "PSTNDiag Errors"
    raise .error
}

proc DisplayAbout {} {
    global version
    tk_messageBox -icon info -message "PSTNDiag v$version\nCopyright 2005, Intel Corporation.\nAll rights reserved." -parent . -title About -type ok
}

proc DisplayCommandLineHelp {} {
    if {[catch {toplevel .help}]} {
	# failed so already exists probably.
	raise .help
	return
    }
    frame .help.text
    button .help.ok -text "Dismiss" -command "destroy .help"

    grid .help.text -sticky nsew
    grid .help.ok -sticky ew

    
    set text {
	{- {Command Line Options}}
	{"-help" {Display this screen.}}
	{"-b<b>\n-board <b>" {Start with a board view of board <b>.}}
	{"-t<b>.<t>\n-trunk <b>.<t>" {Start with a trunk view of board <b>, trunk <t>.}}
	{"-c<b>.<t>.<c>\n-chan <b>.<t>.<c>" {Start with a channel view of board <b>, trunk <t>, channel <c>.}}
	{"-noscan" {Do not look for system resources. System view will not be displayed.}}
	{{-nolog} {Do not log events for open views.}}
	{{-logto <file>} {Save log information to <file>.}}
	{{-openlog <file>} {Open and view logfile <file>.}}
    }
    set count 0
    set f .help.text
    foreach line $text {
	incr count
	if {[lindex $line 0] == "-"} {
		label $f.l$count -text [lindex $line 1]
		grid $f.l$count - -sticky ew
	} else {
		label $f.l${count}a -text [lindex $line 0] \
			-anchor ne -justify right -pady 3 -padx 5
		label $f.l${count}b -text [lindex $line 1] \
			-anchor nw -justify left -wraplength 3i -pady 3 -padx 5
		grid $f.l${count}a $f.l${count}b
		grid configure $f.l${count}a -sticky ne
		grid configure $f.l${count}b -sticky nw
	}
    }

    wm title .help "PSTNDiag Help"
    raise .help
}

if {![info exists started]} {

    wm geometry . 640x480	
    wm minsize . 640 480	
    wm protocol . WM_DELETE_WINDOW ExitApp
    
    set system(BoardList) {}
    set system(destroyList) {}
    set system(LogCount) 0
    set RunLog(Active) 0
    set RunLog(Filehandle) ""

    ParseCommandLine
    if {$startup(DoLog)} {
	CreateLog $startup(LogFile)
    }
    CreateMenu
    CreateGUI
    if {$startup(DoScan)} {
	QuerySystem
	CreateSystemView
	DisplayView sysView 1 1
    }
    foreach board $startup(BoardQueue) {
	if {[string is integer -strict $board]} {
	    if {![CreateBoardView $board]} {
		lappend startup(Errors) "Board view for $board failed to open."
	    }
	} else {
	    lappend startup(Errors) "Parameter \"$board\" provided for -b is invalid."
	}
    }
    foreach trunk $startup(TrunkQueue) {
	set map [split $trunk .]
	set boardNum [lindex $map 0]
	set lineNum [lindex $map 1]
	if {[string is integer -strict $boardNum] && \
		[string is integer -strict $lineNum]} {
	    if {![CreateLineView $boardNum.$lineNum]} {
		lappend startup(Errors) "Trunk view for $boardNum.$lineNum failed to open."
	    }
	} else {
	    lappend startup(Errors) "Parameter \"$trunk\" provided for -t is invalid."
	}
    }
    foreach chan $startup(ChanQueue) {
	set map [split $chan .]
	set boardNum [lindex $map 0]
	set lineNum [lindex $map 1]
	set chanNum [lindex $map 2]
	if {[string is integer -strict $boardNum] && \
		[string is integer -strict $lineNum] && \
		[string is integer -strict $chanNum]} {
	    if {![CreateChanView $boardNum.$lineNum.$chanNum]} {
		lappend startup(Errors) "Chan view for $boardNum.$lineNum.$chanNum failed to open."
	    }
	} else {
	    lappend startup(Errors) "Parameter \"$chan\" provided for -c is invalid."
	}
    }
    foreach file $startup(LogQueue) {
	if {![CreateLogView $file]} {
	    lappend startup(Errors) "Log $file failed to open."
	} else {
	    DisplayView olog_$system(LogCount) 1 1
	}
    }
    if {[llength $startup(Errors)] > 0} {
	after 1 {DisplayErrors}
    }
    if {$startup(ShowHelp)} {
	after 1 {DisplayCommandLineHelp}
    }
    set started 1
}

