# Dialogic Version String. Do not edit this or next line.\
DLcid 03000001-11 dm3_qtech
# Do not edit previous line.
################################################################
#
#   Copyright (C) 2005 Intel Corporation.
#
#   All Rights Reserved.  All names, products,
#   and services mentioned herein are the trademarks
#   or registered trademarks of their respective organizations
#   and are the sole property of their respective owners.
#
################################################################

array set modified {}

#procedures
proc setParms {} {
    global data inst modified
    set errored 0
    foreach parmid [array names modified] {
	if [catch {$inst SetParm -Parm $parmid -Val $data($parmid)} result] {
	    puts stderr $result
	    incr errored
	}
    }

    catch {unset modified}
    array set modified {}

    if [expr $errored] {
	#an error occured, update all parms
	getParms
    }

};#endof setVariant

proc getParms { } {
    global data inst modified formats
    foreach parmid [array names data] {
	if [catch {array set value [$inst GetParm -Parm $parmid]} result] {
	    puts stderr $result
	} else {
	    if [info exists formats($parmid)] {
		set data($parmid) [format $formats($parmid) $value(Val)]
	    } else {
		set data($parmid) $value(Val)
	    }
	    unset value
	}
    }

    catch {unset modified}
    array set modified {}

};#endog getVariant

proc parmChanged {ary parmid op} {
    global modified

    set modified($parmid) 1

}

proc addto {listname vals} {

    upvar \#0 $listname lst

    if ![info exists lst] {
	set lst {}
    }

    set lst [concat $lst $vals]


}


proc inherit {filename} {
    global parm_num_ids parm_ids parm_id_prefix parm_name_num_ids parm_format
    uplevel \#0 include $filename

    foreach parmId $parm_ids {
	if ![info exists parm_num_ids($parmId)] {
	    if [catch {expr $parmId} result] {
		#field is a string
		global ${parm_id_prefix}${parmId}
		set parm_num_ids($parmId) [format "0x%x" [set ${parm_id_prefix}${parmId}]]
	    } else {
		set parm_num_ids($parmId) [format "0x%x" $parmId]
	    }
	}

    }

    array set tmp $parm_name_num_ids
    foreach parmId [array names tmp] {
	if ![info exists parm_num_ids($parmId)] {
	    set parm_num_ids($parmId) [format "0x%x" $tmp($parmId)]
	}
    }

}

if [catch {array set check [CheckParms -Proc stdconfig.qs -Provided $argv_clean \
	-Required {-board -file} -Optional {-inst -comptype -class}]} result ] {


    message .msg -text "STDCONFIG -board board_number -file filename \[-class class_name\] \[-comptype component_type_number\] \[-inst instance_number\]\n\nRequired:\n\tboard_number\t\tNumber of the board to configure.\n\tfilename\t\t\tName of the file containing parameters of the component to be configured.\n\nOptional:\n\tclass_name\t\tIntel Dialogic component name.\n\tcomponent_type_number\tIntel Dialogic component type number.\n\tinstnace_number\t\tInstance number of the component to modify.\n\n" -aspect 1000

    button .close -text "Close" -command exit
    pack .msg
    pack .close
    wm title . "Stdconfig usage"
} else {
################################################
    set field_width 20

    #create display

    frame .control
    frame .display

    scrollbar .display.yscroll -command {.display.column yview} -orient vertical
    text .display.column -yscrollcommand {.display.yscroll set} -width 50

    pack .display.column -side left -expand true -fill both
    pack .display.yscroll -fill y -expand true

    #control

    button .control.get -text "get" -command getParms
    button .control.set -text "set" -command setParms
    button .control.exit -text "exit" -command exit

    #recolor text frame to label color
    .display.column configure -bg [lindex [.control.get configure -bg] end]

    pack .control.get -side left
    pack .control.set -side left
    pack .control.exit -side left
    pack .display -fill both -expand true
    pack .control -side left

    array set parms $check(Flags)

    #defaults
    set filename std.prm
    set instance 0
    set comptype 0
    
    set filename $parms(-file)

    inherit $filename

    array set data {}

    #build new fields
    set fields [lsort [array names parm_num_ids]]

    #build format definitions
    array set tmp_formats $parm_format
    array set formats {}
    foreach parm [array names tmp_formats] {
        set formats($parm_num_ids($parm)) $tmp_formats($parm)
    }
	
    #find longest field name
    set field_name_length 0
    foreach field $fields {
        if [expr [string length $field] > $field_name_length] {
            set field_name_length [string length $field]
        }
    }

    set head .display.column
    array set enums $parm_enums

    foreach field $fields {
        frame $head.field_$field
        label $head.field_$field.label -text $field -width $field_name_length -anchor e
        pack $head.field_$field.label -side left -anchor n
        set parmId $parm_num_ids($field)
        frame $head.field_$field.box
        pack $head.field_$field.box -side left -anchor n

        if [info exists enums($field)] {
            array set opts $enums($field)
            set opt_names [lsort [array names opts]]
            foreach opt $opt_names {
                if ![catch {expr $opts($opt)} result] {
		        #it is a number, convert it to hex, all qscript values are returned as hex
                    set opts($opt) [format "0x%x" $opts($opt)]
                }
                radiobutton $head.field_$field.box.radio_$opt -text $opt \
                    -variable data($parmId) -value $opts($opt)
                pack $head.field_$field.box.radio_$opt -anchor w
                if {[lsearch -exact $parms_read_only $field] != -1} {
                    $head.field_$field.box.radio_$opt configure -state disabled
                } 
            }
            unset opts
        } else {
            #text field
            entry $head.field_$field.box.entry -text data($parmId) -width $field_width
            pack $head.field_$field.box.entry -anchor w
            #if it is readonly then disable it
            if {[lsearch -exact $parms_read_only $field] != -1} {
                $head.field_$field.box.entry configure -state disabled
            }
        }
        trace variable data($parmId) w parmChanged
        $head window create end -window $head.field_$field -align top
    }

    #lock display format
    $head configure -state disabled

    #this is done here to override anything done in the inheited files
    #required
    set boardNum $parms(-board)

    #optional
    catch {set instance $parms(-inst)}
    catch {set comptype $parms(-comptype)}
    catch {set Class $parms(-class)}

    wm title . "DM3 Standard Config - Board $boardNum CompType $comptype Instance $instance"

    if [catch {expr $comptype} result] {
        #comptype was not a number, it should be the name of a global variable
        set comptype [set $comptype]
    }


    #find instance

    set board [Board new -init [list -BoardNum $boardNum]]

    if ![info exists Class] {
        if [expr $instance == 0] {
	      set Class Component
        } else {
	      set Class Instance
        }
    } else {
        #overwride comtype with value from class
        set comptype [$Class set ComponentType]
        wm title . "DM3 Standard Config - Board $boardNum $Class Instance $instance"
    }

    if [expr $instance == 0] {
        #find a component
        set inst [$board findComp -CompType $comptype -CompClass $Class]
    } else {
        set inst [$board findInst -CompType $comptype -InstNo $instance -InstClass $Class]
    }


    #start

    getParms
}

