/****************************************************************************
 *		Copyright (c) 1995 Dialogic Corp.
 *		All Rights Reserved.
 *
 *		THIS IS UNPUBLISHED PROPRIETARY SOURCE CODE OF Dialogic Corp.
 *		The copyright notice above does not evidence any actual or
 *		intended publication of such source code.
 ***************************************************************************/

/****************************************************************************
 * FILE:
 * AUTHOR:       H.Patel
 * ORG:          Dialogic Corporation
 * ORIG-DATE:    07-Sept-00
 * LAST-MOD:     Wed Jul 31 17:11:05 2002 by huj
 * PURPOSE:      Location tags for QError
 *
 * HISTORY:
 * Date        Who         Description
 * 07/31/02    HUJ         Add Ad12_LOC_085 and Ad12_LOC_086 for linear
 *                         coder 8-bit and 16-bit HCStreamRead() error.
 * 09/18/01    bl          free Ad12_LOC_85, Ad12_LOC_86 and Ad12_LOC_87
 *                         since Ad12encAsyncError() has been removed.          
 * 04/17/01    bl          add AD12_LOC_159
 * 9/07/00     HRP	   Initial creation for Implementing of qError.
 ***************************************************************************/
#ifndef _ad12QErrorLocs_h
#define _ad12QErrorLocs_h 1

#define AD12_LOC_000	0x800000  /* UnUsed */


#define AD12_LOC_001	0x800001  /* AD12:Ad12CmpIni.c:Ad12ComponentInit(),
                     				    get task's self component Descriptor*/

#define AD12_LOC_002	0x800002  /* AD12:Ad12CmpIni.c:Ad12ComponentInit(), Register Component*/


#define AD12_LOC_003	0x800003  /* AD12:Ad12CmpIni.c:Ad12ComponentInit(),
                      				    message for registration complete */

#define AD12_LOC_004	0x800004  /* AD12:Ad12CmpIni.c:Ad12ComponentInit(),
                                 	 QCompRegisterResult_get*/

#define AD12_LOC_005	0x800005  /* AD12:Ad12CmpIni.c:Ad12ComponentInit(),
                                    free message buffer */

#define AD12_LOC_006	0x800006  /* AD12:Ad12CmpIni.c:Ad12ComponentInit(),
                                    receive a message prior to receipt */

#define AD12_LOC_007	0x800007  /* AD12:Ad12CmpIni.c:Ad12ComponentInit(),
                                    Memory Exhausted 'QMemNORM' for compParm allocation */

#define AD12_LOC_008	0x800008  /* AD12:AD12CompSm.c:decoderCompStateMachine(),
                      				    Memory Exhausted 'QMemXFER' for IDB */

#define AD12_LOC_009	0x800009  /* AD12:AD12CompSm.c:decoderCompStateMachine(),
                      				    Memory Exhausted 'QMemNORM' for parm table */

#define AD12_LOC_010   0x80000A  /* AD12:AD12CompSm.c:decoderCompStateMachine(),
                                    Faild on calling CompInstanceRegister*/

#define AD12_LOC_011   0x80000B  /* AD12:AD12CompSm.c:decoderCompStateMachine(),
                                 	 Internal Memory Exhausted 'QMemCHIP' for G726*/

#define AD12_LOC_012   0x80000C  /* AD12:AD12CompSm.c:decoderCompStateMachine(),
                                    Invalid Component State*/

#define AD12_LOC_013   0x80000D  /* AD12:AD12CompSm.c:decoderCompStateMachine(),
                                 	 Internal Memory Exhausted 'QMemCHIP' for G726*/

#define AD12_LOC_014   0x80000E  /* AD12:AD12CompSm.c:decoderCompStateMachine(),
                                 	 External Memory Exhausted 'QMemCHIP' for G726*/

#define AD12_LOC_015   0x80000F  /* AD12:AD12CompSm.c:decoderCompStateMachine(),
                                 	 Memory Exhausted for Speed Control*/

#define AD12_LOC_016	0x800010  /* AD12Init.c:Ad12Init(), Failed on qTaskCreate()*/


#define AD12_LOC_017	0x800011  /* AD12Init.c:Ad12Init(), Failed on qCompInitStart()*/


#define AD12_LOC_018	0x800012  /* AD12:Ad12InstSm.c:decoderInstStateMachine(),
                      				    Invalid coder type */

#define AD12_LOC_019	0x800013  /* AD12:Ad12InstSm.c:decoderInstStateMachine(),
                                    Failed on HC-stream create*/

#define AD12_LOC_020	0x800014  /* AD12:Ad12InstSm.c:decoderInstStateMachine(),
                                    Failed on open HC-stream*/

#define AD12_LOC_021	0x800015  /* AD12:Ad12InstSm.c:decoderInstStateMachine(),
                                    Failed on qCStreamOpen() */

#define AD12_LOC_022	0x800016  /* AD12:Ad12InstSm.c:decoderInstStateMachine(),
                                    HCSMInvoke() call returns error at DIS_STARTING2 state*/

#define AD12_LOC_023	0x800017  /* AD12:Ad12InstSm.c:decoderInstStateMachine(),
                                    cHCSMInvoke() call returns error at DIS_STARTING3 state*/

#define AD12_LOC_024	0x800018  /* AD12:Ad12InstSm.c:decoderInstStateMachine(),
                                    HCSGetStatusStreamState() call returns error at DIS_STARTING3 state*/

#define AD12_LOC_025	0x800019  /* AD12:Ad12InstSm.c:decoderInstStateMachine(),
                       			    HCSMInvoke() call returns error at DIS_STARTING4 state*/

#define AD12_LOC_026	0x80001A  /* AD12:Ad12InstSm.c:decoderInstStateMachine(),
                      				    HCSGetStatusStreamState() call returns error at DIS_DECODING */

#define AD12_LOC_027	0x80001B  /* AD12:Ad12InstSm.c:decoderInstStateMachine(),
                      				    HCSGetStatusStreamError() call returns error*/

#define AD12_LOC_028	0x80001C  /* AD12:Ad12InstSm.c:decoderInstStateMachine(),
                      				    HCSGetStatusStreamFlags() call returns error*/

#define AD12_LOC_029	0x80001D  /* AD12:Ad12InstSm.c:decoderInstStateMachine(),
                      				    HCSGetStatusEODCount() call returns error*/

#define AD12_LOC_030	0x80001E  /* AD12:Ad12InstSm.c:decoderInstStateMAchine(),
                      				    HCSMInvoke() call returns error at DIS_DECODING state*/

#define AD12_LOC_031	0x80001F  /* AD12:Ad12InstSm.c:decoderInstStateMAchine(),
                      				    HCSMInvoke() call returns error at DIS_PAUSE state*/

#define AD12_LOC_032	0x800012  /* AD12:Ad12InstSm.c:decoderInstStateMAchine(),
                      				    HCSMInvoke() call returns error at DIS_UNPAUSING state*/

#define AD12_LOC_033	0x800021  /* AD12:Ad12InstSm.c:decoderInstStateMAchine()
                      				    Failed on HCStreamClose()*/

#define AD12_LOC_034	0x800022  /* AD12:Ad12InstSm.c:decoderInstStateMAchine(),
                      				    HCSMInvoke() call returns error at STOPPING1 state*/

#define AD12_LOC_035	0x800023  /* AD12:Ad12InstSm.c:decoderInstStateMAchine(),
                      				    Invalid return code for qCStreamClose() call */

#define AD12_LOC_036	0x800024  /* AD12:Ad12InstSm.c:decoderInstStateMAchine(),
                      				    HCSMInvoke() call returns error at DIS_STOPPING3 state*/

#define AD12_LOC_037	0x800025  /* AD12:Ad12InstSm.c:decoderInstStateMAchine(),
                      				    HCSGetStatusStreamState() call returns error*/

#define AD12_LOC_038	0x800026  /* AD12:Ad12InstSm.c:decoderInstStateMAchine(),
                                 	 HCSManagerDelete() call returns error*/

#define AD12_LOC_039	0x800027  /* AD12:Ad12InstSm.c:decoderInstStateMAchine(),
                                 	 Invalid instance State Machince state */

#define AD12_LOC_040	0x800028  /* AD12:Ad12KerMsh.c:Ad12QCStreamCloseCompleteHndlr(
                                 	 A message sent to illegal instance*/

#define AD12_LOC_041	0x800029  /* AD12:Ad12KerMsh.c:Ad12QCStreamCloseCompleteHndlr(),
                                 	 Recieved a message in an illegal Instance State Machine state*/

#define AD12_LOC_042	0x80002A  /* AD12:Ad12KerMsh.c:Ad12QResultErrorHndlr(),
                                 	 A message send to illegal instance*/

#define AD12_LOC_043	0x80002B  /* AD12:Ad12KerMsh.c:Ad12QResultErrorHndlr(),
                                 	 QResultError_get() call returns error*/

#define AD12_LOC_044	0x80002C  /* AD12:Ad12KerMsh.c:Ad12QResultErrorHndlr(),
                                 	 Recieved a message in an illegal Instance State Machine state*/

#define AD12_LOC_045	0x80002D  /* AD12:Ad12KerMsh.c:Ad12QResultCompleteHndlr(),
                                    Error at DCS_AWAITINGREGINSTCMPLT State */

#define AD12_LOC_046	0x80002E  /* AD12:Ad12Main.c:Ad12_CompTask(),
                                 	 Invalid return code of qFTimerWait() call*/

#define AD12_LOC_047	0x80002F  /* AD12:Ad12MsgDis.c:Ad12processMessage(),
                                 	 HCSM handle not available to handle the G-Stream specific message*/

#define AD12_LOC_048	0x800030  /* AD12:Ad12MsgDis.c:Ad12processMessage(),
                                 	 HCSM handle not available to handle the HSCM specific message*/

#define AD12_LOC_049	0x800031  /* AD12:Ad12MsgDis.c:Ad12processMessage(),
                                 	 Failed on qMsgFree()*/

#define AD12_LOC_050	0x800032  /* AD12:Ad12ProMsh.c:Ad12ADec_MsgStartHndlr(),
                                 	 A message sent to illegal instance*/

#define AD12_LOC_051	0x800033  /* AD12:Ad12ProMsh.c:Ad12ADec_MsgStopHndlr(),
                                 	 A message sent to illegal instance*/

#define AD12_LOC_052	0x800034  /* AD12:Ad12ProMsh.c:Ad12ADec_MsgPauseHndlr(),
                                 	 A message sent to illegal instance*/

#define AD12_LOC_053	0x800035  /* AD12:Ad12ProMsh.c:Ad12ADec_MsgPauseHndlr(),
                                 	 Illegal Instance State Machine state*/

#define AD12_LOC_054	0x800036  /* AD12:Ad12ProMsh.c:Ad12ADec_MsgResumeHndlr(),
                                 	 A message sent to illegal instance*/

#define AD12_LOC_055	0x800037  /* AD12:Ad12ProMsh.c:Ad12sendMsgResumeCmplt(),
                                 	 Failed on qMsgAllocate() call*/

#define AD12_LOC_056	0x800038  /* AD12:Ad12ProMsh.c:Ad12sendMsgResumeCmplt(),
                                 	 Failed on qMsgWrite() call*/

#define AD12_LOC_057	0x800039  /* AD12:Ad12ProMsh.c:Ad12sendMsgStartCmplt(),
                                 	 Failed on qMsgAllocate() call*/

#define AD12_LOC_058	0x80003A  /* AD12:Ad12ProMsh.c:Ad12sendMsgStartCmplt(),
                                	 Failed on qMsgWrite() call*/

#define AD12_LOC_059	0x80003B  /* AD12:Ad12ProMsh.c:Ad12sendMsgStopCmplt(),
                                 	 Failed on qMsgAllocate() call*/

#define AD12_LOC_060	0x80003C  /* AD12:Ad12ProMsh.c:Ad12sendMsgStopCmplt(),
                                 	 Failed on qMsgWrite() call*/

#define AD12_LOC_061	0x80003D  /* AD12:Ad12ProMsh.c:Ad12sendMsgPauseCmplt(),
                                 	 Failed on qMsgAllocate() call*/

#define AD12_LOC_062	0x80003E  /* AD12:Ad12ProMsh.c:Ad12sendMsgPauseCmplt(),
                                 	 Failed on qMsgWrite() call*/

#define AD12_LOC_063	0x80003F  /* AD12:Ad12ProMsh.c:Ad12sendMsgStatusEvt(),
                                 	 Failed on qMsgAllocate() call*/

#define AD12_LOC_064   0x800030  /* AD12:Ad12ProMsh.c:Ad12sendMsgStatusEvt(),
                                 	 Failed on qMsgWrite() call*/

#define AD12_LOC_065   0x800041  /* AD12:Ad12SpuDec.c:decoder(),
                                 	 HCStreamRead() error at WAV11k8b state*/

#define AD12_LOC_066   0x800042  /* AD12:Ad12SpuDec.c:decoder(),
                                 	 HCStreamRead() error at WAV11k16b state*/

#define AD12_LOC_067   0x800043  /* AD12:Ad12SpuDec.c:decoder(),
                                 	 HCStreamRead() error at MULAW64D state*/

#define AD12_LOC_068   0x800044  /* AD12:Ad12SpuDec.c:decoder(),
                                 	 HCStreamRead() error at ALAW64D state*/

#define AD12_LOC_069   0x800045  /* AD12:Ad12SpuDec.c:decoder(),
                                 	 HCStreamRead() error at MULAW48D state*/

#define AD12_LOC_070   0x800046  /* AD12:Ad12SpuDec.c:decoder(),
                                 	 HCStreamRead() error at ALAW48D state*/

#define AD12_LOC_071   0x800047  /* AD12:Ad12SpuDec.c:decoder(),
                                 	 HCStreamRead() error at OKI32D state*/

#define AD12_LOC_072   0x800048  /* AD12:Ad12SpuDec.c:decoder(),
                                 	 HCStreamRead() error at OKI24D state*/

#define AD12_LOC_073   0x800049  /* AD12:Ad12SpuDec.c:decoder(),
                                 	 Unsupportted decoder type */

#define AD12_LOC_074   0x80004A  /* AD12:Ad12SpuDec.c:getCoefsSRC11to8(),
                                 	 Unsupportted decoder type */

#define AD12_LOC_075   0x80004B  /* AD12:Ad12SpuDec.c:writeOutputToCStrm(),
                                 	 sampsBeforeWrap > 512 */

#define AD12_LOC_076   0x80004C  /* AD12:Ad12StdMsh.c:Ad12Std_MsgInitHndlr(),
                                 	 Received a message in invalid state */

#define AD12_LOC_077   0x80004D  /* AD12:Ad12StdMsh.c:Ad12sendStd_MsgInitCmplt(),
                                 	 Failed on qMsgAllocate()*/

#define AD12_LOC_078   0x80004E  /* AD12:Ad12StdMsh.c:Ad12sendStd_MsgIniCmplt(),
                                 	 Failed on qMsgWrite()*/

#define AD12_LOC_079   0x80004F  /* AD12:Ad12StdMsh.c:Ad12sendStdError(),
                                 	 Failed on qMsgAllocate()*/

#define AD12_LOC_080   0x800050  /* AD12:Ad12StdMsh.c:Ad12sendStdError(),
                                 	 Failed on Std_MsgError_put()*/

#define AD12_LOC_081   0x800051  /* AD12:Ad12StdMsh.c:Ad12sendStdError(),
                                 	 Failed on qMsgWrite()*/

#define AD12_LOC_082   0x800052  /* AD12:Ad12StdMsh.c:Ad12encError(),
                                 	 Failed on qMsgAllocate()*/

#define AD12_LOC_083   0x800053  /* AD12:Ad12StdMsh.c:Ad12encError(),
                                 	 Failed on Std_MsgError_put()*/

#define AD12_LOC_084   0x800054  /* AD12:Ad12StdMsh.c:Ad12encError(),
                                 	 Failed on qMsgWrite()*/

#define AD12_LOC_085   0x800055  /* AD12:Ad12SpuDec.c:decoder(),
                                 	HCStreamRead() error at CODERS_LINEAR_8K_8BIT state
                                 	*/

#define AD12_LOC_086   0x800056  /* AD12:Ad12SpuDec.c:decoder(),
                                 	CStreamRead() error at CODERS_LINEAR_8K_16BIT state
                                 	 */

#define AD12_LOC_087   0x800057  /* AD12:.c:(),
                                 	*/

#define AD12_LOC_088   0x800058  /* AD12:Ad12StdMsh.c:Ad12Std_MsgComTestHnd
                                 	 Failed on qMsgAllocate()*/

#define AD12_LOC_089   0x800059  /* AD12:Ad12StdMsh.c:Ad12Std_MsgComTest
                                 	 Failed on qMsgWrite()*/

#define AD12_LOC_090   0x80005A  /* AD12:Ad12StdMsh.c:Ad12Std_MsgSetParmHndlr(),
                                 	 Failed on Std_MsgSetParm_get() */

#define AD12_LOC_091   0x80005B  /* AD12:Ad12StdMsh.c:Ad12Std_MsgSetParmHnd
                                 	 Failed on qMsgAllocate()*/

#define AD12_LOC_092   0x80005C  /* AD12:Ad12StdMsh.c:Ad12Std_MsgSetParm
                                 	 Failed on qMsgWrite()*/

#define AD12_LOC_093   0x80005D  /* AD12:Ad12StdMsh.c:Ad12Std_MsgSetParmDefHndlr(),
                                 	 Faild on Std_MsgSetParmDef_get() */

#define AD12_LOC_094   0x80005E  /* AD12:Ad12StdMsh.c:Ad12Std_MsgSetParmDef
                                 	 Failed on qMsgAllocate()*/

#define AD12_LOC_095   0x80005F  /* AD12:Ad12StdMsh.c:Ad12Std_MsgSetParmD
                                 	 Failed on qMsgWrite()*/

#define AD12_LOC_096   0x800060  /* AD12:Ad12StdMsh.c:Ad12Std_MsgSetAllParm
                                 	 Failed on qMsgAllocate()*/

#define AD12_LOC_097   0x800061  /* AD12:Ad12StdMsh.c:Ad12Std_MsgSetAllP
                                 	 Failed on qMsgWrite()*/

#define AD12_LOC_098   0x800062  /* AD12:Ad12StdMsh.c:Ad12Std_MsgGetParmHndlr(),
                                 	 Failed on Std_MsgGetparm_get()*/

#define AD12_LOC_099   0x800063  /* AD12:Ad12StdMsh.c:Ad12Std_MsgGetParmHndl
                                 	 Failed on qMsgAllocate()*/

#define AD12_LOC_100   0x800064  /* AD12:Ad12StdMsh.c:Ad12Std_MsgGetParm
                                	 Failed on qMsgWrite()*/

#define AD12_LOC_101   0x800065  /* AD12:Ad12Utils.c:Ad12SyncCStreamIndex(),
                                 	 Failed on qCStreamPosition() call */

#define AD12_LOC_102   0x800066  /* AD12:Ad12.h:NEW_OUTPUT_MESSAGE(msgType, dest),
                                  	 Failed on qMsgAllocate() call*/

#define AD12_LOC_103   0x800067  /* AD12:Ad12.h:ALLOCATE_MSG_BLOCK(msgType),
                                  	 Failed on qMsgAllocate() call*/

#define AD12_LOC_104   0x800068  /* AD12:HCSMcreate.c:HCSManagerCreate(),
                                  	 Failed on qPoolFind() call*/

#define AD12_LOC_105   0x800069  /* AD12:HCSMcreate.c:HCSManagerCreate(),
                                  	 Failed on qPoolAlloc() call*/

#define AD12_LOC_106   0x80006A  /* AD12:HCSMcreate.c:HCSManagerCreate(),
                                  	 Failed on qPoolFind() for QNO_POOL_AVAILABLE*/

#define AD12_LOC_107   0x80006B  /* AD12:HCSMcreate.c:HCSManagerCreate(),
                                  	 Failed on qPoolAlloc() call for QPOOL_EXHAUSTED*/

#define AD12_LOC_108   0x80006C  /* AD12:HCSMcreate.c:HCSManagerCreate(),
                                  	 Failed on qPoolFind() for QNO_POOL_AVAILABLE*/

#define AD12_LOC_109   0x80006D  /* AD12:HCSMcreate.c:HCSManagerCreate(),
                                  	 Failed on qPoolAlloc() call for QPOOL_EXHAUSTED*/

#define AD12_LOC_110   0x80006E  /* AD12:HCSMcreate.c:HCSManagerDelete(),
                                  	 Failed on qPoolFree() call for X Buffer*/

#define AD12_LOC_111   0x80006F  /* AD12:HCSMcreate.c:HCSManagerDelete(),
                                  	 Failed on qPoolFree() for C Buffer*/

#define AD12_LOC_112   0x800070  /* AD12:HCSMcreate.c:HCSManagerDelete(),
                                  	 Failed on qPoolFree() call for HCSM Control Structure*/

#define AD12_LOC_113   0x800071  /* AD12:HCSMinvoke.c:HCS_stop(),
                                  	 Failed on qGStreamClose() call */

#define AD12_LOC_114   0x800072  /* AD12:HCSMinvoke.c:HCS_stop(),
                                  	 Failed on qGStreamClose() call  */

#define AD12_LOC_115   0x800073  /* AD12:HCSMinvoke.c:HCS_stop(),
                                  	 Failed on qGStreamClose() call  */

#define AD12_LOC_116   0x800074  /* AD12:HCSMinvoke.c:HCS_stop(),
                                  	 Failed on qGStreamClose() call  */

#define AD12_LOC_117   0x800075  /* AD12:HCSMinvoke.c:HCS_stop(),
                                  	 Invalid Stream Error  */

#define AD12_LOC_118   0x800076  /* AD12:HCSMinvoke.c:HCS_ReadNewBlock(),
                                  	 Failed on qGStreamIndexRead() call  */

#define AD12_LOC_119   0x800077  /* AD12:HCSMinvoke.c:HCS_ReadNewBlock(),
                                  	 Invalid Sample Format  */

#define AD12_LOC_120   0x800078  /* AD12:HCSMinvoke.c:HCS_ReadNewBlock(),
                                  	 Failed on qGStreamIndexRead() call  */

#define AD12_LOC_121   0x800079  /* AD12:HCSMinvoke.c:formatCopy(),
                                  	 Failed on xbufDataAvail() call  */

#define AD12_LOC_122   0x80007A  /* AD12:HCSMinvoke.c:formatCopy(),
                                  	 Unknown Sample Format  */

#define AD12_LOC_123   0x80007B  /* AD12:HCSMinvoke.c:cbufDataAvail(),
                                  	 illegal Pointer  */

#define AD12_LOC_124   0x80007C  /* AD12:HCSMinvoke.c:readCurrentBlock(),
                                  	 Invalid mode for Data Transfer  */

#define AD12_LOC_125   0x80007D  /* AD12:HCSMinvoke.c:readCurrentBlock(),
                                  	 Invalid Sample Format  */

#define AD12_LOC_126   0x80007E  /* AD12:HCSMinvoke.c:readCurrentBlock(),
                                  	 Failed on qGStreamIndexRead() call  */

#define AD12_LOC_127   0x80007F  /* AD12:HCSMinvoke.c:advanceRead(),
                                  	 Failed on qGStreamAdvanceRead() call  */

#define AD12_LOC_128   0x800080  /* AD12:HCSMinvoke.c:xBuf2cBufCopy(),
                                  	 Failed on Samples in XBuf  */

#define AD12_LOC_129   0x800081  /* AD12:HCSMinvoke.c:xBuf2cBufCopy(),
                                  	 Failed on Space before Wrap  */

#define AD12_LOC_130   0x800082  /* AD12:HCSMinvoke.c:xBuf2cBufCopy(),
                                  	 Invalid Sample format at HCSM_TWO_BIT_PER_SAMP_RJ state   */

#define AD12_LOC_131   0x800083  /* AD12:HCSMinvoke.c:xBuf2cBufCopy(),
                                  	 Invalid Sample format at HCSM_THREE_BIT_PER_SAMP_RJ state   */

#define AD12_LOC_132   0x800084  /* AD12:HCSMinvoke.c:xBuf2cBufCopy(),
                                  	 Unknown Sample format state   */

#define AD12_LOC_133   0x800085  /* AD12:HCSMinvoke.c:HCS_ReadNextBlockThenAdvance(),
                                  	 Failed on qGStreamIndexRead() call  */

#define AD12_LOC_134   0x800086  /* AD12:HCSMinvoke.c:HCS_ReadNextBlockThenAdvance(),
                                  	 Unknown Sample format state   */

#define AD12_LOC_135   0x800087  /* AD12:HCSMinvoke.c:HCS_ReadNextBlockThenAdvance(),
                                  	 Failed on qGStreamIndexRead() call  */

#define AD12_LOC_136   0x800088  /* AD12:HCSMinvoke.c:HCS_ReadNextBlockThenAdvance(),
                                  	 Failed on qGStreamAdvanceRead() call  */

#define AD12_LOC_137   0x800089  /* AD12:HCSMinvoke.c:samplesToBytes(),
                                  	 Unknown Sample format state   */

#define AD12_LOC_138   0x80008A  /* AD12:HCSMmsgHandler.c:HCSMmsgHandler(),
                                  	 Unknown state   */

#define AD12_LOC_139   0x80008B  /* AD12:HCSMmsgHandler.c:HCSM_QGStrmCloseCmplt_Hndlr(),
                                  	 Failed on qMsgFree()*/

#define AD12_LOC_140   0x80008C  /* AD12:HCSMmsgHandler.c:HCSM_QGStrmCloseCmplt_Hndlr(),
                                  	 Failed on HCSMState*/

#define AD12_LOC_141   0x80008D  /* AD12:HCSMmsgHandler.c:HCSM_QGStrmCloseCmplt_Hndlr(),
                                  	 Illegal SF Value*/

#define AD12_LOC_142   0x80008E  /* AD12:HCSMmsgHandler.c:HCSM_QGStrmCloseCmplt_Hndlr(),
                                  	 Failed on qMsgFree()*/

#define AD12_LOC_143   0x80008F  /* AD12:HCSMmsgHandler.c:HCSM_QGStrmOpenCmplt_Hndlr(),
                                  	 Failed on qMsgFree()*/

#define AD12_LOC_144   0x800090  /* AD12:HCSMmsgHandler.c:HCSM_QGStrmOpenCmplt_Hndlr(),
                                  	 Failed on qMsgFree()*/

#define AD12_LOC_145   0x800091  /* AD12:HCSMmsgHandler.c:HCSM_QGStrmOpenCmplt_Hndlr(),
                                  	 Failed on qMsgFree()*/

#define AD12_LOC_146   0x800092  /* AD12:HCSMmsgHandler.c:HCSM_QGStrmCmplt_Hndlr(),
                                  	 Failed on qMsgFree()*/

#define AD12_LOC_147   0x800093  /* AD12:HCSMmsgHandler.c:HCSM_QGStrmCmplt_Hndlr(),
                                  	 Unknown HCSM State*/

#define AD12_LOC_148   0x800094  /* AD12:HCSMmsgHandler.c:HCSM_QGStrmCmplt_Hndlr(),
                                  	 unreachable code*/

#define AD12_LOC_149   0x800095  /* AD12:HCSMmsgHandler.c:HCSM_QResultError_Hndlr(),
                                  	 Failed on qMsgFree()*/

#define AD12_LOC_150   0x800096  /* AD12:HCSMopen.c:HCStreamClose(),
                                  	 A request to close HCStream when the stream manager is IDLE.*/

#define AD12_LOC_151   0x800097  /* AD12:HCSMopen.c:HCStreamClose(),
                                  	 call to HCStreamClose() in HCS_WAITFORGSTMCLOSE.*/

#define AD12_LOC_152   0x800098  /* AD12:HCSMopen.c:HCStreamClose(),
                                  	 call to HCStreamClose() when SF=1*/

#define AD12_LOC_153   0x800099  /* AD12:HCSMopen.c:HCStreamClose(),
                                  	 call to HCStreamClose() when HCSM is in unknown state.*/

#define AD12_LOC_154   0x80009A  /* AD12:HCSMread.c:HCStreamRead(),
                                  	 Error at CLOSING StreamState.*/

#define AD12_LOC_155   0x80009B  /* AD12:HCSMread.c:HCStreamRead(),
                                  	 Error at CLOSING StreamState.*/

#define AD12_LOC_156   0x80009C  /* AD12:HCSMread.c:HCStreamRead(),
                                  	 Size of Buffer Error at CLOSING State.*/

#define AD12_LOC_157   0x80009D  /* AD12:HCSMread.c:HCStreamRead(),
                                  	 Sample after Wrap Error at CLOSING State.*/

#define AD12_LOC_158   0x80009E  /* AD12:HCSMread.c:HCStreamRead(),
                                  	 Unknown Stream State.*/

#define AD12_LOC_159   0x80009F  /* AD12:HCSMinvoke.c:processNewBlock(),  
                                    gstream header corrupted*/


#define AD12_LOC_160   0x8000A0  /* AD12:.c:(),  */


#define AD12_LOC_161   0x8000A1  /* AD12:.c:(),  */


#define AD12_LOC_162   0x8000A2  /* AD12:.c:(),  */


#define AD12_LOC_163   0x8000A3  /* AD12:.c:(),  */


#define AD12_LOC_164   0x8000A4  /* AD12:.c:(),  */


#define AD12_LOC_165   0x8000A5  /* AD12:.c:(),  */


#define AD12_LOC_166   0x8000A6  /* AD12:.c:(),  */


#define AD12_LOC_167   0x8000A7  /* AD12:.c:(),  */


#define AD12_LOC_168   0x8000A8  /* AD12:.c:(),  */


#define AD12_LOC_169   0x8000A9  /* AD12:.c:(),  */


#define AD12_LOC_170   0x8000AA  /* AD12:.c:(),  */


#define AD12_LOC_171   0x8000AB  /* AD12:.c:(),  */


#define AD12_LOC_172   0x8000AC  /* AD12:.c:(),  */


#define AD12_LOC_173   0x8000AD  /* AD12:.c:(),  */


#define AD12_LOC_174   0x8000AE  /* AD12:.c:(),  */


#define AD12_LOC_175   0x8000AF  /* AD12:.c:(),  */


#define AD12_LOC_176   0x8000B0  /* AD12:.c:(),  */


#define AD12_LOC_177   0x8000B1  /* AD12:.c:(),  */


#define AD12_LOC_178   0x8000B2  /* AD12:.c:(),  */


#define AD12_LOC_179   0x8000B3  /* AD12:.c:(),  */


#define AD12_LOC_180   0x8000B4  /* AD12:.c:(),  */


#define AD12_LOC_181   0x8000B5  /* AD12:.c:(),  */


#define AD12_LOC_182   0x8000B6  /* AD12:.c:(),  */


#define AD12_LOC_183   0x8000B7  /* AD12:.c:(),  */


#define AD12_LOC_184   0x8000B8  /* AD12:.c:(),  */


#define AD12_LOC_185   0x8000B9  /* AD12:.c:(),  */


#define AD12_LOC_186   0x8000BA  /* AD12:.c:(),  */


#define AD12_LOC_187   0x8000BB  /* AD12:.c:(),  */


#define AD12_LOC_188   0x8000BC  /* AD12:.c:(),  */


#define AD12_LOC_189   0x8000BD  /* AD12:.c:(),  */


#define AD12_LOC_190   0x8000BE  /* AD12:.c:(),  */


#define AD12_LOC_191   0x8000BF  /* AD12:.c:(),  */


#define AD12_LOC_192   0x8000C0  /* AD12:.c:(),  */


#define AD12_LOC_193   0x8000C1  /* AD12:.c:(),  */


#define AD12_LOC_194   0x8000C2  /* AD12:.c:(),  */


#define AD12_LOC_195   0x8000C3  /* AD12:.c:(),  */


#define AD12_LOC_196   0x8000C4  /* AD12:.c:(),  */


#define AD12_LOC_197   0x8000C5  /* AD12:.c:(),  */


#define AD12_LOC_198   0x8000C6  /* AD12:.c:(),  */


#define AD12_LOC_199   0x8000C7  /* AD12:.c:(),  */


#define AD12_LOC_200   0x8000C8  /* AD12:.c:(),  */


#define AD12_LOC_201   0x8000C9  /* AD12:.c:(),  */


#define AD12_LOC_202   0x8000CA  /* AD12:.c:(),  */


#define AD12_LOC_203   0x8000CB  /* AD12:.c:(),  */


#define AD12_LOC_204   0x8000CC  /* AD12:.c:(),  */


#define AD12_LOC_205   0x8000CD  /* AD12:.c:(),  */


#define AD12_LOC_206   0x8000CE  /* AD12:.c:(),  */


#define AD12_LOC_207   0x8000CF  /* AD12:.c:(),  */


#define AD12_LOC_208   0x8000D0  /* AD12:.c:(),  */


#define AD12_LOC_209   0x8000D1  /* AD12:.c:(),  */


#define AD12_LOC_210   0x8000D2  /* AD12:.c:(),  */


#define AD12_LOC_211   0x8000D3  /* AD12:.c:(),  */


#define AD12_LOC_212   0x8000D4  /* AD12:.c:(),  */


#define AD12_LOC_213   0x8000D5  /* AD12:.c:(),  */


#define AD12_LOC_214   0x8000D6  /* AD12:.c:(),  */


#define AD12_LOC_215   0x8000D7  /* AD12:.c:(),  */


#define AD12_LOC_216   0x8000D8  /* AD12:.c:(),  */


#define AD12_LOC_217   0x8000D9  /* AD12:.c:(),  */


#define AD12_LOC_218   0x8000DA  /* AD12:.c:(),  */


#define AD12_LOC_219   0x8000DB  /* AD12:.c:(),  */


#define AD12_LOC_220   0x8000DC  /* AD12:.c:(),  */


#define AD12_LOC_221   0x8000DD  /* AD12:.c:(),  */


#define AD12_LOC_222   0x8000DE  /* AD12:.c:(),  */


#define AD12_LOC_223   0x8000DF  /* AD12:.c:(),  */


#define AD12_LOC_224   0x8000E0  /* AD12:.c:(),  */


#define AD12_LOC_225   0x8000E1  /* AD12:.c:(),  */


#define AD12_LOC_226   0x8000E2  /* AD12:.c:(),  */


#define AD12_LOC_227   0x8000E3  /* AD12:.c:(),  */


#define AD12_LOC_228   0x8000E4  /* AD12:.c:(),  */


#define AD12_LOC_229   0x8000E5  /* AD12:.c:(),  */


#define AD12_LOC_230   0x8000E6  /* AD12:.c:(),  */


#define AD12_LOC_231   0x8000E7  /* AD12:.c:(),  */


#define AD12_LOC_232   0x8000E8  /* AD12:.c:(),  */


#define AD12_LOC_233   0x8000E9  /* AD12:.c:(),  */


#define AD12_LOC_234   0x8000EA  /* AD12:.c:(),  */


#define AD12_LOC_235   0x8000EB  /* AD12:.c:(),  */


#define AD12_LOC_236   0x8000EC  /* AD12:.c:(),  */


#define AD12_LOC_237   0x8000ED  /* AD12:.c:(),  */


#define AD12_LOC_238   0x8000EE  /* AD12:.c:(),  */


#define AD12_LOC_239   0x8000EF  /* AD12:.c:(),  */


#define AD12_LOC_240   0x8000F0  /* AD12:.c:(),  */


#define AD12_LOC_241   0x8000F1  /* AD12:.c:(),  */


#define AD12_LOC_242   0x8000F2  /* AD12:.c:(),  */


#define AD12_LOC_243   0x8000F3  /* AD12:.c:(),  */


#define AD12_LOC_244   0x8000F4  /* AD12:.c:(),  */


#define AD12_LOC_245   0x8000F5  /* AD12:.c:(),  */


#define AD12_LOC_246   0x8000F6  /* AD12:.c:(),  */


#define AD12_LOC_247   0x8000F7  /* AD12:.c:(),  */


#define AD12_LOC_248   0x8000F8  /* AD12:.c:(),  */


#define AD12_LOC_249   0x8000F9  /* AD12:.c:(),  */


#define AD12_LOC_250   0x8000FA  /* AD12:.c:(),  */


#define AD12_LOC_251   0x8000FB  /* AD12:.c:(),  */


#define AD12_LOC_252   0x8000FC  /* AD12:.c:(),  */


#define AD12_LOC_253   0x8000FD  /* AD12:.c:(),  */


#define AD12_LOC_254   0x8000FE  /* AD12:.c:(),  */


#define AD12_LOC_255   0x8000FF  /* AD12:.c:(),  */



#endif
