/*
    Copyright (C) 2000-2003.  Intel Corporation.

    All Rights Reserved.  All names, products,
    and services mentioned herein are the trademarks
    or registered trademarks of their respective organizations
    and are the sole property of their respective owners.
 */

/*
*    AUTO-VERSIONING HEADER  DO NOT HAND MODIFY
*    ===================================================================
*    %name:          CCTDomain.h %
*    %version:       29 %
*    %instance:      hsw_1 %
*    %created_by:    klotzw %
*    %date_modified: Thu Apr 17 22:56:52 2003 %
*    ===================================================================
*/

#ifndef __CCTDOMAIN_H__
#define __CCTDOMAIN_H__

#ifndef lint
static const char    *_hsw_1_CCTDomain_h = "@(#) %filespec: CCTDomain.h-29 %  (%full_filespec: CCTDomain.h-29:incl:hsw#1 %)";
#endif

#include <string>

#include "dlgctypes.h"

#include "DlgDasiClientLib.h"
#include "ICTNode.h"

#include "CCTDasiException.h"

namespace DASI
{
    // Forward declaration of CDBConnection class.
    class CDBConnection;

    /**
     * The CCTDomain class is the entry point to the OA&M system.
     * All commands to the OA&M system begin with the application instantiation
     * of the CCTDomain class.  An application must instantiate a separate
     * CCTDomain instance for each domain being managed.
     *
     * A domain configuration can consist of the following:
     *
     *    - A relationship of 1 domain to 1 node.  Assumes each node is
     *      completely standalone an does not interact with other nodes.
     *      Each node has it's own naming service running.
     *
     *    - A relationship of 1 domain to many nodes.  Assumes one node has been
     *      configured to have the naming service running and all other nodes
     *      within the domain use this node to find the OA&M services they depend
     *      on for operation.
     *
     * @exception CCTDasiException
     *
     * @version 1.0
     * @since 1.0
     * @stereotype implementationClass
     */
    class DLGDASICLIENT_API CCTDomain
    {
    public:

        /**
         * The CCTDomain constructor initializes the administrative framework reading it
         * for administrative operations.  The constructor takes care of the complex work
         * of establishing connections with the administrative servers within the current
         * node or distributed accross the network.  The constructor parameter have been
         * setup to default to local node operatoin.  An application that is only interested
         * in managing the node they are running their application on need not specify any
         * parameters.
         *
         * @param szNameServerIP a constant std::string& : Naming Service IP Address or Machine Name.
         *                                                 Default = 127.0.0.1
         * @param lNameServerPortNumber a constant long  : Naming Service Port Address between 0 - 65535
         *                                                 Default = 0
         *
         * @exception CCTDasiException
         *
         * @version 1.0
         * @since 1.0
         */

        CCTDomain(const std::string szNameServerIP="127.0.0.1", 
                  const long lNameServerPortNumber = 0);


        /**
         * The CCTDomain destructor releases the resources the object has aquired
         * during it's operational lifecycle.
         *
         * @version 1.0
         * @since 1.0
         */

        virtual ~CCTDomain();


        /**
         * Retrieves the local machine IP Address.
         *
         * @return string: IP Address of local machine.
         *
         * @exception CCTDasiException
         *
         * @version 1.0
         * @since 1.0
         */
        const std::string GetLocalNodeIPAddress() throw(CCTDasiException);


        /**
         * Retrieves the node specified by the calling application based on
         * the IP Address of the node.  An application can pass a value of
         * 127.0.0.1 to obtain the local node if they wish.  The application
         * could also specify the local node or any other node's IP address
         * within the domain to retrieve an instaniated object of type ICTNode.
         *
         * @return ICTNODE : A smart pointer to a ICTNode interface object.
         *
         * @exception CCTDasiException
         *
         * @version 1.0
         * @since 1.0
         * @param rszNodeIP a reference to a constant string : Contains the Node IP Address.
         */

        ICTNode* GetNode(/*in*/ const std::string& rszNodeIP) throw(CCTDasiException);


        /**
         * Retrieves from the data store all the currently known nodes within
         * the domain.  The calling application will be returned fully
         * instanitated ICTNode object contained in an stl list container.
         *
         * @return ICTNODELIST : An std::list<ICTNODE> of ICTNode smart pointers.
         *
         * @exception CCTDasiException
         *
         * @version 1.0
         * @since 1.0
         */

        ICTNODELIST* GetAllNodes() throw(CCTDasiException);


        /**
         * An application would call this function to obtain information with
         * respect to DASI's configuration for committing data to the data store.
         * By default DASI commits data immediately to the data store.
         *
         * @return bool : True indicates data is committed immediately.
         *                False indicates data is only committed if the application
         *                calls the Save interface.
         * @exception CCTDasiException
         *
         * @version 1.0
         * @since 1.0
         */

        bool GetCommitImmediately() throw( CCTDasiException );


        /**
         * An application would call this function to obtain information with
         * respect to DASI's configuration for retrieving data from the data store.
         * By default DASI retrieves data immediately to the data store.
         *
         * @return bool : True indicates data is retrieve immediately.
         *                False indicates data is only retrieved if the application
         *                calls the Retreive interface.
         * @exception CCTDasiException
         *
         * @version 1.0
         * @since 1.0
         */

        bool GetRetrieveImmediately() throw( CCTDasiException );


        /**
         * An application would call this function to change DASI's
         * configuration for committing data to the data store.
         * By default DASI commits data immediately to the data store, but can
         * be configurationed to require the application to call the Save interface
         * on the object to commit the data.
         *
         * @param bCommitImmediately is a bool : True indicates data is committed immediately.
         *                False indicates data is only committed if the application
         *                calls the Save interface.
         * @exception CCTDasiException
         *
         * @version 1.0
         * @since 1.0
         */

        void SetCommitImmediately(/*in*/ bool bCommitImmediately) throw( CCTDasiException );


        /**
         * An application would call this function to change DASI's
         * configuration for retrieving data from the data store.
         * By default DASI retrieves data immediately to the data store.
         *
         * @param bRetrieveImmediately is a bool : True indicates data is retrieve immediately.
         *                False indicates data is only retrieved if the application
         *                calls the Retreive interface.
         * @exception CCTDasiException
         *
         * @version 1.0
         * @since 1.0
         */

        void SetRetrieveImmediately(/*in*/ bool bRetrieveImmediately) throw( CCTDasiException );


    private:

        /**
         * Not implemented but declared private so applications can not
         * accidentally use the copy constructor.
         *
         * @param rhs a reference to a CCTDomain& : CCTDomain object to copy
         *
         * @exception CCTDasiException
         *
         * @version 1.0
         * @since 1.0
         */

        CCTDomain(/*in*/ CCTDomain& rhs);


        /**
         * Not implemented but declared private so applications can not
         * accidentally use the assignment operator.
         *
         * @param rhs a reference to a CCTDomain& : CCTDomain object to copy
         *
         * @return A reference to a CCTDomain object.
         *
         * @exception CCTDasiException
         *
         * @version 1.0
         * @since 1.0
         */

        CCTDomain & operator = (/*in*/ const CCTDomain& rhs);

        /**
         * Pointer to the CCBDConnection class which handles connecting to
         * the different servers that makeup the OA&M system.  An application
         * will never be required to know about or use this pointer.
         * @since 1.0
         */
        CDBConnection * m_plnkCDBConnection;

        /**
         * Represents a flag which indicates whether data with respect to the
         * board classes is committed immediately to the data store.  By
         * default this flag is enabled which means commit to the data store
         * immediately.
         *
         * Valid values are true or false.
         * @since 1.0
         */
        bool            m_bCommitImmediately;

        /**
         * Represents a flag which indicates whether data with respect to the
         * board classes is retrieved directly from the data store or from
         * cached data.  By default this flag is enabled which means retrieves
         * data from the data store at all times.
         *
         * Valid values are true or false.
         */
        bool            m_bRetrieveImmediately;

        /** @link dependency
         * @stereotype instantiate*/
        /*#  ICTNode lnkICTNode; */
    };
}
#endif //CCTDOMAIN_H
