/****************************************************************************
 *		Copyright (c) 1995 Dialogic Corp.
 *		All Rights Reserved.
 *
 *		THIS IS UNPUBLISHED PROPRIETARY SOURCE CODE OF Dialogic Corp.
 *		The copyright notice above does not evidence any actual or
 *		intended publication of such source code.
 ***************************************************************************/

/****************************************************************************
 * FILE:         FePlocs.h
 * AUTHOR:       Rosebud Alexander
 * ORG:          Dialogic Corporation
 * ORIG-DATE:    21-Sep-00 at 13:38:43
 * LAST-MOD:     11-Nov-02 at 16:12:35 by Art Elwell
 * PURPOSE:
 *    This module contains the error code definitions for the FeP Resource.
 *
 * HISTORY:
 * Date			Who	Description
 * 21-Sep-00     RA	Initial Version
 * 30-Oct-00     MN  Added FEP_LOC_096 error for FEP_MsgStopped_put in FePinst.c
 * 05-Dec-00     MN  Changed FEP_LOC_062, FEP_LOC_063 error body word from 
 *                   fepSendStartMsg to fepInstTask for FEP ROC compatibility
 *                   fix.  Added FEP_LOC_98, FEP_LOC_99, FEP_LOC_100,
 *                   FEP_LOC_100 for fepSendReferenceActiveMsg and 
 *                   fepSendReferenceInactiveMsg. Changed FEP_LOC_064 to fepInstTask.
 * 21-Feb-01     MN  Added FEP_LOC_148 and FEP_LOC_149 for DCF from kernel
 *                   addition Task #7013.
 * 29-May-01     RA  Task 8616,Added FEP_LOC_252 to FEP_LOC_255 for DTMF
 *                   detection feature.
 * 04-Jun-01     MN  Task 8829: Added FEP_LOC_256 and FEP_LOC_257 for function
 *                   fepDetermineModel addition for cluster determination. 
 * 25-Jun-01     MN  Task 8829 Also Added FEP_LOC_258 though FEP_LOC_263 for
 *                   RTC Stop Buffering.
 * 12-Nov-01     MN  Task 10893 MAX_TIME:  Added FEP_LOC_264, FEP_LOC_265,
 *                   FEP_LOC_266, FEP_LOC_267, FEP_LOC_268, FEP_LOC_269,
 *                   FEP_LOC_270, FEP_LOC_271, FEP_LOC_272, FEP_LOC_273.
 * 14-Feb-02     BC  Task 12464: Added FEP_LOC_266 and FEP_LOC_267 for Luna.
***************************************************************************/
#if !defined(_FePlocs_h)
#define _FePlocs_h 1

/*#if !defined(_fepLocations_h)
#define _FepLocations_h 1*/
  
#include "qmiscapi.h"

/* 
 * Fep wrappers for qError( ) calls
 */
extern char *fepLocationsFileName;
void fepErrKillTask ( Uint24 errTag );
void fepErrInstKillTask ( Uint24 errTag, QCompDesc *pDesc );
void fepErrArgsKillTask ( Uint24 errTag, QCompDesc *pDesc,  
                          int arg1, int arg2, int arg3, int arg4 );
void fepErrWarning ( Uint24 errTag );
void fepErrInstWarning ( Uint24 errTag, QCompDesc *pDesc );
void fepErrArgsWarning ( Uint24 errTag, QCompDesc *pDesc,  
                         int arg1, int arg2, int arg3, int arg4 );
void fepErrAdvisory ( Uint24 errTag );
void fepErrInstAdvisory ( Uint24 errTag, QCompDesc *pDesc );
void fepErrArgsAdvisory ( Uint24 errTag, QCompDesc *pDesc,  
                          int arg1, int arg2, int arg3, int arg4 );

#if !defined(_FEP_COMP_C__)
extern char *fepLocationsFileName;
#else
char *fepLocationsFileName = "FePlocs.h";

/******************************************************************************
 *       NAME : fepErrKillTask
 *DESCRIPTION : processes errors by calling qError( ) w/ severity QERR_KILLTASK.
 *      INPUT : errTag - unique location of the error
 *     OUTPUT : None
 *    RETURNS : None
 *   CAUTIONS : None
 *****************************************************************************/
void fepErrKillTask ( Uint24 errTag )
{
   qError (QERR_KILLTASK, errTag, fepLocationsFileName);
}

/******************************************************************************
 *       NAME : fepErrInstKillTask
 *DESCRIPTION : processes errors by calling qErrorInst( ) w/ severity QERR_KILLTASK.
 *      INPUT : errTag - unique location of the error
 *            : pDesc - pointer to component desc of instance which caused error.
 *     OUTPUT : None
 *    RETURNS : None
 *   CAUTIONS : None
 *****************************************************************************/
void fepErrInstKillTask ( Uint24 errTag, QCompDesc *pDesc )
{
   qErrorInst (QERR_KILLTASK, errTag, fepLocationsFileName, pDesc);
}

/******************************************************************************
 *       NAME : fepErrArgsKillTask
 *DESCRIPTION : processes errors by calling qErrorArgs( ) w/ severity QERR_KILLTASK.
 *      INPUT : errTag - unique location of the error
 *            : pDesc - pointer to component desc of instance which caused error.
 *            : arg1, arg2, arg3, arg4 - 4 user arguments for further error identification. 
 *     OUTPUT : None
 *    RETURNS : None
 *   CAUTIONS : None
 *****************************************************************************/
void fepErrArgsKillTask ( Uint24 errTag, QCompDesc *pDesc,  
                          int arg1, int arg2, int arg3, int arg4 )
{
   int count=4;
   qErrorArgs (QERR_KILLTASK, errTag, fepLocationsFileName, pDesc, count, arg1, arg2, arg3, arg4 );
}

/******************************************************************************
 *       NAME : fepErrWarning
 *DESCRIPTION : processes errors by calling qError( ) w/ severity QERR_WARNING.
 *      INPUT : errTag - unique location of the error
 *     OUTPUT : None
 *    RETURNS : None
 *   CAUTIONS : None
 *****************************************************************************/
void fepErrWarning ( Uint24 errTag )
{
   qError (QERR_WARNING, errTag, fepLocationsFileName);
}

/******************************************************************************
 *       NAME : fepErrInstWarning
 *DESCRIPTION : processes errors by calling qErrorInst( ) w/ severity QERR_WARNING.
 *      INPUT : errTag - unique location of the error
 *            : pDesc - pointer to component desc of instance which caused error.
 *     OUTPUT : None
 *    RETURNS : None
 *   CAUTIONS : None
 *****************************************************************************/
void fepErrInstWarning ( Uint24 errTag, QCompDesc *pDesc )
{
   qErrorInst (QERR_WARNING, errTag, fepLocationsFileName, pDesc);
}

/******************************************************************************
 *       NAME : fepErrArgsWarning
 *DESCRIPTION : processes errors by calling qErrorArgs( ) w/ severity QERR_WARNING.
 *      INPUT : errTag - unique location of the error
 *            : pDesc - pointer to component desc of instance which caused error.
 *            : arg1, arg2, arg3, arg4 - 4 user arguments for further error identification. 
 *     OUTPUT : None
 *    RETURNS : None
 *   CAUTIONS : None
 *****************************************************************************/
void fepErrArgsWarning ( Uint24 errTag, QCompDesc *pDesc,  
                         int arg1, int arg2, int arg3, int arg4 )
{
   qErrorArgs (QERR_WARNING, errTag, fepLocationsFileName, pDesc, arg1, arg2, arg3, arg4 );
}

/******************************************************************************
 *       NAME : fepErrAdvisory
 *DESCRIPTION : processes errors by calling qError( ) w/ severity QERR_ADVISORY.
 *      INPUT : errTag - unique location of the error
 *     OUTPUT : None
 *    RETURNS : None
 *   CAUTIONS : None
 *****************************************************************************/
void fepErrAdvisory ( Uint24 errTag )
{
   qError (QERR_ADVISORY, errTag, fepLocationsFileName);
}

/******************************************************************************
 *       NAME : fepErrInstAdvisory
 *DESCRIPTION : processes errors by calling qErrorInst( ) w/ severity QERR_ADVISORY.
 *      INPUT : errTag - unique location of the error
 *            : pDesc - pointer to component desc of instance which caused error.
 *     OUTPUT : None
 *    RETURNS : None
 *   CAUTIONS : None
 *****************************************************************************/
void fepErrInstAdvisory ( Uint24 errTag, QCompDesc *pDesc )
{
   qErrorInst (QERR_ADVISORY, errTag, fepLocationsFileName, pDesc);
}

/******************************************************************************
 *       NAME : fepErrArgsAdvisory
 *DESCRIPTION : processes errors by calling qErrorArgs( ) w/ severity QERR_ADVISORY.
 *      INPUT : errTag - unique location of the error
 *            : pDesc - pointer to component desc of instance which caused error.
 *            : arg1, arg2, arg3, arg4 - 4 user arguments for further error identification. 
 *     OUTPUT : None
 *    RETURNS : None
 *   CAUTIONS : None
 *****************************************************************************/
void fepErrArgsAdvisory ( Uint24 errTag, QCompDesc *pDesc,  
                          int arg1, int arg2, int arg3, int arg4 )
{
   qErrorArgs (QERR_ADVISORY, errTag, fepLocationsFileName, pDesc, arg1, arg2, arg3, arg4 );
}

#endif

#define FEP_LOC_000	0x800000 /* FEP:.c:(),
                               */

#define FEP_LOC_001	0x800001 /* FEP:FePcomp.c:fepCompError(),
                                 unable to allocate msg Std_MsgError
                                 qMsgAllocate FAILURE */

#define FEP_LOC_002	0x800002 /* FEP:FePcomp.c:fepCompError(),
                                 Std_MsgError_put FAILURE */ 

#define FEP_LOC_003	0x800003 /* FEP:FePcomp.c:fepCompError(),
                                 unable to send msg Std_MsgError, qMsgWrite FAILURE */

#define FEP_LOC_004	0x800004 /* FEP:FePcomp.c:fepMsgInit(),
                                 fep instance not in FEPCOMP_WAITINIT MainState  */

#define FEP_LOC_005	0x800005 /* FEP:FePcomp.c:fepMsgInit(),
                                 fep component not in FEPCOMP_INIT MainState  */

#define FEP_LOC_006	0x800006 /* FEP:FePcomp.c:fepMsgInit(),
                                 unable to allocate instances   */

#define FEP_LOC_007	0x800007 /* FEP:FePcomp.c:fepMsgInit(),
                                 qCompInstanceRegister FAILURE */

#define FEP_LOC_008	0x800008 /* FEP:FePcomp.c:fepMsgInit(),
                                 unable to allocate msg Std_MsgInit qMsgAllocate FAILURE */

#define FEP_LOC_009	0x800009 /* FEP:FePcomp.c:fepMsgInit(),
                                 unable to send msg Std_MsgInit, qMsgWrite FAIURE */

#define FEP_LOC_010	0x800010 /* FEP:FePcomp.c:fepMsgInitCmplt(),
                                 fep not in  FEPCOMP_WAITINIT MainState */

#define FEP_LOC_011	0x800011 /* FEP:FePcomp.c:fepMsgInitCmplt(),
                                 invalid number of InitCmplt messages  */

#define FEP_LOC_012	0x800012 /* FEP:FePcomp.c:fepMsgGetParm(),
                                 Std_MsgGetParm_get FAILURE */

#define FEP_LOC_013	0x800013 /* FEP:FePcomp.c:fepMsgGetParm(),
                                 unable to allocate msg Std_MsgGetParmCmplt, qMsgAllocate FAILURE */

#define FEP_LOC_014	0x800014 /* FEP:FePcomp.c:fepMsgGetParm(),
                                 unable to send msg Std_MsgGetParmCmplt,
                                 qMsgWrite FAILURE */

#define FEP_LOC_015	0x800015 /* FEP:FePcomp.c:fepMsgSetParm(),
                                 Std_MsgSetParm_get FAILURE */

#define FEP_LOC_016	0x800016 /* FEP:FePcomp.c:fepMsgSetParm(),
                                 unablet to allocate msg
                                 Std_MsgSetParmCmplt, qMsgAllocate FAILURE */

#define FEP_LOC_017	0x800017 /* FEP:FePcomp.c:fepMsgSetParm(),
                                 Unable to send msg Std_MsgSetParmCmplt, 
                                 qMsgWrite FAILURE */

#define FEP_LOC_018	0x800018 /* FEP:FePcomp.c:fepCompTask(),
                                 qTaskCompSelf FAILURE*/

#define FEP_LOC_019	0x800019 /* FEP:FePcomp.c:fepCompTask(), 
                                 qCompRegister FAILURE   */
				  
#define FEP_LOC_020	0x800020 /* FEP:FePcomp.c:fepCompTask(), 
                                 unable to free msg QMSG_RANGE_STD, qMsgFree FAILURE  */   

#define FEP_LOC_021	0x800021 /* FEP:FePcomp.c:fepCompTask(),
                                 unable to free msg QMSG_RANGE_QKERNEL, qMsgFree FAILURE */

#define FEP_LOC_022	0x800022 /* FEP:FePcomp.c:fepCompTask(),
                                 unable to free msg FEPCOMP_IDLE, qMsgFree FAILURE */  

#define FEP_LOC_023	0x800023 /* FEP:FePcomp.c:fepCompTask(),
                                 FEP component in an unknown state  */

#define FEP_LOC_024	0x800024 /* FEP:FePinst.c:feperror(),
                                 unable to allocate msg Std_MsgError ,qMsgAllocate  FAILURE */

#define FEP_LOC_025	0x800025 /* FEP:FePinst.c:feperror(),
                                 Std_MsgError_put  FAILURE */

#define FEP_LOC_026	0x800026 /*  FEP:FePinst.c:fepConvergedMsgHdlr(),
                                  unable to send msg Std_MsgError,qMsgWrite FAILURE */

#define FEP_LOC_027	0x800027 /* FEP:FePinst.c:fepConvergedMsgHdlr(),
                                 unable to allocate msg Std_MsgEvtDetected, qMsgAllocate  FAILURE  */

#define FEP_LOC_028	0x800028 /* FEP:FePinst.c:fepConvergedMsgHdlr(),
                                 Std_MsgEvtDetected_put FAILURE */ 

#define FEP_LOC_029	0x800029 /* FEP:FePinst.c:fepConvergedMsgHdlr(),
                                 unable to write msg  Std_MsgEvtDetected,
                                 qMsgWrite FAILURE */

#define FEP_LOC_030	0x800030 /* FEP:FePinst.c:fepConvergedMsgHdlr(),
                                 unable to allocate msg Std_MsgEvtDetected, qMsgAllocate   FAILURE */

#define FEP_LOC_031	0x800031 /* FEP:FePinst.c:fepConvergedMsgHdlr(),
                                 unable to free  msg Std_MsgEvtDetected,qMsgFree FAILURE */

#define FEP_LOC_032	0x800032 /* FEP:FePinst.c:fepVADDetectedMsgHdlr(),
                                 unable to allocate msg Std_MsgEvtDetected, qMsgAllocate  FAILURE */ 

#define FEP_LOC_033	0x800033 /* FEP:FePinst.c:fepVADDetectedMsgHdlr(), 
                                 Std_MsgEvtDetected_put FAILURE */ 

#define FEP_LOC_034	0x800034 /* FEP:FePinst.c:fepVADDetectedMsgHdlr(), 
                                 unable to write msg  Std_MsgEvtDetected,
                                 qMsgWrite FAILURE */

#define FEP_LOC_035	0x800035 /* FEP:FePinst.c:fepVADDetectedMsgHdlr(),  
                                 unable to allocate msg Std_MsgEvtDetected, qMsgAllocate FAILURE */

#define FEP_LOC_036	0x800036 /* FEP:FePinst.c:fepVADDetectedMsgHdlr(),  
                                 unable to free  msg Std_MsgEvtDetected,qMsgFree  */

#define FEP_LOC_037	0x800037 /* FEP:FePinst.c:fepSetParmMsgHdlr(),
                                 Std_MsgSetParm_get FAILURE*/

#define FEP_LOC_038	0x800038 /* FEP:FePinst.c:fepSetParmMsgHdlr(),
                                 unable to allocate msg Std_MsgSetParm, qMsgAllocate FAILURE*/

#define FEP_LOC_039	0x800039 /* FEP:FePinst.c:fepSetParmMsgHdlr(),
                                 unable to write msg Std_MsgSetParm,
                                 qMsgWrite FAILURE */

#define FEP_LOC_040	0x800040 /* FEP:FePinst.c:fepSetParmMsgHdlr(),
                                 unable to allocate msg Std_MsgSetParmCmplt, qMsgAllocate FAILURE */

#define FEP_LOC_041	0x800041 /* FEP:FePinst.c:fepSetParmMsgHdlr(),
                                 unable to write msg Std_MsgSetParmCmplt,
                                 qMsgWrite FAILURE*/

#define FEP_LOC_042	0x800042 /* FEP:FePinst.c:fepSetParmMsgHdlr(),
                                 invalid msg type*/

#define FEP_LOC_043	0x800043 /* FEP:FePinst.c:fepGetParmMsgHdlr(),
                                 Std_MsgGetParm_get FAILURE */

#define FEP_LOC_044	0x800044 /* FEP:FePinst.c:fepGetParmMsgHdlr(),
                                 unable to allocate msg Std_MsgGetParmCmplt, qMsgAllocate FAILURE */

#define FEP_LOC_045	0x800045 /* FEP:FePinst.c:fepGetParmMsgHdlr(),
                                 unable to write msg Std_MsgGetParmCmplt,
                                 qMsgWrite FAILURE */

#define FEP_LOC_046	0x800046 /* FEP:FePinst.c:fepDetectEvtMsgHdlr(),
                                 Std_MsgDetectEvt_get FAILURE */

#define FEP_LOC_047	0x800047 /* FEP:FePinst.c:fepDetectEvtMsgHdlr(),
                                 unable to allocate msg Std_MsgDetectEvtCmplt, qMsgAllocate FAILURE*/

#define FEP_LOC_048	0x800048 /* FEP:FePinst.c:fepDetectEvtMsgHdlr(),
                                 unable to write msg Std_MsgDetectEvtCmplt,
                                 qMsgWrite FAILURE */

#define FEP_LOC_049	0x800049 /* FEP:FePinst.c:fepCancelEvtMsgHdlr(),
                                 Std_MsgCancelEvt_get  FAILURE*/

#define FEP_LOC_050	0x800050 /* FEP:FePinst.c:fepCancelEvtMsgHdlr(),
                                 unable to allocate msg Std_MsgCancelEvtCmplt,qMsgAllocate FAILURE */
				    

#define FEP_LOC_051	0x800051 /* FEP:FePinst.c:fepCancelEvtMsgHdlr(),
                                 unable to write msg Std_MsgCancelEvtCmplt, qMsgWrite  FAILURE*/
				    

#define FEP_LOC_052	0x800052 /* FEP:FePinst.c:fepInitMsgHdlr(),
                                 invalid MainState in Std_MsgInit */
				    

#define FEP_LOC_053	0x800053 /* FEP:FePinst.c:fepInitMsgHdlr(),
                                 unable to allocate msg Std_MsgInitCmplt,qMsgAllocate  */

#define FEP_LOC_054	0x800054 /* FEP:FePinst.c:fepInitMsgHdlr(),
                                 unable to write msg Std_MsgInitCmplt, qMsgWrite FAILURE*/

#define FEP_LOC_055	0x800055 /* FEP:FePinst.c:fepInitMsgHdlr(),
                                 unexpected state */
				    

#define FEP_LOC_056	0x800056 /* FEP:FePinst.c:fepSendEventDetectedMsg(),
                                 unable to allocate msg Std_MsgEvtDetected, qMsgAllocate FAILURE */

#define FEP_LOC_057	0x800057 /* FEP:FePinst.c:fepSendEventDetectedMsg(), 
                                 unable to write msg Std_MsgEvtDetected, qMsgWriteFAILURE */

#define FEP_LOC_058	0x800058 /* FEP:FePinst.c:fepSentStartMsg(),
                                 qCompAllocate FAILURE*/

#define FEP_LOC_059	0x800059 /* FEP:FePinst.c:fepSentStartMsg(),
                                 FEP_MsgStart_get FAILURE */

#define FEP_LOC_060	0x800060 /* FEP:FePinst.c:fepSentStartMsg(),
                                 qClusterActivate FAILURE*/

#define FEP_LOC_061	0x800061 /* FEP:FePinst.c:fepSentStartMsg(),
                                 qClusterSlotInfo  FAILURE */

#define FEP_LOC_062	0x800062 /* FEP:FePinst.c:fepInstTask(),
                                 qClusterSlotInfo FAILURE,
                                 when setting up the input (Signal + Echo, the far end) stream ID */

#define FEP_LOC_063	0x800063 /* FEP:FePinst.c:fepInstTask(),
                                 qClusterByComp FAILURE,
                                 when setting up the input (Signal + Echo, the far end) stream ID*/

#define FEP_LOC_064	0x800064 /* FEP:FePinst.c:fepInstTask(), failure to get
                                 Ri2 port information,  qClusterSlotInfo FAILURE */
				    
#define FEP_LOC_065	0x800065 /* FEP:FePinst.c:fepSentStartMsg(),
                                 unable to allocate FES_MsgStart,qMsgAllocate FAILURE */
				    

#define FEP_LOC_066	0x800066 /* FEP:FePinst.c:fepSentStartMsg(), 
                                 unable to send msg
                                 FES_MsgStart,qMsgWrite FAILURE*/

#define FEP_LOC_067	0x800067 /* FEP:FePinst.c:fepSentResetMsg(), 
                                 unable to allocate FES_MsgReset,qMsgAllocate FAILURE*/


#define FEP_LOC_068	0x800068 /* FEP:FePinst.c:fepSentResetMsg(), 
                                 unable to send FES_MsgReset,qMsgWrite FAILURE*/

#define FEP_LOC_069	0x800069 /* FEP:FePinst.c:fepSentStopMsg(),
                                 unable to allocate FES_MsgStop,qMsgAllocate FAILURE */
				    

#define FEP_LOC_070	0x800070 /* FEP:FePinst.c:fepSentStopMsg(),
                                 unable to send msg FES_MsgStop,qMsgWrite FAILURE  */

#define FEP_LOC_071	0x800071 /* FEP:FePinst.c:fepSentPauseMsg(),
                                 unable to allocate msg FES_MsgPauseStreaming ,qMsgAllocate FAILURE*/
				    

#define FEP_LOC_072	0x800072 /* FEP:FePinst.c:fepSentPauseMsg(),
                                 unable to send msg FES_MsgPauseStreaming, qMsgWrite FAILURE  */

#define FEP_LOC_073	0x800073 /* FEP:FePinst.c:fepSentPauseMsg(),
                                 unable to allocate msg FES_MsgVadDetected ,qMsgAllocate FAILURE   */

#define FEP_LOC_074	0x800074 /* FEP:FePinst.c:fepSentPauseMsg(),
                                 unable to send msg FES_MsgVadDetected, qMsgWrite FAILURE */

#define FEP_LOC_075	0x800075 /* FEP:FePinst.c:fepInstTask(),
                                 invalid state in QClusterActive  */

#define FEP_LOC_076	0x800076 /* FEP:FePinst.c:fepInstTask(),
                                 invalid state in QClusterActive */

#define FEP_LOC_077	0x800077 /* FEP: FePinst.c:fepInstTask(),
                                 invalid state in QClusterInactive */

#define FEP_LOC_078	0x800078 /* FEP:FePinst.c:fepInstTask(),
                                 FEPINST received QResultError in
                                 FEPINST_WAITINIT state->couldn't find FeS instance */

#define FEP_LOC_079	0x800079 /* FEP:FePinst.c:fepInstTask(),
                                 host connection broken going to MainState,
                                 recd. QHostExited */


#define FEP_LOC_080	0x800080 /* FEP:FePinst.c:fepInstTask(),
                                 invalid MainState FEPINST_DEATHEXIT, in Std_MsgError */

#define FEP_LOC_081	0x800081 /* FEP:FePinst.c:fepInstTask(),
                                 unable to allocate msg
                                 FEP_MsgPauseStreamCmplt, qMsgAllocate FAILURE  */
				    

#define FEP_LOC_082	0x800082 /* FEP:FePinst.c:fepInstTask(),
                                 unable to send msg FEP_MsgPauseStreamCmplt
                                 qMsgWrite FAILURE  */
				    

#define FEP_LOC_083	0x800083 /* FEP:FePinst.c:fepInstTask(),
                                 unable to allocate msg
                                 FEP_MsgStartCmplt, qMsgAllocate FAILURE   */

#define FEP_LOC_084	0x800084 /* FEP:FePinst.c:fepInstTask(),
                                 FEP_MsgStartCmplt_put FAILURE */

#define FEP_LOC_085	0x800085 /* FEP:FePinst.c:fepInstTask(),
                                 unable to send msg FEP_MsgStartCmplt
                                 qMsgWrite FAILURE   */

#define FEP_LOC_086	0x800086 /* FEP:FePinst.c:fepInstTask(),
                                 host connection broken going to MainState,
                                 recd. FES_MsgStartCmplt */

#define FEP_LOC_087	0x800087 /* FEP:FePinst.c:fepInstTask(),
                                 unable to deallocate FES Component Inst. in
                                 FES_MsgStopCmplt in MainState
                                 FEPINST_STOPPING qCompFree FAILURE */

#define FEP_LOC_088	0x800088 /* FEP:tFePinst.c:fepInstTask(),
                                 qClusterDeactivate FAILURE in
                                 FES_MsgStopCmplt in MainState
                                 FEPINST_STOPPING */

#define FEP_LOC_089	0x800089 /* FEP:FePinst.c:fepInstTask(),
                                 unable to allocate msg  FEP_MsgStopped
                                 qMsgAllocate FAILURE */

#define FEP_LOC_090	0x800090 /* FEP:FePinst.c:fepInstTask(),
                                 unable to write msg  FEP_MsgStopped
                                 qMsgWrite FAILURE  */

#define FEP_LOC_091	0x800091 /* FEP:FePinst.c:fepInstTask(),
                                 unable to allocate msg  FEP_MsgRestCmplt
                                 qMsgAllocate FAILURE  */

#define FEP_LOC_092	0x800092 /* FEP:FePinst.c:fepInstTask(),
                                 unable to send msg FEP_MsgRestCmplt
                                 qMsgWrite FAILURE   */

#define FEP_LOC_093	0x800093 /* FEP:FePinst.c:fepInstTask(),
                                 unable to send allocate FeS_MsgConverged,
                                 qMsgAllocate FAILURE    */

#define FEP_LOC_094	0x800094 /* FEP:FePinst.c:fepInstTask(),
                                 unable to send msg FeS_MsgConverged,
                                 qMsgWrite FAILURE  */

#define FEP_LOC_095	0x800095 /* FEP:FePinit.c:FEPinit(),
                                 unable to create the Front End Primary
                                 Component Task   */

#define FEP_LOC_096	0x800096 /* FEP:FePinst.c:feperror(),
                                 Std_MsgError_put  FAILURE */

#define FEP_LOC_097	0x800097 /* FEP:FePinst.c:fepInstTask(),
                                 qClusterSlotInfo FAILURE,
                                 when setting up the reference (Ni - TRC
                                 Model) stream ID */

#define FEP_LOC_098	0x800098 /* FEP:FePinst.c:fepSentReferenceActiveMsg(),
                                 unable to allocate msg FES_ReferenceActive
                                 ,qMsgAllocate FAILURE*/

				    

#define FEP_LOC_099	0x800099 /* FEP:FePinst.c:fepSentReferenceActactiveMsg(),
                                 unable to send msg FES_ReferenceActive, 
                                 qMsgWrite FAILURE  */

#define FEP_LOC_100	0x800100 /* FEP:FePinst.c:fepSentReferenceInactiveMsg(),
                                 unable to allocate msg FES_ReferenceActive
                                 ,qMsgAllocate FAILURE*/

				    

#define FEP_LOC_101	0x800101 /* FEP:FePinst.c:fepSentReferenceInactiveMsg(),
                                 unable to send msg FES_ReferenceActive, 
                                 qMsgWrite FAILURE  */

#define FEP_LOC_102	0x800102 /* FEP:FePinst.c:fepInstTask(),
                                 unable to find the cluster address of the
                                 FEP component instance, qClusterByComp FAILURE  */

#define FEP_LOC_103	0x800103 /* FEP:FePinst.c:fepInstTask(),
                                 Std_MsgArmRTC_get FAILED  */

#define FEP_LOC_104	0x800104 /* FEP:FePinst.c:fepInstTask(),
                                 Std_MsgDisarmRTC_get FAILED  */

#define FEP_LOC_105	0x800105 /* FEP:FePinst.c:fepInstTask(),
                                 qMsgAllocate(Std_MsgDisarmRTCCmplt) FAILED */

#define FEP_LOC_106	0x800106 /* FEP:FePinst.c:fepInstTask(),
                                 qMsgWrite(Std_MsgDisarmRTCCmplt) FAILED */

#define FEP_LOC_107	0x800107 /* FEP:FePinst.c:fepInstTask(),
                                 qMsgAllocate(Std_MsgDisarmAllRTCsCmplt) FAILED  */

#define FEP_LOC_108	0x800108 /* FEP:FePinst.c:fepInstTask(),
                                 qMsgWrite(Std_MsgDisarmAllRTCsCmplt) FAILED  */

#define FEP_LOC_109	0x800109 /* FEP:FePinst.c:fepInstTask(),
                                 Std_MsgEvtDetected_get FAILED  */

#define FEP_LOC_110	0x800110 /* FEP:FePinst.c:fepInstTask(),
                                 Std_MsgArmRTC_get FAILED  */

#define FEP_LOC_111	0x800111 /* FEP:FePinst.c:fepInstTask(),
                                 qMsgAllocate(Std_MsgArmRTCCmplt) FAILED  */

#define FEP_LOC_112 0x800112 /* FEP:FePinst.c:fepInstTask(),
                                 qMsgWrite(Std_MsgArmRTCCmplt) FAILED  */

#define FEP_LOC_113 0x800113 /* FEP:FePinst.c:fepInstTask(),
                                 qMsgAllocate(Std_MsgSetxParms) FAILED  */


#define FEP_LOC_114 0x800114 /* FEP:FePinst.c:fepInstTask(),
                                Std_MsgSetxParms_put FAILED  */

#define FEP_LOC_115 0x800115 /* FEP:FePinst.c:fepInstTask(),
                                 Std_MsgSetxParms_List_put(NLP) FAILED  */

#define FEP_LOC_116 0x800116 /* FEP:FePinst.c:fepInstTask(),
                                Std_MsgSetxParms_List_put FAILED  */

#define FEP_LOC_117 0x800117 /* FEP:FePinst.c:fepInstTask(),
                                Std_MsgSetxParms_List_put FAILED  */

#define FEP_LOC_118 0x800118 /* FEP:FePinst.c:fepInstTask(),
                                 Std_MsgSetxParms_List_putFAILED  */

#define FEP_LOC_119 0x800119 /* FEP:FePinst.c:fepInstTask(),
                                 Std_MsgSetxParms_List_put FAILED  */

#define FEP_LOC_120 0x800120 /* FEP:FePinst.c:fepInstTask(),
                                 Std_MsgSetxParms_List_put FAILED  */

#define FEP_LOC_121 0x800121 /* FEP:FePinst.c:,
                                 Std_MsgSetxParms_List_put FAILED  */

#define FEP_LOC_122 0x800122 /* FEP:FePinst.c:,
                                 Std_MsgSetxParms_List_put FAILED  */

#define FEP_LOC_123 0x800123 /* FEP:FePinst.c:,
                                 Std_MsgSetxParms_List_put FAILED  */

#define FEP_LOC_124 0x800124 /* FEP:FePinst.c:,
                                 Std_MsgSetxParms_List_put FAILED  */

#define FEP_LOC_125 0x800125 /* FEP:FePinst.c:,
                                 Std_MsgSetxParms_List_put FAILED  */

#define FEP_LOC_126 0x800126 /* FEP:FePinst.c:,
                                 Std_MsgSetxParms_List_put FAILED  */

#define FEP_LOC_127 0x800127 /* FEP:FePinst.c:,
                                 Std_MsgSetxParms_List_put FAILED  */

#define FEP_LOC_128 0x800128 /* FEP:FePinst.c:,
                                 Std_MsgSetxParms_List_put FAILED  */

#define FEP_LOC_129 0x800129 /* FEP:FePinst.c:,
                                 Std_MsgSetxParms_List_put FAILED  */

#define FEP_LOC_130 0x800130 /* FEP:FePinst.c:,
                                 Std_MsgSetxParms_List_put FAILED  */


#define FEP_LOC_131 0x800131 /* FEP:FePinst.c:,
                                 qMsgWrite(Std_MsgSetxParms) FAILED  */

#define FEP_LOC_132 0x800132 /* FEP:FePcomp.c:fepCompTask(),
                                 qMsgFree(inMsg) FAILED  */

#define FEP_LOC_133 0x800133 /* FEP:FePinst.c:,
                                 Std_MsgSetxParms_get FAILED */

#define FEP_LOC_134 0x800134 /* FEP:FePinst.c:,
                                 Std_MsgSetxParms_List_get FAILED */

#define FEP_LOC_135 0x800135 /* FEP:FePinst.c:,
                                 Std_MsgSetxParms_List_get FAILED */

#define FEP_LOC_136 0x800136 /* FEP:FePinst.c:,
                                 qMsgAllocate(Std_MsgSetxParms) FAILED */

#define FEP_LOC_137 0x800137 /* FEP:FePinst.c:,
                                 Std_MsgSetxParms_put FAILED */

#define FEP_LOC_138 0x800138 /* FEP:FePinst.c:,
                                 Std_MsgSetxParms_List_get FAILED */

#define FEP_LOC_139 0x800139 /* FEP:FePinst.c:,
                                 Std_MsgSetxParms_List_put FAILED */

#define FEP_LOC_140 0x800140 /* FEP:FePinst.c:,
                                  qMsgFree() FAILED*/

#define FEP_LOC_141 0x800141 /* FEP:FePinst.c:,
                                  qMsgWrite(Std_MsgSetxParms) FAILED*/

#define FEP_LOC_142 0x800142 /* FEP:FePinst.c:,
                                  qMsgAllocate(Std_MsgSetxParmsCmplt) FAILED */

#define FEP_LOC_143 0x800143 /* FEP:FePinst.c:,
                                  qMsgWrite(Std_MsgSetxParmsCmplt) FAILED */

#define FEP_LOC_144 0x800144 /* FEP:FePinst.c:,
                                  Std_MsgSetxParms_List_put FAILED*/

#define FEP_LOC_145 0x800145 /* FEP:FePinst.c:,
                                   Std_MsgSetxParms_List_put FAILED */

#define FEP_LOC_146 0x800146 /* FEP:FePinst.c:,
                                   qMsgAllocate(Std_MsgSetParmCmplt) FAILED */

#define FEP_LOC_147 0x800147 /* FEP:FePinst.c:,
                                   qMsgWrite(Std_MsgSetParmCmplt) FAILED */

#define FEP_LOC_148	0x800148 /* FEP:FePinst.c:fepInstTask() in
                                 QclusterActive (Ri2 testing), failure to get
                                 Delay Compensation Value from kernel call,
                                 qClusterEchoDelayFactor FAILURE */

#define FEP_LOC_149	0x800149  /* FEP:FePinst.c:fepInstTask() in
                                 QclusterActive (Ri1 testing), failure to get
                                 Delay Compensation Value from kernel call,
                                 qClusterEchoDelayFactor FAILURE */

#define FEP_LOC_150	0x800150  /* FEP:FePinst.c:fepInstTask()
                                  fepSendStopMsg() failed during 
                                  QCompInstNotify(free)
                                  */

#define FEP_LOC_151	0x800151  /* FEP:FePinst.c:fepInstTask()
                                 QResultError_get() failed  */

#define FEP_LOC_152	0x800152  /* FEP:FePinst.c:fepInstTask()
                                 QCompExited_get() failed */ 

#define FEP_LOC_153	0x800153  /* FEP:FePinst.c:fepInstTask()
                                  qMsgAllocate(FEP_MsgStopped_Size) failed */  

#define FEP_LOC_154	0x800154  /* FEP:FePinst.c:fepInstTask()
                                  FEP_MsgStopped_put failed */ 

#define FEP_LOC_155	0x800155  /* FEP:FePinst.c:fepInstTask()
                                  qMsgWrite(FEP_MsgStop) failed */

#define FEP_LOC_156	0x800156  /* FEP:FePinst.c:fepInstTask()
                                  qHostExitCmplt failed */ 

#define FEP_LOC_157	0x800157  /* FEP:FePinst.c:fepInstTask()
                                  QHostExited_get failed */ 

#define FEP_LOC_158	0x800158  /* FEP:FePinst.c:fepInstTask()
                                  qHostExitCmplt failed */ 

#define FEP_LOC_159	0x800159  /* FEP:FePinst.c:fepInstTask()
                                  qHostExitCmplt failed */

#define FEP_LOC_160	0x800160  /* FEP:FePinst.c:fepInstTask()
                                  qHostExitCmplt failed */

#define FEP_LOC_161	0x800161  /* FEP:FePcomp.c:
                                  Std_MsgSetParmDef_get failed */

#define FEP_LOC_162	0x800162  /* FEP:FePcomp.c:
                                  qMsgAllocate(Std_MsgSetParmDefCmplt) failed */

#define FEP_LOC_163	0x800163  /* FEP:FePcomp.c:
                                  qMsgWrite (Std_MsgSetParmDefCmplt) failed*/

#define FEP_LOC_164	0x800164  /* FEP:FePcomp.c:
                                  qMsgAllocate(Std_MsgSetxParmsDefCmplt) failed */

#define FEP_LOC_165	0x800165  /* FEP:FePcomp.c:
                                  qMsgAllocate(Std_MsgSetAllParmsDefCmplt) failed */

#define FEP_LOC_166	0x800166  /* FEP:FePcomp.c:
                                  qMsgWrite(Std_MsgSetAllParmsDefCmplt) failed */

#define FEP_LOC_167	0x800167  /* FEP:FePcomp.c:
                                  Std_MsgSetxParms_get failed */

#define FEP_LOC_168	0x800168  /* FEP:FePcomp.c:
                                  Std_MsgSetxParms_List_get failed */

#define FEP_LOC_169	0x800169  /* FEP:FePcomp.c:
                                  Std_MsgSetxParms_List_get failed */

#define FEP_LOC_170	0x800170  /* FEP:FePcomp.c:
                                  qMsgAllocate(Std_MsgSetxParmsCmplt) failed */

#define FEP_LOC_171	0x800171  /* FEP:FePcomp.c:
                                  qMsgWrite(Std_MsgSetxParmsCmplt) failed */

#define FEP_LOC_172	0x800172  /* FEP:FePcomp.c:
                                  qMsgWrite(Std_MsgSetxParmsDefCmplt) failed */

#define FEP_LOC_173	0x800173  /* FEP:FePinst.c:
                                  Std_MsgSetParmDef_get failed */

#define FEP_LOC_174	0x800174  /* FEP:FePinst.c:
                                  qMsgAllocate(Std_MsgSetxParms_List_Size
                                              + Std_MsgSetxParms_Size)  failed*/

#define FEP_LOC_175	0x800175  /* FEP:FePinst.c:
                                  Std_MsgSetxParms_put failed */

#define FEP_LOC_176	0x800176  /* FEP:FePinst.c:
                                  Std_MsgSetxParms_List_put failed */

#define FEP_LOC_177	0x800177  /* FEP:FePinst.c:
                                  qMsgWrite(Std_MsgSetxParms) failed */

#define FEP_LOC_178	0x800178  /* FEP:FePinst.c:
                                  qMsgAllocate(Std_MsgSetParmDefCmplt) failed */

#define FEP_LOC_179	0x800179  /* FEP:FePinst.c:
                                  qMsgWrite(Std_MsgSetParmDefCmplt) failed */

#define FEP_LOC_180	0x800180  /* FEP:FePinst.c:
                                  Std_MsgSetxParmsDef_get failed */

#define FEP_LOC_181	0x800181  /* FEP:FePinst.c:
                                  qMsgAllocate(Std_MsgSetxParms)
                                             FAILED*/

#define FEP_LOC_182	0x800182  /* FEP:FePinst.c:
                                  Std_MsgSetxParms_put failed */

#define FEP_LOC_183	0x800183  /* FEP:FePinst.c:
                                  qMsgFree(Std_MsgSetxParms) failed */

#define FEP_LOC_184	0x800184  /* FEP:FePinst.c:
                                  Std_MsgSetxParms_List_put failed */

#define FEP_LOC_185	0x800185  /* FEP:FePinst.c:
                                  qMsgWrite(Std_MsgSetxParms) failed*/

#define FEP_LOC_186	0x800186  /* FEP:FePinst.c:
                                  qMsgFree(Std_MsgSetxParms) failed */

#define FEP_LOC_187	0x800187  /* FEP:FePinst.c:
                                  qMsgAllocate(Std_MsgSetxParmsDefCmplt) failed */

#define FEP_LOC_188	0x800188  /* FEP:FePinst.c:
                                  qMsgWrite(Std_MsgSetxParmsDefCmplt) failed */

#define FEP_LOC_189	0x800189  /* FEP:FePinst.c:
                                  qMsgAllocate(Std_MsgSetAllParmsDefCmplt) failed */

#define FEP_LOC_190	0x800190  /* FEP:FePinst.c:
                                  qMsgWrite(Std_MsgSetAllParmsDefCmplt) failed */

#define FEP_LOC_191	0x800191  /* FEP:FePinst.c:
                                  Std_MsgDetectxEvts_get failed */

#define FEP_LOC_192	0x800192  /* FEP:FePinst.c:
                                  Std_MsgDetectxEvts_List_get failed */

#define FEP_LOC_193	0x800193  /* FEP:FePinst.c:
                                  Std_MsgDetectxEvts_List_get failed  */

#define FEP_LOC_194	0x800194  /* FEP:FePinst.c:
                                  qMsgAllocate(Std_MsgDetectxEvtsCmplt) failed */

#define FEP_LOC_195	0x800195  /* FEP:FePinst.c:
                                  qMsgWrite(Std_MsgDetectxEvtsCmplt) failed */

#define FEP_LOC_196	0x800196  /* FEP:FePinst.c:
                                  qMsgAllocate(Std_MsgCancelAllEvtsCmplt) failed */

#define FEP_LOC_197	0x800197  /* FEP:FePinst.c:
                                  qMsgWrite(Std_MsgCancelAllEvtsCmplt) failed */

#define FEP_LOC_198	0x800198  /* FEP:FePinst.c:
                                  Std_MsgCancelxEvts_get failed */

#define FEP_LOC_199	0x800199  /* FEP:FePinst.c:
                                  Std_MsgCancelxEvts_List_get failed */

#define FEP_LOC_200	0x800200  /* FEP:FePinst.c:
                                  Std_MsgCancelxEvts_List_get failed */

#define FEP_LOC_201	0x800201  /* FEP:FePinst.c:
                                  qMsgAllocate(Std_MsgCancelxEvtsCmplt) failed */

#define FEP_LOC_202	0x800202  /* FEP:FePinst.c:
                                  qMsgWrite(Std_MsgCancelxEvtsCmplt) failed */

#define FEP_LOC_203	0x800203  /* FEP:FePinst.c:
                                   qMsgAllocate( Std_MsgGetxParmsCmplt) failed */

#define FEP_LOC_204	0x800204  /* FEP:FePinst.c:
                                  Std_MsgGetxParmsCmplt_put failed */

#define FEP_LOC_205	0x800205  /* FEP:FePinst.c:
                                  Std_MsgGetxParms_List_get failed */

#define FEP_LOC_206	0x800206  /* FEP:FePinst.c:
                                  qMsgFree(Std_MsgGetxParms) failed */

#define FEP_LOC_207	0x800207  /* FEP:FePinst.c:
                                  Std_MsgGetxParmsCmplt_List_put failed */

#define FEP_LOC_208	0x800208  /* FEP:FePinst.c:
                                  qMsgWrite( Std_MsgGetxParmsCmplt) failed */

#define FEP_LOC_209	0x800209  /* FEP:FePinst.c:fepInstTask(),
                                 Std_MsgArmxRTCs_get FAILED  */

#define FEP_LOC_210	0x800210  /* FEP:FePinst.c:fepInstTask()
                                  Std_MsgArmxRTCs_List_get */

#define FEP_LOC_211	0x800211  /* FEP:FePinst.c:fepInstTask()
                                  Std_MsgArmxRTCs_List_get
                                   */

#define FEP_LOC_212	0x800212  /* FEP:FePinst.c:fepInstTask()
                                  qMsgAllocate(Std_MsgArmxRTCsCmplt) failed
                                   */

#define FEP_LOC_213	0x800213  /* FEP:FePinst.c:fepInstTask()
                                  qMsgWrite(Std_MsgArmxRTCsCmplt) failed
                                   */

#define FEP_LOC_214	0x800214  /* FEP:FePinst.c:fepInstTask(),
                                 Std_MsgDisarmxRTCs_get FAILED
                                   */

#define FEP_LOC_215	0x800215  /* FEP:FePinst.c:fepInstTask()
                                  Std_MsgDisarmxRTCs_List_get
                                   */

#define FEP_LOC_216	0x800216  /* FEP:FePinst.c:fepInstTask()
                                  qMsgAllocate(Std_MsgDisarmxRTCsCmplt) failed
                                   */

#define FEP_LOC_217	0x800217  /* FEP:FePinst.c:fepInstTask()
                                  qMsgWrite(Std_MsgDisarmxRTCsCmplt) failed
                                   */

/* 
 * Note: FEP_LOC_218 through FEP_LOC_250 are not used 
 */

#define FEP_LOC_251	0x800251  /* FEP:FePinst.c:fepInitMsgHdlr(),
                                  qCompAllocate failed during
                                  Static allocation of FES during
                                  download. */ 

#define FEP_LOC_252	0x800252  /* FEP:FePinst.c:fepInstTask(),
                                  qMsgAllocate  failed during
                                  allocating FEP_MsgDTMFDigit */

#define FEP_LOC_253	0x800253  /* FEP:FePinst.c:fepInstTask(),
                                  failed during  FEP_MsgDTMFDigi_putt */

#define FEP_LOC_254	0x800254  /* FEP:FePinst.c:fepInstTask(),
                                  qMsgWrite failed in sending
                                  FEP_MsgDTMFDigit */

#define FEP_LOC_255	0x800255  /* FEP:FePinst.c:fepSendParmToFes(),
                                   put failed */

#define FEP_LOC_256	0x800256 /* FEP:FePinst.c: fepDetermineModel()
        failure from qCluseterPortCurrentTalker in fepDetermineModel */

#define FEP_LOC_257	0x800257 /*FEP:FePinst.c: fepDetermineModel()
        the isTalkerPresent is false after calling qClusterPortCurrentTalker
        in fepDetermineModel */   

#define FEP_LOC_258	0x800258 /* FEP:FePinst.c:fepInstTask(),
                                 unable to allocate msg
                                 FEP_MsgStartCmplt, qMsgAllocate FAILURE   
                                 For RTC Stop Buffering */

#define FEP_LOC_259	0x800259 /* FEP:FePinst.c:fepInstTask(),
                                 FEP_MsgStartCmplt_put FAILURE 
                                 For RTC Stop Buffering */                  

#define FEP_LOC_260	0x800260 /* FEP:FePinst.c:fepInstTask(),
                                 unable to send msg FEP_MsgStartCmplt
                                 qMsgWrite FAILURE For RTC Stop Buffering */ 

#define FEP_LOC_261	0x800261 /* FEP:FePinst.c:fepInstTask(),
                                 unable to allocate msg FEP_MsgStopped
                                 qMsgAllocate FAILURE 
                                 For RTC Stop Buffering */

#define FEP_LOC_262  0x800262 /* FEP:FePinst.c:fepInstTask(),
                                 FEP_MsgStopped_put FAILURE 
                                 For RTC Stop Buffering */ 

#define FEP_LOC_263	0x800263 /* FEP:FePinst.c:fepInstTask(),
                                 unable to write msg  FEP_MsgStopped
                                 qMsgWrite FAILURE For RTC Stop Buffering */ 

#define FEP_LOC_264  0x800264 /* FEP:FePinst.c:fepInstTask(),
                                 QFTimerSet failure./
                                 Task - 10893: MAX_TIME.*/ 

#define FEP_LOC_265  0x800265 /* FEP:FePinst.c:fepSetXParmsFromMsg_StartxHdlr(),
                                 FEP_MsgStartx_get failure./
                                 Task - 10893: MAX_TIME.*/ 

#define FEP_LOC_266  0x800266 /* FEP:FePinst.c:fepSetXParmsFromMsg_StartxHdlr(),
                                 FEP_MsgStartx_ParmList_get failure
                                 (verifying number of parameters in list)./
                                 Task - 10893: MAX_TIME.*/ 

#define FEP_LOC_267  0x800267 /* FEP:FePinst.c:fepSetXParmsFromMsg_StartxHdlr(),
                                 FEP_MsgStartx_ParmList_get failure.(finding
                                 number of parameters to send to EFES).
                                 Task - 10893: MAX_TIME.*/

#define FEP_LOC_268  0x800268 /* FEP:FePinst.c:fepSetXParmsFromMsg_StartxHdlr(),
                                 qMsgAllocate failure.(failure to allocate
                                 setXParms message for EFES).
                                 Task - 10893: MAX_TIME.*/

#define FEP_LOC_269  0x800269 /* FEP:FePinst.c:fepSetXParmsFromMsg_StartxHdlr(),
                                 Std_MsgSetxParms_put failure.
                                 Task - 10893: MAX_TIME.*/

#define FEP_LOC_270  0x800270 /* FEP:FePinst.c:fepSetXParmsFromMsg_StartxHdlr(),
                                 FEP_MsgStartx_ParmList_get failure (failure
                                 to get parameters from ParmList for setting).
                                 Task - 10893: MAX_TIME.*/
 
#define FEP_LOC_271  0x800271 /* FEP:FePinst.c:fepSetXParmsFromMsg_StartxHdlr(),
                                 Std_MsgSetxParms_List_put failure (failure
                                 to put parameters).
                                 Task - 10893: MAX_TIME.*/ 

#define FEP_LOC_272  0x800272 /* FEP:FePinst.c:fepSetXParmsFromMsg_StartxHdlr(),
                                 qMsgFree failure.
                                 Task - 10893: MAX_TIME.*/ 

#define FEP_LOC_273  0x800273 /* FEP:FePinst.c:fepSetXParmsFromMsg_StartxHdlr(),
                                 qMsgWrite failure.
                                 Task - 10893: MAX_TIME.*/
  
#define FEP_LOC_274	0x800274 /* FEP:FePinst.c:fepInstTask(),
                                 FEP_MsgStart_get() FAILED */                                    

#define FEP_LOC_275	0x800275 /* FEP:FePinst.c:fepInstTask(),
                                 qGStreamTerminate() FAILED */

#define FEP_LOC_276	0x800276 /* FEP:FePinst.c:fepSendReferenceActiveMsg(),
                                 qCompEnableActInactMsg() FAILED */

#define FEP_LOC_277	0x800277 /* FEP:FePinst.c:fepInstTask(),
                                 qCompDisableActInactMsg() FAILED */

#define FEP_LOC_278	0x800278 /* FEP:FePcomp.c:
                                 qCompFind() FAILED */

#define FEP_LOC_279	0x800279 /* FEP:FePcomp.c:
                                 qMsgWrite(GetParm) FAILED */

#define FEP_LOC_280	0x800280 /* FEP:FePcomp.c:
                                 Std_MsgGetParmCmplt_get()  FAILED */

#define FEP_LOC_281	0x800281 /* FEP:FePcomp.c:
                                 qMsgAllocate(GetParm)  FAILED */

#define FEP_LOC_282	0x800282 /* FEP:FePcomp.c:
                                 Std_MsgGetParm_put FAILED */

#define FEP_LOC_283	0x800283 /* FEP:FePcomp.c:
                                 qMsgFree FAILED */

#define FEP_LOC_284	0x800284 /* FEP:FePinst.c:
                                 Std_MsgSetxParms_List_put FAILED when adding
                                 SCSTrailingSilence */

#define FEP_LOC_285	0x800285 /* FEP:FePinst.c:
                                 Std_MsgSetxParms_List_put FAILED when adding
                                 SCSInitialData */

#define FEP_LOC_286	0x800286 /* FEP:FePinst.c:
                                 Std_MsgSetxParms_List_put FAILED when adding
                                 SCSOnOff */
#endif




