/*
    Copyright (C) 2000-2003.  Intel Corporation.

    All Rights Reserved.  All names, products,
    and services mentioned herein are the trademarks
    or registered trademarks of their respective organizations
    and are the sole property of their respective owners.
*/


/*
*    AUTO-VERSIONING HEADER  DO NOT HAND MODIFY
*    ===================================================================
*    %name:          ICTBoard.h %
*    %version:       27 %
*    %instance:      hsw_1 %
*    %created_by:    klotzw %
*    %date_modified: Thu Apr 17 22:56:55 2003 %
*    ===================================================================
*/

#ifndef __ICTBOARD_H__
#define __ICTBOARD_H__

#ifndef lint
static char    *_hsw_1_ICTBoard_h = "@(#) %filespec: ICTBoard.h-27 %  (%full_filespec: ICTBoard.h-27:incl:hsw#1 %)";
#endif

#include <string>
#include <list>

#include "dlgctypes.h"

#include "DlgDasiClientLib.h"
#include "ICTClockAgent.h"

#ifdef  __FULL_DASI__
#include "ICTTrunk.h"
#endif

namespace DASI
{
    /**
     * The ICTBoard object is returned when an application performs a call through the ICTNode class
     * to get the board interface object required by the application.  The ICTBoard object is the base
     * class for all other board objects in the OA&M sub-system.  Each board technology derives it's
     * from this base class.
     *
     * @exception CCTDasiException
     *
     * @version 1.0
     * @since 1.0
     * @stereotype interface
     */

    class DLGDASICLIENT_API ICTBoard
    {
    public:
        // Operational Status
        enum OperationalStatusValues
        {
            NOT_APPLICABLE_STATUS = 0,
            PHYSICAL_PRESENT_NOT_CONFIGURED_STATUS,
            PHYSICAL_PRESENT_CONFIGURED_STATUS,
            CONFIGURED_NOT_PHYSICAL_PRESENT_STATUS,
            ONLINE_STATUS,
            ONLINE_DIAGNOSTIC_STATUS,
            OFFLINE_DIAGNOSTIC_STATUS
        };

        //Admin Status
        enum AdminStatusValues
        {
            BOARD_DISABLE_ADMIN_STATUS = 0,
            BOARD_ENABLE_ADMIN_STATUS
        };

        // Platform Types
        enum CTPlatformValues
        {
            CTPLATFORM_UNKNOWN = 0,
            CTPLATFORM_DM3,
            CTPLATFORM_PMAC,
            CTPLATFORM_SPRINGWARE
        };

        // Platform Types
        enum CTFamilyValues
        {
            CTFAMILY_UNKNOWN = 0,
            CTFAMILY_QUADSPAN,
            CTFAMILY_IPLINK
        };

        /**
         * The ICTBoard destructor releases the resources the object has aquired
         * during it's operational lifecycle.
         *
         * @version 1.0
         * @since 1.0
         */

        virtual ~ICTBoard() {};

#ifdef __FULL_DASI__

        /**
         * Saves ICTBoard information.
         *
         * @exception CCTDasiException
         *
         * @version 1.0
         * @since 1.0
         */

        virtual void Save() = 0;


        /**
         * Retrieves ICTBoard information.
         *
         * @exception CCTDasiException
         *
         * @version 1.0
         * @since 1.0
         */

        virtual void Retrieve() = 0;

#endif  // __FULL_DASI__

        /**
         * Retrieves the ID of the board.
         *
         * @return constant long : The unique id of this ICTBoard object.
         *
         * @exception CCTDasiException
         *
         * @version 1.0
         * @since 1.0
         */

        virtual const AUID GetBoardID() = 0;


        /**
         * Retrieves the board physical slot.
         *
         * @return constant long : Physical slot of this ICTBoard object.
         *
         * @exception CCTDasiException
         *
         * @version 1.0
         * @since 1.0
         */

        virtual const long GetPhysicalSlot() = 0;


        /**
         * Retrieves the board Shelf ID.
         *
         * @return constant long : The shelf ID of this ICTBoard object.
         *
         * @exception CCTDasiException
         *
         * @version 1.0
         * @since 1.0
         */

        virtual const long GetShelfId() = 0;


        /**
         * Retrieves the PCI Bus of the board.
         *
         * @return constant long : The PCI Bus of this ICTBoard object.
         *
         * @exception CCTDasiException
         *
         * @version 1.0
         * @since 1.0
         */

        virtual const long GetPCIBus() = 0;


        /**
         * Retrieves the PCI Slot of the board.
         *
         * @return constant long : The PCI Slot of this ICTBoard object.
         *
         * @exception CCTDasiException
         *
         * @version 1.0
         * @since 1.0
         */

        virtual const long GetPCISlot() = 0;


        /**
         * Retrieves the number of trunks on the board.
         *
         * @return The number of Trunks on the board.
         *
         * @exception CCTDasiException
         *
         * @version 1.0
         * @since 1.0
         */

        virtual const unsigned short GetNumTrunks() = 0;


#ifdef  __FULL_DASI__
        
        /**
         * Retrieves a list of Trunk objects.
         *
         * @return ICTTRUNKLIST* : An std::list<ICTTrunk*> of ICTTRUNK objects.
         *
         * @exception CCTDasiException
         *
         * @version 1.0
         * @since 1.0
         */

        virtual ICTTRUNKLIST* GetTrunks() = 0;


        /**
         * Retrieves CTPlatform associated with this ICTBoard object.
         *
         * @return A constant CTPlatformValues : Value in the enumeration table CTPlatformValues.
         *
         *      // Platform Types
         *      enum CTPlatformValues
         *      {
         *          UNKNOWN = 0,
         *          DM3,
         *          PMAC,
         *          SPRINGWARE
         *      };
         *
         *
         * @exception CCTDasiException
         *
         * @version 1.0
         * @since 1.0
         */

        virtual const CTPlatformValues GetCTPlatform() = 0;


        /**
         * Retrieves the Family associated with this ICTBoard object.
         *
         * @return A constant CTFamilyValues : Value in the enumeration table CTFamilyValues.
         *
         *      // Platform Types
         *      enum CTFamilyValues
         *      {
         *         CTFAMILY_UNKNOWN = 0,
         *         CTFAMILY_QUADSPAN,
         *         CTFAMILY_IPLINK,
         *         CTFAMILY_ROZETTA
         *      };
         *
         * @exception CCTDasiException
         *
         * @version 1.0
         * @since 1.0
         */

        virtual const CTFamilyValues GetCTFamily() = 0;


        /**
         * Retrieves the name associated with this ICTBoard object.
         *
         * @return A constant string : The board name associated with this ICTBoard object.
         *
         * @exception CCTDasiException
         *
         * @version 1.0
         * @since 1.0
         */

        virtual const std::string GetName() = 0;


        /**
         * Retrieves the description associated with this ICTBoard object.
         *
         * @return A constant string : The board description associated with this ICTBoard object.
         *
         * @exception CCTDasiException
         *
         * @version 1.0
         * @since 1.0
         */

        virtual const std::string GetDescription() = 0;

#endif  // __FULL_DASI__


        /**
         * Retrieves the serial number associated with this ICTBoard object.
         *
         * @return A constant string : The serial number.
         *
         * @exception CCTDasiException
         *
         * @version 1.0
         * @since 1.0
         */

        virtual const std::string GetSerialNumber() = 0;


        /**
         * Retrieves the number of clocking agents on the board.
         *
         * @return The number of Clocking Agents on the board.
         *
         * @exception CCTDasiException
         *
         * @version 1.0
         * @since 1.0
         */

        virtual const short GetNumClockingAgents() = 0;


        /**
         * Retrieves the associated clocking agent objects.
         *
         * @return ICTCLOCKAGENTLIST : An std::list<ICTClockAgent*> of ICTClockAgent objects.
         *
         * @exception CCTDasiException
         *
         * @version 1.0
         * @since 1.0
         */

        virtual ICTCLOCKAGENTLIST* GetClockingAgents() = 0;

#ifdef  __FULL_DASI__

        /**
         * Retrieve the fault status associated with this ICTBoard object.
         *
         * @return A constant short bitmask containing the fault status information.
         *
         *	 //Fault Status Bit Mask Values
         *   const   short   DLG_NO_FAULT
         *   const   short   DLG_INIT_FAULT
         *   const   short   DLG_CP_FAULT
         *   const   short   DLG_SP_FAULT
         *   const   short   DLG_TDM_ALINE_FAULT
         *   const   short   DLG_TDM_BLINE_FAULT
         *   const   short   DLG_TDM_SCBUS_FAULT
         *   const   short   DLG_TDM_MASTERPLL_FAULT
         *   const   short   DLG_TDM_NETWORK_FAULT
         *   const   short   DLG_ETHERNET_FAULT
         *
         * @exception CCTDasiException
         *
         * @version 1.0
         * @since 1.0
         */

        virtual const short GetFaultStatus() = 0;


        /**
         * Retrieves the admin status associated with this ICTBoard object.
         *
         * @return A constant AdminStatusValues : Value in the enumeration table AdminStatusValues.
         *
         * 		enum AdminStatusValues
         *    	{
         *     	     BOARD_DISABLE_ADMIN_STATUS=0,
         *     	     BOARD_ENABLE_ADMIN_STATUS
         * 		};
         *
         * @exception CCTDasiException
         *
         * @version 1.0
         * @since 1.0
         */

        virtual const AdminStatusValues GetAdminStatus() = 0;


        /**
         * Retrieves the operational status associated with this ICTBoard object.
         *
         * @return A constant OperationalStatusValues : Values in the enumeration table OperationalStatusValues.
         *
         *    enum OperationalStatusValues
         *    {
         *        NOT_APPLICABLE_STATUS=0,
         *        PHYSICAL_PRESENT_NOT_CONFIGURED_STATUS,
         *        PHYSICAL_PRESENT_CONFIGURED_STATUS,
         *        CONFIGURED_NOT_PHYSICAL_PRESENT_STATUS,
         *        ONLINE_STATUS,
         *        ONLINE_DIAGNOSTIC_STATUS,
         *        OFFLINE_DIAGNOSTIC_STATUS
         *    };
         *
         *
         * @exception CCTDasiException
         *
         * @version 1.0
         * @since 1.0
         */

        virtual const OperationalStatusValues GetOperationalStatus() = 0;


        /**
         * Retrieves the interrupt level assigned to this board.
         *
         * @exception CCTDasiException
         *
         * @version 1.0
         * @since 1.0
         */

        virtual const long GetInterruptLevel() = 0;


        /**
         * Retrieves the shared ram address assigned to this board.
         *
         * @exception CCTDasiException
         *
         * @version 1.0
         * @since 1.0
         */

        virtual const long GetSharedRAMAddress() = 0;


        /**
         * Retrieves the shared ram length being used by this board.
         *
         * @exception CCTDasiException
         *
         * @version 1.0
         * @since 1.0
         */

        virtual const long GetSharedRAMLength() = 0;


        /**
         * Indicates whether board has faulted.
         *
         * @return A boolean value : true  - Board has a faulted
         *                           false - Board is not faulted.
         *
         * @exception CCTDasiException
         *
         * @version 1.0
         * @since 1.0
         */

        virtual bool IsFaulted() = 0;


        /**
         * Updates the name.
         *
         * @param rszBoardName a reference to a constant std::string& : User defined board name.
         *
         * @exception CCTDasiException
         *
         * @version 1.0
         * @since 1.0
         */

        virtual void SetName(/*in*/ const std::string& rszName) = 0;


        /**
         * Updates the description.
         *
         * @param rszBoardDescription a reference to a constant std::string& : User defined board description.
         *
         * @exception CCTDasiException
         *
         * @version 1.0
         * @since 1.0
         */

        virtual void SetDescription(/*in*/ const std::string& rszDescription) = 0;


        /**
         * Updates the CTPlatform type.
         *
         * @param eCTPlatform a constant CTPlatformVales : CTPlatform of board.
         *
         * @exception CCTDasiException
         *
         * @note This API is only available if the board is a preconfiguration template.
         *
         * @version 1.0
         * @since 1.0
         */

        virtual void SetCTPlatform(/*in*/ const CTPlatformValues eCTPlatform) = 0;


        /**
         * Updates the family type.
         *
         * @param eCTFamily a constant CTFamilyVales : CTFamily of board.
         *
         * @exception CCTDasiException
         *
         * @note This API is only available if the board is a preconfiguration template.
         *
         * @version 1.0
         * @since 1.0
         */

        virtual void SetFamilyType(/*in*/ const CTFamilyValues eCTfamily) = 0;



        /**
         * Updates the Administrative status of the board.
         *
         * @param eAdminStatus a constant to a enumeration : A enumeration value indicating the admin status.
         *
         * 		enum AdminStatusValues
         *    	{
         *     	     BOARD_DISABLE_ADMIN_STATUS=0,
         *     	     BOARD_ENABLE_ADMIN_STATUS
         * 		};
         *
         *
         * @exception CCTDasiException
         *
         * @version 1.0
         * @since 1.0
         */

        virtual void SetAdminStatus(/*in*/ const AdminStatusValues eAdminStatus) = 0;


        /**
         * Updates the fault status associated with this ICTBoard object.
         *
         * @param nFaultStatus a constant short to a bitmask containing the fault status.
         *
         *	 //Fault Status Bit Mask Values
         *   const   short   DLG_TDM_ALINE_FAULT
         *   const   short   DLG_TDM_BLINE_FAULT
         *   const   short   DLG_TDM_SCBUS_FAULT
         *   const   short   DLG_TDM_MASTERPLL_FAULT
         *
         * @note This API should only be used by a clock deamon to set the TDM faults
         *       any other use may invalidate the data contained by this field.
         *
         * @exception CCTDasiException
         *
         * @version 1.0
         * @since 1.0
         */

        virtual void SetFaultStatus(/*in*/ const short nFaultStatus) = 0;


        /**
         * Updates the PCISlot associated with this ICTBoard object.
         *
         * @param lPCISlot - A long to the PCI slot.
         *
         * @exception CCTDasiException
         *
         * @note This API is only available if the board is a preconfiguration template.
         *
         * @version 1.0
         * @since 1.0
         */

        virtual void SetPCISlot(/*in*/ const long lPCISot) = 0;


        /**
         * Updates the PCIBus associated with this ICTBoard object.
         *
         * @param lPCIBus - A long to the PCI bus.
         *
         * @exception CCTDasiException
         *
         * @note This API is only available if the board is a preconfiguration template.
         *
         * @version 1.0
         * @since 1.0
         */

        virtual void SetPCIBus(/*in*/ const long lPCIBus) = 0;


        /**
         * Updates the Cpci Shelf associated with this ICTBoard object.
         *
         * @param lShelf - A long to the Cpci Shelf.
         *
         * @exception CCTDasiException
         *
         * @note This API is only available if the board is a preconfiguration template.
         *
         * @version 1.0
         * @since 1.0
         */

        virtual void SetShelf(/*in*/ const long lShelf) = 0;


        /**
         * Updates the Cpci physical slot associated with this ICTBoard object.
         *
         * @param lPhysicalSlot - A long to the physical slot.
         *
         * @exception CCTDasiException
         *
         * @note This API is only available if the board is a preconfiguration template.
         *
         * @version 1.0
         * @since 1.0
         */

        virtual void SetPhysicalSlot(/*in*/ const long lPhysicalSlot) = 0;


        /**
         * Updates the serial number.
         *
         * @param A reference to a constant std::string : The serial number.
         *
         * @exception CCTDasiException
         *
         * @note This API is only available if the board is a preconfiguration template.
         *
         * @version 1.0
         * @since 1.0
         */

        virtual void SetSerialNumber(/*in*/ const std::string& rszSerialNumber) = 0;

        /**
         * Starts this board.
         *
         * @exception CCTDasiException
         *
         * @version 1.0
         * @since 1.0
         */

        virtual void Start() = 0;


        /**
         * Stops this board.
         *
         * @exception CCTDasiException
         *
         * @version 1.0
         * @since 1.0
         */

        virtual void Stop() = 0;


        /**
         * Redetect causes the detection server and associating detection agents for
         * this board to attempt to match a pre-configuration template with this board.
         * If a pre-configuration template is located the data within this ICTBoard object
         * is update with the data from the pre-configuration template matched.
         *
         * @exception CCTDasiException
         *
         * @version 1.0
         * @since 1.0
         */

        virtual void Reconfigure() = 0;

#endif  // __FULL_DASI__

    private:

        /** @link dependency
         * @stereotype instantiate*/
        /*#  ICTTrunk lnkICTTrunk; */

        /** @link dependency
         * @stereotype instantiate*/
        /*#  ICTClockAgent lnkICTClockAgent; */

        /** @link dependency
         * @stereotype instantiate*/
        /*#  ICTBus lnkICTBus; */
    }; // end class ICTBoard

    /// List of pointers to ICTBoard objects.
    typedef std::list<ICTBoard*> ICTBOARDLIST;
    typedef ICTBOARDLIST::iterator ICTBOARDLIST_ITER;

} // end namespace DASI
#endif //ICTBOARD_H




