/*
    Copyright (C) 2000-2003.  Intel Corporation.

    All Rights Reserved.  All names, products,
    and services mentioned herein are the trademarks
    or registered trademarks of their respective organizations
    and are the sole property of their respective owners.
 */


/*
*    AUTO-VERSIONING HEADER  DO NOT HAND MODIFY
*    ===================================================================
*    %name:          ICTClockAgent.h %
*    %version:       27 %
*    %instance:      hsw_1 %
*    %created_by:    klotzw %
*    %date_modified: Thu Apr 17 22:56:57 2003 %
*    ===================================================================
*/

#ifndef __ICTCLOCKAGENT_H__
#define __ICTCLOCKAGENT_H__

#ifndef lint
static char    *_hsw_1_ICTClockAgent_h = "@(#) %filespec: ICTClockAgent.h-27 %  (%full_filespec: ICTClockAgent.h-27:incl:hsw#1 %)";
#endif

#include <list>
#include <string>
#include <vector>

#include "dlgctypes.h"

#include "DlgDasiClientLib.h"

namespace DASI
{
    typedef struct _tagAgentTDMCapabilities
    {
        long structVersion;
        bool canH100Master;
        bool canH100Slave;
        bool canH110Master;
        bool canH110Slave;
        bool canScbusMaster;
        bool canScbusSlave;
        bool canMvipMaster;
        bool canMvipSlave;
        bool canScbus2Mhz;
        bool canScbus4Mhz;
        bool canScbus8Mhz;
        bool canProvideNetrefAt8Khz;
        bool canProvideNetrefAt1536Mhz;
        bool canProvideNetrefAt1544Mhz;
        bool canProvideNetrefAt2048Mhz;
        bool canDeriveNetrefAt8Khz;
        bool canDeriveNetrefAt1536Mhz;
        bool canDeriveNetrefAt1544Mhz;
        bool canDeriveNetrefAt2048Mhz;
        bool canProvideNetref2At8Khz;
        bool canProvideNetref2At1536Mhz;
        bool canProvideNetref2At1544Mhz;
        bool canProvideNetref2At2048Mhz;
        bool canDeriveNetref2At8Khz;
        bool canDeriveNetref2At1536Mhz;
        bool canDeriveNetref2At1544Mhz;
        bool canDeriveNetref2At2048Mhz;
        bool canSilenceScbusCompatLines;
        bool canSilenceMvipCompatLines;
        bool canDeriveNetrefFromOsc;
        bool canTerminate;
        bool canDynamicConfigure;
        bool canUseLocalDNIAsMasterSource;
        short maxClockMasterSourceListSize;
        bool isAlawCapable;
        bool isMulawCapable;
        bool isConversionCapable;
    } AGENTTDMCAPABILITIES, *LPAGENTTDMCAPABILITIES;

    typedef struct _tagAgentTDMBusConfiguration
    {
        long                structVersion;
        bool                onTelephonyBus;
        short               busType;
        short               scBusClockRate;
        short               group1ClockRate;
        short               group2ClockRate;
        short               group3ClockRate;
        short               group4ClockRate;
        bool                MVIPCompatLinesActive;
        bool                SCBusCompatLinesActive;
        short               clockMasterRole;
        long                clockMasterSource;
        std::vector<long>   clockMasterSourceList;
        short               clockMasterRate;
        short               clockingModel;
        short               primaryLines;
        bool                isProvidingNetref;
        long                netrefSource;
        short               netrefClockRate;
        bool                isProvidingNetref2;
        long                netref2Source;
        short               netref2ClockRate;
        bool                termination;
    } AGENTTDMCONFIGURATION, *LPAGENTTDMCONFIGURATION;

    /**
     *
     * An ICTClockAgent object is used to access all information with respect
     * to the board clocking agent.  The ICTClockAgent object is associated with
     * a board object in via has a relationship.  Meaning a ICTBoard object has
     * a ICTClockAgent object.
     *
     * @class  ICTClockAgent
     *
     * @brief  An ICTClockAgent object is used to access all information with
     *         respect to the board clocking agent.
     *
     * @exception CCTDasiException
     *
     * @version 1.0
     * @since 1.0
     * @stereotype implementationClass
     */

    class DLGDASICLIENT_API ICTClockAgent
    {
    public:

        /**
         * The ICTClockAgent destructor releases the resources the object has aquired
         * during it's operational lifecycle.
         *
         * @brief Destructor
         *
         * @version 1.0
         * @since 1.0
         */

        virtual ~ICTClockAgent() {};


        /**
         * @brief Retrieves the TDM capabilities of the clock agent on the board.
         *
         * @return A pointer  to a TDMCAPABILITIES structure.
         *
         * @exception CCTDasiException
         *
         * @version 1.0
         * @since 1.0
         */

        virtual AGENTTDMCAPABILITIES* GetTDMCapabilities() = 0;


        /**
         * @brief Retrieves the TDM configuration of the clock agent on the board.
         *
         * @return A pointer  to a TDMCONFIGURATION structure.
         *
         * @exception CCTDasiException
         *
         * @version 1.0
         * @since 1.0
         */

        virtual AGENTTDMCONFIGURATION* GetTDMConfiguration() = 0;


#ifdef __FULL_DASI__

        /**
         * @brief Updates the TDM configuration in the data store.
         *
         * @param A reference to a constant TDMCAPABILITIES structure.
         *
         * @exception CCTDasiException
         *
         * @version 1.0
         * @since 1.0
         */

        virtual void StoreTDMConfiguration(/*in*/ const AGENTTDMCONFIGURATION& rTDMConfig) = 0;

#endif  // __FULL_DASI__

        /**
         * @brief Updates the TDM configuration to the physical hardware.
         *
         * @param A reference to a constant TDMCONFIGURATION structure.
         *
         * @exception CCTDasiException
         *
         * @version 1.0
         * @since 1.0
         */

        virtual void SetTDMConfiguration(/*in*/ const AGENTTDMCONFIGURATION& rTDMConfig) = 0;


        /**
         * @brief Retrieves the clock agent id.
         *
         * @return An AUID (long) to a clocking agent id.
         *
         * @exception CCTDasiException
         *
         * @version 1.0
         * @since 1.0
         */

        virtual AUID GetClockAgentID() = 0;
    };

    /// List of pointers to ICTClockAgent objects.
    typedef std::list <ICTClockAgent*> ICTCLOCKAGENTLIST;
    typedef ICTCLOCKAGENTLIST::iterator ICTCLOCKAGENTLIST_ITER;
}
#endif //ICTCLOCKAGENT_H




