/*
    Copyright (C) 2000-2002.  Intel Corporation.

    All Rights Reserved.  All names, products,
    and services mentioned herein are the trademarks
    or registered trademarks of their respective organizations
    and are the sole property of their respective owners.
 */


/*
*    AUTO-VERSIONING HEADER  DO NOT HAND MODIFY
*    ===================================================================
*    %name:          ICTDm3Board.h %
*    %version:       21 %
*    %instance:      hsw_1 %
*    %created_by:    klotzw %
*    %date_modified: Wed Jul 03 19:19:38 2002 %
*    ===================================================================
*/

#ifndef __ICTDM3BOARD_H__
#define __ICTDM3BOARD_H__

#ifndef lint
static char    *_hsw_1_ICTDm3Board_h = "@(#) %filespec: ICTDm3Board.h-21 %  (%full_filespec: ICTDm3Board.h-21:incl:hsw#1 %)";
#endif

#include <list>
#include <string>

#include "dlgctypes.h"

#include "DlgDasiClientLib.h"
#include "ICTBoard.h"

#include "CCTDasiException.h"

namespace DASI
{
    /**
     * The ICTDm3Board object is not returned directly to an application
     * which performs a call to CCTDomain:: GetBoardByID or one of the interfaces
     * to retrieve a board or list of board through the ICTNode class.  Instead the
     * application will receive a ICTBoard  which has been dynamically cast from an
     * ICTDm3Board object to a ICTBoard object.  The ICTDm3Board object is the base
     * class for all other DM3 board objects in the system.  The ICTDm3Board object
     * is the base class for all other Dm3 board objects in the OA&M sub-system.
     * Each DM3 board technology derives it's from this base class.
     *
     * @stereotype interface
     *
     * @exception CCTDasiException
     *
     * @version 1.0
     * @since 1.0
     */
    class DLGDASICLIENT_API ICTDm3Board : virtual public ICTBoard
    {
    public:
        /**
         * The ICTDm3Board destructor releases the resources the object has aquired
         * during it's operational lifecycle.
         *
         * @version 1.0
         * @since 1.0
         */

        virtual ~ICTDm3Board() {};


      	/**
       	 * Saves ICTDm3Board information.
       	 *
       	 * @exception CCTDasiException
         *
         * @version 1.0
         * @since 1.0
      	 */

        virtual void Save() = 0;


        /**
       	 * Retrieves ICTDm3Board information.
       	 *
       	 * @exception CCTDasiException
         *
         * @version 1.0
         * @since 1.0
      	 */

        virtual void Retrieve() = 0;


        /**
       	 * Retrieves the control processor boot kernel version associated with this ICTDm3Board object.
         *
         * @return A constant std::string : Contains the contorl processor version.
         *
         * @exception CCTDasiException
         *
         * @version 1.0
         * @since 1.0
         */

		virtual const std::string GetControlProcessorBootKernelVersion() = 0;


        /**
       	 * Retrieves the control processor runtime kernel version associated with this ICTDm3Board object.
         *
         * @return A constant std::string : Contains the control processor version.
         *
         * @exception CCTDasiException
         *
         * @version 1.0
         * @since 1.0
         */

		virtual const std::string GetControlProcessorRuntimeKernelVersion() = 0;


        /**
       	 * Retrieves the signal processor boot kernel version associated with this ICTDm3Board object.
         *
         * @return A constant std::string : Contains the signal processor version.
         *
         * @exception CCTDasiException
         *
         * @version 1.0
         * @since 1.0
         */

        virtual const std::string GetSignalProcessorBootKernelVersion() = 0;


        /**
       	 * Retrieves the signal processor runtime kernel version associated with this ICTDm3Board object.
         *
         * @return A constant std::string : Contains the signal processor version.
         *
         * @exception CCTDasiException
         *
         * @version 1.0
         * @since 1.0
         */

		virtual const std::string GetSignalProcessorRuntimeKernelVersion() = 0;


        /**
       	 * Retrieves the PCD file to use with this ICTDm3Board object.
         *
         * @return A constant std::string : Contains the PCD filename.
         *
         * @exception CCTDasiException
         *
         * @version 1.0
         * @since 1.0
         */

        virtual const std::string GetPcdFileName() = 0;


        /**
       	 * Retrieves the PCD file desscription associated with this ICTDm3Board object.
         *
         * @return A constant std::string& : Contains the PCD file description.
         *
         * @exception CCTDasiException
         *
         * @version 1.0
         * @since 1.0
         */

        virtual const std::string GetPcdFileDescription() = 0;


        /**
       	 * Retrieves the FCD file to use with this ICTDm3Board object.
         *
         * @return A constant std::string& : Contains the FCD filename.
         *
         * @exception CCTDasiException
         *
         * @version 1.0
         * @since 1.0
         */

        virtual const std::string GetFcdFileName() = 0;


       	/**
       	 * Retrieves the physical id associated with this ICTDm3Board object.
       	 *
       	 * @return A long : Physical id assigned by the driver.
       	 *
       	 * @exception CCTDasiException
         *
         * @version 1.0
         * @since 1.0
       	 */

        virtual long GetPhysicalId() = 0;


       	/**
       	 * Retrieves the logical id associated with this ICTDm3Board object.
       	 *
       	 * @return A long : Logical id assigned by application.
       	 *
       	 * @exception CCTDasiException
         *
         * @version 1.0
         * @since 1.0
       	 */

        virtual long GetLogicalId() = 0;


       	/**
       	 * Retrieves the model number of  this ICTDm3Board object.
       	 *
       	 * @return A constant std::string& : Contains the model number.
       	 *
       	 * @exception CCTDasiException
         *
         * @version 1.0
         * @since 1.0
       	 */

        virtual const std::string GetModelNumber() = 0;



        /**
       	 * Updates the PCD file to use with this ICTDm3Board object.
         *
         * @param rszPcdFileName a reference to a constant std::string& : Contains the PCD filename.
         *
         * @exception CCTDasiException
         *
         * @version 1.0
         * @since 1.0
         */

        virtual void SetPcdFilename(/*in*/ const std::string& rszPcdFileName) = 0;


        /**
       	 * Updates the PCD file desscription associated with this ICTDm3Board object.
         *
         * @param rszPcdFileDescription a reference to a constant std::string& : Contains the PCD file description.
         *
         * @exception CCTDasiException
         *
         * @version 1.0
         * @since 1.0
         */

        virtual void SetPcdFileDescription(const std::string& rszPcdFileDescription) = 0;


        /**
       	 * Updates the FCD file to use with this ICTDm3Board object.
         *
         * @param rszFcdFileName a reference to a constant std::string& : Contains the FCD filename.
         *
         * @exception CCTDasiException
         *
         * @version 1.0
         * @since 1.0
         */

        virtual void SetFcdFilename(/*in*/ const std::string& rszFcdFileName) = 0;


       	/**
       	 * Updates the logical id associated with this ICTDm3Board object.
       	 *
       	 * @param lLogicaId a long : Logical id assigned by application.
       	 *
       	 * @exception CCTDasiException
         *
         * @version 1.0
         * @since 1.0
       	 */

        virtual void SetLogicalId(/*in*/ long lLogicaId) = 0;


       	/**
       	 * Updates the model number of  this ICTDm3Board object.
       	 *
       	 * @param rszModelNumber a reference to a constant std::string& : Contains the model number.
       	 *
         * @note API is only available if the board is a preconfiguration template.
      	 *
       	 * @exception CCTDasiException
         *
         * @version 1.0
         * @since 1.0
       	 */

        virtual void SetModelNumber(/*in*/ const std::string& rszModelNumber) = 0;

    }; // End class ICTDm3Board

    typedef std::list<ICTDm3Board*> ICTDM3BOARDLIST;
    typedef ICTDM3BOARDLIST::iterator ICTDM3BOARDLIST_ITER;

} // End namespace DASI
#endif //ICTDM3BOARD_H



