/*
    Copyright (C) 2000-2003.  Intel Corporation.

    All Rights Reserved.  All names, products,
    and services mentioned herein are the trademarks
    or registered trademarks of their respective organizations
    and are the sole property of their respective owners.
*/


/*
*    AUTO-VERSIONING HEADER  DO NOT HAND MODIFY
*    ===================================================================
*    %name:          ICTNode.h %
*    %version:       27 %
*    %instance:      hsw_1 %
*    %created_by:    klotzw %
*    %date_modified: Thu Apr 17 22:56:58 2003 %
*    ===================================================================
*/

#ifndef __ICTNODE_H__
#define __ICTNODE_H__

#ifndef lint
static char    *_hsw_1_ICTNode_h = "@(#) %filespec: ICTNode.h-27 %  (%full_filespec: ICTNode.h-27:incl:hsw#1 %)";
#endif

#include <string>
#include <list>

#include "dlgctypes.h"

#include "DlgDasiClientLib.h"


#include "ICTBoard.h"

#ifdef  __FULL_DASI__

#include "ICTBus.h"
#include "ICTPreConfigMgr.h"

#endif  // __FULL_DASI__

namespace DASI
{
    typedef std::list<std::string> CTPLATFORMLIST;
    typedef CTPLATFORMLIST::iterator CTPLATFORMLIST_ITER;

    typedef struct _tagCTPlatformVersionInfo
	{
        long lSystemReleaseMajorReleaseNumber;
        long lSystemReleaseMinorReleaseNumber;
        long lSystemReleaseSubMinorReleaseNumber;
        long lSystemReleaseBuildNumber;
        long lSystemServicePackNumber;
        long lSystemServicePackBuildNumber;
        long lSystemFeaturePackNumber;
        long lSystemFeaturePackBuildNumber;
    } CTPLATFORMVERSIONINFO;

    /**
     * The ICTNode object is returned when an application calls the GetAllNodes() or GetNode()
     * API calls from the CCTDomain.  An application uses this object to obtain and configure
     * information specific to the node.
     *
     * @exception CCTDasiException
     *
     * @version 1.0
     * @stereotype interface
     */

    class DLGDASICLIENT_API ICTNode
    {
    public:
        /**
         * The ICCTNode destructor releases the resources the object has aquired
         * during it's operational lifecycle.
         *
         * @brief Destructor
         *
         * @version 1.0
         * @since 1.0
         */

        virtual ~ICTNode() {};


#ifdef  __FULL_DASI__

        /**
         * An application would call this function to obtain an instaniated
         * object of type ICTPreConfigMgr.  The ICTPreConfigMgr class is used
         * to manage the configuration templates within the domain.
         *
         * @return ICTPRECONFIGMGR : A smart pointer to ICTPreConfigMgr object.
         *
         * @exception CCTDasiException
         *
         * @version 1.0
         * @since 1.0
         */

        virtual ICTPreConfigMgr* GetPreConfigMgr() = 0;

#endif  // __FULL_DASI__


        /**
         * @brief Retrieves the number of installed boards within the node..
         *
         * @return long : Value indicating the number of installed boards.
         *
         * @exception CCTDasiException
         *
         * @version 1.0
         * @since 1.0
         */

        virtual long GetNumberOfInstalledBoards() = 0;


#ifdef  __FULL_DAS__
        
        /**
         * @brief Retrieves the number of shelves within the node..
         *
         * @return long : Value indicating the number of shelves within the node.
         *
         * @exception CCTDasiException
         *
         * @version 1.0
         * @since 1.0
         */

        virtual const long GetNumberOfShelves () = 0;


        /**
         * @brief Retrieves node name.
         *
         * @return A reference to a constant string : Name of the node.
         *
         * @exception CCTDasiException
         *
         * @version 1.0
         * @since 1.0
         */

        virtual const std::string GetName() = 0;


        /**
         * @brief Retrieves node description.
         *
         * @return A reference to a string : Description of the node.
         *
         * @exception CCTDasiException
         *
         * @version 1.0
         * @since 1.0
        */

        virtual const std::string GetDescription() = 0;

#endif  // __FULL_DASI__


        /**
         * @brief Retieves a ICTBoard object by the Board ID.
         *
         * @param rBoardID a reference to a constant long : Id of the board.
         *
         * @return ICTBOARD : A pointer to a ICTBoard object.
         *
         * @exception CCTDasiException
         *
         * @version 1.0
         * @since 1.0
         */

        virtual ICTBoard* GetBoardByID(/*in*/ const AUID& rBoardID) = 0;


        /**
         * @brief Retrieve all installed boards within the node..
         *
         * @return ICTBOARDLIST : A pointer to an std::list<ICTBoard*> of pointers to ICTBoard objects.
         *
         * @exception CCTDasiException
         *
         * @version 1.0
         * @since 1.0
         */

        virtual ICTBOARDLIST* GetAllInstalledBoards() = 0;


#ifdef  __FULL_DASI__

        /**
         * @brief Retrieves node IP Address.
         *
         * @return A reference to a string : Node IP Address.
         *
         * @exception CCTDasiException
         *
         * @version 1.0
         * @since 1.0
         */

        virtual const std::string GetIPAddress() = 0;

#endif  // __FULL_DASI__


        /**
         * @brief Retrieves system release version.
         *
         * @return A CTPLATFORMVERIONINFO structure : Structure containing versin info.
         *
         * @exception CCTDasiException
         *
         * @version 1.0
         * @since 1.0
         */

        virtual const CTPLATFORMVERSIONINFO GetSystemReleaseVersionInfo() = 0;


#ifdef  __FULL_DASI__

        /**
         * @brief Retrieves operating system name.
         *
         * @return A reference to a string : Operating system name.
         *
         * @exception CCTDasiException
         *
         * @version 1.0
         * @since 1.0
         */

        virtual const std::string GetOperatingSystemInfo() = 0;


        /**
         * @brief Retrieves automatic startup mode of the node.
         *
         * @return A constant short : Auto startup mode of the node.
         *
         *      const	short   AUTO_NONE  		= 0;
         *      const	short   AUTO_START      = 1;
         *      const	short   AUTO_DETECT	    = 2;
         *      const	short   AUTO_INIT       = 3;
         *
         * @exception CCTDasiException
         *
         * @version 1.0
         * @since 1.0
         */

        virtual const short GetAutoStartSetting() = 0;


        /**
         * @brief Retrieves the ICTBoard object with repect to the clocking agent.
         *
         * @param rClockAgentID a reference to a constant long : Id of the clocking agent.
         *
         * @return ICTBoard* : A pointer to a ICTBoard object.
         *
         * @exception CCTDasiException
         *
         * @version 1.0
         * @since 1.0
         */

        virtual ICTBoard* GetBoardByClockAgentID(/*in*/ const AUID& rClockAgentID) = 0;


        /**
         * @brief Retrieves all boards of a particular CTPlatform within the node.
         *
         * @param rszCTPlatform a reference to a constant string : CTPlatform identification.
         *
         * @return ICTBOARDLIST* : A pointer to an std::list<ICTBoard*> of pointers to ICTBoard objects.
         *
         * @exception CCTDasiException
         *
         * @version 1.0
         * @since 1.0
         */

        virtual ICTBOARDLIST* GetAllBoardsByCTPlatform(std::string& rszCTPlatform) = 0;


        /**
         * @brief Retrieves all boards within the node.
         *
         * @return ICTBOARDLIST* : A pointer to an std::list<ICTBoard*> of pointers to ICTBoard objects.
         *
         * @exception CCTDasiException
         *
         * @version 1.0
         * @since 1.0
         */

        virtual ICTBOARDLIST* GetAllBoards() = 0;


        /**
         * @brief Retrieves all installed boards by CTPlatform within the node.
         *
         * @param rszCTPlatform a reference to a constant string : CTPlatform identification.
         *
         * @return ICTBOARDLIST* : A pointer to an std::list<ICTBoard*> of pointers to ICTBoard objects.
         *
         * @exception CCTDasiException
         *
         * @version 1.0
         * @since 1.0
         */

        virtual ICTBOARDLIST* GetAllInstalledBoardsByCTPlatform(std::string& rszCTPlatform) = 0;


        /**
         * @brief Retrieves the CTPlatforms supported within the node..
         *
         * @return CTPLATFORMLIST : An std::list<string> of suppoorted CTPlatforms.
         *
         * @exception CCTDasiException
         *
         * @version 1.0
         * @since 1.0
         */

        virtual CTPLATFORMLIST GetSupportedCTPlatforms() = 0;


        /**
         * @brief Retrieves an ICTBus objects associated with a board.
         *
         * @return ICTBus* : A pointer to an ICTBus object associated with a board.
         *
         * @exception CCTDasiException
         *
         * @version 1.0
         * @since 1.0
         */

        virtual ICTBus* GetCTBusByBoardID(const AUID& rBoardID) = 0;


        /**
         * @brief Retrieves a list of ICTBus objects within the node.
         *
         * @return ICTBUSLIST* : An std::list<ICTBus*> of pointers to ICTBus objects.
         *
         * @exception CCTDasiException
         *
         * @version 1.0
         * @since 1.0
         */

        virtual ICTBUSLIST* GetAllCTBuses() = 0;


        /**
         * @brief Updates node description.
         *
         * @param rNodeDesc a reference to a constant string : Description of the node.
         *
         * @exception CCTDasiException
         *
         * @version 1.0
         * @since 1.0
         */

        virtual void SetDescription(/*in*/ const std::string& rNodeDesc) = 0;


        /**
         * @brief Updates node name.
         *
         * @param rNodeName a reference to a constant string : Name of the node.
         *
         * @exception CCTDasiException
         *
         * @version 1.0
         * @since 1.0
         */

        virtual void SetName(/*in*/ const std::string& rNodeName) = 0;


        /**
         * @brief Updates automatic startup mode of the node.
         *
         * @param nAutoStart a constant short : Auto startup mode of the node.
         *
         *      const	short   AUTO_NONE  		= 0;
         *      const	short   AUTO_START      = 1;
         *      const	short   AUTO_DETECT	    = 2;
         *      const	short   AUTO_INIT       = 3;
         *
         * @exception CCTDasiException
         *
         * @version 1.0
         * @since 1.0
         */

        virtual void SetAutoStartSetting(const short nAutoStart) = 0;


        /**
         * @brief Starts all the boards within the node.
         *
         * @exception CCTDasiException
         *
         * @version 1.0
         * @since 1.0
         */

        virtual void Start() = 0;


        /**
         * @brief Starts a list of boards within the node.
         *
         * @param rBoardList a reference to a std::list<ICTBoard*> of ICTBoard objects
         *
         * @exception CCTDasiException
         *
         * @version 1.0
         * @since 1.0
         */

        virtual void Start(/*in*/ ICTBOARDLIST& rBoardList) = 0;


        /**
         * @brief Stops all the boards within the node.
         *
         * @exception CCTDasiException
         *
         * @version 1.0
         * @since 1.0
         */

        virtual void Stop() = 0;


        /**
         * @brief Stops a list of boards within the node.
         *
         * @param rBoardList a reference to a std::list<ICTBoard*> of ICTBoard objects
         *
         * @exception CCTDasiException
         *
         * @version 1.0
         * @since 1.0
         */

        virtual void Stop(/*in*/ ICTBOARDLIST& rBoardList) = 0;

#endif  // __FULL_DASI__

    private:

        /** @link dependency
         * @stereotype instantiate*/
        /*#  ICTBus lnkICTBus; */

        /** @link dependency
         * @stereotype instantiate*/
        /*#  ICTBoard lnkICTBoard; */

        /** @link dependency
         * @stereotype instantiate*/
        /*#  ICTPreConfigMgr lnkICTPreConfigMgr; */

    }; // end class ICTNode

    /// List of pointers to ICTNode objects.
    typedef std::list<ICTNode*> ICTNODELIST;
    typedef ICTNODELIST::iterator ICTNODELIST_ITER;

} // end namespace DASI
#endif //ICTNODE_H




