/*
    Copyright (C) 2000-2002.  Intel Corporation.

    All Rights Reserved.  All names, products,
    and services mentioned herein are the trademarks
    or registered trademarks of their respective organizations
    and are the sole property of their respective owners.
 */


/*
*    AUTO-VERSIONING HEADER  DO NOT HAND MODIFY
*    ===================================================================
*    %name:          ICTPreConfigMgr.h %
*    %version:       19 %
*    %instance:      hsw_1 %
*    %created_by:    klotzw %
*    %date_modified: Wed Jul 03 19:19:46 2002 %
*    ===================================================================
*/

#ifndef __ICTPRECONFIGMGR_H__
#define __ICTPRECONFIGMGR_H__

#ifndef lint
static char    *_hsw_1_ICTPreConfigMgr_h = "@(#) %filespec: ICTPreConfigMgr.h-19 %  (%full_filespec: ICTPreConfigMgr.h-19:incl:hsw#1 %)";
#endif

#include <string>

#include "dlgctypes.h"

#include "DlgDasiClientLib.h"
#include "ICTBoard.h"

namespace DASI
{
    /**
     * The ICTConfigTemplateMgr object is instantiated from the CCTDomain object.
     * The ICTConfigTemplateMgr is used by the application to create, add, query,
     * and delete configuration templates within the system.  Once an application
     * creates and adds a configuration template to the system the detection system
     * will use this configuration template to match product insertion with configuration
     * information thus allowing application to add a list of configurations they expect
     * to utilize in the future.
     *
     * @stereotype interface
     *
     * @author  William Klotz
     * @version 1.0
     * @since 1.0
     */
    class DLGDASICLIENT_API ICTPreConfigMgr
    {
    public:
        /**
         * The ICTPreConfigMgr destructor releases the resources the object has aquired
         * during it's operational lifecycle.
         *
         * @version 1.0
         * @since 1.0
         */

        virtual ~ICTPreConfigMgr() {};


        /**
       	 * Saves the configuration template into the data store.
         *
       	 * @param rConfigurationTemplate a reference to a constant ICTBoard& containing the configuration template information to
         *                be used by the detection sub-system.
         *
         * @exception CCTDasiException
         *
         * @version 1.0
         * @since 1.0
         */

        virtual void AddConfigurationTemplate(/*in*/ const ICTBoard& rConfigurationTemplate) = 0;

        /**
       	 * Deletes the configuration template from the data store.
         *
       	 * @param rConfigurationTemplate a reference to a constant ICTBoard& containing the configuration template information to
         *                be used by the detection sub-system.
         *
         * @exception CCTDasiException
         *
         * @version 1.0
         * @since 1.0
         */

        virtual void DeleteConfigurationTemplate(/*in*/ const ICTBoard& rConfigurationTemplate) = 0;


       	/**
       	 * Retrieves all the configuration templates in the data store.
       	 *
       	 * @return A pointer to an std::list of pointers to ICTBoard objects containing the
       	 *         configuration template information to be used by the detection sub-system.
         *
       	 * @exception CCTDasiException
         *
         * @version 1.0
         * @since 1.0
       	 */

        virtual ICTBOARDLIST* GetAllConfigurationTemplates() = 0;


        /**
       	 * Retrieves all the configuration template for a specific CTPlatform in the data store.
         *
         * @param A reference to a constant std::string& containing the FCD file.
         *
       	 * @return A pointer to an std::list of pointers to ICTBoard objects containing the
       	 *         configuration template information to be used by the detection sub-system.
         *
         * @exception CCTDasiException
         *
         * @version 1.0
         * @since 1.0
         */

        virtual ICTBOARDLIST* GetAllConfigurationTemplatesByCTPlatform(/*in*/ const std::string& rszCTPlatform) = 0;


       	/**
       	 * Creates the configuration template for a specific CTPlatform in the data store.
         *
         * @param A reference to a constant std::string& containing the FCD file.
         *
       	 * @return A pointer to an ICTBoard object containing no information at this point.
         *
         * @exception CCTDasiException
         *
         * @author  William Klotz
         * @version 1.0
         * @since 1.0
         */

        virtual ICTBoard* CreateConfigurationTemplate() = 0;

    private:

        /** @link dependency
         * @stereotype instantiate*/
        /*#  ICTBoard lnkICTBoard; */
    };

    typedef std::list<ICTPreConfigMgr*> ICTPRECONFIGMGRLIST;
    typedef ICTPRECONFIGMGRLIST::iterator ICTPRECONFIGMGRLIST_ITER;
}

#endif //ICTPRECONFIGMGR_H




