/****************************************************************************
 *		Copyright (c) 2000 Dialogic Corp.
 *		All Rights Reserved.
 *
 *		THIS IS UNPUBLISHED PROPRIETARY SOURCE CODE OF Dialogic Corp.
 *		The copyright notice above does not evidence any actual or
 *		intended publication of such source code.
 ***************************************************************************/

/****************************************************************************
 * FILE:        agc_def.h
 * AUTHOR:
 * ORG:         Dialogic Corporation
 * ORIG-DATE:   Vijay Guduru
 * LAST-MOD:
 * PURPOSE:     The header file for  AGC3.x unit interface
 *
 * HISTORY:
 * Date        Who	    	Description
 * 12/16/02    Himanshu    Changed AGC_LO_AGC_THRESHOLD from -54 to -40
 * 2/21/01     Vijay       Changed  AGCK from -13.6 -> -19.6
 *                         Changed  AGCMAXGain from 21  -> 11.6
 *12/06/2000   Vijay       Changed loth factor from 6->4
 *                         Changed low threshold 0.0100->0.002
 *
 ***************************************************************************/


#define     AGC_ON   1
#define     AGC_OFF  0


/*-------AGC defines-----------------------------------------------*/
#define		FLT2FRAC			    8388608     /* pow(2,23) floating to Fractional converting constant */
#define		AGC_ONE      			0x7FFFFF	/*Float ONE*/
#define		AGC_HI_THRESHOLD		0.0186*FLT2FRAC      /*pow(10.0,-34.6/20)*/ /*-34.6 dB Average*/
#define		AGC_TONE_AVGLEV_OFFSET  0.8913*FLT2FRAC      /*pow(10.0,-1.0/20)*/  /*Power to average offset for tones*/
#define		AGC_NOISE_SPEECH_THRESH 0.1778*FLT2FRAC      /*pow(10.0,-15.0/20)*/
									/*Difference between voice & non-voice*/
#define		AGC_GAIN_SCALE			32.0          	      /*pow(2.0,5)*/         /*Gain Scale*/
#define		AGC_INIT_GAIN 			(1.0/AGC_GAIN_SCALE)*FLT2FRAC	/*Initial Gain*/
#define		AGC_DITH_D_SEED			0.12347*FLT2FRAC	/*Seed into rand. seq. generator*/
#define		AGC_LA_MAXSIZE		  	4		/*Maximum size of history in msec*/
#define		AGC_MSEC_SIZE 			8 		/*1msec size in samples*/


/*status Word bits*/
#define		AGC_TONE_PROTECTION_EN		0x000001	/*Enable Mask for the Tone Protection*/
#define		AGC_QEM_EN			        0x000002	/*Enable Mask for quant. error masking*/
#define		AGC_DEBUG_EN			    0x000004	/*Enable Mask for debugging mode of AGC*/
/*-----------------------------------------------*/


/*-------AGC Const Default Values----------------------*/
#define		AGC_STATUS_WORD	       	AGC_QEM_EN
#define		AGC_BUFLEN	       	    AGC_LA_MAXSIZE		/*LA Buffer Size in msec*/

/*#define	AGC_LO_AGC_THRESHOLD	0.0020*FLT2FRAC	*/	/*pow(10.0,-54.0/20)*/ /*-54 dB Average*/
#define		AGC_LO_AGC_THRESHOLD	0.010*FLT2FRAC  /*pow(10.0,-40.0/20)*/ /*-40 dB Average*/

#define		AGC_K		       	   (0.104712854/AGC_GAIN_SCALE)*FLT2FRAC /* -19.6 dB Average */
                          /*(0.2089296/AGC_GAIN_SCALE)*FLT2FRAC -> -13.6 dB Average*/
									/*pow(10.0,-13.6/20)/AGC_GAIN_SCALE*/	/*-13.6 dB Average*/
#define		AGC_INIT_AVGLEV_OFFSET 	0.70794578*FLT2FRAC
									/*pow(10.0,-3.0/20)*/ /*Initial Power to average offset*/
#define	AGC_FIRST_PHRASE_LENGTH 	500			   /*The length of the first phrase*/
#define	AGC_NFLOR_LOW_THRESH	    0.00012589*FLT2FRAC 		/*pow(10.0,-78.0/20)*/ /*Nflor can not be below it*/
#define	AGC_MAX_GAIN	    FLT2FRAC*0.118809186            /* (pow(10.0,11.6/20)/32)=0.118809186 */
                            /*(AGC_K)/(AGC_HI_THRESHOLD)*FLT2FRAC	  */
									 /*Limit on the Max Gain - K/hith for AGC*/
#define  AGC_ALCMAXGAIN			    (2.0/AGC_GAIN_SCALE)*FLT2FRAC		/*Maximum Gain for the ALC = 6dB*/
#define	AGC_INIT_GAIN_HANG     	    10			   /*Initial time before gain is applied*/
#define	AGC_A		       	        0.8*FLT2FRAC			/*favg coefficient*/
#define	AGC_D		       	        0.99*FLT2FRAC   			/*savg decay filter coefficient*/
#define	AGC_VD			            0.999*FLT2FRAC   		   /*vsavg decay filter coefficient*/
#define	AGC_NF_DEC			        0.9*FLT2FRAC			/*nflor decay filter coefficient*/
#define	AGC_NF_ATTFAST			    0.99*FLT2FRAC		/*nflor fast attack filter coefficient*/
#define	AGC_NF_ATTSLOW			    0.9999*FLT2FRAC		/*nflor slow attack filter coefficient*/
#define	AGC_CLIPLIM			        1.0/AGC_GAIN_SCALE*FLT2FRAC
									/*Clipping Limit for peak/avg compression */
#define	AGC_MEM_INIT			    (1.0/10.0)*FLT2FRAC 		/*Initial Memory Size in msec*/
#define	AGC_NF_POW_INVTIMETHRESH	(1.0/400.0)*FLT2FRAC	/*nflor depend on powlev not earlier that this time*/
#define	AGC_LOTH_FACTOR			    4		/*nflor to loth factor*/
#define	AGC_NF_FAVGFACTOR	    	(1.0/2.0)*FLT2FRAC		/*favg factor used in nflor*/
#define	AGC_SPEECH_THRESH		    (1.0/AGC_LOTH_FACTOR*AGC_NOISE_SPEECH_THRESH)
#define	AGC_GATE_HANG		     	200		/*hangover time for the gate for IPT*/
#define	AGC_SPIKE_MAXLEN		    50		/*maximum length of a spike*/
#define	AGC_SPMIN_DEC			    (0.7)*FLT2FRAC		/*speech_min decay filter coefficient*/
#define	AGC_SPMIN_ATT			    (0.99)*FLT2FRAC	/*speech_min attack filter coefficient*/
#define	AGC_GAIN_INC_SPEECH	        (0.01)*FLT2FRAC	/*gain_inc value during voice*/
#define	AGC_SPMIN_FACTOR		    (1.0/3.0)*FLT2FRAC	/*speech_min factor */
#define	AGC_INIT_POWLEV_HANG	    20		/*initial time before powlev is changed */
#define	AGC_MEM_RESET_THRESH	    (0.10)*FLT2FRAC		/*pow(10.0,-20.0/20)*/ /*reset mem. during first phrase */
						/*if curr. pow. is that higher then estimate.*/
#define	AGC_MEM_SIL_RESET		   (1.0/50.0)*FLT2FRAC
								/*memory size reset to during silence for IPT */
#define	AGC_MEM_MAX_SIZE		  (1.0/300.0)*FLT2FRAC		/*max size of memory for IPT with no NBSD	*/
#define	AGC_GAIN_COMP_ATT		  0.1*FLT2FRAC		/*acceleration of the peak/average compression return*/
#define	AGC_GAIN_COMP_RESET	      0.001*FLT2FRAC		/*starting rate of the peak/average compression return*/
#define	AGC_AVGLEV_OFF_DEC	      (0.0004608626)*FLT2FRAC	/*pow(AGC_TONE_AVGLEV_OFFSET/AGC_INIT_AVGLEV_OFFSET,1.0/AGC_FIRST_PHRASE_LENGTH)-1.0*/
#define	AGC_MAX_QUANTDELTA	      0.00048828125*FLT2FRAC	/*pow(2.0,-11)*/	/*Upper limit for the adapt. quant. level*/
#define	AGC_MIN_QUANTDELTA	      0.00006103515625*FLT2FRAC	/*pow(2.0,-14)*/
								/*Lower limit for the adapt. quant. level*/
#define	AGC_QUANTLEV_SCALE	     0.25*FLT2FRAC		/*scale factor for the dither relat. to quant. lev*/
/*-----------------------------------------------*/


/*-------Offsets to Consts------------------------------*/
#define		oAGCstWord_const			0
#define		oAGCbuflen_const			1
#define		oAGCmaxquantdelta_const		2
#define		oAGCminquantdelta_const		3
#define		oAGCa_const					4
#define		oAGCd_const					5
#define		oAGCnffavgfactor_const		6
#define		oAGCnfattslow_const			7
#define		oAGCnfattfast_const			8
#define		oAGCnfdec_const				9
#define		oAGCnflorlowthresh_const	10
#define		oAGCspeechthresh_const		11
#define		oAGC1stphraselength_const	12
#define		oAGCnfpowinvtimethresh_const 13
#define		oAGClowthresh_const			14
#define		oAGClothfactor_const		15
#define		oAGCgatehang_const			16
#define		oAGCspikemaxlen_const		17
#define		oAGCinitavglevoff_const		18
#define		oAGCspminatt_const			19
#define		oAGCspmindec_const			20
#define		oAGCgainincsp_const			21
#define		oAGCspminfactor_const		22
#define		oAGCinitgainhang_const		23
#define		oAGCvd_const				24
#define		oAGCmeminit_const			25
#define		oAGCmemresetthresh_const	26
#define		oAGCinitpowlevhang_const	27
#define		oAGCmemsilreset_const		28
#define		oAGCmemmaxsize_const		29
#define		oAGCavglevoffdec_const		30
#define		oAGCmaxgain_const			31
#define		oAGCk_const					32
#define		oAGCgaincompatt_const		33
#define		oAGCcliplim_const			34
#define		oAGCgaincompreset_const		35
#define		oAGCquantlevscale_const		36
#define		AGC_CONSTTBL_SIZE			37	/*the size - has to be last*/
/*-----------------------------------------------*/



/*--------Offsets to Vars------------------------*/
#define	oAGCctrlWord_var		0
#define	oAGCquantlev_var		1
#define	oAGCavg_var			    2
#define	oAGCfavg_var			3
#define	oAGCsavg_var			4
#define	oAGCnflor_var			5
#define	oAGCavglev_var			6
#define	oAGCgateopencnt_var	    7
#define	oAGCspeechcnt_var		8
#define	oAGCinvpowlevcnt_var	9
#define	oAGCloth_var			10
#define	oAGCcounter_var			11
#define	oAGCsavinvpowlevcnt_var	12
#define	oAGCsavpowlev_var		13
#define	oAGCpowlev_var			14
#define	oAGCsavgain_var			15
#define	oAGCgain_var			16
#define	oAGCspeechmin_var		17
#define	oAGCgaininc_var			18
#define	oAGCvsavg_var			19
#define	oAGCfutpow_var			20
#define	oAGCfutmaxsample_var 	21
#define	oAGCavglevoff_var		22
#define	oAGCgaincomp_var		23
#define	oAGCagcgain_var			24
#define	oAGCdither_var			25
#define AGC_VARTBL_SIZE			26	/*the size - has to be last*/
/*----------------------------------------------*/


/* AGC parameter */
typedef struct
{
	int StatusWord;			/*Status Word*/
	int buf_len;			/*LA Buffer Size in msec*/
	int max_quantdelta;	    /*Upper limit for the adapt. quant. level*/
	int min_quantdelta;	    /*Lower limit for the adapt. quant. level*/
	int a;					/*favg coefficient*/
	int d;					/*savg decay filter*/
	int nf_favgfactor;      /*favg factor used in nflor*/
	int nf_attslow;			/*nflor slow attack filter coefficient*/
	int nf_attfast;			/*nflor fast attack filter coefficient*/

	int nf_dec;			    /*nflor decay filter*/
	int nflor_low_thresh;	/*Nflor low threshold*/
	int speech_thresh; 		/*Difference between speech and background noise*/
	int first_phrase_length;	/*The length of the first phrase in msec*/
	int pow_invtimethresh;     /*nflor depend on powlev not earlier that this time*/
	int low_threshold;	/*Upper limit for the noise floor estimate*/
	int loth_factor; 		/*nflor to loth factor*/
	int gate_hang; 			/*hangover time for the gate in msec*/
	int spike_maxlen;		/*maximum length of a spike in msec*/
	int agc_init_avglev_offset;         /* Initial Power to average offset*/
	int agc_spmin_att;                   /*speech_min attack filter coefficient*/
	int agc_spmin_dec;		   /*speech_min decay filter coefficient */
	int gain_inc_speech;   	 /*gain_inc value during voice*/
	int agc_spmin_factor;     /*speech_min factor */
	int init_gain_hang;	    /*Initial time before gain is applied in msec*/
	int agc_vd        ;	    /*vsavg decay filter coefficient*/
	int MEM_init;			/*Initial Memory Size in msec*/
	int mem_reset_thresh;
	int init_powlev_hang;	/*initial time before powlev is changed in msec*/

	int MEM_sil_reset;	/*memory size reset to during silence*/
	int MEM_max_size;		/*max size of memory*/
	int agc_avglev_off_dec;
	int max_gain;			/*Limit on the Max Gain - K/hith for AGC*/
	int k;			/*Target Output Level*/
	int gain_comp_att;	/*acceleration of the peak/average compression return*/
	int ClipLim;			/*Clipping Limit for peak/avg compression */
	int gain_comp_reset;	/*starting rate of the peak/average compression return*/
	int quantlev_scale;	/*scale factor for the dither relat. to quant. lev*/
}agcParm_t;

typedef	struct {
        int  *pAgcK;         /*Pointer to AGCK table memory            */
        int  *pAgcV;         /*Pointer to an external memory block     */
}agcMem_t;

typedef struct {
        int samplAvail;       /* Number of samples available for AGC                  */
        int *pBuf;            /* Pointer to a buffer to contain linear PCM samples    */
        int samplUsed;        /* Number of samples used by AGC(number of output samples)      */
}PCMData_t;

typedef struct
{
   agcMem_t agcMem;
   PCMData_t pcmData;
}AGC_t;

/*
 *Function prototypes
 */
extern void agcKCreate(agcParm_t *, agcMem_t *);
extern void agcVCreate(agcMem_t *);
extern void agcDelete(void);
extern void agcInit(void);
extern void agcInvoke(agcMem_t *, PCMData_t *);
extern void agcInitParms2Defaults(agcParm_t* ptrParm);
extern void alcInitParms2Defaults(agcParm_t* ptrParm);




















