
/*
 * This file was automatically generated from casdefs.txt.
 * Author: "Sean W. Marrinan"
 * Version: "Revision A.9"
 * Date: Fri Oct  5 14:16:39 2001
 * The output was written to cas_defs.h.
 * Produced by mmdl translator version 1.3.
 */

#if !defined(_cas_defs_h_)
#define _cas_defs_h_ 1
/* This file describes the list of Mercury messages, parameters and equates 
 * supported by the Mercury Channel Associated Signaling Component and its 
 * Instances. */
 
/* The Signal Id is fully defined in the Mercury Signal Detector CIS, refernce #7. */
 
#define	SIG_CAT_CAS		0xCA 
 /* This is the category of standard CAS signals*/

/* 
 *  The following IDs are standard CAS signal id field identifiers. These are used  
 * to build by combining with the environment though the sub-category fields. 
  */
enum 	CASStdSigIDFld {  
	SIG_ID_ANSWER,  
	SIG_ID_BLOCKING, 
/*  The outgoing trunk interface will often receive charge information received as charge pulses.  */ 
/*  These pulses are of a short duration and are typically received at a frequency of no greater */ 
/*  than 1/10 of a minute (6 seconds) */ 
 	SIG_ID_CHARGE_PULSE, 
 	SIG_ID_CLEAR_BACK, 
 	SIG_ID_CLEAR_FORWARD, 
/*  Hookflash/Recall is commonly used to recall an operator, initiate a transfer, place a call on hold, etc. */ 
 	SIG_ID_HOOKFLASH, 
 	SIG_ID_IDLE, 
 	SIG_ID_SIEZE, 
 	SIG_ID_SEIZE, 
 	SIG_ID_SEIZE_ACK, 
/*  A wink is commonly used to request ANI */ 
 	SIG_ID_WINK, 
/* A wink-start pulse is commonly used in T1 CAS protocols as an acknowledge to the channel seizure.*/ 
 	SIG_ID_WINK_START 
}; 


/* 
 * Channel Associated Signaling Component Type Definition 
 */
/* The CAS uses messages from the Standard Kernel Message Set, the Standard 
 * Component Message Set , and the TSC Component Message Set. */
/* 
 * 	Mercury Kernel Standard Message Set defined in mercdefs.doc 
 * 	*/
/* 
 * 	Standard Component Message Set defined in stddefs.doc. 
 * 	*/

/*
 * COMPONENT CAS (value = 0x14) uses:
 *	MESSAGE Std_MsgError
 *	MESSAGE Std_MsgAck
 *	MESSAGE Std_MsgInit
 *	MESSAGE Std_MsgInitCmplt
 *	MESSAGE Std_MsgExit
 *	MESSAGE Std_MsgExitCmplt
 *	MESSAGE Std_MsgGetParm
 *	MESSAGE Std_MsgGetParmCmplt
 *	MESSAGE Std_MsgSetParm
 *	MESSAGE Std_MsgSetParmCmplt
 *	MESSAGE Std_MsgComtest
 *	MESSAGE Std_MsgComtestCmplt
 */
/* 
 * CAS Message Definitions
 */

#define CAS_MsgDefTransition_SignalId	0x380000	/* 3670016 */
typedef	UInt32	CAS_MsgDefTransition_SignalId_t;

#define CAS_MsgDefTransition_PreTransCode	0x200004	/* 2097156 */
typedef	UInt8	CAS_MsgDefTransition_PreTransCode_t;

#define CAS_MsgDefTransition_PostTransCode	0x200005	/* 2097157 */
typedef	UInt8	CAS_MsgDefTransition_PostTransCode_t;

#define CAS_MsgDefTransition_PreTransInterval	0x280006	/* 2621446 */
typedef	UInt16	CAS_MsgDefTransition_PreTransInterval_t;

#define CAS_MsgDefTransition_PostTransInterval	0x280008	/* 2621448 */
typedef	UInt16	CAS_MsgDefTransition_PostTransInterval_t;

/*
 * CAS_MsgDefTransition (value = 0x1400) is an input message
 * for component CAS.
 */


typedef struct {
	UInt32	SignalId;
	UInt8	PreTransCode;
	UInt8	PostTransCode;
	UInt16	PreTransInterval;
	UInt16	PostTransInterval;
} CAS_MsgDefTransition_t;

#define CAS_MsgDefTransition_get(msgPtr, structAddr, offset)	\
		    qMsgVarFieldGet((msgPtr), 5, &(offset),	\
			(CAS_MsgDefTransition_SignalId), &((structAddr)->SignalId),	\
			(CAS_MsgDefTransition_PreTransCode), &((structAddr)->PreTransCode),	\
			(CAS_MsgDefTransition_PostTransCode), &((structAddr)->PostTransCode),	\
			(CAS_MsgDefTransition_PreTransInterval), &((structAddr)->PreTransInterval),	\
			(CAS_MsgDefTransition_PostTransInterval), &((structAddr)->PostTransInterval))


#define CAS_MsgDefTransition_put(msgPtr, structAddr, offset)	\
		    qMsgVarFieldPut((msgPtr), 5, &(offset),	\
			(CAS_MsgDefTransition_SignalId), &((structAddr)->SignalId),	\
			(CAS_MsgDefTransition_PreTransCode), &((structAddr)->PreTransCode),	\
			(CAS_MsgDefTransition_PostTransCode), &((structAddr)->PostTransCode),	\
			(CAS_MsgDefTransition_PreTransInterval), &((structAddr)->PreTransInterval),	\
			(CAS_MsgDefTransition_PostTransInterval), &((structAddr)->PostTransInterval))


#define CAS_MsgDefTransition_Size		10

#define CAS_MsgDefTransition	0x1400	/* 5120 */
/* This message directs a CAS component to add a CAS Transition Signal 
 * definition to a signal set. Once the signal has been defined, it may be 
 * activated, or made available for transmission or detection by using the 
 * command MsgEnableSignal. Message Definition Item Description Range/Units 
 * SignalId Identifies the CAS Signal to define. N/A PreTransCode The code 
 * which must be transmitted prior to transition. The 8-bit value is composed 
 * of 4 bits for a code mask (most significant), and 4 bits for representing 
 * the signal code (least significant). The mask indicates which of the 
 * signaling bits are significant. The significant signal is constructed with 
 * the logical ORing of the mask bits and the signal bits. The "don't care" 
 * bits are left as zero in the mask, and the significant bits are set to one. 
 * (See table in section 9.4 for a list of Signal Code Identifiers.) 0x00 
 * through 0xFF PostTransCode The code which must be transmitted after 
 * transition. The 8- bit value is composed of 4 bits for a code mask (most 
 * significant), and 4 bits for representing the signal code (least 
 * significant). The mask indicates which of the signaling bits are 
 * significant. The significant signal is constructed with the logical ORing of 
 * the mask bits and the signal bits. The "don't care" bits are left as zero in 
 * the mask, and the significant bits are set to one. (See table in section 9.4 
 * for a list of Signal Code Identifiers.) 0x00 through 0xFF PreTransInterval 
 * The minimum time for the duration of the pre-transition interval msec 
 * PostTransInterval The minimum time for the duration of the post-transition 
 * interval msec */

#define CAS_MsgDefPulse_SignalId	0x380000	/* 3670016 */
typedef	UInt32	CAS_MsgDefPulse_SignalId_t;

#define CAS_MsgDefPulse_OffPulseCode	0x200004	/* 2097156 */
typedef	UInt8	CAS_MsgDefPulse_OffPulseCode_t;

#define CAS_MsgDefPulse_OnPulseCode	0x200005	/* 2097157 */
typedef	UInt8	CAS_MsgDefPulse_OnPulseCode_t;

#define CAS_MsgDefPulse_PrePulseInterval	0x280006	/* 2621446 */
typedef	UInt16	CAS_MsgDefPulse_PrePulseInterval_t;

#define CAS_MsgDefPulse_PulseIntervalMin	0x280008	/* 2621448 */
typedef	UInt16	CAS_MsgDefPulse_PulseIntervalMin_t;

#define CAS_MsgDefPulse_PulseIntervalMax	0x28000a	/* 2621450 */
typedef	UInt16	CAS_MsgDefPulse_PulseIntervalMax_t;

#define CAS_MsgDefPulse_PulseIntervalNom	0x28000c	/* 2621452 */
typedef	UInt16	CAS_MsgDefPulse_PulseIntervalNom_t;

#define CAS_MsgDefPulse_PostPulseInterval	0x28000e	/* 2621454 */
typedef	UInt16	CAS_MsgDefPulse_PostPulseInterval_t;

/*
 * CAS_MsgDefPulse (value = 0x1401) is an input message
 * for component CAS.
 */


typedef struct {
	UInt32	SignalId;
	UInt8	OffPulseCode;
	UInt8	OnPulseCode;
	UInt16	PrePulseInterval;
	UInt16	PulseIntervalMin;
	UInt16	PulseIntervalMax;
	UInt16	PulseIntervalNom;
	UInt16	PostPulseInterval;
} CAS_MsgDefPulse_t;

#define CAS_MsgDefPulse_get(msgPtr, structAddr, offset)	\
		    qMsgVarFieldGet((msgPtr), 8, &(offset),	\
			(CAS_MsgDefPulse_SignalId), &((structAddr)->SignalId),	\
			(CAS_MsgDefPulse_OffPulseCode), &((structAddr)->OffPulseCode),	\
			(CAS_MsgDefPulse_OnPulseCode), &((structAddr)->OnPulseCode),	\
			(CAS_MsgDefPulse_PrePulseInterval), &((structAddr)->PrePulseInterval),	\
			(CAS_MsgDefPulse_PulseIntervalMin), &((structAddr)->PulseIntervalMin),	\
			(CAS_MsgDefPulse_PulseIntervalMax), &((structAddr)->PulseIntervalMax),	\
			(CAS_MsgDefPulse_PulseIntervalNom), &((structAddr)->PulseIntervalNom),	\
			(CAS_MsgDefPulse_PostPulseInterval), &((structAddr)->PostPulseInterval))


#define CAS_MsgDefPulse_put(msgPtr, structAddr, offset)	\
		    qMsgVarFieldPut((msgPtr), 8, &(offset),	\
			(CAS_MsgDefPulse_SignalId), &((structAddr)->SignalId),	\
			(CAS_MsgDefPulse_OffPulseCode), &((structAddr)->OffPulseCode),	\
			(CAS_MsgDefPulse_OnPulseCode), &((structAddr)->OnPulseCode),	\
			(CAS_MsgDefPulse_PrePulseInterval), &((structAddr)->PrePulseInterval),	\
			(CAS_MsgDefPulse_PulseIntervalMin), &((structAddr)->PulseIntervalMin),	\
			(CAS_MsgDefPulse_PulseIntervalMax), &((structAddr)->PulseIntervalMax),	\
			(CAS_MsgDefPulse_PulseIntervalNom), &((structAddr)->PulseIntervalNom),	\
			(CAS_MsgDefPulse_PostPulseInterval), &((structAddr)->PostPulseInterval))


#define CAS_MsgDefPulse_Size		16

#define CAS_MsgDefPulse	0x1401	/* 5121 */
/* This message directs a CAS component to add a CAS Pulse Signal definition 
 * to a signal set. Once the signal has been defined, it may be activated, or 
 * made available for transmission or detection by using the command 
 * MsgEnableSignal. Message Definition Item Description Range/Units SignalId 
 * Identifies the CAS Signal to define. N/A OffPulseCode The code which must be 
 * transmitted prior to and after the pulse code. The 8-bit value is composed 
 * of 4 bits for a code mask (most significant), and 4 bits for representing 
 * the signal code (least significant). The mask indicates which of the 
 * signaling bits are significant. The significant signal is constructed with 
 * the logical ORing of the mask bits and the signal bits. The "don't care" 
 * bits are left as zero in the mask, and the significant bits are set to one. 
 * (See table in section 9.4 for a list of Signal Code Identifiers.) 0x00 
 * through 0xFF OnPulseCode The code which must be transmitted during the pulse 
 * interval. The 8-bit value is composed of 4 bits for a code mask (most 
 * significant), and 4 bits for representing the signal code (least 
 * significant). The mask indicates which of the signaling bits are 
 * significant. The significant signal is constructed with the logical ORing of 
 * the mask bits and the signal bits. The "don't care" bits are left as zero in 
 * the mask, and the significant bits are set to one. (See table in section 9.4 
 * for a list of Signal Code Identifiers.)The initial transition. 0x00 through 
 * 0xFF PrePulseInterval The minimum time for the duration of the pre-pulse 
 * interval msec PulseIntervalMin The minimum time for the duration of the 
 * pulse interval msec PulseIntervalMax The maximum time for the duration of 
 * the pulse interval msec PulseIntervalNom The nominal time for the duration 
 * of the pulse interval msec PostPulseInterval The minimum time for the 
 * duration of the end-of-pulse interval msec */

#define CAS_MsgDefTrain_SignalId	0x380000	/* 3670016 */
typedef	UInt32	CAS_MsgDefTrain_SignalId_t;

#define CAS_MsgDefTrain_OffPulseCode	0x200004	/* 2097156 */
typedef	UInt8	CAS_MsgDefTrain_OffPulseCode_t;

#define CAS_MsgDefTrain_OnPulseCode	0x200005	/* 2097157 */
typedef	UInt8	CAS_MsgDefTrain_OnPulseCode_t;

#define CAS_MsgDefTrain_PulseIntervalMin	0x280006	/* 2621446 */
typedef	UInt16	CAS_MsgDefTrain_PulseIntervalMin_t;

#define CAS_MsgDefTrain_PulseIntervalMax	0x280008	/* 2621448 */
typedef	UInt16	CAS_MsgDefTrain_PulseIntervalMax_t;

#define CAS_MsgDefTrain_PulseIntervalNom	0x28000a	/* 2621450 */
typedef	UInt16	CAS_MsgDefTrain_PulseIntervalNom_t;

#define CAS_MsgDefTrain_PreTrainInterval	0x28000c	/* 2621452 */
typedef	UInt16	CAS_MsgDefTrain_PreTrainInterval_t;

#define CAS_MsgDefTrain_InterPulseIntervalMin	0x28000e	/* 2621454 */
typedef	UInt16	CAS_MsgDefTrain_InterPulseIntervalMin_t;

#define CAS_MsgDefTrain_InterPulseIntervalMax	0x280010	/* 2621456 */
typedef	UInt16	CAS_MsgDefTrain_InterPulseIntervalMax_t;

#define CAS_MsgDefTrain_InterPulseIntervalNom	0x280012	/* 2621458 */
typedef	UInt16	CAS_MsgDefTrain_InterPulseIntervalNom_t;

#define CAS_MsgDefTrain_PostTrainInterval	0x280014	/* 2621460 */
typedef	UInt16	CAS_MsgDefTrain_PostTrainInterval_t;

#define CAS_MsgDefTrain_DigitCount	0x200016	/* 2097174 */
typedef	UInt8	CAS_MsgDefTrain_DigitCount_t;

#define CAS_MsgDefTrain_varStart	0x17

#define CAS_MsgDefTrain_Digit_PulseCount	0x200000	/* 2097152 */
typedef	UInt8	CAS_MsgDefTrain_Digit_PulseCount_t;

#define CAS_MsgDefTrain_Digit_Label	0x500000	/* 5242880 */
typedef	Char	CAS_MsgDefTrain_Digit_Label_t;


typedef struct {
	UInt8	PulseCount;
	Char	Label;
} CAS_MsgDefTrain_Digit_t;

#define CAS_MsgDefTrain_Digit_get(msgPtr, structAddr, offset)	\
		    qMsgVarFieldGet((msgPtr), 2, &(offset),	\
			(CAS_MsgDefTrain_Digit_PulseCount), &((structAddr)->PulseCount),	\
			(CAS_MsgDefTrain_Digit_Label), &((structAddr)->Label))


#define CAS_MsgDefTrain_Digit_put(msgPtr, structAddr, offset)	\
		    qMsgVarFieldPut((msgPtr), 2, &(offset),	\
			(CAS_MsgDefTrain_Digit_PulseCount), &((structAddr)->PulseCount),	\
			(CAS_MsgDefTrain_Digit_Label), &((structAddr)->Label))


#define CAS_MsgDefTrain_Digit_Size		2

#define CAS_MsgDefTrain_Digit	0	/* 0 */

/*
 * CAS_MsgDefTrain (value = 0x1402) is an input message
 * for component CAS.
 */


typedef struct {
	UInt32	SignalId;
	UInt8	OffPulseCode;
	UInt8	OnPulseCode;
	UInt16	PulseIntervalMin;
	UInt16	PulseIntervalMax;
	UInt16	PulseIntervalNom;
	UInt16	PreTrainInterval;
	UInt16	InterPulseIntervalMin;
	UInt16	InterPulseIntervalMax;
	UInt16	InterPulseIntervalNom;
	UInt16	PostTrainInterval;
	UInt8	DigitCount;
} CAS_MsgDefTrain_t;

#define CAS_MsgDefTrain_get(msgPtr, structAddr, offset)	\
		    qMsgVarFieldGet((msgPtr), 12, &(offset),	\
			(CAS_MsgDefTrain_SignalId), &((structAddr)->SignalId),	\
			(CAS_MsgDefTrain_OffPulseCode), &((structAddr)->OffPulseCode),	\
			(CAS_MsgDefTrain_OnPulseCode), &((structAddr)->OnPulseCode),	\
			(CAS_MsgDefTrain_PulseIntervalMin), &((structAddr)->PulseIntervalMin),	\
			(CAS_MsgDefTrain_PulseIntervalMax), &((structAddr)->PulseIntervalMax),	\
			(CAS_MsgDefTrain_PulseIntervalNom), &((structAddr)->PulseIntervalNom),	\
			(CAS_MsgDefTrain_PreTrainInterval), &((structAddr)->PreTrainInterval),	\
			(CAS_MsgDefTrain_InterPulseIntervalMin), &((structAddr)->InterPulseIntervalMin),	\
			(CAS_MsgDefTrain_InterPulseIntervalMax), &((structAddr)->InterPulseIntervalMax),	\
			(CAS_MsgDefTrain_InterPulseIntervalNom), &((structAddr)->InterPulseIntervalNom),	\
			(CAS_MsgDefTrain_PostTrainInterval), &((structAddr)->PostTrainInterval),	\
			(CAS_MsgDefTrain_DigitCount), &((structAddr)->DigitCount))


#define CAS_MsgDefTrain_put(msgPtr, structAddr, offset)	\
		    qMsgVarFieldPut((msgPtr), 12, &(offset),	\
			(CAS_MsgDefTrain_SignalId), &((structAddr)->SignalId),	\
			(CAS_MsgDefTrain_OffPulseCode), &((structAddr)->OffPulseCode),	\
			(CAS_MsgDefTrain_OnPulseCode), &((structAddr)->OnPulseCode),	\
			(CAS_MsgDefTrain_PulseIntervalMin), &((structAddr)->PulseIntervalMin),	\
			(CAS_MsgDefTrain_PulseIntervalMax), &((structAddr)->PulseIntervalMax),	\
			(CAS_MsgDefTrain_PulseIntervalNom), &((structAddr)->PulseIntervalNom),	\
			(CAS_MsgDefTrain_PreTrainInterval), &((structAddr)->PreTrainInterval),	\
			(CAS_MsgDefTrain_InterPulseIntervalMin), &((structAddr)->InterPulseIntervalMin),	\
			(CAS_MsgDefTrain_InterPulseIntervalMax), &((structAddr)->InterPulseIntervalMax),	\
			(CAS_MsgDefTrain_InterPulseIntervalNom), &((structAddr)->InterPulseIntervalNom),	\
			(CAS_MsgDefTrain_PostTrainInterval), &((structAddr)->PostTrainInterval),	\
			(CAS_MsgDefTrain_DigitCount), &((structAddr)->DigitCount))


#define CAS_MsgDefTrain_Size		23

#define CAS_MsgDefTrain	0x1402	/* 5122 */
/* This message directs a CAS component to add a CAS Pulse Train Signal 
 * definition to a signal set. Once the signal has been defined, it may be 
 * activated, or made available for transmission or detection by using the 
 * command MsgEnableSignal. Message Definition Item Description Range/Units 
 * SignalId Identifies the CAS Signal to define. N/A OffPulseCode The code 
 * which must be transmitted prior to and after the pulse code. The 8-bit value 
 * is composed of 4 bits for a code mask (most significant), and 4 bits for 
 * representing the signal code (least significant). The mask indicates which 
 * of the signaling bits are significant. The significant signal is constructed 
 * with the logical ORing of the mask bits and the signal bits. The "don't 
 * care" bits are left as zero in the mask, and the significant bits are set to 
 * one. (See table in section 9.4 for a list of Signal Code Identifiers.)The 
 * initial transition. 0x00 through 0xFF SignalId OnPulseCode The code which 
 * must be transmitted during the pulse interval. The 8-bit value is composed 
 * of 4 bits for a code mask (most significant), and 4 bits for representing 
 * the signal code (least significant). The mask indicates which of the 
 * signaling bits are significant. The significant signal is constructed with 
 * the logical ORing of the mask bits and the signal bits. The "don't care" 
 * bits are left as zero in the mask, and the significant bits are set to one. 
 * (See table in section 9.4 for a list of Signal Code Identifiers.)The initial 
 * transition.The final transition. 0x00 through 0xFF SignalId PulseIntervalMin 
 * The minimum time for the duration of the pulse interval msec 
 * PulseIntervalMax The maximum time for the duration of the pulse interval 
 * msec PulseIntervalNom The nominal time for the duration of the pulse 
 * interval msec PreTrainInterval The minimum time for the duration of the 
 * pre-train interval. This time may differ from the pre-pulse time of the 
 * component pulses. msec InterPulseIntervalMin The minimum time for the 
 * duration of the inter-pulse interval msec InterPulseIntervalMax The maximum 
 * time for the duration of the inter-pulse interval msec InterPulseIntervalNom 
 * The nominal time for the duration of the inter-pulse interval msec 
 * PostTrainInterval The minimum time for the duration of the end-of-train 
 * interval msec PulseCount The Number of pulses in the train which the Label 
 * identifies. Label This is used to identify a signal when it's detected. This 
 * is an ASCII character. */

#define CAS_MsgDefSequence_SignalId	0x380000	/* 3670016 */
typedef	UInt32	CAS_MsgDefSequence_SignalId_t;

#define CAS_MsgDefSequence_PulseTrainRef	0x380004	/* 3670020 */
typedef	UInt32	CAS_MsgDefSequence_PulseTrainRef_t;

#define CAS_MsgDefSequence_PreSeqInterval	0x280008	/* 2621448 */
typedef	UInt16	CAS_MsgDefSequence_PreSeqInterval_t;

#define CAS_MsgDefSequence_InterTrainIntervalMin	0x28000a	/* 2621450 */
typedef	UInt16	CAS_MsgDefSequence_InterTrainIntervalMin_t;

#define CAS_MsgDefSequence_InterTrainIntervalMax	0x28000c	/* 2621452 */
typedef	UInt16	CAS_MsgDefSequence_InterTrainIntervalMax_t;

#define CAS_MsgDefSequence_InterTrainIntervalNom	0x28000e	/* 2621454 */
typedef	UInt16	CAS_MsgDefSequence_InterTrainIntervalNom_t;

#define CAS_MsgDefSequence_PostSeqInterval	0x280010	/* 2621456 */
typedef	UInt16	CAS_MsgDefSequence_PostSeqInterval_t;

/*
 * CAS_MsgDefSequence (value = 0x1403) is an input message
 * for component CAS.
 */


typedef struct {
	UInt32	SignalId;
	UInt32	PulseTrainRef;
	UInt16	PreSeqInterval;
	UInt16	InterTrainIntervalMin;
	UInt16	InterTrainIntervalMax;
	UInt16	InterTrainIntervalNom;
	UInt16	PostSeqInterval;
} CAS_MsgDefSequence_t;

#define CAS_MsgDefSequence_get(msgPtr, structAddr, offset)	\
		    qMsgVarFieldGet((msgPtr), 7, &(offset),	\
			(CAS_MsgDefSequence_SignalId), &((structAddr)->SignalId),	\
			(CAS_MsgDefSequence_PulseTrainRef), &((structAddr)->PulseTrainRef),	\
			(CAS_MsgDefSequence_PreSeqInterval), &((structAddr)->PreSeqInterval),	\
			(CAS_MsgDefSequence_InterTrainIntervalMin), &((structAddr)->InterTrainIntervalMin),	\
			(CAS_MsgDefSequence_InterTrainIntervalMax), &((structAddr)->InterTrainIntervalMax),	\
			(CAS_MsgDefSequence_InterTrainIntervalNom), &((structAddr)->InterTrainIntervalNom),	\
			(CAS_MsgDefSequence_PostSeqInterval), &((structAddr)->PostSeqInterval))


#define CAS_MsgDefSequence_put(msgPtr, structAddr, offset)	\
		    qMsgVarFieldPut((msgPtr), 7, &(offset),	\
			(CAS_MsgDefSequence_SignalId), &((structAddr)->SignalId),	\
			(CAS_MsgDefSequence_PulseTrainRef), &((structAddr)->PulseTrainRef),	\
			(CAS_MsgDefSequence_PreSeqInterval), &((structAddr)->PreSeqInterval),	\
			(CAS_MsgDefSequence_InterTrainIntervalMin), &((structAddr)->InterTrainIntervalMin),	\
			(CAS_MsgDefSequence_InterTrainIntervalMax), &((structAddr)->InterTrainIntervalMax),	\
			(CAS_MsgDefSequence_InterTrainIntervalNom), &((structAddr)->InterTrainIntervalNom),	\
			(CAS_MsgDefSequence_PostSeqInterval), &((structAddr)->PostSeqInterval))


#define CAS_MsgDefSequence_Size		18

#define CAS_MsgDefSequence	0x1403	/* 5123 */
/* This message directs a CAS component to add a CAS Pulse Train Sequence 
 * Signal definition to a signal set. Once the signal has been defined, it may 
 * be activated, or made available for transmission or detection by using the 
 * command MsgEnableSignal. Message Definition Item Description Range/Units 
 * SignalId Identifies the CAS Signal to define. N/A PulseTrainRefer The pulse 
 * train which comprises the sequence. SignalId PreSeqInterval The minimum time 
 * for the duration of the pre-sequence interval. This time may differ from the 
 * pre-train time of the component trains. Msec InterTrainIntervalMin The 
 * minimum time for the duration of the inter-train interval Msec 
 * InterTrainIntervalMax The maximum time for the duration of the inter-train 
 * interval Msec InterTrainIntervalNominal The nominal time for the duration of 
 * the inter-train interval Msec PostSeqInterval The minimum time for the 
 * duration of the end-of-sequence interval Msec */
/* This is the response to the command MsgDefPulse, MsgDefPulse, MsgDefTrain 
 * and MsgDefSequence. It indicates that the CAS Signal has been successfully 
 * added to a signal set. ? Related Messages MsgDefineSignal. */

/*
 * CAS_MsgDefSignalCmplt (value = 0x1404) is an output message
 * for component CAS.
 */

#define CAS_MsgDefSignalCmplt_Size		0

#define CAS_MsgDefSignalCmplt	0x1404	/* 5124 */

#define CAS_MsgDeleteSignal_SignalId	0x380000	/* 3670016 */
typedef	UInt32	CAS_MsgDeleteSignal_SignalId_t;

/*
 * CAS_MsgDeleteSignal (value = 0x1405) is an input message
 * for component CAS.
 */


typedef struct {
	UInt32	SignalId;
} CAS_MsgDeleteSignal_t;

#define CAS_MsgDeleteSignal_get(msgPtr, structAddr, offset)	\
		    qMsgVarFieldGet((msgPtr), 1, &(offset),	\
			(CAS_MsgDeleteSignal_SignalId), &((structAddr)->SignalId))


#define CAS_MsgDeleteSignal_put(msgPtr, structAddr, offset)	\
		    qMsgVarFieldPut((msgPtr), 1, &(offset),	\
			(CAS_MsgDeleteSignal_SignalId), &((structAddr)->SignalId))


#define CAS_MsgDeleteSignal_Size		4

#define CAS_MsgDeleteSignal	0x1405	/* 5125 */
/* This message removes the CAS Signal definition identified by SignalId. 
 * SignalId Identifies the CAS Signal to delete. If the Information Identifier 
 * is invalid the an ErrParmValue error is generated in place of the response. */
/* This is the response to the command MsgDeleteSignal. It acknowledges 
 * deletion of a signal definition. */

/*
 * CAS_MsgDeleteSignalCmplt (value = 0x1406) is an output message
 * for component CAS.
 */

#define CAS_MsgDeleteSignalCmplt_Size		0

#define CAS_MsgDeleteSignalCmplt	0x1406	/* 5126 */

#define CAS_MsgDisableSignal_SignalId	0x380000	/* 3670016 */
typedef	UInt32	CAS_MsgDisableSignal_SignalId_t;

/*
 * CAS_MsgDisableSignal (value = 0x1407) is an input message
 * for component CAS.
 */


typedef struct {
	UInt32	SignalId;
} CAS_MsgDisableSignal_t;

#define CAS_MsgDisableSignal_get(msgPtr, structAddr, offset)	\
		    qMsgVarFieldGet((msgPtr), 1, &(offset),	\
			(CAS_MsgDisableSignal_SignalId), &((structAddr)->SignalId))


#define CAS_MsgDisableSignal_put(msgPtr, structAddr, offset)	\
		    qMsgVarFieldPut((msgPtr), 1, &(offset),	\
			(CAS_MsgDisableSignal_SignalId), &((structAddr)->SignalId))


#define CAS_MsgDisableSignal_Size		4

#define CAS_MsgDisableSignal	0x1407	/* 5127 */
/* This message deactivates the signal or signal set identified by SignalId. 
 * Deactivation makes that signal unavailable for transmission or detection for 
 * this client. SignalId Identifies the signal to be deactivated. If the Id 
 * field of the SignalId is set to zero, the entire signal set is disabled. If 
 * the Information Identifier is invalid the an ErrParmValue error is generated 
 * in place of the response. */
/* This is the response to the command MsgDisableSignal. It is sent to 
 * acknowledge that the requested signal has been disabled. */

/*
 * CAS_MsgDisableSignalCmplt (value = 0x1408) is an output message
 * for component CAS.
 */

#define CAS_MsgDisableSignalCmplt_Size		0

#define CAS_MsgDisableSignalCmplt	0x1408	/* 5128 */

#define CAS_MsgEnableSignal_SignalId	0x380000	/* 3670016 */
typedef	UInt32	CAS_MsgEnableSignal_SignalId_t;

/*
 * CAS_MsgEnableSignal (value = 0x1409) is an input message
 * for component CAS.
 */


typedef struct {
	UInt32	SignalId;
} CAS_MsgEnableSignal_t;

#define CAS_MsgEnableSignal_get(msgPtr, structAddr, offset)	\
		    qMsgVarFieldGet((msgPtr), 1, &(offset),	\
			(CAS_MsgEnableSignal_SignalId), &((structAddr)->SignalId))


#define CAS_MsgEnableSignal_put(msgPtr, structAddr, offset)	\
		    qMsgVarFieldPut((msgPtr), 1, &(offset),	\
			(CAS_MsgEnableSignal_SignalId), &((structAddr)->SignalId))


#define CAS_MsgEnableSignal_Size		4

#define CAS_MsgEnableSignal	0x1409	/* 5129 */
/* This message activates the signal or signal set identified by SignalId. 
 * Activation makes that signal available for transmission or detection. 
 * SignalId Identifies the signal to be activated. If the Id field of the 
 * SignalId is set to zero, the entire signal set is enabled. If the 
 * Information Identifier is invalid the an ErrParmValue error is generated in 
 * place of the response. */
/* This is the response to the command MsgEnableSignal. It is sent to 
 * acknowledge that the requested signal has been enabled. */

/*
 * CAS_MsgEnableSignalCmplt (value = 0x140a) is an output message
 * for component CAS.
 */

#define CAS_MsgEnableSignalCmplt_Size		0

#define CAS_MsgEnableSignalCmplt	0x140a	/* 5130 */

#define CAS_MsgGenerateSignal_SignalId	0x380000	/* 3670016 */
typedef	UInt32	CAS_MsgGenerateSignal_SignalId_t;

#define CAS_MsgGenerateSignal_Count	0x280004	/* 2621444 */
typedef	UInt16	CAS_MsgGenerateSignal_Count_t;

#define CAS_MsgGenerateSignal_Format	0x200006	/* 2097158 */
typedef	UInt8	CAS_MsgGenerateSignal_Format_t;

#define CAS_MsgGenerateSignal_varStart	0x7

#define CAS_MsgGenerateSignal_SignalListPulseCountElement	0x200000	/* 2097152 */
typedef	UInt8	CAS_MsgGenerateSignal_SignalListPulseCountElement_t;

#define CAS_MsgGenerateSignal_SignalListLabelElement	0x201800	/* 2103296 */
typedef	UInt8	CAS_MsgGenerateSignal_SignalListLabelElement_t[4];

#define CAS_MsgGenerateSignal_SignalListLabelString	0x27f000	/* 2617344 */
typedef	UInt8	CAS_MsgGenerateSignal_SignalListLabelString_t[255];

/*
 * CAS_MsgGenerateSignal (value = 0x140b) is an input message
 * for component CAS.
 */


typedef struct {
	UInt32	SignalId;
	UInt16	Count;
	UInt8	Format;
} CAS_MsgGenerateSignal_t;

#define CAS_MsgGenerateSignal_get(msgPtr, structAddr, offset)	\
		    qMsgVarFieldGet((msgPtr), 3, &(offset),	\
			(CAS_MsgGenerateSignal_SignalId), &((structAddr)->SignalId),	\
			(CAS_MsgGenerateSignal_Count), &((structAddr)->Count),	\
			(CAS_MsgGenerateSignal_Format), &((structAddr)->Format))


#define CAS_MsgGenerateSignal_put(msgPtr, structAddr, offset)	\
		    qMsgVarFieldPut((msgPtr), 3, &(offset),	\
			(CAS_MsgGenerateSignal_SignalId), &((structAddr)->SignalId),	\
			(CAS_MsgGenerateSignal_Count), &((structAddr)->Count),	\
			(CAS_MsgGenerateSignal_Format), &((structAddr)->Format))


#define CAS_MsgGenerateSignal_Size		7

#define CAS_MsgGenerateSignal	0x140b	/* 5131 */
/* This message starts the generation of the CAS Signal definition identified 
 * by SignalId. SignalId Identifies the CAS Signal to generate. If the 
 * Information Identifier is invalid then an ErrParmValue error is generated in 
 * place of the response. Count The number of Array Elements in the SignalList 
 * Arrays or the length of the LabelString in the SignalListLabelString. If the 
 * Count is 0 the Format field has no relevant information and there will be no 
 * variable section of the message. Format This field describes the format of 
 * the variable length section of the message if it exists. The possible 
 * formats are listed in the table below. Equate Name Description 
 * CAS_SignalListFormat_PulseCountsArray The signal list is an Array of Pulse 
 * Counts. CAS_SignalListFormat_LabelString The signals list is a space 
 * delineated ASCIIZ string where each train digit is represented by its label 
 * from the signal definition. CAS_SignalListFormat_LabelArray The signals list 
 * is an Array of ASCIIZ strings where each train digit is represented by its 
 * label from the signal definition, and each array entry is a single Label. */
/* This is the response to the command MsgGenerateSignal. It is sent when the 
 * CAS signal being generated completes or is terminated by a MsgStopSignal 
 * command. */

/*
 * CAS_MsgGenerateSignalCmplt (value = 0x140c) is an output message
 * for component CAS.
 */

#define CAS_MsgGenerateSignalCmplt_Size		0

#define CAS_MsgGenerateSignalCmplt	0x140c	/* 5132 */
/* This message stops the generation of the current CAS Signal being 
 * generated. There is no effect if none is being generated. */

/*
 * CAS_MsgStopSignal (value = 0x140d) is an input message
 * for component CAS.
 */

#define CAS_MsgStopSignal_Size		0

#define CAS_MsgStopSignal	0x140d	/* 5133 */

#define CAS_EvtDetectedSignal_SignalId	0x380000	/* 3670016 */
typedef	UInt32	CAS_EvtDetectedSignal_SignalId_t;

#define CAS_EvtDetectedSignal_Timestamp	0x380004	/* 3670020 */
typedef	UInt32	CAS_EvtDetectedSignal_Timestamp_t;

#define CAS_EvtDetectedSignal_Count	0x200008	/* 2097160 */
typedef	UInt8	CAS_EvtDetectedSignal_Count_t;

#define CAS_EvtDetectedSignal_Format	0x200009	/* 2097161 */
typedef	UInt8	CAS_EvtDetectedSignal_Format_t;

#define CAS_EvtDetectedSignal_varStart	0xa

#define CAS_EvtDetectedSignal_SignalListPulseCountElement	0x200000	/* 2097152 */
typedef	UInt8	CAS_EvtDetectedSignal_SignalListPulseCountElement_t;

#define CAS_EvtDetectedSignal_SignalListLabelElement	0x201800	/* 2103296 */
typedef	UInt8	CAS_EvtDetectedSignal_SignalListLabelElement_t[4];

#define CAS_EvtDetectedSignal_SignalListLabelString	0x27f000	/* 2617344 */
typedef	UInt8	CAS_EvtDetectedSignal_SignalListLabelString_t[255];

/*
 * CAS_EvtDetectedSignal (value = 0x140e) is an output message
 * for component CAS.
 */


typedef struct {
	UInt32	SignalId;
	UInt32	Timestamp;
	UInt8	Count;
	UInt8	Format;
} CAS_EvtDetectedSignal_t;

#define CAS_EvtDetectedSignal_get(msgPtr, structAddr, offset)	\
		    qMsgVarFieldGet((msgPtr), 4, &(offset),	\
			(CAS_EvtDetectedSignal_SignalId), &((structAddr)->SignalId),	\
			(CAS_EvtDetectedSignal_Timestamp), &((structAddr)->Timestamp),	\
			(CAS_EvtDetectedSignal_Count), &((structAddr)->Count),	\
			(CAS_EvtDetectedSignal_Format), &((structAddr)->Format))


#define CAS_EvtDetectedSignal_put(msgPtr, structAddr, offset)	\
		    qMsgVarFieldPut((msgPtr), 4, &(offset),	\
			(CAS_EvtDetectedSignal_SignalId), &((structAddr)->SignalId),	\
			(CAS_EvtDetectedSignal_Timestamp), &((structAddr)->Timestamp),	\
			(CAS_EvtDetectedSignal_Count), &((structAddr)->Count),	\
			(CAS_EvtDetectedSignal_Format), &((structAddr)->Format))


#define CAS_EvtDetectedSignal_Size		10

#define CAS_EvtDetectedSignal	0x140e	/* 5134 */
/* This is an asynchronous event that indicates that a signal, identified by 
 * SignalId, has been detected. This message is sent to the enabler of the 
 * signal. SignalId Identifies the signal which was detected. Timestamp The 
 * time that the signal was detected (board timestamp in units of 1 msecs). The 
 * time is stamped once the post-time for the signal has expired. Count The 
 * number of Array Elements in the SignalList Arrays or the length of the 
 * LabelString in the SignalListLabelString. If the Count is 0 the Format field 
 * has no relevant information and there will be no variable section of the 
 * message. Format This field describes the format of the variable length 
 * section of the message if it exists. The possible formats are listed in the 
 * table below. Equate Name Description CAS_SignalListFormat_PulseCountsArray 
 * The signal list is an Array of Pulse Counts. 
 * CAS_SignalListFormat_LabelString The signals list is a space delineated 
 * ASCIIZ string where each train digit is represented by its label from the 
 * signal definition. CAS_SignalListFormat_LabelArray The signals list is an 
 * Array of ASCIIZ strings where each train digit is represented by its label 
 * from the signal definition, and each array entry is a single Label. */

#define CAS_RTCEvtDetectedSignal_Label	0x380000	/* 3670016 */
typedef	UInt32	CAS_RTCEvtDetectedSignal_Label_t;

#define CAS_RTCEvtDetectedSignal_SignalId	0x380004	/* 3670020 */
typedef	UInt32	CAS_RTCEvtDetectedSignal_SignalId_t;

#define CAS_RTCEvtDetectedSignal_Direction_Inbound	0x1	/* 1 */

#define CAS_RTCEvtDetectedSignal_Direction_Outbound	0x2	/* 2 */

#define CAS_RTCEvtDetectedSignal_Direction	0x380008	/* 3670024 */
typedef	UInt32	CAS_RTCEvtDetectedSignal_Direction_t;

#define CAS_RTCEvtDetectedSignal_Timestamp	0x38000c	/* 3670028 */
typedef	UInt32	CAS_RTCEvtDetectedSignal_Timestamp_t;

#define CAS_RTCEvtDetectedSignal_Count	0x200010	/* 2097168 */
typedef	UInt8	CAS_RTCEvtDetectedSignal_Count_t;

#define CAS_RTCEvtDetectedSignal_Format	0x200011	/* 2097169 */
typedef	UInt8	CAS_RTCEvtDetectedSignal_Format_t;

#define CAS_RTCEvtDetectedSignal_varStart	0x12

#define CAS_RTCEvtDetectedSignal_SignalListPulseCountElement	0x200000	/* 2097152 */
typedef	UInt8	CAS_RTCEvtDetectedSignal_SignalListPulseCountElement_t;

#define CAS_RTCEvtDetectedSignal_SignalListLabelElement	0x201800	/* 2103296 */
typedef	UInt8	CAS_RTCEvtDetectedSignal_SignalListLabelElement_t[4];

#define CAS_RTCEvtDetectedSignal_SignalListLabelString	0x27f000	/* 2617344 */
typedef	UInt8	CAS_RTCEvtDetectedSignal_SignalListLabelString_t[255];

/*
 * CAS_RTCEvtDetectedSignal (value = generic) is an output message
 * for component CAS.
 */


typedef struct {
	UInt32	Label;
	UInt32	SignalId;
	UInt32	Direction;
	UInt32	Timestamp;
	UInt8	Count;
	UInt8	Format;
} CAS_RTCEvtDetectedSignal_t;

#define CAS_RTCEvtDetectedSignal_get(msgPtr, structAddr, offset)	\
		    qMsgVarFieldGet((msgPtr), 6, &(offset),	\
			(CAS_RTCEvtDetectedSignal_Label), &((structAddr)->Label),	\
			(CAS_RTCEvtDetectedSignal_SignalId), &((structAddr)->SignalId),	\
			(CAS_RTCEvtDetectedSignal_Direction), &((structAddr)->Direction),	\
			(CAS_RTCEvtDetectedSignal_Timestamp), &((structAddr)->Timestamp),	\
			(CAS_RTCEvtDetectedSignal_Count), &((structAddr)->Count),	\
			(CAS_RTCEvtDetectedSignal_Format), &((structAddr)->Format))


#define CAS_RTCEvtDetectedSignal_put(msgPtr, structAddr, offset)	\
		    qMsgVarFieldPut((msgPtr), 6, &(offset),	\
			(CAS_RTCEvtDetectedSignal_Label), &((structAddr)->Label),	\
			(CAS_RTCEvtDetectedSignal_SignalId), &((structAddr)->SignalId),	\
			(CAS_RTCEvtDetectedSignal_Direction), &((structAddr)->Direction),	\
			(CAS_RTCEvtDetectedSignal_Timestamp), &((structAddr)->Timestamp),	\
			(CAS_RTCEvtDetectedSignal_Count), &((structAddr)->Count),	\
			(CAS_RTCEvtDetectedSignal_Format), &((structAddr)->Format))


#define CAS_RTCEvtDetectedSignal_Size		18
/* This is an asynchronous RTC event that indicates that a signal, identified 
 * by SignalId, has been detected. This message is returned as a 
 * Std_MsgEvtDetetected message. Label The RTC label specified when this event 
 * type was enabled for detection. SignalId Identifies the signal which was 
 * detected. Direction The direction in which the signal was detected. Into the 
 * system (Inbound) or Out of the system (Outbound). Timestamp The time that 
 * the signal was detected (board timestamp in units of 1 msecs). The time is 
 * stamped once the post-time for the signal has expired. Count The number of 
 * Array Elements in the SignalList Arrays or the length of the LabelString in 
 * the SignalListLabelString. If the Count is 0 the Format field has no 
 * relevant information and there will be no variable section of the message. 
 * Format This field describes the format of the variable length section of the 
 * message if it exists. The possible formats are listed in the table below. 
 * Equate Name Description CAS_SignalListFormat_PulseCountsArray The signal 
 * list is an Array of Pulse Counts. CAS_SignalListFormat_LabelString The 
 * signals list is a space delineated ASCIIZ string where each train digit is 
 * represented by its label from the signal definition. 
 * CAS_SignalListFormat_LabelArray The signals list is an Array of ASCIIZ 
 * strings where each train digit is represented by its label from the signal 
 * definition, and each array entry is a single Label. */

#define CAS_EvtDetectedTransition_Label	0x380000	/* 3670016 */
typedef	UInt32	CAS_EvtDetectedTransition_Label_t;

#define CAS_EvtDetectedTransition_PreTransCode	0x200004	/* 2097156 */
typedef	UInt8	CAS_EvtDetectedTransition_PreTransCode_t;

#define CAS_EvtDetectedTransition_PostTransCode	0x200005	/* 2097157 */
typedef	UInt8	CAS_EvtDetectedTransition_PostTransCode_t;

#define CAS_EvtDetectedTransition_Direction_Inbound	0x1	/* 1 */

#define CAS_EvtDetectedTransition_Direction_Outbound	0x2	/* 2 */

#define CAS_EvtDetectedTransition_Direction	0x380006	/* 3670022 */
typedef	UInt32	CAS_EvtDetectedTransition_Direction_t;

#define CAS_EvtDetectedTransition_Timestamp	0x38000a	/* 3670026 */
typedef	UInt32	CAS_EvtDetectedTransition_Timestamp_t;

/*
 * CAS_EvtDetectedTransition (value = generic) is an output message
 * for component CAS.
 */


typedef struct {
	UInt32	Label;
	UInt8	PreTransCode;
	UInt8	PostTransCode;
	UInt32	Direction;
	UInt32	Timestamp;
} CAS_EvtDetectedTransition_t;

#define CAS_EvtDetectedTransition_get(msgPtr, structAddr, offset)	\
		    qMsgVarFieldGet((msgPtr), 5, &(offset),	\
			(CAS_EvtDetectedTransition_Label), &((structAddr)->Label),	\
			(CAS_EvtDetectedTransition_PreTransCode), &((structAddr)->PreTransCode),	\
			(CAS_EvtDetectedTransition_PostTransCode), &((structAddr)->PostTransCode),	\
			(CAS_EvtDetectedTransition_Direction), &((structAddr)->Direction),	\
			(CAS_EvtDetectedTransition_Timestamp), &((structAddr)->Timestamp))


#define CAS_EvtDetectedTransition_put(msgPtr, structAddr, offset)	\
		    qMsgVarFieldPut((msgPtr), 5, &(offset),	\
			(CAS_EvtDetectedTransition_Label), &((structAddr)->Label),	\
			(CAS_EvtDetectedTransition_PreTransCode), &((structAddr)->PreTransCode),	\
			(CAS_EvtDetectedTransition_PostTransCode), &((structAddr)->PostTransCode),	\
			(CAS_EvtDetectedTransition_Direction), &((structAddr)->Direction),	\
			(CAS_EvtDetectedTransition_Timestamp), &((structAddr)->Timestamp))


#define CAS_EvtDetectedTransition_Size		14
/* This is an asynchronous event that indicates that a raw transition has been 
 * detected. This does not indicate that a signal match was found. Label The 
 * RTC label specified when this event type was enabled for detection. 
 * PreTransCode The code prior to the transition. PostTransCode The code after 
 * the transition. Direction The direction in which the transition was 
 * detected. Into the system (Inbound) or Out of the system (Outbound). 
 * Timestamp The time that the transition was detected (board timestamp in 
 * units of msec). */

#define CAS_MsgDefineSignal_SignalId	0x380000	/* 3670016 */
typedef	UInt32	CAS_MsgDefineSignal_SignalId_t;

#define CAS_MsgDefineSignal_SignalType	0x200004	/* 2097156 */
typedef	UInt8	CAS_MsgDefineSignal_SignalType_t;

#define CAS_MsgDefineSignal_varStart	0x5

#define CAS_MsgDefineSignal_SignalDefinition	0x380000	/* 3670016 */
typedef	UInt32	CAS_MsgDefineSignal_SignalDefinition_t;

/*
 * CAS_MsgDefineSignal (value = 0x140f) is an input message
 * for component CAS.
 */


typedef struct {
	UInt32	SignalId;
	UInt8	SignalType;
} CAS_MsgDefineSignal_t;

#define CAS_MsgDefineSignal_get(msgPtr, structAddr, offset)	\
		    qMsgVarFieldGet((msgPtr), 2, &(offset),	\
			(CAS_MsgDefineSignal_SignalId), &((structAddr)->SignalId),	\
			(CAS_MsgDefineSignal_SignalType), &((structAddr)->SignalType))


#define CAS_MsgDefineSignal_put(msgPtr, structAddr, offset)	\
		    qMsgVarFieldPut((msgPtr), 2, &(offset),	\
			(CAS_MsgDefineSignal_SignalId), &((structAddr)->SignalId),	\
			(CAS_MsgDefineSignal_SignalType), &((structAddr)->SignalType))


#define CAS_MsgDefineSignal_Size		5

#define CAS_MsgDefineSignal	0x140f	/* 5135 */
/* This message directs a CAS component to add a CAS Signal definition to a 
 * signal set. Once the signal has been defined, it may be activated for 
 * detection, by using the command MsgEnableSignal. Message Definition Item 
 * Description SignalId Identifies the CAS Signal to define. SignalType 
 * Identifies the type of signal being defined. (CAS_SignalType). See Section 
 * 9.1 Page 48 for the proper values. SignalDefinition A place holder for the 
 * appropriate signal definition type. (Transition, Pulse, Train, or Sequence) 
 * The signal definitions are defined in Section 7 Page 43. */
/* This is the response to the command MsgDefineSignal. It indicates that the 
 * CAS Signal has been successfully added to a signal set. ? Related Messages 
 * MsgDefineSignal. */

/*
 * CAS_MsgDefineSignalCmplt (value = 0x1410) is an output message
 * for component CAS.
 */

#define CAS_MsgDefineSignalCmplt_Size		0

#define CAS_MsgDefineSignalCmplt	0x1410	/* 5136 */

#define CAS_MsgRedefineSignal_SignalId	0x380000	/* 3670016 */
typedef	UInt32	CAS_MsgRedefineSignal_SignalId_t;

#define CAS_MsgRedefineSignal_SignalType	0x200004	/* 2097156 */
typedef	UInt8	CAS_MsgRedefineSignal_SignalType_t;

#define CAS_MsgRedefineSignal_varStart	0x5

#define CAS_MsgRedefineSignal_SignalDefinition	0x380000	/* 3670016 */
typedef	UInt32	CAS_MsgRedefineSignal_SignalDefinition_t;

/*
 * CAS_MsgRedefineSignal (value = 0x1411) is an input message
 * for component CAS.
 */


typedef struct {
	UInt32	SignalId;
	UInt8	SignalType;
} CAS_MsgRedefineSignal_t;

#define CAS_MsgRedefineSignal_get(msgPtr, structAddr, offset)	\
		    qMsgVarFieldGet((msgPtr), 2, &(offset),	\
			(CAS_MsgRedefineSignal_SignalId), &((structAddr)->SignalId),	\
			(CAS_MsgRedefineSignal_SignalType), &((structAddr)->SignalType))


#define CAS_MsgRedefineSignal_put(msgPtr, structAddr, offset)	\
		    qMsgVarFieldPut((msgPtr), 2, &(offset),	\
			(CAS_MsgRedefineSignal_SignalId), &((structAddr)->SignalId),	\
			(CAS_MsgRedefineSignal_SignalType), &((structAddr)->SignalType))


#define CAS_MsgRedefineSignal_Size		5

#define CAS_MsgRedefineSignal	0x1411	/* 5137 */
/* This message directs a CAS component to redefine CAS Signal definition in a 
 * signal set. Message Definition Item Description SignalId Identifies the CAS 
 * Signal to redefine. SignalType Identifies the type of signal being defined. 
 * (CAS_SignalType). See Section 9.1 Page 48 for the proper values. 
 * SignalDefinition A place holder for the appropriate signal definition type. 
 * (Transition, Pulse, Train, or Sequence) The signal definitions are defined 
 * in Section 7 Page 43. */
/* This is the response to the command MsgRedefineSignal. It indicates that 
 * the CAS Signal has been successfully redefined. ? Related Messages 
 * MsgRedefineSignal. */

/*
 * CAS_MsgRedefineSignalCmplt (value = 0x1412) is an output message
 * for component CAS.
 */

#define CAS_MsgRedefineSignalCmplt_Size		0

#define CAS_MsgRedefineSignalCmplt	0x1412	/* 5138 */

#define CAS_MsgGetSignalDefinition_SignalId	0x380000	/* 3670016 */
typedef	UInt32	CAS_MsgGetSignalDefinition_SignalId_t;

/*
 * CAS_MsgGetSignalDefinition (value = 0x1413) is an input message
 * for component CAS.
 */


typedef struct {
	UInt32	SignalId;
} CAS_MsgGetSignalDefinition_t;

#define CAS_MsgGetSignalDefinition_get(msgPtr, structAddr, offset)	\
		    qMsgVarFieldGet((msgPtr), 1, &(offset),	\
			(CAS_MsgGetSignalDefinition_SignalId), &((structAddr)->SignalId))


#define CAS_MsgGetSignalDefinition_put(msgPtr, structAddr, offset)	\
		    qMsgVarFieldPut((msgPtr), 1, &(offset),	\
			(CAS_MsgGetSignalDefinition_SignalId), &((structAddr)->SignalId))


#define CAS_MsgGetSignalDefinition_Size		4

#define CAS_MsgGetSignalDefinition	0x1413	/* 5139 */
/* This message fetches the CAS Signal definition identified by SignalId. 
 * SignalId Identifies the CAS Signal definition to get. If the Information 
 * Identifier is invalid an ErrParmValue error is generated in place of the 
 * response. */

#define CAS_MsgGetSignalDefinitionCmplt_SignalId	0x380000	/* 3670016 */
typedef	UInt32	CAS_MsgGetSignalDefinitionCmplt_SignalId_t;

#define CAS_MsgGetSignalDefinitionCmplt_SignalType	0x200004	/* 2097156 */
typedef	UInt8	CAS_MsgGetSignalDefinitionCmplt_SignalType_t;

#define CAS_MsgGetSignalDefinitionCmplt_varStart	0x5

#define CAS_MsgGetSignalDefinitionCmplt_SignalDefinition	0x380000	/* 3670016 */
typedef	UInt32	CAS_MsgGetSignalDefinitionCmplt_SignalDefinition_t;

/*
 * CAS_MsgGetSignalDefinitionCmplt (value = 0x1414) is an output message
 * for component CAS.
 */


typedef struct {
	UInt32	SignalId;
	UInt8	SignalType;
} CAS_MsgGetSignalDefinitionCmplt_t;

#define CAS_MsgGetSignalDefinitionCmplt_get(msgPtr, structAddr, offset)	\
		    qMsgVarFieldGet((msgPtr), 2, &(offset),	\
			(CAS_MsgGetSignalDefinitionCmplt_SignalId), &((structAddr)->SignalId),	\
			(CAS_MsgGetSignalDefinitionCmplt_SignalType), &((structAddr)->SignalType))


#define CAS_MsgGetSignalDefinitionCmplt_put(msgPtr, structAddr, offset)	\
		    qMsgVarFieldPut((msgPtr), 2, &(offset),	\
			(CAS_MsgGetSignalDefinitionCmplt_SignalId), &((structAddr)->SignalId),	\
			(CAS_MsgGetSignalDefinitionCmplt_SignalType), &((structAddr)->SignalType))


#define CAS_MsgGetSignalDefinitionCmplt_Size		5

#define CAS_MsgGetSignalDefinitionCmplt	0x1414	/* 5140 */
/* This is the response to the command MsgGetSignalDefinition. It returns the 
 * signal definition of the queried signal. Message Definition Item Description 
 * SignalId Identifies the CAS Signal to define. SignalType Identifies the type 
 * of signal being defined. (CAS_SignalType). See Section 9.1 Page 48 for the 
 * proper values. SignalDefinition A place holder for the appropriate signal 
 * definition type. The signal definitions are defined in Section 7 Page 43. */

#define CAS_MsgDial_SignalId	0x380000	/* 3670016 */
typedef	UInt32	CAS_MsgDial_SignalId_t;

#define CAS_MsgDial_DigitString	0x53f804	/* 5502980 */
typedef	Char	CAS_MsgDial_DigitString_t[128];

/*
 * CAS_MsgDial (value = 0x1415) is an input message
 * for component CAS.
 */


typedef struct {
	UInt32	SignalId;
	Char	DigitString[128];
} CAS_MsgDial_t;

#define CAS_MsgDial_get(msgPtr, structAddr, offset)	\
		    qMsgVarFieldGet((msgPtr), 2, &(offset),	\
			(CAS_MsgDial_SignalId), &((structAddr)->SignalId),	\
			(CAS_MsgDial_DigitString), &((structAddr)->DigitString))


#define CAS_MsgDial_put(msgPtr, structAddr, offset)	\
		    qMsgVarFieldPut((msgPtr), 2, &(offset),	\
			(CAS_MsgDial_SignalId), &((structAddr)->SignalId),	\
			(CAS_MsgDial_DigitString), &((structAddr)->DigitString))


#define CAS_MsgDial_Size		132

#define CAS_MsgDial	0x1415	/* 5141 */
/* 
 * This message directs a CAS output a digit sequence. 
 * 
 * Message Definition Item
 * Description 
 * SignalId
 * Identifies the CAS Signal Sequence to output.
 * DigitString
 * An ASCIIZ string of digit labels.
 *  */

#define CAS_MsgDialCmplt_Reason_EOD	0	/* 0 */

#define CAS_MsgDialCmplt_Reason_UserStop	0x1	/* 1 */

#define CAS_MsgDialCmplt_Reason	0x380000	/* 3670016 */
typedef	UInt32	CAS_MsgDialCmplt_Reason_t;

/*
 * CAS_MsgDialCmplt (value = 0x1416) is an output message
 * for component CAS.
 */


typedef struct {
	UInt32	Reason;
} CAS_MsgDialCmplt_t;

#define CAS_MsgDialCmplt_get(msgPtr, structAddr, offset)	\
		    qMsgVarFieldGet((msgPtr), 1, &(offset),	\
			(CAS_MsgDialCmplt_Reason), &((structAddr)->Reason))


#define CAS_MsgDialCmplt_put(msgPtr, structAddr, offset)	\
		    qMsgVarFieldPut((msgPtr), 1, &(offset),	\
			(CAS_MsgDialCmplt_Reason), &((structAddr)->Reason))


#define CAS_MsgDialCmplt_Size		4

#define CAS_MsgDialCmplt	0x1416	/* 5142 */
/* This is the response to the command MsgDial. It is sent when the CAS 
 * sequence being dialed completes or is terminated by a MsgStopSignal command. */

#define CAS_MsgMatchCondition_SignalId	0x380000	/* 3670016 */
typedef	UInt32	CAS_MsgMatchCondition_SignalId_t;

#define CAS_MsgMatchCondition_Condition_Pre	0	/* 0 */

#define CAS_MsgMatchCondition_Condition_Post	0x1	/* 1 */

#define CAS_MsgMatchCondition_Condition	0x200004	/* 2097156 */
typedef	UInt8	CAS_MsgMatchCondition_Condition_t;

/*
 * CAS_MsgMatchCondition (value = 0x1417) is an output message
 * for component CAS.
 */


typedef struct {
	UInt32	SignalId;
	UInt8	Condition;
} CAS_MsgMatchCondition_t;

#define CAS_MsgMatchCondition_get(msgPtr, structAddr, offset)	\
		    qMsgVarFieldGet((msgPtr), 2, &(offset),	\
			(CAS_MsgMatchCondition_SignalId), &((structAddr)->SignalId),	\
			(CAS_MsgMatchCondition_Condition), &((structAddr)->Condition))


#define CAS_MsgMatchCondition_put(msgPtr, structAddr, offset)	\
		    qMsgVarFieldPut((msgPtr), 2, &(offset),	\
			(CAS_MsgMatchCondition_SignalId), &((structAddr)->SignalId),	\
			(CAS_MsgMatchCondition_Condition), &((structAddr)->Condition))


#define CAS_MsgMatchCondition_Size		5

#define CAS_MsgMatchCondition	0x1417	/* 5143 */
/* This Messages causes the CAS instance to check if the supplied signal 
 * partially matches the last or next signal by comparing the pre or post 
 * condition of the supplied signal against the current bit state. This 
 * mechanism is intended to be used at system startup before transitions begin 
 * to occur. Or after a detrimental alarm occurs and the previous value of the 
 * line cannot be trusted. */

#define CAS_MsgMatchConditionCmplt_SignalId	0x380000	/* 3670016 */
typedef	UInt32	CAS_MsgMatchConditionCmplt_SignalId_t;

#define CAS_MsgMatchConditionCmplt_Condition_Pre	0	/* 0 */

#define CAS_MsgMatchConditionCmplt_Condition_Post	0x1	/* 1 */

#define CAS_MsgMatchConditionCmplt_Condition	0x200004	/* 2097156 */
typedef	UInt8	CAS_MsgMatchConditionCmplt_Condition_t;

#define CAS_MsgMatchConditionCmplt_Match_False	0	/* 0 */

#define CAS_MsgMatchConditionCmplt_Match_True	0x1	/* 1 */

#define CAS_MsgMatchConditionCmplt_Match	0x200005	/* 2097157 */
typedef	UInt8	CAS_MsgMatchConditionCmplt_Match_t;

/*
 * CAS_MsgMatchConditionCmplt (value = 0x1418) is an output message
 * for component CAS.
 */


typedef struct {
	UInt32	SignalId;
	UInt8	Condition;
	UInt8	Match;
} CAS_MsgMatchConditionCmplt_t;

#define CAS_MsgMatchConditionCmplt_get(msgPtr, structAddr, offset)	\
		    qMsgVarFieldGet((msgPtr), 3, &(offset),	\
			(CAS_MsgMatchConditionCmplt_SignalId), &((structAddr)->SignalId),	\
			(CAS_MsgMatchConditionCmplt_Condition), &((structAddr)->Condition),	\
			(CAS_MsgMatchConditionCmplt_Match), &((structAddr)->Match))


#define CAS_MsgMatchConditionCmplt_put(msgPtr, structAddr, offset)	\
		    qMsgVarFieldPut((msgPtr), 3, &(offset),	\
			(CAS_MsgMatchConditionCmplt_SignalId), &((structAddr)->SignalId),	\
			(CAS_MsgMatchConditionCmplt_Condition), &((structAddr)->Condition),	\
			(CAS_MsgMatchConditionCmplt_Match), &((structAddr)->Match))


#define CAS_MsgMatchConditionCmplt_Size		6

#define CAS_MsgMatchConditionCmplt	0x1418	/* 5144 */
/* This is the completion message of MsgMatchCondtion. This message indicates 
 * whether or not the queried signal condition matched. */

#define CAS_Transition_PreTransCode	0x200000	/* 2097152 */
typedef	UInt8	CAS_Transition_PreTransCode_t;

#define CAS_Transition_PostTransCode	0x200001	/* 2097153 */
typedef	UInt8	CAS_Transition_PostTransCode_t;

#define CAS_Transition_PreTransInterval	0x280002	/* 2621442 */
typedef	UInt16	CAS_Transition_PreTransInterval_t;

#define CAS_Transition_PostTransInterval	0x280004	/* 2621444 */
typedef	UInt16	CAS_Transition_PostTransInterval_t;


typedef struct {
	UInt8	PreTransCode;
	UInt8	PostTransCode;
	UInt16	PreTransInterval;
	UInt16	PostTransInterval;
} CAS_Transition_t;

#define CAS_Transition_get(msgPtr, structAddr, offset)	\
		    qMsgVarFieldGet((msgPtr), 4, &(offset),	\
			(CAS_Transition_PreTransCode), &((structAddr)->PreTransCode),	\
			(CAS_Transition_PostTransCode), &((structAddr)->PostTransCode),	\
			(CAS_Transition_PreTransInterval), &((structAddr)->PreTransInterval),	\
			(CAS_Transition_PostTransInterval), &((structAddr)->PostTransInterval))


#define CAS_Transition_put(msgPtr, structAddr, offset)	\
		    qMsgVarFieldPut((msgPtr), 4, &(offset),	\
			(CAS_Transition_PreTransCode), &((structAddr)->PreTransCode),	\
			(CAS_Transition_PostTransCode), &((structAddr)->PostTransCode),	\
			(CAS_Transition_PreTransInterval), &((structAddr)->PreTransInterval),	\
			(CAS_Transition_PostTransInterval), &((structAddr)->PostTransInterval))


#define CAS_Transition_Size		6

#define CAS_Transition	0x1	/* 1 */

#define CAS_Pulse_OffPulseCode	0x200000	/* 2097152 */
typedef	UInt8	CAS_Pulse_OffPulseCode_t;

#define CAS_Pulse_OnPulseCode	0x200001	/* 2097153 */
typedef	UInt8	CAS_Pulse_OnPulseCode_t;

#define CAS_Pulse_PrePulseInterval	0x280002	/* 2621442 */
typedef	UInt16	CAS_Pulse_PrePulseInterval_t;

#define CAS_Pulse_PulseIntervalMin	0x280004	/* 2621444 */
typedef	UInt16	CAS_Pulse_PulseIntervalMin_t;

#define CAS_Pulse_PulseIntervalMax	0x280006	/* 2621446 */
typedef	UInt16	CAS_Pulse_PulseIntervalMax_t;

#define CAS_Pulse_PulseIntervalNom	0x280008	/* 2621448 */
typedef	UInt16	CAS_Pulse_PulseIntervalNom_t;

#define CAS_Pulse_PostPulseInterval	0x28000a	/* 2621450 */
typedef	UInt16	CAS_Pulse_PostPulseInterval_t;


typedef struct {
	UInt8	OffPulseCode;
	UInt8	OnPulseCode;
	UInt16	PrePulseInterval;
	UInt16	PulseIntervalMin;
	UInt16	PulseIntervalMax;
	UInt16	PulseIntervalNom;
	UInt16	PostPulseInterval;
} CAS_Pulse_t;

#define CAS_Pulse_get(msgPtr, structAddr, offset)	\
		    qMsgVarFieldGet((msgPtr), 7, &(offset),	\
			(CAS_Pulse_OffPulseCode), &((structAddr)->OffPulseCode),	\
			(CAS_Pulse_OnPulseCode), &((structAddr)->OnPulseCode),	\
			(CAS_Pulse_PrePulseInterval), &((structAddr)->PrePulseInterval),	\
			(CAS_Pulse_PulseIntervalMin), &((structAddr)->PulseIntervalMin),	\
			(CAS_Pulse_PulseIntervalMax), &((structAddr)->PulseIntervalMax),	\
			(CAS_Pulse_PulseIntervalNom), &((structAddr)->PulseIntervalNom),	\
			(CAS_Pulse_PostPulseInterval), &((structAddr)->PostPulseInterval))


#define CAS_Pulse_put(msgPtr, structAddr, offset)	\
		    qMsgVarFieldPut((msgPtr), 7, &(offset),	\
			(CAS_Pulse_OffPulseCode), &((structAddr)->OffPulseCode),	\
			(CAS_Pulse_OnPulseCode), &((structAddr)->OnPulseCode),	\
			(CAS_Pulse_PrePulseInterval), &((structAddr)->PrePulseInterval),	\
			(CAS_Pulse_PulseIntervalMin), &((structAddr)->PulseIntervalMin),	\
			(CAS_Pulse_PulseIntervalMax), &((structAddr)->PulseIntervalMax),	\
			(CAS_Pulse_PulseIntervalNom), &((structAddr)->PulseIntervalNom),	\
			(CAS_Pulse_PostPulseInterval), &((structAddr)->PostPulseInterval))


#define CAS_Pulse_Size		12

#define CAS_Pulse	0x2	/* 2 */

#define CAS_Train_OffPulseCode	0x200000	/* 2097152 */
typedef	UInt8	CAS_Train_OffPulseCode_t;

#define CAS_Train_OnPulseCode	0x200001	/* 2097153 */
typedef	UInt8	CAS_Train_OnPulseCode_t;

#define CAS_Train_PulseIntervalMin	0x280002	/* 2621442 */
typedef	UInt16	CAS_Train_PulseIntervalMin_t;

#define CAS_Train_PulseIntervalMax	0x280004	/* 2621444 */
typedef	UInt16	CAS_Train_PulseIntervalMax_t;

#define CAS_Train_PulseIntervalNom	0x280006	/* 2621446 */
typedef	UInt16	CAS_Train_PulseIntervalNom_t;

#define CAS_Train_PreTrainInterval	0x280008	/* 2621448 */
typedef	UInt16	CAS_Train_PreTrainInterval_t;

#define CAS_Train_InterPulseIntervalMin	0x28000a	/* 2621450 */
typedef	UInt16	CAS_Train_InterPulseIntervalMin_t;

#define CAS_Train_InterPulseIntervalMax	0x28000c	/* 2621452 */
typedef	UInt16	CAS_Train_InterPulseIntervalMax_t;

#define CAS_Train_InterPulseIntervalNom	0x28000e	/* 2621454 */
typedef	UInt16	CAS_Train_InterPulseIntervalNom_t;

#define CAS_Train_PostTrainInterval	0x280010	/* 2621456 */
typedef	UInt16	CAS_Train_PostTrainInterval_t;

#define CAS_Train_DigitCount	0x200012	/* 2097170 */
typedef	UInt8	CAS_Train_DigitCount_t;

#define CAS_Train_varStart	0x13

#define CAS_Train_Digit_PulseCount	0x200000	/* 2097152 */
typedef	UInt8	CAS_Train_Digit_PulseCount_t;

#define CAS_Train_Digit_Label	0x500000	/* 5242880 */
typedef	Char	CAS_Train_Digit_Label_t;


typedef struct {
	UInt8	PulseCount;
	Char	Label;
} CAS_Train_Digit_t;

#define CAS_Train_Digit_get(msgPtr, structAddr, offset)	\
		    qMsgVarFieldGet((msgPtr), 2, &(offset),	\
			(CAS_Train_Digit_PulseCount), &((structAddr)->PulseCount),	\
			(CAS_Train_Digit_Label), &((structAddr)->Label))


#define CAS_Train_Digit_put(msgPtr, structAddr, offset)	\
		    qMsgVarFieldPut((msgPtr), 2, &(offset),	\
			(CAS_Train_Digit_PulseCount), &((structAddr)->PulseCount),	\
			(CAS_Train_Digit_Label), &((structAddr)->Label))


#define CAS_Train_Digit_Size		2

#define CAS_Train_Digit	0x4	/* 4 */


typedef struct {
	UInt8	OffPulseCode;
	UInt8	OnPulseCode;
	UInt16	PulseIntervalMin;
	UInt16	PulseIntervalMax;
	UInt16	PulseIntervalNom;
	UInt16	PreTrainInterval;
	UInt16	InterPulseIntervalMin;
	UInt16	InterPulseIntervalMax;
	UInt16	InterPulseIntervalNom;
	UInt16	PostTrainInterval;
	UInt8	DigitCount;
} CAS_Train_t;

#define CAS_Train_get(msgPtr, structAddr, offset)	\
		    qMsgVarFieldGet((msgPtr), 11, &(offset),	\
			(CAS_Train_OffPulseCode), &((structAddr)->OffPulseCode),	\
			(CAS_Train_OnPulseCode), &((structAddr)->OnPulseCode),	\
			(CAS_Train_PulseIntervalMin), &((structAddr)->PulseIntervalMin),	\
			(CAS_Train_PulseIntervalMax), &((structAddr)->PulseIntervalMax),	\
			(CAS_Train_PulseIntervalNom), &((structAddr)->PulseIntervalNom),	\
			(CAS_Train_PreTrainInterval), &((structAddr)->PreTrainInterval),	\
			(CAS_Train_InterPulseIntervalMin), &((structAddr)->InterPulseIntervalMin),	\
			(CAS_Train_InterPulseIntervalMax), &((structAddr)->InterPulseIntervalMax),	\
			(CAS_Train_InterPulseIntervalNom), &((structAddr)->InterPulseIntervalNom),	\
			(CAS_Train_PostTrainInterval), &((structAddr)->PostTrainInterval),	\
			(CAS_Train_DigitCount), &((structAddr)->DigitCount))


#define CAS_Train_put(msgPtr, structAddr, offset)	\
		    qMsgVarFieldPut((msgPtr), 11, &(offset),	\
			(CAS_Train_OffPulseCode), &((structAddr)->OffPulseCode),	\
			(CAS_Train_OnPulseCode), &((structAddr)->OnPulseCode),	\
			(CAS_Train_PulseIntervalMin), &((structAddr)->PulseIntervalMin),	\
			(CAS_Train_PulseIntervalMax), &((structAddr)->PulseIntervalMax),	\
			(CAS_Train_PulseIntervalNom), &((structAddr)->PulseIntervalNom),	\
			(CAS_Train_PreTrainInterval), &((structAddr)->PreTrainInterval),	\
			(CAS_Train_InterPulseIntervalMin), &((structAddr)->InterPulseIntervalMin),	\
			(CAS_Train_InterPulseIntervalMax), &((structAddr)->InterPulseIntervalMax),	\
			(CAS_Train_InterPulseIntervalNom), &((structAddr)->InterPulseIntervalNom),	\
			(CAS_Train_PostTrainInterval), &((structAddr)->PostTrainInterval),	\
			(CAS_Train_DigitCount), &((structAddr)->DigitCount))


#define CAS_Train_Size		19

#define CAS_Train	0x3	/* 3 */

#define CAS_Sequence_PulseTrainRef	0x380000	/* 3670016 */
typedef	UInt32	CAS_Sequence_PulseTrainRef_t;

#define CAS_Sequence_PreSeqInterval	0x280004	/* 2621444 */
typedef	UInt16	CAS_Sequence_PreSeqInterval_t;

#define CAS_Sequence_InterTrainIntervalMin	0x280006	/* 2621446 */
typedef	UInt16	CAS_Sequence_InterTrainIntervalMin_t;

#define CAS_Sequence_InterTrainIntervalMax	0x280008	/* 2621448 */
typedef	UInt16	CAS_Sequence_InterTrainIntervalMax_t;

#define CAS_Sequence_InterTrainIntervalNom	0x28000a	/* 2621450 */
typedef	UInt16	CAS_Sequence_InterTrainIntervalNom_t;

#define CAS_Sequence_PostSeqInterval	0x28000c	/* 2621452 */
typedef	UInt16	CAS_Sequence_PostSeqInterval_t;


typedef struct {
	UInt32	PulseTrainRef;
	UInt16	PreSeqInterval;
	UInt16	InterTrainIntervalMin;
	UInt16	InterTrainIntervalMax;
	UInt16	InterTrainIntervalNom;
	UInt16	PostSeqInterval;
} CAS_Sequence_t;

#define CAS_Sequence_get(msgPtr, structAddr, offset)	\
		    qMsgVarFieldGet((msgPtr), 6, &(offset),	\
			(CAS_Sequence_PulseTrainRef), &((structAddr)->PulseTrainRef),	\
			(CAS_Sequence_PreSeqInterval), &((structAddr)->PreSeqInterval),	\
			(CAS_Sequence_InterTrainIntervalMin), &((structAddr)->InterTrainIntervalMin),	\
			(CAS_Sequence_InterTrainIntervalMax), &((structAddr)->InterTrainIntervalMax),	\
			(CAS_Sequence_InterTrainIntervalNom), &((structAddr)->InterTrainIntervalNom),	\
			(CAS_Sequence_PostSeqInterval), &((structAddr)->PostSeqInterval))


#define CAS_Sequence_put(msgPtr, structAddr, offset)	\
		    qMsgVarFieldPut((msgPtr), 6, &(offset),	\
			(CAS_Sequence_PulseTrainRef), &((structAddr)->PulseTrainRef),	\
			(CAS_Sequence_PreSeqInterval), &((structAddr)->PreSeqInterval),	\
			(CAS_Sequence_InterTrainIntervalMin), &((structAddr)->InterTrainIntervalMin),	\
			(CAS_Sequence_InterTrainIntervalMax), &((structAddr)->InterTrainIntervalMax),	\
			(CAS_Sequence_InterTrainIntervalNom), &((structAddr)->InterTrainIntervalNom),	\
			(CAS_Sequence_PostSeqInterval), &((structAddr)->PostSeqInterval))


#define CAS_Sequence_Size		14

#define CAS_Sequence	0x4	/* 4 */
/* 
 * Channel Associated Signaling Parameter Definitions 
 */
/* 
 * The identifier of the bearer channel that the 
 * CAS instance is associated with. 
 */

#define CAS_BearerChannelId	0x1400	/* 5120 */
typedef	UInt32	CAS_BearerChannelId_t;
/* 
 * The identifier of the line device that the CAS 
 * instance is associated with. 
 */

typedef enum{ 
CAS_SignalType_Transition = 1,

/*
 * Transition Type
 */

CAS_SignalType_Pulse,

/*
 * Pulse Type
 */

CAS_SignalType_Train,

/*
 * Pulse Train Type
 */

CAS_SignalType_Sequence} CAS_SignalType;

/*
 * Sequence of Pulse Trains Type
 */

typedef enum{ 
CAS_EventId_InboundTransitions = 0x1400,

/*
 * Used to register for notification of all transitions 
 * detected by the CAS instance.
 */

CAS_EventId_OutboundTransitions,

/*
 * Used to register for notification of all transitions 
 * generated by the CAS instance.
 */

CAS_EventId_AllTransitions,

/*
 * Used to register for notification of all transitions 
 * generated and detected by the CAS instance.
 */

CAS_EventId_InboundSignals,

/*
 * Used to register for notification of all signals matched by 
 * the CAS instance.
 */

CAS_EventId_OutboundSignals,

/*
 * Used to register for notification of all signals being 
 * generated by the CAS instance.
 */

CAS_EventId_AllSignals} CAS_EventId;

/*
 * Used to register for notification of all signals matched 
 * and generated by the CAS instance..
 */

typedef enum{ 
CAS_SignalListFormat_PulseCountsArray = 1,

/*
 * The signal list is an Array of Pulse Counts.
 */

CAS_SignalListFormat_LabelArray,

/*
 * The signals list is an Array of ASCIIZ strings where 
 * each train digit is represented by its label from the signal 
 * definition, and each array entry is a single Label.
 */

CAS_SignalListFormat_LabelString 
}CAS_SignalListFormat;

/*
 * The signals list is a space delineated ASCIIZ string 
 * where each train digit is represented by its label from the 
 * signal definition.
 */

#define SIGNAL_BIT_A  0x08


#define SIGNAL_BIT_B 0x04


#define SIGNAL_BIT_C 0x02


#define SIGNAL_BIT_D 0x01


#define SIGNAL_MASK_BIT_A  0x80


#define SIGNAL_MASK_BIT_B 0x40


#define SIGNAL_MASK_BIT_C 0x20


#define SIGNAL_MASK_BIT_D 0x10

/* 
 * The specified identifier is already in use. 
 */

#define CAS_LineId	0x1401	/* 5121 */
typedef	UInt32	CAS_LineId_t;
/*
 * The signal identifier is invalid, or, in the case of 
 * MsgDefineSignal, has been previously defined.
 */

#define CAS_ErrSignalId	0x1400	/* 5120 */
/*
 * The Signal Type is invalid. 
 */

#define CAS_ErrSignalType	0x1401	/* 5121 */
/*
 * The Pre-Transition Code is invalid. 
 */

#define CAS_ErrPreTransCode	0x1402	/* 5122 */
/*
 * The Post-Transition Code is invalid. 
 */

#define CAS_ErrPostTransCode	0x1403	/* 5123 */
/*
 * The Pre-Transition interval is out-of-range. 
 */

#define CAS_ErrPreTransInt	0x1404	/* 5124 */
/*
 * The Post-Transition interval is out-of-range. 
 */

#define CAS_ErrPostTransInt	0x1405	/* 5125 */
/*
 * The signal table is full and can't insert the signal entry. 
 */

#define CAS_ErrSignalTableFull	0x1406	/* 5126 */
/*
 * The signal is in use and can't be deleted.
 */

#define CAS_ErrSignalInUse	0x1407	/* 5127 */
/*
 * The Pre-Pulse interval is invalid. 
 */

#define CAS_ErrPrePulseInt	0x1408	/* 5128 */
/*
 * The minimum pulse interval is invalid. 
 */

#define CAS_ErrPulseIntMin	0x1409	/* 5129 */
/*
 * The maximum pulse interval is invalid. 
 */

#define CAS_ErrPulseIntMax	0x140a	/* 5130 */
/*
 * The nominal pulse interval is invalid. 
 */

#define CAS_ErrPulseIntNom	0x140b	/* 5131 */
/*
 * The Post-Pulse interval is invalid. 
 */

#define CAS_ErrPostPulseInt	0x140c	/* 5132 */
/*
 * The signal referenced is already enabled for the instance. 
 */

#define CAS_ErrSignalEnabled	0x140d	/* 5133 */
/*
 * The Pre-Train interval is invalid. 
 */

#define CAS_ErrPreTrainInt	0x140e	/* 5134 */
/*
 * The minimum inter-pulse interval is invalid. 
 */

#define CAS_ErrIntPulseIntMin	0x140f	/* 5135 */
/*
 * The maximum inter-pulse interval is invalid. 
 */

#define CAS_ErrIntPulseIntMax	0x1410	/* 5136 */
/*
 * The nominal inter-pulse interval is invalid. 
 */

#define CAS_ErrIntPulseIntNom	0x1411	/* 5137 */
/*
 * The Post-Train interval is invalid. 
 */

#define CAS_ErrPostTrainInt	0x1412	/* 5138 */
/*
 * The Pulse Train Signal Id Reference is invalid. 
 */

#define CAS_ErrPulseTrainRef	0x1413	/* 5139 */
/* 
 * The Pre-Sequence interval is invalid. 
 */

#define CAS_ErrPreSequenceInt	0x1414	/* 5140 */
/*
 * The minimum inter-train interval is invalid.
 */

#define CAS_ErrIntTrainIntMin	0x1415	/* 5141 */
/*
 * The maximum inter-train interval is invalid.
 */

#define CAS_ErrIntTrainIntMax	0x1416	/* 5142 */
/*
 * The nominal inter-train interval is invalid.
 */

#define CAS_ErrIntTrainIntNom	0x1417	/* 5143 */
/*
 * The Post-Sequence interval is invalid.
 */

#define CAS_ErrPostSequenceInt	0x1418	/* 5144 */
/*
 * The maximum number of definable digits has been 
 * exceeded in a train definition, or in the case of MsgDial the 
 * string exceeded the maximum allowable length.
 */

#define CAS_ErrMaxDigitsExceeded	0x1419	/* 5145 */
/*
 * The specified digit label is not recognized.
 */
/*
 * Standard Attribute Types
 */

#define CAS_ErrDigitLabelUndefined	0x141a	/* 5146 */

#define CAS_DIALOGIC	0x1	/* 1 */
/* 
 * Identifier that uniquely identifies the component type (e.g. the 
 * vendor that provides the component).
 */

#define CAS_Std_ComponentType	0x14	/* 20 */

#define CAS_CAS	0x14	/* 20 */
/* Component type */
/*
 * CAS Specific Attribute Types
 */

#define CAS_CAS_Component_Type_T1_SF	0x1	/* 1 */

#define CAS_CAS_Component_Type_T1_ESF	0x2	/* 2 */

#define CAS_CAS_Component_Type_E1	0x3	/* 3 */
/* 
 * Framing identifier for the componenet. 
 */
/* 
 * End of all Mercury Channel Associated Signaling Component Definitions 
 */

#define CAS_CAS_Component_Type	0x3	/* 3 */
typedef	QCompAttr	CAS_CAS_Component_Type_t;

#define CAS	0x14	/* 20 */

typedef struct {
	UInt32		BearerChannelId;
	UInt32		LineId;

} CASparm_t;

#if defined ( CAS_DEFINED )

ParmStruct CASParmTab []= {
{CAS_BearerChannelId, 2, 0, 0, 0, 0},
 {0x380000, offsetof(CASparm_t, BearerChannelId), PARM_READWRITE, 0, 0, 0},
 {0x380000, offsetof(CASparm_t, LineId), PARM_READWRITE, 0, 0, 0},

};

#endif


#endif /* !defined(_cas_defs_h_) */
