
/*
 * This file was automatically generated from ciddefs.txt.
 * Author: "DM3 Team"
 * Version: "0.9"
 * Date: Mon Dec 16 14:15:56 2002
 * The output was written to ciddefs.h.
 * Produced by mmdl translator version 1.3.
 */

#if !defined(_ciddefs_h_)
#define _ciddefs_h_ 1
/* "DM3 CallerId Team" This file describes the list of DM3 messages, 
 * parameters and equates supported by the DM3 Caller ID Component and its 
 * Instances. */
/*
 * Cid Component Definition
 */
/* The Cid uses messages from the Standard Kernel Message Set, the Standard 
 * Component Message Set and the Standard Cid Modem Component Message Set. */
/*
 * 	Mercury Kernel Standard Message Set defined in mercdefs.doc
 * 	*/
/*
 * 	Standard Component Message Set defined in stddefs.doc.
 * 	*/
/*
 * 	Cid Modem Component Message Set defined in cidmodem_defs.doc
 * 	*/
/* 
 * Cid Message Definitions
 */

#define   FSK_Rx_Buf_Size	255  /*  Buffer size for receiving FSK data*/
#define	FSK_Tx_Buf_Size	255  /*  Buffer size for transmiting FSK data*/
#define	FSK_CAS_Tone_ID	59994 /* CAS tone signal ID used in FSK.*/

/* The MsgRxStart message is sent to initiate a reception of Caller ID data 
 * from a specified stream. The MsgRxStartCmplt message is returned when this 
 * message is received and successfully processed by the Cid. */

/*
 * Cid_MsgRxStart (value = 0x2900) is an input message
 * for component Cid.
 */

#define Cid_MsgRxStart_Size		0

#define Cid_MsgRxStart	0x2900	/* 10496 */
/* The MsgRxStartCmplt message is sent as a response to the MsgRxStart command 
 * when the message has been received and processed. */

/*
 * Cid_MsgRxStartCmplt (value = 0x2901) is an output message
 * for component Cid.
 */

#define Cid_MsgRxStartCmplt_Size		0

#define Cid_MsgRxStartCmplt	0x2901	/* 10497 */
/* The MsgStop message is sent to stop an ongoing operation. The MsgRxStopped 
 * is sent when a reception is stopped. The MsgRxRawStoppped is sent when a raw 
 * reception is stopped. The MsgTxStopped is sent when a transmission is 
 * stopped. Note. In FSK/ADSI application, only this stop message is used. */

/*
 * Cid_MsgStop (value = 0x2902) is an input message
 * for component Cid.
 */

#define Cid_MsgStop_Size		0

#define Cid_MsgStop	0x2902	/* 10498 */

#define Cid_MsgRxStopped_Reason_UserStop	0x1	/* 1 */

#define Cid_MsgRxStopped_Reason_Timeout	0x2	/* 2 */

#define Cid_MsgRxStopped_Reason_EOT	0x2	/* 2 */

#define Cid_MsgRxStopped_Reason_MaxData	0x4	/* 4 */

#define Cid_MsgRxStopped_Reason_PreambleError	0x8	/* 8 */

#define Cid_MsgRxStopped_Reason_EOS	0x80	/* 128 */

#define Cid_MsgRxStopped_Reason_Deallocated	0x172	/* 370 */

#define Cid_MsgRxStopped_Reason_ModemExited	0x173	/* 371 */

#define Cid_MsgRxStopped_Reason	0x380000	/* 3670016 */
typedef	UInt32	Cid_MsgRxStopped_Reason_t;

#define Cid_MsgRxStopped_BytesReceived	0x380004	/* 3670020 */
typedef	UInt32	Cid_MsgRxStopped_BytesReceived_t;

/*
 * Cid_MsgRxStopped (value = 0x2903) is an output message
 * for component Cid.
 */


typedef struct {
	UInt32	Reason;
	UInt32	BytesReceived;
} Cid_MsgRxStopped_t;

#define Cid_MsgRxStopped_get(msgPtr, structAddr, offset)	\
		    qMsgVarFieldGet((msgPtr), 2, &(offset),	\
			(Cid_MsgRxStopped_Reason), &((structAddr)->Reason),	\
			(Cid_MsgRxStopped_BytesReceived), &((structAddr)->BytesReceived))


#define Cid_MsgRxStopped_put(msgPtr, structAddr, offset)	\
		    qMsgVarFieldPut((msgPtr), 2, &(offset),	\
			(Cid_MsgRxStopped_Reason), &((structAddr)->Reason),	\
			(Cid_MsgRxStopped_BytesReceived), &((structAddr)->BytesReceived))


#define Cid_MsgRxStopped_Size		8

#define Cid_MsgRxStopped	0x2903	/* 10499 */
/* The MsgRxStopped is sent as a response to the MsgStop command when a Caller 
 * ID reception has stopped. Reason - reason why reception stopped. 
 * BytesReceived - bytes received during this session. */

#define Cid_MsgCID_MsgStatus_Success	0	/* 0 */

#define Cid_MsgCID_MsgStatus_CSFailed	0x1	/* 1 */

#define Cid_MsgCID_MsgStatus_CRC16Failed	0x2	/* 2 */

#define Cid_MsgCID_MsgStatus_TimeOut	0x3	/* 3 */

#define Cid_MsgCID_MsgStatus_Unknown	0xff	/* 255 */

#define Cid_MsgCID_MsgStatus	0x380000	/* 3670016 */
typedef	UInt32	Cid_MsgCID_MsgStatus_t;

#define Cid_MsgCID_CIDType_SDF	0x4	/* 4 */

#define Cid_MsgCID_CIDType_MDMF	0x80	/* 128 */

#define Cid_MsgCID_CIDType_Unknown	0xff	/* 255 */

#define Cid_MsgCID_CIDType	0x380004	/* 3670020 */
typedef	UInt32	Cid_MsgCID_CIDType_t;

#define Cid_MsgCID_CallerNumberStatus_Present	0	/* 0 */

#define Cid_MsgCID_CallerNumberStatus_Private	0x50	/* 80 */

#define Cid_MsgCID_CallerNumberStatus_OutOfArea	0x4f	/* 79 */

#define Cid_MsgCID_CallerNumberStatus_PublicPhone	0x43	/* 67 */

#define Cid_MsgCID_CallerNumberStatus_ServiceStatus	0x53	/* 83 */

#define Cid_MsgCID_CallerNumberStatus_Unknown	0xff	/* 255 */

#define Cid_MsgCID_CallerNumberStatus	0x380008	/* 3670024 */
typedef	UInt32	Cid_MsgCID_CallerNumberStatus_t;
/* Ascii chars received from CO to represent Month Day Hour Minute. This does 
 * not include the seperators. */

#define Cid_MsgCID_CallerNumber	0x20f80c	/* 2160652 */
typedef	UInt8	Cid_MsgCID_CallerNumber_t[32];

#define Cid_MsgCID_DateTimeStatus_Present	0	/* 0 */

#define Cid_MsgCID_DateTimeStatus_Unknown	0xff	/* 255 */

#define Cid_MsgCID_DateTimeStatus	0x38002c	/* 3670060 */
typedef	UInt32	Cid_MsgCID_DateTimeStatus_t;

#define Cid_MsgCID_DateTime	0x207830	/* 2127920 */
typedef	UInt8	Cid_MsgCID_DateTime_t[16];

#define Cid_MsgCID_MDataPresent_False	0xff	/* 255 */

#define Cid_MsgCID_MDataPresent_True	0	/* 0 */

#define Cid_MsgCID_MDataPresent	0x200040	/* 2097216 */
typedef	UInt8	Cid_MsgCID_MDataPresent_t;

#define Cid_MsgCID_EDataPresent_False	0xff	/* 255 */

#define Cid_MsgCID_EDataPresent_True	0	/* 0 */

#define Cid_MsgCID_EDataPresent	0x200041	/* 2097217 */
typedef	UInt8	Cid_MsgCID_EDataPresent_t;

#define Cid_MsgCID_EEDataPresent_False	0xff	/* 255 */

#define Cid_MsgCID_EEDataPresent_True	0	/* 0 */

#define Cid_MsgCID_EEDataPresent	0x200042	/* 2097218 */
typedef	UInt8	Cid_MsgCID_EEDataPresent_t;

#define Cid_MsgCID_MData_CallerNameStatus_Present	0	/* 0 */

#define Cid_MsgCID_MData_CallerNameStatus_Private	0x50	/* 80 */

#define Cid_MsgCID_MData_CallerNameStatus_OutOfArea	0x4f	/* 79 */

#define Cid_MsgCID_MData_CallerNameStatus_PublicPhone	0x43	/* 67 */

#define Cid_MsgCID_MData_CallerNameStatus_ServiceStatus	0x53	/* 83 */

#define Cid_MsgCID_MData_CallerNameStatus_Unknown	0xff	/* 255 */

#define Cid_MsgCID_MData_CallerNameStatus	0x380043	/* 3670083 */
typedef	UInt32	Cid_MsgCID_MData_CallerNameStatus_t;

#define Cid_MsgCID_MData_CallerName	0x21f847	/* 2226247 */
typedef	UInt8	Cid_MsgCID_MData_CallerName_t[64];


typedef struct {
	UInt32	CallerNameStatus;
	UInt8	CallerName[64];
} Cid_MsgCID_MData_t;

#define Cid_MsgCID_MData_get(msgPtr, structAddr, offset)	\
		    qMsgVarFieldGet((msgPtr), 2, &(offset),	\
			(Cid_MsgCID_MData_CallerNameStatus), &((structAddr)->CallerNameStatus),	\
			(Cid_MsgCID_MData_CallerName), &((structAddr)->CallerName))


#define Cid_MsgCID_MData_put(msgPtr, structAddr, offset)	\
		    qMsgVarFieldPut((msgPtr), 2, &(offset),	\
			(Cid_MsgCID_MData_CallerNameStatus), &((structAddr)->CallerNameStatus),	\
			(Cid_MsgCID_MData_CallerName), &((structAddr)->CallerName))


#define Cid_MsgCID_MData_Size		68

#define Cid_MsgCID_MData	0	/* 0 */

#define Cid_MsgCID_EData_PublicMsgStatus_Present	0	/* 0 */

#define Cid_MsgCID_EData_PublicMsgStatus_Unknown	0xff	/* 255 */

#define Cid_MsgCID_EData_PublicMsgStatus	0x380087	/* 3670151 */
typedef	UInt32	Cid_MsgCID_EData_PublicMsgStatus_t;

#define Cid_MsgCID_EData_PublicMsg	0x21f88b	/* 2226315 */
typedef	UInt8	Cid_MsgCID_EData_PublicMsg_t[64];

#define Cid_MsgCID_EData_VisualIndicatorStatus_Present	0	/* 0 */

#define Cid_MsgCID_EData_VisualIndicatorStatus_Unknown	0xff	/* 255 */

#define Cid_MsgCID_EData_VisualIndicatorStatus	0x3800cb	/* 3670219 */
typedef	UInt32	Cid_MsgCID_EData_VisualIndicatorStatus_t;

#define Cid_MsgCID_EData_VisualIndicator_Activate	0xff	/* 255 */

#define Cid_MsgCID_EData_VisualIndicator_Deactivate	0	/* 0 */

#define Cid_MsgCID_EData_VisualIndicator	0x3800cf	/* 3670223 */
typedef	UInt32	Cid_MsgCID_EData_VisualIndicator_t;


typedef struct {
	UInt32	PublicMsgStatus;
	UInt8	PublicMsg[64];
	UInt32	VisualIndicatorStatus;
	UInt32	VisualIndicator;
} Cid_MsgCID_EData_t;

#define Cid_MsgCID_EData_get(msgPtr, structAddr, offset)	\
		    qMsgVarFieldGet((msgPtr), 4, &(offset),	\
			(Cid_MsgCID_EData_PublicMsgStatus), &((structAddr)->PublicMsgStatus),	\
			(Cid_MsgCID_EData_PublicMsg), &((structAddr)->PublicMsg),	\
			(Cid_MsgCID_EData_VisualIndicatorStatus), &((structAddr)->VisualIndicatorStatus),	\
			(Cid_MsgCID_EData_VisualIndicator), &((structAddr)->VisualIndicator))


#define Cid_MsgCID_EData_put(msgPtr, structAddr, offset)	\
		    qMsgVarFieldPut((msgPtr), 4, &(offset),	\
			(Cid_MsgCID_EData_PublicMsgStatus), &((structAddr)->PublicMsgStatus),	\
			(Cid_MsgCID_EData_PublicMsg), &((structAddr)->PublicMsg),	\
			(Cid_MsgCID_EData_VisualIndicatorStatus), &((structAddr)->VisualIndicatorStatus),	\
			(Cid_MsgCID_EData_VisualIndicator), &((structAddr)->VisualIndicator))


#define Cid_MsgCID_EData_Size		76

#define Cid_MsgCID_EData	0x1	/* 1 */

#define Cid_MsgCID_EEData_CallQualifierStatus_Present	0	/* 0 */

#define Cid_MsgCID_EEData_CallQualifierStatus_Unknown	0xff	/* 255 */

#define Cid_MsgCID_EEData_CallQualifierStatus	0x3800d3	/* 3670227 */
typedef	UInt32	Cid_MsgCID_EEData_CallQualifierStatus_t;

#define Cid_MsgCID_EEData_CallQualifier_LongDistance	0x4c	/* 76 */

#define Cid_MsgCID_EEData_CallQualifier	0x3800d7	/* 3670231 */
typedef	UInt32	Cid_MsgCID_EEData_CallQualifier_t;

#define Cid_MsgCID_EEData_RedirectReasonStatus_Present	0	/* 0 */

#define Cid_MsgCID_EEData_RedirectReasonStatus_Unknown	0xff	/* 255 */

#define Cid_MsgCID_EEData_RedirectReasonStatus	0x3800db	/* 3670235 */
typedef	UInt32	Cid_MsgCID_EEData_RedirectReasonStatus_t;

#define Cid_MsgCID_EEData_RedirectReason_CallFwdUniversal	0	/* 0 */

#define Cid_MsgCID_EEData_RedirectReason_CallFwdBusy	0x1	/* 1 */

#define Cid_MsgCID_EEData_RedirectReason_CallFwdUnanswered	0x2	/* 2 */

#define Cid_MsgCID_EEData_RedirectReason_Unknown	0xff	/* 255 */
/*.uint32 	DialedNumberStatus {Present=0, Unknown=0xFF, ExpandedCalledInfo = 0x22}*/
/* If Dialed Number Status is 0x22, in Japan, then first 2 bytes inform the 
 * type of number and type of number plan. The TON : 0 - 1 International 
 * Number, 2-DomesticNumber, 3-Network Specific Number, 4-LocalNumber, 6-Speed 
 * Dial Number, 7-Reserved. Note that using using the status byte, the 
 * information about TON and NPI can be found out. */
/*.uint8   	DialedNumber[32]    */

#define Cid_MsgCID_EEData_RedirectReason	0x3800df	/* 3670239 */
typedef	UInt32	Cid_MsgCID_EEData_RedirectReason_t;

#define Cid_MsgCID_EEData_CallerNumberExtendedStatus_Present	0	/* 0 */

#define Cid_MsgCID_EEData_CallerNumberExtendedStatus_Unknown	0xff	/* 255 */

#define Cid_MsgCID_EEData_CallerNumberExtendedStatus	0x3800e3	/* 3670243 */
typedef	UInt32	Cid_MsgCID_EEData_CallerNumberExtendedStatus_t;

#define Cid_MsgCID_EEData_CallerNumberExtended	0x2018e7	/* 2103527 */
typedef	UInt8	Cid_MsgCID_EEData_CallerNumberExtended_t[4];

#define Cid_MsgCID_EEData_DDINumberStatus_Present	0	/* 0 */

#define Cid_MsgCID_EEData_DDINumberStatus_Unknown	0xff	/* 255 */

#define Cid_MsgCID_EEData_DDINumberStatus	0x3800eb	/* 3670251 */
typedef	UInt32	Cid_MsgCID_EEData_DDINumberStatus_t;

#define Cid_MsgCID_EEData_DDINumber	0x20f8ef	/* 2160879 */
typedef	UInt8	Cid_MsgCID_EEData_DDINumber_t[32];

#define Cid_MsgCID_EEData_DDINumberExtendedStatus_Present	0	/* 0 */

#define Cid_MsgCID_EEData_DDINumberExtendedStatus_Unknown	0xff	/* 255 */

#define Cid_MsgCID_EEData_DDINumberExtendedStatus	0x38010f	/* 3670287 */
typedef	UInt32	Cid_MsgCID_EEData_DDINumberExtendedStatus_t;

#define Cid_MsgCID_EEData_DDINumberExtended	0x201913	/* 2103571 */
typedef	UInt8	Cid_MsgCID_EEData_DDINumberExtended_t[4];

#define Cid_MsgCID_EEData_OriginalCallerNumberStatus_Present	0	/* 0 */

#define Cid_MsgCID_EEData_OriginalCallerNumberStatus_Unknown	0xff	/* 255 */

#define Cid_MsgCID_EEData_OriginalCallerNumberStatus	0x380117	/* 3670295 */
typedef	UInt32	Cid_MsgCID_EEData_OriginalCallerNumberStatus_t;

#define Cid_MsgCID_EEData_OriginalCallerNumber	0x20f91b	/* 2160923 */
typedef	UInt8	Cid_MsgCID_EEData_OriginalCallerNumber_t[32];

#define Cid_MsgCID_EEData_OriginalCallerNumberExtendedStatus_Present	0	/* 0 */

#define Cid_MsgCID_EEData_OriginalCallerNumberExtendedStatus_Unknown	0xff	/* 255 */

#define Cid_MsgCID_EEData_OriginalCallerNumberExtendedStatus	0x38013b	/* 3670331 */
typedef	UInt32	Cid_MsgCID_EEData_OriginalCallerNumberExtendedStatus_t;

#define Cid_MsgCID_EEData_OriginalCallerNumberExtended	0x20193f	/* 2103615 */
typedef	UInt8	Cid_MsgCID_EEData_OriginalCallerNumberExtended_t[4];


typedef struct {
	UInt32	CallQualifierStatus;
	UInt32	CallQualifier;
	UInt32	RedirectReasonStatus;
	UInt32	RedirectReason;
	UInt32	CallerNumberExtendedStatus;
	UInt8	CallerNumberExtended[4];
	UInt32	DDINumberStatus;
	UInt8	DDINumber[32];
	UInt32	DDINumberExtendedStatus;
	UInt8	DDINumberExtended[4];
	UInt32	OriginalCallerNumberStatus;
	UInt8	OriginalCallerNumber[32];
	UInt32	OriginalCallerNumberExtendedStatus;
	UInt8	OriginalCallerNumberExtended[4];
} Cid_MsgCID_EEData_t;

#define Cid_MsgCID_EEData_get(msgPtr, structAddr, offset)	\
		    qMsgVarFieldGet((msgPtr), 14, &(offset),	\
			(Cid_MsgCID_EEData_CallQualifierStatus), &((structAddr)->CallQualifierStatus),	\
			(Cid_MsgCID_EEData_CallQualifier), &((structAddr)->CallQualifier),	\
			(Cid_MsgCID_EEData_RedirectReasonStatus), &((structAddr)->RedirectReasonStatus),	\
			(Cid_MsgCID_EEData_RedirectReason), &((structAddr)->RedirectReason),	\
			(Cid_MsgCID_EEData_CallerNumberExtendedStatus), &((structAddr)->CallerNumberExtendedStatus),	\
			(Cid_MsgCID_EEData_CallerNumberExtended), &((structAddr)->CallerNumberExtended),	\
			(Cid_MsgCID_EEData_DDINumberStatus), &((structAddr)->DDINumberStatus),	\
			(Cid_MsgCID_EEData_DDINumber), &((structAddr)->DDINumber),	\
			(Cid_MsgCID_EEData_DDINumberExtendedStatus), &((structAddr)->DDINumberExtendedStatus),	\
			(Cid_MsgCID_EEData_DDINumberExtended), &((structAddr)->DDINumberExtended),	\
			(Cid_MsgCID_EEData_OriginalCallerNumberStatus), &((structAddr)->OriginalCallerNumberStatus),	\
			(Cid_MsgCID_EEData_OriginalCallerNumber), &((structAddr)->OriginalCallerNumber),	\
			(Cid_MsgCID_EEData_OriginalCallerNumberExtendedStatus), &((structAddr)->OriginalCallerNumberExtendedStatus),	\
			(Cid_MsgCID_EEData_OriginalCallerNumberExtended), &((structAddr)->OriginalCallerNumberExtended))


#define Cid_MsgCID_EEData_put(msgPtr, structAddr, offset)	\
		    qMsgVarFieldPut((msgPtr), 14, &(offset),	\
			(Cid_MsgCID_EEData_CallQualifierStatus), &((structAddr)->CallQualifierStatus),	\
			(Cid_MsgCID_EEData_CallQualifier), &((structAddr)->CallQualifier),	\
			(Cid_MsgCID_EEData_RedirectReasonStatus), &((structAddr)->RedirectReasonStatus),	\
			(Cid_MsgCID_EEData_RedirectReason), &((structAddr)->RedirectReason),	\
			(Cid_MsgCID_EEData_CallerNumberExtendedStatus), &((structAddr)->CallerNumberExtendedStatus),	\
			(Cid_MsgCID_EEData_CallerNumberExtended), &((structAddr)->CallerNumberExtended),	\
			(Cid_MsgCID_EEData_DDINumberStatus), &((structAddr)->DDINumberStatus),	\
			(Cid_MsgCID_EEData_DDINumber), &((structAddr)->DDINumber),	\
			(Cid_MsgCID_EEData_DDINumberExtendedStatus), &((structAddr)->DDINumberExtendedStatus),	\
			(Cid_MsgCID_EEData_DDINumberExtended), &((structAddr)->DDINumberExtended),	\
			(Cid_MsgCID_EEData_OriginalCallerNumberStatus), &((structAddr)->OriginalCallerNumberStatus),	\
			(Cid_MsgCID_EEData_OriginalCallerNumber), &((structAddr)->OriginalCallerNumber),	\
			(Cid_MsgCID_EEData_OriginalCallerNumberExtendedStatus), &((structAddr)->OriginalCallerNumberExtendedStatus),	\
			(Cid_MsgCID_EEData_OriginalCallerNumberExtended), &((structAddr)->OriginalCallerNumberExtended))


#define Cid_MsgCID_EEData_Size		112

#define Cid_MsgCID_EEData	0x2	/* 2 */

/*
 * Cid_MsgCID (value = 0x2904) is an output message
 * for component Cid.
 */


typedef struct {
	UInt32	MsgStatus;
	UInt32	CIDType;
	UInt32	CallerNumberStatus;
	UInt8	CallerNumber[32];
	UInt32	DateTimeStatus;
	UInt8	DateTime[16];
	UInt8	MDataPresent;
	UInt8	EDataPresent;
	UInt8	EEDataPresent;
	Cid_MsgCID_MData_t	Cid_MsgCID_MData_i;
	Cid_MsgCID_EData_t	Cid_MsgCID_EData_i;
	Cid_MsgCID_EEData_t	Cid_MsgCID_EEData_i;
} Cid_MsgCID_t;

#define Cid_MsgCID_get(msgPtr, structAddr, offset)	\
		    qMsgVarFieldGet((msgPtr), 9, &(offset),	\
			(Cid_MsgCID_MsgStatus), &((structAddr)->MsgStatus),	\
			(Cid_MsgCID_CIDType), &((structAddr)->CIDType),	\
			(Cid_MsgCID_CallerNumberStatus), &((structAddr)->CallerNumberStatus),	\
			(Cid_MsgCID_CallerNumber), &((structAddr)->CallerNumber),	\
			(Cid_MsgCID_DateTimeStatus), &((structAddr)->DateTimeStatus),	\
			(Cid_MsgCID_DateTime), &((structAddr)->DateTime),	\
			(Cid_MsgCID_MDataPresent), &((structAddr)->MDataPresent),	\
			(Cid_MsgCID_EDataPresent), &((structAddr)->EDataPresent),	\
			(Cid_MsgCID_EEDataPresent), &((structAddr)->EEDataPresent));	\
		    Cid_MsgCID_EEData_get(msgPtr, &((structAddr)->Cid_MsgCID_EEData_i), offset);	\
		    Cid_MsgCID_EData_get(msgPtr, &((structAddr)->Cid_MsgCID_EData_i), offset);	\
		    Cid_MsgCID_MData_get(msgPtr, &((structAddr)->Cid_MsgCID_MData_i), offset)


#define Cid_MsgCID_put(msgPtr, structAddr, offset)	\
		    qMsgVarFieldPut((msgPtr), 9, &(offset),	\
			(Cid_MsgCID_MsgStatus), &((structAddr)->MsgStatus),	\
			(Cid_MsgCID_CIDType), &((structAddr)->CIDType),	\
			(Cid_MsgCID_CallerNumberStatus), &((structAddr)->CallerNumberStatus),	\
			(Cid_MsgCID_CallerNumber), &((structAddr)->CallerNumber),	\
			(Cid_MsgCID_DateTimeStatus), &((structAddr)->DateTimeStatus),	\
			(Cid_MsgCID_DateTime), &((structAddr)->DateTime),	\
			(Cid_MsgCID_MDataPresent), &((structAddr)->MDataPresent),	\
			(Cid_MsgCID_EDataPresent), &((structAddr)->EDataPresent),	\
			(Cid_MsgCID_EEDataPresent), &((structAddr)->EEDataPresent));	\
		    Cid_MsgCID_EEData_put(msgPtr, &((structAddr)->Cid_MsgCID_EEData_i), offset);	\
		    Cid_MsgCID_EData_put(msgPtr, &((structAddr)->Cid_MsgCID_EData_i), offset);	\
		    Cid_MsgCID_MData_put(msgPtr, &((structAddr)->Cid_MsgCID_MData_i), offset)


#define Cid_MsgCID_Size		323

#define Cid_MsgCID	0x2904	/* 10500 */
/* The MsgCID message is sent with available data. This message contains the 
 * parsed information from received data. MsgStatus - This variable field tells 
 * what was the result of parsing operation. CIDType This field holds the 
 * received Caller ID type. CallerNumberStatus - This field details if the 
 * caller number is present or not. Due to privacy or out of area, the data may 
 * be absent and will be indicated so. If this variable is set to Present, the 
 * next field holds received caller number. If CallerNumberStatus is not set to 
 * Unknown and Present then the field holds the reason of absence for the 
 * caller number. The CO may send Private/OutOfArea/ServiceStatus etc as the 
 * reason for absence. CallerNumber - This field holds a string with caller 
 * number. It is valid only when CallerNumberStatus is set to Present. 
 * DateTime- This field holds Hour, Minute, Day, Month - These fields hold the 
 * time as received from the CO. MDataPresent - This field indicates if the 
 * next variable data is present. In case of MDMF reception, this field will be 
 * turned on to indicate that next variable field has valid data. The Mdata 
 * field holds CallerName and CallerName status. CallerNameStatus - This field 
 * is set to Present if the caller name is received from CO. It can be set to 
 * Private, OutOfArea, PayPhone, Operator, Reminder, Out or Unknown. CallerName 
 * - This field holds an ASCII string with caller name as received from CO. 
 * EdataPresent - This field indicates the presence of data portion Edata. This 
 * portion holds PublicMsgStatus, PublicMsg, VisualIndicatorStatus and 
 * VisualIndicator. VisualIndicator - This filed holds the number received from 
 * CO indicating the message waiting status. PublicMsgStatus - Is set to 
 * Present if PublicMsg is received from the CO. PublicMsg - The Japan CO may 
 * send this information to CPE. EEDataPresent - This field is set to TRUE if 
 * MDMF reception gathers information for reason for redirection, DDINumber, 
 * OriginalCallerNumber, etc. CallQualifier - Indicates the type of call 
 * received. It can be set to Long Distance in US caller Id operations. 
 * RedirectReason - This field holds redirection reason. DDINumber - This field 
 * holds the dialed number received from CO. Thus in above message definition, 
 * there are two possible variable data segments which can also be sent with 
 * this message. CallerNumberExtended - Holds the TON/NPI information about the 
 * caller number. DDINumberExtended - Holds the TON/NPI information about the 
 * DDN/DDI number. OriginalCallerNumber - Holds the number from where the call 
 * was redircted/forwarded. OriginalCallerNumberExtended - Holds the TON/NPI 
 * information about the original caller number. There are status fields 
 * associated with these fields to indicate the absence and presence of the 
 * data in the fields. */

#define Cid_MsgCIDRaw_MsgType	0x200000	/* 2097152 */
typedef	UInt8	Cid_MsgCIDRaw_MsgType_t;

#define Cid_MsgCIDRaw_MsgLength	0x200001	/* 2097153 */
typedef	UInt8	Cid_MsgCIDRaw_MsgLength_t;

#define Cid_MsgCIDRaw_RawData	0x27f002	/* 2617346 */
typedef	UInt8	Cid_MsgCIDRaw_RawData_t[255];
/* This is CRC16 or Check Sum information */

#define Cid_MsgCIDRaw_DataIntegrityCheck	0x200101	/* 2097409 */
typedef	UInt8	Cid_MsgCIDRaw_DataIntegrityCheck_t;

/*
 * Cid_MsgCIDRaw (value = 0x2905) is an output message
 * for component Cid.
 */


typedef struct {
	UInt8	MsgType;
	UInt8	MsgLength;
	UInt8	RawData[255];
	UInt8	DataIntegrityCheck;
} Cid_MsgCIDRaw_t;

#define Cid_MsgCIDRaw_get(msgPtr, structAddr, offset)	\
		    qMsgVarFieldGet((msgPtr), 4, &(offset),	\
			(Cid_MsgCIDRaw_MsgType), &((structAddr)->MsgType),	\
			(Cid_MsgCIDRaw_MsgLength), &((structAddr)->MsgLength),	\
			(Cid_MsgCIDRaw_RawData), &((structAddr)->RawData),	\
			(Cid_MsgCIDRaw_DataIntegrityCheck), &((structAddr)->DataIntegrityCheck))


#define Cid_MsgCIDRaw_put(msgPtr, structAddr, offset)	\
		    qMsgVarFieldPut((msgPtr), 4, &(offset),	\
			(Cid_MsgCIDRaw_MsgType), &((structAddr)->MsgType),	\
			(Cid_MsgCIDRaw_MsgLength), &((structAddr)->MsgLength),	\
			(Cid_MsgCIDRaw_RawData), &((structAddr)->RawData),	\
			(Cid_MsgCIDRaw_DataIntegrityCheck), &((structAddr)->DataIntegrityCheck))


#define Cid_MsgCIDRaw_Size		258

#define Cid_MsgCIDRaw	0x2905	/* 10501 */
/* The MsgCIDRaw message is sent with available data. This message is 
 * generated when the ParmCIDStandardType field is set to CID_RAW / CID_RAWCS / 
 * CID_RAWCRC16. If set to CID_RAW, no data integrity check is done on the 
 * incoming data. For the CID_RAWCS the incoming data is verified for check 
 * sum. When CID_RAWCRC16 is the value of this field, the data input is 
 * verified for CRC16 verification. This will be done in the Japan operations. 
 * The check sum is used in BellCore and British Telecom standards for data 
 * integrity. */
/* The MsgGetLastCID message is a command message to obtain the last Caller ID 
 * data. This command message will generate an error if the ParmCIDStandardType 
 * was previously set to CID_RAW / CID_RAWCS / CID_RAWCRC16. This message 
 * expects to retrieve the last parsed Caller ID information. */

/*
 * Cid_MsgGetLastCID (value = 0x2906) is an input message
 * for component Cid.
 */

#define Cid_MsgGetLastCID_Size		0

#define Cid_MsgGetLastCID	0x2906	/* 10502 */

#define Cid_MsgGetLastCIDCmplt_MsgStatus_Success	0	/* 0 */

#define Cid_MsgGetLastCIDCmplt_MsgStatus_CSFailed	0x1	/* 1 */

#define Cid_MsgGetLastCIDCmplt_MsgStatus_CRC16Failed	0x2	/* 2 */

#define Cid_MsgGetLastCIDCmplt_MsgStatus_TimeOut	0x3	/* 3 */

#define Cid_MsgGetLastCIDCmplt_MsgStatus_Unknown	0xff	/* 255 */

#define Cid_MsgGetLastCIDCmplt_MsgStatus	0x380000	/* 3670016 */
typedef	UInt32	Cid_MsgGetLastCIDCmplt_MsgStatus_t;

#define Cid_MsgGetLastCIDCmplt_CIDType_SDF	0x4	/* 4 */

#define Cid_MsgGetLastCIDCmplt_CIDType_MDMF	0x80	/* 128 */

#define Cid_MsgGetLastCIDCmplt_CIDType_Unknown	0xff	/* 255 */

#define Cid_MsgGetLastCIDCmplt_CIDType	0x380004	/* 3670020 */
typedef	UInt32	Cid_MsgGetLastCIDCmplt_CIDType_t;

#define Cid_MsgGetLastCIDCmplt_CallerNumberStatus_Present	0	/* 0 */

#define Cid_MsgGetLastCIDCmplt_CallerNumberStatus_Private	0x50	/* 80 */

#define Cid_MsgGetLastCIDCmplt_CallerNumberStatus_OutOfArea	0x4f	/* 79 */

#define Cid_MsgGetLastCIDCmplt_CallerNumberStatus_PublicPhone	0x43	/* 67 */

#define Cid_MsgGetLastCIDCmplt_CallerNumberStatus_ServiceStatus	0x53	/* 83 */

#define Cid_MsgGetLastCIDCmplt_CallerNumberStatus_Unknown	0xff	/* 255 */

#define Cid_MsgGetLastCIDCmplt_CallerNumberStatus	0x380008	/* 3670024 */
typedef	UInt32	Cid_MsgGetLastCIDCmplt_CallerNumberStatus_t;
/* Ascii chars received from CO to represent Month Day Hour Minute. This does 
 * not include the seperators. */

#define Cid_MsgGetLastCIDCmplt_CallerNumber	0x20f80c	/* 2160652 */
typedef	UInt8	Cid_MsgGetLastCIDCmplt_CallerNumber_t[32];

#define Cid_MsgGetLastCIDCmplt_DateTimeStatus_Present	0	/* 0 */

#define Cid_MsgGetLastCIDCmplt_DateTimeStatus_Unknown	0xff	/* 255 */

#define Cid_MsgGetLastCIDCmplt_DateTimeStatus	0x38002c	/* 3670060 */
typedef	UInt32	Cid_MsgGetLastCIDCmplt_DateTimeStatus_t;

#define Cid_MsgGetLastCIDCmplt_DateTime	0x207830	/* 2127920 */
typedef	UInt8	Cid_MsgGetLastCIDCmplt_DateTime_t[16];

#define Cid_MsgGetLastCIDCmplt_MDataPresent_False	0x100	/* 256 */

#define Cid_MsgGetLastCIDCmplt_MDataPresent_True	0x101	/* 257 */

#define Cid_MsgGetLastCIDCmplt_MDataPresent	0x200040	/* 2097216 */
typedef	UInt8	Cid_MsgGetLastCIDCmplt_MDataPresent_t;

#define Cid_MsgGetLastCIDCmplt_EDataPresent_False	0x102	/* 258 */

#define Cid_MsgGetLastCIDCmplt_EDataPresent_True	0x103	/* 259 */

#define Cid_MsgGetLastCIDCmplt_EDataPresent	0x200041	/* 2097217 */
typedef	UInt8	Cid_MsgGetLastCIDCmplt_EDataPresent_t;

#define Cid_MsgGetLastCIDCmplt_EEDataPresent_False	0x104	/* 260 */

#define Cid_MsgGetLastCIDCmplt_EEDataPresent_True	0x105	/* 261 */

#define Cid_MsgGetLastCIDCmplt_EEDataPresent	0x200042	/* 2097218 */
typedef	UInt8	Cid_MsgGetLastCIDCmplt_EEDataPresent_t;

#define Cid_MsgGetLastCIDCmplt_MData_CallerNameStatus_Present	0	/* 0 */

#define Cid_MsgGetLastCIDCmplt_MData_CallerNameStatus_Private	0x50	/* 80 */

#define Cid_MsgGetLastCIDCmplt_MData_CallerNameStatus_OutOfArea	0x4f	/* 79 */

#define Cid_MsgGetLastCIDCmplt_MData_CallerNameStatus_PublicPhone	0x43	/* 67 */

#define Cid_MsgGetLastCIDCmplt_MData_CallerNameStatus_ServiceStatus	0x53	/* 83 */

#define Cid_MsgGetLastCIDCmplt_MData_CallerNameStatus_Unknown	0xff	/* 255 */

#define Cid_MsgGetLastCIDCmplt_MData_CallerNameStatus	0x380043	/* 3670083 */
typedef	UInt32	Cid_MsgGetLastCIDCmplt_MData_CallerNameStatus_t;

#define Cid_MsgGetLastCIDCmplt_MData_CallerName	0x21f847	/* 2226247 */
typedef	UInt8	Cid_MsgGetLastCIDCmplt_MData_CallerName_t[64];


typedef struct {
	UInt32	CallerNameStatus;
	UInt8	CallerName[64];
} Cid_MsgGetLastCIDCmplt_MData_t;

#define Cid_MsgGetLastCIDCmplt_MData_get(msgPtr, structAddr, offset)	\
		    qMsgVarFieldGet((msgPtr), 2, &(offset),	\
			(Cid_MsgGetLastCIDCmplt_MData_CallerNameStatus), &((structAddr)->CallerNameStatus),	\
			(Cid_MsgGetLastCIDCmplt_MData_CallerName), &((structAddr)->CallerName))


#define Cid_MsgGetLastCIDCmplt_MData_put(msgPtr, structAddr, offset)	\
		    qMsgVarFieldPut((msgPtr), 2, &(offset),	\
			(Cid_MsgGetLastCIDCmplt_MData_CallerNameStatus), &((structAddr)->CallerNameStatus),	\
			(Cid_MsgGetLastCIDCmplt_MData_CallerName), &((structAddr)->CallerName))


#define Cid_MsgGetLastCIDCmplt_MData_Size		68

#define Cid_MsgGetLastCIDCmplt_MData	0x3	/* 3 */

#define Cid_MsgGetLastCIDCmplt_EData_PublicMsgStatus_Present	0	/* 0 */

#define Cid_MsgGetLastCIDCmplt_EData_PublicMsgStatus_Unknown	0xff	/* 255 */

#define Cid_MsgGetLastCIDCmplt_EData_PublicMsgStatus	0x380087	/* 3670151 */
typedef	UInt32	Cid_MsgGetLastCIDCmplt_EData_PublicMsgStatus_t;

#define Cid_MsgGetLastCIDCmplt_EData_PublicMsg	0x21f88b	/* 2226315 */
typedef	UInt8	Cid_MsgGetLastCIDCmplt_EData_PublicMsg_t[64];

#define Cid_MsgGetLastCIDCmplt_EData_VisualIndicatorStatus_Present	0	/* 0 */

#define Cid_MsgGetLastCIDCmplt_EData_VisualIndicatorStatus_Unknown	0xff	/* 255 */

#define Cid_MsgGetLastCIDCmplt_EData_VisualIndicatorStatus	0x3800cb	/* 3670219 */
typedef	UInt32	Cid_MsgGetLastCIDCmplt_EData_VisualIndicatorStatus_t;

#define Cid_MsgGetLastCIDCmplt_EData_VisualIndicator_Activate	0xff	/* 255 */

#define Cid_MsgGetLastCIDCmplt_EData_VisualIndicator_Deactivate	0	/* 0 */

#define Cid_MsgGetLastCIDCmplt_EData_VisualIndicator	0x3800cf	/* 3670223 */
typedef	UInt32	Cid_MsgGetLastCIDCmplt_EData_VisualIndicator_t;


typedef struct {
	UInt32	PublicMsgStatus;
	UInt8	PublicMsg[64];
	UInt32	VisualIndicatorStatus;
	UInt32	VisualIndicator;
} Cid_MsgGetLastCIDCmplt_EData_t;

#define Cid_MsgGetLastCIDCmplt_EData_get(msgPtr, structAddr, offset)	\
		    qMsgVarFieldGet((msgPtr), 4, &(offset),	\
			(Cid_MsgGetLastCIDCmplt_EData_PublicMsgStatus), &((structAddr)->PublicMsgStatus),	\
			(Cid_MsgGetLastCIDCmplt_EData_PublicMsg), &((structAddr)->PublicMsg),	\
			(Cid_MsgGetLastCIDCmplt_EData_VisualIndicatorStatus), &((structAddr)->VisualIndicatorStatus),	\
			(Cid_MsgGetLastCIDCmplt_EData_VisualIndicator), &((structAddr)->VisualIndicator))


#define Cid_MsgGetLastCIDCmplt_EData_put(msgPtr, structAddr, offset)	\
		    qMsgVarFieldPut((msgPtr), 4, &(offset),	\
			(Cid_MsgGetLastCIDCmplt_EData_PublicMsgStatus), &((structAddr)->PublicMsgStatus),	\
			(Cid_MsgGetLastCIDCmplt_EData_PublicMsg), &((structAddr)->PublicMsg),	\
			(Cid_MsgGetLastCIDCmplt_EData_VisualIndicatorStatus), &((structAddr)->VisualIndicatorStatus),	\
			(Cid_MsgGetLastCIDCmplt_EData_VisualIndicator), &((structAddr)->VisualIndicator))


#define Cid_MsgGetLastCIDCmplt_EData_Size		76

#define Cid_MsgGetLastCIDCmplt_EData	0x4	/* 4 */

#define Cid_MsgGetLastCIDCmplt_EEData_CallQualifierStatus_Present	0	/* 0 */

#define Cid_MsgGetLastCIDCmplt_EEData_CallQualifierStatus_Unknown	0xff	/* 255 */

#define Cid_MsgGetLastCIDCmplt_EEData_CallQualifierStatus	0x3800d3	/* 3670227 */
typedef	UInt32	Cid_MsgGetLastCIDCmplt_EEData_CallQualifierStatus_t;

#define Cid_MsgGetLastCIDCmplt_EEData_CallQualifier_LongDistance	0x4c	/* 76 */

#define Cid_MsgGetLastCIDCmplt_EEData_CallQualifier	0x3800d7	/* 3670231 */
typedef	UInt32	Cid_MsgGetLastCIDCmplt_EEData_CallQualifier_t;

#define Cid_MsgGetLastCIDCmplt_EEData_RedirectReasonStatus_Present	0	/* 0 */

#define Cid_MsgGetLastCIDCmplt_EEData_RedirectReasonStatus_Unknown	0xff	/* 255 */

#define Cid_MsgGetLastCIDCmplt_EEData_RedirectReasonStatus	0x3800db	/* 3670235 */
typedef	UInt32	Cid_MsgGetLastCIDCmplt_EEData_RedirectReasonStatus_t;

#define Cid_MsgGetLastCIDCmplt_EEData_RedirectReason_CallFwdUniversal	0	/* 0 */

#define Cid_MsgGetLastCIDCmplt_EEData_RedirectReason_CallFwdBusy	0x1	/* 1 */

#define Cid_MsgGetLastCIDCmplt_EEData_RedirectReason_CallFwdUnanswered	0x2	/* 2 */

#define Cid_MsgGetLastCIDCmplt_EEData_RedirectReason_Unknown	0xff	/* 255 */
/*.uint32 	DialedNumberStatus {Present=0, Unknown=0xFF, ExpandedCalledInfo = 0x22}*/
/* If Dialed Number Status is 0x22, in Japan, then first 2 bytes inform the 
 * type of number and type of number plan. The TON : 0 - 1 International 
 * Number, 2-DomesticNumber, 3-Network Specific Number, 4-LocalNumber, 6-Speed 
 * Dial Number, 7-Reserved. Note that using using the status byte, the 
 * information about TON and NPI can be found out. */
/*.uint8   	DialedNumber[32]    */

#define Cid_MsgGetLastCIDCmplt_EEData_RedirectReason	0x3800df	/* 3670239 */
typedef	UInt32	Cid_MsgGetLastCIDCmplt_EEData_RedirectReason_t;

#define Cid_MsgGetLastCIDCmplt_EEData_CallerNumberExtendedStatus_Present	0	/* 0 */

#define Cid_MsgGetLastCIDCmplt_EEData_CallerNumberExtendedStatus_Unknown	0xff	/* 255 */

#define Cid_MsgGetLastCIDCmplt_EEData_CallerNumberExtendedStatus	0x3800e3	/* 3670243 */
typedef	UInt32	Cid_MsgGetLastCIDCmplt_EEData_CallerNumberExtendedStatus_t;

#define Cid_MsgGetLastCIDCmplt_EEData_CallerNumberExtended	0x2018e7	/* 2103527 */
typedef	UInt8	Cid_MsgGetLastCIDCmplt_EEData_CallerNumberExtended_t[4];

#define Cid_MsgGetLastCIDCmplt_EEData_DDINumberStatus_Present	0	/* 0 */

#define Cid_MsgGetLastCIDCmplt_EEData_DDINumberStatus_Unknown	0xff	/* 255 */

#define Cid_MsgGetLastCIDCmplt_EEData_DDINumberStatus	0x3800eb	/* 3670251 */
typedef	UInt32	Cid_MsgGetLastCIDCmplt_EEData_DDINumberStatus_t;

#define Cid_MsgGetLastCIDCmplt_EEData_DDINumber	0x20f8ef	/* 2160879 */
typedef	UInt8	Cid_MsgGetLastCIDCmplt_EEData_DDINumber_t[32];

#define Cid_MsgGetLastCIDCmplt_EEData_DDINumberExtendedStatus_Present	0	/* 0 */

#define Cid_MsgGetLastCIDCmplt_EEData_DDINumberExtendedStatus_Unknown	0xff	/* 255 */

#define Cid_MsgGetLastCIDCmplt_EEData_DDINumberExtendedStatus	0x38010f	/* 3670287 */
typedef	UInt32	Cid_MsgGetLastCIDCmplt_EEData_DDINumberExtendedStatus_t;

#define Cid_MsgGetLastCIDCmplt_EEData_DDINumberExtended	0x201913	/* 2103571 */
typedef	UInt8	Cid_MsgGetLastCIDCmplt_EEData_DDINumberExtended_t[4];

#define Cid_MsgGetLastCIDCmplt_EEData_OriginalCallerNumberStatus_Present	0	/* 0 */

#define Cid_MsgGetLastCIDCmplt_EEData_OriginalCallerNumberStatus_Unknown	0xff	/* 255 */

#define Cid_MsgGetLastCIDCmplt_EEData_OriginalCallerNumberStatus	0x380117	/* 3670295 */
typedef	UInt32	Cid_MsgGetLastCIDCmplt_EEData_OriginalCallerNumberStatus_t;

#define Cid_MsgGetLastCIDCmplt_EEData_OriginalCallerNumber	0x20f91b	/* 2160923 */
typedef	UInt8	Cid_MsgGetLastCIDCmplt_EEData_OriginalCallerNumber_t[32];

#define Cid_MsgGetLastCIDCmplt_EEData_OriginalCallerNumberExtendedStatus_Present	0	/* 0 */

#define Cid_MsgGetLastCIDCmplt_EEData_OriginalCallerNumberExtendedStatus_Unknown	0xff	/* 255 */

#define Cid_MsgGetLastCIDCmplt_EEData_OriginalCallerNumberExtendedStatus	0x38013b	/* 3670331 */
typedef	UInt32	Cid_MsgGetLastCIDCmplt_EEData_OriginalCallerNumberExtendedStatus_t;

#define Cid_MsgGetLastCIDCmplt_EEData_OriginalCallerNumberExtended	0x20193f	/* 2103615 */
typedef	UInt8	Cid_MsgGetLastCIDCmplt_EEData_OriginalCallerNumberExtended_t[4];


typedef struct {
	UInt32	CallQualifierStatus;
	UInt32	CallQualifier;
	UInt32	RedirectReasonStatus;
	UInt32	RedirectReason;
	UInt32	CallerNumberExtendedStatus;
	UInt8	CallerNumberExtended[4];
	UInt32	DDINumberStatus;
	UInt8	DDINumber[32];
	UInt32	DDINumberExtendedStatus;
	UInt8	DDINumberExtended[4];
	UInt32	OriginalCallerNumberStatus;
	UInt8	OriginalCallerNumber[32];
	UInt32	OriginalCallerNumberExtendedStatus;
	UInt8	OriginalCallerNumberExtended[4];
} Cid_MsgGetLastCIDCmplt_EEData_t;

#define Cid_MsgGetLastCIDCmplt_EEData_get(msgPtr, structAddr, offset)	\
		    qMsgVarFieldGet((msgPtr), 14, &(offset),	\
			(Cid_MsgGetLastCIDCmplt_EEData_CallQualifierStatus), &((structAddr)->CallQualifierStatus),	\
			(Cid_MsgGetLastCIDCmplt_EEData_CallQualifier), &((structAddr)->CallQualifier),	\
			(Cid_MsgGetLastCIDCmplt_EEData_RedirectReasonStatus), &((structAddr)->RedirectReasonStatus),	\
			(Cid_MsgGetLastCIDCmplt_EEData_RedirectReason), &((structAddr)->RedirectReason),	\
			(Cid_MsgGetLastCIDCmplt_EEData_CallerNumberExtendedStatus), &((structAddr)->CallerNumberExtendedStatus),	\
			(Cid_MsgGetLastCIDCmplt_EEData_CallerNumberExtended), &((structAddr)->CallerNumberExtended),	\
			(Cid_MsgGetLastCIDCmplt_EEData_DDINumberStatus), &((structAddr)->DDINumberStatus),	\
			(Cid_MsgGetLastCIDCmplt_EEData_DDINumber), &((structAddr)->DDINumber),	\
			(Cid_MsgGetLastCIDCmplt_EEData_DDINumberExtendedStatus), &((structAddr)->DDINumberExtendedStatus),	\
			(Cid_MsgGetLastCIDCmplt_EEData_DDINumberExtended), &((structAddr)->DDINumberExtended),	\
			(Cid_MsgGetLastCIDCmplt_EEData_OriginalCallerNumberStatus), &((structAddr)->OriginalCallerNumberStatus),	\
			(Cid_MsgGetLastCIDCmplt_EEData_OriginalCallerNumber), &((structAddr)->OriginalCallerNumber),	\
			(Cid_MsgGetLastCIDCmplt_EEData_OriginalCallerNumberExtendedStatus), &((structAddr)->OriginalCallerNumberExtendedStatus),	\
			(Cid_MsgGetLastCIDCmplt_EEData_OriginalCallerNumberExtended), &((structAddr)->OriginalCallerNumberExtended))


#define Cid_MsgGetLastCIDCmplt_EEData_put(msgPtr, structAddr, offset)	\
		    qMsgVarFieldPut((msgPtr), 14, &(offset),	\
			(Cid_MsgGetLastCIDCmplt_EEData_CallQualifierStatus), &((structAddr)->CallQualifierStatus),	\
			(Cid_MsgGetLastCIDCmplt_EEData_CallQualifier), &((structAddr)->CallQualifier),	\
			(Cid_MsgGetLastCIDCmplt_EEData_RedirectReasonStatus), &((structAddr)->RedirectReasonStatus),	\
			(Cid_MsgGetLastCIDCmplt_EEData_RedirectReason), &((structAddr)->RedirectReason),	\
			(Cid_MsgGetLastCIDCmplt_EEData_CallerNumberExtendedStatus), &((structAddr)->CallerNumberExtendedStatus),	\
			(Cid_MsgGetLastCIDCmplt_EEData_CallerNumberExtended), &((structAddr)->CallerNumberExtended),	\
			(Cid_MsgGetLastCIDCmplt_EEData_DDINumberStatus), &((structAddr)->DDINumberStatus),	\
			(Cid_MsgGetLastCIDCmplt_EEData_DDINumber), &((structAddr)->DDINumber),	\
			(Cid_MsgGetLastCIDCmplt_EEData_DDINumberExtendedStatus), &((structAddr)->DDINumberExtendedStatus),	\
			(Cid_MsgGetLastCIDCmplt_EEData_DDINumberExtended), &((structAddr)->DDINumberExtended),	\
			(Cid_MsgGetLastCIDCmplt_EEData_OriginalCallerNumberStatus), &((structAddr)->OriginalCallerNumberStatus),	\
			(Cid_MsgGetLastCIDCmplt_EEData_OriginalCallerNumber), &((structAddr)->OriginalCallerNumber),	\
			(Cid_MsgGetLastCIDCmplt_EEData_OriginalCallerNumberExtendedStatus), &((structAddr)->OriginalCallerNumberExtendedStatus),	\
			(Cid_MsgGetLastCIDCmplt_EEData_OriginalCallerNumberExtended), &((structAddr)->OriginalCallerNumberExtended))


#define Cid_MsgGetLastCIDCmplt_EEData_Size		112

#define Cid_MsgGetLastCIDCmplt_EEData	0x5	/* 5 */

/*
 * Cid_MsgGetLastCIDCmplt (value = 0x2907) is an output message
 * for component Cid.
 */


typedef struct {
	UInt32	MsgStatus;
	UInt32	CIDType;
	UInt32	CallerNumberStatus;
	UInt8	CallerNumber[32];
	UInt32	DateTimeStatus;
	UInt8	DateTime[16];
	UInt8	MDataPresent;
	UInt8	EDataPresent;
	UInt8	EEDataPresent;
	Cid_MsgGetLastCIDCmplt_MData_t	Cid_MsgGetLastCIDCmplt_MData_i;
	Cid_MsgGetLastCIDCmplt_EData_t	Cid_MsgGetLastCIDCmplt_EData_i;
	Cid_MsgGetLastCIDCmplt_EEData_t	Cid_MsgGetLastCIDCmplt_EEData_i;
} Cid_MsgGetLastCIDCmplt_t;

#define Cid_MsgGetLastCIDCmplt_get(msgPtr, structAddr, offset)	\
		    qMsgVarFieldGet((msgPtr), 9, &(offset),	\
			(Cid_MsgGetLastCIDCmplt_MsgStatus), &((structAddr)->MsgStatus),	\
			(Cid_MsgGetLastCIDCmplt_CIDType), &((structAddr)->CIDType),	\
			(Cid_MsgGetLastCIDCmplt_CallerNumberStatus), &((structAddr)->CallerNumberStatus),	\
			(Cid_MsgGetLastCIDCmplt_CallerNumber), &((structAddr)->CallerNumber),	\
			(Cid_MsgGetLastCIDCmplt_DateTimeStatus), &((structAddr)->DateTimeStatus),	\
			(Cid_MsgGetLastCIDCmplt_DateTime), &((structAddr)->DateTime),	\
			(Cid_MsgGetLastCIDCmplt_MDataPresent), &((structAddr)->MDataPresent),	\
			(Cid_MsgGetLastCIDCmplt_EDataPresent), &((structAddr)->EDataPresent),	\
			(Cid_MsgGetLastCIDCmplt_EEDataPresent), &((structAddr)->EEDataPresent));	\
		    Cid_MsgGetLastCIDCmplt_EEData_get(msgPtr, &((structAddr)->Cid_MsgGetLastCIDCmplt_EEData_i), offset);	\
		    Cid_MsgGetLastCIDCmplt_EData_get(msgPtr, &((structAddr)->Cid_MsgGetLastCIDCmplt_EData_i), offset);	\
		    Cid_MsgGetLastCIDCmplt_MData_get(msgPtr, &((structAddr)->Cid_MsgGetLastCIDCmplt_MData_i), offset)


#define Cid_MsgGetLastCIDCmplt_put(msgPtr, structAddr, offset)	\
		    qMsgVarFieldPut((msgPtr), 9, &(offset),	\
			(Cid_MsgGetLastCIDCmplt_MsgStatus), &((structAddr)->MsgStatus),	\
			(Cid_MsgGetLastCIDCmplt_CIDType), &((structAddr)->CIDType),	\
			(Cid_MsgGetLastCIDCmplt_CallerNumberStatus), &((structAddr)->CallerNumberStatus),	\
			(Cid_MsgGetLastCIDCmplt_CallerNumber), &((structAddr)->CallerNumber),	\
			(Cid_MsgGetLastCIDCmplt_DateTimeStatus), &((structAddr)->DateTimeStatus),	\
			(Cid_MsgGetLastCIDCmplt_DateTime), &((structAddr)->DateTime),	\
			(Cid_MsgGetLastCIDCmplt_MDataPresent), &((structAddr)->MDataPresent),	\
			(Cid_MsgGetLastCIDCmplt_EDataPresent), &((structAddr)->EDataPresent),	\
			(Cid_MsgGetLastCIDCmplt_EEDataPresent), &((structAddr)->EEDataPresent));	\
		    Cid_MsgGetLastCIDCmplt_EEData_put(msgPtr, &((structAddr)->Cid_MsgGetLastCIDCmplt_EEData_i), offset);	\
		    Cid_MsgGetLastCIDCmplt_EData_put(msgPtr, &((structAddr)->Cid_MsgGetLastCIDCmplt_EData_i), offset);	\
		    Cid_MsgGetLastCIDCmplt_MData_put(msgPtr, &((structAddr)->Cid_MsgGetLastCIDCmplt_MData_i), offset)


#define Cid_MsgGetLastCIDCmplt_Size		323

#define Cid_MsgGetLastCIDCmplt	0x2907	/* 10503 */
/* The MsgGetLastCIDCmplt is returned with Caller Id data when MsgLastCID 
 * message is received. Please refer to the explanation of caller id fields 
 * from MsgCID message. */
/* The MsgGetLastCIDRaw message is a command to obtain the copy of raw data 
 * from last caller Id reception operation. */

/*
 * Cid_MsgGetLastCIDRaw (value = 0x2908) is an input message
 * for component Cid.
 */

#define Cid_MsgGetLastCIDRaw_Size		0

#define Cid_MsgGetLastCIDRaw	0x2908	/* 10504 */

#define Cid_MsgGetLastCIDRawCmplt_MsgType	0x200000	/* 2097152 */
typedef	UInt8	Cid_MsgGetLastCIDRawCmplt_MsgType_t;

#define Cid_MsgGetLastCIDRawCmplt_MsgLength	0x200001	/* 2097153 */
typedef	UInt8	Cid_MsgGetLastCIDRawCmplt_MsgLength_t;

#define Cid_MsgGetLastCIDRawCmplt_RawData	0x27f002	/* 2617346 */
typedef	UInt8	Cid_MsgGetLastCIDRawCmplt_RawData_t[255];
/* This is CRC16 or Check Sum information */

#define Cid_MsgGetLastCIDRawCmplt_DataIntegrityCheck	0x200101	/* 2097409 */
typedef	UInt8	Cid_MsgGetLastCIDRawCmplt_DataIntegrityCheck_t;

/*
 * Cid_MsgGetLastCIDRawCmplt (value = 0x2909) is an output message
 * for component Cid.
 */


typedef struct {
	UInt8	MsgType;
	UInt8	MsgLength;
	UInt8	RawData[255];
	UInt8	DataIntegrityCheck;
} Cid_MsgGetLastCIDRawCmplt_t;

#define Cid_MsgGetLastCIDRawCmplt_get(msgPtr, structAddr, offset)	\
		    qMsgVarFieldGet((msgPtr), 4, &(offset),	\
			(Cid_MsgGetLastCIDRawCmplt_MsgType), &((structAddr)->MsgType),	\
			(Cid_MsgGetLastCIDRawCmplt_MsgLength), &((structAddr)->MsgLength),	\
			(Cid_MsgGetLastCIDRawCmplt_RawData), &((structAddr)->RawData),	\
			(Cid_MsgGetLastCIDRawCmplt_DataIntegrityCheck), &((structAddr)->DataIntegrityCheck))


#define Cid_MsgGetLastCIDRawCmplt_put(msgPtr, structAddr, offset)	\
		    qMsgVarFieldPut((msgPtr), 4, &(offset),	\
			(Cid_MsgGetLastCIDRawCmplt_MsgType), &((structAddr)->MsgType),	\
			(Cid_MsgGetLastCIDRawCmplt_MsgLength), &((structAddr)->MsgLength),	\
			(Cid_MsgGetLastCIDRawCmplt_RawData), &((structAddr)->RawData),	\
			(Cid_MsgGetLastCIDRawCmplt_DataIntegrityCheck), &((structAddr)->DataIntegrityCheck))


#define Cid_MsgGetLastCIDRawCmplt_Size		258

#define Cid_MsgGetLastCIDRawCmplt	0x2909	/* 10505 */
/* The MsgGetLastCIDRawCmplt is a respone message to the query for raw copy of 
 * last obtained Caller ID data. The body of the messsage holds the RawData 
 * buffer which has the necessary data. RawData - Buffer with raw data. */

#define Cid_MsgRxRawStart_LastFlag	0x200000	/* 2097152 */
typedef	UInt8	Cid_MsgRxRawStart_LastFlag_t;

#define Cid_MsgRxRawStart_MaxData	0x380001	/* 3670017 */
typedef	UInt32	Cid_MsgRxRawStart_MaxData_t;
/*  10 ms unit.  */

#define Cid_MsgRxRawStart_MaxTime	0x380005	/* 3670021 */
typedef	UInt32	Cid_MsgRxRawStart_MaxTime_t;
/*1 ms unit , must be multiples of 12ms*/

#define Cid_MsgRxRawStart_RxEndOfNotificationTime	0x280009	/* 2621449 */
typedef	UInt16	Cid_MsgRxRawStart_RxEndOfNotificationTime_t;
/* indicate which standard will be used.*/

#define Cid_MsgRxRawStart_StandardType	0x20000b	/* 2097163 */
typedef	UInt8	Cid_MsgRxRawStart_StandardType_t;
/* the number of bits of Channel Seizure.*/

#define Cid_MsgRxRawStart_ChannelSeizure	0x28000c	/* 2621452 */
typedef	UInt16	Cid_MsgRxRawStart_ChannelSeizure_t;
/* the number of bits of Mark signal.*/

#define Cid_MsgRxRawStart_MarkLength	0x28000e	/* 2621454 */
typedef	UInt16	Cid_MsgRxRawStart_MarkLength_t;

/*
 * Cid_MsgRxRawStart (value = 0x290a) is an input message
 * for component Cid.
 */


typedef struct {
	UInt8	LastFlag;
	UInt32	MaxData;
	UInt32	MaxTime;
	UInt16	RxEndOfNotificationTime;
	UInt8	StandardType;
	UInt16	ChannelSeizure;
	UInt16	MarkLength;
} Cid_MsgRxRawStart_t;

#define Cid_MsgRxRawStart_get(msgPtr, structAddr, offset)	\
		    qMsgVarFieldGet((msgPtr), 7, &(offset),	\
			(Cid_MsgRxRawStart_LastFlag), &((structAddr)->LastFlag),	\
			(Cid_MsgRxRawStart_MaxData), &((structAddr)->MaxData),	\
			(Cid_MsgRxRawStart_MaxTime), &((structAddr)->MaxTime),	\
			(Cid_MsgRxRawStart_RxEndOfNotificationTime), &((structAddr)->RxEndOfNotificationTime),	\
			(Cid_MsgRxRawStart_StandardType), &((structAddr)->StandardType),	\
			(Cid_MsgRxRawStart_ChannelSeizure), &((structAddr)->ChannelSeizure),	\
			(Cid_MsgRxRawStart_MarkLength), &((structAddr)->MarkLength))


#define Cid_MsgRxRawStart_put(msgPtr, structAddr, offset)	\
		    qMsgVarFieldPut((msgPtr), 7, &(offset),	\
			(Cid_MsgRxRawStart_LastFlag), &((structAddr)->LastFlag),	\
			(Cid_MsgRxRawStart_MaxData), &((structAddr)->MaxData),	\
			(Cid_MsgRxRawStart_MaxTime), &((structAddr)->MaxTime),	\
			(Cid_MsgRxRawStart_RxEndOfNotificationTime), &((structAddr)->RxEndOfNotificationTime),	\
			(Cid_MsgRxRawStart_StandardType), &((structAddr)->StandardType),	\
			(Cid_MsgRxRawStart_ChannelSeizure), &((structAddr)->ChannelSeizure),	\
			(Cid_MsgRxRawStart_MarkLength), &((structAddr)->MarkLength))


#define Cid_MsgRxRawStart_Size		16

#define Cid_MsgRxRawStart	0x290a	/* 10506 */
/* Raw Block Tranfer Commands. These are the hooks for ADSI */
/* The MsgRxRawStart message is a command to obtain the incoming FSK data 
 * without parsing. LastFlag - Contains terminating conditions. Check 
 * MsgTxRawData for detailed information. MaxData - The max data bytes to be 
 * received before the session is terminated. This value should only be given 
 * when CID_SESSION_START and CID_TERM_MAX_DATA both set. It is a new feature 
 * and for FSK/ADSI only. MaxTime - The max time elapsed before the session is 
 * terminated. This value should only be given when CID_SESSION_START and 
 * CID_TERM_MAX_TIME both set. It is a new feature and for FSK/ADSI only. Note. 
 * The unit is 10ms. RxEndOfNotificationTime - The max silence time elapsed 
 * before modem sending out end of rx notification. Note. The unit is 1ms, but 
 * the value must be multiple of 12ms(DSP frame time). If 0 is given, a default 
 * 120ms will be used internally. StandardType - The standard will be used. 
 * ChannelSeizure - How many channel seizure bits will be transmitted. 
 * MarkLength - How many mark bits will be transmitted. */
/* Raw Block Tranfer Commands. These are the hooks for ADSI */
/* The MsgRxRawStartCmplt message is sent as a respones to MsgRxRawStart 
 * command. It is acknowledgement to the command. */

/*
 * Cid_MsgRxRawStartCmplt (value = 0x290b) is an output message
 * for component Cid.
 */

#define Cid_MsgRxRawStartCmplt_Size		0

#define Cid_MsgRxRawStartCmplt	0x290b	/* 10507 */

#define Cid_MsgRawData_RawDataSize	0x200000	/* 2097152 */
typedef	UInt8	Cid_MsgRawData_RawDataSize_t;

#define Cid_MsgRawData_RawData	0x27f001	/* 2617345 */
typedef	UInt8	Cid_MsgRawData_RawData_t[255];

#define Cid_MsgRawData_LastFlag	0x200100	/* 2097408 */
typedef	UInt8	Cid_MsgRawData_LastFlag_t;

/*
 * Cid_MsgRawData (value = 0x290c) is an output message
 * for component Cid.
 */


typedef struct {
	UInt8	RawDataSize;
	UInt8	RawData[255];
	UInt8	LastFlag;
} Cid_MsgRawData_t;

#define Cid_MsgRawData_get(msgPtr, structAddr, offset)	\
		    qMsgVarFieldGet((msgPtr), 3, &(offset),	\
			(Cid_MsgRawData_RawDataSize), &((structAddr)->RawDataSize),	\
			(Cid_MsgRawData_RawData), &((structAddr)->RawData),	\
			(Cid_MsgRawData_LastFlag), &((structAddr)->LastFlag))


#define Cid_MsgRawData_put(msgPtr, structAddr, offset)	\
		    qMsgVarFieldPut((msgPtr), 3, &(offset),	\
			(Cid_MsgRawData_RawDataSize), &((structAddr)->RawDataSize),	\
			(Cid_MsgRawData_RawData), &((structAddr)->RawData),	\
			(Cid_MsgRawData_LastFlag), &((structAddr)->LastFlag))


#define Cid_MsgRawData_Size		257

#define Cid_MsgRawData	0x290c	/* 10508 */
/* The MsgRawData message is sent as a completion message to the MsgRxStart 
 * command. RawData - The raw data received. LastFlag - Indicates if there are 
 * more data blocks of information available. Ref. MsgTxRawData for further 
 * description. */

#define Cid_MsgTxStart_MsgStatus_Success	0	/* 0 */

#define Cid_MsgTxStart_MsgStatus_CSFailed	0x1	/* 1 */

#define Cid_MsgTxStart_MsgStatus_CRC16Failed	0x2	/* 2 */

#define Cid_MsgTxStart_MsgStatus_TimeOut	0x3	/* 3 */

#define Cid_MsgTxStart_MsgStatus_Unknown	0xff	/* 255 */

#define Cid_MsgTxStart_MsgStatus	0x380000	/* 3670016 */
typedef	UInt32	Cid_MsgTxStart_MsgStatus_t;

#define Cid_MsgTxStart_CIDType_SDF	0x4	/* 4 */

#define Cid_MsgTxStart_CIDType_MDMF	0x80	/* 128 */

#define Cid_MsgTxStart_CIDType_Unknown	0xff	/* 255 */

#define Cid_MsgTxStart_CIDType	0x380004	/* 3670020 */
typedef	UInt32	Cid_MsgTxStart_CIDType_t;

#define Cid_MsgTxStart_CallerNumberStatus_Present	0	/* 0 */

#define Cid_MsgTxStart_CallerNumberStatus_Private	0x50	/* 80 */

#define Cid_MsgTxStart_CallerNumberStatus_OutOfArea	0x4f	/* 79 */

#define Cid_MsgTxStart_CallerNumberStatus_PublicPhone	0x43	/* 67 */

#define Cid_MsgTxStart_CallerNumberStatus_ServiceStatus	0x53	/* 83 */

#define Cid_MsgTxStart_CallerNumberStatus_Unknown	0xff	/* 255 */

#define Cid_MsgTxStart_CallerNumberStatus	0x380008	/* 3670024 */
typedef	UInt32	Cid_MsgTxStart_CallerNumberStatus_t;
/* Ascii chars received from CO to represent Month Day Hour Minute. This does 
 * not include the seperators. */

#define Cid_MsgTxStart_CallerNumber	0x20f80c	/* 2160652 */
typedef	UInt8	Cid_MsgTxStart_CallerNumber_t[32];

#define Cid_MsgTxStart_DateTimeStatus_Present	0	/* 0 */

#define Cid_MsgTxStart_DateTimeStatus_Unknown	0xff	/* 255 */

#define Cid_MsgTxStart_DateTimeStatus	0x38002c	/* 3670060 */
typedef	UInt32	Cid_MsgTxStart_DateTimeStatus_t;

#define Cid_MsgTxStart_DateTime	0x207830	/* 2127920 */
typedef	UInt8	Cid_MsgTxStart_DateTime_t[16];

#define Cid_MsgTxStart_MDataPresent_False	0x100	/* 256 */

#define Cid_MsgTxStart_MDataPresent_True	0x101	/* 257 */

#define Cid_MsgTxStart_MDataPresent	0x200040	/* 2097216 */
typedef	UInt8	Cid_MsgTxStart_MDataPresent_t;

#define Cid_MsgTxStart_EDataPresent_False	0x102	/* 258 */

#define Cid_MsgTxStart_EDataPresent_True	0x103	/* 259 */

#define Cid_MsgTxStart_EDataPresent	0x200041	/* 2097217 */
typedef	UInt8	Cid_MsgTxStart_EDataPresent_t;

#define Cid_MsgTxStart_EEDataPresent_False	0x104	/* 260 */

#define Cid_MsgTxStart_EEDataPresent_True	0x105	/* 261 */

#define Cid_MsgTxStart_EEDataPresent	0x200042	/* 2097218 */
typedef	UInt8	Cid_MsgTxStart_EEDataPresent_t;

#define Cid_MsgTxStart_MData_CallerNameStatus_Present	0	/* 0 */

#define Cid_MsgTxStart_MData_CallerNameStatus_Private	0x50	/* 80 */

#define Cid_MsgTxStart_MData_CallerNameStatus_OutOfArea	0x4f	/* 79 */

#define Cid_MsgTxStart_MData_CallerNameStatus_PublicPhone	0x43	/* 67 */

#define Cid_MsgTxStart_MData_CallerNameStatus_ServiceStatus	0x53	/* 83 */

#define Cid_MsgTxStart_MData_CallerNameStatus_Unknown	0xff	/* 255 */

#define Cid_MsgTxStart_MData_CallerNameStatus	0x380043	/* 3670083 */
typedef	UInt32	Cid_MsgTxStart_MData_CallerNameStatus_t;

#define Cid_MsgTxStart_MData_CallerName	0x21f847	/* 2226247 */
typedef	UInt8	Cid_MsgTxStart_MData_CallerName_t[64];


typedef struct {
	UInt32	CallerNameStatus;
	UInt8	CallerName[64];
} Cid_MsgTxStart_MData_t;

#define Cid_MsgTxStart_MData_get(msgPtr, structAddr, offset)	\
		    qMsgVarFieldGet((msgPtr), 2, &(offset),	\
			(Cid_MsgTxStart_MData_CallerNameStatus), &((structAddr)->CallerNameStatus),	\
			(Cid_MsgTxStart_MData_CallerName), &((structAddr)->CallerName))


#define Cid_MsgTxStart_MData_put(msgPtr, structAddr, offset)	\
		    qMsgVarFieldPut((msgPtr), 2, &(offset),	\
			(Cid_MsgTxStart_MData_CallerNameStatus), &((structAddr)->CallerNameStatus),	\
			(Cid_MsgTxStart_MData_CallerName), &((structAddr)->CallerName))


#define Cid_MsgTxStart_MData_Size		68

#define Cid_MsgTxStart_MData	0x6	/* 6 */

#define Cid_MsgTxStart_EData_PublicMsgStatus_Present	0	/* 0 */

#define Cid_MsgTxStart_EData_PublicMsgStatus_Unknown	0xff	/* 255 */

#define Cid_MsgTxStart_EData_PublicMsgStatus	0x380087	/* 3670151 */
typedef	UInt32	Cid_MsgTxStart_EData_PublicMsgStatus_t;

#define Cid_MsgTxStart_EData_PublicMsg	0x21f88b	/* 2226315 */
typedef	UInt8	Cid_MsgTxStart_EData_PublicMsg_t[64];

#define Cid_MsgTxStart_EData_VisualIndicatorStatus_Present	0	/* 0 */

#define Cid_MsgTxStart_EData_VisualIndicatorStatus_Unknown	0xff	/* 255 */

#define Cid_MsgTxStart_EData_VisualIndicatorStatus	0x3800cb	/* 3670219 */
typedef	UInt32	Cid_MsgTxStart_EData_VisualIndicatorStatus_t;

#define Cid_MsgTxStart_EData_VisualIndicator_Activate	0xff	/* 255 */

#define Cid_MsgTxStart_EData_VisualIndicator_Deactivate	0	/* 0 */

#define Cid_MsgTxStart_EData_VisualIndicator	0x3800cf	/* 3670223 */
typedef	UInt32	Cid_MsgTxStart_EData_VisualIndicator_t;


typedef struct {
	UInt32	PublicMsgStatus;
	UInt8	PublicMsg[64];
	UInt32	VisualIndicatorStatus;
	UInt32	VisualIndicator;
} Cid_MsgTxStart_EData_t;

#define Cid_MsgTxStart_EData_get(msgPtr, structAddr, offset)	\
		    qMsgVarFieldGet((msgPtr), 4, &(offset),	\
			(Cid_MsgTxStart_EData_PublicMsgStatus), &((structAddr)->PublicMsgStatus),	\
			(Cid_MsgTxStart_EData_PublicMsg), &((structAddr)->PublicMsg),	\
			(Cid_MsgTxStart_EData_VisualIndicatorStatus), &((structAddr)->VisualIndicatorStatus),	\
			(Cid_MsgTxStart_EData_VisualIndicator), &((structAddr)->VisualIndicator))


#define Cid_MsgTxStart_EData_put(msgPtr, structAddr, offset)	\
		    qMsgVarFieldPut((msgPtr), 4, &(offset),	\
			(Cid_MsgTxStart_EData_PublicMsgStatus), &((structAddr)->PublicMsgStatus),	\
			(Cid_MsgTxStart_EData_PublicMsg), &((structAddr)->PublicMsg),	\
			(Cid_MsgTxStart_EData_VisualIndicatorStatus), &((structAddr)->VisualIndicatorStatus),	\
			(Cid_MsgTxStart_EData_VisualIndicator), &((structAddr)->VisualIndicator))


#define Cid_MsgTxStart_EData_Size		76

#define Cid_MsgTxStart_EData	0x7	/* 7 */

#define Cid_MsgTxStart_EEData_CallQualifierStatus_Present	0	/* 0 */

#define Cid_MsgTxStart_EEData_CallQualifierStatus_Unknown	0xff	/* 255 */

#define Cid_MsgTxStart_EEData_CallQualifierStatus	0x3800d3	/* 3670227 */
typedef	UInt32	Cid_MsgTxStart_EEData_CallQualifierStatus_t;

#define Cid_MsgTxStart_EEData_CallQualifier_LongDistance	0x4c	/* 76 */

#define Cid_MsgTxStart_EEData_CallQualifier	0x3800d7	/* 3670231 */
typedef	UInt32	Cid_MsgTxStart_EEData_CallQualifier_t;

#define Cid_MsgTxStart_EEData_RedirectReasonStatus_Present	0	/* 0 */

#define Cid_MsgTxStart_EEData_RedirectReasonStatus_Unknown	0xff	/* 255 */

#define Cid_MsgTxStart_EEData_RedirectReasonStatus	0x3800db	/* 3670235 */
typedef	UInt32	Cid_MsgTxStart_EEData_RedirectReasonStatus_t;

#define Cid_MsgTxStart_EEData_RedirectReason_CallFwdUniversal	0	/* 0 */

#define Cid_MsgTxStart_EEData_RedirectReason_CallFwdBusy	0x1	/* 1 */

#define Cid_MsgTxStart_EEData_RedirectReason_CallFwdUnanswered	0x2	/* 2 */

#define Cid_MsgTxStart_EEData_RedirectReason_Unknown	0xff	/* 255 */
/*.uint32 	DialedNumberStatus {Present=0, Unknown=0xFF, ExpandedCalledInfo = 0x22}*/
/* If Dialed Number Status is 0x22, in Japan, then first 2 bytes inform the 
 * type of number and type of number plan. The TON : 0 - 1 International 
 * Number, 2-DomesticNumber, 3-Network Specific Number, 4-LocalNumber, 6-Speed 
 * Dial Number, 7-Reserved. Note that using using the status byte, the 
 * information about TON and NPI can be found out. */
/*.uint8   	DialedNumber[32]    */

#define Cid_MsgTxStart_EEData_RedirectReason	0x3800df	/* 3670239 */
typedef	UInt32	Cid_MsgTxStart_EEData_RedirectReason_t;

#define Cid_MsgTxStart_EEData_CallerNumberExtendedStatus_Present	0	/* 0 */

#define Cid_MsgTxStart_EEData_CallerNumberExtendedStatus_Unknown	0xff	/* 255 */

#define Cid_MsgTxStart_EEData_CallerNumberExtendedStatus	0x3800e3	/* 3670243 */
typedef	UInt32	Cid_MsgTxStart_EEData_CallerNumberExtendedStatus_t;

#define Cid_MsgTxStart_EEData_CallerNumberExtended	0x2018e7	/* 2103527 */
typedef	UInt8	Cid_MsgTxStart_EEData_CallerNumberExtended_t[4];

#define Cid_MsgTxStart_EEData_DDINumberStatus_Present	0	/* 0 */

#define Cid_MsgTxStart_EEData_DDINumberStatus_Unknown	0xff	/* 255 */

#define Cid_MsgTxStart_EEData_DDINumberStatus	0x3800eb	/* 3670251 */
typedef	UInt32	Cid_MsgTxStart_EEData_DDINumberStatus_t;

#define Cid_MsgTxStart_EEData_DDINumber	0x20f8ef	/* 2160879 */
typedef	UInt8	Cid_MsgTxStart_EEData_DDINumber_t[32];

#define Cid_MsgTxStart_EEData_DDINumberExtendedStatus_Present	0	/* 0 */

#define Cid_MsgTxStart_EEData_DDINumberExtendedStatus_Unknown	0xff	/* 255 */

#define Cid_MsgTxStart_EEData_DDINumberExtendedStatus	0x38010f	/* 3670287 */
typedef	UInt32	Cid_MsgTxStart_EEData_DDINumberExtendedStatus_t;

#define Cid_MsgTxStart_EEData_DDINumberExtended	0x201913	/* 2103571 */
typedef	UInt8	Cid_MsgTxStart_EEData_DDINumberExtended_t[4];

#define Cid_MsgTxStart_EEData_OriginalCallerNumberStatus_Present	0	/* 0 */

#define Cid_MsgTxStart_EEData_OriginalCallerNumberStatus_Unknown	0xff	/* 255 */

#define Cid_MsgTxStart_EEData_OriginalCallerNumberStatus	0x380117	/* 3670295 */
typedef	UInt32	Cid_MsgTxStart_EEData_OriginalCallerNumberStatus_t;

#define Cid_MsgTxStart_EEData_OriginalCallerNumber	0x20f91b	/* 2160923 */
typedef	UInt8	Cid_MsgTxStart_EEData_OriginalCallerNumber_t[32];

#define Cid_MsgTxStart_EEData_OriginalCallerNumberExtendedStatus_Present	0	/* 0 */

#define Cid_MsgTxStart_EEData_OriginalCallerNumberExtendedStatus_Unknown	0xff	/* 255 */

#define Cid_MsgTxStart_EEData_OriginalCallerNumberExtendedStatus	0x38013b	/* 3670331 */
typedef	UInt32	Cid_MsgTxStart_EEData_OriginalCallerNumberExtendedStatus_t;

#define Cid_MsgTxStart_EEData_OriginalCallerNumberExtended	0x20193f	/* 2103615 */
typedef	UInt8	Cid_MsgTxStart_EEData_OriginalCallerNumberExtended_t[4];


typedef struct {
	UInt32	CallQualifierStatus;
	UInt32	CallQualifier;
	UInt32	RedirectReasonStatus;
	UInt32	RedirectReason;
	UInt32	CallerNumberExtendedStatus;
	UInt8	CallerNumberExtended[4];
	UInt32	DDINumberStatus;
	UInt8	DDINumber[32];
	UInt32	DDINumberExtendedStatus;
	UInt8	DDINumberExtended[4];
	UInt32	OriginalCallerNumberStatus;
	UInt8	OriginalCallerNumber[32];
	UInt32	OriginalCallerNumberExtendedStatus;
	UInt8	OriginalCallerNumberExtended[4];
} Cid_MsgTxStart_EEData_t;

#define Cid_MsgTxStart_EEData_get(msgPtr, structAddr, offset)	\
		    qMsgVarFieldGet((msgPtr), 14, &(offset),	\
			(Cid_MsgTxStart_EEData_CallQualifierStatus), &((structAddr)->CallQualifierStatus),	\
			(Cid_MsgTxStart_EEData_CallQualifier), &((structAddr)->CallQualifier),	\
			(Cid_MsgTxStart_EEData_RedirectReasonStatus), &((structAddr)->RedirectReasonStatus),	\
			(Cid_MsgTxStart_EEData_RedirectReason), &((structAddr)->RedirectReason),	\
			(Cid_MsgTxStart_EEData_CallerNumberExtendedStatus), &((structAddr)->CallerNumberExtendedStatus),	\
			(Cid_MsgTxStart_EEData_CallerNumberExtended), &((structAddr)->CallerNumberExtended),	\
			(Cid_MsgTxStart_EEData_DDINumberStatus), &((structAddr)->DDINumberStatus),	\
			(Cid_MsgTxStart_EEData_DDINumber), &((structAddr)->DDINumber),	\
			(Cid_MsgTxStart_EEData_DDINumberExtendedStatus), &((structAddr)->DDINumberExtendedStatus),	\
			(Cid_MsgTxStart_EEData_DDINumberExtended), &((structAddr)->DDINumberExtended),	\
			(Cid_MsgTxStart_EEData_OriginalCallerNumberStatus), &((structAddr)->OriginalCallerNumberStatus),	\
			(Cid_MsgTxStart_EEData_OriginalCallerNumber), &((structAddr)->OriginalCallerNumber),	\
			(Cid_MsgTxStart_EEData_OriginalCallerNumberExtendedStatus), &((structAddr)->OriginalCallerNumberExtendedStatus),	\
			(Cid_MsgTxStart_EEData_OriginalCallerNumberExtended), &((structAddr)->OriginalCallerNumberExtended))


#define Cid_MsgTxStart_EEData_put(msgPtr, structAddr, offset)	\
		    qMsgVarFieldPut((msgPtr), 14, &(offset),	\
			(Cid_MsgTxStart_EEData_CallQualifierStatus), &((structAddr)->CallQualifierStatus),	\
			(Cid_MsgTxStart_EEData_CallQualifier), &((structAddr)->CallQualifier),	\
			(Cid_MsgTxStart_EEData_RedirectReasonStatus), &((structAddr)->RedirectReasonStatus),	\
			(Cid_MsgTxStart_EEData_RedirectReason), &((structAddr)->RedirectReason),	\
			(Cid_MsgTxStart_EEData_CallerNumberExtendedStatus), &((structAddr)->CallerNumberExtendedStatus),	\
			(Cid_MsgTxStart_EEData_CallerNumberExtended), &((structAddr)->CallerNumberExtended),	\
			(Cid_MsgTxStart_EEData_DDINumberStatus), &((structAddr)->DDINumberStatus),	\
			(Cid_MsgTxStart_EEData_DDINumber), &((structAddr)->DDINumber),	\
			(Cid_MsgTxStart_EEData_DDINumberExtendedStatus), &((structAddr)->DDINumberExtendedStatus),	\
			(Cid_MsgTxStart_EEData_DDINumberExtended), &((structAddr)->DDINumberExtended),	\
			(Cid_MsgTxStart_EEData_OriginalCallerNumberStatus), &((structAddr)->OriginalCallerNumberStatus),	\
			(Cid_MsgTxStart_EEData_OriginalCallerNumber), &((structAddr)->OriginalCallerNumber),	\
			(Cid_MsgTxStart_EEData_OriginalCallerNumberExtendedStatus), &((structAddr)->OriginalCallerNumberExtendedStatus),	\
			(Cid_MsgTxStart_EEData_OriginalCallerNumberExtended), &((structAddr)->OriginalCallerNumberExtended))


#define Cid_MsgTxStart_EEData_Size		112

#define Cid_MsgTxStart_EEData	0x8	/* 8 */

/*
 * Cid_MsgTxStart (value = 0x290d) is an input message
 * for component Cid.
 */


typedef struct {
	UInt32	MsgStatus;
	UInt32	CIDType;
	UInt32	CallerNumberStatus;
	UInt8	CallerNumber[32];
	UInt32	DateTimeStatus;
	UInt8	DateTime[16];
	UInt8	MDataPresent;
	UInt8	EDataPresent;
	UInt8	EEDataPresent;
	Cid_MsgTxStart_MData_t	Cid_MsgTxStart_MData_i;
	Cid_MsgTxStart_EData_t	Cid_MsgTxStart_EData_i;
	Cid_MsgTxStart_EEData_t	Cid_MsgTxStart_EEData_i;
} Cid_MsgTxStart_t;

#define Cid_MsgTxStart_get(msgPtr, structAddr, offset)	\
		    qMsgVarFieldGet((msgPtr), 9, &(offset),	\
			(Cid_MsgTxStart_MsgStatus), &((structAddr)->MsgStatus),	\
			(Cid_MsgTxStart_CIDType), &((structAddr)->CIDType),	\
			(Cid_MsgTxStart_CallerNumberStatus), &((structAddr)->CallerNumberStatus),	\
			(Cid_MsgTxStart_CallerNumber), &((structAddr)->CallerNumber),	\
			(Cid_MsgTxStart_DateTimeStatus), &((structAddr)->DateTimeStatus),	\
			(Cid_MsgTxStart_DateTime), &((structAddr)->DateTime),	\
			(Cid_MsgTxStart_MDataPresent), &((structAddr)->MDataPresent),	\
			(Cid_MsgTxStart_EDataPresent), &((structAddr)->EDataPresent),	\
			(Cid_MsgTxStart_EEDataPresent), &((structAddr)->EEDataPresent));	\
		    Cid_MsgTxStart_EEData_get(msgPtr, &((structAddr)->Cid_MsgTxStart_EEData_i), offset);	\
		    Cid_MsgTxStart_EData_get(msgPtr, &((structAddr)->Cid_MsgTxStart_EData_i), offset);	\
		    Cid_MsgTxStart_MData_get(msgPtr, &((structAddr)->Cid_MsgTxStart_MData_i), offset)


#define Cid_MsgTxStart_put(msgPtr, structAddr, offset)	\
		    qMsgVarFieldPut((msgPtr), 9, &(offset),	\
			(Cid_MsgTxStart_MsgStatus), &((structAddr)->MsgStatus),	\
			(Cid_MsgTxStart_CIDType), &((structAddr)->CIDType),	\
			(Cid_MsgTxStart_CallerNumberStatus), &((structAddr)->CallerNumberStatus),	\
			(Cid_MsgTxStart_CallerNumber), &((structAddr)->CallerNumber),	\
			(Cid_MsgTxStart_DateTimeStatus), &((structAddr)->DateTimeStatus),	\
			(Cid_MsgTxStart_DateTime), &((structAddr)->DateTime),	\
			(Cid_MsgTxStart_MDataPresent), &((structAddr)->MDataPresent),	\
			(Cid_MsgTxStart_EDataPresent), &((structAddr)->EDataPresent),	\
			(Cid_MsgTxStart_EEDataPresent), &((structAddr)->EEDataPresent));	\
		    Cid_MsgTxStart_EEData_put(msgPtr, &((structAddr)->Cid_MsgTxStart_EEData_i), offset);	\
		    Cid_MsgTxStart_EData_put(msgPtr, &((structAddr)->Cid_MsgTxStart_EData_i), offset);	\
		    Cid_MsgTxStart_MData_put(msgPtr, &((structAddr)->Cid_MsgTxStart_MData_i), offset)


#define Cid_MsgTxStart_Size		323

#define Cid_MsgTxStart	0x290d	/* 10509 */
/*
 * Please read the information about these fields in MsgCID message description.
 */
/* The MsgTxStartCmplt message is sent as a response to the MsgTxStart command 
 * when the message has been received and processed. */

/*
 * Cid_MsgTxStartCmplt (value = 0x290e) is an output message
 * for component Cid.
 */

#define Cid_MsgTxStartCmplt_Size		0

#define Cid_MsgTxStartCmplt	0x290e	/* 10510 */
/* The MsgTxCmplt message is sent as an indication of the end of transmission 
 * of caller id data sent with MsgTxStart command. */

/*
 * Cid_MsgTxCmplt (value = 0x290f) is an output message
 * for component Cid.
 */

#define Cid_MsgTxCmplt_Size		0

#define Cid_MsgTxCmplt	0x290f	/* 10511 */

#define Cid_MsgTxRawBlkStart_RawDataSize	0x200000	/* 2097152 */
typedef	UInt8	Cid_MsgTxRawBlkStart_RawDataSize_t;

#define Cid_MsgTxRawBlkStart_RawBlock	0x27f001	/* 2617345 */
typedef	UInt8	Cid_MsgTxRawBlkStart_RawBlock_t[255];

#define Cid_MsgTxRawBlkStart_LastFlag	0x200100	/* 2097408 */
typedef	UInt8	Cid_MsgTxRawBlkStart_LastFlag_t;

/*
 * Cid_MsgTxRawBlkStart (value = 0x2910) is an input message
 * for component Cid.
 */


typedef struct {
	UInt8	RawDataSize;
	UInt8	RawBlock[255];
	UInt8	LastFlag;
} Cid_MsgTxRawBlkStart_t;

#define Cid_MsgTxRawBlkStart_get(msgPtr, structAddr, offset)	\
		    qMsgVarFieldGet((msgPtr), 3, &(offset),	\
			(Cid_MsgTxRawBlkStart_RawDataSize), &((structAddr)->RawDataSize),	\
			(Cid_MsgTxRawBlkStart_RawBlock), &((structAddr)->RawBlock),	\
			(Cid_MsgTxRawBlkStart_LastFlag), &((structAddr)->LastFlag))


#define Cid_MsgTxRawBlkStart_put(msgPtr, structAddr, offset)	\
		    qMsgVarFieldPut((msgPtr), 3, &(offset),	\
			(Cid_MsgTxRawBlkStart_RawDataSize), &((structAddr)->RawDataSize),	\
			(Cid_MsgTxRawBlkStart_RawBlock), &((structAddr)->RawBlock),	\
			(Cid_MsgTxRawBlkStart_LastFlag), &((structAddr)->LastFlag))


#define Cid_MsgTxRawBlkStart_Size		257

#define Cid_MsgTxRawBlkStart	0x2910	/* 10512 */
/* The MsgTxRawBlkStart is a command to start transmission of user processed 
 * data block. The user needs to add checksum/CRC16 to the data. The primary 
 * component instance does not touch this data and simply transmits it in 
 * blocks with the help of Cid Modem instance. */
/* The MsgTxRawBlkRequest message is sent as a request and indication to the 
 * user that the next block of data can be now queued up. Note that the last 
 * flag used in the start message can indicate the presence of multiple blocks 
 * of data. Thus the data blocks can be queued up using this message. */

/*
 * Cid_MsgTxRawBlkRequest (value = 0x2911) is an output message
 * for component Cid.
 */

#define Cid_MsgTxRawBlkRequest_Size		0

#define Cid_MsgTxRawBlkRequest	0x2911	/* 10513 */
/* The MsgTxRawBlkStartCmplt message is sent as a response to the 
 * MsgTxRawBlkStart command when the message has been received and processed. */

/*
 * Cid_MsgTxRawBlkStartCmplt (value = 0x2912) is an output message
 * for component Cid.
 */

#define Cid_MsgTxRawBlkStartCmplt_Size		0

#define Cid_MsgTxRawBlkStartCmplt	0x2912	/* 10514 */

#define Cid_MsgTxRawData_RawDataSize	0x200000	/* 2097152 */
typedef	UInt8	Cid_MsgTxRawData_RawDataSize_t;

#define Cid_MsgTxRawData_RawData	0x27f001	/* 2617345 */
typedef	UInt8	Cid_MsgTxRawData_RawData_t[255];

#define Cid_MsgTxRawData_LastFlag	0x200100	/* 2097408 */
typedef	UInt8	Cid_MsgTxRawData_LastFlag_t;

#define Cid_MsgTxRawData_MaxData	0x380101	/* 3670273 */
typedef	UInt32	Cid_MsgTxRawData_MaxData_t;
/*  10 ms unit.  */

#define Cid_MsgTxRawData_MaxTime	0x380105	/* 3670277 */
typedef	UInt32	Cid_MsgTxRawData_MaxTime_t;
/* indicate which standard will be used.*/

#define Cid_MsgTxRawData_StandardType	0x200109	/* 2097417 */
typedef	UInt8	Cid_MsgTxRawData_StandardType_t;
/* the number of bits of Channel Seizure.*/

#define Cid_MsgTxRawData_ChannelSeizure	0x28010a	/* 2621706 */
typedef	UInt16	Cid_MsgTxRawData_ChannelSeizure_t;
/* the number of bits of Mark signal.*/

#define Cid_MsgTxRawData_MarkLength	0x28010c	/* 2621708 */
typedef	UInt16	Cid_MsgTxRawData_MarkLength_t;

/*
 * Cid_MsgTxRawData (value = 0x2913) is an input message
 * for component Cid.
 */


typedef struct {
	UInt8	RawDataSize;
	UInt8	RawData[255];
	UInt8	LastFlag;
	UInt32	MaxData;
	UInt32	MaxTime;
	UInt8	StandardType;
	UInt16	ChannelSeizure;
	UInt16	MarkLength;
} Cid_MsgTxRawData_t;

#define Cid_MsgTxRawData_get(msgPtr, structAddr, offset)	\
		    qMsgVarFieldGet((msgPtr), 8, &(offset),	\
			(Cid_MsgTxRawData_RawDataSize), &((structAddr)->RawDataSize),	\
			(Cid_MsgTxRawData_RawData), &((structAddr)->RawData),	\
			(Cid_MsgTxRawData_LastFlag), &((structAddr)->LastFlag),	\
			(Cid_MsgTxRawData_MaxData), &((structAddr)->MaxData),	\
			(Cid_MsgTxRawData_MaxTime), &((structAddr)->MaxTime),	\
			(Cid_MsgTxRawData_StandardType), &((structAddr)->StandardType),	\
			(Cid_MsgTxRawData_ChannelSeizure), &((structAddr)->ChannelSeizure),	\
			(Cid_MsgTxRawData_MarkLength), &((structAddr)->MarkLength))


#define Cid_MsgTxRawData_put(msgPtr, structAddr, offset)	\
		    qMsgVarFieldPut((msgPtr), 8, &(offset),	\
			(Cid_MsgTxRawData_RawDataSize), &((structAddr)->RawDataSize),	\
			(Cid_MsgTxRawData_RawData), &((structAddr)->RawData),	\
			(Cid_MsgTxRawData_LastFlag), &((structAddr)->LastFlag),	\
			(Cid_MsgTxRawData_MaxData), &((structAddr)->MaxData),	\
			(Cid_MsgTxRawData_MaxTime), &((structAddr)->MaxTime),	\
			(Cid_MsgTxRawData_StandardType), &((structAddr)->StandardType),	\
			(Cid_MsgTxRawData_ChannelSeizure), &((structAddr)->ChannelSeizure),	\
			(Cid_MsgTxRawData_MarkLength), &((structAddr)->MarkLength))


#define Cid_MsgTxRawData_Size		270

#define Cid_MsgTxRawData	0x2913	/* 10515 */

/* These defines will be used in LastFlag for both Tx/Rx */
#define	CID_SESSION_ON		0x00  /* indicate more data is coming in next message.*/
#define	CID_SESSION_CID		0x01 /* indicate it is Caller ID application and only one block data.*/
#define	CID_SESSION_START	0x02 /* to indicate the start of the session. */
#define	CID_SESSION_END		0x04 /* to indicate it is the last block of data of this session.*/
#define	CID_MARK_ON		0x08 /* to indicate that modem is receiving continues Mark. */

#define	CID_TERM_MAX_TIME	0x10 /* terminating the FSK session when the max time reached.*/
#define	CID_TERM_MAX_DATA 	0x20 /* terminating the FSK session when max data bytes reached.*/

/* The MsgTxRawData is a command to start transmission of user processed data 
 * block. The user needs to add checksum/CRC16 to the data. The primary 
 * component instance does not touch this data and simply transmits it in 
 * blocks with the help of Cid Modem instance. RawDataSize - Give the number of 
 * bytes of data in this message. RawData - Hold the data to be transmitted. 
 * LastFlag - There are two different usage: Caller ID - Only two values are 
 * used, 0 to indicate there will be more data coming and 1 to indicate that 
 * this is the last block of data. FSK/ADSI - The lower 4 bits are used to 
 * indicate the data flow and the upper 4 bits are used as terminating 
 * condition. Note. The terminating conditions are valid only when 
 * CID_SESSION_START is set. MaxData - The max data bytes to be transmitted 
 * before the session is terminated. This value should only be given when 
 * CID_SESSION_START and CID_TERM_MAX_DATA both set. It is a new feature and 
 * for FSK/ADSI only. MaxTime - The max time elapsed before the session is 
 * terminated. This value should only be given when CID_SESSION_START and 
 * CID_TERM_MAX_TIME both set. It is a new feature and for FSK/ADSI only. Note. 
 * The unit is 10ms. StandardType - The standard will be used. ChannelSeizure - 
 * How many channel seizure bits will be transmitted. MarkLength - How many 
 * mark bits will be transmitted. */
/* The MsgTxRawDataCmplt message is sent as a response to the MsgTxRawData 
 * command when the message has been received and processed. It indicates the 
 * handoff of all the data to the modem instance. */

/*
 * Cid_MsgTxRawDataCmplt (value = 0x2914) is an output message
 * for component Cid.
 */

#define Cid_MsgTxRawDataCmplt_Size		0

#define Cid_MsgTxRawDataCmplt	0x2914	/* 10516 */

#define Cid_MsgTxCIDString_Length	0x200000	/* 2097152 */
typedef	UInt8	Cid_MsgTxCIDString_Length_t;

#define Cid_MsgTxCIDString_DataLinkLayerMessageFormat_MDMF	0	/* 0 */

#define Cid_MsgTxCIDString_DataLinkLayerMessageFormat_SDMF	0x1	/* 1 */

#define Cid_MsgTxCIDString_DataLinkLayerMessageFormat	0x200001	/* 2097153 */
typedef	UInt8	Cid_MsgTxCIDString_DataLinkLayerMessageFormat_t;

#define Cid_MsgTxCIDString_CIDString	0x57e802	/* 5761026 */
typedef	Char	Cid_MsgTxCIDString_CIDString_t[254];

/*
 * Cid_MsgTxCIDString (value = 0x2915) is an input message
 * for component Cid.
 */


typedef struct {
	UInt8	Length;
	UInt8	DataLinkLayerMessageFormat;
	Char	CIDString[254];
} Cid_MsgTxCIDString_t;

#define Cid_MsgTxCIDString_get(msgPtr, structAddr, offset)	\
		    qMsgVarFieldGet((msgPtr), 3, &(offset),	\
			(Cid_MsgTxCIDString_Length), &((structAddr)->Length),	\
			(Cid_MsgTxCIDString_DataLinkLayerMessageFormat), &((structAddr)->DataLinkLayerMessageFormat),	\
			(Cid_MsgTxCIDString_CIDString), &((structAddr)->CIDString))


#define Cid_MsgTxCIDString_put(msgPtr, structAddr, offset)	\
		    qMsgVarFieldPut((msgPtr), 3, &(offset),	\
			(Cid_MsgTxCIDString_Length), &((structAddr)->Length),	\
			(Cid_MsgTxCIDString_DataLinkLayerMessageFormat), &((structAddr)->DataLinkLayerMessageFormat),	\
			(Cid_MsgTxCIDString_CIDString), &((structAddr)->CIDString))


#define Cid_MsgTxCIDString_Size		256

#define Cid_MsgTxCIDString	0x2915	/* 10517 */
/* The MsgTxCIDString is a command to start transmission of Caller ID data 
 * string. The component adds checksum/CRC16 to the data. The 
 * DataLinkLayerMessageFormat field can be set to SDMF to build caller ID 
 * packets in SDMF. By default the packets will be built with MDMF format. 
 * Currently the string can include following sub fields in it: SubField Sub 
 * field Identifier Comment Example Name N: / n: The name is embedded after 
 * this field identifier. "N:J.Doe" Number I: The name is embedded after this 
 * field identifier. "I:993-3000" Name Absence Reason A: "A:P" Number Absence 
 * Reason B: "B:O" Date Time T: "T:020430" The user can build a variable length 
 * string using above fields. The sub fields can appear in any order in the 
 * string. */
/* The MsgTxCIDStringCmplt message is sent as a response to the MsgTxCIDString 
 * command when the message has been received and processed. It indicates the 
 * handoff of all the data to the modem instance. It also indicates that the 
 * received string did not have any errors in it. It arrives when SP component 
 * has finished transmitting the string out. */

/*
 * Cid_MsgTxCIDStringCmplt (value = 0x2916) is an output message
 * for component Cid.
 */

#define Cid_MsgTxCIDStringCmplt_Size		0

#define Cid_MsgTxCIDStringCmplt	0x2916	/* 10518 */

#define Cid_MsgTxStopped_Reason_UserStop	0x1	/* 1 */

#define Cid_MsgTxStopped_Reason_Timeout	0x2	/* 2 */

#define Cid_MsgTxStopped_Reason_EOT	0x2	/* 2 */

#define Cid_MsgTxStopped_Reason_MaxData	0x4	/* 4 */

#define Cid_MsgTxStopped_Reason_EOS	0x80	/* 128 */

#define Cid_MsgTxStopped_Reason_Deallocated	0x172	/* 370 */

#define Cid_MsgTxStopped_Reason_ModemExited	0x173	/* 371 */

#define Cid_MsgTxStopped_Reason	0x380000	/* 3670016 */
typedef	UInt32	Cid_MsgTxStopped_Reason_t;

/*
 * Cid_MsgTxStopped (value = 0x2917) is an output message
 * for component Cid.
 */


typedef struct {
	UInt32	Reason;
} Cid_MsgTxStopped_t;

#define Cid_MsgTxStopped_get(msgPtr, structAddr, offset)	\
		    qMsgVarFieldGet((msgPtr), 1, &(offset),	\
			(Cid_MsgTxStopped_Reason), &((structAddr)->Reason))


#define Cid_MsgTxStopped_put(msgPtr, structAddr, offset)	\
		    qMsgVarFieldPut((msgPtr), 1, &(offset),	\
			(Cid_MsgTxStopped_Reason), &((structAddr)->Reason))


#define Cid_MsgTxStopped_Size		4

#define Cid_MsgTxStopped	0x2917	/* 10519 */
/*
 * The MsgTxStopped is sent to inform host that the modem has been stopped.
 *  Reason	-	reason why tx stopped.
 *  */

#define Cid_MsgTxRxStart_RawDataSize	0x200000	/* 2097152 */
typedef	UInt8	Cid_MsgTxRxStart_RawDataSize_t;

#define Cid_MsgTxRxStart_RawData	0x27f001	/* 2617345 */
typedef	UInt8	Cid_MsgTxRxStart_RawData_t[255];

#define Cid_MsgTxRxStart_LastFlag	0x200100	/* 2097408 */
typedef	UInt8	Cid_MsgTxRxStart_LastFlag_t;

#define Cid_MsgTxRxStart_TxMaxData	0x380101	/* 3670273 */
typedef	UInt32	Cid_MsgTxRxStart_TxMaxData_t;
/*  10 ms unit.  */

#define Cid_MsgTxRxStart_TxMaxTime	0x380105	/* 3670277 */
typedef	UInt32	Cid_MsgTxRxStart_TxMaxTime_t;

#define Cid_MsgTxRxStart_RxMaxData	0x380109	/* 3670281 */
typedef	UInt32	Cid_MsgTxRxStart_RxMaxData_t;
/*  10 ms unit.  */

#define Cid_MsgTxRxStart_RxMaxTime	0x38010d	/* 3670285 */
typedef	UInt32	Cid_MsgTxRxStart_RxMaxTime_t;
/*1 ms unit , must be multiples of 12ms*/

#define Cid_MsgTxRxStart_RxEndOfNotificationTime	0x280111	/* 2621713 */
typedef	UInt16	Cid_MsgTxRxStart_RxEndOfNotificationTime_t;
/* indicate which standard will be used.*/

#define Cid_MsgTxRxStart_StandardType	0x200113	/* 2097427 */
typedef	UInt8	Cid_MsgTxRxStart_StandardType_t;
/* the number of bits of Channel Seizure.*/

#define Cid_MsgTxRxStart_ChannelSeizure	0x280114	/* 2621716 */
typedef	UInt16	Cid_MsgTxRxStart_ChannelSeizure_t;
/* the number of bits of Mark signal.*/

#define Cid_MsgTxRxStart_MarkLength	0x280116	/* 2621718 */
typedef	UInt16	Cid_MsgTxRxStart_MarkLength_t;

/*
 * Cid_MsgTxRxStart (value = 0x2918) is an input message
 * for component Cid.
 */


typedef struct {
	UInt8	RawDataSize;
	UInt8	RawData[255];
	UInt8	LastFlag;
	UInt32	TxMaxData;
	UInt32	TxMaxTime;
	UInt32	RxMaxData;
	UInt32	RxMaxTime;
	UInt16	RxEndOfNotificationTime;
	UInt8	StandardType;
	UInt16	ChannelSeizure;
	UInt16	MarkLength;
} Cid_MsgTxRxStart_t;

#define Cid_MsgTxRxStart_get(msgPtr, structAddr, offset)	\
		    qMsgVarFieldGet((msgPtr), 11, &(offset),	\
			(Cid_MsgTxRxStart_RawDataSize), &((structAddr)->RawDataSize),	\
			(Cid_MsgTxRxStart_RawData), &((structAddr)->RawData),	\
			(Cid_MsgTxRxStart_LastFlag), &((structAddr)->LastFlag),	\
			(Cid_MsgTxRxStart_TxMaxData), &((structAddr)->TxMaxData),	\
			(Cid_MsgTxRxStart_TxMaxTime), &((structAddr)->TxMaxTime),	\
			(Cid_MsgTxRxStart_RxMaxData), &((structAddr)->RxMaxData),	\
			(Cid_MsgTxRxStart_RxMaxTime), &((structAddr)->RxMaxTime),	\
			(Cid_MsgTxRxStart_RxEndOfNotificationTime), &((structAddr)->RxEndOfNotificationTime),	\
			(Cid_MsgTxRxStart_StandardType), &((structAddr)->StandardType),	\
			(Cid_MsgTxRxStart_ChannelSeizure), &((structAddr)->ChannelSeizure),	\
			(Cid_MsgTxRxStart_MarkLength), &((structAddr)->MarkLength))


#define Cid_MsgTxRxStart_put(msgPtr, structAddr, offset)	\
		    qMsgVarFieldPut((msgPtr), 11, &(offset),	\
			(Cid_MsgTxRxStart_RawDataSize), &((structAddr)->RawDataSize),	\
			(Cid_MsgTxRxStart_RawData), &((structAddr)->RawData),	\
			(Cid_MsgTxRxStart_LastFlag), &((structAddr)->LastFlag),	\
			(Cid_MsgTxRxStart_TxMaxData), &((structAddr)->TxMaxData),	\
			(Cid_MsgTxRxStart_TxMaxTime), &((structAddr)->TxMaxTime),	\
			(Cid_MsgTxRxStart_RxMaxData), &((structAddr)->RxMaxData),	\
			(Cid_MsgTxRxStart_RxMaxTime), &((structAddr)->RxMaxTime),	\
			(Cid_MsgTxRxStart_RxEndOfNotificationTime), &((structAddr)->RxEndOfNotificationTime),	\
			(Cid_MsgTxRxStart_StandardType), &((structAddr)->StandardType),	\
			(Cid_MsgTxRxStart_ChannelSeizure), &((structAddr)->ChannelSeizure),	\
			(Cid_MsgTxRxStart_MarkLength), &((structAddr)->MarkLength))


#define Cid_MsgTxRxStart_Size		280

#define Cid_MsgTxRxStart	0x2918	/* 10520 */
/* Raw Block Tx/Rx Command. This is the hook for ADSI /SMS*/
/* The MsgTxRxStart message is a command to let firmware to be able to 
 * automatically switch to receive mode as soon as the transmit is completed. 
 * In this way, the turn around time will be no greater than 100 ms, which is 
 * required for the most of ADSI/SMS protocols. Note, there is no complete 
 * message specifically defined for this message, a "Cid_ MsgTxRawDataCmplt" 
 * and "Cid_ MsgRxRawStart" will be used to send to host to indicate successful 
 * of Tx and Rx start. RawDataSize - Give the number of bytes of data to be 
 * transmitted in this message. RawData - Hold the data to be transmitted. 
 * LastFlag - Contains terminating conditions. Check MsgTxRawData for detailed 
 * information. TxMaxData - The max data bytes to be sent before the session is 
 * terminated. This value should only be given when CID_SESSION_START and 
 * CID_TERM_MAX_DATA both set. It is a new feature and for FSK/ADSI only. 
 * TxMaxTime - The max time elapsed before the Tx session is terminated. This 
 * value should only be given when CID_SESSION_START and CID_TERM_MAX_TIME both 
 * set. It is a new feature and for FSK/ADSI only. Note. The unit is 10ms. 
 * RxMaxData - Same as TxMaxData., but for receiving. RxMaxTime - Same as 
 * TxMaxTime but for receiving. RxEndOfNotificationTime - The max silence time 
 * elapsed before modem sending out end of rx notification. Note. The unit is 
 * 1ms, but the value must be multiple of 12ms(DSP frame time). If 0 is given, 
 * a default 120ms will be used internally. StandardType - The standard will be 
 * used. ChannelSeizure - How many channel seizure bits will be transmitted. 
 * MarkLength - How many mark bits will be transmitted. */
/* 
 * Cid Parameter Definitions
 */
/*
 * Receive Signal Energy Threshold Off to On (Linear Value)*/

#define Cid_ParmFSKRxThresholdOffOn	0x2900	/* 10496 */
typedef	UInt32	Cid_ParmFSKRxThresholdOffOn_t;
/*
 * Receive Signal Energy Threshold On to Off (Linear Value)
 */

#define Cid_ParmFSKRxThresholdOnOff	0x2901	/* 10497 */
typedef	UInt32	Cid_ParmFSKRxThresholdOnOff_t;
/*
 * Number of Channel Seizure bits to qualify
 */

#define Cid_ParmFSKRxCSLength	0x2902	/* 10498 */
typedef	UInt32	Cid_ParmFSKRxCSLength_t;
/*
 * Number of mark bits to qualify
 */

#define Cid_ParmFSKRxMarkLength	0x2903	/* 10499 */
typedef	UInt32	Cid_ParmFSKRxMarkLength_t;
/*
 * Transmit signal level in dBm.
 */

#define Cid_ParmFSKTxLevel	0x2904	/* 10500 */
typedef	UInt32	Cid_ParmFSKTxLevel_t;
/*
 * Number of channel seizure bits to generate.
 */

#define Cid_ParmFSKTxCSLength	0x2905	/* 10501 */
typedef	UInt32	Cid_ParmFSKTxCSLength_t;
/*
 * Number of mark bits to generate.
 */

#define Cid_ParmFSKTxMarkLength	0x2906	/* 10502 */
typedef	UInt32	Cid_ParmFSKTxMarkLength_t;

#define Cid_ParmFSKTxMode_FSK_BELL202	0	/* 0 */

#define Cid_ParmFSKTxMode_FSK_V23	0x1	/* 1 */
/* FSK_BELL202 or FSK_V23 transmission */

#define Cid_ParmFSKTxMode	0x2907	/* 10503 */
typedef	UInt32	Cid_ParmFSKTxMode_t;

#define Cid_ParmCIDStandardType_BELL_US	0x1	/* 1 */

#define Cid_ParmCIDStandardType_BELL_SG	0x2	/* 2 */

#define Cid_ParmCIDStandardType_NTT	0x3	/* 3 */

#define Cid_ParmCIDStandardType_UK	0x4	/* 4 */

#define Cid_ParmCIDStandardType_RAW	0x5	/* 5 */

#define Cid_ParmCIDStandardType_RAWCS	0x6	/* 6 */

#define Cid_ParmCIDStandardType_RAWCRC16	0x7	/* 7 */
/* Caller ID standard of operation:
 *     BELL_US, BELL_SG,
 *      CID_NTT,UK, RAW,
 *    RAWCS, RAWCRC16 */

#define Cid_ParmCIDStandardType	0x2908	/* 10504 */
typedef	UInt32	Cid_ParmCIDStandardType_t;
/* This parameter lets parsing of incoming FSK data even when check sum or 
 * CRC16 fails. By default it will set FALSE. */

#define Cid_ParmIgnoreCSCRC	0x2909	/* 10505 */
typedef	UInt32	Cid_ParmIgnoreCSCRC_t;
/* This parameter defines the maximum raw caller id data that can be received. 
 * By default it is set to 320 which is larger than 258 as required by the 
 * standards. */

#define Cid_ParmInRecordLength	0x290a	/* 10506 */
typedef	UInt32	Cid_ParmInRecordLength_t;
/*This parameter defines the maximum data bytes can be transmitted/received 
 * before the session to be terminated when the CID_TERM_MAX_DATA is set with 
 * CID_SESSION_START. */

#define Cid_ParmFSKMaxData	0x290b	/* 10507 */
typedef	UInt32	Cid_ParmFSKMaxData_t;
/* This parameter defines the maximum time elapsed for transmitting/receiving 
 * before the session to be terminated when the CID_TERM_MAX_TIME is set with 
 * CID_SESSION_START. */

#define Cid_ParmFSKMaxTime	0x290c	/* 10508 */
typedef	UInt32	Cid_ParmFSKMaxTime_t;

#define Cid_ParmDebugLevel	0x290d	/* 10509 */
typedef	UInt32	Cid_ParmDebugLevel_t;

#define Cid_ParmFSKStandardType_BELL_US	0x1	/* 1 */

#define Cid_ParmFSKStandardType_ETSI	0x2	/* 2 */
/* FSK standard of operation:
 *     BELL_US, ETSI */
/*  Debug parameter information */

#define CID_DEBUGSTATEMACHINE   0x00000001

/* Print all debugging messages associated with the state machine. Not 
 * Supported yet. */

#define CID_DEBUGMESSAGE   0x00000002

/*
 * Print all the incoming message type. 
 */

#define CID_DEBUGMESSAGEBODY  0x00000004

/*
 * Print body of the incoming message.
 */

#define CID_DEBUGREGISTRATION   0x00000008

/*
 * Print messages during component and instance registration. Not Supported yet.
 */

#define CID_DEBUGINITIALIZATION   0x00000010

/*
 * Print all debugging messages associated with initialization. Not Supported yet.
 */

#define CID_DEBUGTXCIDSTRING    0x00000020

/*
 * Print all debugging messages associated with procedure txCIDString.
 */

#define CID_DEBUGRXCIDSTRING   0x00000040

/*
 * Print all debugging messages associated with rxCIDString.
 */

#define CID_DEBUGRXSTART   0x00000080

/*
 * Print all debugging for rxStart message. */

#define CID_DEBUGRXCALLERNUMBER   0x00000100

/*
 * Debug callerNumber received information for rxCID */
/* 
 * CID Error Code Definitions
 */

#define Cid_ParmFSKStandardType	0x290e	/* 10510 */
typedef	UInt32	Cid_ParmFSKStandardType_t;
/*
 * Invalid Modem was specified.
 */

#define Cid_ErrModem	0x2900	/* 10496 */
/*
 * Cluster could not be activated.
 */

#define Cid_ErrClusterNotActive	0x2901	/* 10497 */
/*
 * Cluster information could not be obtained.
 */

#define Cid_ErrClusterInfo	0x2902	/* 10498 */
/*
 * The Reserved field has not been set to zero.
 */

#define Cid_ErrReservedNotZero	0x2903	/* 10499 */
/*
 * The requested FSK Modem is not available.
 */

#define Cid_ErrModemNotAvailable	0x2904	/* 10500 */
/*
 * The requested FSK Modem is not valid.
 */

#define Cid_ErrInvalidModem	0x2905	/* 10501 */
/*
 * The parsing algorithm failed.
 */

#define Cid_ErrParsing	0x2906	/* 10502 */
/* The data layer did not match the msg type received to the stored 
 * information. 0x80 is MDMF message type. */

#define Cid_ErrMsgTypeMatch	0x2907	/* 10503 */
/* Information is not complete to send Caller ID,
 * The buffer CallerID was not completely filled.
 */

#define Cid_ErrIncompleteData	0x2908	/* 10504 */
/* This operation can not be done on this caller ID standard. */

#define Cid_ErrCIDStandardType	0x2909	/* 10505 */
/* The Caller ID raw data received from the SP exceeds the allocated buffer 
 * size in the CP */

#define Cid_ErrExceedInRecordBuf	0x290a	/* 10506 */
/* The data integrity check CRC16/check sum failed on current input record. */

#define Cid_ErrDataIntegrity	0x290b	/* 10507 */
/* If MsgGetLastCID received when ParmCIDStandardType was set to CID_RAW / 
 * CID_RAWCS / CID_RAWCRC16, then this error will be generated to indicate that 
 * last operation did not produce the parsed caller id data. */

#define Cid_ErrParsedDataNotAvailable	0x290c	/* 10508 */
/* Received invalid sub field identifier in Cid_MsgTxCIDString. */

#define Cid_ErrInvalidSubFieldId	0x290d	/* 10509 */
/* CP received excessive data from host. */

#define Cid_ErrOverRun	0x290e	/* 10510 */
/* Host fail to provide data quick enough to CP.*/

#define Cid_ErrUnderRun	0x290f	/* 10511 */
/* CP can not set a frame timer for max time termination. */

#define Cid_ErrFTimer	0x2910	/* 10512 */
/* Preamble is either too short or too long.*/
/*
 * Standard Attribute Definition
 */

#define Cid_ErrPreamble	0x2911	/* 10513 */

#define Cid_Std_ComponentType	0x29	/* 41 */
/*
 * Cid Component Type definition.
 */

#define Cid_DIALOGIC	0x1	/* 1 */
/*
 * Dialogic Id.
 */
/*
 * End of all DM3 Caller ID Component Definitions
 */

#define Cid	0x29	/* 41 */

typedef struct {
	UInt32		ParmFSKRxThresholdOffOn;
	UInt32		ParmFSKRxThresholdOnOff;
	UInt32		ParmFSKRxCSLength;
	UInt32		ParmFSKRxMarkLength;
	UInt32		ParmFSKTxLevel;
	UInt32		ParmFSKTxCSLength;
	UInt32		ParmFSKTxMarkLength;
	UInt32		ParmFSKTxMode;
	UInt32		ParmCIDStandardType;
	UInt32		ParmIgnoreCSCRC;
	UInt32		ParmInRecordLength;
	UInt32		ParmFSKMaxData;
	UInt32		ParmFSKMaxTime;
	UInt32		ParmDebugLevel;
	UInt32		ParmFSKStandardType;

} Cidparm_t;

#if defined ( Cid_DEFINED )

ParmStruct CidParmTab []= {
{Cid_ParmFSKRxThresholdOffOn, 15, 0, 0, 0, 0},
 {0x380000, offsetof(Cidparm_t, ParmFSKRxThresholdOffOn), PARM_READWRITE, 0, 0, 0},
 {0x380000, offsetof(Cidparm_t, ParmFSKRxThresholdOnOff), PARM_READWRITE, 0, 0, 0},
 {0x380000, offsetof(Cidparm_t, ParmFSKRxCSLength), PARM_READWRITE, 0, 0, 0},
 {0x380000, offsetof(Cidparm_t, ParmFSKRxMarkLength), PARM_READWRITE, 0, 0, 0},
 {0x380000, offsetof(Cidparm_t, ParmFSKTxLevel), PARM_READWRITE, 0, 0, 0},
 {0x380000, offsetof(Cidparm_t, ParmFSKTxCSLength), PARM_READWRITE, 0, 0, 0},
 {0x380000, offsetof(Cidparm_t, ParmFSKTxMarkLength), PARM_READWRITE, 0, 0, 0},
 {0x380000, offsetof(Cidparm_t, ParmFSKTxMode), PARM_READWRITE, 0, 0, 0},
 {0x380000, offsetof(Cidparm_t, ParmCIDStandardType), PARM_READWRITE, 0, 0, 0},
 {0x380000, offsetof(Cidparm_t, ParmIgnoreCSCRC), PARM_READWRITE, 0, 0, 0},
 {0x380000, offsetof(Cidparm_t, ParmInRecordLength), PARM_READWRITE, 0, 0, 0},
 {0x380000, offsetof(Cidparm_t, ParmFSKMaxData), PARM_READWRITE, 0, 0, 0},
 {0x380000, offsetof(Cidparm_t, ParmFSKMaxTime), PARM_READWRITE, 0, 0, 0},
 {0x380000, offsetof(Cidparm_t, ParmDebugLevel), PARM_READWRITE, 0, 0, 0},
 {0x380000, offsetof(Cidparm_t, ParmFSKStandardType), PARM_READWRITE, 0, 0, 0},

};

#endif


#endif /* !defined(_ciddefs_h_) */
