/****************************************************************************
 *		Copyright (c) 2000 Dialogic Corp.
 *		All Rights Reserved.
 *
 *		THIS IS UNPUBLISHED PROPRIETARY SOURCE CODE OF Dialogic Corp.
 *		The copyright notice above does not evidence any actual or
 *		intended publication of such source code.
 ***************************************************************************/

/****************************************************************************
 * FILE:
 * AUTHOR:       F. Balady
 * ORG:          Dialogic Corporation
 * ORIG-DATE:    16-Aug-00
 * LAST-MOD:     Tue Mar 19 16:14:50 2002 by huj
 * PURPOSE:
 * 				 Location tags for QError
 *
 * HISTORY:
 * Date        Who			Description
 * 03/11/02    Jiangang             Add some CSUMS_LOCS for the error detection in the newly implemented
 *                                  function CSUMS_Std_MsgSetxParmsDefHndlr(),CSUMS_Std_MsgSetxParmsDefHndlr()
 *                                  and CSUMS_Std_MSgGetxParmsHndlr().
 * 09/25/00    hrp                  qError Changes.
 * 5/18/00     FAB			Initial creation for Implementing the qError.
 ***************************************************************************/
#ifndef _csumsQErrorLocs_h
#define _csumsQErrorLocs_h 1

#define CSUMS_LOC_000	0x800000   /* UnUsed */


#define CSUMS_LOC_001	0x800001   /* CSUMS:csumscompsm.c:CSUMS_CompSM(),
        				           	  Failed to create instances */

#define CSUMS_LOC_002	0x800002   /* CSUMS:csumscompsm.c:CSUMS_CompSM(),
        					        	  Start Instance Number Standard Component parameter should not be zero */

#define CSUMS_LOC_003	0x800003   /* CSUMS:csumscompsm.c:CSUMS_CompSM(),
        					        	  Reached invalid state in Component State Machine */

#define CSUMS_LOC_004	0x800004   /* CSUMS:csumsinstsm.c:CSUMS_InstStateMachine(),
        					        	  Reached invalid state in Instance State Machine */

#define CSUMS_LOC_005	0x800005   /* CSUMS:csumsinstsm.c:CSUMS_InstsCreate(),
        					        	  Memory exhausted when allocating Instance Data Blocks */

#define CSUMS_LOC_006	0x800006   /* CSUMS:csumsinstsm.c:CSUMS_InstsCreate(),
        					        	  QMemCHIP exhausted when allocating Party Data Blocks */

#define CSUMS_LOC_007	0x800007   /* CSUMS:csumsinstsm.c:CSUMS_InstsCreate(),
        					        	  QMemFAST exhausted when allocating Party Data Blocks */

#define CSUMS_LOC_008	0x800008   /* CSUMS:csumsinstsm.c:CSUMS_InstsCreate(),
        					        	  QMemCHIP exhausted when allocating AGC Variable Table */

#define CSUMS_LOC_009	0x800009   /* CSUMS:csumsinstsm.c:CSUMS_InstsCreate(),
        					        	  QMemCHIP exhausted when allocating Party Input Frame */

#define CSUMS_LOC_010	0x80000A   /* CSUMS:csumsinstsm.c:CSUMS_InstsCreate(),
        					        	  QMemFAST exhausted when allocating AGC Variable Table */

#define CSUMS_LOC_011	0x80000B   /* CSUMS:csumsinstsm.c:CSUMS_InstsCreate(),
        					        	  QMemFAST exhausted when allocating Party Input Frame */

#define CSUMS_LOC_012	0x80000C   /* CSUMS:csumsinstsm.c:CSUMS_InstsCreate(),
        					        	  QMemFAST exhausted when allocating Party Output Frame */

#define CSUMS_LOC_013	0x80000D   /* CSUMS:csumsinstsm.c:CSUMS_InstsCreate(),
        					        	  Start Instance Number Standard Component parameter should not be zero */

#define CSUMS_LOC_014	0x80000E   /* CSUMS:csumsinstsm.c:CSUMS_InstsCreate(),
        					        	  Call to qCompInstanceRegister resulted in an error */

#define CSUMS_LOC_015	0x80000F   /* CSUMS:csumsinstsm.c:CSUMS_InstsCreate(),Call to qMsgRead while
                                     waiting for instance registration complete message resulted in error */

#define CSUMS_LOC_016	0x800010   /* CSUMS:csumsinstsm.c:CSUMS_InstsCreate(), Call to qMsgFree failed
                                  while trying to free instance registration complete message */

#define CSUMS_LOC_017	0x800011   /* CSUMS:csumsinstsm.c:CSUMS_InstsCreate(),
        					        	  Received unexpected message while waiting for an instance registration complete */

#define CSUMS_LOC_018	0x800012   /* CSUMS:csumsmain.c:CSUMS_CompTask(),
        					        	  A call to qFTimerSet2() resulted in an error */

#define CSUMS_LOC_019	0x800013   /* CSUMS:csumsmain.c:CSUMS_CompTask(),
        						        A call to qFTimerWait2() resulted in an error */

#define CSUMS_LOC_020	0x800014   /* CSUMS:csumsmain.c:CSUMS_CompTask(),
        						        A call to qFTimerWait2() resulted in an error */

#define CSUMS_LOC_021	0x800015   /* CSUMS:csumsmsgdis.c:CSUMS_ProcessMessage(),
        						        A call to qMsgFree fails after receiving an unknown message */

#define CSUMS_LOC_022	0x800016   /* CSUMS:csumspromsh.c:CSUMS_SendMsgStartCmplt(),
        					        	  A call to qMsgAllocate() resulted in an error */

#define CSUMS_LOC_023	0x800017   /* CSUMS:csumspromsh.c:CSUMS_SendMsgStartCmplt(),
        					        	  A call to qMsgWrite() resulted in an error */

#define CSUMS_LOC_024	0x800018   /* CSUMS:csumspromsh.c:CSUMS_MsgStopHndlr(),
        					        	  A call to qCStreamClose() of the party's input C-Stream resulted in an error */

#define CSUMS_LOC_025	0x800019   /* CSUMS:csumspromsh.c:CSUMS_MsgStopHndlr(),
        					        	  A call to qCStreamClose() of the party's output C-Stream resulted in an error */

#define CSUMS_LOC_026	0x80001A   /* CSUMS:csumspromsh.c:CSUMS_SendMsgStopCmplt(),
        					        	  A call to qMsgAllocate() resulted in an error */

#define CSUMS_LOC_027	0x80001B   /* CSUMS:csumspromsh.c:CSUMS_SendMsgStopCmplt(),
        					        	  A call to CSUMS_MsgStopCmplt_put() resulted in an error */

#define CSUMS_LOC_028	0x80001C   /* CSUMS:csumspromsh.c:CSUMS_SendMsgStopCmplt(),
        					        	  A call to qMsgWrite() resulted in an error */

#define CSUMS_LOC_029	0x80001D   /* CSUMS:csumspromsh.c:CSUMS_MsgAddPartyHndlr(),
        					        	  A call to CSUMS_MsgAddParty_get resulted in an error */

#define CSUMS_LOC_030	0x80001E   /* CSUMS:csumspromsh.c:CSUMS_MsgAddPartyHndlr(),
        					        	  A call to qCStreamOpen() while opening the party's input	stream resulted in an error */

#define CSUMS_LOC_031	0x80001F   /* CSUMS:csumspromsh.c:CSUMS_MsgAddPartyHndlr(), A call to qCStreamOpen() while opening the party's output
        					        	  stream resulted in an error */

#define CSUMS_LOC_032	0x800012   /* CSUMS:csumspromsh.c:CSUMS_MsgRemovePartyHndlr(),
        					        	  A call to CSUMS_MsgRemoveParty_get resulted in an error */

#define CSUMS_LOC_033	0x800021   /* CSUMS:csumspromsh.c:CSUMS_MsgRemovePartyHndlr(),
        					        	  A call to qCStreamClose() while closing the party's input cstream resulted in an error */

#define CSUMS_LOC_034	0x800022   /* CSUMS:csumspromsh.c:CSUMS_MsgRemovePartyHndlr(),
        					        	  A call to qCStreamClose() while closing the party's output cstream resulted in an error */

#define CSUMS_LOC_035	0x800023   /* CSUMS:csumspromsh.c:CSUMS_MsgChangeModePartyHndlr(),
        					        	  A call to CSUMS_MsgChangeModeParty_get resulted in an error */

#define CSUMS_LOC_036	0x800024   /* CSUMS:csumspromsh.c:CSUMS_MsgChangeModePartyHndlr(),
        					        	  A call to qCStreamOpen while opening the party's input cstream resulted in an error */

#define CSUMS_LOC_037	0x800025   /* CSUMS:csumspromsh.c:CSUMS_MsgChangeModePartyHndlr(),
        					        	  A call to qCStreamOpen while opening the party's output cstream resulted in an error */

#define CSUMS_LOC_038	0x800026   /* CSUMS:csumspromsh.c:CSUMS_MsgChangeModePartyHndlr(),
        					        	  A call to qCStreamClose while closing the party's input cstream resulted in an error */

#define CSUMS_LOC_039	0x800027   /* CSUMS:csumspromsh.c:CSUMS_MsgChangeModePartyHndlr(),
        					        	  A call to qCStreamClose while closing the party's output cstream resulted in an error */

#define CSUMS_LOC_040	0x800028   /* CSUMS:csumspromsh.c:CSUMS_SendMsgAddPartyCmplt(),
                                  A call to qMsgAllocate() resulted in an error */

#define CSUMS_LOC_041	0x800029   /* CSUMS:csumspromsh.c:CSUMS_SendMsgAddPartyCmplt(),
                                  A call to CSUMS_MsgStopCmplt_put() resulted in an error */

#define CSUMS_LOC_042	0x80002A   /* CSUMS:csumspromsh.c:CSUMS_SendMsgAddPartyCmplt(),
                                  A call to qMsgWrite() resulted in an error */

#define CSUMS_LOC_043	0x80002B   /* CSUMS:csumspromsh.c:CSUMS_SendMsgRemovePartyCmplt(),
                                  A call to qMsgAllocate() resulted in an error */

#define CSUMS_LOC_044	0x80002C   /* CSUMS:csumspromsh.c:CSUMS_SendMsgRemovePartyCmplt(),
                                  A call to qMsgWrite() resulted in an error */

#define CSUMS_LOC_045	0x80002D   /* CSUMS:csumspromsh.c:CSUMS_SendMsgChangeModePartyCmplt(),
                                  A call to qMsgAllocate() resulted in an error */

#define CSUMS_LOC_046	0x80002E   /* CSUMS:csumspromsh.c:CSUMS_SendMsgChangeModePartyCmplt(),
                                  A call to qMsgWrite() resulted in an error */

#define CSUMS_LOC_047	0x80002F   /* CSUMS:csumspromsh.c:CSUMS_MsgSetPartyParmHndlr(),
                                  A call to CSUMS_MsgSetPartyParm_get() resulted in an error */

#define CSUMS_LOC_048	0x800030   /* CSUMS:csumspromsh.c:CSUMS_SendMsgSetPartyParmCmplt(),
                                  A call to qMsgAllocate() resulted in an error */

#define CSUMS_LOC_049	0x800031   /* CSUMS:csumspromsh.c:CSUMS_SendMsgSetPartyParmCmplt(),
                                  A call to qMsgWrite() resulted in an error */

#define CSUMS_LOC_050	0x800032   /* CSUMS:csumspromsh.c:CSUMS_MsgGetPartyParmHndlr(),
                                  A call to CSUMS_MsgSetPartyParm_get() resulted in an error */

#define CSUMS_LOC_051	0x800033   /* CSUMS:csumspromsh.c:CSUMS_SendMsgGetPartyParmCmplt(),
                                  A call to qMsgAllocate() resulted in an error */

#define CSUMS_LOC_052	0x800034   /* CSUMS:csumspromsh.c:CSUMS_SendMsgGetPartyParmCmplt(),
                                  A call to CSUMS_MsgGetPartyParmCmplt_put() resulted in an error */

#define CSUMS_LOC_053	0x800035   /* CSUMS:csumspromsh.c:CSUMS_SendMsgGetPartyParmCmplt(),
                                  A call to qMsgWrite() resulted in an error */

#define CSUMS_LOC_054	0x800036   /* CSUMS:csumspromsh.c:CSUMS_MsgActiveTalkerNotifyEnableHndlr(),
                                  A call to CSUMS_MsgActiveNotifyEnable_get() resulted in an error */

#define CSUMS_LOC_055	0x800037   /* CSUMS:csumspromsh.c:CSUMS_SendMsgActiveTalkerNotifyEnableCmplt(),
                                  A call to qMsgAllocate() resulted in an error */

#define CSUMS_LOC_056	0x800038   /* CSUMS:csumspromsh.c:CSUMS_SendMsgActiveTalkerNotifyEnableCmplt(),
                                  A call to qMsgWrite() resulted in an error */

#define CSUMS_LOC_057	0x800039   /* CSUMS:csumspromsh.c:CSUMS_SendMsgActiveTalkerNotifyDisableCmplt(),
                                  A call to qMsgAllocate() resulted in an error */

#define CSUMS_LOC_058	0x80003A   /* CSUMS:csumspromsh.c:CSUMS_SendMsgActiveTalkerNotifyDisableCmplt(),
                                  A call to qMsgWrite() resulted in an error */

#define CSUMS_LOC_059	0x80003B   /* CSUMS:csumsstdmsh.c:CSUMS_SendMsgInitCmplt(),
                                  A call to qMsgAllocate() resulted in an error */

#define CSUMS_LOC_060	0x80003C   /* CSUMS:csumsstdmsh.c:CSUMS_SendMsgInitCmplt(),
                                  A call to qMsgWrite() resulted in an error */

#define CSUMS_LOC_061	0x80003D   /* CSUMS:csumsstdmsh.c:CSUMS_Std_MsgSetParmHndlr(),
                                  A call to Std_MsgSetParm_get() resulted in an error */

#define CSUMS_LOC_062	0x80003E   /* CSUMS:csumsstdmsh.c:CSUMS_Std_MsgSetParmHndlr(),
                                  A call to qMsgWrite() resulted in an error */

#define CSUMS_LOC_063	0x80003F   /* CSUMS:csumsstdmsh.c:CSUMS_Std_MsgSetParmDefHndlr(),
                                  A call to Std_MsgSetParmDef_get() resulted in an error */

#define CSUMS_LOC_064   0x800030  /* CSUMS:csumsstdmsh.c:CSUMS_Std_MsgGetParmHndlr(),
                                  A call to Std_MsgGetParm_get() resulted in an error */

#define CSUMS_LOC_065   0x800041  /* CSUMS:csumsstdmsh.c:CSUMS_Std_MsgGetParmHndlr(),
                                  A call to qMsgAllocate() resulted in an error */

#define CSUMS_LOC_066   0x800042  /* CSUMS:csumsstdmsh.c:CSUMS_Std_MsgGetParmHndlr(),
                                  A call to qMsgWrite() resulted in an error */

#define CSUMS_LOC_067   0x800043  /* CSUMS:csumsstdmsh.c:CSUMS_SendStdError(),
                                  A call to qMsgAllocate() resulted in an error */

#define CSUMS_LOC_068   0x800044  /* CSUMS:csumsstdmsh.c:CSUMS_SendStdError(),
                                  A call to Std_MsgError_put() resulted in an error */

#define CSUMS_LOC_069   0x800045  /* CSUMS:csumsstdmsh.c:CSUMS_SendStdError(),
                                  A call to qMsgWrite() resulted in an error */

#define CSUMS_LOC_070   0x800046  /* CSUMS:csumsstrtup.c:CSUMS_Strtup(),
                                  A call to qTaskCompSelf() resulted in an error */

#define CSUMS_LOC_071   0x800047  /* CSUMS:csumsstrtup.c:CSUMS_Strtup(),
                                  A call to qCompRegister() resulted in an error */

#define CSUMS_LOC_072   0x800048  /* CSUMS:csumsstrtup.c:CSUMS_Strtup(),
                                  A call to qMsgRead() resulted in an error */

#define CSUMS_LOC_073   0x800049  /* CSUMS:csumsstrtup.c:CSUMS_Strtup(),
                                  A call to qCompRegisterResult_get() resulted in an error */

#define CSUMS_LOC_074   0x80004A  /* CSUMS:csumsstrtup.c:CSUMS_Strtup(),
                                  A call to qMsgFree() resulted in an error */

#define CSUMS_LOC_075   0x80004B  /* CSUMS:csumsstrtup.c:CSUMS_Strtup(),
                                  invalid Message Type */

#define CSUMS_LOC_076   0x80004C  /* CSUMS:csumsstrtup.c:CSUMS_Strtup(),
                                  QMEM_EXHAUSTED on Component Parameter Table */

#define CSUMS_LOC_077   0x80004D  /* CSUMS:csumsstrtup.c:CSUMS_Strtup(),
                                  QMEM_EXHAUSTED on AGCConst Table */

#define CSUMS_LOC_078   0x80004E  /* CSUMS:csumsstrtup.c:CSUMS_Strtup(),
                                  QMEM_EXHAUSTED on Internal Data Memory */

#define CSUMS_LOC_079   0x80004F  /* CSUMS:csumsstrtup.c:CSUMS_Strtup(),
                                  QMEM_EXHAUSTED on Active Talker Notify G-Stream Buffer */

#define CSUMS_LOC_080   0x800050  /* CSUMS:DBGTaskInit.c:DBGTaskInit(),
                                  QMEM_EXHAUSTED on DBG Task Data*/

#define CSUMS_LOC_081   0x800051  /* CSUMS:DBGTaskInit.c:dbg_func1(),
                                  A call to qMsgFree() resulted in an error */

#define CSUMS_LOC_082   0x800052  /* CSUMS:DBGTaskInit.c:dbg_func1(),
                                  qMsgFree() Error in state QComponentResult*/

#define CSUMS_LOC_083   0x800053  /* CSUMS:DBGTaskInit.c:dbg_func1(),
                                  qMsgFree() Error in state QResultError*/

#define CSUMS_LOC_084   0x800054  /* CSUMS:DBGTaskInit.c:dbg_func1(),
                                  Error in state QResultError*/

#define CSUMS_LOC_085   0x800055  /* CSUMS:DBGTaskInit.c:dbg_func1(),
                                  Invalid incoming message type  */

#define CSUMS_LOC_086   0x800056  /* CSUMS:DBGTaskInit.c:dbg_TaskCall(),
                                  qMsgAllocate() error in state DBGTASK_SENDINITMSGSTATE */

#define CSUMS_LOC_087   0x800057  /* CSUMS:DBGTaskInit.c:dbg_TaskCall(),
                                  qMsgWrite() error in state DBGTASK_SENDINITMSGSTATE */

#define CSUMS_LOC_088   0x800058  /* CSUMS:DBGTaskInit.c:dbg_TaskCall(),
                                  qMsgAllocate() error in state DBGTASK_SENDSTARTMSGSTATE */

#define CSUMS_LOC_089   0x800059  /* CSUMS:DBGTaskInit.c:dbg_TaskCall(),
                                  qMsgWrite() error in state DBGTASK_SENDSTARTMSGSTATE */

#define CSUMS_LOC_090   0x80005A  /* CSUMS:DBGTaskInit.c:dbg_TaskCall(),
                                  qMsgAllocate() error in state DBGTASK_SENDADDPARTYMSGSTATE */

#define CSUMS_LOC_091   0x80005B  /* CSUMS:DBGTaskInit.c:dbg_TaskCall(),
                                  CSUMS_MsgAddParty_put() error in state DBGTASK_SENDADDPARTYMSGSTATE */

#define CSUMS_LOC_092   0x80005C  /* CSUMS:DBGTaskInit.c:dbg_TaskCall(),
                                  qMsgWrite() error in state DBGTASK_SENDADDPARTYMSGSTATE */

#define CSUMS_LOC_093   0x80005D  /* CSUMS:DBGTaskInit.c:dbg_TaskCall(),
                                  qMsgAllocate() error in state DBGTASK_SENDADDPARTYMSGSTATE */

#define CSUMS_LOC_094   0x80005E  /* CSUMS:DBGTaskInit.c:dbg_TaskCall(),
                                  qMsgWrite() error in state DBGTASK_SENDADDPARTYMSGSTATE when FE_ENABLED */

#define CSUMS_LOC_095   0x80005F  /* CSUMS:DBGTaskInit.c:dbg_TaskCall(),
                                  qMsgAllocate() error in state DBGTASK_SENDSETPARTYPARMMSGSTATE */

#define CSUMS_LOC_096   0x800060  /* CSUMS:DBGTaskInit.c:dbg_TaskCall(),
                                  CSUMS_MsgSetPartyParm_put() error in state DBGTASK_SENDSETPARTYPARMMSGSTATE */

#define CSUMS_LOC_097   0x800061  /* CSUMS:DBGTaskInit.c:dbg_TaskCall(),
                                  qMsgWrite() error in state DBGTASK_SENDSETPARTYPARMMSGSTATE */

#define CSUMS_LOC_098   0x800062  /* CSUMS:DBGTaskInit.c:dbg_TaskCall(),
                                  qMsgAllocate() error in state DBGTASK_SENDREMOVEPARTYMSGSTATE */

#define CSUMS_LOC_099   0x800063  /* CSUMS:DBGTaskInit.c:dbg_TaskCall(),
                                  CSUMS_MsgRemoveParty_put() error in state DBGTASK_SENDREMOVEPARTYMSGSTATE */

#define CSUMS_LOC_100   0x800064  /* CSUMS:DBGTaskInit.c:dbg_TaskCall(),
                                  qMsgWrite() error in state DBGTASK_SENDREMOVEPARTYMSGSTATE */

#define CSUMS_LOC_101   0x800065  /* CSUMS:DBGTaskInit.c:dbg_TaskCall(),
                                  qMsgAllocate() error in state DBGTASK_SENDSTOPMSGSTATE */

#define CSUMS_LOC_102   0x800066  /* CSUMS:DBGTaskInit.c:dbg_TaskCall(),
                                  qMsgWrite() error in state DBGTASK_SENDSTOPMSGSTATE */

#define CSUMS_LOC_103   0x800067  /* CSUMS:DBGTaskInit.c:dbg_TaskCall(),
                                  qMsgAllocate() error in state DBGTASK_SENDSETPARMMSGSTATE */

#define CSUMS_LOC_104   0x800068  /* CSUMS:DBGTaskInit.c:dbg_TaskCall(),
                                  CSUMS_MsgSetParm_put() error in state DBGTASK_SENDSETPARMMSGSTATE */

#define CSUMS_LOC_105   0x800069  /* CSUMS:DBGTaskInit.c:dbg_TaskCall(),
                                  qMsgWrite() error in state DBGTASK_SENDSETPARMMSGSTATE */

#define CSUMS_LOC_106   0x80006A  /* CSUMS:csumsInit.c:CSUMSInit(),
                                  qTaskCreate() error */

#define CSUMS_LOC_107   0x80006B  /* CSUMS:csumsInit.c:CSUMSInit(),
                                  qCompInitStart() error */

#define CSUMS_LOC_108   0x80006C  /* CSUMS:csumspromsh.c:CSUMS_SendMsgChangeModePartyCmplt(),
                                  A call to CSUMS_MsgChangeModePartyCmplt_put() resulted in an error */

#define CSUMS_LOC_109   0x80006D  /* CSUMS:csumspromsh.c:CSUMS_SendMsgSetPartyParmCmplt(),
                                  A call to CSUMS_MsgSetPartyParmCmplt_put() resulted in an error */

#define CSUMS_LOC_110   0x80006E  /* CSUMS:csumsstdmsh.c:CSUMS_Std_MsgSetxParmsHndlr(),
                                  A call to Std_MsgSetxParms_get() resulted in an error */


#define CSUMS_LOC_111   0x80006F  /* CSUMS:csumsstdmsh.c:CSUMS_Std_MsgSetxParmsHndlr(),
                                  A call to Std_MsgSetxParms_List_get() resulted in an error */


#define CSUMS_LOC_112   0x800070  /* CSUMS:csumsstdmsh.c:CSUMS_Std_MsgSetxParmsHndlr(),
                                  A call to Std_MsgSetxParms_List_get() reslulted in an error */


#define CSUMS_LOC_113   0x800071  /* CSUMS:csumsstdmsh.c:CSUMS_Std_MsgSetxParmsHndlr(),
                                  A call to qMsgAllocate() resulted in an error */


#define CSUMS_LOC_114   0x800072  /* CSUMS:csumsstdmsh.c:CSUMS_Std_MsgSetxParmsHndlr(),
                                  A call to qMsgWrite() resulted in an error  */


#define CSUMS_LOC_115   0x800073  /* CSUMS:csumsstdmsh.c:CSUMS_Std_MsgSetxParmsHndlr(),
                                  A call to qMsgFree() resulted in an error */


#define CSUMS_LOC_116   0x800074  /* CSUMS:csumsstdmsh.c:CSUMS_Std_MsgSetxParmsDefHndlr(),
                                  A call to Std_MsgSetxParmsDef_get() resulted in an error */


#define CSUMS_LOC_117   0x800075  /* CSUMS:csumsstdmsh.c:CSUMS_Std_MsgSetxParmsDefHndlr(),
                                  A call to Std_MsgSetxParmsDef_List_get() resulted in an error */


#define CSUMS_LOC_118   0x800076  /* CSUMS:csumsstdmsh.c:CSUMS_Std_MsgSetxParmsDefHndlr(), 
                                  A call to  Std_MsgSetxParmsDef_List_get() resulted in an error */


#define CSUMS_LOC_119   0x800077  /* CSUMS:csumsstdmsh.c:CSUMS_Std_MsgSetxParmsDefHndlr(),
                                  A call to qMsgAllocate() resulted in an error */


#define CSUMS_LOC_120   0x800078  /* CSUMS:csumsstdmsh.c:CSUMS_Std_MsgSetxParmsDefHndlr(),
                                  A call to qMsgWrite() resulted in an error */


#define CSUMS_LOC_121   0x800079  /* CSUMS:csumsstdmsh.c:CSUMS_Std_MsgSetxParmsDefHndlr(),
                                  A call to qMsgFree() resulted in an error */


#define CSUMS_LOC_122   0x80007A  /* CSUMS:csumsstdmsh.c:CSUMS_StdMsgGetxParmsHndlr(), 
                                  A call to Std_MsgGetxParms_get() resulted in an error */


#define CSUMS_LOC_123   0x80007B  /* CSUMS:csumsstdmsh.c:CSUMS_StdMsgGetxParmsHndlr(),
                                  A call to Std_MsgGetxParms_List_get() resulted in an error */


#define CSUMS_LOC_124   0x80007C  /* CSUMS:csumsstdmsh.c:CSUMS_StdMsgGetxParmsHndlr(),
                                  A call to qMsgAllocate() resulted in an error  */


#define CSUMS_LOC_125   0x80007D  /* CSUMS:csumsstdmsh.c:CSUMS_StdMsgGetxParmsHndlr(),
                                  A call to Std_MsgGetxParmsCmplt_put() resulted in an error */


#define CSUMS_LOC_126   0x80007E  /* CSUMS:csumsstdmsh.c:CSUMS_StdMsgGetxParmsHndlr(),
                                  A call to Std_MsgGetxParms_List_get() resulted in an error */


#define CSUMS_LOC_127   0x80007F  /* CSUMS:csumsstdmsh.c:CSUMS_StdMsgGetxParmsHndlr(),
                                  A call to qMsgWrite() resulted in an error */


#define CSUMS_LOC_128   0x800080  /* CSUMS:csumsstdmsh.c:CSUMS_StdMsgGetxParmsHndlr(),
                                  A call to qMsgFree() resulted in an error */


#define CSUMS_LOC_129   0x800081  /* CSUMS:.c:(), */


#define CSUMS_LOC_130   0x800082  /* CSUMS:.c:(), */


#define CSUMS_LOC_131   0x800083  /* CSUMS:.c:(), */


#define CSUMS_LOC_132   0x800084  /* CSUMS:.c:(), */


#define CSUMS_LOC_133   0x800085  /* CSUMS:.c:(), */


#define CSUMS_LOC_134   0x800086  /* CSUMS:.c:(), */


#define CSUMS_LOC_135   0x800087  /* CSUMS:.c:(), */


#define CSUMS_LOC_136   0x800088  /* CSUMS:.c:(), */


#define CSUMS_LOC_137   0x800089  /* CSUMS:.c:(), */


#define CSUMS_LOC_138   0x80008A  /* CSUMS:.c:(), */


#define CSUMS_LOC_139   0x80008B  /* CSUMS:.c:(), */


#define CSUMS_LOC_140   0x80008C  /* CSUMS:.c:(), */


#define CSUMS_LOC_141   0x80008D  /* CSUMS:.c:(), */


#define CSUMS_LOC_142   0x80008E  /* CSUMS:.c:(), */


#define CSUMS_LOC_143   0x80008F  /* CSUMS:.c:(), */


#define CSUMS_LOC_144   0x800090  /* CSUMS:.c:(), */


#define CSUMS_LOC_145   0x800091  /* CSUMS:.c:(), */


#define CSUMS_LOC_146   0x800092  /* CSUMS:.c:(), */


#define CSUMS_LOC_147   0x800093  /* CSUMS:.c:(), */


#define CSUMS_LOC_148   0x800094  /* CSUMS:.c:(), */


#define CSUMS_LOC_149   0x800095  /* CSUMS:.c:(), */


#define CSUMS_LOC_150   0x800096  /* CSUMS:.c:(), */


#define CSUMS_LOC_151   0x800097  /* CSUMS:.c:(), */


#define CSUMS_LOC_152   0x800098  /* CSUMS:.c:(), */


#define CSUMS_LOC_153   0x800099  /* CSUMS:.c:(), */


#define CSUMS_LOC_154   0x80009A  /* CSUMS:.c:(), */


#define CSUMS_LOC_155   0x80009B  /* CSUMS:.c:(), */


#define CSUMS_LOC_156   0x80009C  /* CSUMS:.c:(), */


#define CSUMS_LOC_157   0x80009D  /* CSUMS:.c:(), */


#define CSUMS_LOC_158   0x80009E  /* CSUMS:.c:(), */


#define CSUMS_LOC_159   0x80009F  /* CSUMS:.c:(), */


#define CSUMS_LOC_160   0x8000A0  /* CSUMS:.c:(), */


#define CSUMS_LOC_161   0x8000A1  /* CSUMS:.c:(), */


#define CSUMS_LOC_162   0x8000A2  /* CSUMS:.c:(), */


#define CSUMS_LOC_163   0x8000A3  /* CSUMS:.c:(), */


#define CSUMS_LOC_164   0x8000A4  /* CSUMS:.c:(), */


#define CSUMS_LOC_165   0x8000A5  /* CSUMS:.c:(), */


#define CSUMS_LOC_166   0x8000A6  /* CSUMS:.c:(), */


#define CSUMS_LOC_167   0x8000A7  /* CSUMS:.c:(), */


#define CSUMS_LOC_168   0x8000A8  /* CSUMS:.c:(), */


#define CSUMS_LOC_169   0x8000A9  /* CSUMS:.c:(), */


#define CSUMS_LOC_170   0x8000AA  /* CSUMS:.c:(), */


#define CSUMS_LOC_171   0x8000AB  /* CSUMS:.c:(), */


#define CSUMS_LOC_172   0x8000AC  /* CSUMS:.c:(), */


#define CSUMS_LOC_173   0x8000AE  /* CSUMS:.c:(), */


#define CSUMS_LOC_174   0x8000AE  /* CSUMS:.c:(), */


#define CSUMS_LOC_175   0x8000AF  /* CSUMS:.c:(), */


#define CSUMS_LOC_176   0x8000B0  /* CSUMS:.c:(), */


#define CSUMS_LOC_177   0x8000B1  /* CSUMS:.c:(), */


#define CSUMS_LOC_178   0x8000B2  /* CSUMS:.c:(), */


#define CSUMS_LOC_179   0x8000B3  /* CSUMS:.c:(), */


#define CSUMS_LOC_180   0x8000B4  /* CSUMS:.c:(), */


#define CSUMS_LOC_181   0x8000B5  /* CSUMS:.c:(), */


#define CSUMS_LOC_182   0x8000B6  /* CSUMS:.c:(), */


#define CSUMS_LOC_183   0x8000B7  /* CSUMS:.c:(), */


#define CSUMS_LOC_184   0x8000B8  /* CSUMS:.c:(), */


#define CSUMS_LOC_185   0x8000B9  /* CSUMS:.c:(), */


#define CSUMS_LOC_186   0x8000BA  /* CSUMS:.c:(), */


#define CSUMS_LOC_187   0x8000BB  /* CSUMS:.c:(), */


#define CSUMS_LOC_188   0x8000BC  /* CSUMS:.c:(), */


#define CSUMS_LOC_189   0x8000BD  /* CSUMS:.c:(), */


#define CSUMS_LOC_190   0x8000BE  /* CSUMS:.c:(), */


#define CSUMS_LOC_191   0x8000BF  /* CSUMS:.c:(), */


#define CSUMS_LOC_192   0x8000C0  /* CSUMS:.c:(), */


#define CSUMS_LOC_193   0x8000C1  /* CSUMS:.c:(), */


#define CSUMS_LOC_194   0x8000C2  /* CSUMS:.c:(), */


#define CSUMS_LOC_195   0x8000C3  /* CSUMS:.c:(), */


#define CSUMS_LOC_196   0x8000C4  /* CSUMS:.c:(), */


#define CSUMS_LOC_197   0x8000C5  /* CSUMS:.c:(), */


#define CSUMS_LOC_198   0x8000C6  /* CSUMS:.c:(), */


#define CSUMS_LOC_199   0x8000C7  /* CSUMS:.c:(), */


#define CSUMS_LOC_200   0x8000C8  /* CSUMS:.c:(), */


#define CSUMS_LOC_201   0x8000C9  /* CSUMS:.c:(), */


#define CSUMS_LOC_202   0x8000CA  /* CSUMS:.c:(), */


#define CSUMS_LOC_203   0x8000CB  /* CSUMS:.c:(), */


#define CSUMS_LOC_204   0x8000CC  /* CSUMS:.c:(), */


#define CSUMS_LOC_205   0x8000CD  /* CSUMS:.c:(), */


#define CSUMS_LOC_206   0x8000CE  /* CSUMS:.c:(), */


#define CSUMS_LOC_207   0x8000CF  /* CSUMS:.c:(), */


#define CSUMS_LOC_208   0x8000D0  /* CSUMS:.c:(), */


#define CSUMS_LOC_209   0x8000D1  /* CSUMS:.c:(), */


#define CSUMS_LOC_210   0x8000D2  /* CSUMS:.c:(), */


#define CSUMS_LOC_211   0x8000D3  /* CSUMS:.c:(), */


#define CSUMS_LOC_212   0x8000D4  /* CSUMS:.c:(), */


#define CSUMS_LOC_213   0x8000D5  /* CSUMS:.c:(), */


#define CSUMS_LOC_214   0x8000D6  /* CSUMS:.c:(), */


#define CSUMS_LOC_215   0x8000D7  /* CSUMS:.c:(), */


#define CSUMS_LOC_216   0x8000D8  /* CSUMS:.c:(), */


#define CSUMS_LOC_217   0x8000D9  /* CSUMS:.c:(), */


#define CSUMS_LOC_218   0x8000DA  /* CSUMS:.c:(), */


#define CSUMS_LOC_219   0x8000DB  /* CSUMS:.c:(), */


#define CSUMS_LOC_220   0x8000DC  /* CSUMS:.c:(), */


#define CSUMS_LOC_221   0x8000DD  /* CSUMS:.c:(), */


#define CSUMS_LOC_222   0x8000DE  /* CSUMS:.c:(), */


#define CSUMS_LOC_223   0x8000DF  /* CSUMS:.c:(), */


#define CSUMS_LOC_224   0x8000E0  /* CSUMS:.c:(), */


#define CSUMS_LOC_225   0x8000E1  /* CSUMS:.c:(), */


#define CSUMS_LOC_226   0x8000E2  /* CSUMS:.c:(), */


#define CSUMS_LOC_227   0x8000E3  /* CSUMS:.c:(), */


#define CSUMS_LOC_228   0x8000E4  /* CSUMS:.c:(), */


#define CSUMS_LOC_229   0x8000E5  /* CSUMS:.c:(), */


#define CSUMS_LOC_230   0x8000E6  /* CSUMS:.c:(), */


#define CSUMS_LOC_231   0x8000E7  /* CSUMS:.c:(), */


#define CSUMS_LOC_232   0x8000E8  /* CSUMS:.c:(), */


#define CSUMS_LOC_233   0x8000E9  /* CSUMS:.c:(), */


#define CSUMS_LOC_234   0x8000EA  /* CSUMS:.c:(), */


#define CSUMS_LOC_235   0x8000EB  /* CSUMS:.c:(), */


#define CSUMS_LOC_236   0x8000EC  /* CSUMS:.c:(), */


#define CSUMS_LOC_237   0x8000ED  /* CSUMS:.c:(), */


#define CSUMS_LOC_238   0x8000EE  /* CSUMS:.c:(), */


#define CSUMS_LOC_239   0x8000EF  /* CSUMS:.c:(), */


#define CSUMS_LOC_240   0x8000F0  /* CSUMS:.c:(), */


#define CSUMS_LOC_241   0x8000F1  /* CSUMS:.c:(), */


#define CSUMS_LOC_242   0x8000F2  /* CSUMS:.c:(), */


#define CSUMS_LOC_243   0x8000F3  /* CSUMS:.c:(), */


#define CSUMS_LOC_244   0x8000F4  /* CSUMS:.c:(), */


#define CSUMS_LOC_245   0x8000F5  /* CSUMS:.c:(), */


#define CSUMS_LOC_246   0x8000F6  /* CSUMS:.c:(), */


#define CSUMS_LOC_247   0x8000F7  /* CSUMS:.c:(), */


#define CSUMS_LOC_248   0x8000F8  /* CSUMS:.c:(), */


#define CSUMS_LOC_249   0x8000F9  /* CSUMS:.c:(), */


#define CSUMS_LOC_250   0x8000FA  /* CSUMS:.c:(), */


#define CSUMS_LOC_251   0x8000FB  /* CSUMS:.c:(), */


#define CSUMS_LOC_252   0x8000FC  /* CSUMS:.c:(), */


#define CSUMS_LOC_253   0x8000FD  /* CSUMS:.c:(), */


#define CSUMS_LOC_254   0x8000FE  /* CSUMS:.c:(), */


#define CSUMS_LOC_255   0x8000FF  /* CSUMS:.c:(), */





#endif
