/*########@@@SOFT@@@WARE@@@COPY@@@RIGHT@@@###################################
# INTEL CONFIDENTIAL
#
# Copyright (C) 2000-2006 Intel Corporation. All Rights Reserved.
# The source code contained or described herein and all documents related
# to the source code ("Material") are owned by Intel Corporation or its
# suppliers or licensors. Title to the Material remains with Intel Corporation
# or its suppliers and licensors. The Material contains trade secrets and
# proprietary and confidential information of Intel or its suppliers and
# licensors. The Material is protected by worldwide copyright and trade secret
# laws and treaty provisions. No part of the Material may be used, copied,
# reproduced, modified, published, uploaded, posted, transmitted, distributed,
# or disclosed in any way without Intel's prior express written permission.
#
# No license under any patent, copyright, trade secret or other intellectual
# property right is granted to or conferred upon you by disclosure or delivery
# of the Materials, either expressly, by implication, inducement, estoppel or
# otherwise. Any license under such intellectual property rights must be
# express and approved by Intel in writing.
#
###################################@@@SOFT@@@WARE@@@COPY@@@RIGHT@@@########*/
 /***********************************************************************
 *	  FILE: d42lib.h
 * DESCRIPTION: D/42 library definitions
 *
 **********************************************************************/

#ifndef __D42LIB_H__
#define __D42LIB_H__

/*
 * General Definitions
 */
#define  VER_D42DRIVER		0x0000
#define  VER_D42LIB		0x0003
#define  VER_D42FIRMWARE	0x0004

/* 
 * New Board Status Event
 */
#define  DE_BOARDSTATUS 	301	 /* FrontEnd Sync Message */

/*
 *  Board Types Return Values
 */ 
#define TYP_NONE		0x0000	 /* No D/42  Devices     */
#define TYP_SL			0x0001	 /* D/42-SL  Device      */
#define TYP_SX			0x0002	 /* D/42-SX  Device      */
#define TYP_NS			0x0003	 /* D/42-NS  Device      */
#define TYP_NE2 		0x0004	 /* D/42-NE2 Device      */
#define TYP_M1			0x0005	 /* D/42-M1  Device      */
#define TYP_DVC 		0x0006	 /* D/42-DVC Device      */
#define TYP_NE2PBX		0x0007	 /* D/42-NE2PBX Device   */
#define TYP_NE2KTS		0x0008	 /* D/42-NE2KTS Device   */
#define TYP_PA			0x0009	 /* D/42-PA  Device      */
#define TYP_D82L4		0x000A	 /* D/82 Lucent 4 wire   */
#define TYP_D82L2		0x000B	 /* D/82 Lucent 2 wire   */
#define TYP_D82SR		0x000C	 /* D/82 Siemens/ROLM    */
#define TYP_D82SH		0x000D	 /* D/82 Siemens/Hicom   */
#define TYP_D82SX		0x000E	 /* D/82 Mitel SX        */
#define TYP_D82NS		0x000F	 /* D/82 Nortel NS       */
#define TYP_D82M1		0x0010	 /* D/82 Nortel Meridian */
#define TYP_D82NE2PBX		0x0011	 /* D/82 NEC PBX         */
#define TYP_D82NE2KTS		0x0012	 /* D/82 NEC KTS         */

#define MAXDBTYPE		0x0012

/*
 * The following equates are parameter numbers
 */
#define D4BD_TYPE		0x0070	/* Indicates a Board Parm   */
#define D4CH_TYPE		0x00F0	/* Indicates a channel parm */

#define MINNEWPARM		0x0001	/* Minimum New Parm Number  */
#define MAXNEWPARM		0x0019	/* Maximum New Parm Number  */
#define MINOLDPARM		0x0082	/* Minimum Old Parm Number  */
#define MAXOLDPARM		0x008E	/* Maximum Old Parm Number  */

/*
 * Board level Parameters for D/42-SX Only
 */
#define D4BD_CALLID		0x0001	/* calling number ID enable    */
#define D4BD_CALLID_BEGIN	0x0004	/* caller id delimiter begin   */
#define D4BD_CALLID_END		0x0005	/* caller id delimiter end     */
#define D4BD_SPMODE		0x0007	/* enable/disable speakerphone */

/*
 * Channel level Parameters for D/42-SX Only
 */
#define D4CH_COMMTIMER		0x0002	/* no communication timer      */
#define D4CH_DISCONNECT		0x0003	/* disconnect string           */

/*
 * Board level Parameters for D/42-SL Only
 */
#define D4BD_RINGON		0x0002	/* ring on duration	       */
#define D4BD_RINGOFF		0x0003	/* ring off duration	       */
#define D4BD_RINGBACKMSG	0x0007	/* ring back message	       */
#define D4BD_RINGBACK		0x0008	/* ring back enable/disable    */

/*
 * Channel level Parameters for the D/42-SL only
 */
#define D4CH_PDNKEY		0x0089	/* PDN or ICI key location     */
#define D4CH_XFERKEY		0x008A	/* transfer key location       */
#define D4CH_SENDKEY		0x008B	/* send message key location   */
#define D4CH_CANCELKEY		0x008C	/* cancel message key location */
#define D4CH_DNKEY		0x008D	/* DN or outbound line location*/
#define D4CH_RELEASEKEY 	0x008E	/* release key location        */

/*
 * Channel level Parameters for the D/42-NS only
 */
#define D4CH_RECVFUMP		0x0001	/* Pass Functional Message     */
#define D4CH_OUTBANDDTMF	0x0002	/* Enables/Disables Outband    */
#define D4CH_CALLINGID		0x0003	/* Pass Calling ID             */
#define D4CH_CALLEDID		0x0004	/* Pass Called  ID             */
#define D4CH_RECVSTIM		0x0005	/* Send/Receive Stimulus       */
#define D4CH_CHANNELSTATUS	0x0013	/* Asynch Channel Status       */
#define D4CH_SOFTKEYINPUT	0x0014	/* Asynch Soft Key Input       */
#define D4CH_CALLERIDAVAILABLE	0x0015	/* Asynch Caller ID available  */
#define D4CH_MESG_Q		0x0016	/* Message Queue Parameter 	*/

/*
 * Board level Parameters for D/42-NE2 KTS and D/42-NE2 PBX Only
 */
#define D4BD_LONGBEEPDUR	0x0002	/* Long beep duration          */
#define D4BD_GETSWITCHTYPE	0x000D	/* Retrieves the switch type   */

/*
 * Channel level Parameters for D/42-NE2 KTS and D/42-NE2 PBX Only
 */
#define D4CH_RECBEEPDUR		0x0003	/* Record beep duration	       */
#define D4CH_RECBEEPREP		0x0004	/* Record beep repetition      */
#define D4CH_TIMETOFIRSTBEEP	0x0005	/* Time to start first beep    */

/*
 * Board level Parameters for D/42-NE2 PBX Only
 */
#define D4BD_VPEMULTYP		0x0003	/* Virtual Phone Emulation     */
#define D4BD_MSGACCESSON	0x000A	/* Access Code To Turn MSG On  */
#define D4BD_MSGACCESSOFF	0x000B	/* Access Code To Turn MSG Off */
#define D4BD_RESETRINGCNT	0x000C	/* Reset Ring Counter          */

/*
 * Board level Parameters for D/82 Only
 */
#define D4BD_REPORT_RESET	0x000E	/* Enables/Disables Report     */

/*
 * Channel level Parameters for D/82 Only
 */
#define D4CH_CHANNELUPDATE	0x0017	/* Enables/Disables async LCD  */
#define D4CH_LC_LAMP		0x0019	/* Lamp to monitor loop current*/

/*
 * D/82 D4BD_GETSWITCHTYPE results
 */
#define PBX_L4			0x0A
#define PBX_L2			0x0B
#define PBX_NS			0x0C
#define PBX_M1			0x0D
#define PBX_SR			0x0E
#define PBX_SH			0x0F
#define PBX_SX			0x10
#define PBX_SX2			0x11
#define PBX_NE2K		0x12
#define PBX_NE2P		0x13

/* 
 * D42 events returned to the application 
 */
#define TD42_ASYNCCHSTATUS	    0x00D0 /* channel status event (not SL)  */
#if 0 /* N/A */
#define TD42_ASYNCCALLID	    0x00D1 /* caller ID is available(NS only)*/
#define TD42_SOFTKEYINPUT	    0x00D2 /* soft key pressed (NS only)     */
#define TD42_LIVERECORDENABLE	    0x00D3 /* live recording enabled(PA only)*/
#define TD42_LIVERECORDDISABLE	    0x00D4 /* live recording disable(PA only)*/
#define TD42_ASYNCCLOSEFEATSESSION  0x00D5 /* async. close of feature session*/
#define TD42_GETPBXMESSAGE	    0x00D6 /* get PBX message complete (NE2) */
#endif

#define TD42_ASYNCDISP		    0x00DA /* async display information */
#define TD42_ASYNCLINE		    0x00DB /* async line indicators */

#define TD42_NEWMESSAGEARRIVED	    0x00DD /* async new message arrived */

/* 
 *  Contents of 'datap' returned with TD42_ASYNCLINE event
 */
typedef struct lineindicator {
   unsigned short line;			/* line # */
   unsigned short status;		/* indicator state */
} LINEINDICATOR;


/* 
 *  D42 Library error codes returned by ATDV_LASTERR( )
 */
#define ED42_NOTIMP		    0x0500 /* Function not implemented 	     */
#define ED42_MAXCHAN		    0x0501 /* Max chan capacity reached	     */
#define ED42_INVALARG		    0x0502 /* Illegal argument to function   */
#define ED42_BADPARM		    0x0503 /* Invalid value for d42 parameter*/
#define ED42_UNSUPPORTED	    0x0504 /* Unsupported feature	     */
#define ED42_RDFWVER		    0x0505 /* Error reading version	     */
#define ED42_UNKNOWNBOARD	    0x0506 /* Unknown D/42 Board Type	     */
#define ED42_BADDEVICE		    0x0507 /* Invalid or wrong device handle */
#define ED42_DLLINIT		    0x0508 /* Unable to initialize the DLL   */
#define ED42_SYSTEM		    0x0509 /* System Error		     */
#define ED42_NOCOMM		    0x050A /* No Communication With Switch   */
#define ED42_NOTIDLE		    0x050B /* Device is not idle	     */

#define ED42_QEMPTY		    0x050E /* User buffer overflow	    */
#define ED42_MEMORY		    0x050F /* User buffer overflow	    */

 /*
 * Function prototypes
 */
#ifdef	D42_LIBDEVELOPMENT

#ifdef __cplusplus
extern "C" {		// C Plus Plus function bindings
#endif

int ATD4_BDTYPE(int);
int ATD4_CHTYPE(int);
int d42_brdstatus(int, char *, char *);   
int d42_chnstatus(int, char *, char *);
int d42_display(int, char *);
int d42_displayex(int, char *, int);
int d42_flags(int, char *);
int d42_getnewmessage(int, char *);
int d42_getparm(int, int, void *);
int d42_getver(int, char *, int);
int d42_gtcallid(int, char *);
int d42_indicators(int, char *);
int d42_indicatorsex(int, char *, int len);
int d42_lcdprompt(int, char *);
int d42_setparm(int, int, void *);

int d42_libinit(void);

#ifdef __cplusplus
}			// C Plus Plus function bindings
#endif

#else

#ifdef __cplusplus
extern "C" {		// C Plus Plus function bindings
#define extern
#endif

extern int ATD4_BDTYPE(int);
extern int ATD4_CHTYPE(int);
extern int d42_brdstatus(int, char *, char *);	 
extern int d42_chnstatus(int, char *, char *);
extern int d42_display(int, char *);
extern int d42_displayex(int, char *, int);
extern int d42_flags(int, char *);
extern int d42_getnewmessage(int, char *);
extern int d42_getparm(int, int, void *);
extern int d42_getver(int, char *, int);
extern int d42_gtcallid(int, char *);
extern int d42_indicators(int, char *);
extern int d42_indicatorsex(int, char *, int len);
extern int d42_lcdprompt(int, char *);
extern int d42_setparm(int, int, void *);

extern int d42_libinit(void);

#ifdef __cplusplus
}			// C Plus Plus function bindings
#undef extern
#endif

#endif

#endif /* __D42LIB_H__ */
