/*########@@@SOFT@@@WARE@@@COPY@@@RIGHT@@@###################################
# INTEL CONFIDENTIAL
#
# Copyright (C) 2000-2006 Intel Corporation. All Rights Reserved.
# The source code contained or described herein and all documents related
# to the source code ("Material") are owned by Intel Corporation or its
# suppliers or licensors. Title to the Material remains with Intel Corporation
# or its suppliers and licensors. The Material contains trade secrets and
# proprietary and confidential information of Intel or its suppliers and
# licensors. The Material is protected by worldwide copyright and trade secret
# laws and treaty provisions. No part of the Material may be used, copied,
# reproduced, modified, published, uploaded, posted, transmitted, distributed,
# or disclosed in any way without Intel's prior express written permission.
#
# No license under any patent, copyright, trade secret or other intellectual
# property right is granted to or conferred upon you by disclosure or delivery
# of the Materials, either expressly, by implication, inducement, estoppel or
# otherwise. Any license under such intellectual property rights must be
# express and approved by Intel in writing.
#
###################################@@@SOFT@@@WARE@@@COPY@@@RIGHT@@@########*/
/*****************************************************************************
 * Filename:    dcblib.h
 * DESCRIPTION: DCB UNIX library header file for application use
 ****************************************************************************/

#ifndef __DCBLIB_H__
#define __DCBLIB_H__


#define MAX_DCBDIGS 32
#define DCB_DTMF    0

/*
 * Ensure all structures are packed.
 */

#pragma pack(1)

typedef struct dcb_digits {
   unsigned char  dsp	;	   /* DSP number */
   int            confid;	   /* Conference Id*/
   int            chan_num;        /* channel/time slot number */
   int            chan_sel;        /* meaning of channel/time slot number */
   int            chan_attr;       /* channel attribute description */
   unsigned char digits[MAX_DCBDIGS+1];   /* ASCIIZ string of Received digits */
   unsigned char dig_type;         /* Type of digit (DTMF) */  
} DCB_DIGITS;

typedef struct dcb_ct {
	int confid;	   /* Conference ID */
	int chan_num;	   /* TS number */
	int chan_sel;	   /* TS selector */
} DCB_CT;

typedef struct ms_vol {
	unsigned char vol_control; /* Volume Control En/Disable */
	unsigned char vol_up;	   /* Increase Volume */
	unsigned char vol_reset;   /* Reset Volume */ 
	unsigned char vol_down;    /* Decrease Volume */
} MS_VOL;

typedef struct bridgecdt {
	MS_CDT cdtA;
	MS_CDT cdtB;
	unsigned int nBridgeID;
} TS_BRIDGECDT;

#if defined(sun)
#pragma pack()
#else
#pragma pack(4)
#endif

#define MSG_VOLDIG      0x33                /* Volume Control Digits */
#define MSG_RESTBL      0x50                /* Enable/Disable Conference Tbl*/
#define DT_DCB	  	0x00008000          /* DCB device class      */
#define DCBEV_DIGIT 	(DT_DCB| 0x96)      /* DTMF event            */
#define DCBEV_CTU 	(DT_DCB| 0x97)      /* Conference Tbl Update event*/
#define DCBEV_DELALLCONF (DT_DCB| 0x98)  /* DeleteAllConf Event          */
#define DCBEV_ERREVT     DTEV_ERREVT     /* Define error event */
#define DCBEV_BRIDGEESTABLISHED (DT_DCB | 0x99) /* bridge established */
#define DCBEV_BRIDGEREMOVED     (DT_DCB | 0x9A) /* bridge removed */


#define ON		1
#define OFF		0

#define GET_EVENT	0
#define SET_EVENT	1

#define CBMM_ZERO         0x0001
#define CBMM_ONE	  0x0002
#define CBMM_TWO 	  0x0004
#define CBMM_THREE	  0x0008
#define CBMM_FOUR	  0x0010
#define CBMM_FIVE 	  0x0020
#define CBMM_SIX 	  0x0040
#define CBMM_SEVEN 	  0x0080
#define CBMM_EIGHT        0x0100
#define CBMM_NINE	  0x0200
#define CBMM_STAR	  0x0400
#define CBMM_POUND        0x0800
#define CBMM_A		  0x1000
#define CBMM_B		  0x2000
#define CBMM_C 		  0x4000
#define CBMM_D		  0x8000
#define CBMM_ALL	  0xFFFF

#define CBA_SETMSK    0x0	/* Set mask */
#define CBA_ADDMSK    0x1	/* Add mask */
#define CBA_SUBMSK    0x2	/* Sub mask */
#endif

/* Standard DTMF Tone Ids for Volume Control */
#define VOL_DTMF_1       0x0001
#define VOL_DTMF_2       0x0002
#define VOL_DTMF_3       0x0003
#define VOL_DTMF_4       0x0004
#define VOL_DTMF_5       0x0005
#define VOL_DTMF_6       0x0006
#define VOL_DTMF_7       0x0007
#define VOL_DTMF_8       0x0008
#define VOL_DTMF_9       0x0009
#define VOL_DTMF_STAR    0x000e
#define VOL_DTMF_0       0x0000
#define VOL_DTMF_POUND   0x000f
#define VOL_DTMF_A       0x000a
#define VOL_DTMF_B       0x000b
#define VOL_DTMF_C       0x000c
#define VOL_DTMF_D       0x000d

/*
 * Prototypes for DCB960 library functions.
 */
#ifdef __cplusplus
extern "C" {   // C++ func bindings to enable C funcs to be called from C++
#define extern
#endif

#if (defined(__STDC__) || defined(__cplusplus))
   int dcb_setbrdparm(int, unsigned char, void *);/* Set dcb Board parameter */
   int dcb_getbrdparm(int, unsigned char, void *);/* Get dcb Board parameters*/
   int dcb_SetPartyParm(int, int, MS_CDT *, unsigned int, void *, void *);  /* Set dcb party parameter */
   int dcb_GetPartyParm(int, int, MS_CDT *, unsigned int, void *, void *);  /* Get dcb party parameter */
   int dcb_estconf(int, MS_CDT *,int, int, int *);/* Estab a conference      */
   int dcb_delconf(int, int);		  	  /* Delete conference       */
   int dcb_addtoconf(int,int, MS_CDT *);  	  /* Add a party to conf     */
   int dcb_remfromconf(int,int, MS_CDT *);	  /* Remove a party from conf*/
   int dcb_getcde(int, int, MS_CDT *);            /* Get conf. descr. elem   */
   int dcb_setcde(int,int,MS_CDT *);              /* Set conf. descr. elem   */
   int dcb_monconf(int,int, long *);              /* Monitor conference      */
   int dcb_unmonconf(int, int);                   /* Unmonitor conference    */
   int dcb_getatibits(int, unsigned long *);	  /* Get ATI bits            */
   int dcb_evtstatus(unsigned char, unsigned char, unsigned char *);/*status */
   int dcb_getdigitmsk(int, int ,unsigned short *);/* Get DTMF mask          */
   int dcb_open(char *, int);	                  /* Open DCB/SC device      */
   int dcb_tstcom(int, unsigned int);	          /* Test communication      */
   int dcb_close(int);			          /* Close DCB/SC device     */	
   int dcb_setdigitmsk(int, int, unsigned short, int);/* Set DTMF mask       */
   int dcb_dsprescount(int, int *);               /* Get config list         */
   int dcb_getcnflist(int, int, int *, MS_CDT *); /* Get DSP resource count  */
   int dcb_gettalkers(int, int, int *, MS_CDT *);  /* Get Active talkers     */
   int dcb_getatibitsEx(int, int*, DCB_CT*, void*);    /* Get ATI bits Extended            */
   int dcb_DeleteAllConferences(int,unsigned short,void*);    /* Delete All Conferences    */
   int dcb_CreateBridge(int,int,int,int,TS_BRIDGECDT*,unsigned short,void*);    /* Create Conference Bridge  */
   int dcb_DeleteBridge(int,int,int,int,TS_BRIDGECDT*,unsigned short,void*);    /* Delete Conference Bridge  */

#else
   int dcb_setbrdparm(); 	    /* Set dcb Board paramters       */
   int dcb_getbrdparm();            /* Get dcb Board parameters      */
   int dcb_SetPartyParm();          /* Set dcb party parameter       */
   int dcb_GetPartyParm();          /* Get dcb party parameter       */
   int dcb_estconf(); 		    /* Establish a conference        */
   int dcb_delconf();		    /* Delete conference             */
   int dcb_addtoconf();  	    /* Add a party to conf           */
   int dcb_remfromconf();	    /* Remove a party from conf      */
   int dcb_getcde();                /* Get conf. descr. element      */
   int dcb_setcde();                /* Set conf. descr. element      */
   int dcb_monconf();               /* Monitor conference            */
   int dcb_unmonconf();             /* Unmonitor conference          */
   int dcb_getatibits();	    /* Get ATI bits                  */
   int dcb_evtstatus();	  	    /* Get or set event status       */
   int dcb_getdigitmsk();            /* Get event mask                */
   int dcb_setdigitmsk();            /* Set event mask                */
   int dcb_tstcom();	   	    /* Test communication            */
   int dcb_open();		    /* Open dcb device               */
   int dcb_close();		    /* Close dcb device              */	
   int dcb_dsprescount();           /* Get config list               */
   int dcb_getcnflist();            /* Get DSP resource count        */
   int dcb_gettalkers(); 	    /* Get Active talkers             */
   int dcb_getatibitsEx();    /* Get ATI bits Extended            */
   int dcb_DeleteAllConferences();    /* Delete All Conferences    */
   int dcb_CreateBridge();            /* Create Bridge */
   int dcb_DeleteBridge();            /* Delete Bridge */
#endif

#ifdef __cplusplus
}
#undef extern
#endif

