/**************************************************************
    Copyright (C) 2000-2006.  Intel Corporation.

    All Rights Reserved.  All names, products,
    and services mentioned herein are the trademarks
    or registered trademarks of their respective organizations
    and are the sole property of their respective owners.
 **************************************************************/

/*
*    AUTO-VERSIONING HEADER  DO NOT HAND MODIFY
*    ===================================================================
*    %name:          devmapr4.h %
*    %version:       28 %
*    %instance:      hsw_1 %
*    %created_by:    ritscheg %
*    %date_modified: Tue Oct 26 21:15:52 2004 %
*    ===================================================================
*/
#ifndef __DEVMAPR4_H__
#define __DEVMAPR4_H__

#ifndef lint
static char    *_hsw_1_devmapr4_h = "@(#) %filespec: devmapr4.h-28 %  (%full_filespec: devmapr4.h-28:incl:hsw#1 %)";
#endif

/*
 * AUID typedef
 */
#ifndef AUID_TYPEDEF_DEFINED
#define AUID_TYPEDEF_DEFINED
#include "dlgctypes.h"
#endif

/******************************************************************************
** Maintenance Note:
**
** DeviceMapper Rules:
** -------------------
** 1) There are five main types of fields:
**       Enumerated Integers - their values are defined in devmapr4.h.
**          Example: DM_ATTR_TDM_BUSTYPE uses values: DM_BUS_TYPE_SCBUS,
**                                                    DM_BUS_TYPE_H100 , ....
**       Integers            - They are always defined as 'int' eventhough
**                                some could be argued to be unsigned. Their
**                                values will probably not be defined in
**                                devmapr4.h.
**          Example: PCI_BUS_SLOT_NUMBER should be integer.
**       Enumerated ASCIIz   - Their values should be listed in devmapr4.h
**          Example: DM_ATTR_CTPLATFORM uses values: DM_PLATFORM_DM3,
**                                                   DM_PLATFORM_PMAC, ....
**       ASCIIz            - Their values will probably not be defined in
**                              devmapr4.h.
**          Example: DM_ATTR_FWNAME
**       Bytes             - A description of their values should be in
**                              devmapr4.h
**          Example: None
**
** 2) Any variations from the above rule should be documented in the
**       devmapr4.h file.
******************************************************************************/

/******************************************************************************
** Non-standard attribute name definitions.
** The standard attribute name definitions are defined in devmap.h.
** Examples of standard attribute names are: DM_ATTR_NAME, and DM_ATTR_TYPE.
******************************************************************************/
#define DM_ATTR_FAMILY           "FAMILY"        /* Type is Enumerated ASCIIz      */
#define DM_ATTR_IPADDRESS        "IPADDRESS"     /* Type is ASCIIz in form w.x.y.z.*/
#define DM_ATTR_CT_PLATFORM      "CTPLATFORM"    /* Type is Enumerated ASCIIz      */
#define DM_ATTR_LOGICAL_ID       "LOGICAL ID"    /* Type is int.                   */
#define DM_ATTR_SERNUM           "SERIAL_NUMBER" /* Type is ASCIIz                 */
#define DM_ATTR_JACKNUMBER       "JACK_NUMBER"   /* Type is int.                   */
#define DM_ATTR_CLASP_NAME       "CLASP_NAME"    /* Type is ASCIIz                 */

/******************************************************************************
** The following two defines are used by Springware.  Springware needs to be
** changed so that it uses DM_ATTR_PCI_BUS_NUMBER and DM_ATTR_PCI_SLOT_NUMBER,
** so that all technologies are consistent starting in SR 6.0.
**#define DM_ATTR_SLOT_NUMBER      "SLOT_NUMBER"
**#define DM_ATTR_BUS_NUMBER       "BUS_NUMBER"
******************************************************************************/
#define DM_ATTR_PCM_ENCODING     "PCM_ENCODING"         /* Type is Enumerated ASCIIz */
#define DM_ATTR_FWNAME           "FIRMWARE_NAME"        /* Type is ASCIIz            */
#define DM_ATTR_BOARD_CONDITION  "BOARD_CONDITION"      /* Type is int (0=Okay)      */

/* The following are added as per 5.1 Based Andover Linux SAS(0.3) */

/* Build Info */
#define DM_ATTR_RELEASE_NAME        "RELEASE_NAME"      /* Type is ASCIIz.           */
#define DM_ATTR_BUILD_NUMBER        "BUILD_NUMBER"      /* Type is int.              */
#define DM_ATTR_BUILD_DATE          "BUILD_DATE"        /* Type is ASCIIz.           */

/* TDM Bus Info */
#define DM_ATTR_TDM_BUSTYPE         "TDM_BUSTYPE"       /* Type is Enumerated ASCIIz.*/
#define DM_ATTR_TDM_BUSLAW          "TDM_BUSLAW"        /* Type is Enumerated ASCIIz.*/
#define DM_ATTR_TDM_BUS_CR          "TDM_BUS_CR"        /* Type is Enumerated int.   */
#define DM_ATTR_TDM_GROUP1_CR       "TDM_GROUP1_CR"     /* Type is Enumerated int.   */
#define DM_ATTR_TDM_GROUP2_CR       "TDM_GROUP2_CR"     /* Type is Enumerated int.   */
#define DM_ATTR_TDM_GROUP3_CR       "TDM_GROUP3_CR"     /* Type is Enumerated int.   */
#define DM_ATTR_TDM_GROUP4_CR       "TDM_GROUP4_CR"     /* Type is Enumerated int.   */
#define DM_ATTR_TDM_PRIMARY_LINE    "TDM_PRIMARY_LINE"  /* Type is Enumerated ASCIIz.*/
#define DM_ATTR_MASTER_ROLE         "MASTER_ROLE"       /* Type is Enumerated int.   */
#define DM_ATTR_MASTER_SRC          "MASTER_SRC"        /* Type is Enumerated int.   */
#define DM_ATTR_MASTER_RATE         "MASTER_RATE"       /* Type is Enumerated int.   */
#define DM_ATTR_NETREF1_ROLE        "NETREF1_ROLE"      /* Type is int (0=Off, 1=On).*/
#define DM_ATTR_NETREF1_SOURCE      "NETREF1_SOURCE"    /* Type is int.              */
#define DM_ATTR_NETREF1_RATE        "NETREF1_RATE"      /* Type is Enumerated int.   */
#define DM_ATTR_NETREF2_ROLE        "NETREF2_ROLE"      /* Type is Enumerated int.   */
#define DM_ATTR_NETREF2_SOURCE      "NETREF2_SOURCE"    /* Type is int.              */
#define DM_ATTR_NETREF2_RATE        "NETREF2_RATE"      /* Type is Enumerated int.   */
#define DM_ATTR_NUM_TRUNKS          "NUM_TRUNKS"        /* Type is int.              */
#define DM_ATTR_TDM_BASE_SLOT       "TDM_BASE_SLOT"     /* Type is Enumerated int.   */
#define DM_ATTR_TDM_END_SLOT        "TDM_END_SLOT"      /* Type is Enumerated int.   */

/* Board Status Info */
#define DM_ATTR_BOARD_PRESENT       "BOARD_PRESENT"     /* Type is int (0=No, 1=Yes). */
#define DM_ATTR_BOARD_ENABLED       "BOARD_ENABLED"     /* Type is int (0=No, 1=Yes). */
#define DM_ATTR_PCI_BUS_NUMBER      "PCI_BUS_NUMBER"    /* Type is int.               */
#define DM_ATTR_PCI_SLOT_NUMBER     "PCI_SLOT_NUMBER"   /* Type is int.               */
#define DM_ATTR_SHELF_ID            "SHELF_ID"          /* Type is int.               */
#define DM_ATTR_CHASSIS_SLOT        "CHASSIS_SLOT"      /* Type is int.               */
#define DM_ATTR_FAULTSP_NAME        "FAULTSP_NAME"      /* Type is ASCIIz.            */
#define DM_ATTR_R4_VISIBLE          "R4_VISIBLE"        /* Type is int (0=No, 1=Yes). */
#define DM_ATTR_NETREF1_FALLBACK_ROLE   "NETREF1_FALLBACK_ROLE"   /* Type is int (0=Off, 1=On). */
#define DM_ATTR_NETREF1_FALLBACK_SOURCE "NETREF1_FALLBACK_SOURCE" /* Type is int.               */
#define DM_ATTR_MASTER_CLK_MODEL		"MASTER_CLK_MODEL"            /* Type is Enumerated int.    */

/******************************************************************************
*****  Attributes for DM3 Extended Platform MIB (provided for BoardWatch)******
******************************************************************************/
#define DM_ATTR_DESCRIPTION         "DESCRIPTION"       /* Type is ASCIIz.           */
#define DM_ATTR_FWNAME1             "FIRMWARE_NAME1"    /* Type is ASCIIz.           */
#define DM_ATTR_MEMBASEADDR         "MEMBASEADDR"       /* Type is int.              */
#define DM_ATTR_IOBASEADDR          "IOBASEADDR"        /* Type is int.              */
#define DM_ATTR_IRQ                 "IRQ"       /* Type is int.              */
#define DM_ATTR_STATE_CHANGE_DATE   "STATE_CHANGE_DATE" /* Type is ASCIIz.           */

/* Attributes available at TYPE_PROC level */
#define DM_ATTR_BK_VERSION          "BK_VERSION"        /* Type is ASCIIz.           */
#define DM_ATTR_RTK_VERSION         "RTK_VERSION"       /* Type is ASCIIz.           */
#define DM_ATTR_BK_FILE             "BK_FILE"   /* Type is ASCIIz.           */
#define DM_ATTR_RTK_FILE            "RTK_FILE"  /* Type is ASCIIz.           */
#define DM_ATTR_PROC_NUM            "PROC_NUM"  /* Type is int.              */


/******************************************************************************
*************************  PMAC Specific Attributes  **************************
******************************************************************************/

/******************************************************************************
** Note: Pre-SR 6.0: PMAC Admin used:
**   SerialNumber           , e.g., "0x12345678" Set by Detector    (from PAI)
**   DriverBoardId          , e.g., "2"          Set by Detector    (from PAI), Used by IPML
**   PciBusNumber           , e.g., "15"         Set by Detector    (from PAI)
**   PciSlotNumber          , e.g., "14"         Set by Detector    (from PAI)
**   PhysicalSlotNumber     , e.g., "16"         Set by Detector    (from PAI)
**   BoardPresent           , e.g., "No"         Set by Detector    (from PAI)
**   BoardEnabled           , e.g., "Yes"        Set by Initializer (from DCM/pmac.cfg (set by User))
**   StartContextId         , e.g., "1"          Set by Initializer (from DCM/pmac.cfg (set by User))
**   NumContexts            , e.g., "672"        Set by Initializer (from DCM/pmac.cfg (set by User))
**   RemoteCodec            , e.g., "G729a"      Set by Initializer (from DCM/pmac.cfg (set by User))
**   LocalCodec             , e.g., "G729a"      Set by Initializer (from DCM/pmac.cfg (set by User))
**   DefaultTimeslotEncoding, e.g., "ULAW"       Set by Initializer (from DCM/pmac.cfg (set by User))
**   StartTimeSlot          , e.g., "0"          Set by TimeSlotAssigner (from CTBB/.sctsbase)
**   EndTimeSlot            , e.g., "671"        Set by TimeSlotAssigner (from CTBB/.sctsbase)
**   ChannelCount           , e.g., "672"        Set by TimeSlotAssigner (based on NumContexts), Used by IPML
**   TdmTalkTS              , e.g., "1023"       Set by TimeSlotAssigner (from CTBB/.sctsbase) , Used by IPML
**   TdmTermId              , e.g., "1"          Set by TimeSlotAssigner (Use Channel Number)  , Used by IPML
**   StartTimeSlot          , e.g., "1"          Set by TimeSlotAssigner
**   EndTimeSlot            , e.g., "1"          Set by TimeSlotAssigner
******************************************************************************/
#define DM_ATTR_PMAC_DRIVER_BOARD_ID  "PMAC_DRIVER_BOARD_ID"    /* Type is int.               */
#define DM_ATTR_PMAC_START_CONTEXT_ID "PMAC_START_CONTEXT_ID"   /* Type is int.               */
#define DM_ATTR_PMAC_START_TERM_ID    "PMAC_START_TERM_ID"      /* Type is int.               */
#define DM_ATTR_PMAC_NUM_CONTEXTS     "PMAC_NUM_CONTEXTS"       /* Type is int.               */
#define DM_ATTR_PMAC_REMOTE_CODEC     "PMAC_REMOTE_CODEC"       /* Type is Enumerated ASCIIz. */
#define DM_ATTR_PMAC_LOCAL_CODEC      "PMAC_LOCAL_CODE" /* Type is Enumerated ASCIIz. */
#define DM_ATTR_PMAC_CHANNEL_COUNT    "PMAC_CHANNEL_COUNT"      /* Type is int.               */
#define DM_ATTR_PMAC_TDM_TALK_TS      "PMAC_TDM_TALK_TS"        /* Type is int.               */
#define DM_ATTR_PMAC_TDM_TERM_ID      "PMAC_TDM_TERM_ID"        /* Type is int.               */
#define DM_ATTR_PMAC_START_TIME_SLOT  "PMAC_START_TIME_SLOT"    /* Type is int.               */
#define DM_ATTR_PMAC_END_TIME_SLOT    "PMAC_END_TIME_SLOT"      /* Type is int.               */

/* These are Enumerated values of the attribute DM_ATTR_FAMILY_PMAC */
#define DM_FAMILY_PMAC              "NetStructure IPT Board Series"     /* Type is Enumerated ASCIIz. */

/******************************************************************************
**********************  Springware Specific Attributes  ***********************
******************************************************************************/

/******************************************************************************
** Note: Pre-SR 6.0: Genload uses: "Board Id (BLT ID)"
******************************************************************************/
#define DM_ATTR_BLT_ID              "BLT_ID"    // Type is int.
#define DM_ATTR_SW_TS_CLAIM_ID      "SW_TS_CLAIM_ID"  // Type is int.

// This is the board's unique product ID as set in genload.  The values are
// the PR_XXX defines from Genlow.h
#define DM_ATTR_SW_PRODUCT_ID       "SW_PRODUCT_ID" // Type is 32 bit unsinged

/******************************************************************************
** Entities that exist is the map
******************************************************************************/
#define TYPE_HOST                  100
#define TYPE_BLADE                 200
#define TYPE_JACK                  300
#define TYPE_CLOCK_AGENT           400
#define TYPE_R4_DEVICE_BASE        500
#define TYPE_TELEPHONY_BUS         600
#define TYPE_IP_CONNECTION         700
#define TYPE_PROC                  800
#define TYPE_USER_DEFINED_BASE    5000

/******************************************************************************
** These are Enumerated int values of the attribute
** DM_ATTR_BUS_FABRIC.
******************************************************************************/
#define DM_BUS_FABRIC_HARD_BUS     201  /* E.g., dxxxB1   */
#define DM_BUS_FABRIC_SOFT_BUS     202  /* E.g., dxxxB1   */

/******************************************************************************
** These are Virtual R4 Devices that may exist in the device map.
** 'Virtual R4 Device' sometimes refer to:
**    Virtual Boards (e.g., TYPE_R4_VOX_BOARD   )
**    Voice Channels (e.g., TYPE_R4_VOX_CHANNEL )
**    DTI Timeslots  (e.g., TYPE_R4_DTI_TIMESLOT)
**    CPs            (e.g., TYPE_SW_DCP         )
** These are Enumerated int values of the attribute
** DM_ATTR_TYPE (defined in devmap.h)
******************************************************************************/
#define TYPE_R4_VOX_BOARD          501  /* E.g., dxxxB1   */
#define TYPE_R4_VOX_CHANNEL        502  /* E.g., dxxxB1C1 */
#define TYPE_R4_DTI_BOARD          503  /* E.g., dtiB1    */
#define TYPE_R4_DTI_TIMESLOT       504  /* E.g., dxxxB1T1 */
#define TYPE_R4_MSI_BOARD          505  /* E.g., msiB1    */
#define TYPE_R4_MSI_STATION        506  /* E.g., msiB1C1  */
#define TYPE_R4_FAX_BOARD          507  /*                */
#define TYPE_R4_FAX_CHANNEL        508  /*                */
#define TYPE_R4_VR_BOARD           509  /* E.g., vrxB1    */
#define TYPE_R4_VR_CHANNEL         510  /* E.g., vrxB1C1  */
#define TYPE_R4_BRI_BOARD          511  /* E.g., briS1    */
#define TYPE_R4_BRI_TIMESLOT       512  /* E.g., briS1T1  */
#define TYPE_R4_SCX_BOARD          513  /* E.g., scxB1    */
#define TYPE_R4_DCB_BOARD          514  /* E.g., dcbB1    */
#define TYPE_SW_DCP                515  /* E.g., fruB1sd1 */
#define TYPE_R4_DPD_BOARD          516  /* E.g., dpdB1    */
#define TYPE_R4_DPD_CHANNEL        517  /* E.g., dpdB1C1  */
#define TYPE_R4_TTS_BOARD          518  /* E.g., ttsB1    */
#define TYPE_R4_TTS_CHANNEL        519  /* E.g., ttsB1C1  */
#define TYPE_R4_DMX_BOARD          520  /* E.g., dmxB1    */
#define TYPE_R4_CSP_BOARD          521  /* E.g., cspB1    */
#define TYPE_R4_CSP_CHANNEL        522  /* E.g., cspB1C1  */
#define TYPE_R4_BRI_DATA_BOARD     523  /* E.g., briD1    */
#define TYPE_R4_BRI_DATA_CHANNEL   524  /* E.g., briD1C1  */
#define TYPE_R4_IPT_BOARD          525  /*                */
#define TYPE_R4_IPT_TIMESLOT       526  /*                */
#define TYPE_R4_IPM_BOARD          527  /* E.g., ipmB1    */
#define TYPE_R4_IPM_CHANNEL        528  /* E.g., ipmB1C1  */
#define TYPE_R4_DCB_DSP            529  /* E.g., dcbB1D1  */
#define TYPE_R4_MOH_BOARD          530  /*                */
#define TYPE_R4_TPI_BOARD          531  /*                */
#define TYPE_R4_PHYSICAL_BOARD     532  /*E.g., brdB1      */
#define TYPE_R4_MM_BOARD           534  /* E.g., mmB1    */
#define TYPE_R4_MM_CHANNEL         535  /* E.g., mmB1C1  */
#define TYPE_R4_CNF_BOARD          536  /* e.g., cnfB1  */

/* for M3G */
#define TYPE_R4_M3G_BOARD		537
#define TYPE_R4_M3G_CHANNEL		538

#define TYPE_R4_MCX_BOARD          539  /* e.g., mcxB1  */

/******************************************************************************
** The following were added as per SR 6.0 Based Andover Linux SAS(0.3).
** Enumerated int values for entity of type TYPE_TELEPHONY_BUS.
******************************************************************************/
#define DM_BUS_TYPE_SCBUS          600  /* Enumerated int Value for DM_ATTR_TDM_BUSTYPE.      */
#define DM_BUS_TYPE_H100           601  /* Enumerated int Value for DM_ATTR_TDM_BUSTYPE.      */
#define DM_BUS_TYPE_H110           602  /* Enumerated int Value for DM_ATTR_TDM_BUSTYPE.      */
#define DM_BUS_TYPE_MVIP           603  /* Enumerated int Value for DM_ATTR_TDM_BUSTYPE.      */
#define DM_ENCODING_MULAW          604  /* Enumerated int Value for DM_ATTR_TDM_BUSLAW.       */
#define DM_ENCODING_ALAW           605  /* Enumerated int Value for DM_ATTR_TDM_BUSLAW.       */
#define DM_BUS_SPEED_2MHZ          606  /* Enumerated int Value for DM_ATTR_TDM_BUS_CR,DM_ATTR_TDM_GROUPn_CR. */
#define DM_BUS_SPEED_4MHZ          607  /* Enumerated int Value for DM_ATTR_TDM_BUS_CR,DM_ATTR_TDM_GROUPn_CR. */
#define DM_BUS_SPEED_8MHZ          608  /* Enumerated int Value for DM_ATTR_TDM_BUS_CR,DM_ATTR_TDM_GROUPn_CR. */
#define DM_LINE_CT_A               609  /* Enumerated int Value for DM_ATTR_TDM_PRIMARY_LINE. */
#define DM_LINE_CT_B               610  /* Enumerated int Value for DM_ATTR_TDM_PRIMARY_LINE. */
#define DM_BUS_ROLE_PRIMARY        611  /* Enumerated int Value for DM_ATTR_MASTER_ROLE.      */
#define DM_BUS_ROLE_SECONDARY      612  /* Enumerated int Value for DM_ATTR_MASTER_ROLE.      */
#define DM_BUS_ROLE_SLAVE          613  /* Enumerated int Value for DM_ATTR_MASTER_ROLE.      */
#define DM_CLOCK_SRC_OSC           614  /* Enumerated int Value for DM_ATTR_MASTER_SRC.       */
#define DM_CLOCK_SRC_NETREF1       615  /* Enumerated int Value for DM_ATTR_MASTER_SRC.       */
#define DM_CLOCK_SRC_NETREF2       616  /* Enumerated int Value for DM_ATTR_MASTER_SRC.       */
#define DM_CLK_RATE_8KHZ           617  /* Enumerated int Value for DM_ATTR_MASTER_RATE,DM_ATTR_NETREFn_RATE. */
#define DM_CLK_RATE_1_536MHZ       618  /* Enumerated int Value for DM_ATTR_MASTER_RATE,DM_ATTR_NETREFn_RATE. */
#define DM_CLK_RATE_1_544MHZ       619  /* Enumerated int Value for DM_ATTR_MASTER_RATE,DM_ATTR_NETREFn_RATE. */
#define DM_CLK_RATE_2_048MHZ       620  /* Enumerated int Value for DM_ATTR_MASTER_RATE,DM_ATTR_NETREFn_RATE. */
#define DM_CLK_RATE_NONE           621  /* Enumerated int Value for DM_ATTR_MASTER_RATE,DM_ATTR_NETREFn_RATE. */
#define DM_CLK_MODEL_NORMAL        622     /* Enumerated int Value for DM_ATTR_MASTER_CLK_MODEL. */
#define DM_CLK_MODEL_HOLDOVER      623     /* Enumerated int Value for DM_ATTR_MASTER_CLK_MODEL. */
#define DM_CLK_MODEL_FREERUN       624     /* Enumerated int Value for DM_ATTR_MASTER_CLK_MODEL. */
#define DM_CLK_MODEL_AUTOHOLDOVER  625     /* Enumerated int Value for DM_ATTR_MASTER_CLK_MODEL. */
#define DM_CLK_MODEL_AUTOFREERUN   626     /* Enumerated int Value for DM_ATTR_MASTER_CLK_MODEL. */
#define DM_R4_VISIBLE              1    /* Enumerated int Value for DM_ATTR_R4_VISIBLE */
#define DM_R4_NOT_VISIBLE          0    /* Enumerated int Value for DM_ATTR_R4_VISIBLE */

/******************************************************************************
** These are attributes related to HMP Bridging and Streaming.
*******************************************************************************/
#define DM_ATTR_BRIDGE_CAPABLE          "BRIDGE_CAPABLE"        /* Type is int (0=No, 1=Yes).   */
#define DM_ATTR_BRIDGE_ENABLED          "BRIDGE_ENABLED"        /* Type is int (0=No, 1=Yes).   */
#define DM_ATTR_BUS_FABRIC              "BUS_FABRIC"            /* Type is Enumerated int Value.*/
#define DM_ATTR_CAPABLE_ENABLED_YES     1                       /* Type is int (0=No, 1=Yes).   */
#define DM_ATTR_CAPABLE_ENABLED_NO      0                       /* Type is int (0=No, 1=Yes).   */
                                                                /* Values are: "HARD_BUS" and "SOFT_BUS" */

#define DM_ATTR_MIN_SOFT_BUS_TS_RANGE   "MIN_SOFT_BUS_TS_RANGE" /* Type is int                */
#define DM_ATTR_MAX_SOFT_BUS_TS_RANGE   "MAX_SOFT_BUS_TS_RANGE" /* Type is int                */
#define DM_ATTR_BC_NBR_HSI_HOLD_BUFFERS "BC_NBR_HSI_HOLD_BUFFERS" /* Type is int              */


#define DM_ATTR_HMP_CLOCK_MASTER_00     "HMP_CLOCK_MASTER_00"   /* Type is ASCIIz; range: "-1".."99999" and "HMP". */
#define DM_ATTR_HMP_CLOCK_MASTER_01     "HMP_CLOCK_MASTER_01"   /* Type is ASCIIz; range: "-1".."99999" and "HMP". */
#define DM_ATTR_HMP_CLOCK_MASTER_02     "HMP_CLOCK_MASTER_02"   /* Type is ASCIIz; range: "-1".."99999" and "HMP". */
#define DM_ATTR_HMP_CLOCK_MASTER_03     "HMP_CLOCK_MASTER_03"   /* Type is ASCIIz; range: "-1".."99999" and "HMP". */
#define DM_ATTR_HMP_CLOCK_MASTER_04     "HMP_CLOCK_MASTER_04"   /* Type is ASCIIz; range: "-1".."99999" and "HMP". */
#define DM_ATTR_HMP_CLOCK_MASTER_05     "HMP_CLOCK_MASTER_05"   /* Type is ASCIIz; range: "-1".."99999" and "HMP". */
#define DM_ATTR_HMP_CLOCK_MASTER_06     "HMP_CLOCK_MASTER_06"   /* Type is ASCIIz; range: "-1".."99999" and "HMP". */
#define DM_ATTR_HMP_CLOCK_MASTER_07     "HMP_CLOCK_MASTER_07"   /* Type is ASCIIz; range: "-1".."99999" and "HMP". */
#define DM_ATTR_HMP_CLOCK_MASTER_08     "HMP_CLOCK_MASTER_08"   /* Type is ASCIIz; range: "-1".."99999" and "HMP". */
#define DM_ATTR_HMP_CLOCK_MASTER_09     "HMP_CLOCK_MASTER_09"   /* Type is ASCIIz; range: "-1".."99999" and "HMP". */
#define DM_ATTR_HMP_CLOCK_MASTER_10     "HMP_CLOCK_MASTER_10"   /* Type is ASCIIz; range: "-1".."99999" and "HMP". */
#define DM_ATTR_HMP_CLOCK_MASTER_11     "HMP_CLOCK_MASTER_11"   /* Type is ASCIIz; range: "-1".."99999" and "HMP". */
#define DM_ATTR_HMP_CLOCK_MASTER_12     "HMP_CLOCK_MASTER_12"   /* Type is ASCIIz; range: "-1".."99999" and "HMP". */
#define DM_ATTR_HMP_CLOCK_MASTER_13     "HMP_CLOCK_MASTER_13"   /* Type is ASCIIz; range: "-1".."99999" and "HMP". */
#define DM_ATTR_HMP_CLOCK_MASTER_14     "HMP_CLOCK_MASTER_14"   /* Type is ASCIIz; range: "-1".."99999" and "HMP". */
#define DM_ATTR_HMP_CLOCK_MASTER_15     "HMP_CLOCK_MASTER_15"   /* Type is ASCIIz; range: "-1".."99999" and "HMP". */

#define DM_ATTR_BRIDGE_DEVICE_STATUS                                      "BridgeDeviceStatus"
#define DM_ATTR_BRIDGE_DEVICE_TYPE                                        "BridgeDeviceType"
#define DM_ATTR_BRIDGE_DEVICE_HMP_CLOCK_MASTER_FALLBACK_NBR_USER_DEFINED  "BridgeDeviceHMPClockMasterFallbackNbrUserDefined"
#define DM_ATTR_BRIDGE_DEVICE_HB_STREAM_CAPACITY                          "BridgeDeviceHBStreamCapacity"
#define DM_ATTR_BRIDGE_DEVICE_BH_STREAM_CAPACITY                          "BridgeDeviceBHStreamCapacity"
#define DM_ATTR_BRIDGE_DEVICE_MAX_HB_STREAM_SETTING                       "BridgeDeviceMaxHBStreamSetting"
#define DM_ATTR_BRIDGE_DEVICE_MAX_BH_STREAM_SETTING                       "BridgeDeviceMaxBHStreamSetting"
#define DM_ATTR_BRIDGE_DEVICE_MULTI_BRIDGE_SYNCH_PATTERN                  "BridgeDeviceMultiBridgeSynchPattern"
#define DM_ATTR_BRIDGE_CONTROLLER_MULTI_BRIDGE_IDLE_PATTERN_MULAW         "BridgeControllerMultiBridgeIdlePatternMuLaw"
#define DM_ATTR_BRIDGE_CONTROLLER_MULTI_BRIDGE_IDLE_PATTERN_ALAW          "BridgeControllerMultiBridgeIdlePatternALaw"
#define DM_ATTR_BRIDGE_CONTROLLER_SYSTEM_MAX_HB_STREAMS                   "SystemMaxHBStreams"
#define DM_ATTR_BRIDGE_CONTROLLER_SYSTEM_MAX_BH_STREAMS                   "SystemMaxBHStreams"
#define DM_ATTR_BRIDGE_STREAM_PCM_ENCODING                                "MediaTypeResolved"
#define DM_ATTR_PHYSICAL_ID_AKA_INSTANCE_NUMBER                           "InstanceNumber"
#define DM_ATTR_BRIDGE_PORT                                               "BridgePort"
#define DM_ATTR_BRIDGE_ID                                                 "BridgeID"

#define DM_ATTR_BRIDGE_STREAM_CAPACITY_256  256  /*Type is int*/
#define DM_ATTR_BRIDGE_STREAM_CAPACITY_000  000  /*Type is int*/
#define DM_ATTR_BRIDGE_STREAM_CAPACITY_001  001  /*Type is int*/
#define DM_ATTR_BRIDGE_STREAM_CAPACITY_002  002  /*Type is int*/
#define DM_ATTR_BRIDGE_STREAM_CAPACITY_004  004  /*Type is int*/
#define DM_ATTR_BRIDGE_STREAM_CAPACITY_008  008  /*Type is int*/
#define DM_ATTR_BRIDGE_STREAM_CAPACITY_016  016  /*Type is int*/
#define DM_ATTR_BRIDGE_STREAM_CAPACITY_032  032  /*Type is int*/
#define DM_ATTR_BRIDGE_STREAM_CAPACITY_064  064  /*Type is int*/
#define DM_ATTR_BRIDGE_STREAM_CAPACITY_128  128  /*Type is int*/
#define DM_ATTR_BRIDGE_STREAM_CAPACITY_192  192  /*Type is int*/
#define DM_ATTR_BRIDGE_STREAM_CAPACITY_320  320  /*Type is int*/
#define DM_ATTR_BRIDGE_STREAM_CAPACITY_384  384  /*Type is int*/
#define DM_ATTR_BRIDGE_STREAM_CAPACITY_448  448  /*Type is int*/
#define DM_ATTR_BRIDGE_STREAM_CAPACITY_512  512  /*Type is int*/

#define DM_ATTR_BRIDGE_DEVICE_TYPE_SOFTORCT  "Soft_OR_CT_Bus_Bridge_Device" /*Type is ASCIIz */
#define DM_ATTR_BRIDGE_DEVICE_TYPE_DEDICATED "Dedicated_Bridge_Device" /*Type is ASCIIz */

#define DM_ATTR_BRIDGE_SYNCH_PATTERN_30313233  0x30313233  /*Type is int   */
#define DM_ATTR_BRIDGE_SYNCH_PATTERN_31323334  0x31323334  /*Type is int   */
#define DM_ATTR_BRIDGE_SYNCH_PATTERN_35363738  0x35363738  /*Type is int   */
#define DM_ATTR_BRIDGE_SYNCH_PATTERN_36373839  0x36373839  /*Type is int   */

#define DM_ATTR_BC_IDLE_PATTERN_ALAW_D5   0xD5  /*Type is int   */
#define DM_ATTR_BC_IDLE_PATTERN_ALAW_55   0x55  /*Type is int   */
#define DM_ATTR_BC_IDLE_PATTERN_ALAW_54   0x54  /*Type is int   */
#define DM_ATTR_BC_IDLE_PATTERN_MULAW_7F  0x7F  /*Type is int   */
#define DM_ATTR_BC_IDLE_PATTERN_MULAW_FF  0xFF  /*Type is int   */

#define DM_ATTR_BRIDGE_DEVICE_STATUS_STOPPED         "Bridge_Device_Status_Stopped"  /* Type is ASCIIz */
#define DM_ATTR_BRIDGE_DEVICE_STATUS_STARTING        "Bridge_Device_Status_Starting"  /* Type is ASCIIz */
#define DM_ATTR_BRIDGE_DEVICE_STATUS_STARTED         "Bridge_Device_Status_Started"  /* Type is ASCIIz */
#define DM_ATTR_BRIDGE_DEVICE_STATUS_STOPPING        "Bridge_Device_Status_Stopping"  /* Type is ASCIIz */
#define DM_ATTR_BRIDGE_DEVICE_STATUS_HMPCLOCKMASTER  "Bridge_Device_Status_HMPClockMaster"  /* Type is ASCIIz */
#define DM_ATTR_BRIDGE_DEVICE_STATUS_FAILED          "Bridge_Device_Status_Failed"  /* Type is ASCIIz */

#define DM_ATTR_HMP_CLK_MASTER_FALLBACK_NBR_03  03  /*Type is int*/
#define DM_ATTR_HMP_CLK_MASTER_FALLBACK_NBR_00  00  /*Type is int*/
#define DM_ATTR_HMP_CLK_MASTER_FALLBACK_NBR_01  01  /*Type is int*/
#define DM_ATTR_HMP_CLK_MASTER_FALLBACK_NBR_02  02  /*Type is int*/
#define DM_ATTR_HMP_CLK_MASTER_FALLBACK_NBR_04  04  /*Type is int*/
#define DM_ATTR_HMP_CLK_MASTER_FALLBACK_NBR_05  05  /*Type is int*/
#define DM_ATTR_HMP_CLK_MASTER_FALLBACK_NBR_06  06  /*Type is int*/
#define DM_ATTR_HMP_CLK_MASTER_FALLBACK_NBR_07  07  /*Type is int*/
#define DM_ATTR_HMP_CLK_MASTER_FALLBACK_NBR_08  08  /*Type is int*/
#define DM_ATTR_HMP_CLK_MASTER_FALLBACK_NBR_09  09  /*Type is int*/
#define DM_ATTR_HMP_CLK_MASTER_FALLBACK_NBR_10  10  /*Type is int*/
#define DM_ATTR_HMP_CLK_MASTER_FALLBACK_NBR_11  11  /*Type is int*/
#define DM_ATTR_HMP_CLK_MASTER_FALLBACK_NBR_12  12  /*Type is int*/
#define DM_ATTR_HMP_CLK_MASTER_FALLBACK_NBR_13  13  /*Type is int*/
#define DM_ATTR_HMP_CLK_MASTER_FALLBACK_NBR_14  14  /*Type is int*/
#define DM_ATTR_HMP_CLK_MASTER_FALLBACK_NBR_15  15  /*Type is int*/

#define DM_ATTR_BC_HSI_HOLD_BUFFERS_03    3  /*Type is int*/
#define DM_ATTR_BC_HSI_HOLD_BUFFERS_02    2  /*Type is int*/
#define DM_ATTR_BC_HSI_HOLD_BUFFERS_04    4  /*Type is int*/
#define DM_ATTR_BC_HSI_HOLD_BUFFERS_05    5  /*Type is int*/
/******************************************************************************
** Enumerated ASCIIz values for attribute: DM_ATTR_CT_PLATFORM
******************************************************************************/
#define DM_PLATFORM_DM3           "DM3"
#define DM_PLATFORM_SPRINGWARE    "SPRINGWARE"
#define DM_PLATFORM_PMAC          "PMAC"
#define DM_PLATFORM_ANTARES       "ANTARES"
#define DM_PLATFORM_ROZETTA       "ROZETTA"


#endif /* #ifndef __DEVMAPR4_H__ */
