/********************************************************
  Copyright  2000 - 2001 Intel Corporation.
  All Rights Reserved.
 ********************************************************/

/*
    AUTO-VERSIONING HEADER  DO NOT HAND MODIFY
    ===================================================================
    name     : %name %
    version  : %version %
    state    : %state %
    full_name: %full_name %
    creater  : %name %
    mod_date : %date_modified %
    ===================================================================
*/
  
#ifndef _DLG_CLOCKING_ADAPTOR_FW_H
#define _DLG_CLOCKING_ADAPTOR_FW_H

#include <list>

#include "dlgctypes.h"
#include "ICTBus.h"
#include "dlgeventproxydef.h"		//defines DlgEventMsgTypePtr
#include "dlgclockserverlibfw.h"

using namespace std;

namespace DlgClockFW
{   
    class DLGCLOCKFW_API CDlgClockAdapterFW 
    {
    public:
        typedef std::list<AUID> AUIDListT;

        CDlgClockAdapterFW();
        
        virtual ~CDlgClockAdapterFW();

        //called after entire system is downloaded
        virtual long AddBoardToTDMBus( const char* node, AUIDListT& auidList, AUIDListT& failedList )     = 0;
        
        //called after entire system is stopped
        virtual long RemoveBoardFromTDMBus(const char* node, AUIDListT& auidList) = 0;

        //called after the end of the detection phase
        virtual long CalculateTDMBus(const char* node) = 0;

        //called by User via DASI to verify if user tdm bus config update is valid 
        virtual long VerifyBusConfig(const char* node, AUID busAuid, DASI::CTBUSCONFIGURATION& busConfig) = 0;

        //retrive error string
        virtual const char* GetErrorDescription( long errorId ) = 0;
        
        //TDM BUS Events
        //override these virtual methods to handle
        //TDM bus events.
        
        virtual DlgEvent_TRESULT OnEvent_CT_A_LINESBAD( const DlgEventMsgTypePtr pEventMsg );

        virtual DlgEvent_TRESULT OnEvent_CT_B_LINESBAD( const DlgEventMsgTypePtr pEventMsg);
        
        virtual DlgEvent_TRESULT OnEvent_SCBUS_COMPAT_LINESBAD( const DlgEventMsgTypePtr pEventMsg);
        
        virtual DlgEvent_TRESULT OnEvent_MVIP_COMPAT_LINESBAD(  const DlgEventMsgTypePtr pEventMsg);
        
        virtual DlgEvent_TRESULT OnEvent_NETREF1_LINEBAD( const DlgEventMsgTypePtr pEventMsg);
        
        virtual DlgEvent_TRESULT OnEvent_LOSS_MASTER_SOURCE_INVALID( const DlgEventMsgTypePtr pEventMsg);

        virtual DlgEvent_TRESULT OnEvent_SYNC_MASTER_CLOCK( const DlgEventMsgTypePtr pEventMsg );

        virtual DlgEvent_TRESULT OnEvent_EXTERNAL_ALARM_RED( const DlgEventMsgTypePtr pEventMsg);

        virtual DlgEvent_TRESULT OnEvent_EXTERNAL_ALARM_RED_CLEAR( const DlgEventMsgTypePtr pEventMsg );

        virtual DlgEvent_TRESULT OnEvent_EXTERNAL_ALARM_YELLOW(  const DlgEventMsgTypePtr pEventMsg );

        virtual DlgEvent_TRESULT OnEvent_EXTERNAL_ALARM_YELLOW_CLEAR(  const DlgEventMsgTypePtr pEventMsg );

        virtual DlgEvent_TRESULT OnEvent_EXTERNAL_CARRIER_DETECT( const DlgEventMsgTypePtr pEventMsg );

        virtual DlgEvent_TRESULT OnEvent_EXTERNAL_LOSS_OF_SIGNAL( const DlgEventMsgTypePtr pEventMsg );
    };

}

#endif
