/**************************************************************
    Copyright (C) 2000-2002.  Intel Corporation.

    All Rights Reserved.  All names, products,
    and services mentioned herein are the trademarks
    or registered trademarks of their respective organizations
    and are the sole property of their respective owners.
 **************************************************************/

/*
*    AUTO-VERSIONING HEADER  DO NOT HAND MODIFY
*    ===================================================================
*    %name:          dlgcstructs.h %
*    %version:       45 %
*    %instance:      hsw_1 %
*    %created_by:    lingx %
*    %date_modified: Tue Oct 19 10:38:08 2004 %
*    ===================================================================
*/

#ifndef __DLGCSTRUCTS_H__
#define __DLGCSTRUCTS_H__

#include "dlgctypes.h"

#include <list>
#include <string>
#include <vector>

//trunk attributes
typedef struct _tagTrunkAttributes
{
    long                structVersion;
    AUID                trunkID;
    AUID                clockingAgentID;
    TRUNKTYPE           trunkType;
    TRUNKOPSTATUS       trunkStatus;
    std::string         trunkName;
} TRUNKATTRIBUTES, *LPTRUNKATTRIBUTES;

//system attributes
typedef struct _tagNodeAttributes
{
  long          structVersion;
  std::string   nodeAddress;
  std::string   nodeName;
  long          numberOfShelves;
  long          numberOfInstalledBoards;
  std::string   locationDescription;
  std::string   operatingSystem;
  short		    autoSetting;
  long          lMajorRelease;
  long          lMinorRelease;
  long          lSubMinorRelease;
  long          lSystemReleaseBuildNumber;
  long          lFeaturePackNumber;
  long          lFeaturePackBuildNumber;
  long          lServicePackNumber;
  long          lServicePackBuildNumber;
  long			lNodeKey;				//newly added 5-28-03 
} NODEATTRIBUTES, *LPNODEATTRIBUTES;

typedef std::list<NODEATTRIBUTES>    NODEATTRIBUTELIST;
typedef NODEATTRIBUTELIST::iterator NODEATTRIBUTELIST_ITER;

//shelf attributes
typedef struct _tagShelfAttribute
{
    SHELFID     lShelfId;
    std::string shelfDesc;

} SHELFATTRIBUTES, *LPSHELFATTRIBUTES;

typedef std::list<SHELFATTRIBUTES> SHELFATTRIBUTESLIST;
typedef SHELFATTRIBUTESLIST::iterator SHELFATTRIBUTESLIST_ITER;

//board installation attributes
typedef struct _tagBoardInstallationAttr
{
    long                structVersion;
    CTPLATFORM          ctPlatform;
    CTPLATFORMFAMILY    family;
    std::string         BoardName;
    std::string         BoardDescription;
    PHYSICALID          lPhysicalId;
    IPADDRESS           nodeAddress;
    SHELFID             lShelfId;
    SHELFTYPE           sShelfType;
    PHYSCIALSLOTNUMBER	physicalSlot;
    PCIBUSID            pciBus;
    PCISLOTNUMBER       pciSlot;
    LOGICALID           lLogicalId;
    TDMBUSAUID          tdmBus;
    SERIALNUMBER        sSerialNumber;
    std::string         ModelNumber;
    short               numClockingAgents;
    short               numNetworkInterfaces;
    bool                preConfigFlag;
} INSTALLATIONATTRIBUTES, *LPINSTALLATIONATTRIBUTES;

typedef std::list<std::string> CTPLATFORMLIST;
typedef CTPLATFORMLIST::iterator CTPLATFORMLIST_ITER;

typedef struct _tagBoardStatusAttr
{
    DLGSTATUS           opStatus;
    DLGSTATUS           adStatus;
    FAULTSTATUSTYPE     faultStatus;
} BOARDSTATUSATTRS, *LPBOARDSTATUSATTRS;

typedef struct _tagSlotInfoStruct
{
    PHYSCIALSLOTNUMBER  physicalSlotNumber;
    PCISLOTNUMBER       pciSlot;
    std::string         slotDesc;
} SlotInfo, SLOTINFO, *LPSLOTINFO;

typedef std::list<SLOTINFO> SLOTINFOLIST;
typedef SLOTINFOLIST::iterator SLOTINFOLIST_ITER;

//tdm bus structures
//Bus configuration
typedef struct _tagTDMBusConfiguration
{
    TDMBUSTYPE          bustype;
    CLOCKRATE           scBusClockRate;
    CLOCKRATE           group1ClockRate;
    CLOCKRATE           group2ClockRate;
    CLOCKRATE           group3ClockRate;
    CLOCKRATE           group4ClockRate;
    bool                MVIPCompatLinesActive;
    bool                SCBusCompatLinesActive;
    AUID                primaryMaster;
    long                primaryClockSource;
    AUID                secondaryMaster;
    long                secondaryClockSource;
    short               primaryLines;
    AUID                netrefBoard;
    long                netrefSource;
    NETREFCLOCKRATES    netrefClockRate;
    AUID                netref2Board;
    long                netref2Source;
    NETREFCLOCKRATES    netref2ClockRate;
    bool                termination;
	short				pcmEncoding;
} TDMBUSCONFIGURATION, *LPTDMBUSCONFIGURATION;;

//Bus Attributes
typedef struct _tagTDMBusAttributes
{
    std::string     busName;
    short           clockDaemonMode;
    TIMESLOTNUMBER  baseTimeslot;
} TDMBUSATTRIBUTES, *LPTDMBUSATTRIBUTES;

//public network reference
typedef struct _tagNetworkReference
{
    AUID    netrefBoard;
    long    netrefSource;
} NETWORKREFERENCE, *LPNETWORKREFERENCE;

typedef std::list <NETWORKREFERENCE> REFERENCELIST;
typedef REFERENCELIST::iterator REFERENCELIST_ITER;

typedef struct _tagTimeslotCoordinate
{
    short   streamNumber;
    long    timeslotInStreamNumber;
} TIMESLOTCOORDINATE, *LPTIMESLOTCOORDINATE;

typedef struct _tagTimeslot
{
    TIMESLOTNUMBER      ordinal;
    TIMESLOTCOORDINATE  coordinate;
} TIMESLOT, *LPTIMESLOT;

typedef std::list <TIMESLOT> TIMESLOTLIST;
typedef TIMESLOTLIST::iterator TIMESLOTLIST_ITER;

typedef struct _tagTimeslotSegment
{
    TIMESLOT    startPoint;
    TIMESLOT    endPoint;
    long        numberOfTimeslots;
} TIMESLOTSEGMENT, *LPTIMESLOTSEGMENT;

typedef std::list<TIMESLOTSEGMENT> TIMESLOTSEGMENTLIST;
typedef TIMESLOTSEGMENTLIST::iterator TIMESLOTSEGMENTLIST_ITER;

typedef struct _tagTimeslotErrorStruct
{
    CLAIMID     claimId;
    std::string error;
} TimeslotError, TIMESLOTERROR, *LPTIMESLOTERROR;

typedef std::list<CLAIMID> TIMESLOTCLAIMIDLIST;
typedef TIMESLOTCLAIMIDLIST::iterator TIMESLOTCLAIMIDLIST_ITER;

//dm3 structures
typedef struct _tagDM3Attr
{
    long        structVersion;
    std::string pcdFileName;
    std::string fcdFileName;
    std::string offDiagPcdFileName;
    std::string pcdFileDesc;
    long        processTimeout;
    long        replyMsgTimeout;
    long        traceLevel;
} DM3ATTRIBUTES, *LPDM3ATTRIBUTES;

typedef struct _tagDM3PhysicalAttributes
{
    long    structVersion;
    long    pciId;
    long    instanceNumber;
    long    intVector;
    long    IRQLevel;
    long    PLXlength;
    long    PLXAddr;
    long    SRAMlength;
    long    SRAMAddr;
    long    SRAMSize;
    long    DlgcOUI;
    long    PrimaryBoardID;
    long    SecondaryBoardID;
    short   boardPcmEncoding;
} DM3PHYSICALATTRIBUTES, *LPDM3PHYSICALATTRIBUTES;

typedef std::list<DM3PHYSICALATTRIBUTES> DM3PHYSICALATTRIBUTESLIST;
typedef DM3PHYSICALATTRIBUTESLIST::iterator DM3PHYSICALATTRIBUTESLIST_ITER;

typedef struct _tagWerewolfAttr
{
    long structVersion;
    long numberMFAInboundQ;
    long sizeofMFAInboundQ;
    long numberMFAOutboundQ;
    long sizeofMFAOutboundQ;
    long numberBigMsgBlocks;
    long sizeofBigMsgBlocks;
    long numberOrphanEntries;
    long flowControlToBoard;
    long flowControlFromBoard;
    long hardwareTimeout;
    long maxNumStreamsMFAAllowed;
} WEREWOLFATTRIBUTES, *LPWEREWOLFATTRIBUTES;

typedef struct _tagDM3NTDriverAttributes
{
    long    structVersion;
    long    doDMA;
    long    freeOrphanOnDepletion;
    long    maxOrphanStrmSize;
    long    orphanageMsgLen;
    long    orphanageMsgTimeout;
    long    orphanStrmTableSize;
    long    outStrmQuantum;
    long    sramInQuantum;
    long    sramOutQuantum;
    long    sramOutTimer;
} DM3NTDRIVERATTRIBUTES, *LPDM3NTDRIVERATTRIBUTES;

typedef struct _tagDM3UnixDriverAttributes
{
    long    structVersion;
    long    numStreams;
    long    numBinds;
} DM3UNIXDRIVERATTRIBUTES, *LPDM3UNIXDRIVERATTRIBUTES;

typedef union _tagDriverAttributesUnion
{
    DM3NTDRIVERATTRIBUTES   Dm3NTDriverAttributes;
    DM3UNIXDRIVERATTRIBUTES Dm3UnixDriverAttributes;
    WEREWOLFATTRIBUTES      WereWolfDriverAttributes;
} UDRIVERATTRIBUTES, *LPUDRIVERATTRIBUTES;

typedef struct _tagDlgDriverAttributes
{
	DLG_DRIVER_TYPES		uTag;
	UDRIVERATTRIBUTES		uDriverAttr;
} DLGDRIVERATTRIBUTES, *LPDLGDRIVERATTRIBUTES;


typedef struct _tagDM3VersionAttributes
{
    long        structVersion;
    std::string CPBKVersion;
    std::string CPRTKVersion;
    std::string SPBKVersion;
    std::string SPRTKVersion;
} DM3VERSIONATTRIBUTES, *LPDM3VERSIONATTRIBUTES;

typedef struct _tagDM3NetworkAttributes
{
    long    structVersion;
    std::string  IPAddress;
    std::string  SubnetMask;
    std::string  targetName;
    std::string  HostIPAddress;
    std::string  HostName;
    std::string  UserName;
    std::string  GatewayIPAddress;
} DM3NETWORKATTRIBUTES, *LPDM3NETWORKATTRIBUTES;

typedef std::list<DM3NETWORKATTRIBUTES> DM3NETWORKATTRIBUTESLIST;
typedef DM3NETWORKATTRIBUTESLIST::iterator DM3NETWORKATTRIBUTESLIST_ITER;

//pmac structures
typedef struct _tagPMACAttributes
{
    long    structVersion;
    short   pciSlotNumber;
    short   pciBusNumber;
    short   driverBoardId;
    short   maxNumLagunas;
} PMACATTRIBUTES, *LPPMACATTRIBUTES;

typedef struct _tagPMACContextProps
{
    long    structVersion;
    short   maxNumContexts;
    short   maxNumTerminationsPerContext;
    short   maxNumTDMTerminations;
    short   maxNumRTPTerminations;
    short   maxNumHostTerminations;
    short   maxNumEventsPerTermination;
    short   maxNumSignalsPerTemrination;
    short   startContextID;
    short   timeslot;
} PMACCONTEXTPROPS, *LPPMACCONTEXTPROPS;

typedef struct _tagPMACDTMFConfig
{
    long    structVersion;
    short   maxNumDigitMaps;
    short   dtmfDetectionTime;
    short   dtmfGuardTime;
    short   dtmfInterdigitTime;
    short   dtmfVolume;
    short   dtmfh245Mode;
    short   dtmfh245DurationEstimate;
    short   dtmfh245TotalDuration;
    short   digitString;
    long    digitMapStartTimer;
    long    digitMapShortTimer;
    long    digitMapLongTimer;
}PMACDTMFCONFIG, *LPPMACDTMFCONFIG;

typedef struct _tagPMACCallDefaults
{
    long    structVersion;
    short   codec;
    short   briefSignalTime;
    short   lostPacketThreshold;
    short   jitterBufferLength;
    short   echoTailLength;
    short   echoReturnLoss;
    short   tdmTransmitAttenuation;
    short   voiceActivityDetection;
    short   terminationMethod;
    short   toneIDList;
    short   CPTOnTime;
    short   CPTOffTime;
    short   CPTFreqLow;
    short   CPTFreqHigh;
    short   CPTGainLow;
    short   CPTGainHigh;
}PMACCALLDEFAULTS, *LPPMACCALLDEFAULTS;

typedef struct _tagPMACVersionProps
{
    long    structVersion;
    long    hardwareVersion;
    long    bootROMVersion;
    short   pmacSoftwareVersion;
    short   lagunaVersion;
}PMACVERSIONPROPS, *LPPMACVERSIONPROPS;

typedef struct _tagPMACNetworkProps
{
    long    structVersion;
    long    numEthernetGiga;
    long    numEthernet100BT;
    short   maxNumIPAddressesPerInterface;
    char    ipVersion[16];
    long    ipInterface[4];
    long    macAddress[4];
    long    ipv4Address;
    short   ethernetLoadSharingMode;
    short   ethernetFailoverMode;
    long    udpPortStart;
    long    numUDPPortsPerIPAddress;
    short   udpUseChecksum;
    long    typeOfService;
    long    timeToLive;
    long    dhcpMode;
    long    physicalAddress32;
    long    udpPort;
    short   voiceFrameSize;
    long    voiceFramesPerPacket;
}PMACNETWORKPROPS, *LPPMACNETWORKPROPS;

//rozetta structures
typedef struct _tagRozettaKernelBoardConfig
{
    long        structVersion;
    std::string IPAddress;
    long        maxPeers;
    long        peerTimeout;
} ROZETTAKERNELBOARDCONFIG, *LPROZETTAKERNELBOARDCONFIG;

typedef struct _tagClockingAgentError
{
  AUID              agentId;
  AUID              boardId;
  DLGSYSRESULTTYPE  error;
  std::string       errmsg;
} CAERROR, *LPCAERROR;


/*
 * Only present for compatiblity
 */

typedef std::list<SlotInfo> SlotInfoList;

//managed object attributes etc
typedef struct _tagManagedObjectError
{
  AUID                  objectId;
  DlgSysResultType      error;
  std::string           errmsg;
} MOERROR, *LPMOERROR;

typedef std::list<MOERROR> MOERRORLIST;
typedef MOERRORLIST::iterator MOERRORLIST_ITER;

typedef struct _tagBoardTDMCapabilities
{
    long structVersion;
    bool canH100Master;
    bool canH100Slave;
    bool canH110Master;
    bool canH110Slave;
    bool canScbusMaster;
    bool canScbusSlave;
    bool canMvipMaster;
    bool canMvipSlave;
    bool canScbus2Mhz;
    bool canScbus4Mhz;
    bool canScbus8Mhz;
    bool canProvideNetrefAt8Khz;
    bool canProvideNetrefAt1536Mhz;
    bool canProvideNetrefAt1544Mhz;
    bool canProvideNetrefAt2048Mhz;
    bool canDeriveNetrefAt8Khz;
    bool canDeriveNetrefAt1536Mhz;
    bool canDeriveNetrefAt1544Mhz;
    bool canDeriveNetrefAt2048Mhz;
    bool canProvideNetref2At8Khz;
    bool canProvideNetref2At1536Mhz;
    bool canProvideNetref2At1544Mhz;
    bool canProvideNetref2At2048Mhz;
    bool canDeriveNetref2At8Khz;
    bool canDeriveNetref2At1536Mhz;
    bool canDeriveNetref2At1544Mhz;
    bool canDeriveNetref2At2048Mhz;
    bool canSilenceScbusCompatLines;
    bool canSilenceMvipCompatLines;
    bool canDeriveNetrefFromOsc;
    bool canTerminate;
    bool canDynamicConfigure;
    bool canUseLocalFEAsMasterSource;
    short maxClockMasterSourceListSize;
    bool isAlawCapable;
    bool isMulawCapable;
    bool isConversionCapable;
} TDMCAPABILITIES, *LPTDMCAPABILITIES;

//agent configuration
typedef struct _tagBoardTDMBusConfiguration
{
    long                structVersion;
    bool                onTelephonyBus;
    short               busType;
    CLOCKRATE           scBusClockRate;
    CLOCKRATE           group1ClockRate;
    CLOCKRATE           group2ClockRate;
    CLOCKRATE           group3ClockRate;
    CLOCKRATE           group4ClockRate;
    bool                MVIPCompatLinesActive;
    bool                SCBusCompatLinesActive;
    short               clockMasterRole;
    long                clockMasterSource;
    long                clockMasterSourceList[16];
    CLOCKRATE           clockMasterRate;
    short               clockingModel;
    short               primaryLines;
    bool                isProvidingNetref;
    long                netrefSource;
    NETREFCLOCKRATES    netrefClockRate;
    bool                isProvidingNetref2;
    long                netref2Source;
    NETREFCLOCKRATES    netref2ClockRate;
    bool                termination;
} TDMCONFIGURATION, *LPTDMCONFIGURATION;

//clocking agent attributes
typedef struct _tagClockingAgentAttr
{
    TDMCONFIGURATION    agentConfig;
    TDMCAPABILITIES     agentCaps;
} CLOCKINGAGENTATTR, *LPCLOCKINGAGENTATTR;

typedef struct _tagMOAttributes
{
    AUID        objectId;
    std::string name;
    DLGTYPE     type;
    std::string locationDescription;
    DLGSTATUS   opStatus;
    DLGSTATUS   adStatus;
} MOATTRIBUTES, *LPMOATTRIBUTES;

// Board attributes
typedef struct _tagBoardAttr
{
    MOATTRIBUTES            objectAttr;
    INSTALLATIONATTRIBUTES  boardInstAttr;

} BOARDATTRIBUTES, *LPBOARDATTRIBUTES;

typedef struct _tagDM3ClusterAttributes
{
    long    structVersion;
    long    clusterConfiguration;
    long    configClusters;
    long    assignXmitSlotCmplt;
    long    numConfigs;
    long    curConfig;
} DM3CLUSTERATTRIBUTES, *LPDM3CLUSTERATTRIBUTES;

//dm3 structures
typedef struct _tagDM3BoardAttr
{
    BOARDATTRIBUTES             attr;
    DM3ATTRIBUTES               dm3attr;
    DM3CLUSTERATTRIBUTES	    clusterAttr;
    DM3NETWORKATTRIBUTES	    networkAttr;
    DM3PHYSICALATTRIBUTES	    physicalAttr;
    DM3NTDRIVERATTRIBUTES	    ntDriverAttr;
    DM3UNIXDRIVERATTRIBUTES     unixDriverAttr;
    DM3VERSIONATTRIBUTES        versionAttr;
} DM3BOARDATTRIBUTES, *LPDM3BOARDATTRIBUTES;

//pmac structures
typedef struct _tagDlgPMACAttrs
{
    BOARDATTRIBUTES	    attr;
    PMACATTRIBUTES      pmacAttr;
    PMACCONTEXTPROPS    pmacContext;
    PMACDTMFCONFIG      dtmfConfig;
    PMACCALLDEFAULTS    callDefaults;
    PMACVERSIONPROPS    versionProps;
    PMACNETWORKPROPS    networkProps;
} PMACBOARDATTRIBUTES, *LPPMACBOARDATTRIBUTES;

typedef struct _tagRozettaBoardAttr
{
    DM3BOARDATTRIBUTES          attr;
    WEREWOLFATTRIBUTES          werewolfAttr;
    ROZETTAKERNELBOARDCONFIG    kernelAttr;
} ROZETTABOARDATTRIBUTES, *LPROZETTABOARDATTRIBUTES;

typedef struct _tagFeatureRequest
{
	std::string	name;
    short count;
	short type; 
} FEATURE_REQUEST, *LPFEATURE_REQUEST;

typedef std::list<FEATURE_REQUEST> FEATURE_REQUEST_LIST;
typedef FEATURE_REQUEST_LIST::iterator FEATURE_REQUEST_LIST_ITER;

#endif
