/****************************************************************************
*              Copyright (c) 1997 Dialogic Corp.
*              All Rights Reserved.
*
*              THIS IS UNPUBLISHED PROPRIETARY SOURCE CODE OF Dialogic Corp.
*              The copyright notice above does not evidence any actual or
*              intended publication of such source code.
****************************************************************************/

/****************************************************************************
* FILE:    dm3isdncmd.h
* $Author: low $
* $Revision: 1.2 $
*
* DESCRIPTION: IE Library Macro Definitions.
*
****************************************************************************/

#ifndef _ISDNCMD
#define _ISDNCMD

#ifndef IGNORE_SIGNAL
#define IGNORE_SIGNAL 0xFF
#endif

/* Misc. IE parsing defines */
#define IE_LEN_OFFSET          1
#define IE_DATA_START          2
#define IE_HEADER_LEN          2
#define IE_EXT_BIT_MASK        0x80
#define IE_EXTNED_LEN_LEN      2
#define SINGLE_OCTET_IE_LENGTH 1

#define PRIMARY_OCTET          0
#define SUB_OCTET_A            1
#define SUB_OCTET_B            2
#define SUB_OCTET_C            3
#define SUB_OCTET_D            4
#define MAX_NUM_SUB_OCTETS     5


/* Facilities specific parsing defines */
#define FAC_MIN_COMP_LENGTH      0x02
#define FAC_MIN_TOTAL_LENGTH     0x06
#define FAC_MIN_INVOKE_TAG_LEN   0x01
#define FAC_MIN_OPP_LENGTH       0x03
#define FAC_MIN_ELEMENT_LEN      0x02

/* Facilities service discriminator values */
#define FAC_SUPPLEMENTARY_SERVICES  0x11
#define FAC_NETWORKING_EXTENSIONS   0x1F
#define FAC_SERVICE_DESC_MASK       0x1F

/* Facilities interpretation values */
#define FAC_INTERP_DISCARD_COMP     0x00
#define FAC_INTERP_CLEAR_COMP       0x01
#define FAC_INTERP_DISCARD_ALL      0x02

/* Facilities components values */
#define FAC_INVOKE               0xA1
#define FAC_RETURN_RESULT        0xA2
#define FAC_RETURN_ERROR         0xA3
#define FAC_REJECT               0xA4
#define FAC_NFE                  0xAA
#define FAC_INTERPERATION        0x8B
#define FAC_NETWORK_PROTO_PROF   0x92

/* Facilities invoke identifier values */
#define FAC_INVOKE_ID_TAG   0x02
#define FAC_NULL_ID_TAG     0x03

/* Facilities operation tag values */
#define FAC_OPERATION_INTEGER       0x02
#define FAC_OPERATION_OBJECT_ID     0x06
#define FAC_OPERATION_VALUE_UNKNOWN 0xFF

/* Facilities sequence tag value */
#define FAC_SEQUENCE_TAG            0x30

/* Facilities set tag value */
#define FAC_SETPARM_TAG             0x31

/* Facilities return error problem tag values */
#define GENERAL_PROBLEM_TAG         0x80
#define INVOKE_PROBLEM_TAG          0x81

/* Facilities Return Error Problem Values */
/*Facilities general problems values */
#define FAC_UNRECOGNIZED_COMPONENT     0x00
#define FAC_MISSEDTYPED_COMPONENT      0x01
#define FAC_BADLY_STRUCTERED_COMPONENT 0x02
/* Facilities invoke problems values */
#define FAC_DUPLICATE_INVACATION       0x00
#define FAC_UNRECOGNIZED_OPERATION     0x01
#define FAC_MISTYPED_ARGUMENT          0x02
/* Facilities return result problems values */
#define FAC_UNRECOGNIZED_INVOCATION    0x00
#define FAC_MISTYPED_RESULT            0x01
#define FAC_UNRECOGNIZED_ERROR         0x02
#define FAC_UNEXPECTED_ERROR           0x03
#define FAC_MISTYPED_PARAMETER         0x04


/* Bearer capability coding standard values */
#define BEARER_CODE_STD_CCITT       0x00
#define BEARER_CODE_STD_NATIONAL    0x02
#define BEARER_CODE_STD_NETWORK     0x03
#define BEARER_CODE_STD_MASK        0x03
#define BEARER_CODE_STD_SHIFT       0x05


/* Bearer capability information transfer capability values */
#define BEARER_INFO_XFER_CAP_SPEECH          0x00
#define BEARER_INFO_XFER_CAP_UNRESTRICTED    0x08
#define BEARER_INFO_XFER_CAP_RESTRICTED      0x09
#define BEARER_INFO_XFER_CAP_3KHZ            0x10
#define BEARER_INFO_XFER_CAP_7KHZ            0x11
#define BEARER_INFO_XFER_CAP_VIDEO           0x18
#define BEARER_INFO_XFER_CAP_SHIFT           0x00
#define BEARER_INFO_XFER_CAP_MASK            0x1F

/* number of Bearer capability information transfer capability table records */
#define MAX_BEAR_INFO_CAP_RECS               0x20
#define MAX_BEARER_RATE_TAB_RECS             0x20

/* Bearer capability information transfer mode values */
#define BEARER_INFO_XFER_MODE_CIRCUIT        0x00
#define BEARER_INFO_XFER_MODE_PACKET         0x02
#define BEARER_INFO_XFER_MODE_MASK           0x03
#define BEARER_INFO_XFER_MODE_SHIFT          0x05

/* Bearer capability information transfer rate values */
#define BEARER_INFO_XFER_RATE_UNDEFINED      0x00
#define BEARER_INFO_XFER_RATE_PACKET         0x00
#define BEARER_INFO_XFER_RATE_64KB           0x10
#define BEARER_INFO_XFER_RATE_128KB          0x11
#define BEARER_INFO_XFER_RATE_384KB          0x13
#define BEARER_INFO_XFER_RATE_1536KB         0x15
#define BEARER_INFO_XFER_RATE_1920KB         0x17
#define BEARER_INFO_XFER_RATE_MULTIRATE      0x18
#define BEARER_INFO_XFER_RATE_MASK           0x1F
#define BEARER_INFO_XFER_RATE_SHIFT          0x00

/* Bearer capability information transfer structure values */
#define BEARER_STRUCTURE_DEFAULT             0x00
#define BEARER_STRUCTURE_8KHZ                0x01
#define BEARER_STRUCTURE_UNIT_DATA           0x04
#define BEARER_STRUCTURE_UNSTRUCTURED        0x07
#define BEARER_STRUCTURE_MASK                0x07
#define BEARER_STRUCTURE_SHIFT               0x04

/* Bearer capability configuration values */
#define BEARER_CONFIG_POINT_TO_POINT         0x00
#define BEARER_CONFIG_POINT_TO_MULTIPOINT    0x01
#define BEARER_CONFIG_MASK                   0x03
#define BEARER_CONFIG_SHIFT                  0x02

/* Bearer capability establishment values */
#define BEARER_ESTABLISHMENT_DEMAND          0x00
#define BEARER_ESTABLISHMENT_NAILED_UP       0x01
#define BEARER_ESTABLISHMENT_MASK            0x03
#define BEARER_ESTABLISHMENT_SHIFT           0x00

/* Bearer capability connection symmetry values */
#define BEARER_SYMETRY_SYMETRICAL            0x00
#define BEARER_SYMETRY_ASYMETRICAL           0x01
#define BEARER_SYMETRY_MASK                  0x03
#define BEARER_SYMETRY_SHIFT                 0x05
#define BEARER_INFO_XFER_RATE_DEST_ORG_MASK  0x1F
#define BEARER_INFO_XFER_RATE_DEST_ORG_SHIFT 0x00

/* defines for bearer capability layer 1 protocol.    */
/* Note: In the case of multiRate channels this field */
/* will contain the 64 KB rate multiplier value.      */
#define BEARER_LAYER_1_PROTO_NOT_PRESENT          0x00
#define BEARER_LAYER_1_PROTO_CCITT                0x01
#define BEARER_LAYER_1_PROTO_G711_ULAW            0x02
#define BEARER_LAYER_1_PROTO_G711_ALAW            0x03
#define BEARER_LAYER_1_PROTO_G721_ADPCM           0x04
#define BEARER_LAYER_1_PROTO_G722_7KHZ            0x05
#define BEARER_LAYER_1_PROTO_384K_VIDEO           0x06
#define BEARER_LAYER_1_PROTO_NS_RATE_ADAPTION     0x07
#define BEARER_LAYER_1_PROTO_V120_RATE_ADAPTION   0x08
#define BEARER_LAYER_1_PROTO_X31_HDLC             0x09
#define BEARER_LAYER_1_PROTO_MASK                 0x1F
#define BEARER_LAYER_1_PROTO_SHIFT                0x00

/*
 *    Bearer Capability Element Alternate Layer 1 Defines
 *    for backward IE message library compatibility.
 *    These macros are depreciated. Do Not Use.
 */
#define ISDN_UIL1_CCITTV110      0x01  /* user info layer 1 - CCITT V.110/X.3
                                          */
#define ISDN_UIL1_G711ULAW       0x02  /* user info layer 1 - G.711 u-law */
#define ISDN_UIL1_G711ALAW       0x03  /* user info layer 1 - G.711 A-law */
#define ISDN_UIL1_G721ADCPM      0x04  /* user info layer 1 - G.721 ADCPM */
#define ISDN_UIL1_G722F725       0x05  /* user info layer 1 - G.722 and G.725
                                          */
#define ISDN_UIL1_H261           0x06  /* user info layer 1 - H.261 */
#define ISDN_UIL1_NONCCITT       0x07  /* user info layer 1 - non-CCITT */
#define ISDN_UIL1_CCITTV120      0x08  /* user info layer 1 - CCITT V.120 */
#define ISDN_UIL1_CCITTX31       0x09  /* user info layer 1 - CCITT X.31 */
#define ISDN_UIL1_DEFAULT        0xFF  /* user info layer 1 - Default Value */

/* Bearer capability async_sync for rate adaption values */
#define BEARER_ASYNC_SYNC_SYNCHRONOUS             0x00
#define BEARER_ASYNC_SYNC_ASYNCHRONOUS            0x01
#define BEARER_ASYNC_SYNC_MASK                    0x01
#define BEARER_ASYNC_SYNC_SHIFT                   0x06

/* Bearer capability inband negotiation for rate adaption values */
#define BEARER_INBAND_NEGOTIATION_NOT_POSSIBLE    0x00
#define BEARER_INBAND_NEGOTIATION_POSSIBLE        0x01
#define BEARER_INBAND_MASK                        0x01
#define BEARER_INBAND_SHIFT                       0x05
#define BEARER_USER_RATE_SHIFT                    0x00
#define BEARER_USER_RATE_MASK                     0x1F

/* Bearer capability user rate for rate adaption V.120 values */
#define BEARER_V120_UR_EINI460      0x00  /* user rate - E bits in I.460 */
#define BEARER_V120_UR_600          0x01  /* user rate - 0.6 kbits */
#define BEARER_V120_UR_1200         0x02  /* user rate - 1.2 kbits */
#define BEARER_V120_UR_2400         0x03  /* user rate - 2.4 kbits */
#define BEARER_V120_UR_3600         0x04  /* user rate - 3.6 kbits */
#define BEARER_V120_UR_4800         0x05  /* user rate - 4.8 kbits */
#define BEARER_V120_UR_7200         0x06  /* user rate - 7.2 kbits */
#define BEARER_V120_UR_8000         0x07  /* user rate - 8.0 kbits */
#define BEARER_V120_UR_9600         0x08  /* user rate - 9.6 kbits */
#define BEARER_V120_UR_14400        0x09  /* user rate - 14.4 kbits */
#define BEARER_V120_UR_16000        0x0A  /* user rate - 16.0 kbits */
#define BEARER_V120_UR_19200        0x0B  /* user rate - 19.2 kbits */
#define BEARER_V120_UR_32000        0x0C  /* user rate - 32 kbits */
#define BEARER_V120_UR_48000        0x0E  /* user rate - 48 kbits */
#define BEARER_V120_UR_56000        0x0F  /* user rate - 56 kbits */
#define BEARER_V120_UR_64000        0x10  /* user rate - 64 kbits */
#define BEARER_V120_UR_134          0x15  /* user rate - .1345 kbits */
#define BEARER_V120_UR_100          0x16  /* user rate - .100 kbits */
#define BEARER_V120_UR_75_1200      0x17  /* user rate - .075/1200 kbits */
#define BEARER_V120_UR_1200_75      0x18  /* user rate - 1200/.075 kbits */
#define BEARER_V120_UR_50           0x19  /* user rate - .050 kbits */
#define BEARER_V120_UR_75           0x1A  /* user rate - .075 kbits */
#define BEARER_V120_UR_110          0x1B  /* user rate - .110 kbits */
#define BEARER_V120_UR_150          0x1C  /* user rate - .150 kbits */
#define BEARER_V120_UR_200          0x1D  /* user rate - .200 kbits */
#define BEARER_V120_UR_300          0x1E  /* user rate - .300 kbits */
#define BEARER_V120_UR_12000        0x1F  /* user rate - 12 kbits */
#define BEARER_V120_UR_DEFAULT      0xFF  /* user rate - Default */

/* Bearer capability layer 2 protocol values */
#define BEARER_LAYER_2_PROTO_NOT_PRESENT          0x00
#define BEARER_LAYER_2_PROTO_Q921                 0x02
#define BEARER_LAYER_2_PROTO_X25                  0x06
#define BEARER_LAYER_2_PROTO_MASK                 0x1F
#define BEARER_LAYER_2_PROTO_SHIFT                0x00

/* Bearer capability layer 3 protocol values */
#define BEARER_LAYER_3_PROTO_NOT_PRESENT          0x00
#define BEARER_LAYER_3_PROTO_Q931                 0x02
#define BEARER_LAYER_3_PROTO_X25                  0x06
#define BEARER_LAYER_3_PROTO_MASK                 0x1F
#define BEARER_LAYER_3_PROTO_SHIFT                0x00


/* Number plan and type lookup table sizes */
#define MAX_NB_PLAN_TAB_RECS        16
#define MAX_NB_TYPE_TAB_RECS        8

/* Number type values */
#define NB_TYPE_UNKNOWN             0x00
#define NB_TYPE_INTERNATIONAL       0x01
#define NB_TYPE_NATIONAL            0x02
#define NB_TYPE_NETWORK_SPECIFIC    0x03
#define NB_TYPE_NETWORK_SUBSCRIBER  0x04
#define NB_TYPE_NETWORK_ABBREVIATED 0x06

/* Number plan values */
#define NB_PLAN_UNKNOWN          0x00
#define NB_PLAN_ISDN             0x01
#define NB_PLAN_TELEPHONY        0x02
#define NB_PLAN_DATA_X121        0x03
#define NB_PLAN_TELEX_F69        0x04
#define NB_PLAN_NATIONAL_STD     0x08
#define NB_PLAN_PRIVATE          0x09

/* Presentation Indicator lookup table sizes */
#define MAX_PRESENTATION_IND_TAB_RECS  4
#define MAX_SCREENING_IND_TAB_RECS     4

/*Number presentation indicator values */
#define NB_PRESENTATION_ALLOWED       0x00
#define NB_PRESENTATION_RESTRICTED    0x01
#define NB_PRESENTATION_NOT_AVAILABLE 0x02

/* Number screening indicator values */
#define NB_SCREENING_USER_PROVIDED      0x00
#define NB_SCREENING_VERIFIED_N_PASSED  0x01
#define NB_SCREENING_VERIFIED_N_FAILED  0x02
#define NB_SCREENING_NETWORK_PROVIDED   0x03

/* Cause lookup table size */
#define MAX_CAUSE_TAB_RECS 128

/* Cause values */
#define CAUSE_UNASSIGNED_NUMBER        0x01  /* Cause 01 */
#define CAUSE_NO_ROUTE_TO_TRAN_NET     0x02  /* Cause 02 */
#define CAUSE_NO_ROUTE_TO_DEST         0x03  /* Cause 03 */
#define CAUSE_SEND_SPECIAL_ITONE       0x04  /* Cause 04 */
#define CAUSE_MISDIALLED_TRUNK_PFX     0x05  /* Cause 05 */
#define CAUSE_CHANNEL_UNACCEPTABLE     0x06  /* Cause 06 */
#define CAUSE_CALL_AWARDED_IN_EST_CHAN 0x07  /* Cause 07 */
#define CAUSE_PREEMPTION               0x08  /* Cause 08 */
#define CAUSE_PREEMPTION_CHAN_RESERVED 0x09  /* Cause 09 */
#define CAUSE_NORMAL_CLEARING          0x10  /* Cause 16 */
#define CAUSE_USER_BUSY                0x11  /* Cause 17 */
#define CAUSE_NO_USER_RESPONDING       0x12  /* Cause 18 */
#define CAUSE_NO_ANSWER_FROM_USER      0x13  /* Cause 19 */
#define CAUSE_SUBSCRIBER_ABBSENT       0x14  /* Cause 20 */
#define CAUSE_CALL_REJECTED            0x15  /* Cause 21 */
#define CAUSE_NUMBER_CHANGED           0x16  /* Cause 22 */
#define CAUSE_NON_SELECTED_USR_CLEAR   0x1A  /* Cause 26 */
#define CAUSE_DEST_OUT_OF_ORDER        0x1B  /* Cause 27 */
#define CAUSE_INVALID_NUMBER_FORMAT    0x1C  /* Cause 28 */
#define CAUSE_FACILITY_REJECTED        0x1D  /* Cause 29 */
#define CAUSE_RESP_TO_STAT_ENQ         0x1E  /* Cause 30 */
#define CAUSE_UNSPECIFIED_CAUSE        0x1F  /* Cause 31 */
#define CAUSE_NO_CIRCUIT_AVAILABLE     0x22  /* Cause 34 */
#define CAUSE_NETWORK_OUT_OF_ORDER     0x26  /* Cause 38 */
#define CAUSE_PFM_CONN_OUT_OF_SERVICE  0x27  /* Cause 39 */
#define CAUSE_PFM_CONN_OPPERATIONAL    0x28  /* Cause 40 */
#define CAUSE_TEMPORARY_FAILURE        0x29  /* Cause 41 */
#define CAUSE_NETWORK_CONGESTION       0x2A  /* Cause 42 */
#define CAUSE_ACCESS_INFO_DISCARDED    0x2B  /* Cause 43 */
#define CAUSE_REQ_CHANNEL_NOT_AVAIL    0x2C  /* Cause 44 */
#define CAUSE_PRE_EMPTED               0x2D  /* Cause 45 */
#define CAUSE_CALL_BLOCKED             0x2E  /* Cause 46 */
#define CAUSE_RESOURCE_UNAVAILABLE     0x2F  /* Cause 47 */
#define CAUSE_QOS_UNAVAILABLE          0x31  /* Cause 49 */
#define CAUSE_FACILITY_NOT_SUBSCRIBED  0x32  /* Cause 50 */
#define CAUSE_BEARER_INCOMPAT_SERVICE  0x33  /* Cause 51 */
#define CAUSE_OUTGOING_CALL_BARRED     0x34  /* Cause 52 */
#define CAUSE_OUTGOING_BARRED_IN_CUG   0x37  /* Cause 53 */ 
#define CAUSE_SERVICE_OPP_VIOLATED     0x35  /* Cause 53 */
#define CAUSE_INCOMING_CALL_BARRED     0x36  /* Cause 54 */
#define CAUSE_INCOMMING_BARRED_IN_CUG  0x37  /* Cause 55 */ 
#define CAUSE_BEAR_CAP_NOT_AUTHL       0x39  /* Cause 57 */
#define CAUSE_BEAR_CAP_NOT_AVAIL       0x3A  /* Cause 58 */
#define CAUSE_INCOSISTANT_OUTB_INFO    0x3E  /* Cause 62 */
#define CAUSE_SERVICE_NOT_AVAIL        0x3F  /* Cause 63 */
#define CAUSE_CAP_NOT_IMPLEMENTED      0x41  /* Cause 65 */
#define CAUSE_CHAN_NOT_IMPLEMENTED     0x42  /* Cause 66 */
#define CAUSE_FACILITY_NOT_IMPLEMENT   0x45  /* Cause 69 */
#define CAUSE_RESTRICED_DIG_INFO_ONLY  0x46  /* Cause 70 */
#define CAUSE_SERVICE_NOT_IMPLEMENTED  0x4F  /* Cause 79 */
#define CAUSE_INVALID_CALL_REF         0x51  /* Cause 81 */
#define CAUSE_CHAN_DOES_NOT_EXIST      0x52  /* Cause 82 */
#define CAUSE_BAD_CALL_ID_FOR_SUS_CALL 0x53  /* Cause 83 */
#define CAUSE_CALL_ID_NOT_IN_USE       0x54  /* Cause 84 */
#define CAUSE_NO_SUSPENDED_CALL        0x55  /* Cause 85 */
#define CAUSE_CALL_ID_CLEARED          0x56  /* Cause 86 */
#define CAUSE_NOT_MEMBER_OF_CUG        0x57  /* Cause 87 */
#define CAUSE_INCOMPATIBLE_DEST        0x58  /* Cause 88 */
#define CAUSE_DEST_ADDR_MISSING        0x5A  /* Cause 90 */
#define CAUSE_INVALID_TRANS_NETWORK    0x5B  /* Cause 91 */
#define CAUSE_INVALID_MSG_UNSPEC       0x5F  /* Cause 95 */
#define CAUSE_MANDATORY_IE_MISSING     0x60  /* Cause 96 */
#define CAUSE_NONEXISTENT_MSG          0x61  /* Cause 97 */
#define CAUSE_WRONG_MESSAGE            0x62  /* Cause 98 */
#define CAUSE_BAD_INFO_ELEM            0x63  /* Cause 99 */
#define CAUSE_INVALID_ELEM_CONTENTS    0x64  /* Cause 100 */
#define CAUSE_WRONG_MSG_FOR_STATE      0x65  /* Cause 101 */
#define CAUSE_TIMER_EXPIRY             0x66  /* Cause 102 */
#define CAUSE_MANDATORY_IE_LEN_ERR     0x67  /* Cause 103 */
#define CAUSE_MSG_W_UNRECOGNIZED_PARAM 0x6E  /* Cause 110 */
#define CAUSE_PROTOCOL_ERROR           0x6F  /* Cause 111 */
#define CAUSE_INTERWORKING_UNSPEC      0x7F  /* Cause 127 */

/* Cause location values */
#define CAUSE_LOCATION_USER                   0x00
#define CAUSE_LOCATION_PRIVATE_NETWORK_LOCAL  0x01
#define CAUSE_LOCATION_PUBLIC_NETWORK_LOCAL   0x02
#define CAUSE_LOCATION_TRANSIT_NETWORK        0x03
#define CAUSE_LOCATION_PRIVATE_NETWORK_REMOTE 0x04
#define CAUSE_LOCATION_PUBLIC_NETWORK_REMOTE  0x05
#define CAUSE_LOCATION_INTERNATIONAL          0x07
#define CAUSE_LOCATION_BEYOND_INTERWORKING    0x0A

/* Cause coding standard values */
#define CAUSE_CODE_STD_CCITT       0x00
#define CAUSE_CODE_STD_NATIONAL    0x02
#define CAUSE_CODE_STD_NETWORK     0x03


/* Keypad Facility - Max number of IA5 characters */
#define MAX_KEYPAD_FACILITY_IE_LENGTH  34


/* Display - Max number of IA5 characters  */
#define MAX_DISPLAY_IE_LENGTH  34

#endif
