#ifndef  _DTMF_H__
#define  _DTMF_H__
/****************************************************************************
 *		Copyright (c) 1995 Dialogic Corp.
 *		All Rights Reserved.
 *
 *		THIS IS UNPUBLISHED PROPRIETARY SOURCE CODE OF Dialogic Corp.
 *		The copyright notice above does not evidence any actual or
 *		intended publication of such source code.
 ***************************************************************************/

/****************************************************************************
 * FILE:         
 * AUTHOR:       Chris Chuba
 * ORG:          Dialogic Corporation
 * ORIG-DATE:    27-Mar-96 at 15:01:00
 * LAST-MOD:     26-Jun-97 at 08:32:24 by Chris Chuba  
 * PURPOSE:
 *    This module facilitates the creation of all the siganl ID's for the 
 *    DTMF digits.
 *    
 * HISTORY:
 * Date        Who   Description
 * 3-29-96     CC    Initial createion.
 ***************************************************************************/
#include <sdsignal.h>

/*
 * This is the ID portion of all the DTMF sets.
 */
enum {
   ID_DTMF1=1,
   ID_DTMF2,
   ID_DTMF3,
   ID_DTMF4,
   ID_DTMF5,
   ID_DTMF6,
   ID_DTMF7,
   ID_DTMF8,
   ID_DTMF9,
   ID_DTMF0,
   ID_DTMFA,
   ID_DTMFB,
   ID_DTMFC,
   ID_DTMFD,
   ID_DTMFNUM,
   ID_DTMFSTAR,
   ID_PAUSE,
   ID_PAUSE2
};


/*
 * This macro allows for creation of the DTMF signal ID's for all countries
 * using the ISO two letter country code.
 * CreateDtmfSet(US, 'U', 'S') will create ...
 * US_DTMF_SET, US_DTMF1, US_DTMF2 ...
 */
#define  CreateDtmfSet(PREFIX,LETTER1,LETTER2) \
enum { \
 PREFIX##_DTMF_SET =CreateCountrySet(SD_DTMF_START,LETTER1, LETTER2), \
   PREFIX##_DTMF1 = CreateCountrySet(SD_DTMF_START,LETTER1, LETTER2) \
                     + ID_DTMF1, \
   PREFIX##_DTMF2 = CreateCountrySet(SD_DTMF_START,LETTER1, LETTER2) \
                     + ID_DTMF2, \
   PREFIX##_DTMF3 = CreateCountrySet(SD_DTMF_START,LETTER1, LETTER2) \
                     + ID_DTMF3, \
   PREFIX##_DTMF4 = CreateCountrySet(SD_DTMF_START,LETTER1, LETTER2) \
                     + ID_DTMF4, \
   PREFIX##_DTMF5 = CreateCountrySet(SD_DTMF_START,LETTER1, LETTER2) \
                     + ID_DTMF5, \
   PREFIX##_DTMF6 = CreateCountrySet(SD_DTMF_START,LETTER1, LETTER2) \
                     + ID_DTMF6, \
   PREFIX##_DTMF7 = CreateCountrySet(SD_DTMF_START,LETTER1, LETTER2) \
                     + ID_DTMF7, \
   PREFIX##_DTMF8 = CreateCountrySet(SD_DTMF_START,LETTER1, LETTER2) \
                     + ID_DTMF8, \
   PREFIX##_DTMF9 = CreateCountrySet(SD_DTMF_START,LETTER1, LETTER2) \
                     + ID_DTMF9, \
   PREFIX##_DTMF0 = CreateCountrySet(SD_DTMF_START,LETTER1, LETTER2) \
                     + ID_DTMF0, \
   PREFIX##_DTMFA = CreateCountrySet(SD_DTMF_START,LETTER1, LETTER2) \
                     + ID_DTMFA, \
   PREFIX##_DTMFB = CreateCountrySet(SD_DTMF_START,LETTER1, LETTER2) \
                     + ID_DTMFB, \
   PREFIX##_DTMFC = CreateCountrySet(SD_DTMF_START,LETTER1, LETTER2) \
                     + ID_DTMFC, \
   PREFIX##_DTMFD = CreateCountrySet(SD_DTMF_START,LETTER1, LETTER2) \
                     + ID_DTMFD, \
   PREFIX##_DTMFNUM = CreateCountrySet(SD_DTMF_START,LETTER1, LETTER2) \
                     + ID_DTMFNUM, \
   PREFIX##_DTMFSTAR = CreateCountrySet(SD_DTMF_START,LETTER1, LETTER2) \
                     + ID_DTMFSTAR, \
   PREFIX##_PAUSE = CreateCountrySet(SD_DTMF_START,LETTER1, LETTER2) \
          + ID_PAUSE, \
   PREFIX##_PAUSE2 = CreateCountrySet(SD_DTMF_START,LETTER1, LETTER2) \
          + ID_PAUSE2 \
};

/*
 * This creates all the defines for the U.S. DTMF digits.
 */
CreateDtmfSet(US,'U','S')

/*
 * The following defines make the U.S. DTMF set the default.
 */
#define DTMF_SET US_DTMF_SET  /* Used for set operations */

#define DTMF1  US_DTMF1
#define DTMF2  US_DTMF2
#define DTMF3  US_DTMF3
#define DTMF4  US_DTMF4
#define DTMF5  US_DTMF5
#define DTMF6  US_DTMF6
#define DTMF7  US_DTMF7
#define DTMF8  US_DTMF8
#define DTMF9  US_DTMF9
#define DTMF0  US_DTMF0
#define DTMFA  US_DTMFA
#define DTMFB  US_DTMFB
#define DTMFC  US_DTMFC
#define DTMFD  US_DTMFD
#define DTMFNUM  US_DTMFNUM
#define DTMFSTAR  US_DTMFSTAR
#define PAUSE  US_PAUSE    /* A timed wait during dialing */
#define PAUSE2 US_PAUSE2   /* A 1 second pause added for Digital sound */

#endif




