/*
*!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!
*
*                  ====  COPYRIGHT NOTICE ====
*
*        File:   FAX_MDM.H
*	 Version 2.9, February 1997.
*
*        Copyright (C) ILLICO 1995,1996,1997.
*	 All Rights Reserved
*
*
*           This file is "ILLICO Materials" as defined in Paragraph 1.2
*	of the Source License Agreement (SLA) between ILLICO and GAMMALINK
*	dated December 16, 1994 and is ILLICO property per Paragraph 2.3 of 
*	the SLA. This file is ILLICO "Confidential Information" as described
*	in Paragraph 1.9 of the SLA.
*
*!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!
*/

/*----------------------------------------------------------------------*/
/* FAX MODEM CONTROL STRUCTURE						*/
/*----------------------------------------------------------------------*/
typedef struct fax_modem_control
  {
  /*----------------------------*/
  /* General			*/
  /*----------------------------*/
  union MOD_CONFIG_UNION
  {
  struct MOD_CONFIG_STRUCT
    {
    unsigned int MOD_MODE:4;	/* bit 0-3 */
    unsigned int MOD_TRAIN:1;	/* bit 4 */
    unsigned int spare:8;	/* bit 5-12 */
    unsigned int MOD_EYE:1;	/* bit 13 */
    unsigned int MOD_TX:1;	/* bit 14 */
    unsigned int MOD_SETUP:1;	/* bit 15 */
    } mdcfg_bits;
  int mdcfg;
  } mod_config;

  int *mod_ext;
  int *mod_rx_x;
  int *mod_rx_y;
  int mod_nsamp;
  int mod_state;
  int *mod_eye_ptr;
  int mod_eye_nbr;

  /*----------------------------*/
  /* Receiver only		*/
  /*----------------------------*/
  union RX_CONFIG_UNION
  {
  struct RX_CONFIG_STRUCT
    {
    unsigned int RX_ON_LEVEL:3;	/* bit 0-2 */
    unsigned int RX_TAPS:1;	/* bit 3 */
    unsigned int RX_HDLC:1;	/* bit 4 */
    unsigned int RX_CLOCK:2;	/* bit 5-6 */
    unsigned int RX_FORMAT:1;	/* bit 7 */
    unsigned int RX_END:1;	/* bit 8 */
    } rxcfg_bits;
  int rxcfg;
  } rx_config;

  int rx_mse_coef;

  union RX_CONTROL_UNION
  {
  struct RX_CONTROL_STRUCT
    {
    unsigned int RX_FREEZE:1;	/* bit 0 */
    } rxctl_bits;
  int rxctl;
  } rx_control;

  union RX_STATUS_UNION
  {
  struct RX_STATUS_STRUCT
    {
    unsigned int RX_FROZEN:1;	/* bit 0 */
    unsigned int RX_EPT:1;	/* bit 1 */
    unsigned int RX_V21:1;	/* bit 2 */
    unsigned int RX_TRN:1;	/* bit 3 */
    unsigned int RX_DAT:1;	/* bit 4 */
    unsigned int RX_CDET:1;	/* bit 5 */
    unsigned int RX_STEP:1;	/* bit 6 */
    unsigned int RX_FLAG:1;	/* bit 7 */
    } rxst_bits;
  int rxst;
  } rx_status;

  int rx_power;
  int rx_mse;
  int *rx_inptr;
  int rx_ndat;
  int *rx_bdptr;
  int *rx_bdbuf_start;
  int *rx_bdbuf_end;

  /*----------------------------*/
  /* Transmitter only		*/
  /*----------------------------*/
  union TX_CONFIG_UNION
  {
  struct TX_CONFIG_STRUCT
    {
    unsigned int TX_CEQ:3;		/* bit 0-2 */
    unsigned int TX_FORMAT:1;		/* bit 3 */
    unsigned int TX_EPT:1;		/* bit 4 */
    unsigned int TX_EPT_SIL:1;		/* bit 5 */
    unsigned int TX_HDLC:1;		/* bit 6 */
    unsigned int TX_TONE:1;		/* bit 7 */
    unsigned int TX_V21_START_MARK:8;	/* bit 8-15 */
    unsigned int TX_END_MARK:8;		/* bit 16-23 */
    } txcfg_bits;
  int txcfg;
  } tx_config;

  int tx_freq;
  int tx_gain;
  int *tx_ceq_ptr;

  union TX_CONTROL_UNION
  {
  struct TX_CONTROL_STRUCT
    {
    unsigned int TX_RTS:1;	/* bit 0 */
    } txctl_bits;
  int txctl;
  } tx_control;

  union TX_STATUS_UNION
  {
  struct TX_STATUS_STRUCT
    {
    unsigned int TX_CTS:1;	/* bit 0 */
    unsigned int TX_REAL_CTS:1;	/* bit 1 */
    unsigned int TX_UNDERRUN:1;	/* bit 2 */
    } txst_bits;
  int txst;
  } tx_status;

  int *tx_bdptr;
  int tx_ndat;
  int *tx_outptr;
  int *tx_bdbuf_start;
  int *tx_bdbuf_end;
  int *com_ptr;
  } FaxModemCntl_t;

/*----------------------------------------------------------------------*/
/* DEFINITIONS								*/
/*----------------------------------------------------------------------*/
#define  CONTEXT_SWAP          1     /* used in fmcimain.c fmcmdm.c and fmcstate.c */
#define MAX_PCM_LEN		128	/* max number of samples per block */
#define	MOD_RX_X_LENGTH		256	/* length of MOD_RX_X space */
#define	MOD_RX_Y_LENGTH		256	/* length of MOD_RX_Y space */
#define CTRL_STRUCT_LENGTH	sizeof(struct fax_modem_control)
#define MOD_LINT_LEN		168	/* length of MOD_INT space */
#define	COMMON_BUF_LEN		269	/* ICOEFF_BASE (240), COEFF_V29 (18),CLK_CO17 (11) */

#define	FAX_OK			0	/* normal return value of fax_modem() */
#define	FAX_MOD_MODE_ERR	1	/* fax_modem() error: unknown MOD_MODE */
#define	FAX_MOD_RX_EXT_ERR	2	/* fax_modem() error: MOD_RX_EXT alignment error */

#define	RX_DATA_STATE		10	/* Data mode of receiver */
#define	RX_IDLE_STATE		11	/* Idle state of receiver */
#define	TX_IDLE_STATE		9	/* Idle state of transmitter */

/*----------------------------------------------------------------------*/
/* FUNCTION PROTOTYPING							*/
/*----------------------------------------------------------------------*/

/* The second parameter is a dummy, requested by Nir Nice */
int fax_modem(struct fax_modem_control *chan, ...);
void FaxModemCopyTables(int temp);
