#ifndef _AS_G7231_H_
#define _AS_G7231_H_ 1
/****************************************************************************
*                              NOTICE
*  This source code contains proprietary and confidential information,
*  and is the property of the Dialogic Corporation.
*
*  This program has been distributed under license agreement and any
*  unauthorized use or distribution is prohibited.
*

*  Copyright 1997-2000 by Dialogic, An Intel Company. All rights reserved.
 ***************************************************************************/
/****************************************************************************
 * FILE:         AS_G7231.H
 * AUTHOR:
 * ORG:
 * ORIG-DATE:
 * LAST-MOD:	 2/10/00
 * PURPOSE:      Definitions and prototypes of G.723.1
 *
 * HISTORY:
 * Date       Who       Description
 *
 * 5/18/2001  Himanshu  G723.1 Integration
 ***************************************************************************/

/* Frame type definitions */
typedef enum
{
	SPEECH =	0,
	SID =	1,
	UNTRANS =	2,
} G723Frame_t;



/* Coder state structure. */
typedef struct
{
    Uint24     *pData;
    int        Size;
    int        DtxFlag;
    G723Frame_t  FrameState;
} G723STATE_t, *G723HANDLE_t;

/* PCM data samples frame structure. */
typedef struct
{
    int    Size;
    Int24  *pData;
    int	   SamplesRequested;
    int    SamplesProcessed;
} G723PCMFRAME_t;

/* Coded data frame structure. */
typedef struct
{
    int    Size;
    Uint24 *pData;
    int    ByteCount;
    int    FrameErasure;
    int    VadCng;
    int    Rate;
} G723DATAFRAME_t;

/* Frame info. structure */
typedef struct
{
    int FrameSize;
    int Sid;
    int Rate;
} G723FRAMEINFO_t;



/* ITU definitions for G.723.1 */
#define NUM_BYTES_63                    24
#define NUM_BYTES_53                    20
#define NUM_BYTES_SID                   4
#define NUM_BYTES_UNT                   1
#define FRAME_TYPE_MASK                 0x3

/* Definitions from Analogical */
/*#define AS_723_CODER_SIZE               1700 */ /* 2000 */
#define AS_723_ENCODER_SIZE		1080
#define AS_723_DECODER_SIZE		580

#define AS_723_RATE63           0
#define AS_723_RATE53           1
#define AS_723_RATESID          2

#define AS_723_PCM_FRAME_SIZE   240

#define G723_DTX	0
#define G723_SPEECH	0

#define G723_SAVE_LEN 4
#define G723_CODE_FRAME_SIZE NUM_BYTES_63
/*
 * Convert C interface naming convention to assembler convention

 * for those functions which do not have an intermediate functionaliy

 * in the translator.

*/

#define AS_G7231_CreateEncoder as_vG723CreateEncoder

#define AS_G7231_CreateDecoder as_vG723CreateDecoder

#define AS_G7231_Delete as_vG723Delete

#define AS_G7231_Init   as_vG723Init

#define AS_G7231_Encode as_vG723Encode


/* Function prototypes for using the translator and coder */


void AS_G7231_CreateEncoder(G723HANDLE_t);

void AS_G7231_CreateDecoder(G723HANDLE_t);

void AS_G7231_Delete(G723HANDLE_t);

int  AS_G7231_Encode(G723HANDLE_t, G723PCMFRAME_t *, G723DATAFRAME_t *);

int  AS_G7231_Decode(G723HANDLE_t, G723PCMFRAME_t *, G723DATAFRAME_t *);

void AS_G7231_Init(void);

int  AS_G7231_FrameInfo(G723DATAFRAME_t *, G723FRAMEINFO_t  *);

G723Frame_t AS_G7231_ClassifyFrame(G723DATAFRAME_t );



#endif

