/****************************************************************************
*              Copyright (c) 1997 Dialogic Corp.
*              All Rights Reserved.
*
*              THIS IS UNPUBLISHED PROPRIETARY SOURCE CODE OF Dialogic Corp.
*              The copyright notice above does not evidence any actual or
*              intended publication of such source code.
****************************************************************************/

/****************************************************************************
* FILE:    iefuncs.h
* $Author: sheap $
* $Revision: 1.91 $
*
* DESCRIPTION: IE Function prototypes.
*
****************************************************************************/

#ifndef _IEFUNCS_H
#define _IEFUNCS_H

/*** Ie message library data structures ***/

/*
 * Enumeration for the Switch Table used in the ie normalization  functions
 */

typedef enum
{
   NB_TYPE_TAB_INDEX,
   NB_PLAN_TAB_INDEX,
   CAUSE_TAB_INDEX,
   BEAR_INFO_CAP_TAB_INDEX,
   PRESENTATION_TAB_INDEX,
   SCREENING_TAB_INDEX,
   BEAR_RATE_INDEX,
   MAX_SW_TAB_ENTRY
}tSwTab;

/*
 *  This enumeration is used to index the
 *  Element[] of the tFAC_COMP_BODY data structure.
 */
typedef enum {
   OPERATION,
   SEQUENCE,
   SET_PARAM,
   PROBLEM,
   NUM_DATA_ELEMENTS
} tFAC_DATA_ELEMENT_ID ;

/*
 *  This structure is used to hold the Data Element of the
 *  facility ie body in expanded format.
 */
typedef struct
{
   BOOLEAN Present;
   BYTE    Tag;
   BYTE    Length;
   BYTE    *pData;
} tFAC_DATA_ELEMENT;

/*
 *  This structure is used to hold the header of the
 *  facility ie in expanded format.
 */
typedef struct {
   BYTE ServiceDesc;
   BYTE NetFacExt;
   BOOLEAN NetFacExtPresent;
   BYTE NetProtocolProf;
   BOOLEAN NetProtocolProfPresent;
   BYTE Interperation;
   BOOLEAN InterperationPresent;
}tFAC_NET_EXT;

/*
 *  This structure is used to hold the body of the
 *  facility ie in expanded format.
 */
typedef struct {
   BYTE              CompType;
   BYTE              InvokeTag;
   UINT32            InvokeId;
   tFAC_DATA_ELEMENT Element[NUM_DATA_ELEMENTS];
}tFAC_COMP_BODY;

/*
 *  This is the structure of the facility ie in expanded format.
 */
typedef struct {
 tFAC_NET_EXT   FacNetExt;
 tFAC_COMP_BODY FacComp;
}tFAC_IE;


/*
 * This structure holds the expanded bearer capability ie.
 */
typedef struct
{
   BYTE codingStd;         /*  Coding standard from octet 3          */
   BYTE infoXferCap;       /*  Info transfer capability from octet 3 */
   BYTE xferMode;          /*  Transfer mode from octet 4 Bits 7-6   */
   BYTE xferRate;          /*  Info transfer rate from octet 4 5-1   */
   BOOLEAN octet4aPresent; /*  Octet 4A is present    */
   BYTE structure;         /*  Bits 7-5 from octet 4a */
   BYTE configuration;     /*  Bits 4-3 from octet 4a */
   BYTE establishment;     /*  Bits 2-1 from octet 4a */
   BOOLEAN octet4bPresent; /*  Octet 4B is present    */
   BYTE symetry;           /*  Bits 7-6 from octet 4b */
   BYTE xferRateDesttoOrg; /*  Bits 5-1 from octet 4b */
   BYTE rateMultiplier;    /**** if multiRate (see xferRate field) the rateMultiplier ***/
                           /***  field will contain the 64KB rate multiplier value.   ***/
   BOOLEAN octet5Present;  /*  Octet 5 is present     */
   BYTE layer1Protocol;    /*  User info layer 1 proto from octet 5 Bits 5-1 */
   BOOLEAN octet5aPresent; /*  Octet 5A is present    */
   BYTE AyyncSync;         /*  Bits 7-7 from octet 5a */
   BYTE negot;             /*  Bits 6-6 from octet 5a */
   BYTE userRate;          /*  Bits 5-1 from octet 5a */
   BOOLEAN octet5bPresent; /*  Octet 5B is present    */
   BYTE octet5b;           /*  Bits 7-1 from octet 5b */
   BOOLEAN octet5cPresent; /*  Octet 5V is present    */
   BYTE octet5c;           /*  Bits 7-1 from octet 5c */
   BOOLEAN octet5dPresent; /*  Octet 5D is present    */
   BYTE octet5d;           /*  Bits 7-1 from octet 5d */
   BOOLEAN octet6Present;  /*  Octet 6 is present layer 2 Protocol */
   BYTE layer2Protocol;    /*  Bits 7-1 from octet 6  */
   BOOLEAN octet7Present;  /*   Octet 7 is present layer 3 Protocol */
   BYTE layer3Protocol;    /*  Bits 7-1 from octet 7  */
}tEXPANDED_BEARER_CAP_IE;

/*
 * This structure holds the expanded keypad facility ie.
 */
typedef struct
{
   BYTE numIA5_Chars;
   BYTE IA5_Data[MAX_KEYPAD_FACILITY_IE_LENGTH + 1];
}tEXPANDED_KEYPAD_FACILITY_IE;

/*
 * This structure holds the expanded keypad facility ie.
 */
typedef struct
{
   BYTE numIA5_Chars;
   BYTE IA5_Data[MAX_DISPLAY_IE_LENGTH + 1];
}tEXPANDED_DISPLAY_IE;



/*** Function Prototypes ***/

#if defined(PRI_DASS2) || defined(PRI_DPNSS)
int ds2_serviceIndicator(BYTE *, BYTE, BYTE *);

int ds2_selection(BYTE *, BYTE, BYTE *);

int ds2_indication(BYTE *, BYTE, BYTE *);

int ds2_channelID(BYTE*, BYTE, BYTE, BYTE);

int ds2_progressInd(BYTE *, BYTE);

int ds2_causeie(BYTE *, BYTE);

INT32 getDs2SelectionIE(BYTE *pIeData, BYTE ieLen,
			BYTE **ppDs2SelectionIE);
#endif

int sendingComplete(BYTE *);

int bearerCap(BYTE *, BYTE, BYTE, BYTE, BYTE, BYTE, BYTE, BYTE, BYTE,
              BYTE, BYTE, BYTE, BYTE, BYTE);

int channelID(BYTE *, BYTE, BOOLEAN, BYTE, BYTE, BYTE, BYTE, BYTE,
              BYTE, BYTE *, int, int);

int callingPartyNum(BYTE *,BYTE, BYTE, BYTE, BYTE, BYTE *, int);

int callingPartySubAddr(BYTE *, BYTE, BYTE, BYTE *, int);

int calledPartyNum(BYTE *, BYTE, BYTE, BYTE *, int);

int calledPartySubAddr(BYTE *, BYTE, BYTE, BYTE *, int);

int userUser(BYTE *, BYTE, BYTE *, int);

int netSpecFacility(BYTE *, BYTE, BYTE, BYTE, BYTE, BYTE, BYTE *, int);

int causeie(BYTE *, BYTE, BYTE, BYTE, BYTE *);

int signalie(BYTE *, BYTE);

int progressInd(BYTE *, BYTE, BYTE, BYTE);

int codesetShift(BYTE *, BYTE, BOOLEAN);

int display(BYTE *pMsg, BYTE *display, int  display_length);

int keypadFacility(BYTE *pMsg, BYTE *keypad, int  keypad_length);

void initFacilitiesIE(tFAC_IE *pFacIe);

INT32 getFacilitiesIE(BYTE *pIeData, UINT16 privateIeLen, UINT16 totalIeLen,
                      BYTE **ppFacilitiesIE, UINT32 *pLengthFacilitiesIE);

INT32 getFacNetworkExt(BYTE *pFacilities, tFAC_NET_EXT *pFacHeader);

INT32 getFacServiceComp(BYTE *pFacilities, tFAC_COMP_BODY *pFacComp, BYTE compNumber);

INT32 expandFacIe(BYTE *pFacilities, tFAC_IE *pFacIe);

INT32 buildFacilitiesIE(BYTE *pFacilities, UINT32 bufLen,
                        UINT32 *pLengthFacilitiesIE, tFAC_IE *pFacIe);

INT32 getBearerCapIE(BYTE *pIeData, UINT16 privateIeLen, UINT16 totalIeLen,
                        BYTE **ppBearerCapIE, UINT32 *pLengthBearerCapIE);

INT32 expandBearCapIe(BYTE *pBearCap, tEXPANDED_BEARER_CAP_IE *pBearCapIe);

INT32 setIsdnLibSwType(int dslId, int swVal);

INT32 getIsdnLibSwType(int dslId, UINT32 *pSwType);

void  setBoardType(int BrdType);

INT32 NormailizeNumberingPlanAndType(UINT32 dslId, BYTE *pNbPlan, BYTE *pNbType);

INT32 NormailizeCause(UINT32 dslId, BYTE *pCause);

INT32 getSendingCompleteIE(BYTE *pIeData, UINT16 privateIeLen, UINT16 totalIeLen,
                        BYTE **ppSendingCompleteIE, UINT32 *pLengthSendingComplete);

INT32 getKeypadFacilityIE(BYTE *pIeData, UINT16 privateIeLen, UINT16 totalIeLen,
                        BYTE **ppKeypadFacilityIE, UINT32 *pLengthKeypadFacility);

INT32 expandKeypadFacilityIe(BYTE *pKeypadFacility, tEXPANDED_KEYPAD_FACILITY_IE *pKeypadFacilityIe);

INT32 getDisplayIE(BYTE *pIeData, UINT16 privateIeLen, UINT16 totalIeLen,
                        BYTE **ppDisplayIE, UINT32 *pLengthDisplay);

INT32 expandDisplayIe(BYTE *pDisplay, tEXPANDED_DISPLAY_IE *pDisplayIe);

void IEError(char *what, BYTE value);

BYTE	DigitLen(char	*pDigits, unsigned char MaxLen);

INT32 NormailizeBearer(UINT32 dslId, BYTE *pBearCapInfo, BYTE *pBearXferRate);

INT32 NormalizePresentationIndAndScreen(UINT32 dslId, BYTE *pPresInd, BYTE *pScreen);

#endif
