#ifndef  _MF_H__
#define  _MF_H__
/****************************************************************************
 *		Copyright (c) 2004 Intel.
 *		All Rights Reserved.
 *
 *		THIS IS UNPUBLISHED PROPRIETARY SOURCE CODE OF Intel.
 *		The copyright notice above does not evidence any actual or
 *		intended publication of such source code.
 ***************************************************************************/

/****************************************************************************
 * FILE:         
 * AUTHOR:       Chris Chuba
 * ORG:          Dialogic Corporation
 * ORIG-DATE:    27-Mar-96 at 15:01:00
 * LAST-MOD:     17-Jan-04 by JPO  
 * PURPOSE:
 *    This module facilitates the creation of all the siganl ID's for the 
 *    R1 MF digits.
 *    
 * HISTORY:
 * Date        Who   Description
 * 17-Jan-04   JPO   Renamed mf.h to intc_mf.h due to name conflict under Linux.
 ***************************************************************************/
#include <sdsignal.h>
/*
 * The MF Signal's
 */
/*
 * This is the ID portion of all the DTMF sets.
 */
enum {
   ID_MF1=1,
   ID_MF2,
   ID_MF3,
   ID_MF4,
   ID_MF5,
   ID_MF6,
   ID_MF7,
   ID_MF8,
   ID_MF9,
   ID_MF0,
   ID_MF_KP,
   ID_MF_ST,
   ID_MF_STP,
   ID_MF_KP2,
   ID_MF_ST3P
};

/*
 * This macro allows for creation of the MF signal ID's for all countries
 * using the ISO two letter country code.
 * CreateMfSet(US, 'U', 'S') will create ...
 * US_MF_SET, US_MF1, US_MF2, etc ...
 */
#define  CreateMfSet(PREFIX,LETTER1,LETTER2) \
enum { \
 PREFIX##_MF_SET =CreateCountrySet(SD_MF_START,LETTER1, LETTER2), \
   PREFIX##_MF1 = CreateCountrySet(SD_MF_START,LETTER1, LETTER2) \
                     + ID_MF1, \
   PREFIX##_MF2 = CreateCountrySet(SD_MF_START,LETTER1, LETTER2) \
                     + ID_MF2, \
   PREFIX##_MF3 = CreateCountrySet(SD_MF_START,LETTER1, LETTER2) \
                     + ID_MF3, \
   PREFIX##_MF4 = CreateCountrySet(SD_MF_START,LETTER1, LETTER2) \
                     + ID_MF4, \
   PREFIX##_MF5 = CreateCountrySet(SD_MF_START,LETTER1, LETTER2) \
                     + ID_MF5, \
   PREFIX##_MF6 = CreateCountrySet(SD_MF_START,LETTER1, LETTER2) \
                     + ID_MF6, \
   PREFIX##_MF7 = CreateCountrySet(SD_MF_START,LETTER1, LETTER2) \
                     + ID_MF7, \
   PREFIX##_MF8 = CreateCountrySet(SD_MF_START,LETTER1, LETTER2) \
                     + ID_MF8, \
   PREFIX##_MF9 = CreateCountrySet(SD_MF_START,LETTER1, LETTER2) \
                     + ID_MF9, \
   PREFIX##_MF0 = CreateCountrySet(SD_MF_START,LETTER1, LETTER2) \
                     + ID_MF0, \
   PREFIX##_MF_KP = CreateCountrySet(SD_MF_START,LETTER1, LETTER2) \
                     + ID_MF_KP, \
   PREFIX##_MF_ST = CreateCountrySet(SD_MF_START,LETTER1, LETTER2) \
                     + ID_MF_ST, \
   PREFIX##_MF_STP = CreateCountrySet(SD_MF_START,LETTER1, LETTER2) \
                     + ID_MF_STP, \
   PREFIX##_MF_KP2 = CreateCountrySet(SD_MF_START,LETTER1, LETTER2) \
                     + ID_MF_KP2, \
   PREFIX##_MF_ST3P = CreateCountrySet(SD_MF_START,LETTER1, LETTER2) \
                     + ID_MF_ST3P \
};

CreateMfSet(XX,'X','X')

#define MF_SET XX_MF_SET  /* Used for set operations */
#define MF1  XX_MF1
#define MF2  XX_MF2
#define MF3  XX_MF3
#define MF4  XX_MF4
#define MF5  XX_MF5
#define MF6  XX_MF6
#define MF7  XX_MF7
#define MF8  XX_MF8
#define MF9  XX_MF9
#define MF0  XX_MF0
#define MFA  XX_MF_STP
#define MFB  XX_MF_KP2
#define MFC  XX_MF_ST3P
#define MFNUM  XX_MF_ST
#define MFSTAR  XX_MF_KP    /* Long Key Pulse */

#endif
