/*****************************************************************************
 * Copyright (c) 1990-2002 Intel Corporation
 * All Rights Reserved.  All names, products, and services mentioned herein
 * are the trademarks or registered trademarks of their respective organizations
 * and are the sole property of their respective owners
 **************************************************************************/

/*****************************************************************************
 * Filename:     isdncmd.h
 * DESCRIPTION : Header file for all ISDN network firmware shared ram interface.
 *
 * INTERFACE:                   
 *
 * Note:
 *
 * REVISION HISTORY:
 *
 *    DATE           NAME  DESCRIPTION
 *    8-Nov-1995     ?     Clean up
 *    27-Sep-1996    GC    Added CC_HOLD state
 *    20-Dec-1996    GC    Added CC_IDLE3,4,5 and CC_DISCONNECTED2,3
 *           1997    BT    Added DCHANCFG
 *       MAR-1998    DN    Added Term Initilialization.
 *       MAY-1998    DN    Synced the file with Host Library.
 *    7/02/01          Remove unnecessary comments and #if 0, adding Intel header
 ****************************************************************************/
#ifndef _ISDNCMD
#define _ISDNCMD

#include "isdnos.h"

#define CALLID_FLAG              0x80     /* CALL ID PRESENT INDICATOR */

/*
 * Call Control states
 */
#define CC_NULL                  0        /* call released */
#define CC_OFFERED               1        /* inbound call received */
#define CC_ACCEPTED              2        /* call accepted */
#define CC_CONNECTED             3        /* call connected */
#define CC_INITIATED             4        /* outbound call request */
#define CC_FAILED                5        /* not applicable */
#define CC_ALERTING              6        /* call alerted send or received */
#define CC_DISCONNECTED          7        /* disconnect initiated Network */
#define CC_IDLE                  8        /* disconnect initiated by Host */  
#define CC_HOLD                  13       /* call is on hold */


/*
 * Equates for messages TO ISDN firmware via shared ram interface. ISDN_
 */
                                          /* H - Host, B - Board */
#define ISDN_GETDEF              0xFF     /* H ->B get default value of 
                                             mandatory IE */
#define ISDN_SETDEF              0xFE     /* H<->B set default value of 
                                             mandatory IE */
#define ISDN_RETDEF              0xFD     /* H<- B return default value of 
                                             mandatory IE */
#define ISDN_GETMM               0xFC     /* H ->B get message mask */
#define ISDN_SETMM               0xFB     /* H<->B set message mask */
#define ISDN_RETMM               0xFA     /* H<- B return message mask */
#define ISDN_GETTSST             0xF9     /* H ->B get time slot status */
#define ISDN_RETTSST             0xF8     /* H<- B return time slot status */
#define ISDN_MAINTREQ            0xF7     /* H<->B change time slot maintenance
                                             state */
#define ISDN_MAINTREP            0xF6     /* H<- B report time slot maintenance
                                             state */
#define ISDN_UNBLOCK_TS          0xF5     /* H<->B putting DSL in normal
                                             operation state */
#define ISDN_BLOCK_TS            0xF4     /* H<->B putting DSL in Out of 
                                             Service state */    
#define ISDN_ERROR               0xF3     /* H<- B general error message */
#define ISDN_REQANI              0xF2     /* H ->B get ANI value */
#define ISDN_RETANI              0xF1     /* H<- B return ANI value */
#define ISDN_STATUS              0xF0     /* H<- B report D-channel status */
#define ISDN_TRACE               0xEF     /* H ->B enable trace collection */
#define ISDN_TRCINFO             0xEE     /* H<- B report trace info. */
#define ISDN_GETCALLST           0xED     /* H ->B get call state */
#define ISDN_RETCALLST           0xEC     /* H<- B return call state */
#define ISDN_SETBILLING          0xEB     /* H<->B vari-a-bill */
#define CALL_ALERT_ACK           0xEA     /* H<- B response for call alert
                                             message */
#define CALL_DEALLOC             0xE9     /* H ->B deallocate call info block 
                                             */
#define CALL_DEALLOC_ACK         0xE8     /* H<- B response for call dealloc
                                             message */
#define ISDN_CHINFST             0xE7     /* H<->B change interface status */
#define ISDN_GETPROT             0xE6     /* H ->B get protocol type */
#define ISDN_RETPROT             0xE5     /* H<- B return protocol type */
#define ISDN_SETMINDIG           0xE4     /* H<->B set minimal digit expect for
                                             called party number */
#define ISDN_MOREDIGIT           0xE3     /* H <->B get more digit for called 
                                             party number */
#define ISDN_ECHO                0xE2     /* H ->B echo driver's event as 
                                             requested */
#define CALL_TERM                0xE1     /* Fast Disconnect termination */
#define ISDN_RESTART             0xE0     /* H<->B restart the channel */
#define ISDN_GETL2ST             0xDF     /* H ->B get layer 2 state */
#define ISDN_RETL2ST             0xDE     /* H<- B return layer 2 state */
#define ISDN_GETFRAME            0xDD     /* H<- B get layer 2 access frame */
#define ISDN_SNDFRAME            0xDC     /* H ->B send layer 2 access frame */
#define ISDN_QUEUE_CLEAR	 0x3C     /* H <- B send HDLC Queue clear message  */
#define ISDN_QUEUE_WARNING	 0x3D     /* H <- B send HDLC Queue warning message */
#define ISDN_QUEUE_OVERFLOW	 0x3E     /* H <- B send HDLC Queue overflow message */
#define ISDN_CALL_REJECT         0x3F     /* H <- B Call has been rejected by the firmware */
#define ISDN_CALL_DIALING        0x40     /* H <- B This message will be sent to the host every time ISDN sends
                                             a CALL_OUTGOING to CC. */



#define CALL_HOLD                0xDB
#define CALL_HOLD_ACK            0xDA
#define CALL_HOLD_REJ            0xD9
#define CALL_RETRIEVE            0xD8
#define CALL_RET_ACK             0xD7
#define CALL_RET_REJ             0xD6
#define CALL_INTRUD              0xD5
#define CALL_DIVERT              0xD4
#define CALL_NSI                 0xD3
#define CALL_TRANSFER            0xD2
#define CALL_DIVERTED            0xD0
#define CALL_TRANSFERACK         0xCF
#define CALL_TRANSFERREJ         0xCE
#define CALL_TRANSIT             0xCD

/* 01/30/97 BRI Device Driver Interface    isdncmd.h */
#define ISDN_SHIFTUP8            0xCC     /* H ->B for debugging driver only */
#define ISDN_STRTDN              0xCB     /* H<->B start code execution */
#define ISDN_STOPBD              0xCA     /* H<->B stop board execution */

#define ISDN_GETFTR              0xC9     /* H<->B get feature list */
#define ISDN_GETGLOB             0xC8     /* H<->B read global parameter */
#define ISDN_SETGLOB             0xC7     /* H<->B set global parameter */
#define ISDN_BRDERR              0xC6     /* H<- B board level error message */
#define ISDN_TSERR               0xC5     /* H<- B timeslot level error message
*/
#define ISDN_SETID7F             0xC4     /* H<->B set idle to 7f */
#define ISDN_SETIDLE             0xC3     /* H<->B set idle pattern */
#define ISDN_SETIDFF             0xC2     /* H<->B set idle to ff */
#define ISDN_ASSIGNTTS           0xC1     /* H<->B assign local timeslog */
#define ISDN_RDASSIGNTTS         0xC0     /* H<->B read local timeslot assignment */
#define ISDN_UNASSIGNTTS         0xBF     /* H<->B unassign local timeslot */
#define ISDN_SETCLK              0xBE     /* H<->B set clock source */
#define ISDN_LISTEN              0xBD     /* H<->B listen to SCbus timeslot */
#define ISDN_UNLISTEN            0xBC     /* H<->B stop listening to SCbus */
#define ISDN_COMTST              0xBB     /* H<->B communication test to board */
#define ISDN_DATTST              0xBA     /* H<->B perform data test */
#define ISDN_GETBDST             0xB9     /* H<->B get board status */
#define ISDN_RDRAM               0xB8     /* H<->B read from ram */
#define ISDN_WRTRAM              0xB7     /* H<->B write to ram */
#define ISDN_GETDNIN             0xB6     /* H<->B get download information */
#define ISDN_GETDEVINFO          0xB5     /* H<->B get device info */

/* 01/30/97 BRI Device Driver Interface  */
#define ISDN_SETDCHANCFG         0xB4     /* H<->B config & activate D channel,
                                                   response to configuration */
#define ISDN_TERMREG             0xB3     /* B->H  Terminal registration events */
#define ISDN_SNDTERMREG_ACK      0xB2     /* B<->H Provide network ack for term registration */

#define ISDN_TONEREDEFINE        0xB1     /* 05/08/97 Tone Generation isdncmd.h */
#define ISDN_TONEPLAY            0xB0
#define ISDN_TONESTOP            0xAF
#define ISDN_TONEDEFINECMPLT     0xAE
#define ISDN_TONEPLAYCMPLT       0xAD
#define ISDN_TONESTOPCMPLT       0xAC
#define ISDN_TIMEOUT             0xAB	 /* Handling tone gen. timeout
                                           conditions.*/

#define ISDN_GETNETCRV           0xAA   /* PRI: H ->B retrieve network crv to f/w */

#define ISDN_RCVTERMREG_ACK      0xA9   /* B->H convey reception of Term Reg. Ack */
#define ISDN_RCVTERMREG_NACK     0xA8   /* B->H convey reception of Term Reg Nack */

#define ISDN_SETL2ST             0xA3     /* H <->B set layer 2 state */
#define ISDN_SETL2CFG            0xA2     /* H <->B set layer 2 Config */
#define ISDN_GETL2CFG            0xA1     /* H <->B set layer 2 Config */

#define CHAN_RESTARTED			 0x01 	  /* The channel was restarted */
#define CHAN_MAINTENANCE		 0x02	  /* The channel received a maint msg */
#define CHAN_ENQUIRY			 0x03	  /* Host requests channel status */
#define CHAN_RESULT 			 0x04	  /* CC responds to chan enquiry */
#define CHAN_RESTART_REQ		 0x05	  /* Local restart request */
#define CHAN_RESTART_ERR		 0x06	  /* Locally originated restart failed*/
#define CHAN_MAINT_REQ			 0x07	  /* Host requests channel maintenance*/
#define ISDN_INCOMMING_SERVICE	 0x08	  /* Incoming service message */

/*
 * Error codes 
 */
#define  ISDN_OK                 0
#define  ISDN_BADDSL             1
#define  ISDN_BADTS              2
#define  ISDN_BADARG             3
#define  ISDN_BADLEN             4
#define  ISDN_BADSTR             5
#define  ISDN_BADIF              6
#define  ISDN_MISSIE             7
#define  ISDN_CFGERR             8
#define  ISDN_TELNT              9
#define  ISDN_CHRST_ERR          10
#define  ISDN_BADCOMP            11    /* bad component */
#define  ISDN_BADARGU            12    /* bad argument */
#define  ISDN_BADSERVICE         13    /* bad service */
#define  ISDN_BADCALLID          14    /* bad call id */
#define  ISDN_BADSTATE           15    /* can not accept event in current 
                                          state */
#define  ISDN_BADSS              16    /* bad serveice state */
#define  ISDN_TSBUSY             17    /* time slot already in use */
#define  ISDN_NOAVAIL            18    /* no more avail info record */
#define  ISDN_LINKFAIL           19    /* Data link don't come up */
#define  ISDN_FB_AVAIL           ISDN_LINKFAIL+FLEX_BILLING_AVAILABLE      
#define  ISDN_FB_UNAVAIL         ISDN_LINKFAIL+FLEX_BILLING_UNAVAILABLE    
#define  ISDN_FB_ACCEPTED        ISDN_LINKFAIL+FLEX_BILLING_ACCEPTED       
#define  ISDN_FB_BAD_OPER        ISDN_LINKFAIL+FLEX_BILLING_BAD_OPERATION  
#define  ISDN_FB_BAD_ARG         ISDN_LINKFAIL+FLEX_BILLING_BAD_ARGUMENT   
#define  ISDN_FB_RET_ERR         ISDN_LINKFAIL+FLEX_BILLING_RETURN_ERR     
#define  ISDN_FB_IE_ERR          ISDN_LINKFAIL+FLEX_BILLING_IE_ERR
#define  ISDN_NO_FB_INFO         ISDN_LINKFAIL+NO_FLEX_BILLING_INFO
#define  ISDN_NO_MSG             30   /* don't send any message to Network 
                                          or Host */
#define  ISDN_BADMSG             31   /* Bad message in service/feature 
                                          provided */
#define  ISDN_INVALID_EVENT      32   /* invalid event for the switch */
#define  ISDN_GLARE              33   /* Glare condition has occured */
#define  ISDN_BADIE_BEARCAP      34   /* bad transfer rate in Bearer Cap */
#define  ISDN_BADDLID            35   /* Bad data link id */
#define  ISDN_SYSTEM_ERR         36   /* System related error 
                                         (i.e., alloc failure) */
#define  ISDN_INVALID_SWITCH_TYPE 37  /* Invalid switch type specified
                                         in configuration */
#define  ISDN_MISSING_FIXED_TEI  38   /* Fixed TEI value not provided for initializing terminal */
#define  ISDN_MISSING_DN         39   /* SPID not provided for North American terminal */
#define  ISDN_MISSING_SPID       40   /* SPID not provided for North American termina */ 
                          
/* tone generation errors */
#define  ISDN_BADTONEMSG         41   /* Invalid tone message */
#define  ISDN_TONEBUSY           42   /* Channel is busy playing a tone */                          
#define  ISDN_ERRDSP             44   /* DSP is not responding */
#define  ISDN_BADSTOP            54   /* Channel is already stopped */
                                         
                           
/*                              
 * argument id for ISDN_SETDEF, ISDN_GETDEF, and ISDN_RETDEF commands
 */
#define BEAR_CAP_FIELD3          0x0403
#define BEAR_CAP_FIELD4          0x0404
#define BEAR_CAP_FIELD5          0x0405
#define BEAR_CAP_FIELD6          0x0406
#define BEAR_CAP_FIELD7          0x0407
#define CAUSE_FIELD3             0x0803
#define CALLED_NUM_FIELD3        0x7003
#define CALLED_NUM_FIELD4        0x7004
#define CALLED_NUM_FIELD5        0x7005
#define NFAS_CFG_INFO            0x7006          /* HSS:S018-47 -- NFAS Interface ID FR */

/* VJ Added for BRI UNIX */
#define DIRECTORY_NUMBER	 0x7015
#define SUBADDRESS_NUMBER	 0x7115
#define CALLING_NUM_FIELD3       0x6C03
#define CALLING_NUM_FIELD4       0x6C04
#define CALLING_NUM_FIELD5       0x6C05
#define CALLING_NUM_FIELD6       0x6C06
#define CALLING_NUM_FIELD7       0x6C07
#define HIGH_LAYER_COMP_FIELD3   0x7D03
#define HIGH_LAYER_COMP_FIELD4   0x7D04
#define HIGH_LAYER_COMP_FIELD6   0x7D06
#define SPID_NUMBER              0x8000
 
/*
 * bit mask for ISDN_SETMM, ISDN_GETMM, and ISDN_RETMM commands
 */
#define ISDN_CALL_ALERT          0x01
#define ISDN_CALL_DISC           0x02
#define ISDN_CALL_PROC           0x04
#define ISDN_CALL_PROG           0x08
#define ISDN_LINK_STATUS         0x10
#define ISDN_CALL_SETUP_ACK      0x20
#define ISDN_RELEASE             0x40
#define ISDN_CALL_PROC_SEND      0x80

#define ISDN_INCOMMING_STATUS 		0x100
#define ISDN_INCOMMING_STATUS_ENQUIRY 	0x200
#define ISDN_INCOMMING_SERVICE_MSG 	0x400
#define ISDN_INCOMMING_SERVICE_ACK 	0x800
#define ISDN_TMREXPEVENT 		0x1000

#define ISDN_INCALLREJECT_ENABLE        0x2000 /*Mask to turn on CCEV_CALLREJECT event*/
#define ISDN_DIALING_ENABLE             0x4000 /*Mask to turn on CCEV_DIALING message from board to host */
#define ISDN_SERVICE_NOTIFICATION       0x8000 /*Mask to turn on CCEV_SERVICE message while the firmware still handles this message */
   
/*                           
 * Layer 2 Link State
 */
#define ISDN_L2_DOWN             0     /* Layer 2 is down */
#define ISDN_L2_UP               1     /* Layer 2 is up */

/*
 * B-Channel service states.
 */

#define ISDN_IN_SERVICE          0     /* B-Channel in service */
#define ISDN_MAINTENANCE         1     /* B-Channel in maintenance busy */
#define ISDN_OUT_OF_SERVICE      2     /* B-Channel out of service */

#ifndef ISDN_OS2
#ifndef IN_SERVICE
#define IN_SERVICE      ISDN_IN_SERVICE      /* B-Channel in service */
#endif
#define MAINTENANCE     ISDN_MAINTENANCE     /* B-Channel in maintenance busy */
#define OUT_OF_SERVICE  ISDN_OUT_OF_SERVICE  /* B-Channel out of service */
#endif

/*
 * Message IDs for multi-byte messages between FW and Host.
 */
#define CALL_ACCEPT              0x01  /* Not used for new designs */
#define CALL_DISC                0x02  /* Incoming or outgoing call 
                                          disconnect */
#define CALL_INCOMING            0x03  /* Incoming call to the host */
#define CALL_OUTGOING            0x04  /* Outgoing call from the host */
#define CALL_PROGRESS            0x05  /* Call status change (either 
                                          direction) */
#define CALL_REJECTION           0x06  /* Incoming or outgoing call 
                                          rejected */
#define CALL_UUI                 0x07  /* UUI string in either direction */
#define CALL_FACILITY            0x08  /* Network facility indication */
#define CALL_FACILITY_ACK        0x09  /* Facility ACK */
#define CALL_FACILITY_REJ        0x0A  /* Facility REJ */
#define CALL_CONGESTION          0x0B  /* Call congestion report (UUI) */
#define CALL_NOTIFY              0x0C  /* Call notify to/from HOST */
#define CHAN_STATUS              0x0D  /* Channel status to/from HOST */
#define CALL_CLEARED             0x0E  /* Call_ID is cleared to HOST */
#define CALL_INFO                0x0F  /* Information message */
#define CALL_FACILITY_REGISTER   0x10  /* Facility Register */
#define CALL_REGISTER_ACK        0x11  /* Ack of Registration */
#define CALL_REGISTER_REJ        0x12  /* Rej of Registration */
#define CALL_FACILITY_CANCEL     0x13  /* Facility Cancel */
#define CALL_CANCEL_ACK          0x14  /* Cancel Ack */
#define CALL_CANCEL_REJ          0x15  /* Cancel Reject */
#define CALL_RELEASE             0x16  /* Release with UUI or Redirection */
#define STATUS_UPDATE            0x17  /* Update to/from HOST */
#define CALL_DETACH              0x18  /* Detach to/from HOST */
#define CALL_ALERT               0x20  /* Report ALERTING in either direction
                                           */
#define CALL_CONNECT             0x21  /* Report CONNECT in either direction
                                           */
#define CALL_SETUP_ACK           0x22  /* Report SETUP_ACK */
#define CALL_CONNECT_ACK         0x23  /* Report CONNECT_ACK */
#define CALL_PROCEEDING          0x24  /* Report CALL_PROCEEDING */
#define CALL_DEACTIVATE_REQ      0x25  /* TPH Semi-permanent DEACTIVATE_REQ */
#define CALL_REACTIVATE_REQ      0x26  /* TPH Semi-permanent REACTIVATE_REQ */
#define CALL_DEACTIVATE_CONF     0x27  /* TPH DEACTIVATE_CONF */
#define CALL_REACTIVATE_CONF     0x28  /* TPH REACTIVATE_CONF */
#define CALL_DEACTIVATE_ERROR    0x29  /* TPH DEACTIVATE_ERROR */
#define CALL_REACTIVATE_ERROR    0x2A  /* TPH REACTIVATE_ERROR */
#define CALL_STATUS              0x2B  /* Report a STATUS message */
#define CALL_ERROR               0x2C  /* Report internal error */
#define ISDN_RETNETCRV           0x2D  /* H<- B retrieve network call ref value to f/w */


#define CALL_STATUS_ENQ                 0x2E    /*send out a status enquiry message*/
#define ISDN_L3TIMEOUT                  0x2F
#define ISDN_OUTGOING_SERVICE_ACK       0x30    /*for service ack*/


/*
 * Single-byte Codeset 0 information elements
 */
#define CODESET_SHIFT_IE         0x90  /* Codeset shift - Type 1 */
#define MORE_DATA_IE             0xA0  /* More data - Type 2 */
#define SENDING_COMPLETE_IE      0xA1  /* Send complete - Type 2 */
#define CONGEST_LEVEL_IE         0xB0  /* Congestion level - Type 1 */
#define REPEAT_IND_IE            0xD0  /* Repeat indicator - Type 1 */   

/*                                    
 * Multi-byte Codeset 0 information elements
 */
#define SEGMENTED_MSG_IE         0x00  /* Segmented message */
#define CHANGE_STATUS_IE         0x01  /* Change status maint. ie */
#define BEARER_CAPABILITY_IE     0x04  /* Bearer capability */
#define CAUSE_IE                 0x08  /* Cause elem */
#define CONNECTED_NUM_IE         0x0C  /* Connected number */

#define CALL_IDENT_IE            0x10  /* Call identity */
#define CALL_STATE_IE            0x14  /* Call state */
#define CHANNEL_ID_IE            0x18  /* Channel identification */
#define FACILITY_IE              0x1C  /* Facility element */
#define PROGRESS_IND_IE          0x1E  /* Progress indicator */

#define NETWORK_FACILITY_IE      0x20  /* Network-specific facility */
#define NATIONAL_FACILITY_IE     NETWORK_FACILITY_IE      /* VN3 element */
#define ENDPOINT_ID_IE           0x26  /* Endpoint Identification */
#define NOTIFY_IND_IE            0x27  /* Notification indicator */
#define DISPLAY_IE               0x28  /* Display element */
#define TIME_DATE_IE             0x29  /* Time/Date element */
#define KEYPAD_FACILITY_IE       0x2C  /* Keypad facility */

/*
 * Values used in CHAN_STATUS message.
 */
#define CHAN_STATUS_IE           0x30  /* Channel status */

#define CALL_STATUS_IE		 0x2d  /* Call Status */

/*
 * Values used in STATUS_UPDATE message
 */
#define UPDATE_IE                0x31  /* update info */

#define CONGESTION_IE            0x31  /* Channel status */

#define INFO_REQ_IE              0x32  /* Information request */
#define SIGNAL_IE                0x34  /* Signal element */
#define SWITCHHOOK_IE            0x36  /* Switchhook element */
#define FEATURE_ACTIV_IE         0x38  /* Feature activation */
#define FEATURE_IND_IE           0x39  /* Feature indication */

#define INFO_RATE_IE             0x40  /* Information rate */
#define TRANSIT_DELAY_EE_IE      0x42  /* End to end transit delay */
#define TRANSIT_DELAY_SEL_IE     0x43  /* Transit delay select & indic */
#define PACKET_BIN_PARMS_IE      0x44  /* Packet layer binary parameters */
#define PACKET_WINDOW_IE         0x45  /* Packet layer window size */
#define PACKET_SIZE_IE           0x46  /* Packet size */

#define CALLER_NUMBER_IE         0x6C  /* Calling party number */
#define CALLER_SUB_ADDR_IE       0x6D  /* Calling party sub-address */

#define CALLED_NUMBER_IE         0x70  /* Called party number */
#define CALLED_SUB_ADDR_IE       0x71  /* Called party sub-address */
#define ORIGINAL_CALLED_NUM_IE   0x73  /* Original Called Number */
#define REDIRECTING_NUM_IE       0x74  /* Redirecting number */
#define REDIRECTION_NUM_IE       0x76  /* Redirection number */
#define TRANSIT_NETWORK_SEL_IE   0x78  /* Transit network selection */
#define RESTART_IND_IE           0x79  /* Re-start indication */
#define USER_USER_FAC_IE         0x7A  /* User-to-user facility */
#define LOW_LAYER_COMPAT_IE      0x7C  /* Low layer compatibility */
#define HIGH_LAYER_COMPAT_IE     0x7D  /* High layer compatibility */
#define USER_USER_IE             0x7E  /* User-to-User */
#define ESCAPE_FOR_EXT_IE        0x7F  /* Escape for extension */

#define LOCKING_SHIFT_TO_6       0x96  /* for VerifyIEs function */
#define CODESET_6_UNLOCKED       0x86  /* for VerifyIEs function */
#define CODESET_6_LOCKED         0x06  /* for VerifyIEs function */

#define ADVICE_OF_CHARGE_IE      0x01  /* NTT-KDD advice of charge */
                                 
/*
 * Equates for supported value of Information Element
 */

/*
 *     Calling party number element
 */
#define ISDN_PI_RESTRICT         0x01  /* presentation indicator - restricted
                                          */
#define ISDN_PI_NOTAVAIL         0x02  /* presentation indicator - not avail 
                                          */
#define ISDN_PI_RESRV            0x03  /* presentation indicator - reserved
                                          */
#define ISDN_SI_USRVERSCRN       0x01  /* screening indicator - verified and 
                                          passed */
#define ISDN_SI_USRVERFAIL       0x02  /* screening indicator - verified and 
                                          failed */
#define ISDN_SI_NET              0x03  /* screening indicator - network 
                                          provided */

/*
 *     Congestion Level element
 */
#define ISDN_RCV_READY           0x00  /* ready to receive more user to user 
                                          info */
#define ISDN_RCV_NOT_READY       0x01  /* not ready to receive more user to
                                          user info */

/*
 *     Network-Specific facility element
 */
#define ISDN_FEATURE             0x00  /* feature/service - feature */
#define ISDN_SERVICE             0x01  /* feature/service - service */
#define ISDN_CPN_PREF            0x01  /* facility coding - CPN perferred */
#define ISDN_BN_PREF             0x02  /* facility coding - BN preferred */
#define ISDN_CPN                 0x03  /* facility coding - CPN */
#define ISDN_BN                  0x04  /* facility coding - BN */
                                 
#define ISDN_SDN                 0x01  /* service coding - SDN */
#define ISDN_MEGACOM800          0x02  /* service coding - MEGACOM 800 */
#define ISDN_MEGACOM             0x03  /* service coding - MEGACOM */
#define ISDN_WATS                0x04  /* service coding - WATS */
#define ISDN_TIE                 0x05  /* service coding - TIE */
#define ISDN_ACCUNET             0x06  /* service coding - ACCUNET SDS */
#define ISDN_LONG_DS             0x07  /* service coding - Long distance */
#define ISDN_INT_800             0x08  /* service coding - internation 800 */
#define ISDN_CA_TSC              0x09  /* service coding - CA TSC */
#define ISDN_ATT_MULTIQ          0x10  /* service coding - ATT MultiQuest */
#define ISDN_TNID_USER           0x00  /* network id type - user specified */
#define ISDN_TNID_NAT            0x02  /* network id type - national */
#define ISDN_TNID_INTER          0x03  /* network id type - international */
#define ISDN_NIDPLN_UNK          0x00  /* network id plan - unknown */
#define ISDN_NIDPLN_CIC          0x01  /* network id plan - carrier id code */
#define ISDN_NIDPLN_DNIC         0x03  /* network id plan - datanetwork id co */
                                 
/*
 * Information Transfer Capability
 */
#define BEAR_CAP_SPEECH          0x00  /* Speech Bearer Capability */
#define BEAR_CAP_UNREST_DIG      0x08  /* Unrestricted Digital Capability */
#define BEAR_CAP_REST_DIG        0x09  /* Restricted Digital Capability */
#define BEAR_CAP_3DOT1K_AUDIO    0x10  /* 3.1KHz Audio Capability */
#define BEAR_CAP_7K_AUDIO        0x11  /* 7KHz Audio Capability */
#define BEAR_CAP_VIDEO           0x18  /* Video Capability */

#define ISDN_ITM_CIRCUIT         0x00  /* info transfer mode - circuit mode */
#define ISDN_ITM_PACKET          0x02  /* info transfer mode - packet mode */

/*                                 
 * Information Transfer Rate
 */
#define BEAR_RATE_64KBPS         0x10  /* B_CHANNEL_UNITS 1X64 */
#define BEAR_RATE_128KBPS        0x11  /* Non-standard 2X64       */
#define BEAR_RATE_384KBPS        0x13  /* H0_CHANNEL_UNITS 6X64   */
#define BEAR_RATE_1536KBPS       0x15  /* H11_CHANNEL_UNITS 24X64 */
#define BEAR_RATE_1920KBPS       0x17  /* H12_CHANNEL_UNITS 30X64 */
#define PACKET_TRANSFER_MODE	 0x00

/*
 *    Bearer Capability Element
 */
#define ISDN_UIL1_CCITTV110      0x01  /* user info layer 1 - CCITT V.110/X.3
                                          */
#define ISDN_UIL1_G711ULAW       0x02  /* user info layer 1 - G.711 u-law */
#define ISDN_UIL1_G711ALAW       0x03  /* user info layer 1 - G.711 A-law */
#define ISDN_UIL1_G721ADCPM      0x04  /* user info layer 1 - G.721 ADCPM */
#define ISDN_UIL1_G722G725       0x05  /* user info layer 1 - G.722 and G.725 */
#define ISDN_UIL1_G722F725       0x05  /* user info layer 1 - G.722 and G.725
                                          */
#define ISDN_UIL1_H261           0x06  /* user info layer 1 - H.261 */
#define ISDN_UIL1_NONCCITT       0x07  /* user info layer 1 - non-CCITT */
#define ISDN_UIL1_CCITTV120      0x08  /* user info layer 1 - CCITT V.120 */
#define ISDN_UIL1_CCITTX31       0x09  /* user info layer 1 - CCITT X.31 */
#define ISDN_UIL1_DEFAULT        0xFF  /* user info layer 1 - Default Value 
                                          */

#define ISDN_UR_EINI460          0x00  /* user rate - E bits in I.460 */
#define ISDN_UR_600              0x01  /* user rate - 0.6 kbits */
#define ISDN_UR_1200             0x02  /* user rate - 1.2 kbits */
#define ISDN_UR_2400             0x03  /* user rate - 2.4 kbits */
#define ISDN_UR_3600             0x04  /* user rate - 3.6 kbits */
#define ISDN_UR_4800             0x05  /* user rate - 4.8 kbits */
#define ISDN_UR_7200             0x06  /* user rate - 7.2 kbits */
#define ISDN_UR_8000             0x07  /* user rate - 8.0 kbits */
#define ISDN_UR_9600             0x08  /* user rate - 9.6 kbits */
#define ISDN_UR_14400            0x09  /* user rate - 14.4 kbits */
#define ISDN_UR_16000            0x0A  /* user rate - 16.0 kbits */
#define ISDN_UR_19200            0x0B  /* user rate - 19.2 kbits */
#define ISDN_UR_32000            0x0C  /* user rate - 32 kbits */
#define ISDN_UR_48000            0x0E  /* user rate - 48 kbits */
#define ISDN_UR_56000            0x0F  /* user rate - 56 kbits */
#define ISDN_UR_64000            0x10  /* user rate - 64 kbits */
#define ISDN_UR_134              0x15  /* user rate - .1345 kbits */
#define ISDN_UR_100              0x16  /* user rate - .100 kbits */
#define ISDN_UR_75_1200          0x17  /* user rate - .075/1200 kbits */
#define ISDN_UR_1200_75          0x18  /* user rate - 1200/.075 kbits */
#define ISDN_UR_50               0x19  /* user rate - .050 kbits */
#define ISDN_UR_75               0x1A  /* user rate - .075 kbits */
#define ISDN_UR_110              0x1B  /* user rate - .110 kbits */
#define ISDN_UR_150              0x1C  /* user rate - .150 kbits */
#define ISDN_UR_200              0x1D  /* user rate - .200 kbits */
#define ISDN_UR_300              0x1E  /* user rate - .300 kbits */
#define ISDN_UR_12000            0x1F  /* user rate - 12 kbits */
#define ISDN_UR_DEFAULT          0xFF  /* user rate - Default */
                                 

/*
 * CALLER/CALLED_NUMBER_IE 
 */

/*
 * Number types
 */
#define EN_BLOC_NUMBER           0x00  /* Number is sent en-bloc */
#define INTL_NUMBER              0x01  /* International number */
#define NAT_NUMBER               0x02  /* National number */
#define LOC_NUMBER               0x04  /* Loacl (directory) number */
#define OVERLAP_NUMBER           0x05  /* Number is sent overlap */

/*
 * Numbering plans
 */
#define UNKNOWN_NUMB_PLAN        0x00  /* Unknown plan */
#define ISDN_NUMB_PLAN           0x01  /* ISDN numb. plan E.164 */
#define TELEPHONY_NUMB_PLAN      0x02  /* Telephony numb. plan E.163 */
#define PRIVATE_NUMB_PLAN        0x09  /* Private numbering plan */

/*
 * Presentation indicators
 */
#define PRESENTATION_ALLOWED     0x00  /* Default */

/*
 * Screening indicators
 */
#define USER_PROVIDED            0x00  /* Default */


/*
 * CALLER_SUB_ADDR_IE and CALLED_SUB_ADDR_IE
 */
#define OSI_SUB_ADDR             0x00  /* OSI Sub-address */
#define USER_SPECIFIC_SUB_ADDR   0x02  /* User-specific Sub-address */
#define IA_5_FORMAT              0x50  /* IA 5 sub-address digit format */
#define MAX_SUB_ADDR_LEN         23    /* CCITT default */

/*
 * CAUSE_IE
 */
#define CAUSE_LENGTH             0x02  /* Internal length = 2 */
#define DIAG_LEN                 0x03  /* Maximum diagnostic length */
#define NO_DIAG                  0x00  /* No CAUSE diagnostic specified */

/*
 * Cause values
 *
 * NOTE: Not all cause values are universally supported across switch types.
 *       Before a particular cause value is used, its validity should be
 *       compared with the appropriate switch vendor specs.
 */
#define UNASSIGNED_NUMBER        0x01  /* Cause 01 */
#define NO_ROUTE                 0x02  /* Cause 02 */
#define CHANNEL_UNACCEPTABLE     0x06  /* Cause 06 */
#define NORMAL_CLEARING          0x10  /* Cause 16 */
#define USER_BUSY                0x11  /* Cause 17 */
#define NO_USER_RESPONDING       0x12  /* Cause 18 */
#define NO_ANSWER_FROM_USER      0x13  /* Cause 19 */       
#define CALL_REJECTED            0x15  /* Cause 21 */
#define NUMBER_CHANGED           0x16  /* Cause 22 */
#define DEST_OUT_OF_ORDER        0x1B  /* Cause 27 */
#define INVALID_NUMBER_FORMAT    0x1C  /* Cause 28 */
#define FACILITY_REJECTED        0x1D  /* Cause 29 */
#define RESP_TO_STAT_ENQ         0x1E  /* Cause 30 */
#define UNSPECIFIED_CAUSE        0x1F  /* Cause 31 */
#define NO_CIRCUIT_AVAILABLE     0x22  /* Cause 34 */
#define NETWORK_OUT_OF_ORDER     0x26  /* Cause 38 */
#define TEMPORARY_FAILURE        0x29  /* Cause 41 */
#define NETWORK_CONGESTION       0x2A  /* Cause 42 */
#define ACCESS_INFO_DISCARDED    0x2B  /* Cause 43 */
#define REQ_CHANNEL_NOT_AVAIL    0x2C  /* Cause 44 */
#define PRE_EMPTED               0x2D  /* Cause 45 */
#define FACILITY_NOT_SUBSCRIBED  0x32  /* Cause 50 */
#define OUTGOING_CALL_BARRED     0x34  /* Cause 52 */
#define INCOMING_CALL_BARRED     0x36  /* Cause 54 */
#define BEAR_CAP_NOT_AVAIL       0x3A  /* Cause 58 */
#define SERVICE_NOT_AVAIL        0x3F  /* Cause 63 */
#define CAP_NOT_IMPLEMENTED      0x41  /* Cause 65 */
#define CHAN_NOT_IMPLEMENTED     0x42  /* Cause 66 */
#define FACILITY_NOT_IMPLEMENT   0x45  /* Cause 69 */
#define INVALID_CALL_REF         0x51  /* Cause 81 */
#define CHAN_DOES_NOT_EXIST      0x52  /* Cause 82 */
#define INCOMPATIBLE_DEST        0x58  /* Cause 88 */
#define INVALID_MSG_UNSPEC       0x5F  /* Cause 95 */
#define MANDATORY_IE_MISSING     0x60  /* Cause 96 */
#define NONEXISTENT_MSG          0x61  /* Cause 97 */
#define WRONG_MESSAGE            0x62  /* Cause 98 */
#define BAD_INFO_ELEM            0x63  /* Cause 99 */
#define INVALID_ELEM_CONTENTS    0x64  /* Cause 100 */
#define WRONG_MSG_FOR_STATE      0x65  /* Cause 101 */
#define TIMER_EXPIRY             0x66  /* Cause 102 */
#define MANDATORY_IE_LEN_ERR     0x67  /* Cause 103 */
#define PROTOCOL_ERROR           0x6F  /* Cause 111 */
#define INTERWORKING_UNSPEC      0x7F  /* Cause 127 */

/* 
   The Cause value greater than 127 is allowed to define here. There is
   no conflict with those universal defines which ranges 0 - 127 
*/
#define RESTART_ON_NON_PRIMARY 0x80                         /* Cause 128 */


/*
 * CHANNEL_ID_IE
 */
#define  ISDN_CHAN_EXCLUSIVE     0x01

/*
 * B-Channel choices for the Channel Identification IE.
 */
#define B_CHANNEL_UNITS          3     /* Chan type -   single B channel */
#define B_CHANNEL                B_CHANNEL_UNITS     /* Borrow the ID */
#define CHANNEL_1X64             B_CHANNEL           /* BEAR_RATE_64KBPS */

/*
 * CONGEST_LEVEL_IE
 */
#define NOT_CONGESTED            0     /* Level = NOT_CONGESTED */
#define CONGESTED                0x0F  /* Level = CONGESTED */


/*
 * HIGH_LAYER_COMPAT_IE
 */

/*
 * Coding Standards 
 */

#define CCITT_STANDARD            0    /* Coding standard */
#define CEPT_NATIONAL_STANDARD    2    /* CEPT/National standard */

#define NATIONAL_INTERPRETATION   0    /* Interpretation value */
#define CCITT_CEPT_INTERPRETATION 4    /* Interpretation value */
#define PROFILE_PRESENTATION      1    /* Presentation value */

/*
 * CCITT Teleservices
 */
#define TELEPHONY_SERVICE        0x01  /* Teleservice */
#define GR3_FAX_SERVICE          0x04  /* Teleservice */
#define TELETEX_MIXED_SERVICE    0x24  /* Teleservice */
#define GR4_FAX_SERVICE          0x21  /* Teleservice */
#define TELETEX_CHAR_SERVICE     0x31  /* Teleservice */
#define ALPHA_MOS_VID_SERVICE    0x32  /* Teleservice */
#define TELEX_SERVICE            0x35  /* Teleservice */
#define MHS_SERVICE              0x38  /* Teleservice */
#define OSI_APPL_SERVICE         0x41  /* Teleservice */
                                 
/*
 * CEPT Teleservices
 */
#define UNKNOWN_SERVICE          0x00  /* Teleservice (interworking) */

/*
 * National Standard Teleservices
 */
#define AUDIOSCRIPT_SERVICE      0x40  /* Teleservice */
#define AUDIOVIDEOTEX_SERVICE    0x48  /* Teleservice */
#define NON_STD_APPL_SERVICE     0x7F  /* Teleservice */


/*
 * PROGRESS_IND_IE 
 */

/*
 * Progress values
 */
#define CALL_NOT_END_TO_END_ISDN 1     /* Progress indicator value */
#define IN_BAND_INFO             8     /* Progress indicator value */


/*
 * USER_USER_IE 
 */
#define USER_SPEC_PROTO          0x00  /* User-specific protocol */
#define OSI_HIGH_LAYER_PROTO     0x01  /* OSI high layer protocol */
#define X244_PROTO               0x02  /* X.244 protocol */
#define MAINT_MGMT_PROTO         0x03  /* Maintenance/management protocol */
#define IA5_CHAR_PROTO           0x04  /* IA5 character protocol */
#define V120_RATE_ADPT_PROTO     0x07  /* V.120 rate adaption protocol */
#define Q931_USER_NET_PROTO      0x08  /* Q.931 user-network protocol */
#define NT2_NT2_FAC_PROTO        0x40  /* VN2 NT2-NT2 facilities protocol */
#define MINI_MSG_SERV_PROTO      0x41  /* VN2 mini-msg handling protocol */
#define MAX_UUI_LEN              131   /* A network-dependent value */

/*
 * "update" values
 */

#define DATA_LINK_DISABLED       0x00
#define DATA_LINK_DOWN           0x01  /* CC->Host data link failure report */
#define DATA_LINK_UP             0x02  /* CC->Host data link restore report */
#define EST_DATA_LINK            0x03  /* Host->CC data link restore request */
#define REL_DATA_LINK            0x04  /* Host->CC data link restore request */
#define DATA_LINK_RESET          0x05  /* CC->Host data link reset for DASS2 */

#define AUTO_TEI		0x7F
#define DATA_LINK_PROTOCOL_Q931	0x01
#define DATA_LINK_PROTOCOL_X25	0x02

/*
 * vari-a-bill
 */
#define FLEX_BILLING_AVAILABLE      0x01
#define FLEX_BILLING_UNAVAILABLE    0x02
#define FLEX_BILLING_ACCEPTED       0x03
#define FLEX_BILLING_BAD_OPERATION  0x04
#define FLEX_BILLING_BAD_ARGUMENT   0x05
#define FLEX_BILLING_RETURN_ERR     0x06
#define FLEX_BILLING_IE_ERR         0x07
#define NO_FLEX_BILLING_INFO        0x08

/*
 * definitions for flex billing billing type field
 */
#define BILLING_NEW_RATE            0x10
#define BILLING_FLAT_RATE           0x11
#define BILLING_PREMIUM_CHARGE      0x12
#define BILLING_PREMIUM_CREDIT      0x13
#define BILLING_FREE_CALL           0x18
/*
 * DPNSS_IE SINGLE BYTE IE
 */
#define BUSY_IE                     0xE0     /* Busy IE */
#define DIVERSION_BYPASS_IE         0xE1     /* Diversion bypass IE */
#define ENQUIRY_IE                  0xE2     /* Enquiry IE */
#define VIRTUALCALL_IE              0xE3     /* Virtual call IE */
#define DIVERSION_VALIDATION_IE     0xE4     /* Diversion validation IE */

/*
 * DPNSS_IE MULITIPLE BYTES IE
 */
#define DIVERSION_IE                0x58     /* Diversion IE */
#define INTRUDE_IE                  0x59     /* Intrude IE */
#define INTRUSION_IE                0x5A     /* Intrusion IE */
#define NSI_IE                      0x5B     /* NSI IE */
#define TRANSFER_IE                 0x5C     /* Transfer IE */
#define TRANSIT_IE                  0x5D     /* Transit IE */
#define EXTENSION_STATUS_IE         0xE5     /* Extension Status IE */
#define TEXT_DISPLAY_IE		    0x5E     /* Text Display IE */

/*
 *     Diversion Information Element
 */
#define DIVERT_IMMEDIATE            0x01
#define DIVERT_ON_BUSY              0x02
#define DIVERT_NO_REPLY             0x03

#define DIVERT_LOCAL                0x01
#define DIVERT_REMOTE               0x02

/*
 *     Intrusion Information Element
 */
#define INTRUDE_PRIOR_VALIDATION    0x01
#define INTRUDE_NORMAL              0x02

#define INTRUSION_LEVEL_1           0x01
#define INTRUSION_LEVEL_2           0x02
#define INTRUSION_LEVEL_3           0x03

/*
 *     Intrude Information Element
 */
#define INTRUDE                     0x01
#define INTRUDE_WITHDRAW            0x02

/*
 *     Transfer Information Element
 */
#define TRANSFER_ORIG               0x01
#define TRANSFER_TERM               0x02

/*
 *     NSI Information Element
 */
#define NSI_EEM                     0x01
#define NSI_LLM                     0x02

/*
 *     Text Display Information Element
 */
#define TEXT_TYPE_NOT_PRESENT		0x00
#define TEXT_TYPE_NAME			   0x01
#define TEXT_TYPE_MESSAGE		   0x02
#define TEXT_TYPE_REASON		   0x03


#ifndef MAX_DN_SIZE
#define MAX_DN_SIZE              (16+1)
#endif

#ifndef MAX_SPID_SIZE
#define MAX_SPID_SIZE            (20+1)
#endif

#define USER_SIDE                0        /* User side of ISDN protocol */
#define NETWORK_SIDE             1        /* Network side of ISDN protocol */

#define LAYER_2_ONLY             0        /* ISDN access @ layer 2 */
#define FULL_ISDN_STACK          1        /* ISDN access @ L3 call control */

#define AUTO_INIT_TERMINAL       0        /* Auto Initializing terminal */
#define NON_INIT_TERMINAL        1        /* Non Initilizing Terminal   */

#define AUTO_TEI_TERMINAL        0        /* auto TEI assigning Terminal */
#define FIXED_TEI_TERMINAL       1        /* Non-auto TEI assigning term.*/

#define TMR_DEFAULT              0        /* Use default values of timers */
#define TMR_DISABLE              -1       /* Do not use the timer */

#define USE_DEFAULT_USID_TID     0        /* Use values by Telnetworks */ 
#define MATCH_USID_AND_TID       0        /* Match Usid and Tid */
#define MATCH_USID_BUT_NOT_TID   1        /* match usid but tid shouldn't match */


/*
 * BIT MASKS FOR D CHANNEL CONFIGURATION FEATURE CONTROL BYTE
*/
#define SENDING_COMPLETE_ATTACH  0x04     /* Add SENDING_COMPLETE IE to
                                             SETUP message */
#define HOST_CONTROLLED_RELEASE  0x10     /* Delay RELEASE reply until host
                                             issues cc_ReleaseCall */
#define USER_PERST_L2_ACT        0x08     /* Persistent L2 activation on
                                             user side */

/* BRI PCM TONE SETTINGS IN FEATURE CONTROL BYTE */
#define ULAW_PCM_TONE           0x01      /* Use Mu-Law for tone */
#define ALAW_PCM_TONE           0x02      /* Use A-Law for tone  */

#endif

