/******************************************************************************
* M3GERRS.H:
*
* M3G API:  3G-324M API error values.
*******************************************************************************
* DIALOGIC CONFIDENTIAL	
* Copyright 2007 Dialogic Corporation All Rights Reserved.
* 
* The source code contained or described herein and all documents related to 
* the source code ("Material") are owned by Dialogic Corporation or its suppliers
* or licensors.  Title to the Material remains with Dialogic Corporation or its 
* suppliers and licensors.  The Material contains trade secrets and proprietary
* and confidential information of Dialogic or its suppliers and licensors.  The
* Material is protected by worldwide copyright and trade secret laws and treaty
* provisions.  No part of the Material may be used, copied, reproduced, 
* modified, published, uploaded, posted, transmitted, distributed, or disclosed
* in any way without Dialogic's prior express written permission.
* 
* No license under any patent, copyright, trade secret or other intellectual 
* property right is granted to or conferred upon you by disclosure or delivery
* of the Materials, either expressly, by implication, inducement, estoppel or
* otherwise.  Any license under such intellectual property rights must be
* express and approved by Dialogic in writing.
* 
* Unless otherwise agreed by Dialogic in writing, you may not remove or alter this
* notice or any other notice embedded in Materials by Dialogic or Dialogic's 
* suppliers or licensors in any way.
******************************************************************************/

#ifndef _M3GERRS_H_
#define _M3GERRS_H_

/* M3G API error values: */
typedef enum
{
   M3G_E_NO_ERROR                            = 0,
   M3G_E_ERR_LIB_NOT_STARTED                 = 1,
   M3G_E_ERR_INVALID_DEVICE                  = 2,
   M3G_E_ERR_INV_ARGUMENT_VALUE              = 3,
   M3G_E_ERR_INV_PARM_ID                     = 4,
   M3G_E_ERR_NO_MEM                          = 5,
   M3G_E_ERR_INTERNAL                        = 6,
   M3G_E_ERR_INV_MODE                        = 7,
   M3G_E_ERR_INV_STATE                       = 8,
   M3G_E_ERR_PROTOCOL                        = 9,
   M3G_E_ERR_BUSY                            = 10,
   M3G_E_ERR_NO_MATCH_FOUND                  = 11,
   M3G_E_ERR_INVALID_CAPS_FOR_DEVICE         = 12,
   M3G_E_ERR_PHYSICAL_LAYER                  = 13,
   M3G_E_ERR_TCS_REJ_UNSPECIFIED             = 14,
   M3G_E_ERR_TCS_REJ_UND_TBL_ENTRY_USED      = 15,
   M3G_E_ERR_TCS_REJ_DESC_CAP_EXCEEDED       = 16,
   M3G_E_ERR_TCS_REJ_TBL_ENT_CAP_EXCEEDED    = 17,
   M3G_E_ERR_TIMEOUT                         = 18,
   M3G_E_ERR_OLC_REJ_UNSPECIFIED             = 19,
   M3G_E_ERR_OLC_REJ_UNS_REV_PARMS           = 20,
   M3G_E_ERR_OLC_REJ_DATA_TYPE_NOT_SUPPORTED = 21,
   M3G_E_ERR_OLC_REJ_DATA_TYPE_NOT_AVAILABLE = 22,
   M3G_E_ERR_OLC_REJ_UNKOWN_DATA_TYPE        = 23,
   M3G_E_ERR_OLC_REJ_DATA_TYPE_COMB_NOT_SUP  = 24,
   M3G_E_ERR_OLC_REJ_DATA_TYPE_COMB_NOT_ALWD = 25,
   M3G_E_ERR_OLC_REJ_INSUFF_BW               = 26,
   M3G_E_ERR_OLC_REJ_SEP_STCK_EST_FAILED     = 27,
   M3G_E_ERR_OLC_REJ_INVALID_SESSIONID       = 28,
   M3G_E_ERR_OLC_REJ_M_S_CONFLICT            = 29,
   M3G_E_ERR_OLC_REJ_WAIT_FOR_COMM_MODE      = 30,
   M3G_E_ERR_OLC_REJ_INV_DEP_CHANNEL         = 31,
   M3G_E_ERR_OLC_REJ_REPLCMT_FOR_REJECTED    = 32,
   M3G_E_ERR_STREAM_OPEN_ERR                 = 33,
   M3G_E_ERR_IN_STREAM_UNDRUN                = 34,
   M3G_E_ERR_O_STREAM_UNDRUN                 = 35,
   M3G_E_ERR_IN_STREAM_OVFLOW                = 36,
   M3G_E_ERR_O_STREAM_OVFLOW                 = 37,
   M3G_E_KERN_MEM                            = 38,
   M3G_E_NO_RESOURCE                         = 39,
   M3G_E_UNSUPPORTED                         = 40,
   M3G_E_REJECTED_BY_PEER                    = 41,
   M3G_E_ERR_INV_VERSION_VALUE               = 42,
   M3G_E_ERR_DISCONNECTED                    = 43
} M3G_E_ERROR_TYPE;

#endif
