/*Copyright (c) 1995-2001. Intel Corporation. All Rights Reserved. All names, 
 * products, and services mentioned herein are the trademarks or registered 
 * trademarks of their respective organizations and are the sole property of 
 * their respective owners */

/*
 * This file was automatically generated from mercdefs.mdl.
 * Author: "Mercury Kernel Group"
 * Version: "A.41"
 * Date: Wed Mar  3 14:02:07 2004
 * The output was written to mercdefs.h.
 * Produced by mmdl translator version 1.3.
 */

#if !defined(_mercdefs_h_)
#define _mercdefs_h_ 1
/*All Kernel messages start from 0x800000*/
/*Standard Success Completion Message*/
/*Standard Error Message*/

/*
 * QResultComplete (value = 0x800000) is a message of generic use.
 */

#define QResultComplete_Size		0

#define QResultComplete	0x800000	/* 8388608 */

#define QResultError_errorCode	0x380000	/* 3670016 */
typedef	UInt32	QResultError_errorCode_t;

#define QResultError_varStart	0x4
/* User defined data for debugging purpose */

#define QResultError_debugData	0x380000	/* 3670016 */
typedef	UInt32	QResultError_debugData_t;

/*
 * QResultError (value = 0x800001) is a message of generic use.
 */


typedef struct {
	UInt32	errorCode;
} QResultError_t;

#define QResultError_get(msgPtr, structAddr, offset)	\
		    qMsgVarFieldGet((msgPtr), 1, &(offset),	\
			(QResultError_errorCode), &((structAddr)->errorCode))


#define QResultError_put(msgPtr, structAddr, offset)	\
		    qMsgVarFieldPut((msgPtr), 1, &(offset),	\
			(QResultError_errorCode), &((structAddr)->errorCode))


#define QResultError_Size		4

#define QResultError	0x800001	/* 8388609 */
/*Standard No Error but No Data Message*/
/*Standard Timeout Message*/

/*
 * QResultNoError (value = 0x800002) is a message of generic use.
 */

#define QResultNoError_Size		0

#define QResultNoError	0x800002	/* 8388610 */
/*Block or Buffer Information Response*/

/*
 * QResultTimeout (value = 0x800003) is a message of generic use.
 */

#define QResultTimeout_Size		0

#define QResultTimeout	0x800003	/* 8388611 */

#define QBlockInfoResult_link	0x600000	/* 6291456 */
typedef	QMemRef	QBlockInfoResult_link_t;

#define QBlockInfoResult_bufFlags	0x300004	/* 3145732 */
typedef	UInt24	QBlockInfoResult_bufFlags_t;

#define QBlockInfoResult_encoding	0x300007	/* 3145735 */
typedef	UInt24	QBlockInfoResult_encoding_t;

#define QBlockInfoResult_dataSize	0x30000a	/* 3145738 */
typedef	UInt24	QBlockInfoResult_dataSize_t;

#define QBlockInfoResult_sequence	0x30000d	/* 3145741 */
typedef	UInt24	QBlockInfoResult_sequence_t;

/*
 * QBlockInfoResult (value = 0x800004) is a message of generic use.
 */


typedef struct {
	QMemRef	link;
	UInt24	bufFlags;
	UInt24	encoding;
	UInt24	dataSize;
	UInt24	sequence;
} QBlockInfoResult_t;

#define QBlockInfoResult_get(msgPtr, structAddr, offset)	\
		    qMsgVarFieldGet((msgPtr), 5, &(offset),	\
			(QBlockInfoResult_link), &((structAddr)->link),	\
			(QBlockInfoResult_bufFlags), &((structAddr)->bufFlags),	\
			(QBlockInfoResult_encoding), &((structAddr)->encoding),	\
			(QBlockInfoResult_dataSize), &((structAddr)->dataSize),	\
			(QBlockInfoResult_sequence), &((structAddr)->sequence))


#define QBlockInfoResult_put(msgPtr, structAddr, offset)	\
		    qMsgVarFieldPut((msgPtr), 5, &(offset),	\
			(QBlockInfoResult_link), &((structAddr)->link),	\
			(QBlockInfoResult_bufFlags), &((structAddr)->bufFlags),	\
			(QBlockInfoResult_encoding), &((structAddr)->encoding),	\
			(QBlockInfoResult_dataSize), &((structAddr)->dataSize),	\
			(QBlockInfoResult_sequence), &((structAddr)->sequence))


#define QBlockInfoResult_Size		16

#define QBlockInfoResult	0x800004	/* 8388612 */
/* Extended Buffer or Block Reference Response */

#define QBufRefResult_buffer	0x680000	/* 6815744 */
typedef	QBufRef	QBufRefResult_buffer_t;

/*
 * QBufRefResult (value = 0x800005) is a message of generic use.
 */


typedef struct {
	QBufRef	buffer;
} QBufRefResult_t;

#define QBufRefResult_get(msgPtr, structAddr, offset)	\
		    qMsgVarFieldGet((msgPtr), 1, &(offset),	\
			(QBufRefResult_buffer), &((structAddr)->buffer))


#define QBufRefResult_put(msgPtr, structAddr, offset)	\
		    qMsgVarFieldPut((msgPtr), 1, &(offset),	\
			(QBufRefResult_buffer), &((structAddr)->buffer))


#define QBufRefResult_Size		4

#define QBufRefResult	0x800005	/* 8388613 */
/* Component Attribute Information Response */

#define QCompAttrInfoResult_theComponent	0x800000	/* 8388608 */
typedef	QCompDesc	QCompAttrInfoResult_theComponent_t;

#define QCompAttrInfoResult_count	0x280006	/* 2621446 */
typedef	UInt16	QCompAttrInfoResult_count_t;

#define QCompAttrInfoResult_varStart	0x8

#define QCompAttrInfoResult_attr	0x780000	/* 7864320 */
typedef	QCompAttr	QCompAttrInfoResult_attr_t;

/*
 * QCompAttrInfoResult (value = 0x800006) is a message of generic use.
 */


typedef struct {
	QCompDesc	theComponent;
	UInt16	count;
} QCompAttrInfoResult_t;

#define QCompAttrInfoResult_get(msgPtr, structAddr, offset)	\
		    qMsgVarFieldGet((msgPtr), 2, &(offset),	\
			(QCompAttrInfoResult_theComponent), &((structAddr)->theComponent),	\
			(QCompAttrInfoResult_count), &((structAddr)->count))


#define QCompAttrInfoResult_put(msgPtr, structAddr, offset)	\
		    qMsgVarFieldPut((msgPtr), 2, &(offset),	\
			(QCompAttrInfoResult_theComponent), &((structAddr)->theComponent),	\
			(QCompAttrInfoResult_count), &((structAddr)->count))


#define QCompAttrInfoResult_Size		8

#define QCompAttrInfoResult	0x800006	/* 8388614 */
/* Component Description Response */

#define QComponentResult_theInstance	0x800000	/* 8388608 */
typedef	QCompDesc	QComponentResult_theInstance_t;

/*
 * QComponentResult (value = 0x800007) is a message of generic use.
 */


typedef struct {
	QCompDesc	theInstance;
} QComponentResult_t;

#define QComponentResult_get(msgPtr, structAddr, offset)	\
		    qMsgVarFieldGet((msgPtr), 1, &(offset),	\
			(QComponentResult_theInstance), &((structAddr)->theInstance))


#define QComponentResult_put(msgPtr, structAddr, offset)	\
		    qMsgVarFieldPut((msgPtr), 1, &(offset),	\
			(QComponentResult_theInstance), &((structAddr)->theInstance))


#define QComponentResult_Size		6

#define QComponentResult	0x800007	/* 8388615 */
/* Component Registration Response */

#define QCompRegisterResult_theComponent	0x800000	/* 8388608 */
typedef	QCompDesc	QCompRegisterResult_theComponent_t;

/*
 * QCompRegisterResult (value = 0x800008) is a message of generic use.
 */


typedef struct {
	QCompDesc	theComponent;
} QCompRegisterResult_t;

#define QCompRegisterResult_get(msgPtr, structAddr, offset)	\
		    qMsgVarFieldGet((msgPtr), 1, &(offset),	\
			(QCompRegisterResult_theComponent), &((structAddr)->theComponent))


#define QCompRegisterResult_put(msgPtr, structAddr, offset)	\
		    qMsgVarFieldPut((msgPtr), 1, &(offset),	\
			(QCompRegisterResult_theComponent), &((structAddr)->theComponent))


#define QCompRegisterResult_Size		6

#define QCompRegisterResult	0x800008	/* 8388616 */
/* Component Reservation Response */

#define QCompReserveResult_ticket	0x380000	/* 3670016 */
typedef	UInt32	QCompReserveResult_ticket_t;

/*
 * QCompReserveResult (value = 0x800009) is a message of generic use.
 */


typedef struct {
	UInt32	ticket;
} QCompReserveResult_t;

#define QCompReserveResult_get(msgPtr, structAddr, offset)	\
		    qMsgVarFieldGet((msgPtr), 1, &(offset),	\
			(QCompReserveResult_ticket), &((structAddr)->ticket))


#define QCompReserveResult_put(msgPtr, structAddr, offset)	\
		    qMsgVarFieldPut((msgPtr), 1, &(offset),	\
			(QCompReserveResult_ticket), &((structAddr)->ticket))


#define QCompReserveResult_Size		4

#define QCompReserveResult	0x800009	/* 8388617 */
/* Component Set Information Response */

#define QCompSetInfoResult_id	0x300000	/* 3145728 */
typedef	UInt24	QCompSetInfoResult_id_t;

#define QCompSetInfoResult_totalComponents	0x280003	/* 2621443 */
typedef	UInt16	QCompSetInfoResult_totalComponents_t;

#define QCompSetInfoResult_totalSubsets	0x280005	/* 2621445 */
typedef	UInt16	QCompSetInfoResult_totalSubsets_t;

#define QCompSetInfoResult_count	0x280007	/* 2621447 */
typedef	UInt16	QCompSetInfoResult_count_t;

#define QCompSetInfoResult_varStart	0x9

#define QCompSetInfoResult_theComponent	0x800000	/* 8388608 */
typedef	QCompDesc	QCompSetInfoResult_theComponent_t;

#define QCompSetInfoResult_subset	0x280000	/* 2621440 */
typedef	UInt16	QCompSetInfoResult_subset_t;

#define QCompSetInfoResult_firstInstance	0x280000	/* 2621440 */
typedef	UInt16	QCompSetInfoResult_firstInstance_t;

#define QCompSetInfoResult_instanceCount	0x280000	/* 2621440 */
typedef	UInt16	QCompSetInfoResult_instanceCount_t;

#define QCompSetInfoResult_inUse	0x280000	/* 2621440 */
typedef	UInt16	QCompSetInfoResult_inUse_t;

#define QCompSetInfoResult_units	0x280000	/* 2621440 */
typedef	UInt16	QCompSetInfoResult_units_t;

/*
 * QCompSetInfoResult (value = 0x80000a) is a message of generic use.
 */


typedef struct {
	UInt24	id;
	UInt16	totalComponents;
	UInt16	totalSubsets;
	UInt16	count;
} QCompSetInfoResult_t;

#define QCompSetInfoResult_get(msgPtr, structAddr, offset)	\
		    qMsgVarFieldGet((msgPtr), 4, &(offset),	\
			(QCompSetInfoResult_id), &((structAddr)->id),	\
			(QCompSetInfoResult_totalComponents), &((structAddr)->totalComponents),	\
			(QCompSetInfoResult_totalSubsets), &((structAddr)->totalSubsets),	\
			(QCompSetInfoResult_count), &((structAddr)->count))


#define QCompSetInfoResult_put(msgPtr, structAddr, offset)	\
		    qMsgVarFieldPut((msgPtr), 4, &(offset),	\
			(QCompSetInfoResult_id), &((structAddr)->id),	\
			(QCompSetInfoResult_totalComponents), &((structAddr)->totalComponents),	\
			(QCompSetInfoResult_totalSubsets), &((structAddr)->totalSubsets),	\
			(QCompSetInfoResult_count), &((structAddr)->count))


#define QCompSetInfoResult_Size		9

#define QCompSetInfoResult	0x80000a	/* 8388618 */
/* Circular Stream Close Completed */
/* Frame Timer Expiration Response */

/*
 * QCStreamCloseComplete (value = 0x80000b) is a message of generic use.
 */

#define QCStreamCloseComplete_Size		0

#define QCStreamCloseComplete	0x80000b	/* 8388619 */

#define QFTimerExpired_timerHandle	0x300000	/* 3145728 */
typedef	UInt24	QFTimerExpired_timerHandle_t;

#define QFTimerExpired_repCount	0x300003	/* 3145731 */
typedef	UInt24	QFTimerExpired_repCount_t;

#define QFTimerExpired_currFrame	0x300006	/* 3145734 */
typedef	UInt24	QFTimerExpired_currFrame_t;

/*
 * QFTimerExpired (value = 0x80000c) is a message of generic use.
 */


typedef struct {
	UInt24	timerHandle;
	UInt24	repCount;
	UInt24	currFrame;
} QFTimerExpired_t;

#define QFTimerExpired_get(msgPtr, structAddr, offset)	\
		    qMsgVarFieldGet((msgPtr), 3, &(offset),	\
			(QFTimerExpired_timerHandle), &((structAddr)->timerHandle),	\
			(QFTimerExpired_repCount), &((structAddr)->repCount),	\
			(QFTimerExpired_currFrame), &((structAddr)->currFrame))


#define QFTimerExpired_put(msgPtr, structAddr, offset)	\
		    qMsgVarFieldPut((msgPtr), 3, &(offset),	\
			(QFTimerExpired_timerHandle), &((structAddr)->timerHandle),	\
			(QFTimerExpired_repCount), &((structAddr)->repCount),	\
			(QFTimerExpired_currFrame), &((structAddr)->currFrame))


#define QFTimerExpired_Size		9

#define QFTimerExpired	0x80000c	/* 8388620 */

/**********************************************************************/
/****** RE_DEFINE FTIMER EXPIRED MACRO TO USE LOCAL MESSAGES **********/
/**********************************************************************/


/* make sure no-one undoes this change by re-making mmdl */
#define QFTimerExpiredMessageIsLocal 
/*will cause syntax error if not present */
#undef QFTimerExpired_get
#undef QFTimerExpired_put
#undef QFTimerExpired_timerHandle
#undef QFTimerExpired_repCount
#undef QFTimerExpired_currFrame


#define QFTimerExpired_get(msgPtr, structAddr, offset) \
{ \
QFTimerExpired_t *pFtimerExpiredBody; \
pFtimerExpiredBody = (QFTimerExpired_t *)((*(msgPtr)).data); \
(*(structAddr)).timerHandle = (*pFtimerExpiredBody).timerHandle; \
(*(structAddr)).repCount = (*pFtimerExpiredBody).repCount; \
(*(structAddr)).currFrame = (*pFtimerExpiredBody).currFrame; \
}

/* GStream Open Completed */

#if 0  /* mmdl definition not used since MMDL does not support pointers */


#define QGStrmOpenCmplt_handle	0x300000	/* 3145728 */
typedef	UInt24	QGStrmOpenCmplt_handle_t;

#define QGStrmOpenCmplt_id	0x280003	/* 2621443 */
typedef	UInt16	QGStrmOpenCmplt_id_t;

#define QGStrmOpenCmplt_streamStatus	0x200005	/* 2097157 */
typedef	UInt8	QGStrmOpenCmplt_streamStatus_t;

/*
 * QGStrmOpenCmplt (value = 0xa00000) is a message of generic use.
 */


typedef struct {
	UInt24	handle;
	UInt16	id;
	UInt8	streamStatus;
} QGStrmOpenCmplt_t;

#define QGStrmOpenCmplt_get(msgPtr, structAddr, offset)	\
		    qMsgVarFieldGet((msgPtr), 3, &(offset),	\
			(QGStrmOpenCmplt_handle), &((structAddr)->handle),	\
			(QGStrmOpenCmplt_id), &((structAddr)->id),	\
			(QGStrmOpenCmplt_streamStatus), &((structAddr)->streamStatus))


#define QGStrmOpenCmplt_put(msgPtr, structAddr, offset)	\
		    qMsgVarFieldPut((msgPtr), 3, &(offset),	\
			(QGStrmOpenCmplt_handle), &((structAddr)->handle),	\
			(QGStrmOpenCmplt_id), &((structAddr)->id),	\
			(QGStrmOpenCmplt_streamStatus), &((structAddr)->streamStatus))


#define QGStrmOpenCmplt_Size		6

#define QGStrmOpenCmplt	0xa00000	/* 10485760 */


/**********************************************************************/
/****** RE_DEFINE GSTREAMOPENCMPLT MACRO TO USE LOCAL MESSAGES ********/
/**********************************************************************/

/* make sure no-one undoes this change by re-making mmdl */
#define QGStreamOpenCmpltMessageIsLocal 
/*will cause syntax error if not present */
#undef QGStrmOpenCmplt_get
#undef QGStrmOpenCmplt_put
#undef QGStrmOpenCmplt_handle
#undef QGStrmOpenCmplt_id
#undef QGStrmOpenCmplt_streamStatus
#undef QGStrmOpenCmplt_Size

#else

typedef void *  QGStreamHandle;
typedef struct {
        QGStreamHandle  handle;
        Uint16          id;
        Uint8           streamStatus;
}QGStrmOpenCmplt_t;
#endif

#define QGStrmOpenCmplt	0xa00000

#if (QCPU == QM56301)
#define QGStrmOpenCmplt_Size (sizeof(QGStrmOpenCmplt_t)*3)
#else
#define QGStrmOpenCmplt_Size (sizeof(QGStrmOpenCmplt_t))
#endif

#define QGStrmOpenCmplt_get(msgPtr, structAddr, offset) \
{ \
QGStrmOpenCmplt_t * QGStrmOpenCmpltBody; \
QGStrmOpenCmpltBody = (QGStrmOpenCmplt_t *)((*(msgPtr)).data); \
(*(structAddr)).handle = (*QGStrmOpenCmpltBody).handle; \
(*(structAddr)).id = (*QGStrmOpenCmpltBody).id; \
(*(structAddr)).streamStatus = (*QGStrmOpenCmpltBody).streamStatus; \
}


/* GStream Close Completed */

#if 0  /* mmdl definition not used since MMDL does not support #if within {}*/


#define QGStrmCloseCmplt_dummy	0x200000	/* 2097152 */
typedef	UInt8	QGStrmCloseCmplt_dummy_t;

/*
 * QGStrmCloseCmplt (value = 0xa00001) is a message of generic use.
 */


typedef struct {
	UInt8	dummy;
} QGStrmCloseCmplt_t;

#define QGStrmCloseCmplt_get(msgPtr, structAddr, offset)	\
		    qMsgVarFieldGet((msgPtr), 1, &(offset),	\
			(QGStrmCloseCmplt_dummy), &((structAddr)->dummy))


#define QGStrmCloseCmplt_put(msgPtr, structAddr, offset)	\
		    qMsgVarFieldPut((msgPtr), 1, &(offset),	\
			(QGStrmCloseCmplt_dummy), &((structAddr)->dummy))


#define QGStrmCloseCmplt_Size		1

#define QGStrmCloseCmplt	0xa00001	/* 10485761 */


/**********************************************************************/
/****** RE_DEFINE GSTREAMClOSECMPLT MACRO TO USE LOCAL MESSAGES *******/
/**********************************************************************/

/* make sure no-one undoes this change by re-making mmdl */
#define QGStrmCloseCmpltMessageIsLocal 
/*will cause syntax error if not present */
#undef QGStrmCloseCmplt_get
#undef QGStrmCloseCmplt_put
#undef QGStrmCloseCmplt_Size

#else
typedef struct {
#if ((QCPU == QC6X)||(QCPU == QX86)||(QHOST <= QCPU))
	/* dummy number to silence compiler */
	Uint8		dummy;
#endif
}QGStrmCloseCmplt_t;
#endif

#define QGStrmCloseCmplt	0xa00001

#if (QCPU == QM56301)
#define QGStrmCloseCmplt_Size (sizeof(QGStrmCloseCmplt_t)*3)
#else
#define QGStrmCloseCmplt_Size (sizeof(QGStrmCloseCmplt_t))
#endif

#define QGStrmCloseCmplt_get(msgPtr, structAddr, offset) \
{ \
QGStrmCloseCmplt_t * QGStrmCloseCmpltBody; \
QGStrmCloseCmpltBody = (QGStrmCloseCmplt_t *)((*(msgPtr)).data); \
(*(structAddr)).handle = (*QGStrmCloseCmpltBody).handle; \
(*(structAddr)).id = (*QGStrmCloseCmplttBody).id; \
(*(structAddr)).streamStatus = (*QGStrmCloseCmpltBody).streamStatus; \
}

/* GStream IO Completed */

#define QGStrmIOCmplt_count	0x300000	/* 3145728 */
typedef	UInt24	QGStrmIOCmplt_count_t;

#define QGStrmIOCmplt_streamStatus	0x200003	/* 2097155 */
typedef	UInt8	QGStrmIOCmplt_streamStatus_t;

/*
 * QGStrmIOCmplt (value = 0xa00002) is a message of generic use.
 */


typedef struct {
	UInt24	count;
	UInt8	streamStatus;
} QGStrmIOCmplt_t;

#define QGStrmIOCmplt_get(msgPtr, structAddr, offset)	\
		    qMsgVarFieldGet((msgPtr), 2, &(offset),	\
			(QGStrmIOCmplt_count), &((structAddr)->count),	\
			(QGStrmIOCmplt_streamStatus), &((structAddr)->streamStatus))


#define QGStrmIOCmplt_put(msgPtr, structAddr, offset)	\
		    qMsgVarFieldPut((msgPtr), 2, &(offset),	\
			(QGStrmIOCmplt_count), &((structAddr)->count),	\
			(QGStrmIOCmplt_streamStatus), &((structAddr)->streamStatus))


#define QGStrmIOCmplt_Size		4

#define QGStrmIOCmplt	0xa00002	/* 10485762 */


/**********************************************************************/
/****** RE_DEFINE GSTREAMIOCMPLT MACRO TO USE LOCAL MESSAGES ********/
/**********************************************************************/

/* make sure no-one undoes this change by re-making mmdl */
#define QGStrmIOCmpltMessageIsLocal 
/*will cause syntax error if not present */
#undef QGStrmIOCmplt_get
#undef QGStrmIOCmplt_put
#undef QGStrmIOCmplt_count
#undef QGStrmIOCmplt_streamStatus
#undef QGStrmIOCmplt_Size

#if (QCPU == QM56301)
#define QGStrmIOCmplt_Size (sizeof(QGStrmIOCmplt_t)*3)
#else
#define QGStrmIOCmplt_Size (sizeof(QGStrmIOCmplt_t))
#endif

#define QGStrmIOCmplt_get(msgPtr, structAddr, offset) \
{ \
QGStrmIOCmplt_t * QGStrmIOCmpltBody; \
QGStrmIOCmpltBody = (QGStrmIOCmplt_t *)((*(msgPtr)).data);\
(*(structAddr)).id = (*QGStrmIOCmpltBody).count;\
(*(structAddr)).streamStatus = (*QGStrmIOCmpltBody).streamStatus;\
}


/* GStream Status */

#define QGStrmStatus_id	0x280000	/* 2621440 */
typedef	UInt16	QGStrmStatus_id_t;

#define QGStrmStatus_writeIndex	0x300002	/* 3145730 */
typedef	UInt24	QGStrmStatus_writeIndex_t;

#define QGStrmStatus_readIndex	0x300005	/* 3145733 */
typedef	UInt24	QGStrmStatus_readIndex_t;

#define QGStrmStatus_streamSize	0x300008	/* 3145736 */
typedef	UInt24	QGStrmStatus_streamSize_t;

#define QGStrmStatus_writeProcessor	0x20000b	/* 2097163 */
typedef	UInt8	QGStrmStatus_writeProcessor_t;

#define QGStrmStatus_readProcessor	0x20000c	/* 2097164 */
typedef	UInt8	QGStrmStatus_readProcessor_t;

/*
 * QGStrmStatus (value = 0xa00003) is a message of generic use.
 */


typedef struct {
	UInt16	id;
	UInt24	writeIndex;
	UInt24	readIndex;
	UInt24	streamSize;
	UInt8	writeProcessor;
	UInt8	readProcessor;
} QGStrmStatus_t;

#define QGStrmStatus_get(msgPtr, structAddr, offset)	\
		    qMsgVarFieldGet((msgPtr), 6, &(offset),	\
			(QGStrmStatus_id), &((structAddr)->id),	\
			(QGStrmStatus_writeIndex), &((structAddr)->writeIndex),	\
			(QGStrmStatus_readIndex), &((structAddr)->readIndex),	\
			(QGStrmStatus_streamSize), &((structAddr)->streamSize),	\
			(QGStrmStatus_writeProcessor), &((structAddr)->writeProcessor),	\
			(QGStrmStatus_readProcessor), &((structAddr)->readProcessor))


#define QGStrmStatus_put(msgPtr, structAddr, offset)	\
		    qMsgVarFieldPut((msgPtr), 6, &(offset),	\
			(QGStrmStatus_id), &((structAddr)->id),	\
			(QGStrmStatus_writeIndex), &((structAddr)->writeIndex),	\
			(QGStrmStatus_readIndex), &((structAddr)->readIndex),	\
			(QGStrmStatus_streamSize), &((structAddr)->streamSize),	\
			(QGStrmStatus_writeProcessor), &((structAddr)->writeProcessor),	\
			(QGStrmStatus_readProcessor), &((structAddr)->readProcessor))


#define QGStrmStatus_Size		13

#define QGStrmStatus	0xa00003	/* 10485763 */


/**********************************************************************/
/****** RE_DEFINE GSTREAMOPENCMPLT MACRO TO USE LOCAL MESSAGES ********/
/**********************************************************************/

/* make sure no-one undoes this change by re-making mmdl */
#define QGStrmStatusMessageIsLocal 
/*will cause syntax error if not present */
#undef QGStrmStatus_get
#undef QGStrmStatus_put
#undef QGStrmStatus_id
#undef QGStrmStatus_writeIndex
#undef QGStrmStatus_readIndex
#undef QGStrmStatus_streamSize
#undef QGStrmStatus_writeProcessor
#undef QGStrmStatus_readProcessor
#undef QGStrmStatus_Size

#if (QCPU == QM56301)
#define QGStrmStatus_Size (sizeof(QGStrmStatus_t)*3)
#else
#define QGStrmStatus_Size (sizeof(QGStrmStatus_t))
#endif

#define QGStrmStatus_get(msgPtr, structAddr, offset) \
{ \
QGStrmStatus_t * QGStrmStatusBody; \
QGStrmStatusBody = (QGStrmStatus_t *)((*(msgPtr)).data); \
(*(structAddr)).handle = (*QGStrmStatusBody).handle; \
(*(structAddr)).id = (*QGStrmStatusBody).id; \
(*(structAddr)).writeIndex = (*QGStrmStatusBody).writeIndex;\
(*(structAddr)).readIndex = (*QGStrmStatusBody).readIndex;\
(*(structAddr)).streamSize = (*QGStrmStatusBody).streamSize;\
(*(structAddr)).writeProcessor = (*QGStrmStatusBody).writeProcessor;\
(*(structAddr)).readProcessor = (*QGStrmStatusBody).readProcessor;\
}


/* Component Instance Deregistration Response */

#define QInstanceDeregistered_theInstance	0x800000	/* 8388608 */
typedef	QCompDesc	QInstanceDeregistered_theInstance_t;

/*
 * QInstanceDeregistered (value = 0x80000d) is a message of generic use.
 */


typedef struct {
	QCompDesc	theInstance;
} QInstanceDeregistered_t;

#define QInstanceDeregistered_get(msgPtr, structAddr, offset)	\
		    qMsgVarFieldGet((msgPtr), 1, &(offset),	\
			(QInstanceDeregistered_theInstance), &((structAddr)->theInstance))


#define QInstanceDeregistered_put(msgPtr, structAddr, offset)	\
		    qMsgVarFieldPut((msgPtr), 1, &(offset),	\
			(QInstanceDeregistered_theInstance), &((structAddr)->theInstance))


#define QInstanceDeregistered_Size		6

#define QInstanceDeregistered	0x80000d	/* 8388621 */
/* Component Instance Registration Response */

#define QInstanceRegistered_theInstance	0x800000	/* 8388608 */
typedef	QCompDesc	QInstanceRegistered_theInstance_t;

/*
 * QInstanceRegistered (value = 0x80000e) is a message of generic use.
 */


typedef struct {
	QCompDesc	theInstance;
} QInstanceRegistered_t;

#define QInstanceRegistered_get(msgPtr, structAddr, offset)	\
		    qMsgVarFieldGet((msgPtr), 1, &(offset),	\
			(QInstanceRegistered_theInstance), &((structAddr)->theInstance))


#define QInstanceRegistered_put(msgPtr, structAddr, offset)	\
		    qMsgVarFieldPut((msgPtr), 1, &(offset),	\
			(QInstanceRegistered_theInstance), &((structAddr)->theInstance))


#define QInstanceRegistered_Size		6

#define QInstanceRegistered	0x80000e	/* 8388622 */
/* Stream IO Response */

#define QIOResult_count	0x280000	/* 2621440 */
typedef	UInt16	QIOResult_count_t;

/*
 * QIOResult (value = 0x80000f) is a message of generic use.
 */


typedef struct {
	UInt16	count;
} QIOResult_t;

#define QIOResult_get(msgPtr, structAddr, offset)	\
		    qMsgVarFieldGet((msgPtr), 1, &(offset),	\
			(QIOResult_count), &((structAddr)->count))


#define QIOResult_put(msgPtr, structAddr, offset)	\
		    qMsgVarFieldPut((msgPtr), 1, &(offset),	\
			(QIOResult_count), &((structAddr)->count))


#define QIOResult_Size		2

#define QIOResult	0x80000f	/* 8388623 */
/* Global Memory Allocation Response */

#define QMemRefResult_buffer	0x600000	/* 6291456 */
typedef	QMemRef	QMemRefResult_buffer_t;

/*
 * QMemRefResult (value = 0x800010) is a message of generic use.
 */


typedef struct {
	QMemRef	buffer;
} QMemRefResult_t;

#define QMemRefResult_get(msgPtr, structAddr, offset)	\
		    qMsgVarFieldGet((msgPtr), 1, &(offset),	\
			(QMemRefResult_buffer), &((structAddr)->buffer))


#define QMemRefResult_put(msgPtr, structAddr, offset)	\
		    qMsgVarFieldPut((msgPtr), 1, &(offset),	\
			(QMemRefResult_buffer), &((structAddr)->buffer))


#define QMemRefResult_Size		4

#define QMemRefResult	0x800010	/* 8388624 */
/* Stream Global Information Response */

#define QStreamInfoResult_id	0x280000	/* 2621440 */
typedef	UInt16	QStreamInfoResult_id_t;

#define QStreamInfoResult_readState	0x280002	/* 2621442 */
typedef	UInt16	QStreamInfoResult_readState_t;

#define QStreamInfoResult_writeState	0x280004	/* 2621444 */
typedef	UInt16	QStreamInfoResult_writeState_t;

#define QStreamInfoResult_readers	0x280006	/* 2621446 */
typedef	UInt16	QStreamInfoResult_readers_t;

#define QStreamInfoResult_theReader	0x800008	/* 8388616 */
typedef	QCompDesc	QStreamInfoResult_theReader_t;

#define QStreamInfoResult_theWriter	0x80000e	/* 8388622 */
typedef	QCompDesc	QStreamInfoResult_theWriter_t;

#define QStreamInfoResult_bufCount	0x280014	/* 2621460 */
typedef	UInt16	QStreamInfoResult_bufCount_t;

/*
 * QStreamInfoResult (value = 0x800011) is a message of generic use.
 */


typedef struct {
	UInt16	id;
	UInt16	readState;
	UInt16	writeState;
	UInt16	readers;
	QCompDesc	theReader;
	QCompDesc	theWriter;
	UInt16	bufCount;
} QStreamInfoResult_t;

#define QStreamInfoResult_get(msgPtr, structAddr, offset)	\
		    qMsgVarFieldGet((msgPtr), 7, &(offset),	\
			(QStreamInfoResult_id), &((structAddr)->id),	\
			(QStreamInfoResult_readState), &((structAddr)->readState),	\
			(QStreamInfoResult_writeState), &((structAddr)->writeState),	\
			(QStreamInfoResult_readers), &((structAddr)->readers),	\
			(QStreamInfoResult_theReader), &((structAddr)->theReader),	\
			(QStreamInfoResult_theWriter), &((structAddr)->theWriter),	\
			(QStreamInfoResult_bufCount), &((structAddr)->bufCount))


#define QStreamInfoResult_put(msgPtr, structAddr, offset)	\
		    qMsgVarFieldPut((msgPtr), 7, &(offset),	\
			(QStreamInfoResult_id), &((structAddr)->id),	\
			(QStreamInfoResult_readState), &((structAddr)->readState),	\
			(QStreamInfoResult_writeState), &((structAddr)->writeState),	\
			(QStreamInfoResult_readers), &((structAddr)->readers),	\
			(QStreamInfoResult_theReader), &((structAddr)->theReader),	\
			(QStreamInfoResult_theWriter), &((structAddr)->theWriter),	\
			(QStreamInfoResult_bufCount), &((structAddr)->bufCount))


#define QStreamInfoResult_Size		22

#define QStreamInfoResult	0x800011	/* 8388625 */
/* Stream Reference Response */

#define QStreamRefResult_streamReference	0x700000	/* 7340032 */
typedef	QStreamRef	QStreamRefResult_streamReference_t;

/*
 * QStreamRefResult (value = 0x800012) is a message of generic use.
 */


typedef struct {
	QStreamRef	streamReference;
} QStreamRefResult_t;

#define QStreamRefResult_get(msgPtr, structAddr, offset)	\
		    qMsgVarFieldGet((msgPtr), 1, &(offset),	\
			(QStreamRefResult_streamReference), &((structAddr)->streamReference))


#define QStreamRefResult_put(msgPtr, structAddr, offset)	\
		    qMsgVarFieldPut((msgPtr), 1, &(offset),	\
			(QStreamRefResult_streamReference), &((structAddr)->streamReference))


#define QStreamRefResult_Size		11

#define QStreamRefResult	0x800012	/* 8388626 */
/* Stream Identifier Response */

#define QStreamResult_id	0x280000	/* 2621440 */
typedef	UInt16	QStreamResult_id_t;

/*
 * QStreamResult (value = 0x800013) is a message of generic use.
 */


typedef struct {
	UInt16	id;
} QStreamResult_t;

#define QStreamResult_get(msgPtr, structAddr, offset)	\
		    qMsgVarFieldGet((msgPtr), 1, &(offset),	\
			(QStreamResult_id), &((structAddr)->id))


#define QStreamResult_put(msgPtr, structAddr, offset)	\
		    qMsgVarFieldPut((msgPtr), 1, &(offset),	\
			(QStreamResult_id), &((structAddr)->id))


#define QStreamResult_Size		2

#define QStreamResult	0x800013	/* 8388627 */
/* Notification of attribute registration */
/* To Be Defined */

#define QCompAttrNotify_dummy_for_now	0x200000	/* 2097152 */
typedef	UInt8	QCompAttrNotify_dummy_for_now_t;

/*
 * QCompAttrNotify (value = 0x800014) is a message of generic use.
 */


typedef struct {
	UInt8	dummy_for_now;
} QCompAttrNotify_t;

#define QCompAttrNotify_get(msgPtr, structAddr, offset)	\
		    qMsgVarFieldGet((msgPtr), 1, &(offset),	\
			(QCompAttrNotify_dummy_for_now), &((structAddr)->dummy_for_now))


#define QCompAttrNotify_put(msgPtr, structAddr, offset)	\
		    qMsgVarFieldPut((msgPtr), 1, &(offset),	\
			(QCompAttrNotify_dummy_for_now), &((structAddr)->dummy_for_now))


#define QCompAttrNotify_Size		1

#define QCompAttrNotify	0x800014	/* 8388628 */
/* Notification of instance allocation acknowledgement */

#define QCompInstNotifyAck_notifyDesc	0x800000	/* 8388608 */
typedef	QCompDesc	QCompInstNotifyAck_notifyDesc_t;

#define QCompInstNotifyAck_operation_allocate	0	/* 0 */

#define QCompInstNotifyAck_operation_free	0x1	/* 1 */

#define QCompInstNotifyAck_operation_reserve	0x2	/* 2 */

#define QCompInstNotifyAck_operation_release	0x3	/* 3 */

#define QCompInstNotifyAck_operation_lock	0x4	/* 4 */

#define QCompInstNotifyAck_operation_unlock	0x5	/* 5 */

#define QCompInstNotifyAck_operation	0x300006	/* 3145734 */
typedef	UInt24	QCompInstNotifyAck_operation_t;

/*
 * QCompInstNotifyAck (value = 0x800015) is a message of generic use.
 */


typedef struct {
	QCompDesc	notifyDesc;
	UInt24	operation;
} QCompInstNotifyAck_t;

#define QCompInstNotifyAck_get(msgPtr, structAddr, offset)	\
		    qMsgVarFieldGet((msgPtr), 2, &(offset),	\
			(QCompInstNotifyAck_notifyDesc), &((structAddr)->notifyDesc),	\
			(QCompInstNotifyAck_operation), &((structAddr)->operation))


#define QCompInstNotifyAck_put(msgPtr, structAddr, offset)	\
		    qMsgVarFieldPut((msgPtr), 2, &(offset),	\
			(QCompInstNotifyAck_notifyDesc), &((structAddr)->notifyDesc),	\
			(QCompInstNotifyAck_operation), &((structAddr)->operation))


#define QCompInstNotifyAck_Size		9

#define QCompInstNotifyAck	0x800015	/* 8388629 */
/* Notification of instance allocatiuon */

#define QCompInstNotify_operation_allocate	0x6	/* 6 */

#define QCompInstNotify_operation_free	0x7	/* 7 */

#define QCompInstNotify_operation_reserve	0x8	/* 8 */

#define QCompInstNotify_operation_release	0x9	/* 9 */

#define QCompInstNotify_operation_lock	0xa	/* 10 */

#define QCompInstNotify_operation_unlock	0xb	/* 11 */

#define QCompInstNotify_operation	0x300000	/* 3145728 */
typedef	UInt24	QCompInstNotify_operation_t;

#define QCompInstNotify_count	0x300003	/* 3145731 */
typedef	UInt24	QCompInstNotify_count_t;

#define QCompInstNotify_varStart	0x6

#define QCompInstNotify_attr	0x780000	/* 7864320 */
typedef	QCompAttr	QCompInstNotify_attr_t;

/*
 * QCompInstNotify (value = 0x800016) is a message of generic use.
 */


typedef struct {
	UInt24	operation;
	UInt24	count;
} QCompInstNotify_t;

#define QCompInstNotify_get(msgPtr, structAddr, offset)	\
		    qMsgVarFieldGet((msgPtr), 2, &(offset),	\
			(QCompInstNotify_operation), &((structAddr)->operation),	\
			(QCompInstNotify_count), &((structAddr)->count))


#define QCompInstNotify_put(msgPtr, structAddr, offset)	\
		    qMsgVarFieldPut((msgPtr), 2, &(offset),	\
			(QCompInstNotify_operation), &((structAddr)->operation),	\
			(QCompInstNotify_count), &((structAddr)->count))


#define QCompInstNotify_Size		6

#define QCompInstNotify	0x800016	/* 8388630 */
/* Create component instances*/

#define QCompInstCreate_count	0x300000	/* 3145728 */
typedef	UInt24	QCompInstCreate_count_t;

/*
 * QCompInstCreate (value = 0x800017) is a message of generic use.
 */


typedef struct {
	UInt24	count;
} QCompInstCreate_t;

#define QCompInstCreate_get(msgPtr, structAddr, offset)	\
		    qMsgVarFieldGet((msgPtr), 1, &(offset),	\
			(QCompInstCreate_count), &((structAddr)->count))


#define QCompInstCreate_put(msgPtr, structAddr, offset)	\
		    qMsgVarFieldPut((msgPtr), 1, &(offset),	\
			(QCompInstCreate_count), &((structAddr)->count))


#define QCompInstCreate_Size		3

#define QCompInstCreate	0x800017	/* 8388631 */
/* Response to create component instances request*/

#define QCompInstCreateResult_result_success	0xc	/* 12 */

#define QCompInstCreateResult_result_failure	0xd	/* 13 */

#define QCompInstCreateResult_result	0x380000	/* 3670016 */
typedef	UInt32	QCompInstCreateResult_result_t;

#define QCompInstCreateResult_firstInstance	0x800004	/* 8388612 */
typedef	QCompDesc	QCompInstCreateResult_firstInstance_t;

/*
 * QCompInstCreateResult (value = 0x800018) is a message of generic use.
 */


typedef struct {
	UInt32	result;
	QCompDesc	firstInstance;
} QCompInstCreateResult_t;

#define QCompInstCreateResult_get(msgPtr, structAddr, offset)	\
		    qMsgVarFieldGet((msgPtr), 2, &(offset),	\
			(QCompInstCreateResult_result), &((structAddr)->result),	\
			(QCompInstCreateResult_firstInstance), &((structAddr)->firstInstance))


#define QCompInstCreateResult_put(msgPtr, structAddr, offset)	\
		    qMsgVarFieldPut((msgPtr), 2, &(offset),	\
			(QCompInstCreateResult_result), &((structAddr)->result),	\
			(QCompInstCreateResult_firstInstance), &((structAddr)->firstInstance))


#define QCompInstCreateResult_Size		10

#define QCompInstCreateResult	0x800018	/* 8388632 */
/* Component configuration complete, start operation */
/* Notification of child task exit */

/*
 * QCompStart (value = 0x800019) is a message of generic use.
 */

#define QCompStart_Size		0

#define QCompStart	0x800019	/* 8388633 */

#define QTaskChildExit_id	0x300000	/* 3145728 */
typedef	UInt24	QTaskChildExit_id_t;

#define QTaskChildExit_exitCode	0x300003	/* 3145731 */
typedef	UInt24	QTaskChildExit_exitCode_t;

/*
 * QTaskChildExit (value = 0x80001a) is a message of generic use.
 */


typedef struct {
	UInt24	id;
	UInt24	exitCode;
} QTaskChildExit_t;

#define QTaskChildExit_get(msgPtr, structAddr, offset)	\
		    qMsgVarFieldGet((msgPtr), 2, &(offset),	\
			(QTaskChildExit_id), &((structAddr)->id),	\
			(QTaskChildExit_exitCode), &((structAddr)->exitCode))


#define QTaskChildExit_put(msgPtr, structAddr, offset)	\
		    qMsgVarFieldPut((msgPtr), 2, &(offset),	\
			(QTaskChildExit_id), &((structAddr)->id),	\
			(QTaskChildExit_exitCode), &((structAddr)->exitCode))


#define QTaskChildExit_Size		6

#define QTaskChildExit	0x80001a	/* 8388634 */

/**********************************************************************/
/****** RE_DEFINE QTASKCHILDEXIT MACRO TO USE LOCAL MESSAGES **********/
/**********************************************************************/


/* make sure no-one undoes this change by re-making mmdl */

#define QTaskChildExitMessageIsLocal 
/*will cause syntax error if not present */
#undef QTaskChildExit_get
#undef QTaskChildExit_put
#undef QTaskChildExit_id
#undef QTaskChildExit_exitCode

#define QTaskChildExit_get(msgPtr, structAddr, offset) \
{ \
QTaskChildExit_t *pTaskChildExitBody; \
pTaskChildExitBody = (QTaskChildExit_t *)((*(msgPtr)).data); \
(*(structAddr)).id = (*pTaskChildExitBody).id; \
(*(structAddr)).exitCode = (*pTaskChildExitBody).exitCode; \
}

/* Activate an output port in a cluster. */

#define QCLUST_AskTalker	0x01	/* Send talker protocol messages to talker       */
#define QCLUST_AutoReject	0x02	/* Automatically reject QClusterSuspend requests */
#define QCLUST_AutoAccept	0x03	/* Automatically accept QClusterSuspend requests */

/* The instance that owns the port */

#define QClusterActivate_instDesc	0x800000	/* 8388608 */
typedef	QCompDesc	QClusterActivate_instDesc_t;
/* Port to activate */

#define QClusterActivate_portId	0x300006	/* 3145734 */
typedef	UInt24	QClusterActivate_portId_t;
/* Activation options */

#define QClusterActivate_options	0x200009	/* 2097161 */
typedef	UInt8	QClusterActivate_options_t;
/* Talker protocol handler */

#define QClusterActivate_talkerDesc	0x80000a	/* 8388618 */
typedef	QCompDesc	QClusterActivate_talkerDesc_t;

/*
 * QClusterActivate (value = 0x80001b) is an input message of generic use.
 */


typedef struct {
	QCompDesc	instDesc;
	UInt24	portId;
	UInt8	options;
	QCompDesc	talkerDesc;
} QClusterActivate_t;

#define QClusterActivate_get(msgPtr, structAddr, offset)	\
		    qMsgVarFieldGet((msgPtr), 4, &(offset),	\
			(QClusterActivate_instDesc), &((structAddr)->instDesc),	\
			(QClusterActivate_portId), &((structAddr)->portId),	\
			(QClusterActivate_options), &((structAddr)->options),	\
			(QClusterActivate_talkerDesc), &((structAddr)->talkerDesc))


#define QClusterActivate_put(msgPtr, structAddr, offset)	\
		    qMsgVarFieldPut((msgPtr), 4, &(offset),	\
			(QClusterActivate_instDesc), &((structAddr)->instDesc),	\
			(QClusterActivate_portId), &((structAddr)->portId),	\
			(QClusterActivate_options), &((structAddr)->options),	\
			(QClusterActivate_talkerDesc), &((structAddr)->talkerDesc))


#define QClusterActivate_Size		16

#define QClusterActivate	0x80001b	/* 8388635 */
/* Tell a cluster that it's input data stream is active. */
/* port user type			*/

#define QClusterActive_portId_userType	0x200000	/* 2097152 */
typedef	UInt8	QClusterActive_portId_userType_t;
/* stream type, MMA, NET, SCBUS	*/

#define QClusterActive_portId_streamType	0x200001	/* 2097153 */
typedef	UInt8	QClusterActive_portId_streamType_t;
/* stream direction			*/

#define QClusterActive_portId_streamDir	0x200002	/* 2097154 */
typedef	UInt8	QClusterActive_portId_streamDir_t;
/* port instance			*/

#define QClusterActive_portId_instance	0x200003	/* 2097155 */
typedef	UInt8	QClusterActive_portId_instance_t;


typedef struct {
	UInt8	userType;
	UInt8	streamType;
	UInt8	streamDir;
	UInt8	instance;
} QClusterActive_portId_t;

#define QClusterActive_portId_get(msgPtr, structAddr, offset)	\
		    qMsgVarFieldGet((msgPtr), 4, &(offset),	\
			(QClusterActive_portId_userType), &((structAddr)->userType),	\
			(QClusterActive_portId_streamType), &((structAddr)->streamType),	\
			(QClusterActive_portId_streamDir), &((structAddr)->streamDir),	\
			(QClusterActive_portId_instance), &((structAddr)->instance))


#define QClusterActive_portId_put(msgPtr, structAddr, offset)	\
		    qMsgVarFieldPut((msgPtr), 4, &(offset),	\
			(QClusterActive_portId_userType), &((structAddr)->userType),	\
			(QClusterActive_portId_streamType), &((structAddr)->streamType),	\
			(QClusterActive_portId_streamDir), &((structAddr)->streamDir),	\
			(QClusterActive_portId_instance), &((structAddr)->instance))


#define QClusterActive_portId_Size		4

#define QClusterActive_portId	0	/* 0 */

/*
 * QClusterActive (value = 0x80001c) is an input message of generic use.
 */


typedef struct {
	QClusterActive_portId_t	QClusterActive_portId_i;
} QClusterActive_t;

#define QClusterActive_get(msgPtr, structAddr, offset)	\
		    QClusterActive_portId_get(msgPtr, &((structAddr)->QClusterActive_portId_i), offset)


#define QClusterActive_put(msgPtr, structAddr, offset)	\
		    QClusterActive_portId_put(msgPtr, &((structAddr)->QClusterActive_portId_i), offset)


#define QClusterActive_Size		4

#define QClusterActive	0x80001c	/* 8388636 */
/* Finds the cluster that the specified component instance belongs to. */
/* The component instance		*/

#define QClusterByComp_instDesc	0x800000	/* 8388608 */
typedef	QCompDesc	QClusterByComp_instDesc_t;

/*
 * QClusterByComp (value = 0x80001d) is an input message of generic use.
 */


typedef struct {
	QCompDesc	instDesc;
} QClusterByComp_t;

#define QClusterByComp_get(msgPtr, structAddr, offset)	\
		    qMsgVarFieldGet((msgPtr), 1, &(offset),	\
			(QClusterByComp_instDesc), &((structAddr)->instDesc))


#define QClusterByComp_put(msgPtr, structAddr, offset)	\
		    qMsgVarFieldPut((msgPtr), 1, &(offset),	\
			(QClusterByComp_instDesc), &((structAddr)->instDesc))


#define QClusterByComp_Size		6

#define QClusterByComp	0x80001d	/* 8388637 */
/* Finds the component instance with the specified attributes in a cluster 
 * instance. */
/* The cluster instance			*/

#define QClusterCompByAttr_clustDesc	0x800000	/* 8388608 */
typedef	QCompDesc	QClusterCompByAttr_clustDesc_t;
/* Component type				*/

#define QClusterCompByAttr_compType	0x200006	/* 2097158 */
typedef	UInt8	QClusterCompByAttr_compType_t;
/* Number of attributes in list		*/

#define QClusterCompByAttr_count	0x200007	/* 2097159 */
typedef	UInt8	QClusterCompByAttr_count_t;

#define QClusterCompByAttr_varStart	0x8
/* Attribute descriptor			*/

#define QClusterCompByAttr_attr	0x780000	/* 7864320 */
typedef	QCompAttr	QClusterCompByAttr_attr_t;

/*
 * QClusterCompByAttr (value = 0x80001e) is an input message of generic use.
 */


typedef struct {
	QCompDesc	clustDesc;
	UInt8	compType;
	UInt8	count;
} QClusterCompByAttr_t;

#define QClusterCompByAttr_get(msgPtr, structAddr, offset)	\
		    qMsgVarFieldGet((msgPtr), 3, &(offset),	\
			(QClusterCompByAttr_clustDesc), &((structAddr)->clustDesc),	\
			(QClusterCompByAttr_compType), &((structAddr)->compType),	\
			(QClusterCompByAttr_count), &((structAddr)->count))


#define QClusterCompByAttr_put(msgPtr, structAddr, offset)	\
		    qMsgVarFieldPut((msgPtr), 3, &(offset),	\
			(QClusterCompByAttr_clustDesc), &((structAddr)->clustDesc),	\
			(QClusterCompByAttr_compType), &((structAddr)->compType),	\
			(QClusterCompByAttr_count), &((structAddr)->count))


#define QClusterCompByAttr_Size		8

#define QClusterCompByAttr	0x80001e	/* 8388638 */
/* Connect the ports of two cluster instances together  */
/* Cluster to connect to clustDesc2	*/

#define QClusterConnect_clustDesc1	0x800000	/* 8388608 */
typedef	QCompDesc	QClusterConnect_clustDesc1_t;
/* Port to connect to portId2		*/

#define QClusterConnect_portId1	0x300006	/* 3145734 */
typedef	UInt24	QClusterConnect_portId1_t;
/* Cluster to connect to clustDesc1	*/

#define QClusterConnect_clustDesc2	0x800009	/* 8388617 */
typedef	QCompDesc	QClusterConnect_clustDesc2_t;
/* Port to connect to portId1		*/

#define QClusterConnect_portId2	0x30000f	/* 3145743 */
typedef	UInt24	QClusterConnect_portId2_t;

/*
 * QClusterConnect (value = 0x80001f) is an input message of generic use.
 */


typedef struct {
	QCompDesc	clustDesc1;
	UInt24	portId1;
	QCompDesc	clustDesc2;
	UInt24	portId2;
} QClusterConnect_t;

#define QClusterConnect_get(msgPtr, structAddr, offset)	\
		    qMsgVarFieldGet((msgPtr), 4, &(offset),	\
			(QClusterConnect_clustDesc1), &((structAddr)->clustDesc1),	\
			(QClusterConnect_portId1), &((structAddr)->portId1),	\
			(QClusterConnect_clustDesc2), &((structAddr)->clustDesc2),	\
			(QClusterConnect_portId2), &((structAddr)->portId2))


#define QClusterConnect_put(msgPtr, structAddr, offset)	\
		    qMsgVarFieldPut((msgPtr), 4, &(offset),	\
			(QClusterConnect_clustDesc1), &((structAddr)->clustDesc1),	\
			(QClusterConnect_portId1), &((structAddr)->portId1),	\
			(QClusterConnect_clustDesc2), &((structAddr)->clustDesc2),	\
			(QClusterConnect_portId2), &((structAddr)->portId2))


#define QClusterConnect_Size		18

#define QClusterConnect	0x80001f	/* 8388639 */
/* Create a component cluster  */
/* Find the C-Streams associated with a port. */

/*
 * QClusterCreate (value = 0x800020) is an input message of generic use.
 */

#define QClusterCreate_Size		0

#define QClusterCreate	0x800020	/* 8388640 */
/* the cluster that owns the port	*/

#define QClusterCStreamInfo_clustDesc	0x800000	/* 8388608 */
typedef	QCompDesc	QClusterCStreamInfo_clustDesc_t;
/* Port that owns the C-Streams	*/

#define QClusterCStreamInfo_portId	0x300006	/* 3145734 */
typedef	UInt24	QClusterCStreamInfo_portId_t;

/*
 * QClusterCStreamInfo (value = 0x800021) is an input message of generic use.
 */


typedef struct {
	QCompDesc	clustDesc;
	UInt24	portId;
} QClusterCStreamInfo_t;

#define QClusterCStreamInfo_get(msgPtr, structAddr, offset)	\
		    qMsgVarFieldGet((msgPtr), 2, &(offset),	\
			(QClusterCStreamInfo_clustDesc), &((structAddr)->clustDesc),	\
			(QClusterCStreamInfo_portId), &((structAddr)->portId))


#define QClusterCStreamInfo_put(msgPtr, structAddr, offset)	\
		    qMsgVarFieldPut((msgPtr), 2, &(offset),	\
			(QClusterCStreamInfo_clustDesc), &((structAddr)->clustDesc),	\
			(QClusterCStreamInfo_portId), &((structAddr)->portId))


#define QClusterCStreamInfo_Size		9

#define QClusterCStreamInfo	0x800021	/* 8388641 */
/* Reports the C-Streams associated with a port. */
/* the cluster that owns the ports	*/

#define QClusterCStreamResult_clustDesc	0x800000	/* 8388608 */
typedef	QCompDesc	QClusterCStreamResult_clustDesc_t;
/* the port that owns the C-Streams	*/

#define QClusterCStreamResult_portId	0x300006	/* 3145734 */
typedef	UInt24	QClusterCStreamResult_portId_t;
/* Number of C-Streams in the port	*/

#define QClusterCStreamResult_count	0x200009	/* 2097161 */
typedef	UInt8	QClusterCStreamResult_count_t;

#define QClusterCStreamResult_varStart	0xa
/* List of C-Stream references	*/

#define QClusterCStreamResult_streamRef	0x380000	/* 3670016 */
typedef	UInt32	QClusterCStreamResult_streamRef_t;

/*
 * QClusterCStreamResult (value = 0x800022) is an output message of generic use.
 */


typedef struct {
	QCompDesc	clustDesc;
	UInt24	portId;
	UInt8	count;
} QClusterCStreamResult_t;

#define QClusterCStreamResult_get(msgPtr, structAddr, offset)	\
		    qMsgVarFieldGet((msgPtr), 3, &(offset),	\
			(QClusterCStreamResult_clustDesc), &((structAddr)->clustDesc),	\
			(QClusterCStreamResult_portId), &((structAddr)->portId),	\
			(QClusterCStreamResult_count), &((structAddr)->count))


#define QClusterCStreamResult_put(msgPtr, structAddr, offset)	\
		    qMsgVarFieldPut((msgPtr), 3, &(offset),	\
			(QClusterCStreamResult_clustDesc), &((structAddr)->clustDesc),	\
			(QClusterCStreamResult_portId), &((structAddr)->portId),	\
			(QClusterCStreamResult_count), &((structAddr)->count))


#define QClusterCStreamResult_Size		10

#define QClusterCStreamResult	0x800022	/* 8388642 */
/* Deactivate an output port in a cluster. */
/* The cluster that owns the port	*/

#define QClusterDeactivate_clustDesc	0x800000	/* 8388608 */
typedef	QCompDesc	QClusterDeactivate_clustDesc_t;
/* Port description			*/

#define QClusterDeactivate_portId	0x300006	/* 3145734 */
typedef	UInt24	QClusterDeactivate_portId_t;

/*
 * QClusterDeactivate (value = 0x800023) is an input message of generic use.
 */


typedef struct {
	QCompDesc	clustDesc;
	UInt24	portId;
} QClusterDeactivate_t;

#define QClusterDeactivate_get(msgPtr, structAddr, offset)	\
		    qMsgVarFieldGet((msgPtr), 2, &(offset),	\
			(QClusterDeactivate_clustDesc), &((structAddr)->clustDesc),	\
			(QClusterDeactivate_portId), &((structAddr)->portId))


#define QClusterDeactivate_put(msgPtr, structAddr, offset)	\
		    qMsgVarFieldPut((msgPtr), 2, &(offset),	\
			(QClusterDeactivate_clustDesc), &((structAddr)->clustDesc),	\
			(QClusterDeactivate_portId), &((structAddr)->portId))


#define QClusterDeactivate_Size		9

#define QClusterDeactivate	0x800023	/* 8388643 */
/* Destroy a component cluster  */
/* The cluster to destroy */

#define QClusterDestroy_clustDesc	0x800000	/* 8388608 */
typedef	QCompDesc	QClusterDestroy_clustDesc_t;

/*
 * QClusterDestroy (value = 0x800024) is an input message of generic use.
 */


typedef struct {
	QCompDesc	clustDesc;
} QClusterDestroy_t;

#define QClusterDestroy_get(msgPtr, structAddr, offset)	\
		    qMsgVarFieldGet((msgPtr), 1, &(offset),	\
			(QClusterDestroy_clustDesc), &((structAddr)->clustDesc))


#define QClusterDestroy_put(msgPtr, structAddr, offset)	\
		    qMsgVarFieldPut((msgPtr), 1, &(offset),	\
			(QClusterDestroy_clustDesc), &((structAddr)->clustDesc))


#define QClusterDestroy_Size		6

#define QClusterDestroy	0x800024	/* 8388644 */
/* Breaks a connection between the ports of two cluster instances. */
/* Cluster that owns port 1.		*/

#define QClusterDisconnect_clustDesc1	0x800000	/* 8388608 */
typedef	QCompDesc	QClusterDisconnect_clustDesc1_t;
/* Port to disconnect in cluster 1.	*/

#define QClusterDisconnect_portId1	0x300006	/* 3145734 */
typedef	UInt24	QClusterDisconnect_portId1_t;
/* Cluster that owns port 2.		*/

#define QClusterDisconnect_clustDesc2	0x800009	/* 8388617 */
typedef	QCompDesc	QClusterDisconnect_clustDesc2_t;
/* Port to disconnect in cluster 2.	*/

#define QClusterDisconnect_portId2	0x30000f	/* 3145743 */
typedef	UInt24	QClusterDisconnect_portId2_t;

/*
 * QClusterDisconnect (value = 0x800025) is an input message of generic use.
 */


typedef struct {
	QCompDesc	clustDesc1;
	UInt24	portId1;
	QCompDesc	clustDesc2;
	UInt24	portId2;
} QClusterDisconnect_t;

#define QClusterDisconnect_get(msgPtr, structAddr, offset)	\
		    qMsgVarFieldGet((msgPtr), 4, &(offset),	\
			(QClusterDisconnect_clustDesc1), &((structAddr)->clustDesc1),	\
			(QClusterDisconnect_portId1), &((structAddr)->portId1),	\
			(QClusterDisconnect_clustDesc2), &((structAddr)->clustDesc2),	\
			(QClusterDisconnect_portId2), &((structAddr)->portId2))


#define QClusterDisconnect_put(msgPtr, structAddr, offset)	\
		    qMsgVarFieldPut((msgPtr), 4, &(offset),	\
			(QClusterDisconnect_clustDesc1), &((structAddr)->clustDesc1),	\
			(QClusterDisconnect_portId1), &((structAddr)->portId1),	\
			(QClusterDisconnect_clustDesc2), &((structAddr)->clustDesc2),	\
			(QClusterDisconnect_portId2), &((structAddr)->portId2))


#define QClusterDisconnect_Size		18

#define QClusterDisconnect	0x800025	/* 8388645 */
/* Tell a cluster that it's input data stream is no longer active. */
/* port user type			*/

#define QClusterInactive_portId_userType	0x200000	/* 2097152 */
typedef	UInt8	QClusterInactive_portId_userType_t;
/* stream type, MMA, NET, SCBUS	*/

#define QClusterInactive_portId_streamType	0x200001	/* 2097153 */
typedef	UInt8	QClusterInactive_portId_streamType_t;
/* stream direction			*/

#define QClusterInactive_portId_streamDir	0x200002	/* 2097154 */
typedef	UInt8	QClusterInactive_portId_streamDir_t;
/* port instance			*/

#define QClusterInactive_portId_instance	0x200003	/* 2097155 */
typedef	UInt8	QClusterInactive_portId_instance_t;


typedef struct {
	UInt8	userType;
	UInt8	streamType;
	UInt8	streamDir;
	UInt8	instance;
} QClusterInactive_portId_t;

#define QClusterInactive_portId_get(msgPtr, structAddr, offset)	\
		    qMsgVarFieldGet((msgPtr), 4, &(offset),	\
			(QClusterInactive_portId_userType), &((structAddr)->userType),	\
			(QClusterInactive_portId_streamType), &((structAddr)->streamType),	\
			(QClusterInactive_portId_streamDir), &((structAddr)->streamDir),	\
			(QClusterInactive_portId_instance), &((structAddr)->instance))


#define QClusterInactive_portId_put(msgPtr, structAddr, offset)	\
		    qMsgVarFieldPut((msgPtr), 4, &(offset),	\
			(QClusterInactive_portId_userType), &((structAddr)->userType),	\
			(QClusterInactive_portId_streamType), &((structAddr)->streamType),	\
			(QClusterInactive_portId_streamDir), &((structAddr)->streamDir),	\
			(QClusterInactive_portId_instance), &((structAddr)->instance))


#define QClusterInactive_portId_Size		4

#define QClusterInactive_portId	0x1	/* 1 */

/*
 * QClusterInactive (value = 0x800026) is an input message of generic use.
 */


typedef struct {
	QClusterInactive_portId_t	QClusterInactive_portId_i;
} QClusterInactive_t;

#define QClusterInactive_get(msgPtr, structAddr, offset)	\
		    QClusterInactive_portId_get(msgPtr, &((structAddr)->QClusterInactive_portId_i), offset)


#define QClusterInactive_put(msgPtr, structAddr, offset)	\
		    QClusterInactive_portId_put(msgPtr, &((structAddr)->QClusterInactive_portId_i), offset)


#define QClusterInactive_Size		4

#define QClusterInactive	0x800026	/* 8388646 */
/* Find the component instances in a cluster. */
/* the cluster that owns the ports	*/

#define QClusterCompInfo_clustDesc	0x800000	/* 8388608 */
typedef	QCompDesc	QClusterCompInfo_clustDesc_t;

/*
 * QClusterCompInfo (value = 0x800027) is an input message of generic use.
 */


typedef struct {
	QCompDesc	clustDesc;
} QClusterCompInfo_t;

#define QClusterCompInfo_get(msgPtr, structAddr, offset)	\
		    qMsgVarFieldGet((msgPtr), 1, &(offset),	\
			(QClusterCompInfo_clustDesc), &((structAddr)->clustDesc))


#define QClusterCompInfo_put(msgPtr, structAddr, offset)	\
		    qMsgVarFieldPut((msgPtr), 1, &(offset),	\
			(QClusterCompInfo_clustDesc), &((structAddr)->clustDesc))


#define QClusterCompInfo_Size		6

#define QClusterCompInfo	0x800027	/* 8388647 */
/* Reports the component instances owned by a cluster. */
/* the cluster that owns the ports		*/

#define QClusterCompInfoResult_clustDesc	0x800000	/* 8388608 */
typedef	QCompDesc	QClusterCompInfoResult_clustDesc_t;
/* the number of ports in the body		*/

#define QClusterCompInfoResult_count	0x200006	/* 2097158 */
typedef	UInt8	QClusterCompInfoResult_count_t;

#define QClusterCompInfoResult_varStart	0x7
/* list of component instance descriptors		*/

#define QClusterCompInfoResult_instDesc	0x800000	/* 8388608 */
typedef	QCompDesc	QClusterCompInfoResult_instDesc_t;

/*
 * QClusterCompInfoResult (value = 0x800028) is an output message of generic use.
 */


typedef struct {
	QCompDesc	clustDesc;
	UInt8	count;
} QClusterCompInfoResult_t;

#define QClusterCompInfoResult_get(msgPtr, structAddr, offset)	\
		    qMsgVarFieldGet((msgPtr), 2, &(offset),	\
			(QClusterCompInfoResult_clustDesc), &((structAddr)->clustDesc),	\
			(QClusterCompInfoResult_count), &((structAddr)->count))


#define QClusterCompInfoResult_put(msgPtr, structAddr, offset)	\
		    qMsgVarFieldPut((msgPtr), 2, &(offset),	\
			(QClusterCompInfoResult_clustDesc), &((structAddr)->clustDesc),	\
			(QClusterCompInfoResult_count), &((structAddr)->count))


#define QClusterCompInfoResult_Size		7

#define QClusterCompInfoResult	0x800028	/* 8388648 */
/* Find the ports owned by a cluster. */
/* the cluster that owns the ports	*/

#define QClusterPortInfo_clustDesc	0x800000	/* 8388608 */
typedef	QCompDesc	QClusterPortInfo_clustDesc_t;

/*
 * QClusterPortInfo (value = 0x800029) is an input message of generic use.
 */


typedef struct {
	QCompDesc	clustDesc;
} QClusterPortInfo_t;

#define QClusterPortInfo_get(msgPtr, structAddr, offset)	\
		    qMsgVarFieldGet((msgPtr), 1, &(offset),	\
			(QClusterPortInfo_clustDesc), &((structAddr)->clustDesc))


#define QClusterPortInfo_put(msgPtr, structAddr, offset)	\
		    qMsgVarFieldPut((msgPtr), 1, &(offset),	\
			(QClusterPortInfo_clustDesc), &((structAddr)->clustDesc))


#define QClusterPortInfo_Size		6

#define QClusterPortInfo	0x800029	/* 8388649 */
/* Reports the ports owned by a cluster. */
/* the cluster that owns the ports	*/

#define QClusterPortInfoResult_clustDesc	0x800000	/* 8388608 */
typedef	QCompDesc	QClusterPortInfoResult_clustDesc_t;
/* the number of ports in the body	*/

#define QClusterPortInfoResult_count	0x200006	/* 2097158 */
typedef	UInt8	QClusterPortInfoResult_count_t;

#define QClusterPortInfoResult_varStart	0x7
/* list of port identifers		*/

#define QClusterPortInfoResult_portId	0x300000	/* 3145728 */
typedef	UInt24	QClusterPortInfoResult_portId_t;

/*
 * QClusterPortInfoResult (value = 0x80002a) is an output message of generic use.
 */


typedef struct {
	QCompDesc	clustDesc;
	UInt8	count;
} QClusterPortInfoResult_t;

#define QClusterPortInfoResult_get(msgPtr, structAddr, offset)	\
		    qMsgVarFieldGet((msgPtr), 2, &(offset),	\
			(QClusterPortInfoResult_clustDesc), &((structAddr)->clustDesc),	\
			(QClusterPortInfoResult_count), &((structAddr)->count))


#define QClusterPortInfoResult_put(msgPtr, structAddr, offset)	\
		    qMsgVarFieldPut((msgPtr), 2, &(offset),	\
			(QClusterPortInfoResult_clustDesc), &((structAddr)->clustDesc),	\
			(QClusterPortInfoResult_count), &((structAddr)->count))


#define QClusterPortInfoResult_Size		7

#define QClusterPortInfoResult	0x80002a	/* 8388650 */
/* Registers a client connection service with the Cluster Connection Manager.  */
/* Address of the service provider	*/

#define QClusterRegisterService_serviceDesc	0x800000	/* 8388608 */
typedef	QCompDesc	QClusterRegisterService_serviceDesc_t;
/* The type of service provided 	*/

#define QClusterRegisterService_serviceType	0x380006	/* 3670022 */
typedef	UInt32	QClusterRegisterService_serviceType_t;

/*
 * QClusterRegisterService (value = 0x80002b) is an input message of generic use.
 */


typedef struct {
	QCompDesc	serviceDesc;
	UInt32	serviceType;
} QClusterRegisterService_t;

#define QClusterRegisterService_get(msgPtr, structAddr, offset)	\
		    qMsgVarFieldGet((msgPtr), 2, &(offset),	\
			(QClusterRegisterService_serviceDesc), &((structAddr)->serviceDesc),	\
			(QClusterRegisterService_serviceType), &((structAddr)->serviceType))


#define QClusterRegisterService_put(msgPtr, structAddr, offset)	\
		    qMsgVarFieldPut((msgPtr), 2, &(offset),	\
			(QClusterRegisterService_serviceDesc), &((structAddr)->serviceDesc),	\
			(QClusterRegisterService_serviceType), &((structAddr)->serviceType))


#define QClusterRegisterService_Size		10

#define QClusterRegisterService	0x80002b	/* 8388651 */
/* Component Description Response */

#define QClusterResult_desc	0x800000	/* 8388608 */
typedef	QCompDesc	QClusterResult_desc_t;

/*
 * QClusterResult (value = 0x80002c) is an output message of generic use.
 */


typedef struct {
	QCompDesc	desc;
} QClusterResult_t;

#define QClusterResult_get(msgPtr, structAddr, offset)	\
		    qMsgVarFieldGet((msgPtr), 1, &(offset),	\
			(QClusterResult_desc), &((structAddr)->desc))


#define QClusterResult_put(msgPtr, structAddr, offset)	\
		    qMsgVarFieldPut((msgPtr), 1, &(offset),	\
			(QClusterResult_desc), &((structAddr)->desc))


#define QClusterResult_Size		6

#define QClusterResult	0x80002c	/* 8388652 */
/* Ask a cluster to resume its data transmission from an output port */
/* Port to resume			*/

#define QClusterResume_portId	0x300000	/* 3145728 */
typedef	UInt24	QClusterResume_portId_t;

/*
 * QClusterResume (value = 0x80002d) is an output message of generic use.
 */


typedef struct {
	UInt24	portId;
} QClusterResume_t;

#define QClusterResume_get(msgPtr, structAddr, offset)	\
		    qMsgVarFieldGet((msgPtr), 1, &(offset),	\
			(QClusterResume_portId), &((structAddr)->portId))


#define QClusterResume_put(msgPtr, structAddr, offset)	\
		    qMsgVarFieldPut((msgPtr), 1, &(offset),	\
			(QClusterResume_portId), &((structAddr)->portId))


#define QClusterResume_Size		3

#define QClusterResume	0x80002d	/* 8388653 */
/* Sent by instance in response to QClusterSuspend request */
/* Response to the request	*/

#define QClusterResumeResult_response	0x200000	/* 2097152 */
typedef	UInt8	QClusterResumeResult_response_t;
/* Reason for the response	*/

#define QClusterResumeResult_reason	0x200001	/* 2097153 */
typedef	UInt8	QClusterResumeResult_reason_t;

/*
 * QClusterResumeResult (value = 0x80002e) is an input message of generic use.
 */


typedef struct {
	UInt8	response;
	UInt8	reason;
} QClusterResumeResult_t;

#define QClusterResumeResult_get(msgPtr, structAddr, offset)	\
		    qMsgVarFieldGet((msgPtr), 2, &(offset),	\
			(QClusterResumeResult_response), &((structAddr)->response),	\
			(QClusterResumeResult_reason), &((structAddr)->reason))


#define QClusterResumeResult_put(msgPtr, structAddr, offset)	\
		    qMsgVarFieldPut((msgPtr), 2, &(offset),	\
			(QClusterResumeResult_response), &((structAddr)->response),	\
			(QClusterResumeResult_reason), &((structAddr)->reason))


#define QClusterResumeResult_Size		2

#define QClusterResumeResult	0x80002e	/* 8388654 */

/* Cluster Resume responses */
#define QCLUST_AcceptRequest	0x01	/* Accept resume	*/
#define QCLUST_RejectRequest	0x02	/* Reject resume	*/

/* Cluster Resume Response reasons */
#define QCLUST_ReasonNormal		0x00	/* Normal or no reason */
#define QCLUST_ReasonNotActive	0x01	/* Instance is not active */
#define QCLUST_ReasonNoPort		0x02	/* Port not known by instance */

/* Ask a timeslot broker for a set of timeslots. */
/* Number of timeslots allocated	*/

#define QClusterSlotAllocate_count	0x200000	/* 2097152 */
typedef	UInt8	QClusterSlotAllocate_count_t;

/*
 * QClusterSlotAllocate (value = 0x80002f) is an input message of generic use.
 */


typedef struct {
	UInt8	count;
} QClusterSlotAllocate_t;

#define QClusterSlotAllocate_get(msgPtr, structAddr, offset)	\
		    qMsgVarFieldGet((msgPtr), 1, &(offset),	\
			(QClusterSlotAllocate_count), &((structAddr)->count))


#define QClusterSlotAllocate_put(msgPtr, structAddr, offset)	\
		    qMsgVarFieldPut((msgPtr), 1, &(offset),	\
			(QClusterSlotAllocate_count), &((structAddr)->count))


#define QClusterSlotAllocate_Size		1

#define QClusterSlotAllocate	0x80002f	/* 8388655 */
/* Assign timeslots to a cluster port  */
/* The cluster that owns the port		*/

#define QClusterSlotAssign_clustDesc	0x800000	/* 8388608 */
typedef	QCompDesc	QClusterSlotAssign_clustDesc_t;
/* Port description				*/

#define QClusterSlotAssign_portId	0x300006	/* 3145734 */
typedef	UInt24	QClusterSlotAssign_portId_t;
/* Number of timeslots to assign to port	*/

#define QClusterSlotAssign_width	0x200009	/* 2097161 */
typedef	UInt8	QClusterSlotAssign_width_t;
/* Type of PCM encoding on timeslots		*/

#define QClusterSlotAssign_encoding	0x20000a	/* 2097162 */
typedef	UInt8	QClusterSlotAssign_encoding_t;
/* Idle pattern required on timeslots		*/

#define QClusterSlotAssign_idlePattern	0x20000b	/* 2097163 */
typedef	UInt8	QClusterSlotAssign_idlePattern_t;

#define QClusterSlotAssign_varStart	0xc
/* List of timeslot numbers [width]		*/

#define QClusterSlotAssign_slotId	0x280000	/* 2621440 */
typedef	UInt16	QClusterSlotAssign_slotId_t;

/*
 * QClusterSlotAssign (value = 0x800030) is an input message of generic use.
 */


typedef struct {
	QCompDesc	clustDesc;
	UInt24	portId;
	UInt8	width;
	UInt8	encoding;
	UInt8	idlePattern;
} QClusterSlotAssign_t;

#define QClusterSlotAssign_get(msgPtr, structAddr, offset)	\
		    qMsgVarFieldGet((msgPtr), 5, &(offset),	\
			(QClusterSlotAssign_clustDesc), &((structAddr)->clustDesc),	\
			(QClusterSlotAssign_portId), &((structAddr)->portId),	\
			(QClusterSlotAssign_width), &((structAddr)->width),	\
			(QClusterSlotAssign_encoding), &((structAddr)->encoding),	\
			(QClusterSlotAssign_idlePattern), &((structAddr)->idlePattern))


#define QClusterSlotAssign_put(msgPtr, structAddr, offset)	\
		    qMsgVarFieldPut((msgPtr), 5, &(offset),	\
			(QClusterSlotAssign_clustDesc), &((structAddr)->clustDesc),	\
			(QClusterSlotAssign_portId), &((structAddr)->portId),	\
			(QClusterSlotAssign_width), &((structAddr)->width),	\
			(QClusterSlotAssign_encoding), &((structAddr)->encoding),	\
			(QClusterSlotAssign_idlePattern), &((structAddr)->idlePattern))


#define QClusterSlotAssign_Size		12

#define QClusterSlotAssign	0x800030	/* 8388656 */
/* Give a set of SCBus timeslots back to a timeslot broker. */
/* Number of timeslots to free	*/

#define QClusterSlotFree_count	0x200000	/* 2097152 */
typedef	UInt8	QClusterSlotFree_count_t;

#define QClusterSlotFree_varStart	0x1
/* List of timeslot numbers [count]	*/

#define QClusterSlotFree_slotId	0x280000	/* 2621440 */
typedef	UInt16	QClusterSlotFree_slotId_t;

/*
 * QClusterSlotFree (value = 0x800031) is an input message of generic use.
 */


typedef struct {
	UInt8	count;
} QClusterSlotFree_t;

#define QClusterSlotFree_get(msgPtr, structAddr, offset)	\
		    qMsgVarFieldGet((msgPtr), 1, &(offset),	\
			(QClusterSlotFree_count), &((structAddr)->count))


#define QClusterSlotFree_put(msgPtr, structAddr, offset)	\
		    qMsgVarFieldPut((msgPtr), 1, &(offset),	\
			(QClusterSlotFree_count), &((structAddr)->count))


#define QClusterSlotFree_Size		1

#define QClusterSlotFree	0x800031	/* 8388657 */
/* Find the timeslots allocated to a port. */
/* the component instance that owns the port	*/

#define QClusterSlotInfo_instDesc	0x800000	/* 8388608 */
typedef	QCompDesc	QClusterSlotInfo_instDesc_t;
/* Port that owns the timeslots			*/

#define QClusterSlotInfo_portId	0x300006	/* 3145734 */
typedef	UInt24	QClusterSlotInfo_portId_t;

/*
 * QClusterSlotInfo (value = 0x800032) is an input message of generic use.
 */


typedef struct {
	QCompDesc	instDesc;
	UInt24	portId;
} QClusterSlotInfo_t;

#define QClusterSlotInfo_get(msgPtr, structAddr, offset)	\
		    qMsgVarFieldGet((msgPtr), 2, &(offset),	\
			(QClusterSlotInfo_instDesc), &((structAddr)->instDesc),	\
			(QClusterSlotInfo_portId), &((structAddr)->portId))


#define QClusterSlotInfo_put(msgPtr, structAddr, offset)	\
		    qMsgVarFieldPut((msgPtr), 2, &(offset),	\
			(QClusterSlotInfo_instDesc), &((structAddr)->instDesc),	\
			(QClusterSlotInfo_portId), &((structAddr)->portId))


#define QClusterSlotInfo_Size		9

#define QClusterSlotInfo	0x800032	/* 8388658 */
/* Reports the timeslots allocated to a port. */
/* the instance that owns the ports	*/

#define QClusterSlotInfoResult_instDesc	0x800000	/* 8388608 */
typedef	QCompDesc	QClusterSlotInfoResult_instDesc_t;
/* the port that owns the timeslots	*/

#define QClusterSlotInfoResult_portId	0x300006	/* 3145734 */
typedef	UInt24	QClusterSlotInfoResult_portId_t;
/* Number of timeslots in the port	*/

#define QClusterSlotInfoResult_width	0x200009	/* 2097161 */
typedef	UInt8	QClusterSlotInfoResult_width_t;
/* Type of PCM encoding on slots	*/

#define QClusterSlotInfoResult_encoding	0x20000a	/* 2097162 */
typedef	UInt8	QClusterSlotInfoResult_encoding_t;
/* Idle pattern required on slots	*/

#define QClusterSlotInfoResult_idlePattern	0x20000b	/* 2097163 */
typedef	UInt8	QClusterSlotInfoResult_idlePattern_t;

#define QClusterSlotInfoResult_varStart	0xc
/* List of slot numbers [width]	*/

#define QClusterSlotInfoResult_slotId	0x280000	/* 2621440 */
typedef	UInt16	QClusterSlotInfoResult_slotId_t;

/*
 * QClusterSlotInfoResult (value = 0x800033) is an output message of generic use.
 */


typedef struct {
	QCompDesc	instDesc;
	UInt24	portId;
	UInt8	width;
	UInt8	encoding;
	UInt8	idlePattern;
} QClusterSlotInfoResult_t;

#define QClusterSlotInfoResult_get(msgPtr, structAddr, offset)	\
		    qMsgVarFieldGet((msgPtr), 5, &(offset),	\
			(QClusterSlotInfoResult_instDesc), &((structAddr)->instDesc),	\
			(QClusterSlotInfoResult_portId), &((structAddr)->portId),	\
			(QClusterSlotInfoResult_width), &((structAddr)->width),	\
			(QClusterSlotInfoResult_encoding), &((structAddr)->encoding),	\
			(QClusterSlotInfoResult_idlePattern), &((structAddr)->idlePattern))


#define QClusterSlotInfoResult_put(msgPtr, structAddr, offset)	\
		    qMsgVarFieldPut((msgPtr), 5, &(offset),	\
			(QClusterSlotInfoResult_instDesc), &((structAddr)->instDesc),	\
			(QClusterSlotInfoResult_portId), &((structAddr)->portId),	\
			(QClusterSlotInfoResult_width), &((structAddr)->width),	\
			(QClusterSlotInfoResult_encoding), &((structAddr)->encoding),	\
			(QClusterSlotInfoResult_idlePattern), &((structAddr)->idlePattern))


#define QClusterSlotInfoResult_Size		12

#define QClusterSlotInfoResult	0x800033	/* 8388659 */
/* Modify the attributes of the timeslots allocated to a port  */
/* The cluster that owns the port	*/

#define QClusterSlotModify_clustDesc	0x800000	/* 8388608 */
typedef	QCompDesc	QClusterSlotModify_clustDesc_t;
/* The port that owns the timeslots	*/

#define QClusterSlotModify_portId	0x300006	/* 3145734 */
typedef	UInt24	QClusterSlotModify_portId_t;
/* Type of PCM encoding on slots	*/

#define QClusterSlotModify_encoding	0x200009	/* 2097161 */
typedef	UInt8	QClusterSlotModify_encoding_t;
/* Idle pattern required on slots	*/

#define QClusterSlotModify_idlePattern	0x20000a	/* 2097162 */
typedef	UInt8	QClusterSlotModify_idlePattern_t;

/*
 * QClusterSlotModify (value = 0x800034) is an input message of generic use.
 */


typedef struct {
	QCompDesc	clustDesc;
	UInt24	portId;
	UInt8	encoding;
	UInt8	idlePattern;
} QClusterSlotModify_t;

#define QClusterSlotModify_get(msgPtr, structAddr, offset)	\
		    qMsgVarFieldGet((msgPtr), 4, &(offset),	\
			(QClusterSlotModify_clustDesc), &((structAddr)->clustDesc),	\
			(QClusterSlotModify_portId), &((structAddr)->portId),	\
			(QClusterSlotModify_encoding), &((structAddr)->encoding),	\
			(QClusterSlotModify_idlePattern), &((structAddr)->idlePattern))


#define QClusterSlotModify_put(msgPtr, structAddr, offset)	\
		    qMsgVarFieldPut((msgPtr), 4, &(offset),	\
			(QClusterSlotModify_clustDesc), &((structAddr)->clustDesc),	\
			(QClusterSlotModify_portId), &((structAddr)->portId),	\
			(QClusterSlotModify_encoding), &((structAddr)->encoding),	\
			(QClusterSlotModify_idlePattern), &((structAddr)->idlePattern))


#define QClusterSlotModify_Size		11

#define QClusterSlotModify	0x800034	/* 8388660 */
/* Response to QClusterSlotAllocate, specifies timeslots allocated. */
/* Number of timeslots allocated	*/

#define QClusterSlotResult_count	0x200000	/* 2097152 */
typedef	UInt8	QClusterSlotResult_count_t;

#define QClusterSlotResult_varStart	0x1
/* List of timeslot numbers [count]	*/

#define QClusterSlotResult_slotId	0x280000	/* 2621440 */
typedef	UInt16	QClusterSlotResult_slotId_t;

/*
 * QClusterSlotResult (value = 0x800035) is an input message of generic use.
 */


typedef struct {
	UInt8	count;
} QClusterSlotResult_t;

#define QClusterSlotResult_get(msgPtr, structAddr, offset)	\
		    qMsgVarFieldGet((msgPtr), 1, &(offset),	\
			(QClusterSlotResult_count), &((structAddr)->count))


#define QClusterSlotResult_put(msgPtr, structAddr, offset)	\
		    qMsgVarFieldPut((msgPtr), 1, &(offset),	\
			(QClusterSlotResult_count), &((structAddr)->count))


#define QClusterSlotResult_Size		1

#define QClusterSlotResult	0x800035	/* 8388661 */
/* Unassign timeslots from a cluster port  */
/* The cluster that owns the port	*/

#define QClusterSlotUnassign_clustDesc	0x800000	/* 8388608 */
typedef	QCompDesc	QClusterSlotUnassign_clustDesc_t;
/* Port that owns the timeslots	*/

#define QClusterSlotUnassign_portId	0x300006	/* 3145734 */
typedef	UInt24	QClusterSlotUnassign_portId_t;

/*
 * QClusterSlotUnassign (value = 0x800036) is an input message of generic use.
 */


typedef struct {
	QCompDesc	clustDesc;
	UInt24	portId;
} QClusterSlotUnassign_t;

#define QClusterSlotUnassign_get(msgPtr, structAddr, offset)	\
		    qMsgVarFieldGet((msgPtr), 2, &(offset),	\
			(QClusterSlotUnassign_clustDesc), &((structAddr)->clustDesc),	\
			(QClusterSlotUnassign_portId), &((structAddr)->portId))


#define QClusterSlotUnassign_put(msgPtr, structAddr, offset)	\
		    qMsgVarFieldPut((msgPtr), 2, &(offset),	\
			(QClusterSlotUnassign_clustDesc), &((structAddr)->clustDesc),	\
			(QClusterSlotUnassign_portId), &((structAddr)->portId))


#define QClusterSlotUnassign_Size		9

#define QClusterSlotUnassign	0x800036	/* 8388662 */
/* Asks a cluster to suspend its data transmission from an output port */
/* Port to suspend			*/

#define QClusterSuspend_portId	0x300000	/* 3145728 */
typedef	UInt24	QClusterSuspend_portId_t;

/*
 * QClusterSuspend (value = 0x800037) is an input message of generic use.
 */


typedef struct {
	UInt24	portId;
} QClusterSuspend_t;

#define QClusterSuspend_get(msgPtr, structAddr, offset)	\
		    qMsgVarFieldGet((msgPtr), 1, &(offset),	\
			(QClusterSuspend_portId), &((structAddr)->portId))


#define QClusterSuspend_put(msgPtr, structAddr, offset)	\
		    qMsgVarFieldPut((msgPtr), 1, &(offset),	\
			(QClusterSuspend_portId), &((structAddr)->portId))


#define QClusterSuspend_Size		3

#define QClusterSuspend	0x800037	/* 8388663 */
/* Sent by instance in response to QClusterSuspend request */
/* Result of the request	*/

#define QClusterSuspendResult_response	0x200000	/* 2097152 */
typedef	UInt8	QClusterSuspendResult_response_t;
/* Reason for the response	*/

#define QClusterSuspendResult_reason	0x200001	/* 2097153 */
typedef	UInt8	QClusterSuspendResult_reason_t;

/*
 * QClusterSuspendResult (value = 0x800038) is an input message of generic use.
 */


typedef struct {
	UInt8	response;
	UInt8	reason;
} QClusterSuspendResult_t;

#define QClusterSuspendResult_get(msgPtr, structAddr, offset)	\
		    qMsgVarFieldGet((msgPtr), 2, &(offset),	\
			(QClusterSuspendResult_response), &((structAddr)->response),	\
			(QClusterSuspendResult_reason), &((structAddr)->reason))


#define QClusterSuspendResult_put(msgPtr, structAddr, offset)	\
		    qMsgVarFieldPut((msgPtr), 2, &(offset),	\
			(QClusterSuspendResult_response), &((structAddr)->response),	\
			(QClusterSuspendResult_reason), &((structAddr)->reason))


#define QClusterSuspendResult_Size		2

#define QClusterSuspendResult	0x800038	/* 8388664 */
/* Port definition attribute */

/* Build a binary port definition attribute value */
#define QClusterDefinePort(userType,portType,direction,count) \
	(((Uint24)((userType) & 0xFF)<<16)|((Uint16)(QTS_DIR_##direction)<<14)|\
	 ((Uint16)QTS_TYPE_##portType << 8) | ((Uint8)((count) & 0xFF)))

/* Geographic location ID definition attribute.  */

#define QClusterAttrPortDef	0x800000	/* 8388608 */
typedef	QCompAttr	QClusterAttrPortDef_t;

/* QClusterAttrGeoId attribute values */
#define QClusterGeoIdProc1  1
#define QClusterGeoIdProc2  2
#define QClusterGeoIdProc3  3
#define QClusterGeoIdProc4  4

/* Most significant portion of CTx12 connection mask definition attribute.  */

#define QClusterAttrGeoId	0x800001	/* 8388609 */
typedef	QCompAttr	QClusterAttrGeoId_t;
/* Least significant portion of CTx12 connection mask definition attribute.  */

#define QClusterAttrCTConnectMaskHigh	0x800002	/* 8388610 */
typedef	QCompAttr	QClusterAttrCTConnectMaskHigh_t;
/* Processor mask definition attribute.  */

#define QClusterAttrCTConnectMaskLow	0x800003	/* 8388611 */
typedef	QCompAttr	QClusterAttrCTConnectMaskLow_t;
/* CT transmitting port priority selecting attribute.  */

#define QClusterAttrProcessorMask	0x800004	/* 8388612 */
typedef	QCompAttr	QClusterAttrProcessorMask_t;

/* QClusterAttrCTPortPriTx attribute values */
#define QClusterCTPortPriUp    1
#define QClusterCTPortPriDown  2

/* CT receiving port priority selecting attribute.  */

#define QClusterAttrCTPortPriTx	0x800005	/* 8388613 */
typedef	QCompAttr	QClusterAttrCTPortPriTx_t;

/* The values for QClusterAttrCTPortPriRx key  */
/*  are the same as QClusterAttrCTPortPriTx.   */

/* QClusterActive/QClusterInactive message suppress attribute.  */

#define QClusterAttrCTPortPriRx	0x800006	/* 8388614 */
typedef	QCompAttr	QClusterAttrCTPortPriRx_t;

/* QCompAttrActInactMsgFlag attribute values */
#define QCompAttrActInactMsgEnable    1
#define QCompAttrActInactMsgDisable   2

/* Add a set of attributes to a component  */

#define QCompAttrActInactMsgFlag	0x800007	/* 8388615 */
typedef	QCompAttr	QCompAttrActInactMsgFlag_t;

#define QCompAttrAdd_comp	0x800000	/* 8388608 */
typedef	QCompDesc	QCompAttrAdd_comp_t;

#define QCompAttrAdd_count	0x380006	/* 3670022 */
typedef	UInt32	QCompAttrAdd_count_t;

#define QCompAttrAdd_varStart	0xa

#define QCompAttrAdd_attr	0x780000	/* 7864320 */
typedef	QCompAttr	QCompAttrAdd_attr_t;

/*
 * QCompAttrAdd (value = 0x800039) is a message of generic use.
 */


typedef struct {
	QCompDesc	comp;
	UInt32	count;
} QCompAttrAdd_t;

#define QCompAttrAdd_get(msgPtr, structAddr, offset)	\
		    qMsgVarFieldGet((msgPtr), 2, &(offset),	\
			(QCompAttrAdd_comp), &((structAddr)->comp),	\
			(QCompAttrAdd_count), &((structAddr)->count))


#define QCompAttrAdd_put(msgPtr, structAddr, offset)	\
		    qMsgVarFieldPut((msgPtr), 2, &(offset),	\
			(QCompAttrAdd_comp), &((structAddr)->comp),	\
			(QCompAttrAdd_count), &((structAddr)->count))


#define QCompAttrAdd_Size		10

#define QCompAttrAdd	0x800039	/* 8388665 */
/* Return the attribute information  associated with a component */

#define QCompAttrInfo_theComponent	0x800000	/* 8388608 */
typedef	QCompDesc	QCompAttrInfo_theComponent_t;

#define QCompAttrInfo_count	0x380006	/* 3670022 */
typedef	UInt32	QCompAttrInfo_count_t;

#define QCompAttrInfo_attroffset	0x38000a	/* 3670026 */
typedef	UInt32	QCompAttrInfo_attroffset_t;

/*
 * QCompAttrInfo (value = 0x80003a) is a message of generic use.
 */


typedef struct {
	QCompDesc	theComponent;
	UInt32	count;
	UInt32	attroffset;
} QCompAttrInfo_t;

#define QCompAttrInfo_get(msgPtr, structAddr, offset)	\
		    qMsgVarFieldGet((msgPtr), 3, &(offset),	\
			(QCompAttrInfo_theComponent), &((structAddr)->theComponent),	\
			(QCompAttrInfo_count), &((structAddr)->count),	\
			(QCompAttrInfo_attroffset), &((structAddr)->attroffset))


#define QCompAttrInfo_put(msgPtr, structAddr, offset)	\
		    qMsgVarFieldPut((msgPtr), 3, &(offset),	\
			(QCompAttrInfo_theComponent), &((structAddr)->theComponent),	\
			(QCompAttrInfo_count), &((structAddr)->count),	\
			(QCompAttrInfo_attroffset), &((structAddr)->attroffset))


#define QCompAttrInfo_Size		14

#define QCompAttrInfo	0x80003a	/* 8388666 */
/* Return the attribute information  associated with a component */

#define QCompAttrInfoByAttr_theComponent	0x800000	/* 8388608 */
typedef	QCompDesc	QCompAttrInfoByAttr_theComponent_t;

#define QCompAttrInfoByAttr_count	0x380006	/* 3670022 */
typedef	UInt32	QCompAttrInfoByAttr_count_t;

#define QCompAttrInfoByAttr_maxResults	0x38000a	/* 3670026 */
typedef	UInt32	QCompAttrInfoByAttr_maxResults_t;

#define QCompAttrInfoByAttr_varStart	0xe

#define QCompAttrInfoByAttr_attr	0x780000	/* 7864320 */
typedef	QCompAttr	QCompAttrInfoByAttr_attr_t;

/*
 * QCompAttrInfoByAttr (value = 0x80003b) is a message of generic use.
 */


typedef struct {
	QCompDesc	theComponent;
	UInt32	count;
	UInt32	maxResults;
} QCompAttrInfoByAttr_t;

#define QCompAttrInfoByAttr_get(msgPtr, structAddr, offset)	\
		    qMsgVarFieldGet((msgPtr), 3, &(offset),	\
			(QCompAttrInfoByAttr_theComponent), &((structAddr)->theComponent),	\
			(QCompAttrInfoByAttr_count), &((structAddr)->count),	\
			(QCompAttrInfoByAttr_maxResults), &((structAddr)->maxResults))


#define QCompAttrInfoByAttr_put(msgPtr, structAddr, offset)	\
		    qMsgVarFieldPut((msgPtr), 3, &(offset),	\
			(QCompAttrInfoByAttr_theComponent), &((structAddr)->theComponent),	\
			(QCompAttrInfoByAttr_count), &((structAddr)->count),	\
			(QCompAttrInfoByAttr_maxResults), &((structAddr)->maxResults))


#define QCompAttrInfoByAttr_Size		14

#define QCompAttrInfoByAttr	0x80003b	/* 8388667 */
/* Remove a set of attributes from a component*/

#define QCompAttrRemove_theComponent	0x800000	/* 8388608 */
typedef	QCompDesc	QCompAttrRemove_theComponent_t;

#define QCompAttrRemove_count	0x380006	/* 3670022 */
typedef	UInt32	QCompAttrRemove_count_t;

#define QCompAttrRemove_varStart	0xa

#define QCompAttrRemove_attr	0x780000	/* 7864320 */
typedef	QCompAttr	QCompAttrRemove_attr_t;

/*
 * QCompAttrRemove (value = 0x80003c) is a message of generic use.
 */


typedef struct {
	QCompDesc	theComponent;
	UInt32	count;
} QCompAttrRemove_t;

#define QCompAttrRemove_get(msgPtr, structAddr, offset)	\
		    qMsgVarFieldGet((msgPtr), 2, &(offset),	\
			(QCompAttrRemove_theComponent), &((structAddr)->theComponent),	\
			(QCompAttrRemove_count), &((structAddr)->count))


#define QCompAttrRemove_put(msgPtr, structAddr, offset)	\
		    qMsgVarFieldPut((msgPtr), 2, &(offset),	\
			(QCompAttrRemove_theComponent), &((structAddr)->theComponent),	\
			(QCompAttrRemove_count), &((structAddr)->count))


#define QCompAttrRemove_Size		10

#define QCompAttrRemove	0x80003c	/* 8388668 */
/* Find a component  */

#define QCompFind_componentMask	0x800000	/* 8388608 */
typedef	QCompDesc	QCompFind_componentMask_t;

#define QCompFind_count	0x380006	/* 3670022 */
typedef	UInt32	QCompFind_count_t;

#define QCompFind_varStart	0xa

#define QCompFind_attr	0x780000	/* 7864320 */
typedef	QCompAttr	QCompFind_attr_t;

/*
 * QCompFind (value = 0x80003d) is a message of generic use.
 */


typedef struct {
	QCompDesc	componentMask;
	UInt32	count;
} QCompFind_t;

#define QCompFind_get(msgPtr, structAddr, offset)	\
		    qMsgVarFieldGet((msgPtr), 2, &(offset),	\
			(QCompFind_componentMask), &((structAddr)->componentMask),	\
			(QCompFind_count), &((structAddr)->count))


#define QCompFind_put(msgPtr, structAddr, offset)	\
		    qMsgVarFieldPut((msgPtr), 2, &(offset),	\
			(QCompFind_componentMask), &((structAddr)->componentMask),	\
			(QCompFind_count), &((structAddr)->count))


#define QCompFind_Size		10

#define QCompFind	0x80003d	/* 8388669 */
/* Allocate a component instance*/

#define QCompInstAllocate_componentMask	0x800000	/* 8388608 */
typedef	QCompDesc	QCompInstAllocate_componentMask_t;

#define QCompInstAllocate_clustDesc	0x800006	/* 8388614 */
typedef	QCompDesc	QCompInstAllocate_clustDesc_t;

#define QCompInstAllocate_count	0x38000c	/* 3670028 */
typedef	UInt32	QCompInstAllocate_count_t;

#define QCompInstAllocate_varStart	0x10

#define QCompInstAllocate_attr	0x780000	/* 7864320 */
typedef	QCompAttr	QCompInstAllocate_attr_t;

/*
 * QCompInstAllocate (value = 0x80003e) is a message of generic use.
 */


typedef struct {
	QCompDesc	componentMask;
	QCompDesc	clustDesc;
	UInt32	count;
} QCompInstAllocate_t;

#define QCompInstAllocate_get(msgPtr, structAddr, offset)	\
		    qMsgVarFieldGet((msgPtr), 3, &(offset),	\
			(QCompInstAllocate_componentMask), &((structAddr)->componentMask),	\
			(QCompInstAllocate_clustDesc), &((structAddr)->clustDesc),	\
			(QCompInstAllocate_count), &((structAddr)->count))


#define QCompInstAllocate_put(msgPtr, structAddr, offset)	\
		    qMsgVarFieldPut((msgPtr), 3, &(offset),	\
			(QCompInstAllocate_componentMask), &((structAddr)->componentMask),	\
			(QCompInstAllocate_clustDesc), &((structAddr)->clustDesc),	\
			(QCompInstAllocate_count), &((structAddr)->count))


#define QCompInstAllocate_Size		16

#define QCompInstAllocate	0x80003e	/* 8388670 */
/* Restrict registered component instances from being allocated or reserved*/

#define QCompInstanceRestrict_theInstance	0x800000	/* 8388608 */
typedef	QCompDesc	QCompInstanceRestrict_theInstance_t;

#define QCompInstanceRestrict_count	0x380006	/* 3670022 */
typedef	UInt32	QCompInstanceRestrict_count_t;

#define QCompInstanceRestrict_restrictMode_inactive	0xe	/* 14 */

#define QCompInstanceRestrict_restrictMode_whenFree	0xf	/* 15 */

#define QCompInstanceRestrict_restrictMode_immediate	0x10	/* 16 */

#define QCompInstanceRestrict_restrictMode	0x38000a	/* 3670026 */
typedef	UInt32	QCompInstanceRestrict_restrictMode_t;

#define QCompInstanceRestrict_timeout	0x38000e	/* 3670030 */
typedef	UInt32	QCompInstanceRestrict_timeout_t;

/*
 * QCompInstanceRestrict (value = 0x80003f) is a message of generic use.
 */


typedef struct {
	QCompDesc	theInstance;
	UInt32	count;
	UInt32	restrictMode;
	UInt32	timeout;
} QCompInstanceRestrict_t;

#define QCompInstanceRestrict_get(msgPtr, structAddr, offset)	\
		    qMsgVarFieldGet((msgPtr), 4, &(offset),	\
			(QCompInstanceRestrict_theInstance), &((structAddr)->theInstance),	\
			(QCompInstanceRestrict_count), &((structAddr)->count),	\
			(QCompInstanceRestrict_restrictMode), &((structAddr)->restrictMode),	\
			(QCompInstanceRestrict_timeout), &((structAddr)->timeout))


#define QCompInstanceRestrict_put(msgPtr, structAddr, offset)	\
		    qMsgVarFieldPut((msgPtr), 4, &(offset),	\
			(QCompInstanceRestrict_theInstance), &((structAddr)->theInstance),	\
			(QCompInstanceRestrict_count), &((structAddr)->count),	\
			(QCompInstanceRestrict_restrictMode), &((structAddr)->restrictMode),	\
			(QCompInstanceRestrict_timeout), &((structAddr)->timeout))


#define QCompInstanceRestrict_Size		18

#define QCompInstanceRestrict	0x80003f	/* 8388671 */

#ifndef QRESTRICT_INACTIVE 
#define QRESTRICT_INACTIVE QCompInstanceRestrict_restrictMode_inactive
#define QRESTRICT_WHENFREE QCompInstanceRestrict_restrictMode_whenFree
#define QRESTRICT_IMMEDIATE QCompInstanceRestrict_restrictMode_immediate 
#endif

/* Release restricted registered component instances */

#define QCompInstanceUnrestrict_count	0x380000	/* 3670016 */
typedef	UInt32	QCompInstanceUnrestrict_count_t;

/*
 * QCompInstanceUnrestrict (value = 0x800040) is a message of generic use.
 */


typedef struct {
	UInt32	count;
} QCompInstanceUnrestrict_t;

#define QCompInstanceUnrestrict_get(msgPtr, structAddr, offset)	\
		    qMsgVarFieldGet((msgPtr), 1, &(offset),	\
			(QCompInstanceUnrestrict_count), &((structAddr)->count))


#define QCompInstanceUnrestrict_put(msgPtr, structAddr, offset)	\
		    qMsgVarFieldPut((msgPtr), 1, &(offset),	\
			(QCompInstanceUnrestrict_count), &((structAddr)->count))


#define QCompInstanceUnrestrict_Size		4

#define QCompInstanceUnrestrict	0x800040	/* 8388672 */

#ifndef QRESTRICT_INACTIVE 
#define QRESTRICT_INACTIVE QCompInstanceRestrict_restrictMode_inactive
#define QRESTRICT_WHENFREE QCompInstanceRestrict_restrictMode_whenFree
#define QRESTRICT_IMMEDIATE QCompInstanceRestrict_restrictMode_immediate 
#endif

/* Free a component instance */

#define QCompInstFree_theInstance	0x800000	/* 8388608 */
typedef	QCompDesc	QCompInstFree_theInstance_t;

/*
 * QCompInstFree (value = 0x800041) is a message of generic use.
 */


typedef struct {
	QCompDesc	theInstance;
} QCompInstFree_t;

#define QCompInstFree_get(msgPtr, structAddr, offset)	\
		    qMsgVarFieldGet((msgPtr), 1, &(offset),	\
			(QCompInstFree_theInstance), &((structAddr)->theInstance))


#define QCompInstFree_put(msgPtr, structAddr, offset)	\
		    qMsgVarFieldPut((msgPtr), 1, &(offset),	\
			(QCompInstFree_theInstance), &((structAddr)->theInstance))


#define QCompInstFree_Size		6

#define QCompInstFree	0x800041	/* 8388673 */
/* Add a component to a component set*/

#define QCompSetAdd_setId	0x380000	/* 3670016 */
typedef	UInt32	QCompSetAdd_setId_t;

#define QCompSetAdd_subsetId	0x380004	/* 3670020 */
typedef	UInt32	QCompSetAdd_subsetId_t;

#define QCompSetAdd_firstInstance	0x800008	/* 8388616 */
typedef	QCompDesc	QCompSetAdd_firstInstance_t;

#define QCompSetAdd_count	0x38000e	/* 3670030 */
typedef	UInt32	QCompSetAdd_count_t;

#define QCompSetAdd_units	0x380012	/* 3670034 */
typedef	UInt32	QCompSetAdd_units_t;

/*
 * QCompSetAdd (value = 0x800042) is a message of generic use.
 */


typedef struct {
	UInt32	setId;
	UInt32	subsetId;
	QCompDesc	firstInstance;
	UInt32	count;
	UInt32	units;
} QCompSetAdd_t;

#define QCompSetAdd_get(msgPtr, structAddr, offset)	\
		    qMsgVarFieldGet((msgPtr), 5, &(offset),	\
			(QCompSetAdd_setId), &((structAddr)->setId),	\
			(QCompSetAdd_subsetId), &((structAddr)->subsetId),	\
			(QCompSetAdd_firstInstance), &((structAddr)->firstInstance),	\
			(QCompSetAdd_count), &((structAddr)->count),	\
			(QCompSetAdd_units), &((structAddr)->units))


#define QCompSetAdd_put(msgPtr, structAddr, offset)	\
		    qMsgVarFieldPut((msgPtr), 5, &(offset),	\
			(QCompSetAdd_setId), &((structAddr)->setId),	\
			(QCompSetAdd_subsetId), &((structAddr)->subsetId),	\
			(QCompSetAdd_firstInstance), &((structAddr)->firstInstance),	\
			(QCompSetAdd_count), &((structAddr)->count),	\
			(QCompSetAdd_units), &((structAddr)->units))


#define QCompSetAdd_Size		22

#define QCompSetAdd	0x800042	/* 8388674 */
/* Create a component set */

#define QCompSetCreate_setId	0x380000	/* 3670016 */
typedef	UInt32	QCompSetCreate_setId_t;

#define QCompSetCreate_processor	0x380004	/* 3670020 */
typedef	UInt32	QCompSetCreate_processor_t;

#define QCompSetCreate_maxUnits	0x800008	/* 8388616 */
typedef	QCompDesc	QCompSetCreate_maxUnits_t;

/*
 * QCompSetCreate (value = 0x800043) is a message of generic use.
 */


typedef struct {
	UInt32	setId;
	UInt32	processor;
	QCompDesc	maxUnits;
} QCompSetCreate_t;

#define QCompSetCreate_get(msgPtr, structAddr, offset)	\
		    qMsgVarFieldGet((msgPtr), 3, &(offset),	\
			(QCompSetCreate_setId), &((structAddr)->setId),	\
			(QCompSetCreate_processor), &((structAddr)->processor),	\
			(QCompSetCreate_maxUnits), &((structAddr)->maxUnits))


#define QCompSetCreate_put(msgPtr, structAddr, offset)	\
		    qMsgVarFieldPut((msgPtr), 3, &(offset),	\
			(QCompSetCreate_setId), &((structAddr)->setId),	\
			(QCompSetCreate_processor), &((structAddr)->processor),	\
			(QCompSetCreate_maxUnits), &((structAddr)->maxUnits))


#define QCompSetCreate_Size		14

#define QCompSetCreate	0x800043	/* 8388675 */
/* Destroy a component set */

#define QCompSetDestroy_setId	0x380000	/* 3670016 */
typedef	UInt32	QCompSetDestroy_setId_t;

/*
 * QCompSetDestroy (value = 0x800044) is a message of generic use.
 */


typedef struct {
	UInt32	setId;
} QCompSetDestroy_t;

#define QCompSetDestroy_get(msgPtr, structAddr, offset)	\
		    qMsgVarFieldGet((msgPtr), 1, &(offset),	\
			(QCompSetDestroy_setId), &((structAddr)->setId))


#define QCompSetDestroy_put(msgPtr, structAddr, offset)	\
		    qMsgVarFieldPut((msgPtr), 1, &(offset),	\
			(QCompSetDestroy_setId), &((structAddr)->setId))


#define QCompSetDestroy_Size		4

#define QCompSetDestroy	0x800044	/* 8388676 */
/* Return the contents of a component set */

#define QCompSetInfoGet_setId	0x380000	/* 3670016 */
typedef	UInt32	QCompSetInfoGet_setId_t;

#define QCompSetInfoGet_attroffset	0x380004	/* 3670020 */
typedef	UInt32	QCompSetInfoGet_attroffset_t;

#define QCompSetInfoGet_count	0x380008	/* 3670024 */
typedef	UInt32	QCompSetInfoGet_count_t;

/*
 * QCompSetInfoGet (value = 0x800045) is a message of generic use.
 */


typedef struct {
	UInt32	setId;
	UInt32	attroffset;
	UInt32	count;
} QCompSetInfoGet_t;

#define QCompSetInfoGet_get(msgPtr, structAddr, offset)	\
		    qMsgVarFieldGet((msgPtr), 3, &(offset),	\
			(QCompSetInfoGet_setId), &((structAddr)->setId),	\
			(QCompSetInfoGet_attroffset), &((structAddr)->attroffset),	\
			(QCompSetInfoGet_count), &((structAddr)->count))


#define QCompSetInfoGet_put(msgPtr, structAddr, offset)	\
		    qMsgVarFieldPut((msgPtr), 3, &(offset),	\
			(QCompSetInfoGet_setId), &((structAddr)->setId),	\
			(QCompSetInfoGet_attroffset), &((structAddr)->attroffset),	\
			(QCompSetInfoGet_count), &((structAddr)->count))


#define QCompSetInfoGet_Size		12

#define QCompSetInfoGet	0x800045	/* 8388677 */
/* Remove a component from a component set */

#define QCompSetRemove_setId	0x380000	/* 3670016 */
typedef	UInt32	QCompSetRemove_setId_t;

#define QCompSetRemove_theComponent	0x800004	/* 8388612 */
typedef	QCompDesc	QCompSetRemove_theComponent_t;

#define QCompSetRemove_count	0x38000a	/* 3670026 */
typedef	UInt32	QCompSetRemove_count_t;

/*
 * QCompSetRemove (value = 0x800046) is a message of generic use.
 */


typedef struct {
	UInt32	setId;
	QCompDesc	theComponent;
	UInt32	count;
} QCompSetRemove_t;

#define QCompSetRemove_get(msgPtr, structAddr, offset)	\
		    qMsgVarFieldGet((msgPtr), 3, &(offset),	\
			(QCompSetRemove_setId), &((structAddr)->setId),	\
			(QCompSetRemove_theComponent), &((structAddr)->theComponent),	\
			(QCompSetRemove_count), &((structAddr)->count))


#define QCompSetRemove_put(msgPtr, structAddr, offset)	\
		    qMsgVarFieldPut((msgPtr), 3, &(offset),	\
			(QCompSetRemove_setId), &((structAddr)->setId),	\
			(QCompSetRemove_theComponent), &((structAddr)->theComponent),	\
			(QCompSetRemove_count), &((structAddr)->count))


#define QCompSetRemove_Size		14

#define QCompSetRemove	0x800046	/* 8388678 */
/* Download a configuration module */

#define QModuleDownload_moduleId	0x380000	/* 3670016 */
typedef	UInt32	QModuleDownload_moduleId_t;

#define QModuleDownload_processor	0x200004	/* 2097156 */
typedef	UInt8	QModuleDownload_processor_t;

#define QModuleDownload_moduleType_passive	0x11	/* 17 */

#define QModuleDownload_moduleType_active	0x12	/* 18 */

#define QModuleDownload_moduleType_boot	0x13	/* 19 */

#define QModuleDownload_moduleType_fixed	0x14	/* 20 */

#define QModuleDownload_moduleType_flashKernel	0x15	/* 21 */

#define QModuleDownload_moduleType_flashSPKernel	0x16	/* 22 */

#define QModuleDownload_moduleType	0x200005	/* 2097157 */
typedef	UInt8	QModuleDownload_moduleType_t;

#define QModuleDownload_pInitEntry	0x380006	/* 3670022 */
typedef	UInt32	QModuleDownload_pInitEntry_t;

#define QModuleDownload_pRemoveEntry	0x38000a	/* 3670026 */
typedef	UInt32	QModuleDownload_pRemoveEntry_t;

#define QModuleDownload_loadStreamId	0x38000e	/* 3670030 */
typedef	UInt32	QModuleDownload_loadStreamId_t;

#define QModuleDownload_key	0x207812	/* 2127890 */
typedef	UInt8	QModuleDownload_key_t[16];

/*
 * QModuleDownload (value = 0x800047) is a message of generic use.
 */


typedef struct {
	UInt32	moduleId;
	UInt8	processor;
	UInt8	moduleType;
	UInt32	pInitEntry;
	UInt32	pRemoveEntry;
	UInt32	loadStreamId;
	UInt8	key[16];
} QModuleDownload_t;

#define QModuleDownload_get(msgPtr, structAddr, offset)	\
		    qMsgVarFieldGet((msgPtr), 7, &(offset),	\
			(QModuleDownload_moduleId), &((structAddr)->moduleId),	\
			(QModuleDownload_processor), &((structAddr)->processor),	\
			(QModuleDownload_moduleType), &((structAddr)->moduleType),	\
			(QModuleDownload_pInitEntry), &((structAddr)->pInitEntry),	\
			(QModuleDownload_pRemoveEntry), &((structAddr)->pRemoveEntry),	\
			(QModuleDownload_loadStreamId), &((structAddr)->loadStreamId),	\
			(QModuleDownload_key), &((structAddr)->key))


#define QModuleDownload_put(msgPtr, structAddr, offset)	\
		    qMsgVarFieldPut((msgPtr), 7, &(offset),	\
			(QModuleDownload_moduleId), &((structAddr)->moduleId),	\
			(QModuleDownload_processor), &((structAddr)->processor),	\
			(QModuleDownload_moduleType), &((structAddr)->moduleType),	\
			(QModuleDownload_pInitEntry), &((structAddr)->pInitEntry),	\
			(QModuleDownload_pRemoveEntry), &((structAddr)->pRemoveEntry),	\
			(QModuleDownload_loadStreamId), &((structAddr)->loadStreamId),	\
			(QModuleDownload_key), &((structAddr)->key))


#define QModuleDownload_Size		34

#define QModuleDownload	0x800047	/* 8388679 */
/* Get info about downloaded modules */

#define QModuleInfo_moduleId	0x380000	/* 3670016 */
typedef	UInt32	QModuleInfo_moduleId_t;

/*
 * QModuleInfo (value = 0x800048) is a message of generic use.
 */


typedef struct {
	UInt32	moduleId;
} QModuleInfo_t;

#define QModuleInfo_get(msgPtr, structAddr, offset)	\
		    qMsgVarFieldGet((msgPtr), 1, &(offset),	\
			(QModuleInfo_moduleId), &((structAddr)->moduleId))


#define QModuleInfo_put(msgPtr, structAddr, offset)	\
		    qMsgVarFieldPut((msgPtr), 1, &(offset),	\
			(QModuleInfo_moduleId), &((structAddr)->moduleId))


#define QModuleInfo_Size		4

#define QModuleInfo	0x800048	/* 8388680 */
/* Response to info about downloaded modules*/

#define QModuleInfoResult_moduleId	0x380000	/* 3670016 */
typedef	UInt32	QModuleInfoResult_moduleId_t;

#define QModuleInfoResult_processor	0x200004	/* 2097156 */
typedef	UInt8	QModuleInfoResult_processor_t;

#define QModuleInfoResult_moduleType_passive	0x17	/* 23 */

#define QModuleInfoResult_moduleType_active	0x18	/* 24 */

#define QModuleInfoResult_moduleType_boot	0x19	/* 25 */

#define QModuleInfoResult_moduleType_fixed	0x1a	/* 26 */

#define QModuleInfoResult_moduleType_flashKernel	0x1b	/* 27 */

#define QModuleInfoResult_moduleType_flashSPKernel	0x1c	/* 28 */

#define QModuleInfoResult_moduleType	0x200005	/* 2097157 */
typedef	UInt8	QModuleInfoResult_moduleType_t;

#define QModuleInfoResult_pInitEntry	0x380006	/* 3670022 */
typedef	UInt32	QModuleInfoResult_pInitEntry_t;

#define QModuleInfoResult_pRemoveEntry	0x38000a	/* 3670026 */
typedef	UInt32	QModuleInfoResult_pRemoveEntry_t;

#define QModuleInfoResult_state_created	0x1d	/* 29 */

#define QModuleInfoResult_state_loading	0x1e	/* 30 */

#define QModuleInfoResult_state_initializing	0x1f	/* 31 */

#define QModuleInfoResult_state_initialized	0x20	/* 32 */

#define QModuleInfoResult_state_removing	0x21	/* 33 */

#define QModuleInfoResult_state_removed	0x22	/* 34 */

#define QModuleInfoResult_state	0x38000e	/* 3670030 */
typedef	UInt32	QModuleInfoResult_state_t;

/*
 * QModuleInfoResult (value = 0x800049) is a message of generic use.
 */


typedef struct {
	UInt32	moduleId;
	UInt8	processor;
	UInt8	moduleType;
	UInt32	pInitEntry;
	UInt32	pRemoveEntry;
	UInt32	state;
} QModuleInfoResult_t;

#define QModuleInfoResult_get(msgPtr, structAddr, offset)	\
		    qMsgVarFieldGet((msgPtr), 6, &(offset),	\
			(QModuleInfoResult_moduleId), &((structAddr)->moduleId),	\
			(QModuleInfoResult_processor), &((structAddr)->processor),	\
			(QModuleInfoResult_moduleType), &((structAddr)->moduleType),	\
			(QModuleInfoResult_pInitEntry), &((structAddr)->pInitEntry),	\
			(QModuleInfoResult_pRemoveEntry), &((structAddr)->pRemoveEntry),	\
			(QModuleInfoResult_state), &((structAddr)->state))


#define QModuleInfoResult_put(msgPtr, structAddr, offset)	\
		    qMsgVarFieldPut((msgPtr), 6, &(offset),	\
			(QModuleInfoResult_moduleId), &((structAddr)->moduleId),	\
			(QModuleInfoResult_processor), &((structAddr)->processor),	\
			(QModuleInfoResult_moduleType), &((structAddr)->moduleType),	\
			(QModuleInfoResult_pInitEntry), &((structAddr)->pInitEntry),	\
			(QModuleInfoResult_pRemoveEntry), &((structAddr)->pRemoveEntry),	\
			(QModuleInfoResult_state), &((structAddr)->state))


#define QModuleInfoResult_Size		18

#define QModuleInfoResult	0x800049	/* 8388681 */
/* Response to module download request */

#define QModuleInitialized_moduleId	0x380000	/* 3670016 */
typedef	UInt32	QModuleInitialized_moduleId_t;

#define QModuleInitialized_headTask	0x380004	/* 3670020 */
typedef	UInt32	QModuleInitialized_headTask_t;

/*
 * QModuleInitialized (value = 0x80004a) is a message of generic use.
 */


typedef struct {
	UInt32	moduleId;
	UInt32	headTask;
} QModuleInitialized_t;

#define QModuleInitialized_get(msgPtr, structAddr, offset)	\
		    qMsgVarFieldGet((msgPtr), 2, &(offset),	\
			(QModuleInitialized_moduleId), &((structAddr)->moduleId),	\
			(QModuleInitialized_headTask), &((structAddr)->headTask))


#define QModuleInitialized_put(msgPtr, structAddr, offset)	\
		    qMsgVarFieldPut((msgPtr), 2, &(offset),	\
			(QModuleInitialized_moduleId), &((structAddr)->moduleId),	\
			(QModuleInitialized_headTask), &((structAddr)->headTask))


#define QModuleInitialized_Size		8

#define QModuleInitialized	0x80004a	/* 8388682 */
/* Unload an existing module */

#define QModuleUnload_moduleId	0x380000	/* 3670016 */
typedef	UInt32	QModuleUnload_moduleId_t;

#define QModuleUnload_key	0x207804	/* 2127876 */
typedef	UInt8	QModuleUnload_key_t[16];

/*
 * QModuleUnload (value = 0x80004b) is a message of generic use.
 */


typedef struct {
	UInt32	moduleId;
	UInt8	key[16];
} QModuleUnload_t;

#define QModuleUnload_get(msgPtr, structAddr, offset)	\
		    qMsgVarFieldGet((msgPtr), 2, &(offset),	\
			(QModuleUnload_moduleId), &((structAddr)->moduleId),	\
			(QModuleUnload_key), &((structAddr)->key))


#define QModuleUnload_put(msgPtr, structAddr, offset)	\
		    qMsgVarFieldPut((msgPtr), 2, &(offset),	\
			(QModuleUnload_moduleId), &((structAddr)->moduleId),	\
			(QModuleUnload_key), &((structAddr)->key))


#define QModuleUnload_Size		20

#define QModuleUnload	0x80004b	/* 8388683 */
/* Component Registration */

#define QCompRegister_theComponent	0x800000	/* 8388608 */
typedef	QCompDesc	QCompRegister_theComponent_t;

#define QCompRegister_options	0x280006	/* 2621446 */
typedef	UInt16	QCompRegister_options_t;

#define QCompRegister_count	0x380008	/* 3670024 */
typedef	UInt32	QCompRegister_count_t;

#define QCompRegister_varStart	0xc

#define QCompRegister_attr	0x780000	/* 7864320 */
typedef	QCompAttr	QCompRegister_attr_t;

/*
 * QCompRegister (value = 0x80004c) is a message of generic use.
 */


typedef struct {
	QCompDesc	theComponent;
	UInt16	options;
	UInt32	count;
} QCompRegister_t;

#define QCompRegister_get(msgPtr, structAddr, offset)	\
		    qMsgVarFieldGet((msgPtr), 3, &(offset),	\
			(QCompRegister_theComponent), &((structAddr)->theComponent),	\
			(QCompRegister_options), &((structAddr)->options),	\
			(QCompRegister_count), &((structAddr)->count))


#define QCompRegister_put(msgPtr, structAddr, offset)	\
		    qMsgVarFieldPut((msgPtr), 3, &(offset),	\
			(QCompRegister_theComponent), &((structAddr)->theComponent),	\
			(QCompRegister_options), &((structAddr)->options),	\
			(QCompRegister_count), &((structAddr)->count))


#define QCompRegister_Size		12

#define QCompRegister	0x80004c	/* 8388684 */
/* Component Instance Registration */

#define QCompInstRegister_theInstance	0x800000	/* 8388608 */
typedef	QCompDesc	QCompInstRegister_theInstance_t;

#define QCompInstRegister_count	0x300006	/* 3145734 */
typedef	UInt24	QCompInstRegister_count_t;

#define QCompInstRegister_msgToComp	0x300009	/* 3145737 */
typedef	UInt24	QCompInstRegister_msgToComp_t;

/*
 * QCompInstRegister (value = 0x80004d) is a message of generic use.
 */


typedef struct {
	QCompDesc	theInstance;
	UInt24	count;
	UInt24	msgToComp;
} QCompInstRegister_t;

#define QCompInstRegister_get(msgPtr, structAddr, offset)	\
		    qMsgVarFieldGet((msgPtr), 3, &(offset),	\
			(QCompInstRegister_theInstance), &((structAddr)->theInstance),	\
			(QCompInstRegister_count), &((structAddr)->count),	\
			(QCompInstRegister_msgToComp), &((structAddr)->msgToComp))


#define QCompInstRegister_put(msgPtr, structAddr, offset)	\
		    qMsgVarFieldPut((msgPtr), 3, &(offset),	\
			(QCompInstRegister_theInstance), &((structAddr)->theInstance),	\
			(QCompInstRegister_count), &((structAddr)->count),	\
			(QCompInstRegister_msgToComp), &((structAddr)->msgToComp))


#define QCompInstRegister_Size		12

#define QCompInstRegister	0x80004d	/* 8388685 */
/* Component/Instance Deregistration */

#define QCompDeregister_theInstance	0x800000	/* 8388608 */
typedef	QCompDesc	QCompDeregister_theInstance_t;

/*
 * QCompDeregister (value = 0x80004e) is a message of generic use.
 */


typedef struct {
	QCompDesc	theInstance;
} QCompDeregister_t;

#define QCompDeregister_get(msgPtr, structAddr, offset)	\
		    qMsgVarFieldGet((msgPtr), 1, &(offset),	\
			(QCompDeregister_theInstance), &((structAddr)->theInstance))


#define QCompDeregister_put(msgPtr, structAddr, offset)	\
		    qMsgVarFieldPut((msgPtr), 1, &(offset),	\
			(QCompDeregister_theInstance), &((structAddr)->theInstance))


#define QCompDeregister_Size		6

#define QCompDeregister	0x80004e	/* 8388686 */
/* Mercury Message did not reach destination */

#define QMsgUndelivered_err_BadDestAdr	0x23	/* 35 */

#define QMsgUndelivered_err_NoLclBuff	0x24	/* 36 */

#define QMsgUndelivered_err_LclMsgQFull	0x25	/* 37 */

#define QMsgUndelivered_err_InvalidSmartMsgSize	0x26	/* 38 */

#define QMsgUndelivered_err_SmartMsgError	0x27	/* 39 */

#define QMsgUndelivered_err	0x300000	/* 3145728 */
typedef	UInt24	QMsgUndelivered_err_t;

/*
 * QMsgUndelivered (value = 0x80004f) is a message of generic use.
 */


typedef struct {
	UInt24	err;
} QMsgUndelivered_t;

#define QMsgUndelivered_get(msgPtr, structAddr, offset)	\
		    qMsgVarFieldGet((msgPtr), 1, &(offset),	\
			(QMsgUndelivered_err), &((structAddr)->err))


#define QMsgUndelivered_put(msgPtr, structAddr, offset)	\
		    qMsgVarFieldPut((msgPtr), 1, &(offset),	\
			(QMsgUndelivered_err), &((structAddr)->err))


#define QMsgUndelivered_Size		3

#define QMsgUndelivered	0x80004f	/* 8388687 */
/* Notification of child task deletion */

#define QTaskChildDeleted_id	0x300000	/* 3145728 */
typedef	UInt24	QTaskChildDeleted_id_t;

#define QTaskChildDeleted_exitCode	0x300003	/* 3145731 */
typedef	UInt24	QTaskChildDeleted_exitCode_t;

/*
 * QTaskChildDeleted (value = 0x800050) is a message of generic use.
 */


typedef struct {
	UInt24	id;
	UInt24	exitCode;
} QTaskChildDeleted_t;

#define QTaskChildDeleted_get(msgPtr, structAddr, offset)	\
		    qMsgVarFieldGet((msgPtr), 2, &(offset),	\
			(QTaskChildDeleted_id), &((structAddr)->id),	\
			(QTaskChildDeleted_exitCode), &((structAddr)->exitCode))


#define QTaskChildDeleted_put(msgPtr, structAddr, offset)	\
		    qMsgVarFieldPut((msgPtr), 2, &(offset),	\
			(QTaskChildDeleted_id), &((structAddr)->id),	\
			(QTaskChildDeleted_exitCode), &((structAddr)->exitCode))


#define QTaskChildDeleted_Size		6

#define QTaskChildDeleted	0x800050	/* 8388688 */
/* Allocates a previously created cluster matching the specified attributes 
 * and cluster descriptor. */
/* The cluster instance			*/

#define QClusterAllocate_clustSpec	0x800000	/* 8388608 */
typedef	QCompDesc	QClusterAllocate_clustSpec_t;
/* Number of attributes in list		*/

#define QClusterAllocate_count	0x200006	/* 2097158 */
typedef	UInt8	QClusterAllocate_count_t;

#define QClusterAllocate_varStart	0x7
/* Attribute descriptor			*/

#define QClusterAllocate_attr	0x780000	/* 7864320 */
typedef	QCompAttr	QClusterAllocate_attr_t;

/*
 * QClusterAllocate (value = 0x800051) is an input message of generic use.
 */


typedef struct {
	QCompDesc	clustSpec;
	UInt8	count;
} QClusterAllocate_t;

#define QClusterAllocate_get(msgPtr, structAddr, offset)	\
		    qMsgVarFieldGet((msgPtr), 2, &(offset),	\
			(QClusterAllocate_clustSpec), &((structAddr)->clustSpec),	\
			(QClusterAllocate_count), &((structAddr)->count))


#define QClusterAllocate_put(msgPtr, structAddr, offset)	\
		    qMsgVarFieldPut((msgPtr), 2, &(offset),	\
			(QClusterAllocate_clustSpec), &((structAddr)->clustSpec),	\
			(QClusterAllocate_count), &((structAddr)->count))


#define QClusterAllocate_Size		7

#define QClusterAllocate	0x800051	/* 8388689 */
/* Frees a previously allocated cluster */
/* The cluster instance that is to be freed */

#define QClusterFree_clustDesc	0x800000	/* 8388608 */
typedef	QCompDesc	QClusterFree_clustDesc_t;

/*
 * QClusterFree (value = 0x800052) is an input message of generic use.
 */


typedef struct {
	QCompDesc	clustDesc;
} QClusterFree_t;

#define QClusterFree_get(msgPtr, structAddr, offset)	\
		    qMsgVarFieldGet((msgPtr), 1, &(offset),	\
			(QClusterFree_clustDesc), &((structAddr)->clustDesc))


#define QClusterFree_put(msgPtr, structAddr, offset)	\
		    qMsgVarFieldPut((msgPtr), 1, &(offset),	\
			(QClusterFree_clustDesc), &((structAddr)->clustDesc))


#define QClusterFree_Size		6

#define QClusterFree	0x800052	/* 8388690 */
/* Finds the cluster matching the specified attributes. */
/* Starting point for the search		*/

#define QClusterFind_clustStart	0x800000	/* 8388608 */
typedef	QCompDesc	QClusterFind_clustStart_t;
/* Number of attributes in list		*/

#define QClusterFind_count	0x200006	/* 2097158 */
typedef	UInt8	QClusterFind_count_t;

#define QClusterFind_varStart	0x7
/* Attribute descriptor			*/

#define QClusterFind_attr	0x780000	/* 7864320 */
typedef	QCompAttr	QClusterFind_attr_t;

/*
 * QClusterFind (value = 0x800053) is an input message of generic use.
 */


typedef struct {
	QCompDesc	clustStart;
	UInt8	count;
} QClusterFind_t;

#define QClusterFind_get(msgPtr, structAddr, offset)	\
		    qMsgVarFieldGet((msgPtr), 2, &(offset),	\
			(QClusterFind_clustStart), &((structAddr)->clustStart),	\
			(QClusterFind_count), &((structAddr)->count))


#define QClusterFind_put(msgPtr, structAddr, offset)	\
		    qMsgVarFieldPut((msgPtr), 2, &(offset),	\
			(QClusterFind_clustStart), &((structAddr)->clustStart),	\
			(QClusterFind_count), &((structAddr)->count))


#define QClusterFind_Size		7

#define QClusterFind	0x800053	/* 8388691 */
/* Adds one or more cluster attributes to a cluster */
/* Number of attributes in list		*/

#define QClusterAttrAdd_count	0x200000	/* 2097152 */
typedef	UInt8	QClusterAttrAdd_count_t;

#define QClusterAttrAdd_varStart	0x1
/* Attribute descriptor			*/

#define QClusterAttrAdd_attr	0x780000	/* 7864320 */
typedef	QCompAttr	QClusterAttrAdd_attr_t;

/*
 * QClusterAttrAdd (value = 0x800054) is an input message of generic use.
 */


typedef struct {
	UInt8	count;
} QClusterAttrAdd_t;

#define QClusterAttrAdd_get(msgPtr, structAddr, offset)	\
		    qMsgVarFieldGet((msgPtr), 1, &(offset),	\
			(QClusterAttrAdd_count), &((structAddr)->count))


#define QClusterAttrAdd_put(msgPtr, structAddr, offset)	\
		    qMsgVarFieldPut((msgPtr), 1, &(offset),	\
			(QClusterAttrAdd_count), &((structAddr)->count))


#define QClusterAttrAdd_Size		1

#define QClusterAttrAdd	0x800054	/* 8388692 */
/* Removes one or more cluster attributes to a cluster */
/* Number of attributes in list		*/

#define QClusterAttrRemove_count	0x200000	/* 2097152 */
typedef	UInt8	QClusterAttrRemove_count_t;

#define QClusterAttrRemove_varStart	0x1
/* Attribute descriptor			*/

#define QClusterAttrRemove_attr	0x780000	/* 7864320 */
typedef	QCompAttr	QClusterAttrRemove_attr_t;

/*
 * QClusterAttrRemove (value = 0x800055) is an input message of generic use.
 */


typedef struct {
	UInt8	count;
} QClusterAttrRemove_t;

#define QClusterAttrRemove_get(msgPtr, structAddr, offset)	\
		    qMsgVarFieldGet((msgPtr), 1, &(offset),	\
			(QClusterAttrRemove_count), &((structAddr)->count))


#define QClusterAttrRemove_put(msgPtr, structAddr, offset)	\
		    qMsgVarFieldPut((msgPtr), 1, &(offset),	\
			(QClusterAttrRemove_count), &((structAddr)->count))


#define QClusterAttrRemove_Size		1

#define QClusterAttrRemove	0x800055	/* 8388693 */
/* Causes the kernel to lock the cluster */
/* Causes the kernel to unlock the cluster */

/*
 * QClusterLock (value = 0x800056) is an input message of generic use.
 */

#define QClusterLock_Size		0

#define QClusterLock	0x800056	/* 8388694 */
/* Message sent in response to QClusterUnlock */

/*
 * QClusterUnlock (value = 0x800057) is an input message of generic use.
 */

#define QClusterUnlock_Size		0

#define QClusterUnlock	0x800057	/* 8388695 */
/* Flag to indicate cluster was unlocked */

#define QClusterUnlockCmplt_clusterUnlocked	0x200000	/* 2097152 */
typedef	UInt8	QClusterUnlockCmplt_clusterUnlocked_t;
/* Number of instances to unlocked		*/

#define QClusterUnlockCmplt_count	0x200001	/* 2097153 */
typedef	UInt8	QClusterUnlockCmplt_count_t;

#define QClusterUnlockCmplt_varStart	0x2
/* list of instances 			*/

#define QClusterUnlockCmplt_theInstance	0x800000	/* 8388608 */
typedef	QCompDesc	QClusterUnlockCmplt_theInstance_t;

/*
 * QClusterUnlockCmplt (value = 0x800058) is an input message of generic use.
 */


typedef struct {
	UInt8	clusterUnlocked;
	UInt8	count;
} QClusterUnlockCmplt_t;

#define QClusterUnlockCmplt_get(msgPtr, structAddr, offset)	\
		    qMsgVarFieldGet((msgPtr), 2, &(offset),	\
			(QClusterUnlockCmplt_clusterUnlocked), &((structAddr)->clusterUnlocked),	\
			(QClusterUnlockCmplt_count), &((structAddr)->count))


#define QClusterUnlockCmplt_put(msgPtr, structAddr, offset)	\
		    qMsgVarFieldPut((msgPtr), 2, &(offset),	\
			(QClusterUnlockCmplt_clusterUnlocked), &((structAddr)->clusterUnlocked),	\
			(QClusterUnlockCmplt_count), &((structAddr)->count))


#define QClusterUnlockCmplt_Size		2

#define QClusterUnlockCmplt	0x800058	/* 8388696 */
/* Message to request the use of a set of Mercury addresses */
/* Number of components to use	*/

#define QCompUse_count	0x200000	/* 2097152 */
typedef	UInt8	QCompUse_count_t;

#define QCompUse_varStart	0x1
/* list of instances 			*/

#define QCompUse_theInstance	0x800000	/* 8388608 */
typedef	QCompDesc	QCompUse_theInstance_t;
/* type of use				*/

#define QCompUse_useType	0x380000	/* 3670016 */
typedef	UInt32	QCompUse_useType_t;

/*
 * QCompUse (value = 0x800059) is an input message of generic use.
 */


typedef struct {
	UInt8	count;
} QCompUse_t;

#define QCompUse_get(msgPtr, structAddr, offset)	\
		    qMsgVarFieldGet((msgPtr), 1, &(offset),	\
			(QCompUse_count), &((structAddr)->count))


#define QCompUse_put(msgPtr, structAddr, offset)	\
		    qMsgVarFieldPut((msgPtr), 1, &(offset),	\
			(QCompUse_count), &((structAddr)->count))


#define QCompUse_Size		1

#define QCompUse	0x800059	/* 8388697 */
/* Message to indicate that the client has finished using a set of Mercury 
 * addresses */
/* Number of components to un-use	*/

#define QCompUnuse_count	0x200000	/* 2097152 */
typedef	UInt8	QCompUnuse_count_t;

#define QCompUnuse_varStart	0x1
/* list of instances 			*/

#define QCompUnuse_theInstance	0x800000	/* 8388608 */
typedef	QCompDesc	QCompUnuse_theInstance_t;

/*
 * QCompUnuse (value = 0x80005a) is an input message of generic use.
 */


typedef struct {
	UInt8	count;
} QCompUnuse_t;

#define QCompUnuse_get(msgPtr, structAddr, offset)	\
		    qMsgVarFieldGet((msgPtr), 1, &(offset),	\
			(QCompUnuse_count), &((structAddr)->count))


#define QCompUnuse_put(msgPtr, structAddr, offset)	\
		    qMsgVarFieldPut((msgPtr), 1, &(offset),	\
			(QCompUnuse_count), &((structAddr)->count))


#define QCompUnuse_Size		1

#define QCompUnuse	0x80005a	/* 8388698 */
/* Message to indicate that the component address has gone away */
/* expired component			*/

#define QCompExited_desc	0x800000	/* 8388608 */
typedef	QCompDesc	QCompExited_desc_t;

/*
 * QCompExited (value = 0x80005b) is a message of generic use.
 */


typedef struct {
	QCompDesc	desc;
} QCompExited_t;

#define QCompExited_get(msgPtr, structAddr, offset)	\
		    qMsgVarFieldGet((msgPtr), 1, &(offset),	\
			(QCompExited_desc), &((structAddr)->desc))


#define QCompExited_put(msgPtr, structAddr, offset)	\
		    qMsgVarFieldPut((msgPtr), 1, &(offset),	\
			(QCompExited_desc), &((structAddr)->desc))


#define QCompExited_Size		6

#define QCompExited	0x80005b	/* 8388699 */
/* Message to indicate that the host address has gone away */
/* expired component					*/

#define QHostExited_desc	0x800000	/* 8388608 */
typedef	QCompDesc	QHostExited_desc_t;
/* type of use performed by the expired component 	*/

#define QHostExited_useType	0x380006	/* 3670022 */
typedef	UInt32	QHostExited_useType_t;

/*
 * QHostExited (value = 0x80005c) is a message of generic use.
 */


typedef struct {
	QCompDesc	desc;
	UInt32	useType;
} QHostExited_t;

#define QHostExited_get(msgPtr, structAddr, offset)	\
		    qMsgVarFieldGet((msgPtr), 2, &(offset),	\
			(QHostExited_desc), &((structAddr)->desc),	\
			(QHostExited_useType), &((structAddr)->useType))


#define QHostExited_put(msgPtr, structAddr, offset)	\
		    qMsgVarFieldPut((msgPtr), 2, &(offset),	\
			(QHostExited_desc), &((structAddr)->desc),	\
			(QHostExited_useType), &((structAddr)->useType))


#define QHostExited_Size		10

#define QHostExited	0x80005c	/* 8388700 */
/* Message to indicate that client wishes to be notified of failures in 
 * platform resources */
/* Message to indicate that certain platform resources have failed. */

/*
 * QRegisterNotify (value = 0x80005d) is an input message of generic use.
 */

#define QRegisterNotify_Size		0

#define QRegisterNotify	0x80005d	/* 8388701 */
/* Number of components failed		*/

#define QFailureNotify_count	0x200000	/* 2097152 */
typedef	UInt8	QFailureNotify_count_t;

#define QFailureNotify_varStart	0x1
/* list of components 			*/

#define QFailureNotify_theComponent	0x800000	/* 8388608 */
typedef	QCompDesc	QFailureNotify_theComponent_t;
/* number of instances allocated		*/

#define QFailureNotify_numAllocated	0x200000	/* 2097152 */
typedef	UInt8	QFailureNotify_numAllocated_t;
/* attributes of each component		*/

#define QFailureNotify_attr	0x780000	/* 7864320 */
typedef	QCompAttr	QFailureNotify_attr_t;

/*
 * QFailureNotify (value = 0x80005e) is an output message of generic use.
 */


typedef struct {
	UInt8	count;
} QFailureNotify_t;

#define QFailureNotify_get(msgPtr, structAddr, offset)	\
		    qMsgVarFieldGet((msgPtr), 1, &(offset),	\
			(QFailureNotify_count), &((structAddr)->count))


#define QFailureNotify_put(msgPtr, structAddr, offset)	\
		    qMsgVarFieldPut((msgPtr), 1, &(offset),	\
			(QFailureNotify_count), &((structAddr)->count))


#define QFailureNotify_Size		1

#define QFailureNotify	0x80005e	/* 8388702 */
/* Message to request Online Diagnostic Status. */
/* Message to request Online Diagnostic Status. */

/*
 * QOnDiagStatus (value = 0xc20000) is a message of generic use.
 */

#define QOnDiagStatus_Size		0

#define QOnDiagStatus	0xc20000	/* 12713984 */
/* Message containing the current results of Online Diagnostics.*/

/*
 * QOnDiagQuery (value = 0x80005f) is a message of generic use.
 */

#define QOnDiagQuery_Size		0

#define QOnDiagQuery	0x80005f	/* 8388703 */
/* Status of CP tests */

#define QOnDiagResult_status	0x300000	/* 3145728 */
typedef	UInt24	QOnDiagResult_status_t;
/* CP clock time of CP tests */

#define QOnDiagResult_reportTime	0x300003	/* 3145731 */
typedef	UInt24	QOnDiagResult_reportTime_t;
/* number of SP Statuses to be returned */

#define QOnDiagResult_count	0x200006	/* 2097158 */
typedef	UInt8	QOnDiagResult_count_t;

#define QOnDiagResult_varStart	0x7
/* Status of SP tests */

#define QOnDiagResult_SpStatus	0x300000	/* 3145728 */
typedef	UInt24	QOnDiagResult_SpStatus_t;

/*
 * QOnDiagResult (value = 0x800060) is a message of generic use.
 */


typedef struct {
	UInt24	status;
	UInt24	reportTime;
	UInt8	count;
} QOnDiagResult_t;

#define QOnDiagResult_get(msgPtr, structAddr, offset)	\
		    qMsgVarFieldGet((msgPtr), 3, &(offset),	\
			(QOnDiagResult_status), &((structAddr)->status),	\
			(QOnDiagResult_reportTime), &((structAddr)->reportTime),	\
			(QOnDiagResult_count), &((structAddr)->count))


#define QOnDiagResult_put(msgPtr, structAddr, offset)	\
		    qMsgVarFieldPut((msgPtr), 3, &(offset),	\
			(QOnDiagResult_status), &((structAddr)->status),	\
			(QOnDiagResult_reportTime), &((structAddr)->reportTime),	\
			(QOnDiagResult_count), &((structAddr)->count))


#define QOnDiagResult_Size		7

#define QOnDiagResult	0x800060	/* 8388704 */
/* Message to unregister notification of failures in platform resources */
/* Find all components matching the specifications */

/*
 * QUnregisterNotify (value = 0x800061) is an input message of generic use.
 */

#define QUnregisterNotify_Size		0

#define QUnregisterNotify	0x800061	/* 8388705 */

#define QCompFindAll_startDesc	0x800000	/* 8388608 */
typedef	QCompDesc	QCompFindAll_startDesc_t;

#define QCompFindAll_endDesc	0x800006	/* 8388614 */
typedef	QCompDesc	QCompFindAll_endDesc_t;

#define QCompFindAll_count	0x38000c	/* 3670028 */
typedef	UInt32	QCompFindAll_count_t;

#define QCompFindAll_varStart	0x10

#define QCompFindAll_attr	0x780000	/* 7864320 */
typedef	QCompAttr	QCompFindAll_attr_t;

/*
 * QCompFindAll (value = 0x800062) is a message of generic use.
 */


typedef struct {
	QCompDesc	startDesc;
	QCompDesc	endDesc;
	UInt32	count;
} QCompFindAll_t;

#define QCompFindAll_get(msgPtr, structAddr, offset)	\
		    qMsgVarFieldGet((msgPtr), 3, &(offset),	\
			(QCompFindAll_startDesc), &((structAddr)->startDesc),	\
			(QCompFindAll_endDesc), &((structAddr)->endDesc),	\
			(QCompFindAll_count), &((structAddr)->count))


#define QCompFindAll_put(msgPtr, structAddr, offset)	\
		    qMsgVarFieldPut((msgPtr), 3, &(offset),	\
			(QCompFindAll_startDesc), &((structAddr)->startDesc),	\
			(QCompFindAll_endDesc), &((structAddr)->endDesc),	\
			(QCompFindAll_count), &((structAddr)->count))


#define QCompFindAll_Size		16

#define QCompFindAll	0x800062	/* 8388706 */
/* Similar to QComponentResult but contains information for multiple components */
/* Number of components 				*/

#define QCompMultipleResult_count	0x200000	/* 2097152 */
typedef	UInt8	QCompMultipleResult_count_t;
/* Starting compdesc for the next result message	*/

#define QCompMultipleResult_nextComponent	0x800001	/* 8388609 */
typedef	QCompDesc	QCompMultipleResult_nextComponent_t;

#define QCompMultipleResult_varStart	0x7
/* list of components 					*/

#define QCompMultipleResult_theComponent	0x800000	/* 8388608 */
typedef	QCompDesc	QCompMultipleResult_theComponent_t;
/* attributes of each component			*/

#define QCompMultipleResult_attr	0x780000	/* 7864320 */
typedef	QCompAttr	QCompMultipleResult_attr_t;

/*
 * QCompMultipleResult (value = 0x800063) is an output message of generic use.
 */


typedef struct {
	UInt8	count;
	QCompDesc	nextComponent;
} QCompMultipleResult_t;

#define QCompMultipleResult_get(msgPtr, structAddr, offset)	\
		    qMsgVarFieldGet((msgPtr), 2, &(offset),	\
			(QCompMultipleResult_count), &((structAddr)->count),	\
			(QCompMultipleResult_nextComponent), &((structAddr)->nextComponent))


#define QCompMultipleResult_put(msgPtr, structAddr, offset)	\
		    qMsgVarFieldPut((msgPtr), 2, &(offset),	\
			(QCompMultipleResult_count), &((structAddr)->count),	\
			(QCompMultipleResult_nextComponent), &((structAddr)->nextComponent))


#define QCompMultipleResult_Size		7

#define QCompMultipleResult	0x800063	/* 8388707 */
/* Event message sent to components when the board has finished download and 
 * configuration. */
/* An HDLC status event occurred.*/

/*
 * QCompDownloadComplete (value = 0x800082) is an output message of generic use.
 */

#define QCompDownloadComplete_Size		0

#define QCompDownloadComplete	0x800082	/* 8388738 */

#define QHDLCStatus_deviceId	0x200000	/* 2097152 */
typedef	UInt8	QHDLCStatus_deviceId_t;

#define QHDLCStatus_deviceType	0x200001	/* 2097153 */
typedef	UInt8	QHDLCStatus_deviceType_t;

#define QHDLCStatus_interfaceId	0x200002	/* 2097154 */
typedef	UInt8	QHDLCStatus_interfaceId_t;

#define QHDLCStatus_channelId	0x200003	/* 2097155 */
typedef	UInt8	QHDLCStatus_channelId_t;

#define QHDLCStatus_statusType	0x200004	/* 2097156 */
typedef	UInt8	QHDLCStatus_statusType_t;

#define QHDLCStatus_time	0x300005	/* 3145733 */
typedef	UInt24	QHDLCStatus_time_t;

/*
 * QHDLCStatus (value = 0x800065) is a message of generic use.
 */


typedef struct {
	UInt8	deviceId;
	UInt8	deviceType;
	UInt8	interfaceId;
	UInt8	channelId;
	UInt8	statusType;
	UInt24	time;
} QHDLCStatus_t;

#define QHDLCStatus_get(msgPtr, structAddr, offset)	\
		    qMsgVarFieldGet((msgPtr), 6, &(offset),	\
			(QHDLCStatus_deviceId), &((structAddr)->deviceId),	\
			(QHDLCStatus_deviceType), &((structAddr)->deviceType),	\
			(QHDLCStatus_interfaceId), &((structAddr)->interfaceId),	\
			(QHDLCStatus_channelId), &((structAddr)->channelId),	\
			(QHDLCStatus_statusType), &((structAddr)->statusType),	\
			(QHDLCStatus_time), &((structAddr)->time))


#define QHDLCStatus_put(msgPtr, structAddr, offset)	\
		    qMsgVarFieldPut((msgPtr), 6, &(offset),	\
			(QHDLCStatus_deviceId), &((structAddr)->deviceId),	\
			(QHDLCStatus_deviceType), &((structAddr)->deviceType),	\
			(QHDLCStatus_interfaceId), &((structAddr)->interfaceId),	\
			(QHDLCStatus_channelId), &((structAddr)->channelId),	\
			(QHDLCStatus_statusType), &((structAddr)->statusType),	\
			(QHDLCStatus_time), &((structAddr)->time))


#define QHDLCStatus_Size		8

#define QHDLCStatus	0x800065	/* 8388709 */

/**********************************************************************/
/****** RE_DEFINE HDLC MESSAGE MACRO TO USE LOCAL MESSAGES **********/
/**********************************************************************/


/* make sure no-one undoes this change by re-making mmdl */
#define QHDLCStatusMessageIsLocal 
/*will cause syntax error if not present */
#undef QHDLCStatus_get
#undef QHDLCStatus_put
#undef QHDLCStatus_deviceId
#undef QHDLCStatus_deviceType
#undef QHDLCStatus_interfaceId
#undef QHDLCStatus_channelId
#undef QHDLCStatus_statusType
#undef QHDLCStatus_time
#undef QHDLCStatus_Size

#define QHDLCStatus_Size sizeof(QHDLCStatus_t)

#define QHDLCStatus_get(msgPtr, structAddr, offset) \
{ \
QHDLCStatus_t *pQHDLCStatusBody; \
pQHDLCStatusBody = (QHDLCStatus_t *)((*(msgPtr)).data); \
(*(structAddr)).deviceId = (*pQHDLCStatusBody).deviceId; \
(*(structAddr)).deviceType = (*pQHDLCStatusBody).deviceType; \
(*(structAddr)).interfaceId = (*pQHDLCStatusBody).interfaceId; \
(*(structAddr)).channelId = (*pQHDLCStatusBody).channelId; \
(*(structAddr)).statusType = (*pQHDLCStatusBody).statusType; \
(*(structAddr)).time = (*pQHDLCStatusBody).time; \
}

#define QHDLCStatus_put(msgPtr, structAddr, offset) \
{ \
QHDLCStatus_t *pQHDLCStatusBody; \
pQHDLCStatusBody = (QHDLCStatus_t *)((*(msgPtr)).data); \
(*pQHDLCStatusBody).deviceId = (*(structAddr)).deviceId; \
(*pQHDLCStatusBody).deviceType = (*(structAddr)).deviceType; \
(*pQHDLCStatusBody).interfaceId = (*(structAddr)).interfaceId; \
(*pQHDLCStatusBody).channelId = (*(structAddr)).channelId; \
(*pQHDLCStatusBody).statusType = (*(structAddr)).statusType; \
(*pQHDLCStatusBody).time = (*(structAddr)).time; \
}

/* An HDLC frame was received from the remote end. */

#define QHDLCFrameRcvd_deviceId	0x200000	/* 2097152 */
typedef	UInt8	QHDLCFrameRcvd_deviceId_t;

#define QHDLCFrameRcvd_deviceType	0x200001	/* 2097153 */
typedef	UInt8	QHDLCFrameRcvd_deviceType_t;

#define QHDLCFrameRcvd_interfaceId	0x200002	/* 2097154 */
typedef	UInt8	QHDLCFrameRcvd_interfaceId_t;

#define QHDLCFrameRcvd_channelId	0x200003	/* 2097155 */
typedef	UInt8	QHDLCFrameRcvd_channelId_t;

#define QHDLCFrameRcvd_time	0x300004	/* 3145732 */
typedef	UInt24	QHDLCFrameRcvd_time_t;

#define QHDLCFrameRcvd_length	0x280007	/* 2621447 */
typedef	UInt16	QHDLCFrameRcvd_length_t;

#define QHDLCFrameRcvd_varStart	0x9

#define QHDLCFrameRcvd_data	0x200000	/* 2097152 */
typedef	UInt8	QHDLCFrameRcvd_data_t;

/*
 * QHDLCFrameRcvd (value = 0x800066) is a message of generic use.
 */


typedef struct {
	UInt8	deviceId;
	UInt8	deviceType;
	UInt8	interfaceId;
	UInt8	channelId;
	UInt24	time;
	UInt16	length;
} QHDLCFrameRcvd_t;

#define QHDLCFrameRcvd_get(msgPtr, structAddr, offset)	\
		    qMsgVarFieldGet((msgPtr), 6, &(offset),	\
			(QHDLCFrameRcvd_deviceId), &((structAddr)->deviceId),	\
			(QHDLCFrameRcvd_deviceType), &((structAddr)->deviceType),	\
			(QHDLCFrameRcvd_interfaceId), &((structAddr)->interfaceId),	\
			(QHDLCFrameRcvd_channelId), &((structAddr)->channelId),	\
			(QHDLCFrameRcvd_time), &((structAddr)->time),	\
			(QHDLCFrameRcvd_length), &((structAddr)->length))


#define QHDLCFrameRcvd_put(msgPtr, structAddr, offset)	\
		    qMsgVarFieldPut((msgPtr), 6, &(offset),	\
			(QHDLCFrameRcvd_deviceId), &((structAddr)->deviceId),	\
			(QHDLCFrameRcvd_deviceType), &((structAddr)->deviceType),	\
			(QHDLCFrameRcvd_interfaceId), &((structAddr)->interfaceId),	\
			(QHDLCFrameRcvd_channelId), &((structAddr)->channelId),	\
			(QHDLCFrameRcvd_time), &((structAddr)->time),	\
			(QHDLCFrameRcvd_length), &((structAddr)->length))


#define QHDLCFrameRcvd_Size		9

#define QHDLCFrameRcvd	0x800066	/* 8388710 */

/**********************************************************************/
/****** RE_DEFINE HDLC MESSAGE MACRO TO USE LOCAL MESSAGES **********/
/**********************************************************************/


/* make sure no-one undoes this change by re-making mmdl */
#define QHDLCFrameRcvdMessageIsLocal 
/*will cause syntax error if not present */
#undef QHDLCFrameRcvd_get
#undef QHDLCFrameRcvd_put
#undef QHDLCFrameRcvd_deviceId
#undef QHDLCFrameRcvd_deviceType
#undef QHDLCFrameRcvd_interfaceId
#undef QHDLCFrameRcvd_channelId
#undef QHDLCFrameRcvd_time
#undef QHDLCFrameRcvd_length
#undef QHDLCFrameRcvd_Size
#undef QHDLCFrameRcvd_varStart


#define QHDLCFrameRcvd_Size sizeof(QHDLCFrameRcvd_t)
#define QHDLCFrameRcvd_varStart QHDLCFrameRcvd_Size

#define QHDLCFrameRcvd_get(msgPtr, structAddr, offset) \
{ \
QHDLCFrameRcvd_t *pQHDLCFrameRcvdBody; \
pQHDLCFrameRcvdBody = (QHDLCFrameRcvd_t *)((*(msgPtr)).data); \
(*(structAddr)).deviceId = (*pQHDLCFrameRcvdBody).deviceId; \
(*(structAddr)).deviceType = (*pQHDLCFrameRcvdBody).deviceType; \
(*(structAddr)).interfaceId = (*pQHDLCFrameRcvdBody).interfaceId; \
(*(structAddr)).channelId = (*pQHDLCFrameRcvdBody).channelId; \
(*(structAddr)).time = (*pQHDLCFrameRcvdBody).time; \
(*(structAddr)).length = (*pQHDLCFrameRcvdBody).length; \
}

#define QHDLCFrameRcvd_put(msgPtr, structAddr, offset) \
{ \
QHDLCFrameRcvd_t *pQHDLCFrameRcvdBody; \
pQHDLCFrameRcvdBody = (QHDLCFrameRcvd_t *)((*(msgPtr)).data); \
(*pQHDLCFrameRcvdBody).deviceId = (*(structAddr)).deviceId; \
(*pQHDLCFrameRcvdBody).deviceType = (*(structAddr)).deviceType; \
(*pQHDLCFrameRcvdBody).interfaceId = (*(structAddr)).interfaceId; \
(*pQHDLCFrameRcvdBody).channelId = (*(structAddr)).channelId; \
(*pQHDLCFrameRcvdBody).time = (*(structAddr)).time; \
(*pQHDLCFrameRcvdBody).length = (*(structAddr)).length; \
}

/* A trace buffer partition block has been filled. */

#define QHDLCTraceBlkFilled_deviceId	0x200000	/* 2097152 */
typedef	UInt8	QHDLCTraceBlkFilled_deviceId_t;

#define QHDLCTraceBlkFilled_deviceType	0x200001	/* 2097153 */
typedef	UInt8	QHDLCTraceBlkFilled_deviceType_t;

#define QHDLCTraceBlkFilled_interfaceId	0x200002	/* 2097154 */
typedef	UInt8	QHDLCTraceBlkFilled_interfaceId_t;

#define QHDLCTraceBlkFilled_channelId	0x200003	/* 2097155 */
typedef	UInt8	QHDLCTraceBlkFilled_channelId_t;

#define QHDLCTraceBlkFilled_pBuffer	0x600004	/* 6291460 */
typedef	QMemRef	QHDLCTraceBlkFilled_pBuffer_t;

#define QHDLCTraceBlkFilled_length	0x280008	/* 2621448 */
typedef	UInt16	QHDLCTraceBlkFilled_length_t;

/*
 * QHDLCTraceBlkFilled (value = 0x800067) is a message of generic use.
 */


typedef struct {
	UInt8	deviceId;
	UInt8	deviceType;
	UInt8	interfaceId;
	UInt8	channelId;
	QMemRef	pBuffer;
	UInt16	length;
} QHDLCTraceBlkFilled_t;

#define QHDLCTraceBlkFilled_get(msgPtr, structAddr, offset)	\
		    qMsgVarFieldGet((msgPtr), 6, &(offset),	\
			(QHDLCTraceBlkFilled_deviceId), &((structAddr)->deviceId),	\
			(QHDLCTraceBlkFilled_deviceType), &((structAddr)->deviceType),	\
			(QHDLCTraceBlkFilled_interfaceId), &((structAddr)->interfaceId),	\
			(QHDLCTraceBlkFilled_channelId), &((structAddr)->channelId),	\
			(QHDLCTraceBlkFilled_pBuffer), &((structAddr)->pBuffer),	\
			(QHDLCTraceBlkFilled_length), &((structAddr)->length))


#define QHDLCTraceBlkFilled_put(msgPtr, structAddr, offset)	\
		    qMsgVarFieldPut((msgPtr), 6, &(offset),	\
			(QHDLCTraceBlkFilled_deviceId), &((structAddr)->deviceId),	\
			(QHDLCTraceBlkFilled_deviceType), &((structAddr)->deviceType),	\
			(QHDLCTraceBlkFilled_interfaceId), &((structAddr)->interfaceId),	\
			(QHDLCTraceBlkFilled_channelId), &((structAddr)->channelId),	\
			(QHDLCTraceBlkFilled_pBuffer), &((structAddr)->pBuffer),	\
			(QHDLCTraceBlkFilled_length), &((structAddr)->length))


#define QHDLCTraceBlkFilled_Size		10

#define QHDLCTraceBlkFilled	0x800067	/* 8388711 */

/**********************************************************************/
/****** RE_DEFINE HDLC MESSAGE MACRO TO USE LOCAL MESSAGES **********/
/**********************************************************************/

/* make sure no-one undoes this change by re-making mmdl */
#define QHDLCTraceBlkFilledMessageIsLocal 
/*will cause syntax error if not present */
#undef QHDLCTraceBlkFilled_get
#undef QHDLCTraceBlkFilled_put
#undef QHDLCTraceBlkFilled_deviceId
#undef QHDLCTraceBlkFilled_deviceType
#undef QHDLCTraceBlkFilled_interfaceId
#undef QHDLCTraceBlkFilled_channelId
#undef QHDLCTraceBlkFilled_pBuffer
#undef QHDLCTraceBlkFilled_length
#undef QHDLCTraceBlkFilled_Size

#define QHDLCTraceBlkFilled_Size sizeof(QHDLCTraceBlkFilled_t)

#define QHDLCTraceBlkFilled_get(msgPtr, structAddr, offset) \
{ \
QHDLCTraceBlkFilled_t *pQHDLCTraceBlkFilledBody; \
pQHDLCTraceBlkFilledBody =(QHDLCTraceBlkFilled_t *)((*(msgPtr)).data); \
(*(structAddr)).deviceId = (*pQHDLCTraceBlkFilledBody).deviceId; \
(*(structAddr)).deviceType = (*pQHDLCTraceBlkFilledBody).deviceType; \
(*(structAddr)).interfaceId = (*pQHDLCTraceBlkFilledBody).interfaceId; \
(*(structAddr)).channelId = (*pQHDLCTraceBlkFilledBody).channelId; \
(*(structAddr)).pBuffer = (*pQHDLCTraceBlkFilledBody).pBuffer; \
(*(structAddr)).length = (*pQHDLCTraceBlkFilledBody).length; \
}

#define QHDLCTraceBlkFilled_put(msgPtr, structAddr, offset) \
{ \
QHDLCTraceBlkFilled_t *pQHDLCTraceBlkFilledBody; \
pQHDLCTraceBlkFilledBody =(QHDLCTraceBlkFilled_t *)((*(msgPtr)).data); \
(*pQHDLCTraceBlkFilledBody).deviceId = (*(structAddr)).deviceId; \
(*pQHDLCTraceBlkFilledBody).deviceType = (*(structAddr)).deviceType; \
(*pQHDLCTraceBlkFilledBody).interfaceId = (*(structAddr)).interfaceId; \
(*pQHDLCTraceBlkFilledBody).channelId = (*(structAddr)).channelId; \
(*pQHDLCTraceBlkFilledBody).pBuffer = (*(structAddr)).pBuffer; \
(*pQHDLCTraceBlkFilledBody).length = (*(structAddr)).length; \
}

/* Message from ISR. */

#define QHDLCQueueMsg_poolId	0x280000	/* 2621440 */
typedef	UInt16	QHDLCQueueMsg_poolId_t;

#define QHDLCQueueMsg_numMapEntries	0x280002	/* 2621442 */
typedef	UInt16	QHDLCQueueMsg_numMapEntries_t;

#define QHDLCQueueMsg_varStart	0x4

#define QHDLCQueueMsg_data	0x200000	/* 2097152 */
typedef	UInt8	QHDLCQueueMsg_data_t;

/*
 * QHDLCQueueMsg (value = 0x800068) is a message of generic use.
 */


typedef struct {
	UInt16	poolId;
	UInt16	numMapEntries;
} QHDLCQueueMsg_t;

#define QHDLCQueueMsg_get(msgPtr, structAddr, offset)	\
		    qMsgVarFieldGet((msgPtr), 2, &(offset),	\
			(QHDLCQueueMsg_poolId), &((structAddr)->poolId),	\
			(QHDLCQueueMsg_numMapEntries), &((structAddr)->numMapEntries))


#define QHDLCQueueMsg_put(msgPtr, structAddr, offset)	\
		    qMsgVarFieldPut((msgPtr), 2, &(offset),	\
			(QHDLCQueueMsg_poolId), &((structAddr)->poolId),	\
			(QHDLCQueueMsg_numMapEntries), &((structAddr)->numMapEntries))


#define QHDLCQueueMsg_Size		4

#define QHDLCQueueMsg	0x800068	/* 8388712 */

/**********************************************************************/
/****** RE_DEFINE HDLC MESSAGE MACRO TO USE LOCAL MESSAGES **********/
/**********************************************************************/

/* make sure no-one undoes this change by re-making mmdl */
#define QHDLCQueueMsgMessageIsLocal 
/*will cause syntax error if not present */
#undef QHDLCQueueMsg_get
#undef QHDLCQueueMsg_put
#undef QHDLCQueueMsg_poolId
#undef QHDLCQueueMsg_numMapEntries
#undef QHDLCQueueMsg_length
#undef QHDLCQueueMsg_Size

#define QHDLCQueueMsg_Size sizeof(QHDLCQueueMsg_t)

#define QHDLCQueueMsg_get(msgPtr, structAddr, offset) \
{ \
QHDLCQueueMsg_t *pQHDLCQueueMsgBody; \
pQHDLCQueueMsgBody = (QHDLCQueueMsg_t *)((*(msgPtr)).data); \
(*(structAddr)).poolId = (*pQHDLCQueueMsgBody).poolId; \
(*(structAddr)).numMapEntries = (*pQHDLCQueueMsgBody).numMapEntries; \
(*(structAddr)).length = (*pQHDLCQueueMsgBody).length; \
}

#define QHDLCQueueMsg_put(msgPtr, structAddr, offset) \
{ \
QHDLCQueueMsg_t *pQHDLCQueueMsgBody; \
pQHDLCQueueMsgBody = (QHDLCQueueMsg_t *)((*(msgPtr)).data); \
(*pQHDLCQueueMsgBody).poolId = (*(structAddr)).poolId; \
(*pQHDLCQueueMsgBody).numMapEntries = (*(structAddr)).numMapEntries; \
(*pQHDLCQueueMsgBody).length = (*(structAddr)).length; \
}

/* Message to request Processor(s) Status. */

/* set request mode of processor status */
#define IDLE_MODE			0
#define ALARM_MODE			1 /* request solicited message */	
#define POLL_MODE			2 /* request poll message */	

/* select error type */
#define LATEST_ERR			0  /* select current error information */
#define OVERALL_ERR			1  /* select the most severe error information */	

/*flag to select overall or latest proc status*/

#define QProcStatusRequest_errSelect	0x200000	/* 2097152 */
typedef	UInt8	QProcStatusRequest_errSelect_t;
/* Processor number */

#define QProcStatusRequest_procNum	0x200001	/* 2097153 */
typedef	UInt8	QProcStatusRequest_procNum_t;

/*
 * QProcStatusRequest (value = 0x800069) is a message of generic use.
 */


typedef struct {
	UInt8	errSelect;
	UInt8	procNum;
} QProcStatusRequest_t;

#define QProcStatusRequest_get(msgPtr, structAddr, offset)	\
		    qMsgVarFieldGet((msgPtr), 2, &(offset),	\
			(QProcStatusRequest_errSelect), &((structAddr)->errSelect),	\
			(QProcStatusRequest_procNum), &((structAddr)->procNum))


#define QProcStatusRequest_put(msgPtr, structAddr, offset)	\
		    qMsgVarFieldPut((msgPtr), 2, &(offset),	\
			(QProcStatusRequest_errSelect), &((structAddr)->errSelect),	\
			(QProcStatusRequest_procNum), &((structAddr)->procNum))


#define QProcStatusRequest_Size		2

#define QProcStatusRequest	0x800069	/* 8388713 */
/* Reply message contains processor(s)'s status.*/

#define MAX_PARM	8  /* updated this if parm[]'s size is changed */
#define MAX_LOCFILE	32  /* updated this if locFile's size is changed */


#define QProcStatusReply_procStat_procNum	0x300000	/* 3145728 */
typedef	UInt24	QProcStatusReply_procStat_procNum_t;

#define QProcStatusReply_procStat_status	0x300003	/* 3145731 */
typedef	UInt24	QProcStatusReply_procStat_status_t;

#define QProcStatusReply_procStat_reportTime	0x300006	/* 3145734 */
typedef	UInt24	QProcStatusReply_procStat_reportTime_t;

#define QProcStatusReply_procStat_errSelect	0x200009	/* 2097161 */
typedef	UInt8	QProcStatusReply_procStat_errSelect_t;

#define QProcStatusReply_procStat_usrSeverity	0x30000a	/* 3145738 */
typedef	UInt24	QProcStatusReply_procStat_usrSeverity_t;

#define QProcStatusReply_procStat_sysSeverity	0x30000d	/* 3145741 */
typedef	UInt24	QProcStatusReply_procStat_sysSeverity_t;

#define QProcStatusReply_procStat_errorTag	0x300010	/* 3145744 */
typedef	UInt24	QProcStatusReply_procStat_errorTag_t;

#define QProcStatusReply_procStat_causeTag	0x300013	/* 3145747 */
typedef	UInt24	QProcStatusReply_procStat_causeTag_t;

#define QProcStatusReply_procStat_compFlag	0x200016	/* 2097174 */
typedef	UInt8	QProcStatusReply_procStat_compFlag_t;

#define QProcStatusReply_procStat_compDesc	0x800017	/* 8388631 */
typedef	QCompDesc	QProcStatusReply_procStat_compDesc_t;

#define QProcStatusReply_procStat_parmCount	0x20001d	/* 2097181 */
typedef	UInt8	QProcStatusReply_procStat_parmCount_t;

#define QProcStatusReply_procStat_parm	0x18381e	/* 1587230 */
typedef	Int32	QProcStatusReply_procStat_parm_t[8];


typedef struct {
	UInt24	procNum;
	UInt24	status;
	UInt24	reportTime;
	UInt8	errSelect;
	UInt24	usrSeverity;
	UInt24	sysSeverity;
	UInt24	errorTag;
	UInt24	causeTag;
	UInt8	compFlag;
	QCompDesc	compDesc;
	UInt8	parmCount;
	Int32	parm[8];
} QProcStatusReply_procStat_t;

#define QProcStatusReply_procStat_get(msgPtr, structAddr, offset)	\
		    qMsgVarFieldGet((msgPtr), 12, &(offset),	\
			(QProcStatusReply_procStat_procNum), &((structAddr)->procNum),	\
			(QProcStatusReply_procStat_status), &((structAddr)->status),	\
			(QProcStatusReply_procStat_reportTime), &((structAddr)->reportTime),	\
			(QProcStatusReply_procStat_errSelect), &((structAddr)->errSelect),	\
			(QProcStatusReply_procStat_usrSeverity), &((structAddr)->usrSeverity),	\
			(QProcStatusReply_procStat_sysSeverity), &((structAddr)->sysSeverity),	\
			(QProcStatusReply_procStat_errorTag), &((structAddr)->errorTag),	\
			(QProcStatusReply_procStat_causeTag), &((structAddr)->causeTag),	\
			(QProcStatusReply_procStat_compFlag), &((structAddr)->compFlag),	\
			(QProcStatusReply_procStat_compDesc), &((structAddr)->compDesc),	\
			(QProcStatusReply_procStat_parmCount), &((structAddr)->parmCount),	\
			(QProcStatusReply_procStat_parm), &((structAddr)->parm))


#define QProcStatusReply_procStat_put(msgPtr, structAddr, offset)	\
		    qMsgVarFieldPut((msgPtr), 12, &(offset),	\
			(QProcStatusReply_procStat_procNum), &((structAddr)->procNum),	\
			(QProcStatusReply_procStat_status), &((structAddr)->status),	\
			(QProcStatusReply_procStat_reportTime), &((structAddr)->reportTime),	\
			(QProcStatusReply_procStat_errSelect), &((structAddr)->errSelect),	\
			(QProcStatusReply_procStat_usrSeverity), &((structAddr)->usrSeverity),	\
			(QProcStatusReply_procStat_sysSeverity), &((structAddr)->sysSeverity),	\
			(QProcStatusReply_procStat_errorTag), &((structAddr)->errorTag),	\
			(QProcStatusReply_procStat_causeTag), &((structAddr)->causeTag),	\
			(QProcStatusReply_procStat_compFlag), &((structAddr)->compFlag),	\
			(QProcStatusReply_procStat_compDesc), &((structAddr)->compDesc),	\
			(QProcStatusReply_procStat_parmCount), &((structAddr)->parmCount),	\
			(QProcStatusReply_procStat_parm), &((structAddr)->parm))


#define QProcStatusReply_procStat_Size		62

#define QProcStatusReply_procStat	0x2	/* 2 */

#define QProcStatusReply_varStart	0x3e

#define QProcStatusReply_errorFile_errF	0x50f800	/* 5306368 */
typedef	Char	QProcStatusReply_errorFile_errF_t[32];


typedef struct {
	Char	errF[32];
} QProcStatusReply_errorFile_t;

#define QProcStatusReply_errorFile_get(msgPtr, structAddr, offset)	\
		    qMsgVarFieldGet((msgPtr), 1, &(offset),	\
			(QProcStatusReply_errorFile_errF), &((structAddr)->errF))


#define QProcStatusReply_errorFile_put(msgPtr, structAddr, offset)	\
		    qMsgVarFieldPut((msgPtr), 1, &(offset),	\
			(QProcStatusReply_errorFile_errF), &((structAddr)->errF))


#define QProcStatusReply_errorFile_Size		32

#define QProcStatusReply_errorFile	0x3	/* 3 */

#define QProcStatusReply_causeFile_causeF	0x50f800	/* 5306368 */
typedef	Char	QProcStatusReply_causeFile_causeF_t[32];


typedef struct {
	Char	causeF[32];
} QProcStatusReply_causeFile_t;

#define QProcStatusReply_causeFile_get(msgPtr, structAddr, offset)	\
		    qMsgVarFieldGet((msgPtr), 1, &(offset),	\
			(QProcStatusReply_causeFile_causeF), &((structAddr)->causeF))


#define QProcStatusReply_causeFile_put(msgPtr, structAddr, offset)	\
		    qMsgVarFieldPut((msgPtr), 1, &(offset),	\
			(QProcStatusReply_causeFile_causeF), &((structAddr)->causeF))


#define QProcStatusReply_causeFile_Size		32

#define QProcStatusReply_causeFile	0x4	/* 4 */

/*
 * QProcStatusReply (value = 0x80006a) is a message of generic use.
 */


typedef struct {
	QProcStatusReply_procStat_t	QProcStatusReply_procStat_i;
} QProcStatusReply_t;

#define QProcStatusReply_get(msgPtr, structAddr, offset)	\
		    QProcStatusReply_procStat_get(msgPtr, &((structAddr)->QProcStatusReply_procStat_i), offset)


#define QProcStatusReply_put(msgPtr, structAddr, offset)	\
		    QProcStatusReply_procStat_put(msgPtr, &((structAddr)->QProcStatusReply_procStat_i), offset)


#define QProcStatusReply_Size		62

#define QProcStatusReply	0x80006a	/* 8388714 */
/* Message to request Processor(s) Status. */
/* Reply message contains processor(s)'s status.*/

/*
 * QBoardStatusRequest (value = 0x800071) is a message of generic use.
 */

#define QBoardStatusRequest_Size		0

#define QBoardStatusRequest	0x800071	/* 8388721 */

#define QBoardStatusReply_procNum	0x300000	/* 3145728 */
typedef	UInt24	QBoardStatusReply_procNum_t;

#define QBoardStatusReply_usrSeverity	0x300003	/* 3145731 */
typedef	UInt24	QBoardStatusReply_usrSeverity_t;

/*
 * QBoardStatusReply (value = 0x800072) is a message of generic use.
 */


typedef struct {
	UInt24	procNum;
	UInt24	usrSeverity;
} QBoardStatusReply_t;

#define QBoardStatusReply_get(msgPtr, structAddr, offset)	\
		    qMsgVarFieldGet((msgPtr), 2, &(offset),	\
			(QBoardStatusReply_procNum), &((structAddr)->procNum),	\
			(QBoardStatusReply_usrSeverity), &((structAddr)->usrSeverity))


#define QBoardStatusReply_put(msgPtr, structAddr, offset)	\
		    qMsgVarFieldPut((msgPtr), 2, &(offset),	\
			(QBoardStatusReply_procNum), &((structAddr)->procNum),	\
			(QBoardStatusReply_usrSeverity), &((structAddr)->usrSeverity))


#define QBoardStatusReply_Size		6

#define QBoardStatusReply	0x800072	/* 8388722 */
/* Message to request Board Status. */

#define QBoardAlarmRequest_alarm	0x200000	/* 2097152 */
typedef	UInt8	QBoardAlarmRequest_alarm_t;
/*flag to select overall or latest proc status*/

#define QBoardAlarmRequest_errSelect	0x200001	/* 2097153 */
typedef	UInt8	QBoardAlarmRequest_errSelect_t;

/*
 * QBoardAlarmRequest (value = 0x800074) is a message of generic use.
 */


typedef struct {
	UInt8	alarm;
	UInt8	errSelect;
} QBoardAlarmRequest_t;

#define QBoardAlarmRequest_get(msgPtr, structAddr, offset)	\
		    qMsgVarFieldGet((msgPtr), 2, &(offset),	\
			(QBoardAlarmRequest_alarm), &((structAddr)->alarm),	\
			(QBoardAlarmRequest_errSelect), &((structAddr)->errSelect))


#define QBoardAlarmRequest_put(msgPtr, structAddr, offset)	\
		    qMsgVarFieldPut((msgPtr), 2, &(offset),	\
			(QBoardAlarmRequest_alarm), &((structAddr)->alarm),	\
			(QBoardAlarmRequest_errSelect), &((structAddr)->errSelect))


#define QBoardAlarmRequest_Size		2

#define QBoardAlarmRequest	0x800074	/* 8388724 */
/* Message to request Board Status. */
/* Create a component cluster  with a specifified connect mode attribute*/

#define QCLUST_ConnectDisable	0x01	/* Disables the automatic connections     */
#define QCLUST_ConnectEnable	0x02	/* Enables the automatic connections*/


/*
 * QBoardAlarmAck (value = 0x800075) is a message of generic use.
 */

#define QBoardAlarmAck_Size		0

#define QBoardAlarmAck	0x800075	/* 8388725 */
/* the specification of the auto connect mode */

#define QClusterCreateMode_connectMode	0x200000	/* 2097152 */
typedef	UInt8	QClusterCreateMode_connectMode_t;

/*
 * QClusterCreateMode (value = 0x80006b) is an input message of generic use.
 */


typedef struct {
	UInt8	connectMode;
} QClusterCreateMode_t;

#define QClusterCreateMode_get(msgPtr, structAddr, offset)	\
		    qMsgVarFieldGet((msgPtr), 1, &(offset),	\
			(QClusterCreateMode_connectMode), &((structAddr)->connectMode))


#define QClusterCreateMode_put(msgPtr, structAddr, offset)	\
		    qMsgVarFieldPut((msgPtr), 1, &(offset),	\
			(QClusterCreateMode_connectMode), &((structAddr)->connectMode))


#define QClusterCreateMode_Size		1

#define QClusterCreateMode	0x80006b	/* 8388715 */
/* Add a port to the specified component instance within the cluster.*/
/* the instance that will own the port */

#define QClusterPortAdd_instDesc	0x800000	/* 8388608 */
typedef	QCompDesc	QClusterPortAdd_instDesc_t;
/* port to add */

#define QClusterPortAdd_portId	0x300006	/* 3145734 */
typedef	UInt24	QClusterPortAdd_portId_t;

/*
 * QClusterPortAdd (value = 0x80006c) is an input message of generic use.
 */


typedef struct {
	QCompDesc	instDesc;
	UInt24	portId;
} QClusterPortAdd_t;

#define QClusterPortAdd_get(msgPtr, structAddr, offset)	\
		    qMsgVarFieldGet((msgPtr), 2, &(offset),	\
			(QClusterPortAdd_instDesc), &((structAddr)->instDesc),	\
			(QClusterPortAdd_portId), &((structAddr)->portId))


#define QClusterPortAdd_put(msgPtr, structAddr, offset)	\
		    qMsgVarFieldPut((msgPtr), 2, &(offset),	\
			(QClusterPortAdd_instDesc), &((structAddr)->instDesc),	\
			(QClusterPortAdd_portId), &((structAddr)->portId))


#define QClusterPortAdd_Size		9

#define QClusterPortAdd	0x80006c	/* 8388716 */
/* Reports the complete id of the port which was added to a component instance.*/
/* the instance that owns the port */

#define QClusterPortAddResult_instDesc	0x800000	/* 8388608 */
typedef	QCompDesc	QClusterPortAddResult_instDesc_t;
/* port id */

#define QClusterPortAddResult_portId	0x300006	/* 3145734 */
typedef	UInt24	QClusterPortAddResult_portId_t;

/*
 * QClusterPortAddResult (value = 0x80006d) is an output message of generic use.
 */


typedef struct {
	QCompDesc	instDesc;
	UInt24	portId;
} QClusterPortAddResult_t;

#define QClusterPortAddResult_get(msgPtr, structAddr, offset)	\
		    qMsgVarFieldGet((msgPtr), 2, &(offset),	\
			(QClusterPortAddResult_instDesc), &((structAddr)->instDesc),	\
			(QClusterPortAddResult_portId), &((structAddr)->portId))


#define QClusterPortAddResult_put(msgPtr, structAddr, offset)	\
		    qMsgVarFieldPut((msgPtr), 2, &(offset),	\
			(QClusterPortAddResult_instDesc), &((structAddr)->instDesc),	\
			(QClusterPortAddResult_portId), &((structAddr)->portId))


#define QClusterPortAddResult_Size		9

#define QClusterPortAddResult	0x80006d	/* 8388717 */
/* Remove a port from the specified component instance within the cluster.*/
/* the instance that owns the port */

#define QClusterPortRemove_instDesc	0x800000	/* 8388608 */
typedef	QCompDesc	QClusterPortRemove_instDesc_t;
/* port to remove */

#define QClusterPortRemove_portId	0x300006	/* 3145734 */
typedef	UInt24	QClusterPortRemove_portId_t;

/*
 * QClusterPortRemove (value = 0x80006e) is an input message of generic use.
 */


typedef struct {
	QCompDesc	instDesc;
	UInt24	portId;
} QClusterPortRemove_t;

#define QClusterPortRemove_get(msgPtr, structAddr, offset)	\
		    qMsgVarFieldGet((msgPtr), 2, &(offset),	\
			(QClusterPortRemove_instDesc), &((structAddr)->instDesc),	\
			(QClusterPortRemove_portId), &((structAddr)->portId))


#define QClusterPortRemove_put(msgPtr, structAddr, offset)	\
		    qMsgVarFieldPut((msgPtr), 2, &(offset),	\
			(QClusterPortRemove_instDesc), &((structAddr)->instDesc),	\
			(QClusterPortRemove_portId), &((structAddr)->portId))


#define QClusterPortRemove_Size		9

#define QClusterPortRemove	0x80006e	/* 8388718 */
/* Find the ports associated with the specified component instance within the 
 * cluster. */
/* the component instance */

#define QClusterPortQuery_instDesc	0x800000	/* 8388608 */
typedef	QCompDesc	QClusterPortQuery_instDesc_t;
/* full or partial port specification */

#define QClusterPortQuery_portId	0x300006	/* 3145734 */
typedef	UInt24	QClusterPortQuery_portId_t;

/*
 * QClusterPortQuery (value = 0x80006f) is an input message of generic use.
 */


typedef struct {
	QCompDesc	instDesc;
	UInt24	portId;
} QClusterPortQuery_t;

#define QClusterPortQuery_get(msgPtr, structAddr, offset)	\
		    qMsgVarFieldGet((msgPtr), 2, &(offset),	\
			(QClusterPortQuery_instDesc), &((structAddr)->instDesc),	\
			(QClusterPortQuery_portId), &((structAddr)->portId))


#define QClusterPortQuery_put(msgPtr, structAddr, offset)	\
		    qMsgVarFieldPut((msgPtr), 2, &(offset),	\
			(QClusterPortQuery_instDesc), &((structAddr)->instDesc),	\
			(QClusterPortQuery_portId), &((structAddr)->portId))


#define QClusterPortQuery_Size		9

#define QClusterPortQuery	0x80006f	/* 8388719 */
/* Reports the ports owned by the component instance.*/
/* the instance that owns the ports */

#define QClusterPortQueryResult_instDesc	0x800000	/* 8388608 */
typedef	QCompDesc	QClusterPortQueryResult_instDesc_t;
/* the number of ports in the body  */

#define QClusterPortQueryResult_portCount	0x200006	/* 2097158 */
typedef	UInt8	QClusterPortQueryResult_portCount_t;

#define QClusterPortQueryResult_varStart	0x7
/* list of port identifiers */

#define QClusterPortQueryResult_portId	0x300000	/* 3145728 */
typedef	UInt24	QClusterPortQueryResult_portId_t;

/*
 * QClusterPortQueryResult (value = 0x800070) is an output message of generic use.
 */


typedef struct {
	QCompDesc	instDesc;
	UInt8	portCount;
} QClusterPortQueryResult_t;

#define QClusterPortQueryResult_get(msgPtr, structAddr, offset)	\
		    qMsgVarFieldGet((msgPtr), 2, &(offset),	\
			(QClusterPortQueryResult_instDesc), &((structAddr)->instDesc),	\
			(QClusterPortQueryResult_portCount), &((structAddr)->portCount))


#define QClusterPortQueryResult_put(msgPtr, structAddr, offset)	\
		    qMsgVarFieldPut((msgPtr), 2, &(offset),	\
			(QClusterPortQueryResult_instDesc), &((structAddr)->instDesc),	\
			(QClusterPortQueryResult_portCount), &((structAddr)->portCount))


#define QClusterPortQueryResult_Size		7

#define QClusterPortQueryResult	0x800070	/* 8388720 */
/* A NID channel state change occurred.*/

#define QNIDChanStateEvt_deviceId	0x200000	/* 2097152 */
typedef	UInt8	QNIDChanStateEvt_deviceId_t;

#define QNIDChanStateEvt_timeslot	0x200001	/* 2097153 */
typedef	UInt8	QNIDChanStateEvt_timeslot_t;

#define QNIDChanStateEvt_state	0x200002	/* 2097154 */
typedef	UInt8	QNIDChanStateEvt_state_t;

/*
 * QNIDChanStateEvt (value = 0x800073) is a message of generic use.
 */


typedef struct {
	UInt8	deviceId;
	UInt8	timeslot;
	UInt8	state;
} QNIDChanStateEvt_t;

#define QNIDChanStateEvt_get(msgPtr, structAddr, offset)	\
		    qMsgVarFieldGet((msgPtr), 3, &(offset),	\
			(QNIDChanStateEvt_deviceId), &((structAddr)->deviceId),	\
			(QNIDChanStateEvt_timeslot), &((structAddr)->timeslot),	\
			(QNIDChanStateEvt_state), &((structAddr)->state))


#define QNIDChanStateEvt_put(msgPtr, structAddr, offset)	\
		    qMsgVarFieldPut((msgPtr), 3, &(offset),	\
			(QNIDChanStateEvt_deviceId), &((structAddr)->deviceId),	\
			(QNIDChanStateEvt_timeslot), &((structAddr)->timeslot),	\
			(QNIDChanStateEvt_state), &((structAddr)->state))


#define QNIDChanStateEvt_Size		3

#define QNIDChanStateEvt	0x800073	/* 8388723 */
#define QNID_CHAN_STATE_ACTIVE 1
#define QNID_CHAN_STATE_INACTIVE 0
/* Return the attribute information  associated with a cluster.*/
/* Cluster Attribute Information Response */

/*
 * QClusterAttrInfo (value = 0x800076) is a message of generic use.
 */

#define QClusterAttrInfo_Size		0

#define QClusterAttrInfo	0x800076	/* 8388726 */

#define QClusterAttrInfoResult_theCluster	0x800000	/* 8388608 */
typedef	QCompDesc	QClusterAttrInfoResult_theCluster_t;

#define QClusterAttrInfoResult_state	0x280006	/* 2621446 */
typedef	UInt16	QClusterAttrInfoResult_state_t;

#define QClusterAttrInfoResult_count	0x280008	/* 2621448 */
typedef	UInt16	QClusterAttrInfoResult_count_t;

#define QClusterAttrInfoResult_varStart	0xa

#define QClusterAttrInfoResult_attr	0x780000	/* 7864320 */
typedef	QCompAttr	QClusterAttrInfoResult_attr_t;

/*
 * QClusterAttrInfoResult (value = 0x800077) is a message of generic use.
 */


typedef struct {
	QCompDesc	theCluster;
	UInt16	state;
	UInt16	count;
} QClusterAttrInfoResult_t;

#define QClusterAttrInfoResult_get(msgPtr, structAddr, offset)	\
		    qMsgVarFieldGet((msgPtr), 3, &(offset),	\
			(QClusterAttrInfoResult_theCluster), &((structAddr)->theCluster),	\
			(QClusterAttrInfoResult_state), &((structAddr)->state),	\
			(QClusterAttrInfoResult_count), &((structAddr)->count))


#define QClusterAttrInfoResult_put(msgPtr, structAddr, offset)	\
		    qMsgVarFieldPut((msgPtr), 3, &(offset),	\
			(QClusterAttrInfoResult_theCluster), &((structAddr)->theCluster),	\
			(QClusterAttrInfoResult_state), &((structAddr)->state),	\
			(QClusterAttrInfoResult_count), &((structAddr)->count))


#define QClusterAttrInfoResult_Size		10

#define QClusterAttrInfoResult	0x800077	/* 8388727 */
/* Message requests that a QTBCRspCap  message be sent. */

#define QTBCCmdQueryCap_BusNumber	0x380000	/* 3670016 */
typedef	UInt32	QTBCCmdQueryCap_BusNumber_t;

/*
 * QTBCCmdQueryCap (value = 0x800126) is a message of generic use.
 */


typedef struct {
	UInt32	BusNumber;
} QTBCCmdQueryCap_t;

#define QTBCCmdQueryCap_get(msgPtr, structAddr, offset)	\
		    qMsgVarFieldGet((msgPtr), 1, &(offset),	\
			(QTBCCmdQueryCap_BusNumber), &((structAddr)->BusNumber))


#define QTBCCmdQueryCap_put(msgPtr, structAddr, offset)	\
		    qMsgVarFieldPut((msgPtr), 1, &(offset),	\
			(QTBCCmdQueryCap_BusNumber), &((structAddr)->BusNumber))


#define QTBCCmdQueryCap_Size		4

#define QTBCCmdQueryCap	0x800126	/* 8388902 */
/* Message sent in response to a QTBCCmdQueryCap  message. */

#define QTBCRspCap_BusNumber	0x380000	/* 3670016 */
typedef	UInt32	QTBCRspCap_BusNumber_t;

#define QTBCRspCap_TDMBusProtocolVersion	0x380004	/* 3670020 */
typedef	UInt32	QTBCRspCap_TDMBusProtocolVersion_t;

#define QTBCRspCap_TDMBusCaps	0x380008	/* 3670024 */
typedef	UInt32	QTBCRspCap_TDMBusCaps_t;

#define QTBCRspCap_RefClkDeriveCaps	0x38000c	/* 3670028 */
typedef	UInt32	QTBCRspCap_RefClkDeriveCaps_t;

#define QTBCRspCap_RefClkProvideExtCaps	0x380010	/* 3670032 */
typedef	UInt32	QTBCRspCap_RefClkProvideExtCaps_t;

#define QTBCRspCap_RefClkProvideIntCaps	0x380014	/* 3670036 */
typedef	UInt32	QTBCRspCap_RefClkProvideIntCaps_t;

#define QTBCRspCap_LawCaps	0x380018	/* 3670040 */
typedef	UInt32	QTBCRspCap_LawCaps_t;

#define QTBCRspCap_NumNetInterfaces	0x38001c	/* 3670044 */
typedef	UInt32	QTBCRspCap_NumNetInterfaces_t;

#define QTBCRspCap_MsgVersionId	0x380020	/* 3670048 */
typedef	UInt32	QTBCRspCap_MsgVersionId_t;

#define QTBCRspCap_reserved2	0x380024	/* 3670052 */
typedef	UInt32	QTBCRspCap_reserved2_t;

#define QTBCRspCap_reserved3	0x380028	/* 3670056 */
typedef	UInt32	QTBCRspCap_reserved3_t;

#define QTBCRspCap_reserved4	0x38002c	/* 3670060 */
typedef	UInt32	QTBCRspCap_reserved4_t;

#define QTBCRspCap_reserved5	0x380030	/* 3670064 */
typedef	UInt32	QTBCRspCap_reserved5_t;

#define QTBCRspCap_reserved6	0x380034	/* 3670068 */
typedef	UInt32	QTBCRspCap_reserved6_t;

/*
 * QTBCRspCap (value = 0x800127) is a message of generic use.
 */


typedef struct {
	UInt32	BusNumber;
	UInt32	TDMBusProtocolVersion;
	UInt32	TDMBusCaps;
	UInt32	RefClkDeriveCaps;
	UInt32	RefClkProvideExtCaps;
	UInt32	RefClkProvideIntCaps;
	UInt32	LawCaps;
	UInt32	NumNetInterfaces;
	UInt32	MsgVersionId;
	UInt32	reserved2;
	UInt32	reserved3;
	UInt32	reserved4;
	UInt32	reserved5;
	UInt32	reserved6;
} QTBCRspCap_t;

#define QTBCRspCap_get(msgPtr, structAddr, offset)	\
		    qMsgVarFieldGet((msgPtr), 14, &(offset),	\
			(QTBCRspCap_BusNumber), &((structAddr)->BusNumber),	\
			(QTBCRspCap_TDMBusProtocolVersion), &((structAddr)->TDMBusProtocolVersion),	\
			(QTBCRspCap_TDMBusCaps), &((structAddr)->TDMBusCaps),	\
			(QTBCRspCap_RefClkDeriveCaps), &((structAddr)->RefClkDeriveCaps),	\
			(QTBCRspCap_RefClkProvideExtCaps), &((structAddr)->RefClkProvideExtCaps),	\
			(QTBCRspCap_RefClkProvideIntCaps), &((structAddr)->RefClkProvideIntCaps),	\
			(QTBCRspCap_LawCaps), &((structAddr)->LawCaps),	\
			(QTBCRspCap_NumNetInterfaces), &((structAddr)->NumNetInterfaces),	\
			(QTBCRspCap_MsgVersionId), &((structAddr)->MsgVersionId),	\
			(QTBCRspCap_reserved2), &((structAddr)->reserved2),	\
			(QTBCRspCap_reserved3), &((structAddr)->reserved3),	\
			(QTBCRspCap_reserved4), &((structAddr)->reserved4),	\
			(QTBCRspCap_reserved5), &((structAddr)->reserved5),	\
			(QTBCRspCap_reserved6), &((structAddr)->reserved6))


#define QTBCRspCap_put(msgPtr, structAddr, offset)	\
		    qMsgVarFieldPut((msgPtr), 14, &(offset),	\
			(QTBCRspCap_BusNumber), &((structAddr)->BusNumber),	\
			(QTBCRspCap_TDMBusProtocolVersion), &((structAddr)->TDMBusProtocolVersion),	\
			(QTBCRspCap_TDMBusCaps), &((structAddr)->TDMBusCaps),	\
			(QTBCRspCap_RefClkDeriveCaps), &((structAddr)->RefClkDeriveCaps),	\
			(QTBCRspCap_RefClkProvideExtCaps), &((structAddr)->RefClkProvideExtCaps),	\
			(QTBCRspCap_RefClkProvideIntCaps), &((structAddr)->RefClkProvideIntCaps),	\
			(QTBCRspCap_LawCaps), &((structAddr)->LawCaps),	\
			(QTBCRspCap_NumNetInterfaces), &((structAddr)->NumNetInterfaces),	\
			(QTBCRspCap_MsgVersionId), &((structAddr)->MsgVersionId),	\
			(QTBCRspCap_reserved2), &((structAddr)->reserved2),	\
			(QTBCRspCap_reserved3), &((structAddr)->reserved3),	\
			(QTBCRspCap_reserved4), &((structAddr)->reserved4),	\
			(QTBCRspCap_reserved5), &((structAddr)->reserved5),	\
			(QTBCRspCap_reserved6), &((structAddr)->reserved6))


#define QTBCRspCap_Size		56

#define QTBCRspCap	0x800127	/* 8388903 */
#define TBC_PROTOCOL_VERSION_1 	1
#define TBC_BUS_CAP_SC    1
#define TBC_BUS_CAP_H100  2
#define TBC_BUS_CAP_H110  4
#define TBC_REF_CLKSPEED_NONE      0
#define TBC_REF_CLKSPEED_8KHz      1
#define TBC_REF_CLKSPEED_1_536MHz  2
#define TBC_REF_CLKSPEED_1_544MHz  4
#define TBC_REF_CLKSPEED_2_048MHz  8
#define TBC_LAW_CAP_MU 1
#define TBC_LAW_CAP_A  2
/* Message to query a boards status. */

#define QTBCCmdQueryStatus_BusNumber	0x380000	/* 3670016 */
typedef	UInt32	QTBCCmdQueryStatus_BusNumber_t;

/*
 * QTBCCmdQueryStatus (value = 0x80012d) is a message of generic use.
 */


typedef struct {
	UInt32	BusNumber;
} QTBCCmdQueryStatus_t;

#define QTBCCmdQueryStatus_get(msgPtr, structAddr, offset)	\
		    qMsgVarFieldGet((msgPtr), 1, &(offset),	\
			(QTBCCmdQueryStatus_BusNumber), &((structAddr)->BusNumber))


#define QTBCCmdQueryStatus_put(msgPtr, structAddr, offset)	\
		    qMsgVarFieldPut((msgPtr), 1, &(offset),	\
			(QTBCCmdQueryStatus_BusNumber), &((structAddr)->BusNumber))


#define QTBCCmdQueryStatus_Size		4

#define QTBCCmdQueryStatus	0x80012d	/* 8388909 */
/* Message reports on current status of a board, sent in response to 
 * QTBCCmdQueryStatus. */

#define QTBCRspStatus_BusNumber	0x380000	/* 3670016 */
typedef	UInt32	QTBCRspStatus_BusNumber_t;

#define QTBCRspStatus_MasterState	0x380004	/* 3670020 */
typedef	UInt32	QTBCRspStatus_MasterState_t;

#define QTBCRspStatus_MasterBusSelect	0x380008	/* 3670024 */
typedef	UInt32	QTBCRspStatus_MasterBusSelect_t;

#define QTBCRspStatus_InputRefBusPin	0x38000c	/* 3670028 */
typedef	UInt32	QTBCRspStatus_InputRefBusPin_t;

#define QTBCRspStatus_InputRefClkSpeed	0x380010	/* 3670032 */
typedef	UInt32	QTBCRspStatus_InputRefClkSpeed_t;

#define QTBCRspStatus_BusType	0x380014	/* 3670036 */
typedef	UInt32	QTBCRspStatus_BusType_t;

#define QTBCRspStatus_DiagMode	0x380018	/* 3670040 */
typedef	UInt32	QTBCRspStatus_DiagMode_t;

#define QTBCRspStatus_SCBusSpeed	0x38001c	/* 3670044 */
typedef	UInt32	QTBCRspStatus_SCBusSpeed_t;

#define QTBCRspStatus_Group1Speed	0x380020	/* 3670048 */
typedef	UInt32	QTBCRspStatus_Group1Speed_t;

#define QTBCRspStatus_Group2Speed	0x380024	/* 3670052 */
typedef	UInt32	QTBCRspStatus_Group2Speed_t;

#define QTBCRspStatus_Group3Speed	0x380028	/* 3670056 */
typedef	UInt32	QTBCRspStatus_Group3Speed_t;

#define QTBCRspStatus_Group4Speed	0x38002c	/* 3670060 */
typedef	UInt32	QTBCRspStatus_Group4Speed_t;

#define QTBCRspStatus_OutputClkrefSource	0x380030	/* 3670064 */
typedef	UInt32	QTBCRspStatus_OutputClkrefSource_t;

#define QTBCRspStatus_OutputClkrefSpeed	0x380034	/* 3670068 */
typedef	UInt32	QTBCRspStatus_OutputClkrefSpeed_t;

#define QTBCRspStatus_AlarmEventsEnabled	0x380038	/* 3670072 */
typedef	UInt32	QTBCRspStatus_AlarmEventsEnabled_t;

#define QTBCRspStatus_AlarmEventsStatus	0x38003c	/* 3670076 */
typedef	UInt32	QTBCRspStatus_AlarmEventsStatus_t;

/*
 * QTBCRspStatus (value = 0x80012e) is a message of generic use.
 */


typedef struct {
	UInt32	BusNumber;
	UInt32	MasterState;
	UInt32	MasterBusSelect;
	UInt32	InputRefBusPin;
	UInt32	InputRefClkSpeed;
	UInt32	BusType;
	UInt32	DiagMode;
	UInt32	SCBusSpeed;
	UInt32	Group1Speed;
	UInt32	Group2Speed;
	UInt32	Group3Speed;
	UInt32	Group4Speed;
	UInt32	OutputClkrefSource;
	UInt32	OutputClkrefSpeed;
	UInt32	AlarmEventsEnabled;
	UInt32	AlarmEventsStatus;
} QTBCRspStatus_t;

#define QTBCRspStatus_get(msgPtr, structAddr, offset)	\
		    qMsgVarFieldGet((msgPtr), 16, &(offset),	\
			(QTBCRspStatus_BusNumber), &((structAddr)->BusNumber),	\
			(QTBCRspStatus_MasterState), &((structAddr)->MasterState),	\
			(QTBCRspStatus_MasterBusSelect), &((structAddr)->MasterBusSelect),	\
			(QTBCRspStatus_InputRefBusPin), &((structAddr)->InputRefBusPin),	\
			(QTBCRspStatus_InputRefClkSpeed), &((structAddr)->InputRefClkSpeed),	\
			(QTBCRspStatus_BusType), &((structAddr)->BusType),	\
			(QTBCRspStatus_DiagMode), &((structAddr)->DiagMode),	\
			(QTBCRspStatus_SCBusSpeed), &((structAddr)->SCBusSpeed),	\
			(QTBCRspStatus_Group1Speed), &((structAddr)->Group1Speed),	\
			(QTBCRspStatus_Group2Speed), &((structAddr)->Group2Speed),	\
			(QTBCRspStatus_Group3Speed), &((structAddr)->Group3Speed),	\
			(QTBCRspStatus_Group4Speed), &((structAddr)->Group4Speed),	\
			(QTBCRspStatus_OutputClkrefSource), &((structAddr)->OutputClkrefSource),	\
			(QTBCRspStatus_OutputClkrefSpeed), &((structAddr)->OutputClkrefSpeed),	\
			(QTBCRspStatus_AlarmEventsEnabled), &((structAddr)->AlarmEventsEnabled),	\
			(QTBCRspStatus_AlarmEventsStatus), &((structAddr)->AlarmEventsStatus))


#define QTBCRspStatus_put(msgPtr, structAddr, offset)	\
		    qMsgVarFieldPut((msgPtr), 16, &(offset),	\
			(QTBCRspStatus_BusNumber), &((structAddr)->BusNumber),	\
			(QTBCRspStatus_MasterState), &((structAddr)->MasterState),	\
			(QTBCRspStatus_MasterBusSelect), &((structAddr)->MasterBusSelect),	\
			(QTBCRspStatus_InputRefBusPin), &((structAddr)->InputRefBusPin),	\
			(QTBCRspStatus_InputRefClkSpeed), &((structAddr)->InputRefClkSpeed),	\
			(QTBCRspStatus_BusType), &((structAddr)->BusType),	\
			(QTBCRspStatus_DiagMode), &((structAddr)->DiagMode),	\
			(QTBCRspStatus_SCBusSpeed), &((structAddr)->SCBusSpeed),	\
			(QTBCRspStatus_Group1Speed), &((structAddr)->Group1Speed),	\
			(QTBCRspStatus_Group2Speed), &((structAddr)->Group2Speed),	\
			(QTBCRspStatus_Group3Speed), &((structAddr)->Group3Speed),	\
			(QTBCRspStatus_Group4Speed), &((structAddr)->Group4Speed),	\
			(QTBCRspStatus_OutputClkrefSource), &((structAddr)->OutputClkrefSource),	\
			(QTBCRspStatus_OutputClkrefSpeed), &((structAddr)->OutputClkrefSpeed),	\
			(QTBCRspStatus_AlarmEventsEnabled), &((structAddr)->AlarmEventsEnabled),	\
			(QTBCRspStatus_AlarmEventsStatus), &((structAddr)->AlarmEventsStatus))


#define QTBCRspStatus_Size		64

#define QTBCRspStatus	0x80012e	/* 8388910 */
#ifndef TBC_BUS_TYPE_H100
#define TBC_BUS_TYPE_H100  1
#endif
#ifndef TBC_BUS_TYPE_H110
#define TBC_BUS_TYPE_H110  2
#endif
#ifndef TBC_BUS_TYPE_SC
#define TBC_BUS_TYPE_SC    3
#endif

#define QGStrmRemoteOpen_pInfo	0x380000	/* 3670016 */
typedef	UInt32	QGStrmRemoteOpen_pInfo_t;

/*
 * QGStrmRemoteOpen (value = 0x800064) is a message of generic use.
 */


typedef struct {
	UInt32	pInfo;
} QGStrmRemoteOpen_t;

#define QGStrmRemoteOpen_get(msgPtr, structAddr, offset)	\
		    qMsgVarFieldGet((msgPtr), 1, &(offset),	\
			(QGStrmRemoteOpen_pInfo), &((structAddr)->pInfo))


#define QGStrmRemoteOpen_put(msgPtr, structAddr, offset)	\
		    qMsgVarFieldPut((msgPtr), 1, &(offset),	\
			(QGStrmRemoteOpen_pInfo), &((structAddr)->pInfo))


#define QGStrmRemoteOpen_Size		4

#define QGStrmRemoteOpen	0x800064	/* 8388708 */

#define QGStrmRemoteClose_pInfo	0x380000	/* 3670016 */
typedef	UInt32	QGStrmRemoteClose_pInfo_t;

/*
 * QGStrmRemoteClose (value = 0x800078) is a message of generic use.
 */


typedef struct {
	UInt32	pInfo;
} QGStrmRemoteClose_t;

#define QGStrmRemoteClose_get(msgPtr, structAddr, offset)	\
		    qMsgVarFieldGet((msgPtr), 1, &(offset),	\
			(QGStrmRemoteClose_pInfo), &((structAddr)->pInfo))


#define QGStrmRemoteClose_put(msgPtr, structAddr, offset)	\
		    qMsgVarFieldPut((msgPtr), 1, &(offset),	\
			(QGStrmRemoteClose_pInfo), &((structAddr)->pInfo))


#define QGStrmRemoteClose_Size		4

#define QGStrmRemoteClose	0x800078	/* 8388728 */

#define QGStrmRemoteOpenCmplt_id	0x380000	/* 3670016 */
typedef	UInt32	QGStrmRemoteOpenCmplt_id_t;

#define QGStrmRemoteOpenCmplt_readstreamstatus	0x380004	/* 3670020 */
typedef	UInt32	QGStrmRemoteOpenCmplt_readstreamstatus_t;

#define QGStrmRemoteOpenCmplt_writestreamstatus	0x380008	/* 3670024 */
typedef	UInt32	QGStrmRemoteOpenCmplt_writestreamstatus_t;

/*
 * QGStrmRemoteOpenCmplt (value = 0x800079) is a message of generic use.
 */


typedef struct {
	UInt32	id;
	UInt32	readstreamstatus;
	UInt32	writestreamstatus;
} QGStrmRemoteOpenCmplt_t;

#define QGStrmRemoteOpenCmplt_get(msgPtr, structAddr, offset)	\
		    qMsgVarFieldGet((msgPtr), 3, &(offset),	\
			(QGStrmRemoteOpenCmplt_id), &((structAddr)->id),	\
			(QGStrmRemoteOpenCmplt_readstreamstatus), &((structAddr)->readstreamstatus),	\
			(QGStrmRemoteOpenCmplt_writestreamstatus), &((structAddr)->writestreamstatus))


#define QGStrmRemoteOpenCmplt_put(msgPtr, structAddr, offset)	\
		    qMsgVarFieldPut((msgPtr), 3, &(offset),	\
			(QGStrmRemoteOpenCmplt_id), &((structAddr)->id),	\
			(QGStrmRemoteOpenCmplt_readstreamstatus), &((structAddr)->readstreamstatus),	\
			(QGStrmRemoteOpenCmplt_writestreamstatus), &((structAddr)->writestreamstatus))


#define QGStrmRemoteOpenCmplt_Size		12

#define QGStrmRemoteOpenCmplt	0x800079	/* 8388729 */

/*
 * QGStrmRemoteCloseCmplt (value = 0x80007a) is a message of generic use.
 */

#define QGStrmRemoteCloseCmplt_Size		0

#define QGStrmRemoteCloseCmplt	0x80007a	/* 8388730 */

/*
 * QGStrmTerminateStreamMsg (value = 0x800083) is a message of generic use.
 */

#define QGStrmTerminateStreamMsg_Size		0

#define QGStrmTerminateStreamMsg	0x800083	/* 8388739 */

#define QSmartMessage_destinst	0x280000	/* 2621440 */
typedef	UInt16	QSmartMessage_destinst_t;

#define QSmartMessage_destbrd	0x200002	/* 2097154 */
typedef	UInt8	QSmartMessage_destbrd_t;

#define QSmartMessage_pad1	0x200003	/* 2097155 */
typedef	UInt8	QSmartMessage_pad1_t;

#define QSmartMessage_destproc	0x200004	/* 2097156 */
typedef	UInt8	QSmartMessage_destproc_t;

#define QSmartMessage_destcomp	0x200005	/* 2097157 */
typedef	UInt8	QSmartMessage_destcomp_t;

#define QSmartMessage_destnode	0x200006	/* 2097158 */
typedef	UInt8	QSmartMessage_destnode_t;

#define QSmartMessage_pad2	0x200007	/* 2097159 */
typedef	UInt8	QSmartMessage_pad2_t;

#define QSmartMessage_index	0x380008	/* 3670024 */
typedef	UInt32	QSmartMessage_index_t;

#define QSmartMessage_lastmsgsig	0x20000c	/* 2097164 */
typedef	UInt8	QSmartMessage_lastmsgsig_t;

#define QSmartMessage_needreplycnt	0x20000d	/* 2097165 */
typedef	UInt8	QSmartMessage_needreplycnt_t;

#define QSmartMessage_needfreecnt	0x20000e	/* 2097166 */
typedef	UInt8	QSmartMessage_needfreecnt_t;

#define QSmartMessage_reserved1	0x20000f	/* 2097167 */
typedef	UInt8	QSmartMessage_reserved1_t;

#define QSmartMessage_varStart	0x10

#define QSmartMessage_msgheader_del	0x280000	/* 2621440 */
typedef	UInt16	QSmartMessage_msgheader_del_t;

#define QSmartMessage_msgheader_format	0x280000	/* 2621440 */
typedef	UInt16	QSmartMessage_msgheader_format_t;

#define QSmartMessage_msgheader_passmsgtype	0x380000	/* 3670016 */
typedef	UInt32	QSmartMessage_msgheader_passmsgtype_t;

#define QSmartMessage_msgheader_msgptr	0x380000	/* 3670016 */
typedef	UInt32	QSmartMessage_msgheader_msgptr_t;

#define QSmartMessage_msgheader_gonogo	0x200000	/* 2097152 */
typedef	UInt8	QSmartMessage_msgheader_gonogo_t;

#define QSmartMessage_msgheader_allocated	0x200000	/* 2097152 */
typedef	UInt8	QSmartMessage_msgheader_allocated_t;

#define QSmartMessage_msgheader_passreply	0x200000	/* 2097152 */
typedef	UInt8	QSmartMessage_msgheader_passreply_t;

#define QSmartMessage_msgheader_errorreply	0x200000	/* 2097152 */
typedef	UInt8	QSmartMessage_msgheader_errorreply_t;

#define QSmartMessage_msgheader_reserved	0x380000	/* 3670016 */
typedef	UInt32	QSmartMessage_msgheader_reserved_t;


typedef struct {
	UInt16	del;
	UInt16	format;
	UInt32	passmsgtype;
	UInt32	msgptr;
	UInt8	gonogo;
	UInt8	allocated;
	UInt8	passreply;
	UInt8	errorreply;
	UInt32	reserved;
} QSmartMessage_msgheader_t;

#define QSmartMessage_msgheader_get(msgPtr, structAddr, offset)	\
		    qMsgVarFieldGet((msgPtr), 9, &(offset),	\
			(QSmartMessage_msgheader_del), &((structAddr)->del),	\
			(QSmartMessage_msgheader_format), &((structAddr)->format),	\
			(QSmartMessage_msgheader_passmsgtype), &((structAddr)->passmsgtype),	\
			(QSmartMessage_msgheader_msgptr), &((structAddr)->msgptr),	\
			(QSmartMessage_msgheader_gonogo), &((structAddr)->gonogo),	\
			(QSmartMessage_msgheader_allocated), &((structAddr)->allocated),	\
			(QSmartMessage_msgheader_passreply), &((structAddr)->passreply),	\
			(QSmartMessage_msgheader_errorreply), &((structAddr)->errorreply),	\
			(QSmartMessage_msgheader_reserved), &((structAddr)->reserved))


#define QSmartMessage_msgheader_put(msgPtr, structAddr, offset)	\
		    qMsgVarFieldPut((msgPtr), 9, &(offset),	\
			(QSmartMessage_msgheader_del), &((structAddr)->del),	\
			(QSmartMessage_msgheader_format), &((structAddr)->format),	\
			(QSmartMessage_msgheader_passmsgtype), &((structAddr)->passmsgtype),	\
			(QSmartMessage_msgheader_msgptr), &((structAddr)->msgptr),	\
			(QSmartMessage_msgheader_gonogo), &((structAddr)->gonogo),	\
			(QSmartMessage_msgheader_allocated), &((structAddr)->allocated),	\
			(QSmartMessage_msgheader_passreply), &((structAddr)->passreply),	\
			(QSmartMessage_msgheader_errorreply), &((structAddr)->errorreply),	\
			(QSmartMessage_msgheader_reserved), &((structAddr)->reserved))


#define QSmartMessage_msgheader_Size		20

#define QSmartMessage_msgheader	0x5	/* 5 */

#define QSmartMessage_optmsgheader_del	0x280000	/* 2621440 */
typedef	UInt16	QSmartMessage_optmsgheader_del_t;

#define QSmartMessage_optmsgheader_format	0x280000	/* 2621440 */
typedef	UInt16	QSmartMessage_optmsgheader_format_t;

#define QSmartMessage_optmsgheader_offodata	0x380000	/* 3670016 */
typedef	UInt32	QSmartMessage_optmsgheader_offodata_t;

#define QSmartMessage_optmsgheader_offireply	0x380000	/* 3670016 */
typedef	UInt32	QSmartMessage_optmsgheader_offireply_t;

#define QSmartMessage_optmsgheader_sizeodata	0x380000	/* 3670016 */
typedef	UInt32	QSmartMessage_optmsgheader_sizeodata_t;

#define QSmartMessage_optmsgheader_passmsgtype	0x380000	/* 3670016 */
typedef	UInt32	QSmartMessage_optmsgheader_passmsgtype_t;

#define QSmartMessage_optmsgheader_msgptr	0x380000	/* 3670016 */
typedef	UInt32	QSmartMessage_optmsgheader_msgptr_t;

#define QSmartMessage_optmsgheader_gonogo	0x200000	/* 2097152 */
typedef	UInt8	QSmartMessage_optmsgheader_gonogo_t;

#define QSmartMessage_optmsgheader_allocated	0x200000	/* 2097152 */
typedef	UInt8	QSmartMessage_optmsgheader_allocated_t;

#define QSmartMessage_optmsgheader_passreply	0x200000	/* 2097152 */
typedef	UInt8	QSmartMessage_optmsgheader_passreply_t;

#define QSmartMessage_optmsgheader_errorreply	0x200000	/* 2097152 */
typedef	UInt8	QSmartMessage_optmsgheader_errorreply_t;

#define QSmartMessage_optmsgheader_reserved	0x380000	/* 3670016 */
typedef	UInt32	QSmartMessage_optmsgheader_reserved_t;


typedef struct {
	UInt16	del;
	UInt16	format;
	UInt32	offodata;
	UInt32	offireply;
	UInt32	sizeodata;
	UInt32	passmsgtype;
	UInt32	msgptr;
	UInt8	gonogo;
	UInt8	allocated;
	UInt8	passreply;
	UInt8	errorreply;
	UInt32	reserved;
} QSmartMessage_optmsgheader_t;

#define QSmartMessage_optmsgheader_get(msgPtr, structAddr, offset)	\
		    qMsgVarFieldGet((msgPtr), 12, &(offset),	\
			(QSmartMessage_optmsgheader_del), &((structAddr)->del),	\
			(QSmartMessage_optmsgheader_format), &((structAddr)->format),	\
			(QSmartMessage_optmsgheader_offodata), &((structAddr)->offodata),	\
			(QSmartMessage_optmsgheader_offireply), &((structAddr)->offireply),	\
			(QSmartMessage_optmsgheader_sizeodata), &((structAddr)->sizeodata),	\
			(QSmartMessage_optmsgheader_passmsgtype), &((structAddr)->passmsgtype),	\
			(QSmartMessage_optmsgheader_msgptr), &((structAddr)->msgptr),	\
			(QSmartMessage_optmsgheader_gonogo), &((structAddr)->gonogo),	\
			(QSmartMessage_optmsgheader_allocated), &((structAddr)->allocated),	\
			(QSmartMessage_optmsgheader_passreply), &((structAddr)->passreply),	\
			(QSmartMessage_optmsgheader_errorreply), &((structAddr)->errorreply),	\
			(QSmartMessage_optmsgheader_reserved), &((structAddr)->reserved))


#define QSmartMessage_optmsgheader_put(msgPtr, structAddr, offset)	\
		    qMsgVarFieldPut((msgPtr), 12, &(offset),	\
			(QSmartMessage_optmsgheader_del), &((structAddr)->del),	\
			(QSmartMessage_optmsgheader_format), &((structAddr)->format),	\
			(QSmartMessage_optmsgheader_offodata), &((structAddr)->offodata),	\
			(QSmartMessage_optmsgheader_offireply), &((structAddr)->offireply),	\
			(QSmartMessage_optmsgheader_sizeodata), &((structAddr)->sizeodata),	\
			(QSmartMessage_optmsgheader_passmsgtype), &((structAddr)->passmsgtype),	\
			(QSmartMessage_optmsgheader_msgptr), &((structAddr)->msgptr),	\
			(QSmartMessage_optmsgheader_gonogo), &((structAddr)->gonogo),	\
			(QSmartMessage_optmsgheader_allocated), &((structAddr)->allocated),	\
			(QSmartMessage_optmsgheader_passreply), &((structAddr)->passreply),	\
			(QSmartMessage_optmsgheader_errorreply), &((structAddr)->errorreply),	\
			(QSmartMessage_optmsgheader_reserved), &((structAddr)->reserved))


#define QSmartMessage_optmsgheader_Size		32

#define QSmartMessage_optmsgheader	0x6	/* 6 */

#define QSmartMessage_embedmsghdr_encoding	0x200000	/* 2097152 */
typedef	UInt8	QSmartMessage_embedmsghdr_encoding_t;

#define QSmartMessage_embedmsghdr_priority	0x200000	/* 2097152 */
typedef	UInt8	QSmartMessage_embedmsghdr_priority_t;

#define QSmartMessage_embedmsghdr_version	0x200000	/* 2097152 */
typedef	UInt8	QSmartMessage_embedmsghdr_version_t;

#define QSmartMessage_embedmsghdr_pad	0x200000	/* 2097152 */
typedef	UInt8	QSmartMessage_embedmsghdr_pad_t;

#define QSmartMessage_embedmsghdr_trans	0x380000	/* 3670016 */
typedef	UInt32	QSmartMessage_embedmsghdr_trans_t;

#define QSmartMessage_embedmsghdr_srcinst	0x280000	/* 2621440 */
typedef	UInt16	QSmartMessage_embedmsghdr_srcinst_t;

#define QSmartMessage_embedmsghdr_srcbrd	0x200000	/* 2097152 */
typedef	UInt8	QSmartMessage_embedmsghdr_srcbrd_t;

#define QSmartMessage_embedmsghdr_srcpad1	0x200000	/* 2097152 */
typedef	UInt8	QSmartMessage_embedmsghdr_srcpad1_t;

#define QSmartMessage_embedmsghdr_srcproc	0x200000	/* 2097152 */
typedef	UInt8	QSmartMessage_embedmsghdr_srcproc_t;

#define QSmartMessage_embedmsghdr_srccomp	0x200000	/* 2097152 */
typedef	UInt8	QSmartMessage_embedmsghdr_srccomp_t;

#define QSmartMessage_embedmsghdr_srcnode	0x200000	/* 2097152 */
typedef	UInt8	QSmartMessage_embedmsghdr_srcnode_t;

#define QSmartMessage_embedmsghdr_srcpad2	0x200000	/* 2097152 */
typedef	UInt8	QSmartMessage_embedmsghdr_srcpad2_t;

#define QSmartMessage_embedmsghdr_destinst	0x280000	/* 2621440 */
typedef	UInt16	QSmartMessage_embedmsghdr_destinst_t;

#define QSmartMessage_embedmsghdr_destbrd	0x200000	/* 2097152 */
typedef	UInt8	QSmartMessage_embedmsghdr_destbrd_t;

#define QSmartMessage_embedmsghdr_destpad1	0x200000	/* 2097152 */
typedef	UInt8	QSmartMessage_embedmsghdr_destpad1_t;

#define QSmartMessage_embedmsghdr_destproc	0x200000	/* 2097152 */
typedef	UInt8	QSmartMessage_embedmsghdr_destproc_t;

#define QSmartMessage_embedmsghdr_destcomp	0x200000	/* 2097152 */
typedef	UInt8	QSmartMessage_embedmsghdr_destcomp_t;

#define QSmartMessage_embedmsghdr_destnode	0x200000	/* 2097152 */
typedef	UInt8	QSmartMessage_embedmsghdr_destnode_t;

#define QSmartMessage_embedmsghdr_destpad2	0x200000	/* 2097152 */
typedef	UInt8	QSmartMessage_embedmsghdr_destpad2_t;

#define QSmartMessage_embedmsghdr_type	0x380000	/* 3670016 */
typedef	UInt32	QSmartMessage_embedmsghdr_type_t;

#define QSmartMessage_embedmsghdr_size	0x380000	/* 3670016 */
typedef	UInt32	QSmartMessage_embedmsghdr_size_t;


typedef struct {
	UInt8	encoding;
	UInt8	priority;
	UInt8	version;
	UInt8	pad;
	UInt32	trans;
	UInt16	srcinst;
	UInt8	srcbrd;
	UInt8	srcpad1;
	UInt8	srcproc;
	UInt8	srccomp;
	UInt8	srcnode;
	UInt8	srcpad2;
	UInt16	destinst;
	UInt8	destbrd;
	UInt8	destpad1;
	UInt8	destproc;
	UInt8	destcomp;
	UInt8	destnode;
	UInt8	destpad2;
	UInt32	type;
	UInt32	size;
} QSmartMessage_embedmsghdr_t;

#define QSmartMessage_embedmsghdr_get(msgPtr, structAddr, offset)	\
		    qMsgVarFieldGet((msgPtr), 21, &(offset),	\
			(QSmartMessage_embedmsghdr_encoding), &((structAddr)->encoding),	\
			(QSmartMessage_embedmsghdr_priority), &((structAddr)->priority),	\
			(QSmartMessage_embedmsghdr_version), &((structAddr)->version),	\
			(QSmartMessage_embedmsghdr_pad), &((structAddr)->pad),	\
			(QSmartMessage_embedmsghdr_trans), &((structAddr)->trans),	\
			(QSmartMessage_embedmsghdr_srcinst), &((structAddr)->srcinst),	\
			(QSmartMessage_embedmsghdr_srcbrd), &((structAddr)->srcbrd),	\
			(QSmartMessage_embedmsghdr_srcpad1), &((structAddr)->srcpad1),	\
			(QSmartMessage_embedmsghdr_srcproc), &((structAddr)->srcproc),	\
			(QSmartMessage_embedmsghdr_srccomp), &((structAddr)->srccomp),	\
			(QSmartMessage_embedmsghdr_srcnode), &((structAddr)->srcnode),	\
			(QSmartMessage_embedmsghdr_srcpad2), &((structAddr)->srcpad2),	\
			(QSmartMessage_embedmsghdr_destinst), &((structAddr)->destinst),	\
			(QSmartMessage_embedmsghdr_destbrd), &((structAddr)->destbrd),	\
			(QSmartMessage_embedmsghdr_destpad1), &((structAddr)->destpad1),	\
			(QSmartMessage_embedmsghdr_destproc), &((structAddr)->destproc),	\
			(QSmartMessage_embedmsghdr_destcomp), &((structAddr)->destcomp),	\
			(QSmartMessage_embedmsghdr_destnode), &((structAddr)->destnode),	\
			(QSmartMessage_embedmsghdr_destpad2), &((structAddr)->destpad2),	\
			(QSmartMessage_embedmsghdr_type), &((structAddr)->type),	\
			(QSmartMessage_embedmsghdr_size), &((structAddr)->size))


#define QSmartMessage_embedmsghdr_put(msgPtr, structAddr, offset)	\
		    qMsgVarFieldPut((msgPtr), 21, &(offset),	\
			(QSmartMessage_embedmsghdr_encoding), &((structAddr)->encoding),	\
			(QSmartMessage_embedmsghdr_priority), &((structAddr)->priority),	\
			(QSmartMessage_embedmsghdr_version), &((structAddr)->version),	\
			(QSmartMessage_embedmsghdr_pad), &((structAddr)->pad),	\
			(QSmartMessage_embedmsghdr_trans), &((structAddr)->trans),	\
			(QSmartMessage_embedmsghdr_srcinst), &((structAddr)->srcinst),	\
			(QSmartMessage_embedmsghdr_srcbrd), &((structAddr)->srcbrd),	\
			(QSmartMessage_embedmsghdr_srcpad1), &((structAddr)->srcpad1),	\
			(QSmartMessage_embedmsghdr_srcproc), &((structAddr)->srcproc),	\
			(QSmartMessage_embedmsghdr_srccomp), &((structAddr)->srccomp),	\
			(QSmartMessage_embedmsghdr_srcnode), &((structAddr)->srcnode),	\
			(QSmartMessage_embedmsghdr_srcpad2), &((structAddr)->srcpad2),	\
			(QSmartMessage_embedmsghdr_destinst), &((structAddr)->destinst),	\
			(QSmartMessage_embedmsghdr_destbrd), &((structAddr)->destbrd),	\
			(QSmartMessage_embedmsghdr_destpad1), &((structAddr)->destpad1),	\
			(QSmartMessage_embedmsghdr_destproc), &((structAddr)->destproc),	\
			(QSmartMessage_embedmsghdr_destcomp), &((structAddr)->destcomp),	\
			(QSmartMessage_embedmsghdr_destnode), &((structAddr)->destnode),	\
			(QSmartMessage_embedmsghdr_destpad2), &((structAddr)->destpad2),	\
			(QSmartMessage_embedmsghdr_type), &((structAddr)->type),	\
			(QSmartMessage_embedmsghdr_size), &((structAddr)->size))


#define QSmartMessage_embedmsghdr_Size		32

#define QSmartMessage_embedmsghdr	0x7	/* 7 */

#define QSmartMessage_embedmsgdata_data	0x380000	/* 3670016 */
typedef	UInt32	QSmartMessage_embedmsgdata_data_t;


typedef struct {
	UInt32	data;
} QSmartMessage_embedmsgdata_t;

#define QSmartMessage_embedmsgdata_get(msgPtr, structAddr, offset)	\
		    qMsgVarFieldGet((msgPtr), 1, &(offset),	\
			(QSmartMessage_embedmsgdata_data), &((structAddr)->data))


#define QSmartMessage_embedmsgdata_put(msgPtr, structAddr, offset)	\
		    qMsgVarFieldPut((msgPtr), 1, &(offset),	\
			(QSmartMessage_embedmsgdata_data), &((structAddr)->data))


#define QSmartMessage_embedmsgdata_Size		4

#define QSmartMessage_embedmsgdata	0x8	/* 8 */

/*
 * QSmartMessage (value = 0x80007b) is a message of generic use.
 */


typedef struct {
	UInt16	destinst;
	UInt8	destbrd;
	UInt8	pad1;
	UInt8	destproc;
	UInt8	destcomp;
	UInt8	destnode;
	UInt8	pad2;
	UInt32	index;
	UInt8	lastmsgsig;
	UInt8	needreplycnt;
	UInt8	needfreecnt;
	UInt8	reserved1;
} QSmartMessage_t;

#define QSmartMessage_get(msgPtr, structAddr, offset)	\
		    qMsgVarFieldGet((msgPtr), 12, &(offset),	\
			(QSmartMessage_destinst), &((structAddr)->destinst),	\
			(QSmartMessage_destbrd), &((structAddr)->destbrd),	\
			(QSmartMessage_pad1), &((structAddr)->pad1),	\
			(QSmartMessage_destproc), &((structAddr)->destproc),	\
			(QSmartMessage_destcomp), &((structAddr)->destcomp),	\
			(QSmartMessage_destnode), &((structAddr)->destnode),	\
			(QSmartMessage_pad2), &((structAddr)->pad2),	\
			(QSmartMessage_index), &((structAddr)->index),	\
			(QSmartMessage_lastmsgsig), &((structAddr)->lastmsgsig),	\
			(QSmartMessage_needreplycnt), &((structAddr)->needreplycnt),	\
			(QSmartMessage_needfreecnt), &((structAddr)->needfreecnt),	\
			(QSmartMessage_reserved1), &((structAddr)->reserved1))


#define QSmartMessage_put(msgPtr, structAddr, offset)	\
		    qMsgVarFieldPut((msgPtr), 12, &(offset),	\
			(QSmartMessage_destinst), &((structAddr)->destinst),	\
			(QSmartMessage_destbrd), &((structAddr)->destbrd),	\
			(QSmartMessage_pad1), &((structAddr)->pad1),	\
			(QSmartMessage_destproc), &((structAddr)->destproc),	\
			(QSmartMessage_destcomp), &((structAddr)->destcomp),	\
			(QSmartMessage_destnode), &((structAddr)->destnode),	\
			(QSmartMessage_pad2), &((structAddr)->pad2),	\
			(QSmartMessage_index), &((structAddr)->index),	\
			(QSmartMessage_lastmsgsig), &((structAddr)->lastmsgsig),	\
			(QSmartMessage_needreplycnt), &((structAddr)->needreplycnt),	\
			(QSmartMessage_needfreecnt), &((structAddr)->needfreecnt),	\
			(QSmartMessage_reserved1), &((structAddr)->reserved1))


#define QSmartMessage_Size		16

#define QSmartMessage	0x80007b	/* 8388731 */

#define RegularFormat 1
#define SpecialFormat 2
#define QSMART_NOREPLY 1
#define QSMART_SUPPRESS_REPLY 2
#define QSMART_LOCAL_REPLY 4
#define QSMART_SMART_REPLY 8
#define QSMART_DEL_FORWARD 1
#define QSMART_DEL_CONTINUE 2
#define QSMART_GOFLAG 1
#define QSMART_NOGOFLAG 2


#define QSmartMessageReply_numembedmsg	0x380000	/* 3670016 */
typedef	UInt32	QSmartMessageReply_numembedmsg_t;

#define QSmartMessageReply_varStart	0x4

#define QSmartMessageReply_embedmsghdr_encoding	0x200000	/* 2097152 */
typedef	UInt8	QSmartMessageReply_embedmsghdr_encoding_t;

#define QSmartMessageReply_embedmsghdr_priority	0x200000	/* 2097152 */
typedef	UInt8	QSmartMessageReply_embedmsghdr_priority_t;

#define QSmartMessageReply_embedmsghdr_version	0x200000	/* 2097152 */
typedef	UInt8	QSmartMessageReply_embedmsghdr_version_t;

#define QSmartMessageReply_embedmsghdr_pad	0x200000	/* 2097152 */
typedef	UInt8	QSmartMessageReply_embedmsghdr_pad_t;

#define QSmartMessageReply_embedmsghdr_trans	0x380000	/* 3670016 */
typedef	UInt32	QSmartMessageReply_embedmsghdr_trans_t;

#define QSmartMessageReply_embedmsghdr_srcinst	0x280000	/* 2621440 */
typedef	UInt16	QSmartMessageReply_embedmsghdr_srcinst_t;

#define QSmartMessageReply_embedmsghdr_srcbrd	0x200000	/* 2097152 */
typedef	UInt8	QSmartMessageReply_embedmsghdr_srcbrd_t;

#define QSmartMessageReply_embedmsghdr_srcpad1	0x200000	/* 2097152 */
typedef	UInt8	QSmartMessageReply_embedmsghdr_srcpad1_t;

#define QSmartMessageReply_embedmsghdr_srcproc	0x200000	/* 2097152 */
typedef	UInt8	QSmartMessageReply_embedmsghdr_srcproc_t;

#define QSmartMessageReply_embedmsghdr_srccomp	0x200000	/* 2097152 */
typedef	UInt8	QSmartMessageReply_embedmsghdr_srccomp_t;

#define QSmartMessageReply_embedmsghdr_srcnode	0x200000	/* 2097152 */
typedef	UInt8	QSmartMessageReply_embedmsghdr_srcnode_t;

#define QSmartMessageReply_embedmsghdr_srcpad2	0x200000	/* 2097152 */
typedef	UInt8	QSmartMessageReply_embedmsghdr_srcpad2_t;

#define QSmartMessageReply_embedmsghdr_destinst	0x280000	/* 2621440 */
typedef	UInt16	QSmartMessageReply_embedmsghdr_destinst_t;

#define QSmartMessageReply_embedmsghdr_destbrd	0x200000	/* 2097152 */
typedef	UInt8	QSmartMessageReply_embedmsghdr_destbrd_t;

#define QSmartMessageReply_embedmsghdr_destpad1	0x200000	/* 2097152 */
typedef	UInt8	QSmartMessageReply_embedmsghdr_destpad1_t;

#define QSmartMessageReply_embedmsghdr_destproc	0x200000	/* 2097152 */
typedef	UInt8	QSmartMessageReply_embedmsghdr_destproc_t;

#define QSmartMessageReply_embedmsghdr_destcomp	0x200000	/* 2097152 */
typedef	UInt8	QSmartMessageReply_embedmsghdr_destcomp_t;

#define QSmartMessageReply_embedmsghdr_destnode	0x200000	/* 2097152 */
typedef	UInt8	QSmartMessageReply_embedmsghdr_destnode_t;

#define QSmartMessageReply_embedmsghdr_destpad2	0x200000	/* 2097152 */
typedef	UInt8	QSmartMessageReply_embedmsghdr_destpad2_t;

#define QSmartMessageReply_embedmsghdr_type	0x380000	/* 3670016 */
typedef	UInt32	QSmartMessageReply_embedmsghdr_type_t;

#define QSmartMessageReply_embedmsghdr_size	0x380000	/* 3670016 */
typedef	UInt32	QSmartMessageReply_embedmsghdr_size_t;


typedef struct {
	UInt8	encoding;
	UInt8	priority;
	UInt8	version;
	UInt8	pad;
	UInt32	trans;
	UInt16	srcinst;
	UInt8	srcbrd;
	UInt8	srcpad1;
	UInt8	srcproc;
	UInt8	srccomp;
	UInt8	srcnode;
	UInt8	srcpad2;
	UInt16	destinst;
	UInt8	destbrd;
	UInt8	destpad1;
	UInt8	destproc;
	UInt8	destcomp;
	UInt8	destnode;
	UInt8	destpad2;
	UInt32	type;
	UInt32	size;
} QSmartMessageReply_embedmsghdr_t;

#define QSmartMessageReply_embedmsghdr_get(msgPtr, structAddr, offset)	\
		    qMsgVarFieldGet((msgPtr), 21, &(offset),	\
			(QSmartMessageReply_embedmsghdr_encoding), &((structAddr)->encoding),	\
			(QSmartMessageReply_embedmsghdr_priority), &((structAddr)->priority),	\
			(QSmartMessageReply_embedmsghdr_version), &((structAddr)->version),	\
			(QSmartMessageReply_embedmsghdr_pad), &((structAddr)->pad),	\
			(QSmartMessageReply_embedmsghdr_trans), &((structAddr)->trans),	\
			(QSmartMessageReply_embedmsghdr_srcinst), &((structAddr)->srcinst),	\
			(QSmartMessageReply_embedmsghdr_srcbrd), &((structAddr)->srcbrd),	\
			(QSmartMessageReply_embedmsghdr_srcpad1), &((structAddr)->srcpad1),	\
			(QSmartMessageReply_embedmsghdr_srcproc), &((structAddr)->srcproc),	\
			(QSmartMessageReply_embedmsghdr_srccomp), &((structAddr)->srccomp),	\
			(QSmartMessageReply_embedmsghdr_srcnode), &((structAddr)->srcnode),	\
			(QSmartMessageReply_embedmsghdr_srcpad2), &((structAddr)->srcpad2),	\
			(QSmartMessageReply_embedmsghdr_destinst), &((structAddr)->destinst),	\
			(QSmartMessageReply_embedmsghdr_destbrd), &((structAddr)->destbrd),	\
			(QSmartMessageReply_embedmsghdr_destpad1), &((structAddr)->destpad1),	\
			(QSmartMessageReply_embedmsghdr_destproc), &((structAddr)->destproc),	\
			(QSmartMessageReply_embedmsghdr_destcomp), &((structAddr)->destcomp),	\
			(QSmartMessageReply_embedmsghdr_destnode), &((structAddr)->destnode),	\
			(QSmartMessageReply_embedmsghdr_destpad2), &((structAddr)->destpad2),	\
			(QSmartMessageReply_embedmsghdr_type), &((structAddr)->type),	\
			(QSmartMessageReply_embedmsghdr_size), &((structAddr)->size))


#define QSmartMessageReply_embedmsghdr_put(msgPtr, structAddr, offset)	\
		    qMsgVarFieldPut((msgPtr), 21, &(offset),	\
			(QSmartMessageReply_embedmsghdr_encoding), &((structAddr)->encoding),	\
			(QSmartMessageReply_embedmsghdr_priority), &((structAddr)->priority),	\
			(QSmartMessageReply_embedmsghdr_version), &((structAddr)->version),	\
			(QSmartMessageReply_embedmsghdr_pad), &((structAddr)->pad),	\
			(QSmartMessageReply_embedmsghdr_trans), &((structAddr)->trans),	\
			(QSmartMessageReply_embedmsghdr_srcinst), &((structAddr)->srcinst),	\
			(QSmartMessageReply_embedmsghdr_srcbrd), &((structAddr)->srcbrd),	\
			(QSmartMessageReply_embedmsghdr_srcpad1), &((structAddr)->srcpad1),	\
			(QSmartMessageReply_embedmsghdr_srcproc), &((structAddr)->srcproc),	\
			(QSmartMessageReply_embedmsghdr_srccomp), &((structAddr)->srccomp),	\
			(QSmartMessageReply_embedmsghdr_srcnode), &((structAddr)->srcnode),	\
			(QSmartMessageReply_embedmsghdr_srcpad2), &((structAddr)->srcpad2),	\
			(QSmartMessageReply_embedmsghdr_destinst), &((structAddr)->destinst),	\
			(QSmartMessageReply_embedmsghdr_destbrd), &((structAddr)->destbrd),	\
			(QSmartMessageReply_embedmsghdr_destpad1), &((structAddr)->destpad1),	\
			(QSmartMessageReply_embedmsghdr_destproc), &((structAddr)->destproc),	\
			(QSmartMessageReply_embedmsghdr_destcomp), &((structAddr)->destcomp),	\
			(QSmartMessageReply_embedmsghdr_destnode), &((structAddr)->destnode),	\
			(QSmartMessageReply_embedmsghdr_destpad2), &((structAddr)->destpad2),	\
			(QSmartMessageReply_embedmsghdr_type), &((structAddr)->type),	\
			(QSmartMessageReply_embedmsghdr_size), &((structAddr)->size))


#define QSmartMessageReply_embedmsghdr_Size		32

#define QSmartMessageReply_embedmsghdr	0x9	/* 9 */

#define QSmartMessageReply_embedmsgdata_data	0x380000	/* 3670016 */
typedef	UInt32	QSmartMessageReply_embedmsgdata_data_t;


typedef struct {
	UInt32	data;
} QSmartMessageReply_embedmsgdata_t;

#define QSmartMessageReply_embedmsgdata_get(msgPtr, structAddr, offset)	\
		    qMsgVarFieldGet((msgPtr), 1, &(offset),	\
			(QSmartMessageReply_embedmsgdata_data), &((structAddr)->data))


#define QSmartMessageReply_embedmsgdata_put(msgPtr, structAddr, offset)	\
		    qMsgVarFieldPut((msgPtr), 1, &(offset),	\
			(QSmartMessageReply_embedmsgdata_data), &((structAddr)->data))


#define QSmartMessageReply_embedmsgdata_Size		4

#define QSmartMessageReply_embedmsgdata	0xa	/* 10 */

/*
 * QSmartMessageReply (value = 0x80007c) is a message of generic use.
 */


typedef struct {
	UInt32	numembedmsg;
} QSmartMessageReply_t;

#define QSmartMessageReply_get(msgPtr, structAddr, offset)	\
		    qMsgVarFieldGet((msgPtr), 1, &(offset),	\
			(QSmartMessageReply_numembedmsg), &((structAddr)->numembedmsg))


#define QSmartMessageReply_put(msgPtr, structAddr, offset)	\
		    qMsgVarFieldPut((msgPtr), 1, &(offset),	\
			(QSmartMessageReply_numembedmsg), &((structAddr)->numembedmsg))


#define QSmartMessageReply_Size		4

#define QSmartMessageReply	0x80007c	/* 8388732 */
/* Assign timeslots to a cluster output port and activate that port */
/* The cluster or the instance that owns the port   */

#define QClusterSlotReroute_instDesc	0x800000	/* 8388608 */
typedef	QCompDesc	QClusterSlotReroute_instDesc_t;
/* Port description				       */

#define QClusterSlotReroute_portId	0x300006	/* 3145734 */
typedef	UInt24	QClusterSlotReroute_portId_t;
/* Number of timeslots to assign to port	       */

#define QClusterSlotReroute_width	0x200009	/* 2097161 */
typedef	UInt8	QClusterSlotReroute_width_t;
/* Type of PCM encoding on timeslots		       */

#define QClusterSlotReroute_encoding	0x20000a	/* 2097162 */
typedef	UInt8	QClusterSlotReroute_encoding_t;
/* Idle pattern required on timeslots		       */

#define QClusterSlotReroute_idlePattern	0x20000b	/* 2097163 */
typedef	UInt8	QClusterSlotReroute_idlePattern_t;
/* Activation options                               */

#define QClusterSlotReroute_options	0x20000c	/* 2097164 */
typedef	UInt8	QClusterSlotReroute_options_t;
/* Talker protocol handler                          */

#define QClusterSlotReroute_talkerDesc	0x80000d	/* 8388621 */
typedef	QCompDesc	QClusterSlotReroute_talkerDesc_t;

#define QClusterSlotReroute_varStart	0x13
/* List of timeslot numbers [width]		       */

#define QClusterSlotReroute_slotId	0x280000	/* 2621440 */
typedef	UInt16	QClusterSlotReroute_slotId_t;

/*
 * QClusterSlotReroute (value = 0x80007d) is an input message of generic use.
 */


typedef struct {
	QCompDesc	instDesc;
	UInt24	portId;
	UInt8	width;
	UInt8	encoding;
	UInt8	idlePattern;
	UInt8	options;
	QCompDesc	talkerDesc;
} QClusterSlotReroute_t;

#define QClusterSlotReroute_get(msgPtr, structAddr, offset)	\
		    qMsgVarFieldGet((msgPtr), 7, &(offset),	\
			(QClusterSlotReroute_instDesc), &((structAddr)->instDesc),	\
			(QClusterSlotReroute_portId), &((structAddr)->portId),	\
			(QClusterSlotReroute_width), &((structAddr)->width),	\
			(QClusterSlotReroute_encoding), &((structAddr)->encoding),	\
			(QClusterSlotReroute_idlePattern), &((structAddr)->idlePattern),	\
			(QClusterSlotReroute_options), &((structAddr)->options),	\
			(QClusterSlotReroute_talkerDesc), &((structAddr)->talkerDesc))


#define QClusterSlotReroute_put(msgPtr, structAddr, offset)	\
		    qMsgVarFieldPut((msgPtr), 7, &(offset),	\
			(QClusterSlotReroute_instDesc), &((structAddr)->instDesc),	\
			(QClusterSlotReroute_portId), &((structAddr)->portId),	\
			(QClusterSlotReroute_width), &((structAddr)->width),	\
			(QClusterSlotReroute_encoding), &((structAddr)->encoding),	\
			(QClusterSlotReroute_idlePattern), &((structAddr)->idlePattern),	\
			(QClusterSlotReroute_options), &((structAddr)->options),	\
			(QClusterSlotReroute_talkerDesc), &((structAddr)->talkerDesc))


#define QClusterSlotReroute_Size		19

#define QClusterSlotReroute	0x80007d	/* 8388733 */

/* In function qClusterSlotReroute():*/
#define QCLUST_SR_DeactivateFailed     0x01  /* qClusterDeactivate()     function failed*/
#define QCLUST_SR_SlotUnassignFailed   0x02  /* qClusterSlotUnassigned() function failed*/
#define QCLUST_SR_SlotAssignFailed     0x03  /* qClusterSlotAssigned()   function failed*/
#define QCLUST_SR_ActivateFailed       0x04  /* qClusterActivate()       function failed*/
#define QCLUST_SR_PortFindFailed       0x05  /* qClusterPortFind()       function failed*/
/* In function qClusterSlotUnroute():*/
#define QCLUST_SU_DeactivateFailed     0x06  /* qClusterDeactivate()     function failed*/
#define QCLUST_SU_SlotUnassignFailed   0x07  /* qClusterSlotUnassigned() function failed*/
#define QCLUST_SU_PortFindFailed       0x08  /* qClusterPortFind()       function failed*/
/* Deactivate an output port in a cluster and unassign the time slot. */
/* The cluster or the instance that owns the port   */

#define QClusterSlotUnroute_instDesc	0x800000	/* 8388608 */
typedef	QCompDesc	QClusterSlotUnroute_instDesc_t;
/* Port description				*/

#define QClusterSlotUnroute_portId	0x300006	/* 3145734 */
typedef	UInt24	QClusterSlotUnroute_portId_t;

/*
 * QClusterSlotUnroute (value = 0x80007e) is an input message of generic use.
 */


typedef struct {
	QCompDesc	instDesc;
	UInt24	portId;
} QClusterSlotUnroute_t;

#define QClusterSlotUnroute_get(msgPtr, structAddr, offset)	\
		    qMsgVarFieldGet((msgPtr), 2, &(offset),	\
			(QClusterSlotUnroute_instDesc), &((structAddr)->instDesc),	\
			(QClusterSlotUnroute_portId), &((structAddr)->portId))


#define QClusterSlotUnroute_put(msgPtr, structAddr, offset)	\
		    qMsgVarFieldPut((msgPtr), 2, &(offset),	\
			(QClusterSlotUnroute_instDesc), &((structAddr)->instDesc),	\
			(QClusterSlotUnroute_portId), &((structAddr)->portId))


#define QClusterSlotUnroute_Size		9

#define QClusterSlotUnroute	0x80007e	/* 8388734 */
/*Message to start or stop monitoring of the host by the firmware*/
/* The heartbeat message interval (sec)	*/

#define QHostSendAliveConfig_interval	0x300000	/* 3145728 */
typedef	UInt24	QHostSendAliveConfig_interval_t;
/* Number of missed SendAlive messages	*/

#define QHostSendAliveConfig_threshold	0x300003	/* 3145731 */
typedef	UInt24	QHostSendAliveConfig_threshold_t;
/* Reserved for future use			*/

#define QHostSendAliveConfig_rfu	0x300006	/* 3145734 */
typedef	UInt24	QHostSendAliveConfig_rfu_t;

/*
 * QHostSendAliveConfig (value = 0x80007f) is an input message of generic use.
 */


typedef struct {
	UInt24	interval;
	UInt24	threshold;
	UInt24	rfu;
} QHostSendAliveConfig_t;

#define QHostSendAliveConfig_get(msgPtr, structAddr, offset)	\
		    qMsgVarFieldGet((msgPtr), 3, &(offset),	\
			(QHostSendAliveConfig_interval), &((structAddr)->interval),	\
			(QHostSendAliveConfig_threshold), &((structAddr)->threshold),	\
			(QHostSendAliveConfig_rfu), &((structAddr)->rfu))


#define QHostSendAliveConfig_put(msgPtr, structAddr, offset)	\
		    qMsgVarFieldPut((msgPtr), 3, &(offset),	\
			(QHostSendAliveConfig_interval), &((structAddr)->interval),	\
			(QHostSendAliveConfig_threshold), &((structAddr)->threshold),	\
			(QHostSendAliveConfig_rfu), &((structAddr)->rfu))


#define QHostSendAliveConfig_Size		9

#define QHostSendAliveConfig	0x80007f	/* 8388735 */
/*This message returns the status of the execution of QHostSendAliveConfig message*/
/* */

#define QHostSendAliveConfigResult_acceptRejectFlag	0x300000	/* 3145728 */
typedef	UInt24	QHostSendAliveConfigResult_acceptRejectFlag_t;
/* */

#define QHostSendAliveConfigResult_errorCode	0x300003	/* 3145731 */
typedef	UInt24	QHostSendAliveConfigResult_errorCode_t;

/*
 * QHostSendAliveConfigResult (value = 0x800080) is an output message of generic use.
 */


typedef struct {
	UInt24	acceptRejectFlag;
	UInt24	errorCode;
} QHostSendAliveConfigResult_t;

#define QHostSendAliveConfigResult_get(msgPtr, structAddr, offset)	\
		    qMsgVarFieldGet((msgPtr), 2, &(offset),	\
			(QHostSendAliveConfigResult_acceptRejectFlag), &((structAddr)->acceptRejectFlag),	\
			(QHostSendAliveConfigResult_errorCode), &((structAddr)->errorCode))


#define QHostSendAliveConfigResult_put(msgPtr, structAddr, offset)	\
		    qMsgVarFieldPut((msgPtr), 2, &(offset),	\
			(QHostSendAliveConfigResult_acceptRejectFlag), &((structAddr)->acceptRejectFlag),	\
			(QHostSendAliveConfigResult_errorCode), &((structAddr)->errorCode))


#define QHostSendAliveConfigResult_Size		6

#define QHostSendAliveConfigResult	0x800080	/* 8388736 */

/* acceptRejectFlag values */
#define SEND_ALIVE_CONFIG_ACCEPT  0
#define SEND_ALIVE_CONFIG_REJECT  1

/*Message to indicate that the host system failed*/

/*
 * QHostFailed (value = 0x800081) is an input message of generic use.
 */

#define QHostFailed_Size		0

#define QHostFailed	0x800081	/* 8388737 */

#endif /* !defined(_mercdefs_h_) */
