/**********@@@SOFT@@@WARE@@@COPY@@@RIGHT@@@**********************************
* DIALOGIC CONFIDENTIAL
*
* Copyright (C) 2007-2009 Dialogic Corporation. All Rights Reserved.
* The source code contained or described herein and all documents related
* to the source code ("Material") are owned by Dialogic Corporation or its
* suppliers or licensors. Title to the Material remains with Dialogic Corporation
* or its suppliers and licensors. The Material contains trade secrets and
* proprietary and confidential information of Dialogic or its suppliers and
* licensors. The Material is protected by worldwide copyright and trade secret
* laws and treaty provisions. No part of the Material may be used, copied,
* reproduced, modified, published, uploaded, posted, transmitted, distributed,
* or disclosed in any way without Dialogic's prior express written permission.
*
* No license under any patent, copyright, trade secret or other intellectual
* property right is granted to or conferred upon you by disclosure or delivery
* of the Materials, either expressly, by implication, inducement, estoppel or
* otherwise. Any license under such intellectual property rights must be
* express and approved by Dialogic in writing.
*
***********************************@@@SOFT@@@WARE@@@COPY@@@RIGHT@@@**********/
#ifndef _MMEVTS_H_
#define _MMEVTS_H_

/* -----------------------------------------------------------------------------
 * Define MM events
 * -----------------------------------------------------------------------------
 */
 
/* Mask for all MM events */
#define MMEV_MASK                       0xA000L

/* Mask for all MM error events */
#define MMEV_ERROR_MASK                 (MMEV_MASK | 0x0800)

/*
 * Define success events
 */
#define MMEV_OPEN                       (MMEV_MASK | 0x01)  /* device opened */
#define MMEV_PLAY_ACK                   (MMEV_MASK | 0x02)  /* play initiated */
#define MMEV_RECORD_ACK                 (MMEV_MASK | 0x03)  /* record initiated */
#define MMEV_STOP_ACK                   (MMEV_MASK | 0x04)  /* stop initiated */
#define MMEV_RESET_ACK                  (MMEV_MASK | 0x05)  /* device reset initiated */
#define MMEV_ENABLEEVENTS               (MMEV_MASK | 0x06)  /* enabled notification events */
#define MMEV_DISABLEEVENTS              (MMEV_MASK | 0x07)  /* disabled notification events */
#define MMEV_PLAY                       (MMEV_MASK | 0x08)  /* play completed */
#define MMEV_RECORD                     (MMEV_MASK | 0x09)  /* record completed */
#define MMEV_RESET                      (MMEV_MASK | 0x0A)  /* device reset */
#define MMEV_GET_CHAN_STATE             (MMEV_MASK | 0x0B)  /* get channel state completed */
#define MMEV_SETPARM                    (MMEV_MASK | 0x0C)  /* parameter set */
#define MMEV_GETPARM                    (MMEV_MASK | 0x0D)  /* parameter retrieved */
#define MMEV_PLAY_VIDEO_LOWWATER        (MMEV_MASK | 0x0E)  /* video play low watermark hit */
#define MMEV_PLAY_VIDEO_HIGHWATER       (MMEV_MASK | 0x0F)  /* video play high watermark hit */
#define MMEV_PLAY_AUDIO_LOWWATER        (MMEV_MASK | 0x10)  /* audio play low watermark hit */
#define MMEV_PLAY_AUDIO_HIGHWATER       (MMEV_MASK | 0x11)  /* audio play high watermark hit */
#define MMEV_RECORD_VIDEO_LOWWATER      (MMEV_MASK | 0x12)  /* video record low watermark hit */
#define MMEV_RECORD_VIDEO_HIGHWATER     (MMEV_MASK | 0x13)  /* video record high watermark hit */
#define MMEV_RECORD_AUDIO_LOWWATER      (MMEV_MASK | 0x14)  /* audio record low watermark hit */
#define MMEV_RECORD_AUDIO_HIGHWATER     (MMEV_MASK | 0x15)  /* audio record high watermark hit */
#define MMEV_CAPTURE_ACK                (MMEV_MASK | 0x16)  /* capture image initiated */
#define MMEV_CAPTURE                    (MMEV_MASK | 0x17)  /* capture image completed */

#define MMEV_PAUSE                      (MMEV_MASK | 0x20)  /* paused */
#define MMEV_RESUME                     (MMEV_MASK | 0x21)  /* resumed */
#define MMEV_SEEK                       (MMEV_MASK | 0x22)  /* seek completed */
#define MMEV_GETELAPSEDTIME             (MMEV_MASK | 0x24)  /* get time completed */
#define MMEV_GETDURATION                (MMEV_MASK | 0x25)  /* get duration completed */

/*
 * Define optional events
 */
#define MMEV_VIDEO_RECORD_STARTED       (MMEV_MASK | 0x30)  /* video recording started */
#define MMEV_RECORD_VIDEO_EOD           (MMEV_MASK | 0x31)  /* video record eod */
#define MMEV_RECORD_AUDIO_EOD           (MMEV_MASK | 0x32)  /* audio record eod */

/* last event code (not real event) */
#define MMEV_LAST_EVENT                 (MMEV_MASK | 0x7F)

/* -----------------------------------------------------------------------------
 * General failure event
 * Indicates general failure during response processing
 * It may be anything ranging from memory errors to implementation assertions
 * May be generated as a response to any request
 * -----------------------------------------------------------------------------
 */
#define MMEV_ERROR                      (MMEV_ERROR_MASK | 0xff)

/* -----------------------------------------------------------------------------
 * Define specific failure events
 * Generated when an error occured during processing of a particular request 
 * -----------------------------------------------------------------------------
 */
#define MMEV_OPEN_FAIL                  (MMEV_ERROR_MASK | 0x01)
#define MMEV_PLAY_ACK_FAIL              (MMEV_ERROR_MASK | 0x02)
#define MMEV_RECORD_ACK_FAIL            (MMEV_ERROR_MASK | 0x03)
#define MMEV_STOP_ACK_FAIL              (MMEV_ERROR_MASK | 0x04)
#define MMEV_RESET_ACK_FAIL             (MMEV_ERROR_MASK | 0x05)
#define MMEV_ENABLEEVENTS_FAIL          (MMEV_ERROR_MASK | 0x06)
#define MMEV_DISABLEEVENTS_FAIL         (MMEV_ERROR_MASK | 0x07)
#define MMEV_PLAY_FAIL                  (MMEV_ERROR_MASK | 0x08)
#define MMEV_RECORD_FAIL                (MMEV_ERROR_MASK | 0x09)
#define MMEV_RESET_FAIL                 (MMEV_ERROR_MASK | 0x0A)
#define MMEV_GET_CHAN_STATE_FAIL        (MMEV_ERROR_MASK | 0x0B)
#define MMEV_SETPARM_FAIL               (MMEV_ERROR_MASK | 0x0C)
#define MMEV_GETPARM_FAIL               (MMEV_ERROR_MASK | 0x0D)
#define MMEV_CAPTURE_ACK_FAIL           (MMEV_ERROR_MASK | 0x0E)
#define MMEV_CAPTURE_FAIL               (MMEV_ERROR_MASK | 0x0F)

#define MMEV_PAUSE_FAIL                 (MMEV_ERROR_MASK | 0x20)
#define MMEV_RESUME_FAIL                (MMEV_ERROR_MASK | 0x21)
#define MMEV_SEEK_FAIL                  (MMEV_ERROR_MASK | 0x22)
#define MMEV_SKIP_FAIL                  (MMEV_ERROR_MASK | 0x23)
#define MMEV_GETELAPSEDTIME_FAIL        (MMEV_ERROR_MASK | 0x24)
#define MMEV_GETDURATION_FAIL           (MMEV_ERROR_MASK | 0x25)

/*
 * Define optional failure events
 */
#define MMEV_VIDEO_RECORD_STARTED_FAIL  (MMEV_ERROR_MASK | 0x30)

/* Last error event code (not real error) */
#define MMEV_LAST_EVENT_ERROR           (MMEV_ERROR_MASK | 0x7F)

/*
 * Enable/Disable event masks
 */
#define MMR_EVENT_VIDEO_RECORD_STARTED_POSITION	0
#define MMR_RECORD_VIDEO_EOD_POSITION           1
#define MMR_RECORD_AUDIO_EOD_POSITION           2

#define MMR_EVENT_VIDEO_RECORD_STARTED (1 << MMR_EVENT_VIDEO_RECORD_STARTED_POSITION)
#define MMR_EVENT_RECORD_VIDEO_EOD     (1 << MMR_RECORD_VIDEO_EOD_POSITION)
#define MMR_EVENT_RECORD_AUDIO_EOD     (1 << MMR_RECORD_AUDIO_EOD_POSITION)

#define MMR_EVENT_ALL (~0L)
/*
 * The mask specifies which optional events are enabled by default.
 */
#define MMR_EVENT_DEFAULT_MASK         (MMR_EVENT_VIDEO_RECORD_STARTED)

#endif /* _MMEVTS_H_ */
