/**********@@@SOFT@@@WARE@@@COPY@@@RIGHT@@@**********************************
* DIALOGIC CONFIDENTIAL
*
* Copyright (C) 2007-2009 Dialogic Corporation. All Rights Reserved.
* The source code contained or described herein and all documents related
* to the source code ("Material") are owned by Dialogic Corporation or its
* suppliers or licensors. Title to the Material remains with Dialogic Corporation
* or its suppliers and licensors. The Material contains trade secrets and
* proprietary and confidential information of Dialogic or its suppliers and
* licensors. The Material is protected by worldwide copyright and trade secret
* laws and treaty provisions. No part of the Material may be used, copied,
* reproduced, modified, published, uploaded, posted, transmitted, distributed,
* or disclosed in any way without Dialogic's prior express written permission.
*
* No license under any patent, copyright, trade secret or other intellectual
* property right is granted to or conferred upon you by disclosure or delivery
* of the Materials, either expressly, by implication, inducement, estoppel or
* otherwise. Any license under such intellectual property rights must be
* express and approved by Dialogic in writing.
*
***********************************@@@SOFT@@@WARE@@@COPY@@@RIGHT@@@**********/
#ifndef _MMLIB_H_
#define _MMLIB_H_

#include "mmtarget.h"
#include "mmerrs.h"
#include "mmevts.h"
#include "mmparms.h"
#include "mtklib.h"
#include "videodefs.h"

#pragma pack(push, 8)

/*** General purpose item types ***/
/* Chain definitions */
typedef enum tagEMM_ITEM
{
	EMM_ITEM_CONT,
	EMM_ITEM_LINK,
	EMM_ITEM_EOT
} eMM_ITEM;

/* Return codes */
typedef struct tagMM_RET_CODE
{
	unsigned int unVersion;
	unsigned int unRetCode;
} MM_RET_CODE, *PMM_RET_CODE;
typedef const MM_RET_CODE* CPMM_RET_CODE;

#define MM_RET_CODE_VER(v) (sizeof(MM_RET_CODE) << 16 | (0xFFFF & (v)))
#define MM_RET_CODE_VERSION_0 MM_RET_CODE_VER(0)
#define MM_RET_CODE_VERSION MM_RET_CODE_VERSION_0

static __inline void INIT_MM_RET_CODE(PMM_RET_CODE pStruct) {
    pStruct->unVersion              = MM_RET_CODE_VERSION;
    pStruct->unRetCode              = EMMRC_OK;
}

/*******************************************************************************
*  mm_Open definitions
*******************************************************************************/
typedef struct tagMM_OPEN_INFO
{
	unsigned int unVersion;
	unsigned int unRFU;
} MM_OPEN_INFO, *PMM_OPEN_INFO;
typedef const MM_OPEN_INFO* CPMM_OPEN_INFO;

#define MM_OPEN_INFO_VER(v) (sizeof(MM_OPEN_INFO) << 16 | (0xFFFF & (v)))
#define MM_OPEN_INFO_VERSION_0 MM_OPEN_INFO_VER(0)
#define MM_OPEN_INFO_VERSION MM_OPEN_INFO_VERSION_0

static __inline void INIT_MM_OPEN_INFO(PMM_OPEN_INFO pStruct) {
    pStruct->unVersion              = MM_OPEN_INFO_VERSION;
    pStruct->unRFU                  = 0;
}

typedef MM_RET_CODE MM_OPEN_RESULT, *PMM_OPEN_RESULT;
typedef const MM_RET_CODE* CPMM_OPEN_RESULT;

#define MM_OPEN_RESULT_VER(v) (sizeof(MM_OPEN_RESULT) << 16 | (0xFFFF & (v)))
#define MM_OPEN_RESULT_VERSION_0 MM_OPEN_RESULT_VER(0)
#define MM_OPEN_RESULT_VERSION MM_OPEN_RESULT_VERSION_0

static __inline void INIT_MM_OPEN_RESULT(PMM_OPEN_RESULT pStruct) {
    INIT_MM_RET_CODE(pStruct);
}

/*******************************************************************************
*  mm_Close definitions
*******************************************************************************/
typedef struct tagMM_CLOSE_INFO
{
	unsigned int unVersion;
	unsigned int unRFU;
} MM_CLOSE_INFO, *PMM_CLOSE_INFO;
typedef const MM_CLOSE_INFO* CPMM_CLOSE_INFO;

#define MM_CLOSE_INFO_VER(v) (sizeof(MM_CLOSE_INFO) << 16 | (0xFFFF & (v)))
#define MM_CLOSE_INFO_VERSION_0 MM_CLOSE_INFO_VER(0)
#define MM_CLOSE_INFO_VERSION MM_CLOSE_INFO_VERSION_0

static __inline void INIT_MM_CLOSE_INFO(PMM_CLOSE_INFO pStruct) {
    pStruct->unVersion              = MM_CLOSE_INFO_VERSION;
    pStruct->unRFU                  = 0;
}

/*******************************************************************************
*  mm_Play and mm_Record definitions
*******************************************************************************/

/*
 * unMode audio/video definitions  
 */

#define MM_MODE_NOT_USED_1          0x0001  /* for internal use only */
#define MM_MODE_PAUSED              0x0002  /* used in audio & video unMode */
#define MM_MODE_BEEPINITIATED       0x0004  /* used in audio & video unMode */
#define MM_MODE_NOIFRMBEEPINITIATED 0x0008  /* used in video unMode */
#define MM_MODE_NOT_USED_2          0x0010  /* for internal use only */
#define MM_MODE_FILE_TYPE_VOX       0x0020  /* used in audio unMode for MM_MEDIA_AUDIO version 0 (HMP1.5) only
                                               (for all other versions use eFileFormat field in MM_MEDIA_AUDIO) */
#define MM_MODE_NOT_USED_3          0x0040  /* for internal use only */
#define MM_MODE_AGC_ON              0x0080  /* used in audio unMode */
#define MM_MODE_OFFSET_IN_BYTES     0x0100  /* used in audio & video unMode (although video offset not supported yet) */

typedef enum tagEMM_MEDIA_TYPE
{
	EMM_MEDIA_TYPE_VIDEO,
	EMM_MEDIA_TYPE_AUDIO,
	EMM_MEDIA_TYPE_TERM,
	EMM_MEDIA_TYPE_IMAGE,
	EMM_MEDIA_TYPE_UNDEFINED = 0xff
} eMM_MEDIA_TYPE;

typedef struct tagMM_VIDEO_CODEC
{
    unsigned int            unVersion;
    eVIDEO_CODING           Coding;
    eVIDEO_PROFILE          Profile;                    /* Profile ID for H263, Profile and Level ID for MPEG4 */
    eVIDEO_LEVEL            Level;                      /* Ignored for MPEG4 */
    eVIDEO_IMAGE_WIDTH      ImageWidth;
    eVIDEO_IMAGE_HEIGHT     ImageHeight;
    eVIDEO_BITRATE          BitRate;
    eVIDEO_FRAMESPERSEC     FramesPerSec;
    eVIDEO_SAMPLING_RATE    SamplingRate;               /* added in version 1 */
    unsigned int            VisualConfigSize;           /* added in version 1 */
    unsigned char*          VisualConfiguration;        /* added in version 1 */ 
    eH264_ACCEPT_REDUNDAND_SLICES   H264_AcceptRedundantSlices;      /* added in version 2 */ 
    unsigned int                    H264_ProfileIOP;                 /* added in version 2 */ 
    eH264_PACKETIZATION_MODE        H264_PacketizationMode;          /* added in version 2 */ 
    unsigned int                    H264_MaxNalUnitSize;            /* added in version 2 */
} MM_VIDEO_CODEC, *PMM_VIDEO_CODEC;
typedef const MM_VIDEO_CODEC* CPMM_VIDEO_CODEC;

#define MM_VIDEO_CODEC_VER(v) (sizeof(MM_VIDEO_CODEC) << 16 | (0xFFFF & (v)))
#define MM_VIDEO_CODEC_VERSION_0 MM_VIDEO_CODEC_VER(0)
#define MM_VIDEO_CODEC_VERSION_1 MM_VIDEO_CODEC_VER(1)
#define MM_VIDEO_CODEC_VERSION_2 MM_VIDEO_CODEC_VER(2)
#define MM_VIDEO_CODEC_VERSION MM_VIDEO_CODEC_VER(2)

static __inline void INIT_MM_VIDEO_CODEC(PMM_VIDEO_CODEC pStruct) {
    pStruct->unVersion              = MM_VIDEO_CODEC_VERSION;
    pStruct->Coding                 = VIDEO_CODING_DEFAULT;
    pStruct->Profile                = VIDEO_PROFILE_DEFAULT;
    pStruct->Level                  = VIDEO_LEVEL_DEFAULT;
    pStruct->ImageWidth             = VIDEO_IMAGE_WIDTH_DEFAULT;
    pStruct->ImageHeight            = VIDEO_IMAGE_HEIGHT_DEFAULT;
    pStruct->BitRate                = VIDEO_BITRATE_DEFAULT;
    pStruct->FramesPerSec           = VIDEO_FRAMESPERSEC_DEFAULT;
    pStruct->SamplingRate           = VIDEO_SAMPLING_RATE_DEFAULT;
    pStruct->VisualConfigSize       = 0;
    pStruct->VisualConfiguration    = NULL;
    pStruct->H264_AcceptRedundantSlices  = ACCEPT_REDUNDAND_SLICES_DEFAULT; 
    pStruct->H264_ProfileIOP             = H264_PROFILE_IOP_DEFAULT;
    pStruct->H264_PacketizationMode      = H264_PACKETIZATION_MODE_DEFAULT;
    pStruct->H264_MaxNalUnitSize      = H264_MAX_NAL_UNIT_SIZE_DEFAULT;

}

typedef struct tagMM_MEDIA_ACCESS_MEMORY
{
	unsigned int  unVersion;
	unsigned char *pBuffer;
	unsigned int unBufferSize;
} MM_MEDIA_ACCESS_MEMORY, *PMM_MEDIA_ACCESS_MEMORY;
typedef const MM_MEDIA_ACCESS_MEMORY *CPMM_MEDIA_ACCESS_MEMORY;

#define MM_MEDIA_ACCESS_MEMORY_VER(v) (sizeof(MM_MEDIA_ACCESS_MEMORY) << 16 | (0xFFFF & (v)))
#define MM_MEDIA_ACCESS_MEMORY_VERSION_0 MM_MEDIA_ACCESS_MEMORY_VER(0)
#define MM_MEDIA_ACCESS_MEMORY_VERSION MM_MEDIA_ACCESS_MEMORY_VERSION_0

static __inline void INIT_MM_MEDIA_ACCESS_MEMORY(PMM_MEDIA_ACCESS_MEMORY pStruct) {
    pStruct->unVersion              = MM_MEDIA_ACCESS_MEMORY_VERSION;
    pStruct->pBuffer                = (unsigned char*)0;
    pStruct->unBufferSize           = 0;
}

typedef struct tagMM_MEDIA_ACCESS_STREAM
{
	unsigned int unVersion;
	int nStreamHandle;
} MM_MEDIA_ACCESS_STREAM, *PMM_MEDIA_ACCESS_STREAM;
typedef const MM_MEDIA_ACCESS_STREAM *CPMM_MEDIA_ACCESS_STREAM; 

#define MM_MEDIA_ACCESS_STREAM_VER(v) (sizeof(MM_MEDIA_ACCESS_STREAM) << 16 | (0xFFFF & (v)))
#define MM_MEDIA_ACCESS_STREAM_VERSION_0 MM_MEDIA_ACCESS_STREAM_VER(0)
#define MM_MEDIA_ACCESS_STREAM_VERSION MM_MEDIA_ACCESS_STREAM_VERSION_0

static __inline void INIT_MM_MEDIA_ACCESS_STREAM(PMM_MEDIA_ACCESS_STREAM pStruct) {
    pStruct->unVersion              = MM_MEDIA_ACCESS_STREAM_VERSION;
    pStruct->nStreamHandle          = -1;
}

/*
 * unMode video definitions  
 */
#define MM_MODE_VID_PAUSED              MM_MODE_PAUSED
#define MM_MODE_VID_BEEPINITIATED       MM_MODE_BEEPINITIATED
#define MM_MODE_VID_NOIFRMBEEPINITIATED MM_MODE_NOIFRMBEEPINITIATED
#define MM_MODE_VID_OFFSET_IN_BYTES     MM_MODE_OFFSET_IN_BYTES

/*
 * unAccessMode definitions
 */
#define MM_MEDIA_ACCESS_MODE_FILE         0
#define MM_MEDIA_ACCESS_MODE_MEMORY       1
#define MM_MEDIA_ACCESS_MODE_STREAM       2

/*
 * pEndFlag definitions (for mm_StreamRead() and mm_StreamWrite())
 */
#define MM_FLAG_STREAM_CONT               0
#define MM_FLAG_STREAM_EOD                1

typedef enum tagEMM_FILE_FORMAT
{
	EMM_FILE_FORMAT_UNDEFINED = 0,
	EMM_FILE_FORMAT_PROPRIETARY = 1,
	EMM_FILE_FORMAT_ISO_MEDIA_EX = 2,    // not used
	EMM_AUD_FILEFORMAT_PROPRIETARY = 3,
	EMM_AUD_FILEFORMAT_VOX = 4,
	EMM_AUD_FILEFORMAT_WAVE = 5,
	EMM_FILE_FORMAT_3GP = 6
} eMM_FILE_FORMAT;

typedef struct tagMM_MEDIA_VIDEO
{
	unsigned int    unVersion;
	MM_VIDEO_CODEC  codec;                  /* modified in version 3 */
	unsigned int    unMode;
	union {
		const char*            szFileName;
		MM_MEDIA_ACCESS_STREAM stream;      /* added in version 1 */
		MM_MEDIA_ACCESS_MEMORY memory;      /* added in version 1 */
	};
	unsigned int    unAccessMode;           /* added in version 1 */
	unsigned int    unOffset;               /* added in version 2 */
	eMM_FILE_FORMAT eFileFormat;            /* added in version 2 */
} MM_MEDIA_VIDEO, *PMM_MEDIA_VIDEO;
typedef const MM_MEDIA_VIDEO* CPMM_MEDIA_VIDEO;

#define MM_MEDIA_VIDEO_VER(v) (sizeof(MM_MEDIA_VIDEO) << 16 | (0xFFFF & (v)))
#define MM_MEDIA_VIDEO_VERSION_0 MM_MEDIA_VIDEO_VER(0)
#define MM_MEDIA_VIDEO_VERSION_1 MM_MEDIA_VIDEO_VER(1)
#define MM_MEDIA_VIDEO_VERSION_2 MM_MEDIA_VIDEO_VER(2)
#define MM_MEDIA_VIDEO_VERSION_3 MM_MEDIA_VIDEO_VER(3)
#define MM_MEDIA_VIDEO_VERSION_4 MM_MEDIA_VIDEO_VER(4)
#define MM_MEDIA_VIDEO_VERSION   MM_MEDIA_VIDEO_VER(4)


static __inline void INIT_MM_MEDIA_VIDEO(PMM_MEDIA_VIDEO pStruct) {
    pStruct->unVersion              = MM_MEDIA_VIDEO_VERSION;
    INIT_MM_VIDEO_CODEC(&pStruct->codec);
    pStruct->unMode                 = 0;
    pStruct->szFileName             = (char*)0;
    pStruct->unAccessMode           = MM_MEDIA_ACCESS_MODE_FILE;
    pStruct->unOffset               = 0;
    pStruct->eFileFormat            = EMM_FILE_FORMAT_PROPRIETARY;
}

/*
 * Voice Sampling rate
 */
#define MM_DRT_6KHZ           0x30  /* 6KHz (RFU) */
#define MM_DRT_8KHZ           0x40  /* 8KHz */
#define MM_DRT_11KHZ          0x58  /* 11KHz (RFU) */
#define MM_DRT_16KHZ          0x80  /* 16KHz */

/*
 * Voice Data format
 */
#define MM_DATA_FORMAT_DIALOGIC_ADPCM                  0x1   /* OKI ADPCM (RFU) */
#define MM_DATA_FORMAT_ALAW                            0x3   /* alaw PCM (RFU) */
#define MM_DATA_FORMAT_G726                            0x4   /* G.726 (RFU) */
#define MM_DATA_FORMAT_MULAW                           0x7   /* mulaw PCM (RFU) */
#define MM_DATA_FORMAT_PCM                             0x8   /* PCM */
#define MM_DATA_FORMAT_G729A                           0x0C  /* CELP Coder (RFU) */
#define MM_DATA_FORMAT_GSM610                          0x0D  /* Microsoft GSM (RFU) */
#define MM_DATA_FORMAT_GSM610_MICROSOFT                0x0D  /* Microsoft GSM (RFU) */
#define MM_DATA_FORMAT_GSM610_ETSI                     0x0E  /* ETSI Standard Framing (RFU) */
#define MM_DATA_FORMAT_GSM610_TIPHON                   0x0F  /* ETSI TIPHON Bit Order (RFU) */
#define MM_DATA_FORMAT_TRUESPEECH                      0x10  /* TRUESPEECH Coder (RFU) */
#define MM_DATA_FORMAT_RFU1                            MM_DATA_FORMAT_TRUESPEECH /* Reserved 1 (RFU) */
#define MM_DATA_FORMAT_G711_ALAW                       MM_DATA_FORMAT_ALAW /* (RFU) */
#define MM_DATA_FORMAT_G711_ALAW_8BIT_REV              0x11  /* (RFU) */
#define MM_DATA_FORMAT_G711_ALAW_16BIT_REV             0x12  /* (RFU) */
#define MM_DATA_FORMAT_G711_MULAW                      MM_DATA_FORMAT_MULAW  /* (RFU) */
#define MM_DATA_FORMAT_G711_MULAW_8BIT_REV             0x13  /* (RFU) */
#define MM_DATA_FORMAT_G711_MULAW_16BIT_REV            0x14  /* (RFU) */
#define MM_DATA_FORMAT_G721                            0x15  /* (RFU) */
#define MM_DATA_FORMAT_G721_8BIT_REV                   0x16  /* (RFU) */
#define MM_DATA_FORMAT_G721_16BIT_REV                  0x17  /* (RFU) */
#define MM_DATA_FORMAT_G721_16BIT_REV_NIBBLE_SWAP      0x18  /* (RFU) */
#define MM_DATA_FORMAT_IMA_ADPCM                       0x19  /* (RFU) */
#define MM_DATA_FORMAT_AMR_NB_4_75K                    0x1A
#define MM_DATA_FORMAT_AMR_NB_5_15K                    0x1B
#define MM_DATA_FORMAT_AMR_NB_5_90K                    0x1C
#define MM_DATA_FORMAT_AMR_NB_6_70K                    0x1D
#define MM_DATA_FORMAT_AMR_NB_7_40K                    0x1E
#define MM_DATA_FORMAT_AMR_NB_7_95K                    0x1F
#define MM_DATA_FORMAT_AMR_NB_10_20K                   0x20
#define MM_DATA_FORMAT_AMR_NB_12_20K                   0x21
#define MM_DATA_FORMAT_G723_1_5_30K                    0x22
#define MM_DATA_FORMAT_G723_1_6_30K                    0x23
#define MM_DATA_FORMAT_EVRC                            0x24  /* EVRC  */
#define MM_DATA_FORMAT_QCELP_RATE_8                    0x25  /* QCELP 8kbps */
#define MM_DATA_FORMAT_QCELP_RATE_13                   0x26  /* QCELP 13kbps */
#define MM_DATA_FORMAT_GSM_EFR                         0x27  /* GSM EFR */
#define MM_DATA_FORMAT_G722_48K                        0x28
#define MM_DATA_FORMAT_G722_56K                        0x29
#define MM_DATA_FORMAT_G722_64K                        0x2A
#define MM_DATA_FORMAT_AMR_WB_6_6K                     0x2B
#define MM_DATA_FORMAT_AMR_WB_8_85K                    0x2C
#define MM_DATA_FORMAT_AMR_WB_12_65K                   0x2D
#define MM_DATA_FORMAT_AMR_WB_14_25K                   0x2E
#define MM_DATA_FORMAT_AMR_WB_15_85K                   0x2F
#define MM_DATA_FORMAT_AMR_WB_18_25K                   0x30
#define MM_DATA_FORMAT_AMR_WB_19_85K                   0x31
#define MM_DATA_FORMAT_AMR_WB_23_05K                   0x32
#define MM_DATA_FORMAT_AMR_WB_23_85K                   0x33
#define MM_DATA_FORMAT_FFT                             0xFF  /* fft data (RFU) */

/*
 * Masked DTMF termination/initiation equates
 */
#define  MM_DM_D        0x0001    /* Mask for DTMF d. */
#define  MM_DM_1        0x0002    /* Mask for DTMF 1. */
#define  MM_DM_2        0x0004    /* Mask for DTMF 2. */
#define  MM_DM_3        0x0008    /* Mask for DTMF 3. */
#define  MM_DM_4        0x0010    /* Mask for DTMF 4. */
#define  MM_DM_5        0x0020    /* Mask for DTMF 5. */
#define  MM_DM_6        0x0040    /* Mask for DTMF 6. */
#define  MM_DM_7        0x0080    /* Mask for DTMF 7. */
#define  MM_DM_8        0x0100    /* Mask for DTMF 8. */
#define  MM_DM_9        0x0200    /* Mask for DTMF 9. */
#define  MM_DM_0        0x0400    /* Mask for DTMF 0. */
#define  MM_DM_S        0x0800    /* Mask for DTMF *. */
#define  MM_DM_P        0x1000    /* Mask for DTMF #. */
#define  MM_DM_A        0x2000    /* Mask for DTMF a. */
#define  MM_DM_B        0x4000    /* Mask for DTMF b. */
#define  MM_DM_C        0x8000    /* Mask for DTMF c. */

typedef enum
{
	EMM_AUDIO_CODEC_OPTION_UNDEFINED         = 0x0,
	EMM_AUDIO_CODEC_OPTION_INTERLEAVE_LENGTH = 0x1,
	EMM_AUDIO_CODEC_OPTION_CDMA_RATE_REDUC   = 0x2,
	EMM_AUDIO_CODEC_OPTION_PAYLOAD_FORMAT    = 0x3   /* choose values from eMM_AUDIO_PAYLOAD_FORMAT */

} eMM_AUDIO_CODEC_OPTION;

typedef enum
{
	EMM_AUDIO_PAYLOAD_FORMAT_OCTET_ALIGNED        = 0x4,
	EMM_AUDIO_PAYLOAD_FORMAT_BANDWIDTH_EFFICIENT  = 0x8

} eMM_AUDIO_PAYLOAD_FORMAT;

typedef struct tagMM_AUDIO_CODEC_OPTION_LIST
{
	unsigned int            unVersion;
	eMM_ITEM                ItemChain;
	eMM_AUDIO_CODEC_OPTION  eParm;
	int                     nValue;
	struct tagMM_AUDIO_CODEC_OPTION_LIST* next;
	struct tagMM_AUDIO_CODEC_OPTION_LIST* prev;  /* optional */
}MM_AUDIO_CODEC_OPTION_LIST, *PMM_AUDIO_CODEC_OPTION_LIST;
typedef const MM_AUDIO_CODEC_OPTION_LIST* CPMM_AUDIO_CODEC_OPTION_LIST;

#define MM_AUDIO_CODEC_OPTION_LIST_VER(v) \
	sizeof(MM_AUDIO_CODEC_OPTION_LIST) << 16 | (0xFFFF & v)

#define MM_AUDIO_CODEC_OPTION_LIST_VERSION  MM_AUDIO_CODEC_OPTION_LIST_VER(0)

static __inline void INIT_MM_AUDIO_CODEC_OPTION_LIST(PMM_AUDIO_CODEC_OPTION_LIST pStruct) {
	pStruct->unVersion      = MM_AUDIO_CODEC_OPTION_LIST_VERSION;
	pStruct->ItemChain      = EMM_ITEM_EOT;
	pStruct->eParm          = EMM_AUDIO_CODEC_OPTION_UNDEFINED;
	pStruct->nValue         = 0;
	pStruct->next           = (PMM_AUDIO_CODEC_OPTION_LIST)0;
	pStruct->prev           = (PMM_AUDIO_CODEC_OPTION_LIST)0;
}

typedef struct tagMM_AUDIO_CODEC
{
	unsigned int unVersion;
	unsigned int unCoding;                      /* see DX_XPB wDataFormat */
	unsigned int unSampleRate;                  /* see DX_XPB nSamplesPerSec */
	unsigned int unBitsPerSample;               /* see DX_XPB wBitsPerSample */
	CPMM_AUDIO_CODEC_OPTION_LIST options;       /* added in version 1 */
} MM_AUDIO_CODEC, *PMM_AUDIO_CODEC;
typedef const MM_AUDIO_CODEC* CPMM_AUDIO_CODEC;

#define MM_AUDIO_CODEC_VER(v) (sizeof(MM_AUDIO_CODEC) << 16 | (0xFFFF & (v)))
#define MM_AUDIO_CODEC_VERSION_0 MM_AUDIO_CODEC_VER(0)
#define MM_AUDIO_CODEC_VERSION  MM_AUDIO_CODEC_VER(1)

static __inline void INIT_MM_AUDIO_CODEC(PMM_AUDIO_CODEC pStruct) {
    pStruct->unVersion              = MM_AUDIO_CODEC_VERSION;
    pStruct->unCoding               = MM_DATA_FORMAT_PCM;
    pStruct->unSampleRate           = MM_DRT_8KHZ;
    pStruct->unBitsPerSample        = 16;
    pStruct->options                = (CPMM_AUDIO_CODEC_OPTION_LIST)0;
}

/*
 * unMode audio definitions
 */
#define MM_MODE_AUD_PAUSED              MM_MODE_PAUSED
#define MM_MODE_AUD_BEEPINITIATED       MM_MODE_BEEPINITIATED
#define MM_MODE_AUD_FILE_TYPE_VOX       MM_MODE_FILE_TYPE_VOX
#define MM_MODE_AUD_AGC_ON              MM_MODE_AGC_ON
#define MM_MODE_AUD_OFFSET_IN_BYTES     MM_MODE_OFFSET_IN_BYTES

typedef struct tagMM_MEDIA_AUDIO
{
	unsigned int    unVersion;
	MM_AUDIO_CODEC  codec;                  /* modified in version 3 */
	unsigned int    unMode;
	unsigned int    unOffset;
	union {
		const char*            szFileName;
		MM_MEDIA_ACCESS_STREAM stream;      /* added in version 1 */
		MM_MEDIA_ACCESS_MEMORY memory;      /* added in version 1 */
	};
	unsigned int    unAccessMode;           /* added in version 1 */
	eMM_FILE_FORMAT eFileFormat;            /* added in version 2 */
} MM_MEDIA_AUDIO, *PMM_MEDIA_AUDIO;
typedef const MM_MEDIA_AUDIO* CPMM_MEDIA_AUDIO;

#define MM_MEDIA_AUDIO_VER(v) (sizeof(MM_MEDIA_AUDIO) << 16 | (0xFFFF & (v)))
#define MM_MEDIA_AUDIO_VERSION_0 MM_MEDIA_AUDIO_VER(0)
#define MM_MEDIA_AUDIO_VERSION_1 MM_MEDIA_AUDIO_VER(1)
#define MM_MEDIA_AUDIO_VERSION_2 MM_MEDIA_AUDIO_VER(2)
#define MM_MEDIA_AUDIO_VERSION MM_MEDIA_AUDIO_VER(3)

#define MM_MEDIA_AUDIO_VERSION_3 MM_MEDIA_AUDIO_VER(3)

static __inline void INIT_MM_MEDIA_AUDIO(PMM_MEDIA_AUDIO pStruct) {
    pStruct->unVersion              = MM_MEDIA_AUDIO_VERSION;
    INIT_MM_AUDIO_CODEC(&pStruct->codec);
    pStruct->unMode                 = 0;
    pStruct->unOffset               = 0;
    pStruct->szFileName             = (char*)0;
    pStruct->unAccessMode           = MM_MEDIA_ACCESS_MODE_FILE;
    pStruct->eFileFormat            = EMM_AUD_FILEFORMAT_PROPRIETARY;
}

/*
 * Image definitions
 */
typedef struct tagMM_YUV
{
	unsigned int            unVersion;
	eMTK_YUV_IMAGE_FORMAT   eFormat;
	unsigned int            unWidth;
	unsigned int            unHeight;
} MM_YUV, *PMM_YUV;

#define MM_YUV_VER(v) (sizeof(MM_YUV) << 16 | (0xFFFF & (v)))
#define MM_YUV_VERSION MM_YUV_VER(0)

static __inline void INIT_MM_YUV(PMM_YUV pStruct) {
    pStruct->unVersion      = MM_YUV_VERSION;
    pStruct->eFormat        = eMTK_YUV_IMAGE_FORMAT_420;
    pStruct->unWidth        = 0;
    pStruct->unHeight       = 0;
}

typedef union tagMM_IMAGE_FORMAT
{
	MM_YUV    yuv;

}MM_IMAGE_FORMAT, *PMM_IMAGE_FORMAT;

typedef struct tagMM_MEDIA_IMAGE
{
	unsigned int         unVersion;
	eMTK_IMAGE_FORMAT    eFormat;
	MM_IMAGE_FORMAT      format;
	unsigned int         unAccessMode;
	union
	{
		const char*    szFileName;
		MM_MEDIA_ACCESS_STREAM    stream;
		MM_MEDIA_ACCESS_MEMORY    memory;
	};
} MM_MEDIA_IMAGE, *PMM_MEDIA_IMAGE;
typedef const MM_MEDIA_IMAGE* CPMM_MEDIA_IMAGE;

#define MM_MEDIA_IMAGE_VER(v) (sizeof(MM_MEDIA_IMAGE) << 16 | (0xFFFF & (v)))
#define MM_MEDIA_IMAGE_VERSION MM_MEDIA_IMAGE_VER(0)

static __inline void INIT_MM_MEDIA_IMAGE(PMM_MEDIA_IMAGE pStruct) {
    pStruct->unVersion              = MM_MEDIA_IMAGE_VERSION;
	INIT_MM_YUV(&pStruct->format.yuv);
    pStruct->eFormat                = eMTK_IMAGE_FORMAT_YUV;
    pStruct->szFileName             = (char*)0;
    pStruct->unAccessMode           = MM_MEDIA_ACCESS_MODE_FILE;
}
typedef MM_RET_CODE MM_CAPTURE_ACK, *PMM_CAPTURE_ACK;
typedef const MM_RET_CODE* CPMM_CAPTURE_ACK;

#define MM_CAPTURE_ACK_VER(v) (sizeof(MM_CAPTURE_ACK) << 16 | (0xFFFF & (v)))
#define MM_CAPTURE_ACK_VERSION_0 MM_CAPTURE_ACK_VER(0)
#define MM_CAPTURE_ACK_VERSION MM_CAPTURE_ACK_VERSION_0;

typedef struct tagMM_MEDIA_TERM
{
	unsigned int   unVersion;
	unsigned int   unRfu;
} MM_MEDIA_TERM, *PMM_MEDIA_TERM;
typedef const MM_MEDIA_TERM* CPMM_MEDIA_TERM;

#define MM_MEDIA_TERM_VER(v) (sizeof(MM_MEDIA_TERM) << 16 | (0xFFFF & (v)))
#define MM_MEDIA_TERM_VERSION_0 MM_MEDIA_TERM_VER(0)
#define MM_MEDIA_TERM_VERSION MM_MEDIA_TERM_VERSION_0

static __inline void INIT_MM_MEDIA_TERM(PMM_MEDIA_TERM pStruct) {
    pStruct->unVersion              = MM_MEDIA_TERM_VERSION;
    pStruct->unRfu                  = 0;
}

typedef union tagMM_MEDIA_ITEM
{
	MM_MEDIA_VIDEO    video;
	MM_MEDIA_AUDIO    audio;
	MM_MEDIA_TERM     term;
	MM_MEDIA_IMAGE    image;
} MM_MEDIA_ITEM, *PMM_MEDIA_ITEM;
typedef const MM_MEDIA_ITEM* CPMM_MEDIA_ITEM;

static __inline void INIT_MM_MEDIA_ITEM(PMM_MEDIA_ITEM pStruct) {
}

/* List of media items */
typedef struct tagMM_MEDIA_ITEM_LIST
{
	unsigned int unVersion;
	eMM_ITEM ItemChain;
	MM_MEDIA_ITEM item;                 /* sub-structures (MM_MEDIA_AUDIO, MM_MEDIA_VIDEO) modified in versions 1,2,3 */
	struct tagMM_MEDIA_ITEM_LIST* next;
	struct tagMM_MEDIA_ITEM_LIST* prev;	/* optional */
} MM_MEDIA_ITEM_LIST, *PMM_MEDIA_ITEM_LIST;
typedef const MM_MEDIA_ITEM_LIST* CPMM_MEDIA_ITEM_LIST;

#define MM_MEDIA_ITEM_LIST_VER(v) (sizeof(MM_MEDIA_ITEM_LIST) << 16 | (0xFFFF & (v)))
#define MM_MEDIA_ITEM_LIST_VERSION_0 MM_MEDIA_ITEM_LIST_VER(0)
#define MM_MEDIA_ITEM_LIST_VERSION_1 MM_MEDIA_ITEM_LIST_VER(1)
#define MM_MEDIA_ITEM_LIST_VERSION_2 MM_MEDIA_ITEM_LIST_VER(2)
#define MM_MEDIA_ITEM_LIST_VERSION_3 MM_MEDIA_ITEM_LIST_VER(3)
#define MM_MEDIA_ITEM_LIST_VERSION_4 MM_MEDIA_ITEM_LIST_VER(4)
#define MM_MEDIA_ITEM_LIST_VERSION   MM_MEDIA_ITEM_LIST_VER(4);

static __inline void INIT_MM_MEDIA_ITEM_LIST(PMM_MEDIA_ITEM_LIST pStruct) {
    pStruct->unVersion              = MM_MEDIA_ITEM_LIST_VERSION;
    pStruct->ItemChain              = EMM_ITEM_EOT;
    INIT_MM_MEDIA_ITEM(&pStruct->item);
    pStruct->next                   = (PMM_MEDIA_ITEM_LIST)0;
    pStruct->prev                   = (PMM_MEDIA_ITEM_LIST)0;
}

typedef struct tagMM_PLAY_RECORD_LIST
{
	unsigned int unVersion;
	eMM_ITEM ItemChain;
	eMM_MEDIA_TYPE ItemType;
	CPMM_MEDIA_ITEM_LIST list;              /* sub-structures (MM_MEDIA_AUDIO, MM_MEDIA_VIDEO) modified in versions 1,2,3 */
	unsigned int unRFU;
	struct tagMM_PLAY_RECORD_LIST* next;
	struct tagMM_PLAY_RECORD_LIST* prev;	/* optional */
} MM_PLAY_RECORD_LIST, *PMM_PLAY_RECORD_LIST;
typedef const MM_PLAY_RECORD_LIST* CPMM_PLAY_RECORD_LIST;

#define MM_PLAY_RECORD_LIST_VER(v) (sizeof(MM_PLAY_RECORD_LIST) << 16 | (0xFFFF & (v)))
#define MM_PLAY_RECORD_LIST_VERSION_0 MM_PLAY_RECORD_LIST_VER(0)
#define MM_PLAY_RECORD_LIST_VERSION_1 MM_PLAY_RECORD_LIST_VER(1)
#define MM_PLAY_RECORD_LIST_VERSION_2 MM_PLAY_RECORD_LIST_VER(2)
#define MM_PLAY_RECORD_LIST_VERSION MM_PLAY_RECORD_LIST_VER(3);

static __inline void INIT_MM_PLAY_RECORD_LIST(PMM_PLAY_RECORD_LIST pStruct) {
    pStruct->unVersion              = MM_PLAY_RECORD_LIST_VERSION;
    pStruct->ItemChain              = EMM_ITEM_EOT;
    pStruct->ItemType               = EMM_MEDIA_TYPE_UNDEFINED;
    pStruct->list                   = (CPMM_MEDIA_ITEM_LIST)0;
    pStruct->unRFU                  = 0;
    pStruct->next                   = (PMM_PLAY_RECORD_LIST)0;
    pStruct->prev                   = (PMM_PLAY_RECORD_LIST)0;
}


typedef struct tagMM_PLAY_RECORD_INFO
{
	unsigned int unVersion;
	eMM_FILE_FORMAT eFileFormat;
	CPMM_PLAY_RECORD_LIST list;         /* sub-structures (MM_MEDIA_AUDIO, MM_MEDIA_VIDEO) modified in versions 1,2,3 */
} MM_PLAY_RECORD_INFO, *PMM_PLAY_RECORD_INFO;
typedef const MM_PLAY_RECORD_INFO* CPMM_PLAY_RECORD_INFO;

#define MM_PLAY_RECORD_INFO_VER(v) (sizeof(MM_PLAY_RECORD_INFO) << 16 | (0xFFFF & (v)))
#define MM_PLAY_RECORD_INFO_VERSION_0 MM_PLAY_RECORD_INFO_VER(0)
#define MM_PLAY_RECORD_INFO_VERSION_1 MM_PLAY_RECORD_INFO_VER(1)
#define MM_PLAY_RECORD_INFO_VERSION_2 MM_PLAY_RECORD_INFO_VER(2)
#define MM_PLAY_RECORD_INFO_VERSION MM_PLAY_RECORD_INFO_VER(3);

static __inline void INIT_MM_PLAY_RECORD_INFO(PMM_PLAY_RECORD_INFO pStruct) {
    pStruct->unVersion              = MM_PLAY_RECORD_INFO_VERSION;
    pStruct->eFileFormat            = EMM_FILE_FORMAT_PROPRIETARY;
    pStruct->list                   = (CPMM_PLAY_RECORD_LIST)0;
}

typedef MM_PLAY_RECORD_INFO MM_PLAY_INFO, *PMM_PLAY_INFO;
typedef CPMM_PLAY_RECORD_INFO CPMM_PLAY_INFO;

#define MM_PLAY_INFO_VER(v) MM_PLAY_RECORD_INFO_VER(v)
#define MM_PLAY_INFO_VERSION_0 MM_PLAY_RECORD_INFO_VERSION_0
#define MM_PLAY_INFO_VERSION_1 MM_PLAY_RECORD_INFO_VERSION_1
#define MM_PLAY_INFO_VERSION_2 MM_PLAY_RECORD_INFO_VERSION_2
#define MM_PLAY_INFO_VERSION MM_PLAY_INFO_VER(3);

static __inline void INIT_MM_PLAY_INFO(PMM_PLAY_INFO pStruct) {
    INIT_MM_PLAY_RECORD_INFO(pStruct);
}

typedef MM_PLAY_RECORD_INFO MM_RECORD_INFO, *PMM_RECORD_INFO;
typedef CPMM_PLAY_RECORD_INFO CPMM_RECORD_INFO;

#define MM_RECORD_INFO_VER(v) MM_PLAY_RECORD_INFO_VER(v)
#define MM_RECORD_INFO_VERSION_0 MM_PLAY_RECORD_INFO_VERSION_0
#define MM_RECORD_INFO_VERSION_1 MM_PLAY_RECORD_INFO_VERSION_1
#define MM_RECORD_INFO_VERSION_2 MM_PLAY_RECORD_INFO_VERSION_2
#define MM_RECORD_INFO_VERSION MM_RECORD_INFO_VER(3);

static __inline void INIT_MM_RECORD_INFO(PMM_RECORD_INFO pStruct) {
    INIT_MM_PLAY_RECORD_INFO(pStruct);
}

typedef enum tagEMM_TERMINATION_REASON
{
	EMM_TERM_NORTC = 0,
	EMM_TERM_DIGMASK = 1,
	EMM_TERM_DIGTYPE = 2,
	EMM_TERM_MAXDTMF = 3,
	EMM_TERM_MAXTIME = 4,
	EMM_TERM_TIME_FROM_AUDIO_RECORD_STARTED = 5,
	EMM_TERM_UNDEFINED = 0xff
} eMM_TERMINATION_REASON;

typedef enum tagEMM_TERMINATION_ACTION
{
	EMM_TA_AUDIO_STOP,
	EMM_TA_VIDEO_STOP,
	EMM_TA_AUDIO_VIDEO_STOP,
	EMM_TA_UNDEFINED = 0xff
} eMM_TERMINATION_ACTION;

typedef struct tagMM_RUNTIME_CONTROL
{
	unsigned int unVersion;
	eMM_TERMINATION_REASON Reason;
	unsigned int unValue;
	eMM_TERMINATION_ACTION Action;
	struct tagMM_RUNTIME_CONTROL *next;
} MM_RUNTIME_CONTROL, *PMM_RUNTIME_CONTROL;
typedef const MM_RUNTIME_CONTROL* CPMM_RUNTIME_CONTROL;

#define MM_RUNTIME_CONTROL_VER(v) (sizeof(MM_RUNTIME_CONTROL) << 16 | (0xFFFF & (v)))
#define MM_RUNTIME_CONTROL_VERSION_0 MM_RUNTIME_CONTROL_VER(0)
#define MM_RUNTIME_CONTROL_VERSION_1 MM_RUNTIME_CONTROL_VER(1)
#define MM_RUNTIME_CONTROL_VERSION MM_RUNTIME_CONTROL_VERSION_1;

static __inline void INIT_MM_RUNTIME_CONTROL(PMM_RUNTIME_CONTROL pStruct) {
    pStruct->unVersion              = MM_RUNTIME_CONTROL_VERSION;
    pStruct->Reason                 = EMM_TERM_NORTC;
    pStruct->unValue                = 0;
    pStruct->Action                 = EMM_TA_UNDEFINED;
    pStruct->next                   = (PMM_RUNTIME_CONTROL)0;
}

typedef MM_RET_CODE MM_PLAY_ACK, *PMM_PLAY_ACK;
typedef const MM_RET_CODE* CPMM_PLAY_ACK;

#define MM_PLAY_ACK_VER(v) (sizeof(MM_PLAY_ACK) << 16 | (0xFFFF & (v)))
#define MM_PLAY_ACK_VERSION_0 MM_PLAY_ACK_VER(0)
#define MM_PLAY_ACK_VERSION MM_PLAY_ACK_VERSION_0;

static __inline void INIT_MM_PLAY_ACK(PMM_PLAY_ACK pStruct) {
    INIT_MM_RET_CODE(pStruct);
}

typedef MM_RET_CODE MM_RECORD_ACK, *PMM_RECORD_ACK;
typedef const MM_RET_CODE* CPMM_RECORD_ACK;

#define MM_RECORD_ACK_VER(v) (sizeof(MM_RECORD_ACK) << 16 | (0xFFFF & (v)))
#define MM_RECORD_ACK_VERSION_0 MM_RECORD_ACK_VER(0)
#define MM_RECORD_ACK_VERSION MM_RECORD_ACK_VERSION_0;

static __inline void INIT_MM_RECORD_ACK(PMM_RECORD_ACK pStruct) {
    INIT_MM_RET_CODE(pStruct);
}

/*
 * MM_VIDEO_RECORD_STARTED::unStatus
 */
#define EMM_VIDEO_RCRD_IFRAME_DETECTED 0x1
#define EMM_VIDEO_RCRD_IFRAME_TIMEOUT 0x2

typedef struct tagMM_VIDEO_RECORD_STARTED
{
	unsigned int unVersion;
	unsigned int unStatus;
} MM_VIDEO_RECORD_STARTED, *PMM_VIDEO_RECORD_STARTED;
typedef const PMM_VIDEO_RECORD_STARTED* CPMM_VIDEO_RECORD_STARTED;

#define MM_VIDEO_RECORD_STARTED_VER(v) (sizeof(MM_VIDEO_RECORD_STARTED) << 16 | (0xFFFF & (v)))
#define MM_VIDEO_RECORD_STARTED_VERSION_0 MM_VIDEO_RECORD_STARTED_VER(0)
#define MM_VIDEO_RECORD_STARTED_VERSION MM_VIDEO_RECORD_STARTED_VERSION_0;

static __inline void INIT_MM_VIDEO_RECORD_STARTED(PMM_VIDEO_RECORD_STARTED pStruct) {
    pStruct->unVersion              = MM_VIDEO_RECORD_STARTED_VERSION;
    pStruct->unStatus               = 0;
}

#pragma pack(push, 1)
typedef struct tagMM_RECORD_CMPLT_INFO_DATA_BLOCKS
{
   unsigned int unNumDataBlocks;  /* number of "data blocks" that follow this structure */
   unsigned int unNumBytes;       /* size of all "data blocks" in bytes */
} MM_RECORD_CMPLT_INFO_DATA_BLOCKS, *PMM_RECORD_CMPLT_INFO_DATA_BLOCKS;

typedef const MM_RECORD_CMPLT_INFO_DATA_BLOCKS* CPMM_RECORD_CMPLT_INFO_DATA_BLOCKS;

typedef struct tagMM_RECORD_CMPLT_DATA_BLOCK
{
   /* data block header */
   unsigned int unOffset;  /* stream byte offset where the following "data" must be written */
   unsigned int unSize;    /* size of the following "data" in bytes */

   /* start of data to be written to recorded stream */
   unsigned char data[1];  /* first byte of data, remaining data in this block follows this structure */
} MM_RECORD_CMPLT_DATA_BLOCK, *PMM_RECORD_CMPLT_DATA_BLOCK;
#pragma pack(pop)

typedef const MM_RECORD_CMPLT_DATA_BLOCK* CPMM_RECORD_CMPLT_DATA_BLOCK;

/* Macros to help parse MM_RECORD_CMPLT.  The caller supplies the "_userPtr" (unsigned char *) that
   is used to track the current location in the structure. */

#define MM_RECORD_CMPLT_INIT(_MMPlayRecCmplt, _userPtr) \
   _userPtr  = (unsigned char *)_MMPlayRecCmplt->details + \
                                (_MMPlayRecCmplt->unCount * sizeof(MM_PLAY_RECORD_CMPLT_DETAILS));

#define MM_RECORD_CMPLT_INFO_DATA_BLOCKS_GET(_dbInfo, _userPtr) \
   _dbInfo  = (MM_RECORD_CMPLT_INFO_DATA_BLOCKS *) _userPtr; \
   _userPtr = _userPtr + sizeof(MM_RECORD_CMPLT_INFO_DATA_BLOCKS);

#define MM_RECORD_CMPLT_DATA_BLOCK_GET(_dataBlock, _userPtr) \
   _dataBlock = (MM_RECORD_CMPLT_DATA_BLOCK *) _userPtr; \
   _userPtr   = _userPtr + sizeof(MM_RECORD_CMPLT_DATA_BLOCK) + _dataBlock->unSize - sizeof(_dataBlock->data[0]);

typedef enum tagEMM_CMPLT_PLAY_RECORD
{
	EMM_CMPLT_VIDEO_PLAY,
	EMM_CMPLT_VIDEO_RECORD,
	EMM_CMPLT_AUDIO_PLAY,
	EMM_CMPLT_AUDIO_RECORD,
	EMM_CMPLT_TONE,
	EMM_CMPLT_GET_DIGIT,
	EMM_CMPLT_IMAGE_PLAY,
	EMM_CMPLT_VIDEO_RECORD_WITH_UPDATE,
	EMM_CMPLT_AUDIO_RECORD_WITH_UPDATE,
	EMM_CMPLT_UNDEFINED = 0xff
} eMM_CMPLT_PLAY_RECORD;

typedef enum tagEMM_CMPLT_PLAY_RECORD_REASON
{
	EMM_TR_MAX_DTMF_DIGIT,
	EMM_TR_CONT_SILON,
	EMM_TR_CONT_SILOFF,
	EMM_TR_ID_DELAY,
	EMM_TR_EOF,
	EMM_TR_DIGIT,
	EMM_TR_PATTERN_SILON_SILOFF,
	EMM_TR_USERSTOP,
	EMM_TR_TONEID,
	EMM_TR_ERROR,
	EMM_TR_DIGMASK,
	EMM_TR_DIGTYPE,
	EMM_TR_MAXTIME,
	EMM_TR_TIME_FROM_AUDIO_RECORD_STARTED,
	EMM_TR_UNDEFINED = 0xff
} eMM_CMPLT_PLAY_RECORD_REASON;

typedef enum tagEMM_CMPLT_PLAY_RECORD_STATUS
{
	EMM_STATUS_SUCCESS,
	EMM_STATUS_RCRD_V_DRPD_FRAME_FULL_ERROR,
	EMM_STATUS_RCRD_V_PKTS_DROPD_FS_GT_MFS,
	EMM_STATUS_RCRD_A_DRPD_FRAME_FULL_ERROR,
	EMM_STATUS_PLAY_V_ERROR_FS_GT_MFS,
	EMM_STATUS_PLAY_A_FILEREAD_ERROR,
	EMM_STATUS_PLAY_V_FILEREAD_ERROR,
	EMM_STATUS_PLAY_I_FILEREAD_ERROR,
	EMM_STATUS_PLAY_I_NULLDATA_ERROR,
	EMM_STATUS_RCRD_V_CODEC_MISMATCH_ERROR,
	EMM_STATUS_RCRD_V_MISSING_MPEG4_VISUALCONFIG_ERROR,
	EMM_STATUS_PLAY_BAD_PACKET,
	EMM_STATUS_RCRD_CODING_ERROR,
	EMM_STATUS_PLAY_CODING_ERROR,
	EMM_STATUS_RCRD_HEADER_WRITE_ERROR,
	EMM_STATUS_UNDEFINED = 0xff
} eMM_CMPLT_PLAY_RECORD_STATUS;

typedef struct tagMM_PLAY_RECORD_CMPLT_DETAILS
{
	unsigned int unVersion;
	eMM_CMPLT_PLAY_RECORD Complete;
	eMM_CMPLT_PLAY_RECORD_REASON Reason;
	unsigned int unDuration;
	unsigned int unNumberOfBytes;
	eMM_CMPLT_PLAY_RECORD_STATUS Status;
} MM_PLAY_RECORD_CMPLT_DETAILS, *PMM_PLAY_RECORD_CMPLT_DETAILS;
typedef const MM_PLAY_RECORD_CMPLT_DETAILS* CPMM_PLAY_RECORD_CMPLT_DETAILS;

#define MM_PLAY_RECORD_CMPLT_DETAILS_VER(v) (sizeof(MM_PLAY_RECORD_CMPLT_DETAILS) << 16 | (0xFFFF & (v)))
#define MM_PLAY_RECORD_CMPLT_DETAILS_VERSION_0 MM_PLAY_RECORD_CMPLT_DETAILS_VER(0)
#define MM_PLAY_RECORD_CMPLT_DETAILS_VERSION MM_PLAY_RECORD_CMPLT_DETAILS_VERSION_0;

static __inline void INIT_MM_PLAY_RECORD_CMPLT_DETAILS(PMM_PLAY_RECORD_CMPLT_DETAILS pStruct) {
    pStruct->unVersion              = MM_PLAY_RECORD_CMPLT_DETAILS_VERSION;
    pStruct->Complete               = EMM_CMPLT_UNDEFINED;
    pStruct->Reason                 = EMM_TR_UNDEFINED;
    pStruct->unDuration             = 0;
    pStruct->unNumberOfBytes        = 0;
}

#define MAX_PLAY_RECORD_CMPLT 16
typedef struct tagMM_PLAY_RECORD_CMPLT
{
	unsigned int unVersion;
	unsigned int unCount;
	MM_PLAY_RECORD_CMPLT_DETAILS details[MAX_PLAY_RECORD_CMPLT];
} MM_PLAY_RECORD_CMPLT, *PMM_PLAY_RECORD_CMPLT;
typedef const MM_PLAY_RECORD_CMPLT* CPMM_PLAY_RECORD_CMPLT;

#define MM_PLAY_RECORD_CMPLT_VER(v) (sizeof(MM_PLAY_RECORD_CMPLT) << 16 | (0xFFFF & (v)))
#define MM_PLAY_RECORD_CMPLT_VERSION_0 MM_PLAY_RECORD_CMPLT_VER(0)
#define MM_PLAY_RECORD_CMPLT_VERSION MM_PLAY_RECORD_CMPLT_VERSION_0;

static __inline void INIT_MM_PLAY_RECORD_CMPLT(PMM_PLAY_RECORD_CMPLT pStruct) {
    pStruct->unVersion              = MM_PLAY_RECORD_CMPLT_VERSION;
    pStruct->unCount                = 0;
}

typedef MM_PLAY_RECORD_CMPLT MM_PLAY_CMPLT, *PMM_PLAY_CMPLT;
typedef CPMM_PLAY_RECORD_CMPLT CPMM_PLAY_CMPLT;
#define MM_PLAY_CMPLT_VER(v) (sizeof(MM_PLAY_CMPLT) << 16 | (0xFFFF & (v)))
#define MM_PLAY_CMPLT_VERSION_0 MM_PLAY_CMPLT_VER(0)
#define MM_PLAY_CMPLT_VERSION MM_PLAY_CMPLT_VERSION_0;

static __inline void INIT_MM_PLAY_CMPLT(PMM_PLAY_CMPLT pStruct) {
    INIT_MM_PLAY_RECORD_CMPLT(pStruct);
}

typedef MM_PLAY_RECORD_CMPLT MM_RECORD_CMPLT, *PMM_RECORD_CMPLT;
typedef CPMM_PLAY_RECORD_CMPLT CPMM_RECORD_CMPLT;
#define MM_RECORD_CMPLT_VER(v) (sizeof(MM_RECORD_CMPLT) << 16 | (0xFFFF & (v)))
#define MM_RECORD_CMPLT_VERSION_0 MM_RECORD_CMPLT_VER(0)
#define MM_RECORD_CMPLT_VERSION MM_RECORD_CMPLT_VERSION_0;

static __inline void INIT_MM_RECORD_CMPLT(PMM_RECORD_CMPLT pStruct) {
    INIT_MM_PLAY_RECORD_CMPLT(pStruct);
}

typedef struct tagMM_CAPTURE_CMPLT_DETAILS
{
	unsigned int unVersion;
	unsigned int unRetCode;
	unsigned int unNumberOfBytes;
	eMTK_IMAGE_FORMAT eFormat;
	eMTK_YUV_IMAGE_FORMAT eYuvFormat;
	unsigned int unWidth;
	unsigned int unHeight;
} MM_CAPTURE_CMPLT_DETAILS, *PMM_CAPTURE_CMPLT_DETAILS;
typedef const MM_CAPTURE_CMPLT_DETAILS* CPMM_CAPTURE_CMPLT_DETAILS;

#define MM_CAPTURE_CMPLT_DETAILS_VER(v) (sizeof(MM_CAPTURE_CMPLT_DETAILS) << 16 | (0xFFFF & (v)))
#define MM_CAPTURE_CMPLT_DETAILS_VERSION_0 MM_CAPTURE_CMPLT_DETAILS_VER(0)
#define MM_CAPTURE_CMPLT_DETAILS_VERSION MM_CAPTURE_CMPLT_DETAILS_VERSION_0;
/*******************************************************************************
*  mm_GetParm definitions
*******************************************************************************/
typedef struct tagMM_GET_PARM
{
	unsigned int unVersion;
	eMM_PARM eParm;
} MM_GET_PARM, *PMM_GET_PARM;
typedef const MM_GET_PARM* CPMM_GET_PARM;

#define MM_GET_PARM_VER(v) (sizeof(MM_GET_PARM) << 16 | (0xFFFF & (v)))
#define MM_GET_PARM_VERSION_0 MM_GET_PARM_VER(0)
#define MM_GET_PARM_VERSION MM_GET_PARM_VERSION_0;

static __inline void INIT_MM_GET_PARM(PMM_GET_PARM pStruct) {
    pStruct->unVersion              = MM_GET_PARM_VERSION;
    pStruct->eParm                  = EMM_PARM_UNDEFINED;
}

typedef struct tagMM_GET_PARM_RESULT
{
	unsigned int unVersion;
	eMM_PARM eParm;
	unsigned int unParmValue;
} MM_GET_PARM_RESULT, *PMM_GET_PARM_RESULT;
typedef const MM_GET_PARM_RESULT* CPMM_GET_PARM_RESULT;

#define MM_GET_PARM_RESULT_VER(v) (sizeof(MM_GET_PARM_RESULT) << 16 | (0xFFFF & (v)))
#define MM_GET_PARM_RESULT_VERSION_0 MM_GET_PARM_RESULT_VER(0)
#define MM_GET_PARM_RESULT_VERSION MM_GET_PARM_RESULT_VERSION_0;

static __inline void INIT_MM_GET_PARM_RESULT(PMM_GET_PARM_RESULT pStruct) {
    pStruct->unVersion              = MM_GET_PARM_RESULT_VERSION;
    pStruct->eParm                  = EMM_PARM_UNDEFINED;
    pStruct->unParmValue            = 0;
}

/*******************************************************************************
*  mm_SetParm definitions
*******************************************************************************/
typedef struct tagMM_SET_PARM
{
	unsigned int unVersion;
	eMM_PARM eParm;
	unsigned int unParmValue;
} MM_SET_PARM, *PMM_SET_PARM;
typedef const MM_SET_PARM* CPMM_SET_PARM;

#define MM_SET_PARM_VER(v) (sizeof(MM_SET_PARM) << 16 | (0xFFFF & (v)))
#define MM_SET_PARM_VERSION_0 MM_SET_PARM_VER(0)
#define MM_SET_PARM_VERSION MM_SET_PARM_VERSION_0;

static __inline void INIT_MM_SET_PARM(PMM_SET_PARM pStruct) {
    pStruct->unVersion              = MM_SET_PARM_VERSION;
    pStruct->eParm                  = EMM_PARM_UNDEFINED;
    pStruct->unParmValue            = 0;
}

typedef MM_RET_CODE MM_SET_PARM_RESULT, *PMM_SET_PARM_RESULT;
typedef const MM_RET_CODE* CPMM_SET_PARM_RESULT;

#define MM_SET_PARM_RESULT_VER(v) (sizeof(MM_SET_PARM_RESULT) << 16 | (0xFFFF & (v)))
#define MM_SET_PARM_RESULT_VERSION_0 MM_SET_PARM_RESULT_VER(0)
#define MM_SET_PARM_RESULT_VERSION MM_SET_PARM_RESULT_VERSION_0;

static __inline void INIT_MM_SET_PARM_RESULT(PMM_SET_PARM_RESULT pStruct) {
    INIT_MM_RET_CODE(pStruct);
}

/*******************************************************************************
*  mm_GetChanState definitions
*******************************************************************************/
typedef struct tagMM_GET_CHAN_STATE
{
	unsigned int unVersion;
	unsigned int unRFU;
} MM_GET_CHAN_STATE, *PMM_GET_CHAN_STATE;
typedef const MM_GET_CHAN_STATE* CPMM_GET_CHAN_STATE;

#define MM_GET_CHAN_STATE_VER(v) (sizeof(MM_GET_CHAN_STATE) << 16 | (0xFFFF & (v)))
#define MM_GET_CHAN_STATE_VERSION_0 MM_GET_CHAN_STATE_VER(0)
#define MM_GET_CHAN_STATE_VERSION MM_GET_CHAN_STATE_VERSION_0;

static __inline void INIT_MM_GET_CHAN_STATE(PMM_GET_CHAN_STATE pStruct) {
    pStruct->unVersion              = MM_GET_CHAN_STATE_VERSION;
    pStruct->unRFU                  = 0;
}

typedef enum tagEMM_CHAN_STATE
{
	EMM_STATE_IDLE,
	/* todo: define */
	EMM_STATE_UNDEFINED = 0xff
} eMM_CHAN_STATE;

typedef struct tagMM_CHAN_STATE
{
	unsigned int unVersion;
	eMM_CHAN_STATE ChanState;
} MM_CHAN_STATE, *PMM_CHAN_STATE;
typedef const MM_CHAN_STATE* CPMM_CHAN_STATE;

#define MM_CHAN_STATE_VER(v) (sizeof(MM_CHAN_STATE) << 16 | (0xFFFF & (v)))
#define MM_CHAN_STATE_VERSION_0 MM_CHAN_STATE_VER(0)
#define MM_CHAN_STATE_VERSION MM_CHAN_STATE_VERSION_0;

static __inline void INIT_MM_CHAN_STATE(PMM_CHAN_STATE pStruct) {
    pStruct->unVersion              = MM_CHAN_STATE_VERSION;
    pStruct->ChanState              = EMM_STATE_IDLE;
}

/*******************************************************************************
*  mm_Reset definitions
*******************************************************************************/
typedef struct tagMM_RESET
{
	unsigned int unVersion;
	unsigned int unRFU;
} MM_RESET, *PMM_RESET;
typedef const MM_RESET* CPMM_RESET;

#define MM_RESET_VER(v) (sizeof(MM_RESET) << 16 | (0xFFFF & (v)))
#define MM_RESET_VERSION_0 MM_RESET_VER(0)
#define MM_RESET_VERSION MM_RESET_VERSION_0;

static __inline void INIT_MM_RESET(PMM_RESET pStruct) {
    pStruct->unVersion              = MM_RESET_VERSION;
    pStruct->unRFU                  = 0;
}

typedef MM_RET_CODE MM_RESET_ACK, *PMM_RESET_ACK;
typedef const MM_RESET_ACK* CPMM_RESET_ACK;

#define MM_RESET_ACK_VER(v) (sizeof(MM_RESET_ACK) << 16 | (0xFFFF & (v)))
#define MM_RESET_ACK_VERSION_0 MM_RESET_ACK_VER(0)
#define MM_RESET_ACK_VERSION MM_RESET_ACK_VERSION_0;

static __inline void INIT_MM_RESET_ACK(PMM_RESET_ACK pStruct) {
    INIT_MM_RET_CODE(pStruct);
}

typedef MM_RET_CODE MM_RESET_RESULT, *PMM_RESET_RESULT;
typedef const MM_RESET_RESULT* CPMM_RESET_RESULT;

#define MM_RESET_RESULT_VER(v) (sizeof(MM_RESET_RESULT) << 16 | (0xFFFF & (v)))
#define MM_RESET_RESULT_VERSION_0 MM_RESET_RESULT_VER(0)
#define MM_RESET_RESULT_VERSION MM_RESET_RESULT_VERSION_0;

static __inline void INIT_MM_RESET_RESULT(PMM_RESET_RESULT pStruct) {
    INIT_MM_RET_CODE(pStruct);
}

/*******************************************************************************
*  mm_EnableEvents and mm_DisableEvents definitions
*******************************************************************************/
typedef struct tagMM_EVENTS
{
	unsigned int unVersion;
	unsigned int unMask;
} MM_EVENTS, *PMM_EVENTS;
typedef const MM_EVENTS* CPMM_EVENTS;

#define MM_EVENTS_VER(v) (sizeof(MM_EVENTS) << 16 | (0xFFFF & (v)))
#define MM_EVENTS_VERSION_0 MM_EVENTS_VER(0)
#define MM_EVENTS_VERSION MM_EVENTS_VERSION_0;

static __inline void INIT_MM_EVENTS(PMM_EVENTS pStruct) {
    pStruct->unVersion              = MM_EVENTS_VERSION;
    pStruct->unMask                 = 0;
}

typedef MM_RET_CODE MM_ENABLE_EVENTS_RESULT, *PMM_ENABLE_EVENTS_RESULT;
typedef const MM_RET_CODE* CPMM_ENABLE_EVENTS_RESULT;
#define MM_ENABLE_EVENTS_RESULT_VER(v) (sizeof(MM_ENABLE_EVENTS_RESULT) << 16 | (0xFFFF & (v)))
#define MM_ENABLE_EVENTS_RESULT_VERSION_0 MM_ENABLE_EVENTS_RESULT_VER(0)
#define MM_ENABLE_EVENTS_RESULT_VERSION MM_ENABLE_EVENTS_RESULT_VERSION_0;

static __inline void INIT_MM_ENABLE_EVENTS_RESULT(PMM_ENABLE_EVENTS_RESULT pStruct) {
    INIT_MM_RET_CODE(pStruct);
}

typedef MM_RET_CODE MM_DISABLE_EVENTS_RESULT, *PMM_DISABLE_EVENTS_RESULT;
typedef const MM_RET_CODE* CPMM_DISABLE_EVENTS_RESULT;
#define MM_DISABLE_EVENTS_RESULT_VER(v) (sizeof(MM_DISABLE_EVENTS_RESULT) << 16 | (0xFFFF & (v)))
#define MM_DISABLE_EVENTS_RESULT_VERSION_0 MM_DISABLE_EVENTS_RESULT_VER(0)
#define MM_DISABLE_EVENTS_RESULT_VERSION MM_DISABLE_EVENTS_RESULT_VERSION_0;

static __inline void INIT_MM_DISABLE_EVENTS_RESULT(PMM_DISABLE_EVENTS_RESULT pStruct) {
    INIT_MM_RET_CODE(pStruct);
}

/*******************************************************************************
*  mm_Stop definitions
*******************************************************************************/
typedef enum tagEMM_STOP
{
	EMM_STOP_VIDEO_PLAY,
	EMM_STOP_VIDEO_RECORD,
	EMM_STOP_AUDIO_PLAY,
	EMM_STOP_AUDIO_RECORD,
	EMM_STOP_AUDIO_PLAYTONE,
	EMM_STOP_GETDIGIT,
	EMM_STOP_IMAGE_PLAY,
	EMM_STOP_UNDEFINED = 0xff
} eMM_STOP;

typedef struct tagMM_STOP_DETAILS
{
	unsigned int unVersion;
	unsigned int unRfu;
} MM_STOP_DETAILS, *PMM_STOP_DETAILS;
typedef const MM_STOP_DETAILS* CPMM_STOP_DETAILS;

#define MM_STOP_DETAILS_VER(v) (sizeof(MM_STOP_DETAILS) << 16 | (0xFFFF & (v)))
#define MM_STOP_DETAILS_VERSION_0 MM_STOP_DETAILS_VER(0)
#define MM_STOP_DETAILS_VERSION MM_STOP_DETAILS_VERSION_0;

static __inline void INIT_MM_STOP_DETAILS(PMM_STOP_DETAILS pStruct) {
    pStruct->unVersion              = MM_STOP_DETAILS_VERSION;
    pStruct->unRfu                  = 0;
}

typedef struct tagMM_STOP
{
	unsigned int unVersion;
	eMM_ITEM ItemChain;
	eMM_STOP ItemType;
	MM_STOP_DETAILS details;
	struct tagMM_STOP* next;
	struct tagMM_STOP* prev;	/* optional */
} MM_STOP, *PMM_STOP;
typedef const MM_STOP* CPMM_STOP;

#define MM_STOP_VER(v) (sizeof(MM_STOP) << 16 | (0xFFFF & (v)))
#define MM_STOP_VERSION_0 MM_STOP_VER(0)
#define MM_STOP_VERSION MM_STOP_VERSION_0;

static __inline void INIT_MM_STOP(PMM_STOP pStruct) {
    pStruct->unVersion              = MM_STOP_VERSION;
    pStruct->ItemChain              = EMM_ITEM_EOT;
    pStruct->ItemType               = EMM_STOP_UNDEFINED;
    INIT_MM_STOP_DETAILS(&pStruct->details);
    pStruct->next                   = (PMM_STOP)0;
    pStruct->prev                   = (PMM_STOP)0;
}

typedef struct tagMM_STOP_ACK_DETAILS
{
	unsigned int unVersion;
	eMM_STOP ItemType;
	unsigned int unRetCode;
} MM_STOP_ACK_DETAILS, *PMM_STOP_ACK_DETAILS;
typedef const MM_STOP_ACK_DETAILS* CPMM_STOP_ACK_DETAILS;

#define MM_STOP_ACK_DETAILS_VER(v) (sizeof(MM_STOP_ACK_DETAILS) << 16 | (0xFFFF & (v)))
#define MM_STOP_ACK_DETAILS_VERSION_0 MM_STOP_ACK_DETAILS_VER(0)
#define MM_STOP_ACK_DETAILS_VERSION MM_STOP_ACK_DETAILS_VERSION_0;

static __inline void INIT_MM_STOP_ACK_DETAILS(PMM_STOP_ACK_DETAILS pStruct) {
    pStruct->unVersion              = MM_STOP_ACK_DETAILS_VERSION;
    pStruct->ItemType               = EMM_STOP_UNDEFINED;
    pStruct->unRetCode              = 0;
}

#define MAX_STOP_ACK 16
typedef struct tagMM_STOP_ACK
{
	unsigned int unVersion;
	unsigned int unCount;
	MM_STOP_ACK_DETAILS details[MAX_STOP_ACK];
} MM_STOP_ACK, *PMM_STOP_ACK;
typedef const MM_STOP_ACK* CPMM_STOP_ACK;

#define MM_STOP_ACK_VER(v) (sizeof(MM_STOP_ACK) << 16 | (0xFFFF & (v)))
#define MM_STOP_ACK_VERSION_0 MM_STOP_ACK_VER(0)
#define MM_STOP_ACK_VERSION MM_STOP_ACK_VERSION_0;

static __inline void INIT_MM_STOP_ACK(PMM_STOP_ACK pStruct) {
    pStruct->unVersion              = MM_STOP_ACK_VERSION;
    pStruct->unCount                = 0;
}

/*******************************************************************************
*  mm_StreamOpen definitions
*******************************************************************************/
typedef enum tagEMM_STREAM_MODE
{
	EMM_SM_READ,
	EMM_SM_WRITE,
	EMM_SM_UNDEFINED = 0xff
} eMM_STREAM_MODE;

typedef struct tagMM_STREAM_OPEN_INFO
{
	unsigned int unVersion;
	unsigned int unBufferSize;
	eMM_STREAM_MODE BufferMode; /* EMM_SM_READ or EMM_SM_WRITE */
} MM_STREAM_OPEN_INFO, *PMM_STREAM_OPEN_INFO;
typedef const MM_STREAM_OPEN_INFO *CPMM_STREAM_OPEN_INFO;

#define MM_STREAM_OPEN_INFO_VER(v) (sizeof(MM_STREAM_OPEN_INFO) << 16 | (0xFFFF & (v)))
#define MM_STREAM_OPEN_INFO_VERSION_0 MM_STREAM_OPEN_INFO_VER(0)
#define MM_STREAM_OPEN_INFO_VERSION MM_STREAM_OPEN_INFO_VERSION_0;

static __inline void INIT_MM_STREAM_OPEN_INFO(PMM_STREAM_OPEN_INFO pStruct) {
    pStruct->unVersion              = MM_STREAM_OPEN_INFO_VERSION;
    pStruct->unBufferSize           = 0;
    pStruct->BufferMode             = EMM_SM_UNDEFINED;
}

/*******************************************************************************
*  mm_StreamGetStat definitions
*******************************************************************************/
typedef struct tagMM_STREAM_STAT
{
	unsigned int unVersion;                 /* version of the structure */
	unsigned int unBytesIn;                 /* total number of bytes put into stream */
	unsigned int unBytesOut;                /* total number of bytes sent to board */
	unsigned char *pHeadPointer;            /* pointer to position in stream */
	unsigned char *pTailPointer;            /* pointer to position in stream buffer */
	unsigned int unCurrentState;            /* idle, streaming etc. */
	unsigned int unNumberOfBufferUnderruns;
	unsigned int unNumberOfBufferOverruns;
	unsigned int unBufferSize;              /* buffer size */
	unsigned int unBufferMode;              /* read or write mode */
	unsigned int unSpaceAvailable;          /* bytes available in stream buffer */
	unsigned int unHighWaterMark;           /* high water mark for stream buffer */
	unsigned int unLowWaterMark;            /* low water mark for stream buffer */
} MM_STREAM_STAT, *PMM_STREAM_STAT;
typedef const MM_STREAM_STAT *CPMM_STREAM_STAT;

#define MM_STREAM_STAT_VER(v) (sizeof(MM_STREAM_STAT) << 16 | (0xFFFF & (v)))
#define MM_STREAM_STAT_VERSION_0 MM_STREAM_STAT_VER(0)
#define MM_STREAM_STAT_VERSION MM_STREAM_STAT_VERSION_0;

static __inline void INIT_MM_STREAM_STAT(PMM_STREAM_STAT pStruct) {
    pStruct->unVersion              = MM_STREAM_STAT_VERSION;
    pStruct->unBytesIn              = 0;
    pStruct->unBytesOut             = 0;
    pStruct->pHeadPointer           = (unsigned char*)0;
    pStruct->pTailPointer           = (unsigned char*)0;
    pStruct->unCurrentState         = 0;
    pStruct->unNumberOfBufferUnderruns = 0;
    pStruct->unNumberOfBufferOverruns = 0;
    pStruct->unBufferSize = 0;
    pStruct->unBufferMode = 0;
    pStruct->unSpaceAvailable = 0;
    pStruct->unHighWaterMark = 0;
    pStruct->unLowWaterMark = 0;
}

typedef enum tagEMM_STREAM_WATERMARK_LEVEL
{
	EMM_WM_HIGH,
	EMM_WM_LOW,
	EMM_WM_UNDEFINED = 0xff
} eMM_STREAM_WATERMARK_LEVEL;

/*******************************************************************************
*  mm_StreamSetWaterMark definitions
*******************************************************************************/
typedef struct tagMM_STREAM_WATERMARK_INFO
{
	unsigned int unVersion;
	eMM_STREAM_WATERMARK_LEVEL Level; /* EMM_WM_HIGH or EMM_WM_LOW */
	unsigned int unValue;             /* watermark value in bytes */
} MM_STREAM_WATERMARK_INFO, *PMM_STREAM_WATERMARK_INFO;
typedef const MM_STREAM_WATERMARK_INFO *CPMM_STREAM_WATERMARK_INFO;

#define MM_STREAM_WATERMARK_INFO_VER(v) (sizeof(MM_STREAM_WATERMARK_INFO) << 16 | (0xFFFF & (v)))
#define MM_STREAM_WATERMARK_INFO_VERSION_0 MM_STREAM_WATERMARK_INFO_VER(0)
#define MM_STREAM_WATERMARK_INFO_VERSION MM_STREAM_WATERMARK_INFO_VERSION_0;

static __inline void INIT_MM_STREAM_WATERMARK_INFO(PMM_STREAM_WATERMARK_INFO pStruct) {
    pStruct->unVersion              = MM_STREAM_WATERMARK_INFO_VERSION;
    pStruct->Level                  = EMM_WM_UNDEFINED;
    pStruct->unValue                = 0;
}

/*******************************************************************************
*  mm_Pause definitions
*******************************************************************************/
typedef struct tagMM_PAUSE_INFO {
    unsigned int unVersion;
    unsigned int unStreamType;
	unsigned int unAttribute;
} MM_PAUSE_INFO, *PMM_PAUSE_INFO;
typedef const MM_PAUSE_INFO* CPMM_PAUSE_INFO;

#define MM_PAUSE_INFO_VER(v) (sizeof(MM_PAUSE_INFO) << 16 | (0xFFFF & (v)))
#define MM_PAUSE_INFO_VERSION_0 MM_PAUSE_INFO_VER(0)
#define MM_PAUSE_INFO_VERSION MM_PAUSE_INFO_VERSION_0;

static __inline void INIT_MM_PAUSE_INFO(PMM_PAUSE_INFO pStruct) {
    pStruct->unVersion              = MM_PAUSE_INFO_VERSION;
    pStruct->unStreamType          = 0;
	pStruct->unAttribute            = 0;
}

typedef MM_RET_CODE MM_PAUSE_RESULT, *PMM_PAUSE_RESULT;
typedef const MM_RET_CODE* CPMM_PAUSE_RESULT;

#define MM_PAUSE_RESULT_VER(v) (sizeof(MM_PAUSE_RESULT) << 16 | (0xFFFF & (v)))
#define MM_PAUSE_RESULT_VERSION_0 MM_PAUSE_RESULT_VER(0)
#define MM_PAUSE_RESULT_VERSION MM_PAUSE_RESULT_VERSION_0;

static __inline void INIT_MM_PAUSE_RESULT(PMM_PAUSE_RESULT pStruct) {
    INIT_MM_RET_CODE(pStruct);
}


// unStreamType values
// The unStreamType parameter value can be ONE of the following modes:
#define EMM_PAUSE_AUDIO_ONLY	0x0001	// Pause audio transmission ONLY. Valid for un-synced transmissions. If video/audio is synced, both video and audio will be paused.
#define EMM_PAUSE_VIDEO_ONLY	0x0002	// Pause video transmission ONLY. Valid for un-synced transmissions. If video/audio is synced, both video and audio will be paused.
#define EMM_PAUSE_VIDEO_AUDIO	0x0003	// Pause BOTH video and audio transmission. Default audio option. Valid for both synced and un-synced transmissions.

// unAttribute values
#define EMM_PAUSE_AUDIO_SILENCE	0x0001	// When audio transmission is paused transmit audio silence (DEFAULT).
#define EMM_PAUSE_AUDIO_CNG		0x0002	// When audio transmission is paused transmit audio comfort noise.


// mm_Pause return definitions
typedef struct tagMM_PAUSE_PLAY_CMPLT_DETAILS
{
	unsigned int unVersion;
	unsigned int unStreamType;
	unsigned int unRetCode;
} MM_PAUSE_PLAY_CMPLT_DETAILS, *PMM_PAUSE_PLAY_CMPLT_DETAILS;
typedef const MM_PAUSE_PLAY_CMPLT_DETAILS* CPMM_PAUSE_PLAY_CMPLT_DETAILS;

#define MM_PAUSE_PLAY_CMPLT_DETAILS_VER(v) (sizeof(MM_PAUSE_PLAY_CMPLT_DETAILS) << 16 | (0xFFFF & (v)))
#define MM_PAUSE_PLAY_CMPLT_DETAILS_VERSION_0 MM_PAUSE_PLAY_CMPLT_DETAILS_VER(0)
#define MM_PAUSE_PLAY_CMPLT_DETAILS_VERSION MM_PAUSE_PLAY_CMPLT_DETAILS_VERSION_0;

static __inline void INIT_MM_PAUSE_PLAY_CMPLT_DETAILS(PMM_PAUSE_PLAY_CMPLT_DETAILS pStruct) {
    pStruct->unVersion              = MM_PAUSE_PLAY_CMPLT_DETAILS_VERSION;
    pStruct->unStreamType           = 0;
    pStruct->unRetCode              = 0;
}

#define MAX_PAUSE_PLAY_CMPLT 16
typedef struct tagMM_PAUSE_PLAY_CMPLT
{
	unsigned int unVersion;
	unsigned int unCount;
	MM_PAUSE_PLAY_CMPLT_DETAILS details[MAX_PAUSE_PLAY_CMPLT];
} MM_PAUSE_PLAY_CMPLT, *PMM_PAUSE_PLAY_CMPLT;
typedef const MM_PAUSE_PLAY_CMPLT* CPMM_PAUSE_PLAY_CMPLT;

#define MM_PAUSE_PLAY_CMPLT_VER(v) (sizeof(MM_PAUSE_PLAY_CMPLT) << 16 | (0xFFFF & (v)))
#define MM_PAUSE_PLAY_CMPLT_VERSION_0 MM_PAUSE_PLAY_CMPLT_VER(0)
#define MM_PAUSE_PLAY_CMPLT_VERSION MM_PAUSE_PLAY_CMPLT_VERSION_0;

static __inline void INIT_MM_PAUSE_PLAY_CMPLT(PMM_PAUSE_PLAY_CMPLT pStruct) {
    pStruct->unVersion              = MM_PAUSE_PLAY_CMPLT_VERSION;
    pStruct->unCount                = 0;
}



/*******************************************************************************
*  mm_Resume definitions
*******************************************************************************/
typedef struct tagMM_RESUME_INFO {
    unsigned int unVersion;
    unsigned int unStreamType;
	unsigned int unAttribute;
} MM_RESUME_INFO, *PMM_RESUME_INFO;
typedef const MM_RESUME_INFO* CPMM_RESUME_INFO;

#define MM_RESUME_INFO_VER(v) (sizeof(MM_RESUME_INFO) << 16 | (0xFFFF & (v)))
#define MM_RESUME_INFO_VERSION_0 MM_RESUME_INFO_VER(0)
#define MM_RESUME_INFO_VERSION MM_RESUME_INFO_VERSION_0;

static __inline void INIT_MM_RESUME_INFO(PMM_RESUME_INFO pStruct) {
    pStruct->unVersion              = MM_RESUME_INFO_VERSION;
    pStruct->unStreamType           = 0;
	pStruct->unAttribute            = 0;
}

typedef MM_RET_CODE MM_RESUME_RESULT, *PMM_RESUME_RESULT;
typedef const MM_RET_CODE* CPMM_RESUME_RESULT;

#define MM_RESUME_RESULT_VER(v) (sizeof(MM_RESUME_RESULT) << 16 | (0xFFFF & (v)))
#define MM_RESUME_RESULT_VERSION_0 MM_RESUME_RESULT_VER(0)
#define MM_RESUME_RESULT_VERSION MM_RESUME_RESULT_VERSION_0;

static __inline void INIT_MM_RESUME_RESULT(PMM_RESUME_RESULT pStruct) {
 INIT_MM_RET_CODE(pStruct);
}

// unStreamType values
// The unStreamType parameter value can be ONE of the following modes:
#define EMM_RESUME_AUDIO_ONLY		0x0001	// Resume audio transmission ONLY. Valid for un-synced transmissions. If video/audio is synced, both video and audio will be resumed.
#define EMM_RESUME_VIDEO_ONLY		0x0002	// Resume video transmission ONLY. Valid for un-synced transmissions. If video/audio is synced, both video and audio will be resumed.
#define EMM_RESUME_VIDEO_AUDIO		0x0003	// Resume BOTH video and audio transmission. Default audio option. Valid for both synced and un-synced transmissions.

// unAttribute values
#define EMM_RESUME_VIDEO_NONE		0x0001	// Resume video transmission from next frame following the frame at which it was paused.  Default video option.
#define EMM_RESUME_VIDEO_LAST		0x0002	// Retransmits from most recent video keyframe (I-frame).

// mm_Resume return definitions
typedef struct tagMM_RESUME_PLAY_CMPLT_DETAILS
{
	unsigned int unVersion;
	unsigned int unStreamType;
	unsigned int unRetCode;
} MM_RESUME_PLAY_CMPLT_DETAILS, *PMM_RESUME_PLAY_CMPLT_DETAILS;
typedef const MM_RESUME_PLAY_CMPLT_DETAILS* CPMM_RESUME_PLAY_CMPLT_DETAILS;

#define MM_RESUME_PLAY_CMPLT_DETAILS_VER(v) (sizeof(MM_RESUME_PLAY_CMPLT_DETAILS) << 16 | (0xFFFF & (v)))
#define MM_RESUME_PLAY_CMPLT_DETAILS_VERSION_0 MM_RESUME_PLAY_CMPLT_DETAILS_VER(0)
#define MM_RESUME_PLAY_CMPLT_DETAILS_VERSION MM_RESUME_PLAY_CMPLT_DETAILS_VERSION_0;

static __inline void INIT_MM_RESUME_PLAY_CMPLT_DETAILS(PMM_RESUME_PLAY_CMPLT_DETAILS pStruct) {
    pStruct->unVersion              = MM_RESUME_PLAY_CMPLT_DETAILS_VERSION;
    pStruct->unStreamType           = 0;
    pStruct->unRetCode              = 0;
}

#define MAX_RESUME_PLAY_CMPLT 16
typedef struct tagMM_RESUME_PLAY_CMPLT
{
	unsigned int unVersion;
	unsigned int unCount;
	MM_RESUME_PLAY_CMPLT_DETAILS details[MAX_RESUME_PLAY_CMPLT];
} MM_RESUME_PLAY_CMPLT, *PMM_RESUME_PLAY_CMPLT;
typedef const MM_RESUME_PLAY_CMPLT* CPMM_RESUME_PLAY_CMPLT;

#define MM_RESUME_PLAY_CMPLT_VER(v) (sizeof(MM_RESUME_PLAY_CMPLT) << 16 | (0xFFFF & (v)))
#define MM_RESUME_PLAY_CMPLT_VERSION_0 MM_RESUME_PLAY_CMPLT_VER(0)
#define MM_RESUME_PLAY_CMPLT_VERSION MM_RESUME_PLAY_CMPLT_VERSION_0;

static __inline void INIT_MM_RESUME_PLAY_CMPLT(PMM_RESUME_PLAY_CMPLT pStruct) {
    pStruct->unVersion              = MM_RESUME_PLAY_CMPLT_VERSION;
    pStruct->unCount                = 0;
}

/*******************************************************************************
*  mm_Seek definitions
*******************************************************************************/
typedef struct tagMM_SEEK_INFO {
    unsigned int unVersion;
    unsigned int unStreamType;
    unsigned int unOrigin;
	int nOffset;
} MM_SEEK_INFO, *PMM_SEEK_INFO;
typedef const MM_SEEK_INFO* CPMM_SEEK_INFO;

#define MM_SEEK_INFO_VER(v) (sizeof(MM_SEEK_INFO) << 16 | (0xFFFF & (v)))
#define MM_SEEK_INFO_VERSION_0 MM_SEEK_INFO_VER(0)
#define MM_SEEK_INFO_VERSION MM_SEEK_INFO_VERSION_0;

static __inline void INIT_MM_SEEK_INFO(PMM_SEEK_INFO pStruct) {
    pStruct->unVersion              = MM_SEEK_INFO_VERSION;
	pStruct->unStreamType           = 0;
    pStruct->unOrigin               = 0;
	pStruct->nOffset                = 0;
}

typedef MM_RET_CODE MM_SEEK_RESULT, *PMM_SEEK_RESULT;
typedef const MM_RET_CODE* CPMM_SEEK_RESULT;

#define MM_SEEK_RESULT_VER(v) (sizeof(MM_SEEK_RESULT) << 16 | (0xFFFF & (v)))
#define MM_SEEK_RESULT_VERSION_0 MM_SEEK_RESULT_VER(0)
#define MM_SEEK_RESULT_VERSION MM_SEEK_RESULT_VERSION_0;

static __inline void INIT_MM_SEEK_RESULT(PMM_SEEK_RESULT pStruct) {
    INIT_MM_RET_CODE(pStruct);
}

// unStreamType values
// The unStreamType parameter value can be ONE of the following modes:
#define EMM_SEEK_AUDIO_ONLY		0x0001	// Seek audio transmission ONLY. Valid for un-synced transmissions. If video/audio is synced, both video and audio position will be moved.
#define EMM_SEEK_VIDEO_ONLY		0x0002	// Seek video transmission ONLY. Valid for un-synced transmissions. If video/audio is synced, both video and audio position will be moved.
#define EMM_SEEK_VIDEO_AUDIO	0x0003	// Seek BOTH video and audio transmission. Default audio option. Valid for both synced and un-synced transmissions.

// unOrigin values
#define EMM_SEEK_SET			0x0001	// Start seek operation from beggining of file
#define EMM_SEEK_CUR			0x0002	// Start seek operation from current positin in file

// mm_Seek return definitions
typedef struct tagMM_SEEK_CMPLT_DETAILS
{
	unsigned int unVersion;
	unsigned int unStreamType;
	unsigned int unRetCode;
} MM_SEEK_CMPLT_DETAILS, *PMM_SEEK_CMPLT_DETAILS;
typedef const MM_SEEK_CMPLT_DETAILS* CPMM_SEEK_CMPLT_DETAILS;

#define MM_SEEK_CMPLT_DETAILS_VER(v) (sizeof(MM_SEEK_CMPLT_DETAILS) << 16 | (0xFFFF & (v)))
#define MM_SEEK_CMPLT_DETAILS_VERSION_0 MM_SEEK_CMPLT_DETAILS_VER(0)
#define MM_SEEK_CMPLT_DETAILS_VERSION MM_SEEK_CMPLT_DETAILS_VERSION_0;

static __inline void INIT_MM_SEEK_CMPLT_DETAILS(PMM_SEEK_CMPLT_DETAILS pStruct) {
    pStruct->unVersion              = MM_SEEK_CMPLT_DETAILS_VERSION;
    pStruct->unStreamType           = 0;
    pStruct->unRetCode              = 0;
}

#define MAX_SEEK_CMPLT 16
typedef struct tagMM_SEEK_CMPLT
{
	unsigned int unVersion;
	unsigned int unCount;
	MM_SEEK_CMPLT_DETAILS details[MAX_SEEK_CMPLT];
} MM_SEEK_CMPLT, *PMM_SEEK_CMPLT;
typedef const MM_SEEK_CMPLT* CPMM_SEEK_CMPLT;

#define MM_SEEK_CMPLT_VER(v) (sizeof(MM_SEEK_CMPLT) << 16 | (0xFFFF & (v)))
#define MM_SEEK_CMPLT_VERSION_0 MM_SEEK_CMPLT_VER(0)
#define MM_SEEK_CMPLT_VERSION MM_SEEK_CMPLT_VERSION_0;

static __inline void INIT_MM_SEEK_CMPLT(PMM_SEEK_CMPLT pStruct) {
    pStruct->unVersion              = MM_SEEK_CMPLT_VERSION;
    pStruct->unCount                = 0;
}


/*******************************************************************************
*  mm_GetElapsedTime definitions
*******************************************************************************/
typedef struct tagMM_GETELAPSEDTIME_INFO {
    unsigned int unVersion;
    unsigned int unStreamType;
} MM_GETELAPSEDTIME_INFO, *PMM_GETELAPSEDTIME_INFO;
typedef const MM_GETELAPSEDTIME_INFO* CPMM_GETELAPSEDTIME_INFO;

#define MM_GETELAPSEDTIME_INFO_VER(v) (sizeof(MM_GETELAPSEDTIME_INFO) << 16 | (0xFFFF & (v)))
#define MM_GETELAPSEDTIME_INFO_VERSION_0 MM_GETELAPSEDTIME_INFO_VER(0)
#define MM_GETELAPSEDTIME_INFO_VERSION MM_GETELAPSEDTIME_INFO_VERSION_0;

static __inline void INIT_MM_GETELAPSEDTIME_INFO(PMM_GETELAPSEDTIME_INFO pStruct) {
    pStruct->unVersion              = MM_GETELAPSEDTIME_INFO_VERSION;
    pStruct->unStreamType           = 0;
}

#define MM_UNDEF_POSITION -1.0
typedef struct tagMM_GETELAPSEDTIME_RESULT {
    unsigned int unVersion;
    unsigned int unRetCode;
    double dbPosVideo;
    double dbPosAudio;
} MM_GETELAPSEDTIME_RESULT, *PMM_GETELAPSEDTIME_RESULT;
typedef const MM_GETELAPSEDTIME_RESULT* CPMM_GETELAPSEDTIME_RESULT;

#define MM_GETELAPSEDTIME_RESULT_VER(v) (sizeof(MM_GETELAPSEDTIME_RESULT) << 16 | (0xFFFF & (v)))
#define MM_GETELAPSEDTIME_RESULT_VERSION_0 MM_GETELAPSEDTIME_RESULT_VER(0)
#define MM_GETELAPSEDTIME_RESULT_VERSION MM_GETELAPSEDTIME_RESULT_VERSION_0;

static __inline void INIT_MM_GETELAPSEDTIME_RESULT(PMM_GETELAPSEDTIME_RESULT pStruct) {
    pStruct->unVersion              = MM_GETELAPSEDTIME_RESULT_VERSION;
    pStruct->unRetCode              = 0;
    pStruct->dbPosVideo             = MM_UNDEF_POSITION;
    pStruct->dbPosAudio             = MM_UNDEF_POSITION;
}

// unStreamType values
// The unStreamType parameter value can be ONE of the following modes:
#define EMM_GETELAPSEDTIME_AUDIO_ONLY	0x0001	// Pause audio transmission ONLY. Valid for un-synced transmissions. If video/audio is synced, both video and audio will be paused.
#define EMM_GETELAPSEDTIME_VIDEO_ONLY	0x0002	// Pause video transmission ONLY. Valid for un-synced transmissions. If video/audio is synced, both video and audio will be paused.
#define EMM_GETELAPSEDTIME_VIDEO_AUDIO	0x0003	// Pause BOTH video and audio transmission. Default audio option. Valid for both synced and un-synced transmissions.

// mm_GetElapsedTime return definitions
typedef struct tagMM_GETELAPSEDTIME_CMPLT_DETAILS
{
	unsigned int unVersion;
	unsigned int unStreamType;
	unsigned int unRetCode;
	unsigned int unElapsedTime;
} MM_GETELAPSEDTIME_CMPLT_DETAILS, *PMM_GETELAPSEDTIME_CMPLT_DETAILS;
typedef const MM_GETELAPSEDTIME_CMPLT_DETAILS* CPMM_GETELAPSEDTIME_CMPLT_DETAILS;

#define MM_GETELAPSEDTIME_CMPLT_DETAILS_VER(v) (sizeof(MM_GETELAPSEDTIME_CMPLT_DETAILS) << 16 | (0xFFFF & (v)))
#define MM_GETELAPSEDTIME_CMPLT_DETAILS_VERSION_0 MM_GETELAPSEDTIME_CMPLT_DETAILS_VER(0)
#define MM_GETELAPSEDTIME_CMPLT_DETAILS_VERSION MM_GETELAPSEDTIME_CMPLT_DETAILS_VERSION_0;

static __inline void INIT_MM_GETELAPSEDTIME_CMPLT_DETAILS(PMM_GETELAPSEDTIME_CMPLT_DETAILS pStruct) {
    pStruct->unVersion              = MM_GETELAPSEDTIME_CMPLT_DETAILS_VERSION;
    pStruct->unStreamType           = 0;
    pStruct->unRetCode              = 0;
	pStruct->unElapsedTime          = 0;
}

#define MAX_GETELAPSEDTIME_CMPLT 16
typedef struct tagMM_GETELAPSEDTIME_CMPLT
{
	unsigned int unVersion;
	unsigned int unCount;
	MM_GETELAPSEDTIME_CMPLT_DETAILS details[MAX_GETELAPSEDTIME_CMPLT];
} MM_GETELAPSEDTIME_CMPLT, *PMM_GETELAPSEDTIME_CMPLT;
typedef const MM_GETELAPSEDTIME_CMPLT* CPMM_GETELAPSEDTIME_CMPLT;

#define MM_GETELAPSEDTIME_CMPLT_VER(v) (sizeof(MM_GETELAPSEDTIME_CMPLT) << 16 | (0xFFFF & (v)))
#define MM_GETELAPSEDTIME_CMPLT_VERSION_0 MM_GETELAPSEDTIME_CMPLT_VER(0)
#define MM_GETELAPSEDTIME_CMPLT_VERSION MM_GETELAPSEDTIME_CMPLT_VERSION_0;

static __inline void INIT_MM_GETELAPSEDTIME_CMPLT(PMM_GETELAPSEDTIME_CMPLT pStruct) {
    pStruct->unVersion              = MM_GETELAPSEDTIME_CMPLT_VERSION;
    pStruct->unCount                = 0;
}

/*******************************************************************************
*  mm_GetDuration definitions
*******************************************************************************/
typedef struct tagMM_GETDURATION_INFO {
    unsigned int unVersion;
    unsigned int unStreamType;
} MM_GETDURATION_INFO, *PMM_GETDURATION_INFO;
typedef const MM_GETDURATION_INFO* CPMM_GETDURATION_INFO;

#define MM_GETDURATION_INFO_VER(v) (sizeof(MM_GETDURATION_INFO) << 16 | (0xFFFF & (v)))
#define MM_GETDURATION_INFO_VERSION_0 MM_GETDURATION_INFO_VER(0)
#define MM_GETDURATION_INFO_VERSION MM_GETDURATION_INFO_VERSION_0;

static __inline void INIT_MM_GETDURATION_INFO(PMM_GETDURATION_INFO pStruct) {
    pStruct->unVersion              = MM_GETDURATION_INFO_VERSION;
    pStruct->unStreamType           = 0;
}

#define MM_UNDEF_DURATION -1.0
typedef struct tagMM_GETDURATION_RESULT {
    unsigned int unVersion;
    unsigned int unRetCode;
    double dbDurationVideo;
    double dbDurationAudio;
} MM_GETDURATION_RESULT, *PMM_GETDURATION_RESULT;
typedef const MM_GETDURATION_RESULT* CPMM_GETDURATION_RESULT;

#define MM_GETDURATION_RESULT_VER(v) (sizeof(MM_GETDURATION_RESULT) << 16 | (0xFFFF & (v)))
#define MM_GETDURATION_RESULT_VERSION_0 MM_GETDURATION_RESULT_VER(0)
#define MM_GETDURATION_RESULT_VERSION MM_GETDURATION_RESULT_VERSION_0;

static __inline void INIT_MM_GETDURATION_RESULT(PMM_GETDURATION_RESULT pStruct) {
    pStruct->unVersion              = MM_GETDURATION_RESULT_VERSION;
    pStruct->unRetCode              = 0;
    pStruct->dbDurationVideo        = MM_UNDEF_DURATION;
    pStruct->dbDurationAudio        = MM_UNDEF_DURATION;
}

// unStreamType values
// The unStreamType parameter value can be ONE of the following modes:
#define EMM_GETDURATION_AUDIO_ONLY	0x0001	// Pause audio transmission ONLY. Valid for un-synced transmissions. If video/audio is synced, both video and audio will be paused.
#define EMM_GETDURATION_VIDEO_ONLY	0x0002	// Pause video transmission ONLY. Valid for un-synced transmissions. If video/audio is synced, both video and audio will be paused.
#define EMM_GETDURATION_VIDEO_AUDIO	0x0003	// Pause BOTH video and audio transmission. Default audio option. Valid for both synced and un-synced transmissions.

// mm_GetDuration return definitions
typedef struct tagMM_GETDURATION_CMPLT_DETAILS
{
	unsigned int unVersion;
	unsigned int unStreamType;
	unsigned int unRetCode;
	unsigned int unDuration;
} MM_GETDURATION_CMPLT_DETAILS, *PMM_GETDURATION_CMPLT_DETAILS;
typedef const MM_GETDURATION_CMPLT_DETAILS* CPMM_GETDURATION_CMPLT_DETAILS;

#define MM_GETDURATION_CMPLT_DETAILS_VER(v) (sizeof(MM_GETDURATION_CMPLT_DETAILS) << 16 | (0xFFFF & (v)))
#define MM_GETDURATION_CMPLT_DETAILS_VERSION_0 MM_GETDURATION_CMPLT_DETAILS_VER(0)
#define MM_GETDURATION_CMPLT_DETAILS_VERSION MM_GETDURATION_CMPLT_DETAILS_VERSION_0;

static __inline void INIT_MM_GETDURATION_CMPLT_DETAILS(PMM_GETDURATION_CMPLT_DETAILS pStruct) {
    pStruct->unVersion              = MM_GETDURATION_CMPLT_DETAILS_VERSION;
    pStruct->unStreamType           = 0;
    pStruct->unRetCode              = 0;
	pStruct->unDuration             = 0;
}

#define MAX_GETDURATION_CMPLT 16
typedef struct tagMM_GETDURATION_CMPLT
{
	unsigned int unVersion;
	unsigned int unCount;
	MM_GETDURATION_CMPLT_DETAILS details[MAX_GETDURATION_CMPLT];
} MM_GETDURATION_CMPLT, *PMM_GETDURATION_CMPLT;
typedef const MM_GETDURATION_CMPLT* CPMM_GETDURATION_CMPLT;

#define MM_GETDURATION_CMPLT_VER(v) (sizeof(MM_GETDURATION_CMPLT) << 16 | (0xFFFF & (v)))
#define MM_GETDURATION_CMPLT_VERSION_0 MM_GETDURATION_CMPLT_VER(0)
#define MM_GETDURATION_CMPLT_VERSION MM_GETDURATION_CMPLT_VERSION_0;

static __inline void INIT_MM_GETDURATION_CMPLT(PMM_GETDURATION_CMPLT pStruct) {
    pStruct->unVersion              = MM_GETDURATION_CMPLT_VERSION;
    pStruct->unCount                = 0;
}


/*******************************************************************************
* MM_ERROR_RESULT
* Data block returned with MMEV_ERROR event
*******************************************************************************/
typedef struct tagMM_ERROR_RESULT
{
	unsigned int unVersion;
	unsigned int unErrorCode;
	unsigned int unErrorMsg;
	unsigned int unData[4];
} MM_ERROR_RESULT, *PMM_ERROR_RESULT;
typedef const MM_ERROR_RESULT* CPMM_ERROR_RESULT;

#define MM_ERROR_RESULT_VER(v) (sizeof(MM_ERROR_RESULT) << 16 | (0xFFFF & (v)))
#define MM_ERROR_RESULT_VERSION_0 MM_ERROR_RESULT_VER(0)
#define MM_ERROR_RESULT_VERSION MM_ERROR_RESULT_VERSION_0;

static __inline void INIT_MM_ERROR_RESULT(PMM_ERROR_RESULT pStruct) {
    pStruct->unVersion              = MM_ERROR_RESULT_VERSION;
    pStruct->unErrorCode            = 0;
    pStruct->unErrorMsg             = 0;
    pStruct->unData[0]              = 0;
    pStruct->unData[1]              = 0;
    pStruct->unData[2]              = 0;
    pStruct->unData[3]              = 0;
}

/*******************************************************************************
* MM_INFO
*******************************************************************************/
typedef struct tagMM_INFO
{
	unsigned int unVersion;
	int mmValue;
	const char* mmMsg;
	const char* additionalInfo;
} MM_INFO, *PMM_INFO;
typedef const MM_INFO* CPMM_INFO;

#define MM_INFO_VER(v) (sizeof(MM_INFO) << 16 | (0xFFFF & (v)))
#define MM_INFO_VERSION_0 MM_INFO_VER(0)
#define MM_INFO_VERSION MM_INFO_VERSION_0;

static __inline void INIT_MM_INFO(PMM_INFO pStruct) {
    pStruct->unVersion              = MM_INFO_VERSION;
    pStruct->mmValue                = 0;
    pStruct->mmMsg                  = "";
    pStruct->additionalInfo         = "";
}

/*******************************************************************************
* MM_METAEVENT
*******************************************************************************/
typedef struct tagMM_METAEVENT
{
    unsigned int unVersion;
    /* application calls mm_GetMetaEvent() to fill in these fields */
    unsigned long    flags;              /* flags field */
                                         /* - possibly event data structure type */
                                         /* i.e. evtdata_struct_type */
    void*            evtdatap;           /* pointer to the event data block */
                                         /* other libraries to be determined */
                                         /* sr_getevtdatap() */
    long             evtlen;             /* event length */
                                         /* sr_getevtlen */
    long             evtdev;             /* sr_getevtdev */
    long             evttype;            /* Event type */
    void*            evtUserInfo;        /* User Info */

    int              rfu1;               /* for future use only */

} MM_METAEVENT, *PMM_METAEVENT;
typedef const MM_METAEVENT* CPMM_METAEVENT;

#define MM_METAEVENT_VER(v) (sizeof(MM_METAEVENT) << 16 | (0xFFFF & (v)))
#define MM_METAEVENT_VERSION_0 MM_METAEVENT_VER(0)
#define MM_METAEVENT_VERSION MM_METAEVENT_VERSION_0;

static __inline void INIT_MM_METAEVENT(PMM_METAEVENT pStruct) {
    pStruct->unVersion              = MM_METAEVENT_VERSION;
    pStruct->flags                  = 0;
    pStruct->evtdatap               = (void*)0;
    pStruct->evtlen                 = 0;
    pStruct->evtdev                 = 0;
    pStruct->evttype                = 0;
    pStruct->evtUserInfo            = (void*)0;
    pStruct->rfu1                   = 0;
}

/* define(s) for flags field within MM_METAEVENT structure */
#define MMME_MM_EVENT               0x2  /* Event is an MM event */


/*******************************************************************************
* MM API methods
*******************************************************************************/
#ifdef __cplusplus
extern "C" {
#endif  /* __cplusplus */

MMLIB_API
int MMAPI_CONV mm_Open(
	const char*             szDevName,
	CPMM_OPEN_INFO          pOpenInfo,
	void*                   pUserInfo
	);
	
MMLIB_API
int MMAPI_CONV mm_Close(
	int                     nDeviceHandle,
	CPMM_CLOSE_INFO         pCloseInfo
	);

MMLIB_API
int MMAPI_CONV mm_Play(
	int                     nDeviceHandle,
	CPMM_PLAY_INFO          pPlayInfo,
	CPMM_RUNTIME_CONTROL    pRuntimeControl,
	void*                   pUserInfo
	);
	
MMLIB_API
int MMAPI_CONV mm_Record(
	int                     nDeviceHandle,
	CPMM_RECORD_INFO        pRecordInfo,
	CPMM_RUNTIME_CONTROL    pRuntimeControl,
	void*                   pUserInfo
	);
	
MMLIB_API
int MMAPI_CONV mm_Stop(
	int                     nDeviceHandle,
	CPMM_STOP               pStop,
	void*                   pUserInfo
	);

MMLIB_API
int MMAPI_CONV mm_GetParm(
	int                     nDeviceHandle,
	CPMM_GET_PARM           pGetParm,
	void*                   pUserInfo
	);
	
MMLIB_API
int MMAPI_CONV mm_SetParm(
	int                     nDeviceHandle,
	CPMM_SET_PARM           pSetParm,
	void*                   pUserInfo
	);
	
MMLIB_API
int MMAPI_CONV mm_GetChanState(
	int                     nDeviceHandle,
	CPMM_GET_CHAN_STATE     pGetChanState,
	void*                   pUserInfo
	);

MMLIB_API
int MMAPI_CONV mm_Reset(
	int                     nDeviceHandle,
	CPMM_RESET              pReset,
	void*                   pUserInfo
	);

MMLIB_API
int MMAPI_CONV mm_EnableEvents(
	int                     nDeviceHandle,
	CPMM_EVENTS             pEvents,
	void*                   pUserInfo
	);

MMLIB_API
int MMAPI_CONV mm_DisableEvents(
	int                     nDeviceHandle,
	CPMM_EVENTS             pEvents,
	void*                   pUserInfo
	);

MMLIB_API
int MMAPI_CONV mm_GetMetaEvent(
	PMM_METAEVENT           pMetaEvent
	);

#ifdef MMAPI_TARGET_WIN32
MMLIB_API
int MMAPI_CONV mm_GetMetaEventEx(
	PMM_METAEVENT         pMetaEvent,
	unsigned int          evt_handle
	);
#endif	/* ifdef MMAPI_TARGET_WIN32 */

MMLIB_API
int MMAPI_CONV mm_StreamOpen(
	CPMM_STREAM_OPEN_INFO pStreamOpenInfo,
	void                  *pUserInfo
	);

MMLIB_API
int MMAPI_CONV mm_StreamClose(
	int          nStreamHandle
	);

MMLIB_API
int MMAPI_CONV mm_StreamReset(
	int          nStreamHandle
	);

MMLIB_API
int MMAPI_CONV mm_StreamGetStat(
	int          nStreamHandle,
	PMM_STREAM_STAT       pStreamStat
	);

MMLIB_API
int MMAPI_CONV mm_StreamSetWaterMark(
	int               nStreamHandle,
	CPMM_STREAM_WATERMARK_INFO pStreamWaterMarkInfo
	);

MMLIB_API
int MMAPI_CONV mm_StreamRead(
	int          nStreamHandle,
	unsigned char         *pData,
	unsigned int          *pDataSize,
	unsigned int          *pEndFlag
	);

MMLIB_API
int MMAPI_CONV mm_StreamWrite(
	int          nStreamHandle,
	unsigned char         *pData,
	unsigned int          unDataSize,
	unsigned int          unEndFlag
	);

MMLIB_API
int MMAPI_CONV mm_Pause(
    int nDeviceHandle,
    CPMM_PAUSE_INFO pPauseInfo,
    void* pUserInfo
);

MMLIB_API
int MMAPI_CONV mm_Resume(
    int nDeviceHandle,
    CPMM_RESUME_INFO pResumeInfo,
    void* pUserInfo
);

MMLIB_API
int MMAPI_CONV mm_Seek(
    int nDeviceHandle,
    CPMM_SEEK_INFO pSeekInfo,
    void* pUserInfo
);

MMLIB_API
int MMAPI_CONV mm_GetElapsedTime(
    int nDeviceHandle,
    CPMM_GETELAPSEDTIME_INFO pGetElapsedTimeInfo,
    void* pUserInfo
);

MMLIB_API
int MMAPI_CONV mm_GetDuration(
    int nDeviceHandle,
    CPMM_GETDURATION_INFO pGetDurationInfo,
    void* pUserInfo
);

MMLIB_API
int MMAPI_CONV mm_Capture(
	int nDeviceHandle, 
	CPMM_MEDIA_IMAGE pImage, 
	CPMM_RUNTIME_CONTROL pRuntimeControl, 
	void* pUserInfo
);

/* Retrieves information about MM events */
MMLIB_API
int MMAPI_CONV mm_ResultInfo(
	CPMM_METAEVENT          pMetaEvent,
	PMM_INFO                pInfo
	);

/* Provides thread-specific error information about a failed function */
MMLIB_API
int MMAPI_CONV mm_ErrorInfo(
	PMM_INFO                pInfo
	);

#ifdef __cplusplus
}
#endif  /* __cplusplus */

#pragma pack(pop)

#endif /* _MMLIB_H_ */
