/****************************************************************************
 *		Copyright (c) 1995 Dialogic Corp.
 *		All Rights Reserved.
 *
 *		THIS IS UNPUBLISHED PROPRIETARY SOURCE CODE OF Dialogic Corp.
 *		The copyright notice above does not evidence any actual or
 *		intended publication of such source code.
 ***************************************************************************/

/****************************************************************************
 * FILE:         
 * AUTHOR:       Tyshaun Hawkins
 * ORG:          Dialogic Corporation
 * ORIG-DATE:    24-Jun-98 at 13:24:47 by Tyshaun Hawkins
 * LAST-MOD:     24-Jun-98 at 13:15:19 by Tyshaun Hawkins
 * PURPOSE:
 *    This defines all the standard message ranges that these components will
 *    recieve.
 *
 * HISTORY:
 * Date			Who	Description
 * 24-Jun-98   TH    Initial creation.
 ***************************************************************************/
#ifndef  _MSGSET_H__
#define  _MSGSET_H__

/*
 * The following macro takes the incoming Mercury Message and shifts it left
 * by 7 bits in order to isolate the proper message range.  This works
 * since message number are assigned in blocks of 128.
 */
#define  QMSG_RANGE(_ARG1) ((_ARG1) >> 8)

#define  QMSG_RANGE_STD    (QMsgtype)QMSG_RANGE(0)       /* Standard */
#define  QMSG_RANGE_QKERNEL (QMsgtype)QMSG_RANGE(0x800000) /* Qkernel */


#define  MIN_MSG_SIZE    24
#endif
