/**********@@@SOFT@@@WARE@@@COPY@@@RIGHT@@@**********************************
* DIALOGIC CONFIDENTIAL
*
* Copyright (C) 2007 Dialogic Corporation. All Rights Reserved.
* The source code contained or described herein and all documents related
* to the source code ("Material") are owned by Dialogic Corporation or its
* suppliers or licensors. Title to the Material remains with Dialogic Corporation
* or its suppliers and licensors. The Material contains trade secrets and
* proprietary and confidential information of Dialogic or its suppliers and
* licensors. The Material is protected by worldwide copyright and trade secret
* laws and treaty provisions. No part of the Material may be used, copied,
* reproduced, modified, published, uploaded, posted, transmitted, distributed,
* or disclosed in any way without Dialogic's prior express written permission.
*
* No license under any patent, copyright, trade secret or other intellectual
* property right is granted to or conferred upon you by disclosure or delivery
* of the Materials, either expressly, by implication, inducement, estoppel or
* otherwise. Any license under such intellectual property rights must be
* express and approved by Dialogic in writing.
*
***********************************@@@SOFT@@@WARE@@@COPY@@@RIGHT@@@**********/
#ifndef PORT_CONNECT_H_
#define PORT_CONNECT_H_

#if defined(_MSC_VER)
#if _MSC_VER > 1000
#pragma once
#endif // _MSC_VER > 1000
#endif // _MSC_VER

#include <devmgmt.h>

#pragma pack(push, 8)

/**
 * DM_PORT_MEDIA_TYPE
 */
typedef enum DM_PORT_MEDIA_TYPE
{
	DM_PORT_MEDIA_TYPE_NONE = 0
	
	, DM_PORT_MEDIA_TYPE_AUDIO = 1
	, DM_PORT_MEDIA_TYPE_VIDEO = 2
    , DM_PORT_MEDIA_TYPE_H223 = 3
    , DM_PORT_MEDIA_TYPE_NBUP = 3 /* Deprecated - use DM_PORT_MEDIA_TYPE_H223 */
	
	// Internal Port Media Types
	, DM_PORT_MEDIA_TYPE_AUDIO_NATIVE = 128
	, DM_PORT_MEDIA_TYPE_VIDEO_NATIVE
	, DM_PORT_MEDIA_TYPE_AUDIO_LINEAR
	, DM_PORT_MEDIA_TYPE_VIDEO_LINEAR
} DM_PORT_MEDIA_TYPE;

/**
 * Device ID
 */
typedef unsigned char DM_DEVICE_ID[16];
typedef DM_DEVICE_ID* PDM_DEVICE_ID;
static DM_DEVICE_ID const DM_DEVICE_ID_NULL = "";
static __inline void INIT_DM_DEVICE_ID(PDM_DEVICE_ID pdevice_id) {
	*pdevice_id[0] = '\0';
}

/**
 * Port ID
 */
typedef unsigned char DM_PORT_ID[16];
typedef DM_PORT_ID* PDM_PORT_ID;
static DM_PORT_ID const DM_PORT_ID_NULL = "";
static __inline void INIT_DM_PORT_ID(PDM_PORT_ID pport_id) {
	*pport_id[0] = '\0';
}

/**
 * DM_PORT_INFO
 */
typedef struct DM_PORT_INFO
{
	unsigned int            unVersion;
	DM_DEVICE_ID            device_ID;
	DM_PORT_ID              port_ID;
	DM_PORT_MEDIA_TYPE      port_media_type;
} DM_PORT_INFO, *PDM_PORT_INFO;
typedef const DM_PORT_INFO* CPDM_PORT_INFO;

#define DM_PORT_INFO_VER(v) (sizeof(DM_PORT_INFO) << 16 | (0xFFFF & (v)))
#define DM_PORT_INFO_VERSION_0 DM_PORT_INFO_VER(0)
#define DM_PORT_INFO_VERSION DM_PORT_INFO_VERSION_0

static __inline void INIT_DM_PORT_INFO(PDM_PORT_INFO pStruct) {
	pStruct->unVersion              = DM_PORT_INFO_VERSION;
	INIT_DM_DEVICE_ID(&pStruct->device_ID);
	INIT_DM_PORT_ID(&pStruct->port_ID);
	pStruct->port_media_type = DM_PORT_MEDIA_TYPE_NONE;
}

/**
 * Maximum number of device ports
 */
#define MAX_DM_PORT_INFO 16

/**
 * DM_PORT_INFO_LIST
 */
typedef struct DM_PORT_INFO_LIST
{
	unsigned int            unVersion;
	unsigned int            unCount;
	DM_PORT_INFO            port_info[MAX_DM_PORT_INFO];
} DM_PORT_INFO_LIST, *PDM_PORT_INFO_LIST;
typedef const DM_PORT_INFO_LIST* CPDM_PORT_INFO_LIST;

#define DM_PORT_INFO_LIST_VER(v) (sizeof(DM_PORT_INFO_LIST) << 16 | (0xFFFF & (v)))
#define DM_PORT_INFO_LIST_VERSION_0 DM_PORT_INFO_LIST_VER(0)
#define DM_PORT_INFO_LIST_VERSION DM_PORT_INFO_LIST_VERSION_0

static __inline void INIT_DM_PORT_INFO_LIST(PDM_PORT_INFO_LIST pStruct) {
	pStruct->unVersion              = DM_PORT_INFO_LIST_VERSION;
	pStruct->unCount = 0;
}

/**
 * Connection Flags
 */
#define DMFL_TRANSCODE_MASK     0x0003  /* transcode mask */
#define DMFL_TRANSCODE_ON       0x0000  /* default transcode */
#define DMFL_TRANSCODE_NATIVE   0x0001  /* native (no transcode) */

/**
 * DM_PORT_CONNECT_INFO
 */
typedef struct PORT_CONNECT_INFO
{
	unsigned int            unVersion;
	unsigned int            unFlags;
	DM_PORT_INFO            port_info_tx;
	DM_PORT_INFO            port_info_rx;
} DM_PORT_CONNECT_INFO, *PDM_PORT_CONNECT_INFO;
typedef const DM_PORT_CONNECT_INFO* CPDM_PORT_CONNECT_INFO;

#define DM_PORT_CONNECT_INFO_VER(v) (sizeof(DM_PORT_CONNECT_INFO) << 16 | (0xFFFF & (v)))
#define DM_PORT_CONNECT_INFO_VERSION_0 DM_PORT_CONNECT_INFO_VER(0)
#define DM_PORT_CONNECT_INFO_VERSION DM_PORT_CONNECT_INFO_VERSION_0

static __inline void INIT_DM_PORT_CONNECT_INFO(PDM_PORT_CONNECT_INFO pStruct) {
	pStruct->unVersion              = DM_PORT_CONNECT_INFO_VERSION;
	pStruct->unFlags = DMFL_TRANSCODE_ON;
	INIT_DM_PORT_INFO(&pStruct->port_info_tx);
	INIT_DM_PORT_INFO(&pStruct->port_info_rx);
}

/**
 * DM_PORT_CONNECT_INFO_LIST
 */
typedef struct DM_PORT_CONNECT_INFO_LIST
{
	unsigned int            unVersion;
	unsigned int            unCount;
	DM_PORT_CONNECT_INFO    port_connect_info[MAX_DM_PORT_INFO];
} DM_PORT_CONNECT_INFO_LIST, *PDM_PORT_CONNECT_INFO_LIST;
typedef const DM_PORT_CONNECT_INFO_LIST* CPDM_PORT_CONNECT_INFO_LIST;

#define DM_PORT_CONNECT_INFO_LIST_VER(v) (sizeof(DM_PORT_CONNECT_INFO_LIST) << 16 | (0xFFFF & (v)))
#define DM_PORT_CONNECT_INFO_LIST_VERSION_0 DM_PORT_CONNECT_INFO_LIST_VER(0)
#define DM_PORT_CONNECT_INFO_LIST_VERSION DM_PORT_CONNECT_INFO_LIST_VERSION_0

static __inline void INIT_DM_PORT_CONNECT_INFO_LIST(PDM_PORT_CONNECT_INFO_LIST pStruct) {
	pStruct->unVersion              = DM_PORT_CONNECT_INFO_LIST_VERSION;
	pStruct->unCount = 0;
}

/**
 * DM_CONNECT_STATUS
 */
typedef enum DM_CONNECT_STATUS
{
	DM_STAT_UNKNOWN = 0,
	DM_STAT_CONNECT = 1,
	DM_STAT_CONNECT_FAIL = 2,
	DM_STAT_DISCONNECT = 3,
	DM_STAT_DISCONNECT_FAIL = 4
} DM_CONNECT_STATUS;

/**
 * DM_CONNECT_STATUS_LIST
 */
typedef struct DM_CONNECT_STATUS_LIST
{
	unsigned int            unVersion;
	unsigned int            unCount;
	DM_CONNECT_STATUS       connect_status[MAX_DM_PORT_INFO];
} DM_CONNECT_STATUS_LIST, *PDM_CONNECT_STATUS_LIST;
typedef DM_CONNECT_STATUS_LIST* CPDM_CONNECT_STATUS_LIST;

#define DM_CONNECT_STATUS_LIST_VER(v) (sizeof(DM_CONNECT_STATUS_LIST) << 16 | (0xFFFF & (v)))
#define DM_CONNECT_STATUS_LIST_VERSION_0 DM_CONNECT_STATUS_LIST_VER(0)
#define DM_CONNECT_STATUS_LIST_VERSION DM_CONNECT_STATUS_LIST_VERSION_0

static __inline void INIT_DM_CONNECT_STATUS_LIST(PDM_CONNECT_STATUS_LIST pStruct) {
	pStruct->unVersion              = DM_CONNECT_STATUS_LIST_VERSION;
	pStruct->unCount = 0;
}

#pragma pack(pop)

#ifdef __cplusplus
extern "C" {
#endif

//--------------------------------------------------------------------------------------------------
/** @name Port Connect functions */
//@{

/**
 * Retrieves transmit ports information associated with the specified device
 * Generates DMEV_GET_TX_PORT_INFO event with transmit ports details
 * or DMEV_GET_TX_PORT_INFO_FAIL in case of failure.
 * @param devHandle handle of the device
 * @param pUserContext ptr to user-specific context associated with the transaction.
 * @return 0 if successful, -1 if error.
 */
DEVMGMTLIB_API int DEVMGMT_CONV
dev_GetTransmitPortInfo(int devHandle, void* pUserContext);

/**
 * Retrieves receive ports information associated with the specified device
 * Generates DMEV_GET_RX_PORT_INFO event with receive ports details
 * or DMEV_GET_RX_PORT_INFO_FAIL in case of failure.
 * @param devHandle handle of the device
 * @param pUserContext ptr to user-specific context associated with the transaction.
 * @return 0 if successful, -1 if error.
 */
DEVMGMTLIB_API int DEVMGMT_CONV
dev_GetReceivePortInfo(int devHandle, void* pUserContext);

/**
 * Creates connections between one or more transmit ports of the specified device
 * and receive ports of another device
 * Generates DMEV_PORT_CONNECT event upon successful completion
 * or DMEV_PORT_CONNECT_FAIL in case of failure.
 * @param devHandle handle of the device
 * @param pConnectList ptr to the list of connection structures
 * @param pUserContext ptr to user-specific context associated with the transaction.
 * @return 0 if successful, -1 if error.
 */
DEVMGMTLIB_API int DEVMGMT_CONV
dev_PortConnect(int devHandle, CPDM_PORT_CONNECT_INFO_LIST pConnectList, void* pUserContext);

/**
 * Severs connections between one or more transmit ports of the specified device
 * and receive ports of another device
 * Generates DMEV_PORT_DISCONNECT event upon successful completion
 * or DMEV_PORT_DISCONNECT_FAIL in case of failure.
 * @param devHandle handle of the device
 * @param pConnectList ptr to the list of connection structures
 * @param pUserContext ptr to user-specific context associated with the transaction.
 * @return 0 if successful, -1 if error.
 */
DEVMGMTLIB_API int DEVMGMT_CONV
dev_PortDisconnect(int devHandle, CPDM_PORT_CONNECT_INFO_LIST pConnectList, void* pUserContext);

//@}

#ifdef __cplusplus
}
#endif

/**
 * Events
 */
#define DMEV_GET_TX_PORT_INFO                  (DMEV_MASK | 0x21)
#define DMEV_GET_TX_PORT_INFO_FAIL             (DMEV_MASK | 0x22)
#define DMEV_GET_RX_PORT_INFO                  (DMEV_MASK | 0x23)
#define DMEV_GET_RX_PORT_INFO_FAIL             (DMEV_MASK | 0x24)
#define DMEV_PORT_CONNECT                      (DMEV_MASK | 0x25)
#define DMEV_PORT_CONNECT_FAIL                 (DMEV_MASK | 0x26)
#define DMEV_PORT_DISCONNECT                   (DMEV_MASK | 0x27)
#define DMEV_PORT_DISCONNECT_FAIL              (DMEV_MASK | 0x28)

#endif /*PORT_CONNECT_H_*/
