/****************************************************************************
 *		Copyright (c) 1995 Intel Corporation
 *		All Rights Reserved.
 *
 *		THIS IS UNPUBLISHED PROPRIETARY SOURCE CODE OF Intel Corporation
 *		The copyright notice above does not evidence any actual or
 *		intended publication of such source code.
 ***************************************************************************/

/****************************************************************************
 * FILE:         qaccess.h
 * AUTHOR:       Gerry Lachac
 * ORG:          Intel Corporation
 * ORIG-DATE:    26-Apr-95 at 10:43:25
 * LAST-MOD:      1-Jul-97 at 14:54:46 by Gerry Lachac
 * PURPOSE:
 *    Protoypes for Mercury Platform Access functions
 *
 * HISTORY:
 * Date			   Who	Description
 * 26-Apr-95		CC 	Initial Creation.
 ***************************************************************************/

#ifndef __QACCESS_H__
#define __QACCESS_H__

#include "qtypes.h"
#include "qcomplib.h"
#include "qmsg.h"


/* Interface configuration */
typedef enum {QINTER_DRIVER,QINTER_VXSIM,QINTER_ETHERNET,QINTER_TEST}
QInterfaceType;

/* Mode options */
#define  QFLAG_ASYNC 1
#define  QFLAG_SYNC  2


/* Specific about the interface */
typedef struct  {
   char           name[80];   /* Name or IP address of board, driver */
   UInt32         socket;     /* Socket number to use in RADM mode   */
} QInterfaceParams;




/* Function Prototypes */
#ifdef __cplusplus
extern "C"{
#endif
QHandle qQueueOpen (void );
QStatus qQueueClose (QHandle );
QStatus qQueueBind (QHandle , QCompDesc * );
QStatus qQueueUnbind (QHandle , QCompDesc  );
QStatus qQueueUnbindQuiet (QHandle , QCompDesc  );
QStatus qDrvSetInterface (QInterfaceType, QInterfaceParams *);
QStatus qDrvProtStart (QHandle,QTrans,QCompDesc,Int16);
QStatus qDrvVersionString (QHandle , char *  );
QStatus qSetExitNotify(QHandle, UInt32, QCompDesc, UInt32);
 
#ifdef __cplusplus
}
#endif

#endif







